/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothAudioConfig;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothA2dpSink;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothA2dpSink
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothA2dpSink";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp-sink.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.a2dp-sink.profile.action.PLAYING_STATE_CHANGED";
    public static int STATE_PLAYING = 10;
    public static int STATE_NOT_PLAYING = 11;
    public static String ACTION_AUDIO_CONFIG_CHANGED = "android.bluetooth.a2dp-sink.profile.action.AUDIO_CONFIG_CHANGED";
    public static String EXTRA_AUDIO_CONFIG = "android.bluetooth.a2dp-sink.profile.extra.AUDIO_CONFIG";
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private IBluetoothA2dpSink mService;
    private BluetoothAdapter mAdapter;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothA2dpSink$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothA2dpSink this$0;

            private void $$robo$$android_bluetooth_BluetoothA2dpSink_1$__constructor__(BluetoothA2dpSink this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothA2dpSink_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothA2dpSink", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothA2dpSink", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothA2dpSink", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothA2dpSink bluetoothA2dpSink) {
                this.$$robo$$android_bluetooth_BluetoothA2dpSink_1$__constructor__(bluetoothA2dpSink);
            }
            {
                this.this$0 = bluetoothA2dpSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothA2dpSink_1$__constructor__(android.bluetooth.BluetoothA2dpSink ), 0, this, bluetoothA2dpSink);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothA2dpSink_1$onBluetoothStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothA2dpSink this$0;

            private void $$robo$$android_bluetooth_BluetoothA2dpSink_2$__constructor__(BluetoothA2dpSink this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothA2dpSink_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d("BluetoothA2dpSink", "Proxy object connected");
                this.this$0.mService = IBluetoothA2dpSink.Stub.asInterface(Binder.allowBlocking(service));
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(11, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothA2dpSink_2$onServiceDisconnected(ComponentName className) {
                Log.d("BluetoothA2dpSink", "Proxy object disconnected");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(11);
                }
            }

            private void __constructor__(BluetoothA2dpSink bluetoothA2dpSink) {
                this.$$robo$$android_bluetooth_BluetoothA2dpSink_2$__constructor__(bluetoothA2dpSink);
            }
            {
                this.this$0 = bluetoothA2dpSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothA2dpSink_2$__constructor__(android.bluetooth.BluetoothA2dpSink ), 0, this, bluetoothA2dpSink);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothA2dpSink_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothA2dpSink_2$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dpSink$doBind() {
        Intent intent = new Intent(IBluetoothA2dpSink.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e("BluetoothA2dpSink", "Could not bind to Bluetooth A2DP Service with " + intent);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothA2dpSink$close() {
        this.mServiceListener = null;
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothA2dpSink", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothA2dpSink", "", re);
                }
            }
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothA2dpSink$finalize() {
        this.close();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dpSink$connect(BluetoothDevice device) {
        BluetoothA2dpSink.log("connect(" + device + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.connect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothA2dpSink", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dpSink$disconnect(BluetoothDevice device) {
        BluetoothA2dpSink.log("disconnect(" + device + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothA2dpSink", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothA2dpSink$getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothA2dpSink", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothA2dpSink$getDevicesMatchingConnectionStates(int[] states) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothA2dpSink", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothA2dpSink$getConnectionState(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothA2dpSink", "Proxy not attached to service");
        }
        return 0;
    }

    private final BluetoothAudioConfig $$robo$$android_bluetooth_BluetoothA2dpSink$getAudioConfig(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getAudioConfig(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "Stack:" + Log.getStackTraceString(new Throwable()));
                return null;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothA2dpSink", "Proxy not attached to service");
        }
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dpSink$setPriority(BluetoothDevice device, int priority) {
        BluetoothA2dpSink.log("setPriority(" + device + ", " + priority + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return this.mService.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothA2dpSink", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothA2dpSink$getPriority(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothA2dpSink", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dpSink$isA2dpPlaying(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.isA2dpPlaying(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dpSink", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothA2dpSink", "Proxy not attached to service");
        }
        return false;
    }

    private static final String $$robo$$android_bluetooth_BluetoothA2dpSink$stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 10: {
                return "playing";
            }
            case 11: {
                return "not playing";
            }
        }
        return "<unknown state " + state + ">";
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dpSink$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dpSink$isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static final void $$robo$$android_bluetooth_BluetoothA2dpSink$log(String msg) {
        Log.d("BluetoothA2dpSink", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothA2dpSink$__constructor__(context, serviceListener);
    }

    BluetoothA2dpSink(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothA2dpSink$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), 0, this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothA2dpSink$doBind(), 0, this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothA2dpSink$close(), 0, this);
    }

    public void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothA2dpSink$finalize(), 0, this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothA2dpSink$connect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothA2dpSink$disconnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothA2dpSink$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothA2dpSink$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothA2dpSink$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public BluetoothAudioConfig getAudioConfig(BluetoothDevice bluetoothDevice) {
        return InvokeDynamicSupport.bootstrap("getAudioConfig", $$robo$$android_bluetooth_BluetoothA2dpSink$getAudioConfig(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothA2dpSink$setPriority(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothA2dpSink$getPriority(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean isA2dpPlaying(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isA2dpPlaying", $$robo$$android_bluetooth_BluetoothA2dpSink$isA2dpPlaying(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public static String stateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_bluetooth_BluetoothA2dpSink$stateToString(int ), 0, (int)n);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothA2dpSink$isEnabled(), 0, this);
    }

    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidDevice", $$robo$$android_bluetooth_BluetoothA2dpSink$isValidDevice(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothA2dpSink$log(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ BluetoothA2dpSink() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothA2dpSink)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

