/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.app.ActivityThread;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.IScannerCallback;
import android.bluetooth.le.ResultStorageDescriptor;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.bluetooth.le.TruncatedFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothLeScanner
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothLeScanner";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String EXTRA_LIST_SCAN_RESULT = "android.bluetooth.le.extra.LIST_SCAN_RESULT";
    public static String EXTRA_ERROR_CODE = "android.bluetooth.le.extra.ERROR_CODE";
    public static String EXTRA_CALLBACK_TYPE = "android.bluetooth.le.extra.CALLBACK_TYPE";
    private IBluetoothManager mBluetoothManager;
    private Handler mHandler;
    private BluetoothAdapter mBluetoothAdapter;
    private Map<ScanCallback, BleScanCallbackWrapper> mLeScanClients;

    private void $$robo$$android_bluetooth_le_BluetoothLeScanner$__constructor__(IBluetoothManager bluetoothManager) {
        this.mBluetoothManager = bluetoothManager;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mLeScanClients = new HashMap<ScanCallback, BleScanCallbackWrapper>();
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$startScan(ScanCallback callback) {
        this.startScan(null, new ScanSettings.Builder().build(), callback);
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$startScan(List<ScanFilter> filters, ScanSettings settings, ScanCallback callback) {
        this.startScan(filters, settings, null, callback, null, null);
    }

    private final int $$robo$$android_bluetooth_le_BluetoothLeScanner$startScan(List<ScanFilter> filters, ScanSettings settings, PendingIntent callbackIntent) {
        return this.startScan(filters, settings != null ? settings : new ScanSettings.Builder().build(), null, null, callbackIntent, null);
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$startScanFromSource(WorkSource workSource, ScanCallback callback) {
        this.startScanFromSource(null, new ScanSettings.Builder().build(), workSource, callback);
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$startScanFromSource(List<ScanFilter> filters, ScanSettings settings, WorkSource workSource, ScanCallback callback) {
        this.startScan(filters, settings, workSource, callback, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_le_BluetoothLeScanner$startScan(List<ScanFilter> filters, ScanSettings settings, WorkSource workSource, ScanCallback callback, PendingIntent callbackIntent, List<List<ResultStorageDescriptor>> resultStorages) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        if (callback == null && callbackIntent == null) {
            throw new IllegalArgumentException("callback is null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings is null");
        }
        Map<ScanCallback, BleScanCallbackWrapper> map = this.mLeScanClients;
        synchronized (map) {
            IBluetoothGatt gatt;
            if (callback != null && this.mLeScanClients.containsKey(callback)) {
                this.postCallbackError(callback, 1);
            }
            try {
                gatt = this.mBluetoothManager.getBluetoothGatt();
            }
            catch (RemoteException e) {
                gatt = null;
            }
            if (gatt == null) {
                return this.postCallbackErrorOrReturn(callback, 3);
            }
            if (!this.isSettingsConfigAllowedForScan(settings)) {
                return this.postCallbackErrorOrReturn(callback, 4);
            }
            if (!this.isHardwareResourcesAvailableForScan(settings)) {
                return this.postCallbackErrorOrReturn(callback, 5);
            }
            if (!this.isSettingsAndFilterComboAllowed(settings, filters)) {
                return this.postCallbackErrorOrReturn(callback, 4);
            }
            if (callback != null) {
                BleScanCallbackWrapper wrapper = new BleScanCallbackWrapper(this, gatt, filters, settings, workSource, callback, resultStorages);
                wrapper.startRegistration();
            } else {
                try {
                    gatt.startScanForIntent(callbackIntent, settings, filters, ActivityThread.currentOpPackageName());
                }
                catch (RemoteException e) {
                    return 3;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$stopScan(ScanCallback callback) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        Map<ScanCallback, BleScanCallbackWrapper> map = this.mLeScanClients;
        synchronized (map) {
            BleScanCallbackWrapper wrapper = this.mLeScanClients.remove(callback);
            if (wrapper == null) {
                Log.d("BluetoothLeScanner", "could not find callback wrapper");
                return;
            }
            wrapper.stopLeScan();
        }
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$stopScan(PendingIntent callbackIntent) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        try {
            IBluetoothGatt gatt = this.mBluetoothManager.getBluetoothGatt();
            gatt.stopScanForIntent(callbackIntent, ActivityThread.currentOpPackageName());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$flushPendingScanResults(ScanCallback callback) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null!");
        }
        Map<ScanCallback, BleScanCallbackWrapper> map = this.mLeScanClients;
        synchronized (map) {
            BleScanCallbackWrapper wrapper = this.mLeScanClients.get(callback);
            if (wrapper == null) {
                return;
            }
            wrapper.flushPendingBatchResults();
        }
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$startTruncatedScan(List<TruncatedFilter> truncatedFilters, ScanSettings settings, ScanCallback callback) {
        int filterSize = truncatedFilters.size();
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>(filterSize);
        ArrayList<List<ResultStorageDescriptor>> scanStorages = new ArrayList<List<ResultStorageDescriptor>>(filterSize);
        for (TruncatedFilter filter : truncatedFilters) {
            scanFilters.add(filter.getFilter());
            scanStorages.add(filter.getStorageDescriptors());
        }
        this.startScan(scanFilters, settings, null, callback, null, scanStorages);
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$cleanup() {
        this.mLeScanClients.clear();
    }

    private final int $$robo$$android_bluetooth_le_BluetoothLeScanner$postCallbackErrorOrReturn(ScanCallback callback, int errorCode) {
        if (callback == null) {
            return errorCode;
        }
        this.postCallbackError(callback, errorCode);
        return 0;
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeScanner$postCallbackError(ScanCallback callback, int errorCode) {
        this.mHandler.post(new Runnable(this, callback, errorCode){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ScanCallback val$callback;
            /* synthetic */ int val$errorCode;
            /* synthetic */ BluetoothLeScanner this$0;

            private void $$robo$$android_bluetooth_le_BluetoothLeScanner_1$__constructor__(BluetoothLeScanner this$0, ScanCallback scanCallback, int n) {
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_1$run() {
                this.val$callback.onScanFailed(this.val$errorCode);
            }

            private void __constructor__(BluetoothLeScanner bluetoothLeScanner, ScanCallback scanCallback, int n) {
                this.$$robo$$android_bluetooth_le_BluetoothLeScanner_1$__constructor__(bluetoothLeScanner, scanCallback, n);
            }
            {
                this.this$0 = bluetoothLeScanner;
                this.val$callback = scanCallback;
                this.val$errorCode = n;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeScanner_1$__constructor__(android.bluetooth.le.BluetoothLeScanner android.bluetooth.le.ScanCallback int ), 0, this, bluetoothLeScanner, scanCallback, n);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeScanner_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final boolean $$robo$$android_bluetooth_le_BluetoothLeScanner$isSettingsConfigAllowedForScan(ScanSettings settings) {
        if (this.mBluetoothAdapter.isOffloadedFilteringSupported()) {
            return true;
        }
        int callbackType = settings.getCallbackType();
        return callbackType == 1 && settings.getReportDelayMillis() == 0L;
    }

    private final boolean $$robo$$android_bluetooth_le_BluetoothLeScanner$isSettingsAndFilterComboAllowed(ScanSettings settings, List<ScanFilter> filterList) {
        int callbackType = settings.getCallbackType();
        if ((callbackType & 6) != 0) {
            if (filterList == null) {
                return false;
            }
            for (ScanFilter filter : filterList) {
                if (!filter.isAllFieldsEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_le_BluetoothLeScanner$isHardwareResourcesAvailableForScan(ScanSettings settings) {
        int callbackType = settings.getCallbackType();
        if ((callbackType & 2) != 0 || (callbackType & 4) != 0) {
            return this.mBluetoothAdapter.isOffloadedFilteringSupported() && this.mBluetoothAdapter.isHardwareTrackingFiltersAvailable();
        }
        return true;
    }

    private void __constructor__(IBluetoothManager iBluetoothManager) {
        this.$$robo$$android_bluetooth_le_BluetoothLeScanner$__constructor__(iBluetoothManager);
    }

    public BluetoothLeScanner(IBluetoothManager iBluetoothManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeScanner$__constructor__(android.bluetooth.IBluetoothManager ), 0, this, iBluetoothManager);
    }

    public void startScan(ScanCallback scanCallback) {
        InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_bluetooth_le_BluetoothLeScanner$startScan(android.bluetooth.le.ScanCallback ), 0, this, scanCallback);
    }

    public void startScan(List<ScanFilter> list, ScanSettings scanSettings, ScanCallback scanCallback) {
        InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_bluetooth_le_BluetoothLeScanner$startScan(java.util.List<android.bluetooth.le.ScanFilter> android.bluetooth.le.ScanSettings android.bluetooth.le.ScanCallback ), 0, this, list, scanSettings, scanCallback);
    }

    public int startScan(List<ScanFilter> list, ScanSettings scanSettings, PendingIntent pendingIntent) {
        return (int)InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_bluetooth_le_BluetoothLeScanner$startScan(java.util.List<android.bluetooth.le.ScanFilter> android.bluetooth.le.ScanSettings android.app.PendingIntent ), 0, this, list, scanSettings, pendingIntent);
    }

    public void startScanFromSource(WorkSource workSource, ScanCallback scanCallback) {
        InvokeDynamicSupport.bootstrap("startScanFromSource", $$robo$$android_bluetooth_le_BluetoothLeScanner$startScanFromSource(android.os.WorkSource android.bluetooth.le.ScanCallback ), 0, this, workSource, scanCallback);
    }

    public void startScanFromSource(List<ScanFilter> list, ScanSettings scanSettings, WorkSource workSource, ScanCallback scanCallback) {
        InvokeDynamicSupport.bootstrap("startScanFromSource", $$robo$$android_bluetooth_le_BluetoothLeScanner$startScanFromSource(java.util.List<android.bluetooth.le.ScanFilter> android.bluetooth.le.ScanSettings android.os.WorkSource android.bluetooth.le.ScanCallback ), 0, this, list, scanSettings, workSource, scanCallback);
    }

    private int startScan(List<ScanFilter> list, ScanSettings scanSettings, WorkSource workSource, ScanCallback scanCallback, PendingIntent pendingIntent, List<List<ResultStorageDescriptor>> list2) {
        return (int)InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_bluetooth_le_BluetoothLeScanner$startScan(java.util.List<android.bluetooth.le.ScanFilter> android.bluetooth.le.ScanSettings android.os.WorkSource android.bluetooth.le.ScanCallback android.app.PendingIntent java.util.List<java.util.List<android.bluetooth.le.ResultStorageDescriptor>> ), 0, this, list, scanSettings, workSource, scanCallback, pendingIntent, list2);
    }

    public void stopScan(ScanCallback scanCallback) {
        InvokeDynamicSupport.bootstrap("stopScan", $$robo$$android_bluetooth_le_BluetoothLeScanner$stopScan(android.bluetooth.le.ScanCallback ), 0, this, scanCallback);
    }

    public void stopScan(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("stopScan", $$robo$$android_bluetooth_le_BluetoothLeScanner$stopScan(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void flushPendingScanResults(ScanCallback scanCallback) {
        InvokeDynamicSupport.bootstrap("flushPendingScanResults", $$robo$$android_bluetooth_le_BluetoothLeScanner$flushPendingScanResults(android.bluetooth.le.ScanCallback ), 0, this, scanCallback);
    }

    public void startTruncatedScan(List<TruncatedFilter> list, ScanSettings scanSettings, ScanCallback scanCallback) {
        InvokeDynamicSupport.bootstrap("startTruncatedScan", $$robo$$android_bluetooth_le_BluetoothLeScanner$startTruncatedScan(java.util.List<android.bluetooth.le.TruncatedFilter> android.bluetooth.le.ScanSettings android.bluetooth.le.ScanCallback ), 0, this, list, scanSettings, scanCallback);
    }

    public void cleanup() {
        InvokeDynamicSupport.bootstrap("cleanup", $$robo$$android_bluetooth_le_BluetoothLeScanner$cleanup(), 0, this);
    }

    private int postCallbackErrorOrReturn(ScanCallback scanCallback, int n) {
        return (int)InvokeDynamicSupport.bootstrap("postCallbackErrorOrReturn", $$robo$$android_bluetooth_le_BluetoothLeScanner$postCallbackErrorOrReturn(android.bluetooth.le.ScanCallback int ), 0, this, scanCallback, n);
    }

    private void postCallbackError(ScanCallback scanCallback, int n) {
        InvokeDynamicSupport.bootstrap("postCallbackError", $$robo$$android_bluetooth_le_BluetoothLeScanner$postCallbackError(android.bluetooth.le.ScanCallback int ), 0, this, scanCallback, n);
    }

    private boolean isSettingsConfigAllowedForScan(ScanSettings scanSettings) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSettingsConfigAllowedForScan", $$robo$$android_bluetooth_le_BluetoothLeScanner$isSettingsConfigAllowedForScan(android.bluetooth.le.ScanSettings ), 0, this, scanSettings);
    }

    private boolean isSettingsAndFilterComboAllowed(ScanSettings scanSettings, List<ScanFilter> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSettingsAndFilterComboAllowed", $$robo$$android_bluetooth_le_BluetoothLeScanner$isSettingsAndFilterComboAllowed(android.bluetooth.le.ScanSettings java.util.List<android.bluetooth.le.ScanFilter> ), 0, this, scanSettings, list);
    }

    private boolean isHardwareResourcesAvailableForScan(ScanSettings scanSettings) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareResourcesAvailableForScan", $$robo$$android_bluetooth_le_BluetoothLeScanner$isHardwareResourcesAvailableForScan(android.bluetooth.le.ScanSettings ), 0, this, scanSettings);
    }

    public /* synthetic */ BluetoothLeScanner() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothLeScanner)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class BleScanCallbackWrapper
    extends IScannerCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int REGISTRATION_CALLBACK_TIMEOUT_MILLIS = 2000;
        private ScanCallback mScanCallback;
        private List<ScanFilter> mFilters;
        private WorkSource mWorkSource;
        private ScanSettings mSettings;
        private IBluetoothGatt mBluetoothGatt;
        private List<List<ResultStorageDescriptor>> mResultStorages;
        private int mScannerId;
        /* synthetic */ BluetoothLeScanner this$0;

        private void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$__constructor__(BluetoothLeScanner bluetoothLeScanner, IBluetoothGatt bluetoothGatt, List<ScanFilter> filters, ScanSettings settings, WorkSource workSource, ScanCallback scanCallback, List<List<ResultStorageDescriptor>> resultStorages) {
            this.mBluetoothGatt = bluetoothGatt;
            this.mFilters = filters;
            this.mSettings = settings;
            this.mWorkSource = workSource;
            this.mScanCallback = scanCallback;
            this.mScannerId = 0;
            this.mResultStorages = resultStorages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$startRegistration() {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId == -1) {
                    return;
                }
                try {
                    this.mBluetoothGatt.registerScanner(this, this.mWorkSource);
                    this.wait(2000L);
                }
                catch (RemoteException | InterruptedException e) {
                    Log.e("BluetoothLeScanner", "application registeration exception", e);
                    this.this$0.postCallbackError(this.mScanCallback, 3);
                }
                if (this.mScannerId > 0) {
                    this.this$0.mLeScanClients.put(this.mScanCallback, this);
                } else {
                    if (this.mScannerId == 0) {
                        this.mScannerId = -1;
                    }
                    this.this$0.postCallbackError(this.mScanCallback, 2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$stopLeScan() {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    Log.e("BluetoothLeScanner", "Error state, mLeHandle: " + this.mScannerId);
                    return;
                }
                try {
                    this.mBluetoothGatt.stopScan(this.mScannerId);
                    this.mBluetoothGatt.unregisterScanner(this.mScannerId);
                }
                catch (RemoteException e) {
                    Log.e("BluetoothLeScanner", "Failed to stop scan and unregister", e);
                }
                this.mScannerId = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$flushPendingBatchResults() {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    Log.e("BluetoothLeScanner", "Error state, mLeHandle: " + this.mScannerId);
                    return;
                }
                try {
                    this.mBluetoothGatt.flushPendingBatchResults(this.mScannerId);
                }
                catch (RemoteException e) {
                    Log.e("BluetoothLeScanner", "Failed to get pending scan results", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onScannerRegistered(int status, int scannerId) {
            Log.d("BluetoothLeScanner", "onScannerRegistered() - status=" + status + " scannerId=" + scannerId + " mScannerId=" + this.mScannerId);
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                block8: {
                    if (status == 0) {
                        try {
                            if (this.mScannerId == -1) {
                                this.mBluetoothGatt.unregisterClient(scannerId);
                                break block8;
                            }
                            this.mScannerId = scannerId;
                            this.mBluetoothGatt.startScan(this.mScannerId, this.mSettings, this.mFilters, this.mResultStorages, ActivityThread.currentOpPackageName());
                        }
                        catch (RemoteException e) {
                            Log.e("BluetoothLeScanner", "fail to start le scan: " + e);
                            this.mScannerId = -1;
                        }
                    } else {
                        this.mScannerId = -1;
                    }
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onScanResult(ScanResult scanResult) {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    return;
                }
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(this, scanResult){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ScanResult val$scanResult;
                /* synthetic */ BleScanCallbackWrapper this$1;

                private void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_1$__constructor__(BleScanCallbackWrapper this$1, ScanResult scanResult) {
                }

                private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_1$run() {
                    this.this$1.mScanCallback.onScanResult(1, this.val$scanResult);
                }

                private void __constructor__(BleScanCallbackWrapper bleScanCallbackWrapper, ScanResult scanResult) {
                    this.$$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_1$__constructor__(bleScanCallbackWrapper, scanResult);
                }
                {
                    this.this$1 = bleScanCallbackWrapper;
                    this.val$scanResult = scanResult;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_1$__constructor__(android.bluetooth.le.BluetoothLeScanner$BleScanCallbackWrapper android.bluetooth.le.ScanResult ), 0, this, bleScanCallbackWrapper, scanResult);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onBatchScanResults(List<ScanResult> results) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(this, results){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ List val$results;
                /* synthetic */ BleScanCallbackWrapper this$1;

                private void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_2$__constructor__(BleScanCallbackWrapper this$1, List list) {
                }

                private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_2$run() {
                    this.this$1.mScanCallback.onBatchScanResults(this.val$results);
                }

                private void __constructor__(BleScanCallbackWrapper bleScanCallbackWrapper, List list) {
                    this.$$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_2$__constructor__(bleScanCallbackWrapper, list);
                }
                {
                    this.this$1 = bleScanCallbackWrapper;
                    this.val$results = list;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_2$__constructor__(android.bluetooth.le.BluetoothLeScanner$BleScanCallbackWrapper java.util.List ), 0, this, bleScanCallbackWrapper, list);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onFoundOrLost(boolean onFound, ScanResult scanResult) {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    return;
                }
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(this, onFound, scanResult){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ boolean val$onFound;
                /* synthetic */ ScanResult val$scanResult;
                /* synthetic */ BleScanCallbackWrapper this$1;

                private void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_3$__constructor__(BleScanCallbackWrapper this$1, boolean bl, ScanResult scanResult) {
                }

                private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_3$run() {
                    if (this.val$onFound) {
                        this.this$1.mScanCallback.onScanResult(2, this.val$scanResult);
                    } else {
                        this.this$1.mScanCallback.onScanResult(4, this.val$scanResult);
                    }
                }

                private void __constructor__(BleScanCallbackWrapper bleScanCallbackWrapper, boolean bl, ScanResult scanResult) {
                    this.$$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_3$__constructor__(bleScanCallbackWrapper, bl, scanResult);
                }
                {
                    this.this$1 = bleScanCallbackWrapper;
                    this.val$onFound = bl;
                    this.val$scanResult = scanResult;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_3$__constructor__(android.bluetooth.le.BluetoothLeScanner$BleScanCallbackWrapper boolean android.bluetooth.le.ScanResult ), 0, this, bleScanCallbackWrapper, bl, scanResult);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onScanManagerErrorCallback(int errorCode) {
            BleScanCallbackWrapper bleScanCallbackWrapper = this;
            synchronized (bleScanCallbackWrapper) {
                if (this.mScannerId <= 0) {
                    return;
                }
            }
            this.this$0.postCallbackError(this.mScanCallback, errorCode);
        }

        private void __constructor__(BluetoothLeScanner bluetoothLeScanner, IBluetoothGatt iBluetoothGatt, List<ScanFilter> list, ScanSettings scanSettings, WorkSource workSource, ScanCallback scanCallback, List<List<ResultStorageDescriptor>> list2) {
            this.$$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$__constructor__(bluetoothLeScanner, iBluetoothGatt, list, scanSettings, workSource, scanCallback, list2);
        }

        public BleScanCallbackWrapper(BluetoothLeScanner bluetoothLeScanner, IBluetoothGatt iBluetoothGatt, List<ScanFilter> list, ScanSettings scanSettings, WorkSource workSource, ScanCallback scanCallback, List<List<ResultStorageDescriptor>> list2) {
            this.this$0 = bluetoothLeScanner;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$__constructor__(android.bluetooth.le.BluetoothLeScanner android.bluetooth.IBluetoothGatt java.util.List<android.bluetooth.le.ScanFilter> android.bluetooth.le.ScanSettings android.os.WorkSource android.bluetooth.le.ScanCallback java.util.List<java.util.List<android.bluetooth.le.ResultStorageDescriptor>> ), 0, this, bluetoothLeScanner, iBluetoothGatt, list, scanSettings, workSource, scanCallback, list2);
        }

        public void startRegistration() {
            InvokeDynamicSupport.bootstrap("startRegistration", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$startRegistration(), 0, this);
        }

        public void stopLeScan() {
            InvokeDynamicSupport.bootstrap("stopLeScan", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$stopLeScan(), 0, this);
        }

        void flushPendingBatchResults() {
            InvokeDynamicSupport.bootstrap("flushPendingBatchResults", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$flushPendingBatchResults(), 0, this);
        }

        @Override
        public void onScannerRegistered(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onScannerRegistered", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onScannerRegistered(int int ), 0, this, n, n2);
        }

        @Override
        public void onScanResult(ScanResult scanResult) {
            InvokeDynamicSupport.bootstrap("onScanResult", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onScanResult(android.bluetooth.le.ScanResult ), 0, this, scanResult);
        }

        @Override
        public void onBatchScanResults(List<ScanResult> list) {
            InvokeDynamicSupport.bootstrap("onBatchScanResults", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onBatchScanResults(java.util.List<android.bluetooth.le.ScanResult> ), 0, this, list);
        }

        @Override
        public void onFoundOrLost(boolean bl, ScanResult scanResult) {
            InvokeDynamicSupport.bootstrap("onFoundOrLost", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onFoundOrLost(boolean android.bluetooth.le.ScanResult ), 0, this, bl, scanResult);
        }

        @Override
        public void onScanManagerErrorCallback(int n) {
            InvokeDynamicSupport.bootstrap("onScanManagerErrorCallback", $$robo$$android_bluetooth_le_BluetoothLeScanner_BleScanCallbackWrapper$onScanManagerErrorCallback(int ), 0, this, n);
        }

        public /* synthetic */ BleScanCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BleScanCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

