/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.IPeriodicAdvertisingCallback;
import android.bluetooth.le.PeriodicAdvertisingCallback;
import android.bluetooth.le.PeriodicAdvertisingReport;
import android.bluetooth.le.ScanResult;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.IdentityHashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PeriodicAdvertisingManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PeriodicAdvertisingManager";
    private static int SKIP_MIN = 0;
    private static int SKIP_MAX = 499;
    private static int TIMEOUT_MIN = 10;
    private static int TIMEOUT_MAX = 16384;
    private static int SYNC_STARTING = -1;
    private IBluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    Map<PeriodicAdvertisingCallback, IPeriodicAdvertisingCallback> callbackWrappers;

    private void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$__constructor__(IBluetoothManager bluetoothManager) {
        this.mBluetoothManager = bluetoothManager;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.callbackWrappers = new IdentityHashMap<PeriodicAdvertisingCallback, IPeriodicAdvertisingCallback>();
    }

    private final void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$registerSync(ScanResult scanResult, int skip, int timeout, PeriodicAdvertisingCallback callback) {
        this.registerSync(scanResult, skip, timeout, callback, null);
    }

    private final void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$registerSync(ScanResult scanResult, int skip, int timeout, PeriodicAdvertisingCallback callback, Handler handler) {
        IBluetoothGatt gatt;
        if (callback == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        if (scanResult == null) {
            throw new IllegalArgumentException("scanResult can't be null");
        }
        if (scanResult.getAdvertisingSid() == 255) {
            throw new IllegalArgumentException("scanResult must contain a valid sid");
        }
        if (skip < 0 || skip > 499) {
            throw new IllegalArgumentException("timeout must be between 10 and 16384");
        }
        if (timeout < 10 || timeout > 16384) {
            throw new IllegalArgumentException("timeout must be between 10 and 16384");
        }
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e("PeriodicAdvertisingManager", "Failed to get Bluetooth gatt - ", e);
            callback.onSyncEstablished(0, scanResult.getDevice(), scanResult.getAdvertisingSid(), skip, timeout, 2);
            return;
        }
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        IPeriodicAdvertisingCallback wrapped = this.wrap(callback, handler);
        this.callbackWrappers.put(callback, wrapped);
        try {
            gatt.registerSync(scanResult, skip, timeout, wrapped);
        }
        catch (RemoteException e) {
            Log.e("PeriodicAdvertisingManager", "Failed to register sync - ", e);
            return;
        }
    }

    private final void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$unregisterSync(PeriodicAdvertisingCallback callback) {
        IBluetoothGatt gatt;
        if (callback == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e("PeriodicAdvertisingManager", "Failed to get Bluetooth gatt - ", e);
            return;
        }
        IPeriodicAdvertisingCallback wrapper = this.callbackWrappers.remove(callback);
        if (wrapper == null) {
            throw new IllegalArgumentException("callback was not properly registered");
        }
        try {
            gatt.unregisterSync(wrapper);
        }
        catch (RemoteException e) {
            Log.e("PeriodicAdvertisingManager", "Failed to cancel sync creation - ", e);
            return;
        }
    }

    private final IPeriodicAdvertisingCallback $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$wrap(PeriodicAdvertisingCallback callback, Handler handler) {
        return new ShadowedObject(this, handler, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Handler val$handler;
            /* synthetic */ PeriodicAdvertisingCallback val$callback;
            /* synthetic */ PeriodicAdvertisingManager this$0;

            private void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1$__constructor__(PeriodicAdvertisingManager this$0, Handler handler, PeriodicAdvertisingCallback periodicAdvertisingCallback) {
            }

            private final void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1$onSyncEstablished(int syncHandle, BluetoothDevice device, int advertisingSid, int skip, int timeout, int status) {
                this.val$handler.post(new Runnable(this, syncHandle, device, advertisingSid, skip, timeout, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$syncHandle;
                    /* synthetic */ BluetoothDevice val$device;
                    /* synthetic */ int val$advertisingSid;
                    /* synthetic */ int val$skip;
                    /* synthetic */ int val$timeout;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_1$__constructor__(1 this$1, int n, BluetoothDevice bluetoothDevice, int n2, int n3, int n4, int n5) {
                    }

                    private final void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_1$run() {
                        this.this$1.val$callback.onSyncEstablished(this.val$syncHandle, this.val$device, this.val$advertisingSid, this.val$skip, this.val$timeout, this.val$status);
                        if (this.val$status != 0) {
                            this.this$1.this$0.callbackWrappers.remove(this.this$1.val$callback);
                        }
                    }

                    private void __constructor__(1 var1_1, int n, BluetoothDevice bluetoothDevice, int n2, int n3, int n4, int n5) {
                        this.$$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_1$__constructor__(var1_1, n, bluetoothDevice, n2, n3, n4, n5);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$syncHandle = n;
                        this.val$device = bluetoothDevice;
                        this.val$advertisingSid = n2;
                        this.val$skip = n3;
                        this.val$timeout = n4;
                        this.val$status = n5;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_1$__constructor__(android.bluetooth.le.PeriodicAdvertisingManager$1 int android.bluetooth.BluetoothDevice int int int int ), 0, this, var1_1, n, bluetoothDevice, n2, n3, n4, n5);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1$onPeriodicAdvertisingReport(PeriodicAdvertisingReport report) {
                this.val$handler.post(new Runnable(this, report){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ PeriodicAdvertisingReport val$report;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_2$__constructor__(1 this$1, PeriodicAdvertisingReport periodicAdvertisingReport) {
                    }

                    private final void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_2$run() {
                        this.this$1.val$callback.onPeriodicAdvertisingReport(this.val$report);
                    }

                    private void __constructor__(1 var1_1, PeriodicAdvertisingReport periodicAdvertisingReport) {
                        this.$$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_2$__constructor__(var1_1, periodicAdvertisingReport);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$report = periodicAdvertisingReport;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_2$__constructor__(android.bluetooth.le.PeriodicAdvertisingManager$1 android.bluetooth.le.PeriodicAdvertisingReport ), 0, this, var1_1, periodicAdvertisingReport);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1$onSyncLost(int syncHandle) {
                this.val$handler.post(new Runnable(this, syncHandle){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$syncHandle;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_3$__constructor__(1 this$1, int n) {
                    }

                    private final void $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_3$run() {
                        this.this$1.val$callback.onSyncLost(this.val$syncHandle);
                        this.this$1.this$0.callbackWrappers.remove(this.this$1.val$callback);
                    }

                    private void __constructor__(1 var1_1, int n) {
                        this.$$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_3$__constructor__(var1_1, n);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$syncHandle = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_3$__constructor__(android.bluetooth.le.PeriodicAdvertisingManager$1 int ), 0, this, var1_1, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1_3$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private void __constructor__(PeriodicAdvertisingManager periodicAdvertisingManager, Handler handler, PeriodicAdvertisingCallback periodicAdvertisingCallback) {
                this.$$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1$__constructor__(periodicAdvertisingManager, handler, periodicAdvertisingCallback);
            }
            {
                this.this$0 = periodicAdvertisingManager;
                this.val$handler = handler;
                this.val$callback = periodicAdvertisingCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1$__constructor__(android.bluetooth.le.PeriodicAdvertisingManager android.os.Handler android.bluetooth.le.PeriodicAdvertisingCallback ), 0, this, periodicAdvertisingManager, handler, periodicAdvertisingCallback);
            }

            @Override
            public void onSyncEstablished(int n, BluetoothDevice bluetoothDevice, int n2, int n3, int n4, int n5) {
                InvokeDynamicSupport.bootstrap("onSyncEstablished", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1$onSyncEstablished(int android.bluetooth.BluetoothDevice int int int int ), 0, this, n, bluetoothDevice, n2, n3, n4, n5);
            }

            @Override
            public void onPeriodicAdvertisingReport(PeriodicAdvertisingReport periodicAdvertisingReport) {
                InvokeDynamicSupport.bootstrap("onPeriodicAdvertisingReport", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1$onPeriodicAdvertisingReport(android.bluetooth.le.PeriodicAdvertisingReport ), 0, this, periodicAdvertisingReport);
            }

            @Override
            public void onSyncLost(int n) {
                InvokeDynamicSupport.bootstrap("onSyncLost", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager_1$onSyncLost(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(IBluetoothManager iBluetoothManager) {
        this.$$robo$$android_bluetooth_le_PeriodicAdvertisingManager$__constructor__(iBluetoothManager);
    }

    public PeriodicAdvertisingManager(IBluetoothManager iBluetoothManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$__constructor__(android.bluetooth.IBluetoothManager ), 0, this, iBluetoothManager);
    }

    public void registerSync(ScanResult scanResult, int n, int n2, PeriodicAdvertisingCallback periodicAdvertisingCallback) {
        InvokeDynamicSupport.bootstrap("registerSync", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$registerSync(android.bluetooth.le.ScanResult int int android.bluetooth.le.PeriodicAdvertisingCallback ), 0, this, scanResult, n, n2, periodicAdvertisingCallback);
    }

    public void registerSync(ScanResult scanResult, int n, int n2, PeriodicAdvertisingCallback periodicAdvertisingCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerSync", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$registerSync(android.bluetooth.le.ScanResult int int android.bluetooth.le.PeriodicAdvertisingCallback android.os.Handler ), 0, this, scanResult, n, n2, periodicAdvertisingCallback, handler);
    }

    public void unregisterSync(PeriodicAdvertisingCallback periodicAdvertisingCallback) {
        InvokeDynamicSupport.bootstrap("unregisterSync", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$unregisterSync(android.bluetooth.le.PeriodicAdvertisingCallback ), 0, this, periodicAdvertisingCallback);
    }

    private IPeriodicAdvertisingCallback wrap(PeriodicAdvertisingCallback periodicAdvertisingCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("wrap", $$robo$$android_bluetooth_le_PeriodicAdvertisingManager$wrap(android.bluetooth.le.PeriodicAdvertisingCallback android.os.Handler ), 0, this, periodicAdvertisingCallback, handler);
    }

    public /* synthetic */ PeriodicAdvertisingManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PeriodicAdvertisingManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

