/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SyncStatusInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int VERSION = 2;
    public int authorityId;
    public long totalElapsedTime;
    public int numSyncs;
    public int numSourcePoll;
    public int numSourceServer;
    public int numSourceLocal;
    public int numSourceUser;
    public int numSourcePeriodic;
    public long lastSuccessTime;
    public int lastSuccessSource;
    public long lastFailureTime;
    public int lastFailureSource;
    public String lastFailureMesg;
    public long initialFailureTime;
    public boolean pending;
    public boolean initialize;
    private ArrayList<Long> periodicSyncTimes;
    private static String TAG = "Sync";
    public static Parcelable.Creator<SyncStatusInfo> CREATOR;

    private void $$robo$$android_content_SyncStatusInfo$__constructor__(int authorityId) {
        this.authorityId = authorityId;
    }

    private final int $$robo$$android_content_SyncStatusInfo$getLastFailureMesgAsInt(int def) {
        int i = ContentResolver.syncErrorStringToInt(this.lastFailureMesg);
        if (i > 0) {
            return i;
        }
        Log.d("Sync", "Unknown lastFailureMesg:" + this.lastFailureMesg);
        return def;
    }

    private final int $$robo$$android_content_SyncStatusInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_SyncStatusInfo$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(2);
        parcel.writeInt(this.authorityId);
        parcel.writeLong(this.totalElapsedTime);
        parcel.writeInt(this.numSyncs);
        parcel.writeInt(this.numSourcePoll);
        parcel.writeInt(this.numSourceServer);
        parcel.writeInt(this.numSourceLocal);
        parcel.writeInt(this.numSourceUser);
        parcel.writeLong(this.lastSuccessTime);
        parcel.writeInt(this.lastSuccessSource);
        parcel.writeLong(this.lastFailureTime);
        parcel.writeInt(this.lastFailureSource);
        parcel.writeString(this.lastFailureMesg);
        parcel.writeLong(this.initialFailureTime);
        parcel.writeInt(this.pending ? 1 : 0);
        parcel.writeInt(this.initialize ? 1 : 0);
        if (this.periodicSyncTimes != null) {
            parcel.writeInt(this.periodicSyncTimes.size());
            for (long periodicSyncTime : this.periodicSyncTimes) {
                parcel.writeLong(periodicSyncTime);
            }
        } else {
            parcel.writeInt(-1);
        }
    }

    private void $$robo$$android_content_SyncStatusInfo$__constructor__(Parcel parcel) {
        int version = parcel.readInt();
        if (version != 2 && version != 1) {
            Log.w("SyncStatusInfo", "Unknown version: " + version);
        }
        this.authorityId = parcel.readInt();
        this.totalElapsedTime = parcel.readLong();
        this.numSyncs = parcel.readInt();
        this.numSourcePoll = parcel.readInt();
        this.numSourceServer = parcel.readInt();
        this.numSourceLocal = parcel.readInt();
        this.numSourceUser = parcel.readInt();
        this.lastSuccessTime = parcel.readLong();
        this.lastSuccessSource = parcel.readInt();
        this.lastFailureTime = parcel.readLong();
        this.lastFailureSource = parcel.readInt();
        this.lastFailureMesg = parcel.readString();
        this.initialFailureTime = parcel.readLong();
        this.pending = parcel.readInt() != 0;
        boolean bl = this.initialize = parcel.readInt() != 0;
        if (version == 1) {
            this.periodicSyncTimes = null;
        } else {
            int N = parcel.readInt();
            if (N < 0) {
                this.periodicSyncTimes = null;
            } else {
                this.periodicSyncTimes = new ArrayList();
                for (int i = 0; i < N; ++i) {
                    this.periodicSyncTimes.add(parcel.readLong());
                }
            }
        }
    }

    private void $$robo$$android_content_SyncStatusInfo$__constructor__(SyncStatusInfo other) {
        this.authorityId = other.authorityId;
        this.totalElapsedTime = other.totalElapsedTime;
        this.numSyncs = other.numSyncs;
        this.numSourcePoll = other.numSourcePoll;
        this.numSourceServer = other.numSourceServer;
        this.numSourceLocal = other.numSourceLocal;
        this.numSourceUser = other.numSourceUser;
        this.numSourcePeriodic = other.numSourcePeriodic;
        this.lastSuccessTime = other.lastSuccessTime;
        this.lastSuccessSource = other.lastSuccessSource;
        this.lastFailureTime = other.lastFailureTime;
        this.lastFailureSource = other.lastFailureSource;
        this.lastFailureMesg = other.lastFailureMesg;
        this.initialFailureTime = other.initialFailureTime;
        this.pending = other.pending;
        this.initialize = other.initialize;
        if (other.periodicSyncTimes != null) {
            this.periodicSyncTimes = new ArrayList<Long>(other.periodicSyncTimes);
        }
    }

    private final void $$robo$$android_content_SyncStatusInfo$setPeriodicSyncTime(int index, long when) {
        this.ensurePeriodicSyncTimeSize(index);
        this.periodicSyncTimes.set(index, when);
    }

    private final long $$robo$$android_content_SyncStatusInfo$getPeriodicSyncTime(int index) {
        if (this.periodicSyncTimes != null && index < this.periodicSyncTimes.size()) {
            return this.periodicSyncTimes.get(index);
        }
        return 0L;
    }

    private final void $$robo$$android_content_SyncStatusInfo$removePeriodicSyncTime(int index) {
        if (this.periodicSyncTimes != null && index < this.periodicSyncTimes.size()) {
            this.periodicSyncTimes.remove(index);
        }
    }

    private final void $$robo$$android_content_SyncStatusInfo$ensurePeriodicSyncTimeSize(int index) {
        if (this.periodicSyncTimes == null) {
            this.periodicSyncTimes = new ArrayList(0);
        }
        int requiredSize = index + 1;
        if (this.periodicSyncTimes.size() < requiredSize) {
            for (int i = this.periodicSyncTimes.size(); i < requiredSize; ++i) {
                this.periodicSyncTimes.add(0L);
            }
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<SyncStatusInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_SyncStatusInfo_1$__constructor__() {
            }

            private final SyncStatusInfo $$robo$$android_content_SyncStatusInfo_1$createFromParcel(Parcel in) {
                return new SyncStatusInfo(in);
            }

            private final SyncStatusInfo[] $$robo$$android_content_SyncStatusInfo_1$newArray(int size) {
                return new SyncStatusInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_SyncStatusInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncStatusInfo_1$__constructor__(), 0, this);
            }

            @Override
            public SyncStatusInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_SyncStatusInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public SyncStatusInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_SyncStatusInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n) {
        this.$$robo$$android_content_SyncStatusInfo$__constructor__(n);
    }

    public SyncStatusInfo(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncStatusInfo$__constructor__(int ), 0, this, n);
    }

    public int getLastFailureMesgAsInt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLastFailureMesgAsInt", $$robo$$android_content_SyncStatusInfo$getLastFailureMesgAsInt(int ), 0, this, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_SyncStatusInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_SyncStatusInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_SyncStatusInfo$__constructor__(parcel);
    }

    public SyncStatusInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncStatusInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private void __constructor__(SyncStatusInfo syncStatusInfo) {
        this.$$robo$$android_content_SyncStatusInfo$__constructor__(syncStatusInfo);
    }

    public SyncStatusInfo(SyncStatusInfo syncStatusInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncStatusInfo$__constructor__(android.content.SyncStatusInfo ), 0, this, syncStatusInfo);
    }

    public void setPeriodicSyncTime(int n, long l) {
        InvokeDynamicSupport.bootstrap("setPeriodicSyncTime", $$robo$$android_content_SyncStatusInfo$setPeriodicSyncTime(int long ), 0, this, n, l);
    }

    public long getPeriodicSyncTime(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPeriodicSyncTime", $$robo$$android_content_SyncStatusInfo$getPeriodicSyncTime(int ), 0, this, n);
    }

    public void removePeriodicSyncTime(int n) {
        InvokeDynamicSupport.bootstrap("removePeriodicSyncTime", $$robo$$android_content_SyncStatusInfo$removePeriodicSyncTime(int ), 0, this, n);
    }

    private void ensurePeriodicSyncTimeSize(int n) {
        InvokeDynamicSupport.bootstrap("ensurePeriodicSyncTimeSize", $$robo$$android_content_SyncStatusInfo$ensurePeriodicSyncTimeSize(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(SyncStatusInfo.class);
    }

    public /* synthetic */ SyncStatusInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncStatusInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

