/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteCustomFunction;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SQLiteDatabaseConfiguration
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Pattern EMAIL_IN_DB_PATTERN;
    public static String MEMORY_DB_PATH = ":memory:";
    public String path;
    public String label;
    public int openFlags;
    public int maxSqlCacheSize;
    public Locale locale;
    public boolean foreignKeyConstraintsEnabled;
    public ArrayList<SQLiteCustomFunction> customFunctions;

    private void $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$__constructor__(String path, int openFlags) {
        this.customFunctions = new ArrayList();
        if (path == null) {
            throw new IllegalArgumentException("path must not be null.");
        }
        this.path = path;
        this.label = SQLiteDatabaseConfiguration.stripPathForLogs(path);
        this.openFlags = openFlags;
        this.maxSqlCacheSize = 25;
        this.locale = Locale.getDefault();
    }

    private void $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$__constructor__(SQLiteDatabaseConfiguration other) {
        this.customFunctions = new ArrayList();
        if (other == null) {
            throw new IllegalArgumentException("other must not be null.");
        }
        this.path = other.path;
        this.label = other.label;
        this.updateParametersFrom(other);
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$updateParametersFrom(SQLiteDatabaseConfiguration other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null.");
        }
        if (!this.path.equals(other.path)) {
            throw new IllegalArgumentException("other configuration must refer to the same database.");
        }
        this.openFlags = other.openFlags;
        this.maxSqlCacheSize = other.maxSqlCacheSize;
        this.locale = other.locale;
        this.foreignKeyConstraintsEnabled = other.foreignKeyConstraintsEnabled;
        this.customFunctions.clear();
        this.customFunctions.addAll(other.customFunctions);
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$isInMemoryDb() {
        return this.path.equalsIgnoreCase(":memory:");
    }

    private static final String $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$stripPathForLogs(String path) {
        if (path.indexOf(64) == -1) {
            return path;
        }
        return EMAIL_IN_DB_PATTERN.matcher(path).replaceAll("XX@YY");
    }

    static void __staticInitializer__() {
        EMAIL_IN_DB_PATTERN = Pattern.compile("[\\w\\.\\-]+@[\\w\\.\\-]+");
    }

    private void __constructor__(String string2, int n) {
        this.$$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$__constructor__(string2, n);
    }

    public SQLiteDatabaseConfiguration(String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    private void __constructor__(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        this.$$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$__constructor__(sQLiteDatabaseConfiguration);
    }

    public SQLiteDatabaseConfiguration(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$__constructor__(android.database.sqlite.SQLiteDatabaseConfiguration ), 0, this, sQLiteDatabaseConfiguration);
    }

    public void updateParametersFrom(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        InvokeDynamicSupport.bootstrap("updateParametersFrom", $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$updateParametersFrom(android.database.sqlite.SQLiteDatabaseConfiguration ), 0, this, sQLiteDatabaseConfiguration);
    }

    public boolean isInMemoryDb() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInMemoryDb", $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$isInMemoryDb(), 0, this);
    }

    private static String stripPathForLogs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("stripPathForLogs", $$robo$$android_database_sqlite_SQLiteDatabaseConfiguration$stripPathForLogs(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(SQLiteDatabaseConfiguration.class);
    }

    public /* synthetic */ SQLiteDatabaseConfiguration() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteDatabaseConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

