/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.OutputPort;
import android.filterfw.core.StreamPort;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FilterFunction
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Filter mFilter;
    private FilterContext mFilterContext;
    private boolean mFilterIsSetup;
    private FrameHolderPort[] mResultHolders;

    private void $$robo$$android_filterfw_core_FilterFunction$__constructor__(FilterContext context, Filter filter) {
        this.mFilterIsSetup = false;
        this.mFilterContext = context;
        this.mFilter = filter;
    }

    private final Frame $$robo$$android_filterfw_core_FilterFunction$execute(KeyValueMap inputMap) {
        int filterOutCount = this.mFilter.getNumberOfOutputs();
        if (filterOutCount > 1) {
            throw new RuntimeException("Calling execute on filter " + this.mFilter + " with multiple outputs! Use executeMulti() instead!");
        }
        if (!this.mFilterIsSetup) {
            this.connectFilterOutputs();
            this.mFilterIsSetup = true;
        }
        boolean didActivateGLEnv = false;
        GLEnvironment glEnv = this.mFilterContext.getGLEnvironment();
        if (glEnv != null && !glEnv.isActive()) {
            glEnv.activate();
            didActivateGLEnv = true;
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            if (entry.getValue() instanceof Frame) {
                this.mFilter.pushInputFrame((String)entry.getKey(), (Frame)entry.getValue());
                continue;
            }
            this.mFilter.pushInputValue((String)entry.getKey(), entry.getValue());
        }
        if (this.mFilter.getStatus() != 3) {
            this.mFilter.openOutputs();
        }
        this.mFilter.performProcess(this.mFilterContext);
        Frame result = null;
        if (filterOutCount == 1 && this.mResultHolders[0].hasFrame()) {
            result = this.mResultHolders[0].pullFrame();
        }
        if (didActivateGLEnv) {
            glEnv.deactivate();
        }
        return result;
    }

    private final Frame $$robo$$android_filterfw_core_FilterFunction$executeWithArgList(Object ... inputs) {
        return this.execute(KeyValueMap.fromKeyValues(inputs));
    }

    private final void $$robo$$android_filterfw_core_FilterFunction$close() {
        this.mFilter.performClose(this.mFilterContext);
    }

    private final FilterContext $$robo$$android_filterfw_core_FilterFunction$getContext() {
        return this.mFilterContext;
    }

    private final Filter $$robo$$android_filterfw_core_FilterFunction$getFilter() {
        return this.mFilter;
    }

    private final void $$robo$$android_filterfw_core_FilterFunction$setInputFrame(String input, Frame frame) {
        this.mFilter.setInputFrame(input, frame);
    }

    private final void $$robo$$android_filterfw_core_FilterFunction$setInputValue(String input, Object value) {
        this.mFilter.setInputValue(input, value);
    }

    private final void $$robo$$android_filterfw_core_FilterFunction$tearDown() {
        this.mFilter.performTearDown(this.mFilterContext);
        this.mFilter = null;
    }

    private final String $$robo$$android_filterfw_core_FilterFunction$toString() {
        return this.mFilter.getName();
    }

    private final void $$robo$$android_filterfw_core_FilterFunction$connectFilterOutputs() {
        int i = 0;
        this.mResultHolders = new FrameHolderPort[this.mFilter.getNumberOfOutputs()];
        for (OutputPort outputPort : this.mFilter.getOutputPorts()) {
            this.mResultHolders[i] = new FrameHolderPort(this);
            outputPort.connectTo(this.mResultHolders[i]);
            ++i;
        }
    }

    private void __constructor__(FilterContext filterContext, Filter filter) {
        this.$$robo$$android_filterfw_core_FilterFunction$__constructor__(filterContext, filter);
    }

    public FilterFunction(FilterContext filterContext, Filter filter) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_FilterFunction$__constructor__(android.filterfw.core.FilterContext android.filterfw.core.Filter ), 0, this, filterContext, filter);
    }

    public Frame execute(KeyValueMap keyValueMap) {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$android_filterfw_core_FilterFunction$execute(android.filterfw.core.KeyValueMap ), 0, this, keyValueMap);
    }

    public Frame executeWithArgList(Object ... objectArray) {
        return InvokeDynamicSupport.bootstrap("executeWithArgList", $$robo$$android_filterfw_core_FilterFunction$executeWithArgList(java.lang.Object[] ), 0, this, objectArray);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterfw_core_FilterFunction$close(), 0, this);
    }

    public FilterContext getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_filterfw_core_FilterFunction$getContext(), 0, this);
    }

    public Filter getFilter() {
        return InvokeDynamicSupport.bootstrap("getFilter", $$robo$$android_filterfw_core_FilterFunction$getFilter(), 0, this);
    }

    public void setInputFrame(String string2, Frame frame) {
        InvokeDynamicSupport.bootstrap("setInputFrame", $$robo$$android_filterfw_core_FilterFunction$setInputFrame(java.lang.String android.filterfw.core.Frame ), 0, this, string2, frame);
    }

    public void setInputValue(String string2, Object object) {
        InvokeDynamicSupport.bootstrap("setInputValue", $$robo$$android_filterfw_core_FilterFunction$setInputValue(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    public void tearDown() {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterfw_core_FilterFunction$tearDown(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_filterfw_core_FilterFunction$toString(), 0, this);
    }

    private void connectFilterOutputs() {
        InvokeDynamicSupport.bootstrap("connectFilterOutputs", $$robo$$android_filterfw_core_FilterFunction$connectFilterOutputs(), 0, this);
    }

    public /* synthetic */ FilterFunction() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FilterFunction)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class FrameHolderPort
    extends StreamPort
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ FilterFunction this$0;

        private void $$robo$$android_filterfw_core_FilterFunction_FrameHolderPort$__constructor__(FilterFunction filterFunction) {
        }

        private void __constructor__(FilterFunction filterFunction) {
            this.$$robo$$android_filterfw_core_FilterFunction_FrameHolderPort$__constructor__(filterFunction);
        }

        public FrameHolderPort(FilterFunction filterFunction) {
            this.this$0 = filterFunction;
            super(null, "holder");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_FilterFunction_FrameHolderPort$__constructor__(android.filterfw.core.FilterFunction ), 0, this, filterFunction);
        }

        public /* synthetic */ FrameHolderPort() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameHolderPort)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

