/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FisheyeFilter
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FisheyeFilter";
    @GenerateFieldPort(name="scale", hasDefault=true)
    private float mScale;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize;
    private Program mProgram;
    private int mWidth;
    private int mHeight;
    private int mTarget;
    private static String mFisheyeShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform vec2 scale;\nuniform float alpha;\nuniform float radius2;\nuniform float factor;\nvarying vec2 v_texcoord;\nvoid main() {\n  const float m_pi_2 = 1.570963;\n  vec2 coord = v_texcoord - vec2(0.5, 0.5);\n  float dist = length(coord * scale);\n  float radian = m_pi_2 - atan(alpha * sqrt(radius2 - dist * dist), dist);\n  float scalar = radian * factor / dist;\n  vec2 new_coord = coord * scalar + vec2(0.5, 0.5);\n  gl_FragColor = texture2D(tex_sampler_0, new_coord);\n}\n";

    private void $$robo$$android_filterpacks_imageproc_FisheyeFilter$__constructor__(String name) {
        this.mScale = 0.0f;
        this.mTileSize = 640;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mTarget = 0;
    }

    private final void $$robo$$android_filterpacks_imageproc_FisheyeFilter$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_FisheyeFilter$getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    private final void $$robo$$android_filterpacks_imageproc_FisheyeFilter$initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = new ShaderProgram(context, "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform vec2 scale;\nuniform float alpha;\nuniform float radius2;\nuniform float factor;\nvarying vec2 v_texcoord;\nvoid main() {\n  const float m_pi_2 = 1.570963;\n  vec2 coord = v_texcoord - vec2(0.5, 0.5);\n  float dist = length(coord * scale);\n  float radian = m_pi_2 - atan(alpha * sqrt(radius2 - dist * dist), dist);\n  float scalar = radian * factor / dist;\n  vec2 new_coord = coord * scalar + vec2(0.5, 0.5);\n  gl_FragColor = texture2D(tex_sampler_0, new_coord);\n}\n");
                shaderProgram.setMaximumTileSize(this.mTileSize);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter FisheyeFilter does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    private final void $$robo$$android_filterpacks_imageproc_FisheyeFilter$process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        Frame output = context.getFrameManager().newFrame(inputFormat);
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
        }
        if (inputFormat.getWidth() != this.mWidth || inputFormat.getHeight() != this.mHeight) {
            this.updateFrameSize(inputFormat.getWidth(), inputFormat.getHeight());
        }
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    private final void $$robo$$android_filterpacks_imageproc_FisheyeFilter$fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateProgramParams();
        }
    }

    private final void $$robo$$android_filterpacks_imageproc_FisheyeFilter$updateFrameSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.updateProgramParams();
    }

    private final void $$robo$$android_filterpacks_imageproc_FisheyeFilter$updateProgramParams() {
        float pi = (float)Math.PI;
        float[] scale = new float[2];
        if (this.mWidth > this.mHeight) {
            scale[0] = 1.0f;
            scale[1] = (float)this.mHeight / (float)this.mWidth;
        } else {
            scale[0] = (float)this.mWidth / (float)this.mHeight;
            scale[1] = 1.0f;
        }
        float alpha = this.mScale * 2.0f + 0.75f;
        float bound2 = 0.25f * (scale[0] * scale[0] + scale[1] * scale[1]);
        float bound = (float)Math.sqrt(bound2);
        float radius = 1.15f * bound;
        float radius2 = radius * radius;
        float max_radian = 1.5707964f - (float)Math.atan(alpha / bound * (float)Math.sqrt(radius2 - bound2));
        float factor = bound / max_radian;
        this.mProgram.setHostValue("scale", scale);
        this.mProgram.setHostValue("radius2", Float.valueOf(radius2));
        this.mProgram.setHostValue("factor", Float.valueOf(factor));
        this.mProgram.setHostValue("alpha", Float.valueOf(alpha));
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_FisheyeFilter$__constructor__(string2);
    }

    public FisheyeFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_FisheyeFilter$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_FisheyeFilter$setupPorts(), 0, this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_imageproc_FisheyeFilter$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    public void initProgram(FilterContext filterContext, int n) {
        InvokeDynamicSupport.bootstrap("initProgram", $$robo$$android_filterpacks_imageproc_FisheyeFilter$initProgram(android.filterfw.core.FilterContext int ), 0, this, filterContext, n);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_FisheyeFilter$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_imageproc_FisheyeFilter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), 0, this, string2, filterContext);
    }

    private void updateFrameSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateFrameSize", $$robo$$android_filterpacks_imageproc_FisheyeFilter$updateFrameSize(int int ), 0, this, n, n2);
    }

    private void updateProgramParams() {
        InvokeDynamicSupport.bootstrap("updateProgramParams", $$robo$$android_filterpacks_imageproc_FisheyeFilter$updateProgramParams(), 0, this);
    }

    public /* synthetic */ FisheyeFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FisheyeFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

