/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImageSlicer
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="xSlices")
    private int mXSlices;
    @GenerateFieldPort(name="ySlices")
    private int mYSlices;
    @GenerateFieldPort(name="padSize")
    private int mPadSize;
    private int mSliceIndex;
    private Frame mOriginalFrame;
    private Program mProgram;
    private int mInputWidth;
    private int mInputHeight;
    private int mSliceWidth;
    private int mSliceHeight;
    private int mOutputWidth;
    private int mOutputHeight;

    private void $$robo$$android_filterpacks_imageproc_ImageSlicer$__constructor__(String name) {
        this.mSliceIndex = 0;
    }

    private final void $$robo$$android_filterpacks_imageproc_ImageSlicer$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3, 3));
        this.addOutputBasedOnInput("image", "image");
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_ImageSlicer$getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    private final void $$robo$$android_filterpacks_imageproc_ImageSlicer$calcOutputFormatForInput(Frame frame) {
        this.mInputWidth = frame.getFormat().getWidth();
        this.mInputHeight = frame.getFormat().getHeight();
        this.mSliceWidth = (this.mInputWidth + this.mXSlices - 1) / this.mXSlices;
        this.mSliceHeight = (this.mInputHeight + this.mYSlices - 1) / this.mYSlices;
        this.mOutputWidth = this.mSliceWidth + this.mPadSize * 2;
        this.mOutputHeight = this.mSliceHeight + this.mPadSize * 2;
    }

    private final void $$robo$$android_filterpacks_imageproc_ImageSlicer$process(FilterContext context) {
        if (this.mSliceIndex == 0) {
            this.mOriginalFrame = this.pullInput("image");
            this.calcOutputFormatForInput(this.mOriginalFrame);
        }
        FrameFormat inputFormat = this.mOriginalFrame.getFormat();
        MutableFrameFormat outputFormat = inputFormat.mutableCopy();
        outputFormat.setDimensions(this.mOutputWidth, this.mOutputHeight);
        Frame output = context.getFrameManager().newFrame(outputFormat);
        if (this.mProgram == null) {
            this.mProgram = ShaderProgram.createIdentity(context);
        }
        int xSliceIndex = this.mSliceIndex % this.mXSlices;
        int ySliceIndex = this.mSliceIndex / this.mXSlices;
        float x0 = (float)(xSliceIndex * this.mSliceWidth - this.mPadSize) / (float)this.mInputWidth;
        float y0 = (float)(ySliceIndex * this.mSliceHeight - this.mPadSize) / (float)this.mInputHeight;
        ((ShaderProgram)this.mProgram).setSourceRect(x0, y0, (float)this.mOutputWidth / (float)this.mInputWidth, (float)this.mOutputHeight / (float)this.mInputHeight);
        this.mProgram.process(this.mOriginalFrame, output);
        ++this.mSliceIndex;
        if (this.mSliceIndex == this.mXSlices * this.mYSlices) {
            this.mSliceIndex = 0;
            this.mOriginalFrame.release();
            this.setWaitsOnInputPort("image", true);
        } else {
            this.mOriginalFrame.retain();
            this.setWaitsOnInputPort("image", false);
        }
        this.pushOutput("image", output);
        output.release();
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_ImageSlicer$__constructor__(string2);
    }

    public ImageSlicer(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_ImageSlicer$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_ImageSlicer$setupPorts(), 0, this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_imageproc_ImageSlicer$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    private void calcOutputFormatForInput(Frame frame) {
        InvokeDynamicSupport.bootstrap("calcOutputFormatForInput", $$robo$$android_filterpacks_imageproc_ImageSlicer$calcOutputFormatForInput(android.filterfw.core.Frame ), 0, this, frame);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_ImageSlicer$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public /* synthetic */ ImageSlicer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageSlicer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

