/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImageStitcher
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="xSlices")
    private int mXSlices;
    @GenerateFieldPort(name="ySlices")
    private int mYSlices;
    @GenerateFieldPort(name="padSize")
    private int mPadSize;
    private Program mProgram;
    private Frame mOutputFrame;
    private int mInputWidth;
    private int mInputHeight;
    private int mImageWidth;
    private int mImageHeight;
    private int mSliceWidth;
    private int mSliceHeight;
    private int mSliceIndex;

    private void $$robo$$android_filterpacks_imageproc_ImageStitcher$__constructor__(String name) {
        this.mSliceIndex = 0;
    }

    private final void $$robo$$android_filterpacks_imageproc_ImageStitcher$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3, 3));
        this.addOutputBasedOnInput("image", "image");
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_ImageStitcher$getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_ImageStitcher$calcOutputFormatForInput(FrameFormat format) {
        MutableFrameFormat outputFormat = format.mutableCopy();
        this.mInputWidth = format.getWidth();
        this.mInputHeight = format.getHeight();
        this.mSliceWidth = this.mInputWidth - 2 * this.mPadSize;
        this.mSliceHeight = this.mInputHeight - 2 * this.mPadSize;
        this.mImageWidth = this.mSliceWidth * this.mXSlices;
        this.mImageHeight = this.mSliceHeight * this.mYSlices;
        outputFormat.setDimensions(this.mImageWidth, this.mImageHeight);
        return outputFormat;
    }

    private final void $$robo$$android_filterpacks_imageproc_ImageStitcher$process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat format = input.getFormat();
        if (this.mSliceIndex == 0) {
            this.mOutputFrame = context.getFrameManager().newFrame(this.calcOutputFormatForInput(format));
        } else if (format.getWidth() != this.mInputWidth || format.getHeight() != this.mInputHeight) {
            throw new RuntimeException("Image size should not change.");
        }
        if (this.mProgram == null) {
            this.mProgram = ShaderProgram.createIdentity(context);
        }
        float x0 = (float)this.mPadSize / (float)this.mInputWidth;
        float y0 = (float)this.mPadSize / (float)this.mInputHeight;
        int outputOffsetX = this.mSliceIndex % this.mXSlices * this.mSliceWidth;
        int outputOffsetY = this.mSliceIndex / this.mXSlices * this.mSliceHeight;
        float outputWidth = Math.min(this.mSliceWidth, this.mImageWidth - outputOffsetX);
        float outputHeight = Math.min(this.mSliceHeight, this.mImageHeight - outputOffsetY);
        ((ShaderProgram)this.mProgram).setSourceRect(x0, y0, outputWidth / (float)this.mInputWidth, outputHeight / (float)this.mInputHeight);
        ((ShaderProgram)this.mProgram).setTargetRect((float)outputOffsetX / (float)this.mImageWidth, (float)outputOffsetY / (float)this.mImageHeight, outputWidth / (float)this.mImageWidth, outputHeight / (float)this.mImageHeight);
        this.mProgram.process(input, this.mOutputFrame);
        ++this.mSliceIndex;
        if (this.mSliceIndex == this.mXSlices * this.mYSlices) {
            this.pushOutput("image", this.mOutputFrame);
            this.mOutputFrame.release();
            this.mSliceIndex = 0;
        }
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_ImageStitcher$__constructor__(string2);
    }

    public ImageStitcher(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_ImageStitcher$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_ImageStitcher$setupPorts(), 0, this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_imageproc_ImageStitcher$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    private FrameFormat calcOutputFormatForInput(FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("calcOutputFormatForInput", $$robo$$android_filterpacks_imageproc_ImageStitcher$calcOutputFormatForInput(android.filterfw.core.FrameFormat ), 0, this, frameFormat);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_ImageStitcher$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public /* synthetic */ ImageStitcher() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageStitcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

