/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GestureUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Instance
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int SEQUENCE_SAMPLE_SIZE = 16;
    private static int PATCH_SAMPLE_SIZE = 16;
    private static float[] ORIENTATIONS;
    float[] vector;
    String label;
    long id;

    private void $$robo$$android_gesture_Instance$__constructor__(long id2, float[] sample, String sampleName) {
        this.id = id2;
        this.vector = sample;
        this.label = sampleName;
    }

    private final void $$robo$$android_gesture_Instance$normalize() {
        float[] sample = this.vector;
        float sum = 0.0f;
        int size = sample.length;
        for (int i = 0; i < size; ++i) {
            sum += sample[i] * sample[i];
        }
        float magnitude = (float)Math.sqrt(sum);
        int i = 0;
        while (i < size) {
            int n = i++;
            sample[n] = sample[n] / magnitude;
        }
    }

    private static final Instance $$robo$$android_gesture_Instance$createInstance(int sequenceType, int orientationType, Gesture gesture, String label) {
        Instance instance;
        if (sequenceType == 2) {
            float[] pts = Instance.temporalSampler(orientationType, gesture);
            instance = new Instance(gesture.getID(), pts, label);
            instance.normalize();
        } else {
            float[] pts = Instance.spatialSampler(gesture);
            instance = new Instance(gesture.getID(), pts, label);
        }
        return instance;
    }

    private static final float[] $$robo$$android_gesture_Instance$spatialSampler(Gesture gesture) {
        return GestureUtils.spatialSampling(gesture, 16, false);
    }

    private static final float[] $$robo$$android_gesture_Instance$temporalSampler(int orientationType, Gesture gesture) {
        float[] pts = GestureUtils.temporalSampling(gesture.getStrokes().get(0), 16);
        float[] center = GestureUtils.computeCentroid(pts);
        float orientation = (float)Math.atan2(pts[1] - center[1], pts[0] - center[0]);
        float adjustment = -orientation;
        if (orientationType != 1) {
            int count = ORIENTATIONS.length;
            for (int i = 0; i < count; ++i) {
                float delta = ORIENTATIONS[i] - orientation;
                if (!(Math.abs(delta) < Math.abs(adjustment))) continue;
                adjustment = delta;
            }
        }
        GestureUtils.translate(pts, -center[0], -center[1]);
        GestureUtils.rotate(pts, adjustment);
        return pts;
    }

    static void __staticInitializer__() {
        ORIENTATIONS = new float[]{0.0f, 0.7853982f, 1.5707964f, 2.3561945f, (float)Math.PI, 0.0f, -0.7853982f, -1.5707964f, -2.3561945f, (float)(-Math.PI)};
    }

    private void __constructor__(long l, float[] fArray, String string2) {
        this.$$robo$$android_gesture_Instance$__constructor__(l, fArray, string2);
    }

    private Instance(long l, float[] fArray, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_Instance$__constructor__(long float[] java.lang.String ), 0, this, l, fArray, string2);
    }

    private void normalize() {
        InvokeDynamicSupport.bootstrap("normalize", $$robo$$android_gesture_Instance$normalize(), 0, this);
    }

    static Instance createInstance(int n, int n2, Gesture gesture, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createInstance", $$robo$$android_gesture_Instance$createInstance(int int android.gesture.Gesture java.lang.String ), 0, (int)n, (int)n2, (Gesture)gesture, (String)string2);
    }

    private static float[] spatialSampler(Gesture gesture) {
        return InvokeDynamicSupport.bootstrapStatic("spatialSampler", $$robo$$android_gesture_Instance$spatialSampler(android.gesture.Gesture ), 0, (Gesture)gesture);
    }

    private static float[] temporalSampler(int n, Gesture gesture) {
        return InvokeDynamicSupport.bootstrapStatic("temporalSampler", $$robo$$android_gesture_Instance$temporalSampler(int android.gesture.Gesture ), 0, (int)n, (Gesture)gesture);
    }

    static {
        RobolectricInternals.classInitializing(Instance.class);
    }

    public /* synthetic */ Instance() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Instance)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

