/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.fonts.FontVariationAxis;
import android.os.LocaleList;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Paint
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private long mNativePaint;
    private long mNativeShader;
    private long mNativeColorFilter;
    private static long NATIVE_PAINT_SIZE = 98L;
    public long mNativeTypeface;
    private ColorFilter mColorFilter;
    private MaskFilter mMaskFilter;
    private PathEffect mPathEffect;
    private Shader mShader;
    private Typeface mTypeface;
    private Xfermode mXfermode;
    private boolean mHasCompatScaling;
    private float mCompatScaling;
    private float mInvCompatScaling;
    private LocaleList mLocales;
    private String mFontFeatureSettings;
    private String mFontVariationSettings;
    private static Object sCacheLock;
    @GuardedBy(value="sCacheLock")
    private static HashMap<String, Integer> sMinikinLangListIdCache;
    public int mBidiFlags;
    static Style[] sStyleArray;
    static Cap[] sCapArray;
    static Join[] sJoinArray;
    static Align[] sAlignArray;
    public static int ANTI_ALIAS_FLAG = 1;
    public static int FILTER_BITMAP_FLAG = 2;
    public static int DITHER_FLAG = 4;
    public static int UNDERLINE_TEXT_FLAG = 8;
    public static int STRIKE_THRU_TEXT_FLAG = 16;
    public static int FAKE_BOLD_TEXT_FLAG = 32;
    public static int LINEAR_TEXT_FLAG = 64;
    public static int SUBPIXEL_TEXT_FLAG = 128;
    public static int DEV_KERN_TEXT_FLAG = 256;
    public static int LCD_RENDER_TEXT_FLAG = 512;
    public static int EMBEDDED_BITMAP_TEXT_FLAG = 1024;
    public static int AUTO_HINTING_TEXT_FLAG = 2048;
    public static int VERTICAL_TEXT_FLAG = 4096;
    static int HIDDEN_DEFAULT_PAINT_FLAGS = 1280;
    public static int HINTING_OFF = 0;
    public static int HINTING_ON = 1;
    public static int BIDI_LTR = 0;
    public static int BIDI_RTL = 1;
    public static int BIDI_DEFAULT_LTR = 2;
    public static int BIDI_DEFAULT_RTL = 3;
    public static int BIDI_FORCE_LTR = 4;
    public static int BIDI_FORCE_RTL = 5;
    private static int BIDI_MAX_FLAG_VALUE = 5;
    private static int BIDI_FLAG_MASK = 7;
    public static int DIRECTION_LTR = 0;
    public static int DIRECTION_RTL = 1;
    public static int CURSOR_AFTER = 0;
    public static int CURSOR_AT_OR_AFTER = 1;
    public static int CURSOR_BEFORE = 2;
    public static int CURSOR_AT_OR_BEFORE = 3;
    public static int CURSOR_AT = 4;
    private static int CURSOR_OPT_MAX_VALUE = 4;
    public static int HYPHENEDIT_MASK_END_OF_LINE = 7;
    public static int HYPHENEDIT_MASK_START_OF_LINE = 24;

    private void $$robo$$android_graphics_Paint$__constructor__() {
    }

    private void $$robo$$android_graphics_Paint$__constructor__(int flags) {
        this.mBidiFlags = 2;
        this.mNativePaint = Paint.nInit();
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativePaint);
        this.setFlags(flags | 0x500);
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
        this.setTextLocales(LocaleList.getAdjustedDefault());
    }

    private void $$robo$$android_graphics_Paint$__constructor__(Paint paint) {
        this.mBidiFlags = 2;
        this.mNativePaint = Paint.nInitWithPaint(paint.getNativeInstance());
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativePaint);
        this.setClassVariablesFrom(paint);
    }

    private final void $$robo$$android_graphics_Paint$reset() {
        Paint.nReset(this.mNativePaint);
        this.setFlags(1280);
        this.mColorFilter = null;
        this.mMaskFilter = null;
        this.mPathEffect = null;
        this.mShader = null;
        this.mNativeShader = 0L;
        this.mTypeface = null;
        this.mNativeTypeface = 0L;
        this.mXfermode = null;
        this.mHasCompatScaling = false;
        this.mCompatScaling = 1.0f;
        this.mInvCompatScaling = 1.0f;
        this.mBidiFlags = 2;
        this.setTextLocales(LocaleList.getAdjustedDefault());
        this.setElegantTextHeight(false);
        this.mFontFeatureSettings = null;
        this.mFontVariationSettings = null;
    }

    private final void $$robo$$android_graphics_Paint$set(Paint src) {
        if (this != src) {
            Paint.nSet(this.mNativePaint, src.mNativePaint);
            this.setClassVariablesFrom(src);
        }
    }

    private final void $$robo$$android_graphics_Paint$setClassVariablesFrom(Paint paint) {
        this.mColorFilter = paint.mColorFilter;
        this.mMaskFilter = paint.mMaskFilter;
        this.mPathEffect = paint.mPathEffect;
        this.mShader = paint.mShader;
        this.mNativeShader = paint.mNativeShader;
        this.mTypeface = paint.mTypeface;
        this.mNativeTypeface = paint.mNativeTypeface;
        this.mXfermode = paint.mXfermode;
        this.mHasCompatScaling = paint.mHasCompatScaling;
        this.mCompatScaling = paint.mCompatScaling;
        this.mInvCompatScaling = paint.mInvCompatScaling;
        this.mBidiFlags = paint.mBidiFlags;
        this.mLocales = paint.mLocales;
        this.mFontFeatureSettings = paint.mFontFeatureSettings;
        this.mFontVariationSettings = paint.mFontVariationSettings;
    }

    private final void $$robo$$android_graphics_Paint$setCompatibilityScaling(float factor) {
        if ((double)factor == 1.0) {
            this.mHasCompatScaling = false;
            this.mInvCompatScaling = 1.0f;
            this.mCompatScaling = 1.0f;
        } else {
            this.mHasCompatScaling = true;
            this.mCompatScaling = factor;
            this.mInvCompatScaling = 1.0f / factor;
        }
    }

    private final long $$robo$$android_graphics_Paint$getNativeInstance() {
        long newNativeColorFilter;
        long newNativeShader;
        long l = newNativeShader = this.mShader == null ? 0L : this.mShader.getNativeInstance();
        if (newNativeShader != this.mNativeShader) {
            this.mNativeShader = newNativeShader;
            Paint.nSetShader(this.mNativePaint, this.mNativeShader);
        }
        long l2 = newNativeColorFilter = this.mColorFilter == null ? 0L : this.mColorFilter.getNativeInstance();
        if (newNativeColorFilter != this.mNativeColorFilter) {
            this.mNativeColorFilter = newNativeColorFilter;
            Paint.nSetColorFilter(this.mNativePaint, this.mNativeColorFilter);
        }
        return this.mNativePaint;
    }

    private final int $$robo$$android_graphics_Paint$getBidiFlags() {
        return this.mBidiFlags;
    }

    private final void $$robo$$android_graphics_Paint$setBidiFlags(int flags) {
        if ((flags &= 7) > 5) {
            throw new IllegalArgumentException("unknown bidi flag: " + flags);
        }
        this.mBidiFlags = flags;
    }

    private final int $$robo$$android_graphics_Paint$getFlags() {
        return Paint.nGetFlags(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setFlags(int flags) {
        Paint.nSetFlags(this.mNativePaint, flags);
    }

    private final int $$robo$$android_graphics_Paint$getHinting() {
        return Paint.nGetHinting(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setHinting(int mode) {
        Paint.nSetHinting(this.mNativePaint, mode);
    }

    private final boolean $$robo$$android_graphics_Paint$isAntiAlias() {
        return (this.getFlags() & 1) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setAntiAlias(boolean aa) {
        Paint.nSetAntiAlias(this.mNativePaint, aa);
    }

    private final boolean $$robo$$android_graphics_Paint$isDither() {
        return (this.getFlags() & 4) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setDither(boolean dither) {
        Paint.nSetDither(this.mNativePaint, dither);
    }

    private final boolean $$robo$$android_graphics_Paint$isLinearText() {
        return (this.getFlags() & 0x40) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setLinearText(boolean linearText) {
        Paint.nSetLinearText(this.mNativePaint, linearText);
    }

    private final boolean $$robo$$android_graphics_Paint$isSubpixelText() {
        return (this.getFlags() & 0x80) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setSubpixelText(boolean subpixelText) {
        Paint.nSetSubpixelText(this.mNativePaint, subpixelText);
    }

    private final boolean $$robo$$android_graphics_Paint$isUnderlineText() {
        return (this.getFlags() & 8) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setUnderlineText(boolean underlineText) {
        Paint.nSetUnderlineText(this.mNativePaint, underlineText);
    }

    private final boolean $$robo$$android_graphics_Paint$isStrikeThruText() {
        return (this.getFlags() & 0x10) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setStrikeThruText(boolean strikeThruText) {
        Paint.nSetStrikeThruText(this.mNativePaint, strikeThruText);
    }

    private final boolean $$robo$$android_graphics_Paint$isFakeBoldText() {
        return (this.getFlags() & 0x20) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setFakeBoldText(boolean fakeBoldText) {
        Paint.nSetFakeBoldText(this.mNativePaint, fakeBoldText);
    }

    private final boolean $$robo$$android_graphics_Paint$isFilterBitmap() {
        return (this.getFlags() & 2) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setFilterBitmap(boolean filter) {
        Paint.nSetFilterBitmap(this.mNativePaint, filter);
    }

    private final Style $$robo$$android_graphics_Paint$getStyle() {
        return sStyleArray[Paint.nGetStyle(this.mNativePaint)];
    }

    private final void $$robo$$android_graphics_Paint$setStyle(Style style2) {
        Paint.nSetStyle(this.mNativePaint, style2.nativeInt);
    }

    private final int $$robo$$android_graphics_Paint$getColor() {
        return Paint.nGetColor(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setColor(int color2) {
        Paint.nSetColor(this.mNativePaint, color2);
    }

    private final int $$robo$$android_graphics_Paint$getAlpha() {
        return Paint.nGetAlpha(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setAlpha(int a) {
        Paint.nSetAlpha(this.mNativePaint, a);
    }

    private final void $$robo$$android_graphics_Paint$setARGB(int a, int r, int g, int b) {
        this.setColor(a << 24 | r << 16 | g << 8 | b);
    }

    private final float $$robo$$android_graphics_Paint$getStrokeWidth() {
        return Paint.nGetStrokeWidth(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setStrokeWidth(float width) {
        Paint.nSetStrokeWidth(this.mNativePaint, width);
    }

    private final float $$robo$$android_graphics_Paint$getStrokeMiter() {
        return Paint.nGetStrokeMiter(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setStrokeMiter(float miter) {
        Paint.nSetStrokeMiter(this.mNativePaint, miter);
    }

    private final Cap $$robo$$android_graphics_Paint$getStrokeCap() {
        return sCapArray[Paint.nGetStrokeCap(this.mNativePaint)];
    }

    private final void $$robo$$android_graphics_Paint$setStrokeCap(Cap cap) {
        Paint.nSetStrokeCap(this.mNativePaint, cap.nativeInt);
    }

    private final Join $$robo$$android_graphics_Paint$getStrokeJoin() {
        return sJoinArray[Paint.nGetStrokeJoin(this.mNativePaint)];
    }

    private final void $$robo$$android_graphics_Paint$setStrokeJoin(Join join) {
        Paint.nSetStrokeJoin(this.mNativePaint, join.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Paint$getFillPath(Path src, Path dst) {
        return Paint.nGetFillPath(this.mNativePaint, src.readOnlyNI(), dst.mutateNI());
    }

    private final Shader $$robo$$android_graphics_Paint$getShader() {
        return this.mShader;
    }

    private final Shader $$robo$$android_graphics_Paint$setShader(Shader shader) {
        if (this.mShader != shader) {
            this.mNativeShader = -1L;
            Paint.nSetShader(this.mNativePaint, 0L);
        }
        this.mShader = shader;
        return shader;
    }

    private final ColorFilter $$robo$$android_graphics_Paint$getColorFilter() {
        return this.mColorFilter;
    }

    private final ColorFilter $$robo$$android_graphics_Paint$setColorFilter(ColorFilter filter) {
        if (this.mColorFilter != filter) {
            this.mNativeColorFilter = -1L;
        }
        this.mColorFilter = filter;
        return filter;
    }

    private final Xfermode $$robo$$android_graphics_Paint$getXfermode() {
        return this.mXfermode;
    }

    private final Xfermode $$robo$$android_graphics_Paint$setXfermode(Xfermode xfermode) {
        int curMode;
        int newMode = xfermode != null ? xfermode.porterDuffMode : Xfermode.DEFAULT;
        int n = curMode = this.mXfermode != null ? this.mXfermode.porterDuffMode : Xfermode.DEFAULT;
        if (newMode != curMode) {
            Paint.nSetXfermode(this.mNativePaint, newMode);
        }
        this.mXfermode = xfermode;
        return xfermode;
    }

    private final PathEffect $$robo$$android_graphics_Paint$getPathEffect() {
        return this.mPathEffect;
    }

    private final PathEffect $$robo$$android_graphics_Paint$setPathEffect(PathEffect effect) {
        long effectNative = 0L;
        if (effect != null) {
            effectNative = effect.native_instance;
        }
        Paint.nSetPathEffect(this.mNativePaint, effectNative);
        this.mPathEffect = effect;
        return effect;
    }

    private final MaskFilter $$robo$$android_graphics_Paint$getMaskFilter() {
        return this.mMaskFilter;
    }

    private final MaskFilter $$robo$$android_graphics_Paint$setMaskFilter(MaskFilter maskfilter) {
        long maskfilterNative = 0L;
        if (maskfilter != null) {
            maskfilterNative = maskfilter.native_instance;
        }
        Paint.nSetMaskFilter(this.mNativePaint, maskfilterNative);
        this.mMaskFilter = maskfilter;
        return maskfilter;
    }

    private final Typeface $$robo$$android_graphics_Paint$getTypeface() {
        return this.mTypeface;
    }

    private final Typeface $$robo$$android_graphics_Paint$setTypeface(Typeface typeface) {
        long typefaceNative = 0L;
        if (typeface != null) {
            typefaceNative = typeface.native_instance;
        }
        Paint.nSetTypeface(this.mNativePaint, typefaceNative);
        this.mTypeface = typeface;
        this.mNativeTypeface = typefaceNative;
        return typeface;
    }

    @Deprecated
    private final Rasterizer $$robo$$android_graphics_Paint$getRasterizer() {
        return null;
    }

    @Deprecated
    private final Rasterizer $$robo$$android_graphics_Paint$setRasterizer(Rasterizer rasterizer) {
        return rasterizer;
    }

    private final void $$robo$$android_graphics_Paint$setShadowLayer(float radius, float dx, float dy, int shadowColor) {
        Paint.nSetShadowLayer(this.mNativePaint, radius, dx, dy, shadowColor);
    }

    private final void $$robo$$android_graphics_Paint$clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    private final boolean $$robo$$android_graphics_Paint$hasShadowLayer() {
        return Paint.nHasShadowLayer(this.mNativePaint);
    }

    private final Align $$robo$$android_graphics_Paint$getTextAlign() {
        return sAlignArray[Paint.nGetTextAlign(this.mNativePaint)];
    }

    private final void $$robo$$android_graphics_Paint$setTextAlign(Align align) {
        Paint.nSetTextAlign(this.mNativePaint, align.nativeInt);
    }

    private final Locale $$robo$$android_graphics_Paint$getTextLocale() {
        return this.mLocales.get(0);
    }

    private final LocaleList $$robo$$android_graphics_Paint$getTextLocales() {
        return this.mLocales;
    }

    private final void $$robo$$android_graphics_Paint$setTextLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        if (this.mLocales != null && this.mLocales.size() == 1 && locale.equals(this.mLocales.get(0))) {
            return;
        }
        this.mLocales = new LocaleList(locale);
        this.syncTextLocalesWithMinikin();
    }

    private final void $$robo$$android_graphics_Paint$setTextLocales(LocaleList locales) {
        if (locales == null || locales.isEmpty()) {
            throw new IllegalArgumentException("locales cannot be null or empty");
        }
        if (locales.equals(this.mLocales)) {
            return;
        }
        this.mLocales = locales;
        this.syncTextLocalesWithMinikin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_Paint$syncTextLocalesWithMinikin() {
        Integer minikinLangListId;
        String languageTags = this.mLocales.toLanguageTags();
        Object object = sCacheLock;
        synchronized (object) {
            minikinLangListId = sMinikinLangListIdCache.get(languageTags);
            if (minikinLangListId == null) {
                int newID = Paint.nSetTextLocales(this.mNativePaint, languageTags);
                sMinikinLangListIdCache.put(languageTags, newID);
                return;
            }
        }
        Paint.nSetTextLocalesByMinikinLangListId(this.mNativePaint, minikinLangListId);
    }

    private final boolean $$robo$$android_graphics_Paint$isElegantTextHeight() {
        return Paint.nIsElegantTextHeight(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setElegantTextHeight(boolean elegant) {
        Paint.nSetElegantTextHeight(this.mNativePaint, elegant);
    }

    private final float $$robo$$android_graphics_Paint$getTextSize() {
        return Paint.nGetTextSize(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setTextSize(float textSize) {
        Paint.nSetTextSize(this.mNativePaint, textSize);
    }

    private final float $$robo$$android_graphics_Paint$getTextScaleX() {
        return Paint.nGetTextScaleX(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setTextScaleX(float scaleX) {
        Paint.nSetTextScaleX(this.mNativePaint, scaleX);
    }

    private final float $$robo$$android_graphics_Paint$getTextSkewX() {
        return Paint.nGetTextSkewX(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setTextSkewX(float skewX) {
        Paint.nSetTextSkewX(this.mNativePaint, skewX);
    }

    private final float $$robo$$android_graphics_Paint$getLetterSpacing() {
        return Paint.nGetLetterSpacing(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setLetterSpacing(float letterSpacing) {
        Paint.nSetLetterSpacing(this.mNativePaint, letterSpacing);
    }

    private final float $$robo$$android_graphics_Paint$getWordSpacing() {
        return Paint.nGetWordSpacing(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setWordSpacing(float wordSpacing) {
        Paint.nSetWordSpacing(this.mNativePaint, wordSpacing);
    }

    private final String $$robo$$android_graphics_Paint$getFontFeatureSettings() {
        return this.mFontFeatureSettings;
    }

    private final void $$robo$$android_graphics_Paint$setFontFeatureSettings(String settings) {
        if (settings != null && settings.equals("")) {
            settings = null;
        }
        if (settings == null && this.mFontFeatureSettings == null || settings != null && settings.equals(this.mFontFeatureSettings)) {
            return;
        }
        this.mFontFeatureSettings = settings;
        Paint.nSetFontFeatureSettings(this.mNativePaint, settings);
    }

    private final String $$robo$$android_graphics_Paint$getFontVariationSettings() {
        return this.mFontVariationSettings;
    }

    private final boolean $$robo$$android_graphics_Paint$setFontVariationSettings(String fontVariationSettings) {
        String settings = TextUtils.nullIfEmpty(fontVariationSettings);
        if (settings == this.mFontVariationSettings || settings != null && settings.equals(this.mFontVariationSettings)) {
            return true;
        }
        if (settings == null || settings.length() == 0) {
            this.mFontVariationSettings = null;
            this.setTypeface(Typeface.createFromTypefaceWithVariation(this.mTypeface, Collections.emptyList()));
            return true;
        }
        Typeface targetTypeface = this.mTypeface == null ? Typeface.DEFAULT : this.mTypeface;
        FontVariationAxis[] axes = FontVariationAxis.fromFontVariationSettings(settings);
        ArrayList<FontVariationAxis> filteredAxes = new ArrayList<FontVariationAxis>();
        for (FontVariationAxis axis : axes) {
            if (!targetTypeface.isSupportedAxes(axis.getOpenTypeTagValue())) continue;
            filteredAxes.add(axis);
        }
        if (filteredAxes.isEmpty()) {
            return false;
        }
        this.mFontVariationSettings = settings;
        this.setTypeface(Typeface.createFromTypefaceWithVariation(targetTypeface, filteredAxes));
        return true;
    }

    private final int $$robo$$android_graphics_Paint$getHyphenEdit() {
        return Paint.nGetHyphenEdit(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setHyphenEdit(int hyphen) {
        Paint.nSetHyphenEdit(this.mNativePaint, hyphen);
    }

    private final float $$robo$$android_graphics_Paint$ascent() {
        return Paint.nAscent(this.mNativePaint, this.mNativeTypeface);
    }

    private final float $$robo$$android_graphics_Paint$descent() {
        return Paint.nDescent(this.mNativePaint, this.mNativeTypeface);
    }

    private final float $$robo$$android_graphics_Paint$getFontMetrics(FontMetrics metrics) {
        return Paint.nGetFontMetrics(this.mNativePaint, this.mNativeTypeface, metrics);
    }

    private final FontMetrics $$robo$$android_graphics_Paint$getFontMetrics() {
        FontMetrics fm = new FontMetrics();
        this.getFontMetrics(fm);
        return fm;
    }

    private final int $$robo$$android_graphics_Paint$getFontMetricsInt(FontMetricsInt fmi) {
        return Paint.nGetFontMetricsInt(this.mNativePaint, this.mNativeTypeface, fmi);
    }

    private final FontMetricsInt $$robo$$android_graphics_Paint$getFontMetricsInt() {
        FontMetricsInt fm = new FontMetricsInt();
        this.getFontMetricsInt(fm);
        return fm;
    }

    private final float $$robo$$android_graphics_Paint$getFontSpacing() {
        return this.getFontMetrics(null);
    }

    private final float $$robo$$android_graphics_Paint$measureText(char[] text, int index, int count) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, null, 0));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, null, 0);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    private final float $$robo$$android_graphics_Paint$measureText(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, null, 0));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, null, 0);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    private final float $$robo$$android_graphics_Paint$measureText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        return this.measureText(text, 0, text.length());
    }

    private final float $$robo$$android_graphics_Paint$measureText(CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (text instanceof String) {
            return this.measureText((String)text, start, end);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.measureText(text.toString(), start, end);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).measureText(start, end, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        float result = this.measureText(buf, 0, end - start);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final int $$robo$$android_graphics_Paint$breakText(char[] text, int index, int count, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (index < 0 || text.length - index < Math.abs(count)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, index, count, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, index, count, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    private final int $$robo$$android_graphics_Paint$breakText(CharSequence text, int start, int end, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (start == 0 && text instanceof String && end == text.length()) {
            return this.breakText((String)text, measureForwards, maxWidth, measuredWidth);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = measureForwards ? this.breakText(buf, 0, end - start, maxWidth, measuredWidth) : this.breakText(buf, 0, -(end - start), maxWidth, measuredWidth);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final int $$robo$$android_graphics_Paint$breakText(String text, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (text.length() == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, measureForwards, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, measureForwards, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    private final int $$robo$$android_graphics_Paint$getTextWidths(char[] text, int index, int count, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length || count > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, widths, 0);
            return count;
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, widths, 0);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < count) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return count;
    }

    private final int $$robo$$android_graphics_Paint$getTextWidths(CharSequence text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (text instanceof String) {
            return this.getTextWidths((String)text, start, end, widths);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextWidths(text.toString(), start, end, widths);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextWidths(start, end, widths, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = this.getTextWidths(buf, 0, end - start, widths);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final int $$robo$$android_graphics_Paint$getTextWidths(String text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, widths, 0);
            return end - start;
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, widths, 0);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < end - start) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return end - start;
    }

    private final int $$robo$$android_graphics_Paint$getTextWidths(String text, float[] widths) {
        return this.getTextWidths(text, 0, text.length(), widths);
    }

    private final float $$robo$$android_graphics_Paint$getTextRunAdvances(char[] chars, int index, int count, int contextIndex, int contextCount, boolean isRtl, float[] advances, int advancesIndex) {
        if (chars == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count | contextIndex | contextCount | advancesIndex | index - contextIndex | contextCount - count | contextIndex + contextCount - (index + count) | chars.length - (contextIndex + contextCount) | (advances == null ? 0 : advances.length - (advancesIndex + count))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (chars.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, chars, index, count, contextIndex, contextCount, isRtl ? 5 : 4, advances, advancesIndex);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float res = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, chars, index, count, contextIndex, contextCount, isRtl ? 5 : 4, advances, advancesIndex);
        this.setTextSize(oldSize);
        if (advances != null) {
            int i = advancesIndex;
            int e = i + count;
            while (i < e) {
                int n = i++;
                advances[n] = advances[n] * this.mInvCompatScaling;
            }
        }
        return res * this.mInvCompatScaling;
    }

    private final float $$robo$$android_graphics_Paint$getTextRunAdvances(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | contextStart | contextEnd | advancesIndex | end - start | start - contextStart | contextEnd - end | text.length() - contextEnd | (advances == null ? 0 : advances.length - advancesIndex - (end - start))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String) {
            return this.getTextRunAdvances((String)text, start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextRunAdvances(text.toString(), start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextRunAdvances(start, end, contextStart, contextEnd, isRtl, advances, advancesIndex, this);
        }
        if (text.length() == 0 || end == start) {
            return 0.0f;
        }
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        char[] buf = TemporaryBuffer.obtain(contextLen);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        float result = this.getTextRunAdvances(buf, start - contextStart, len, 0, contextLen, isRtl, advances, advancesIndex);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final float $$robo$$android_graphics_Paint$getTextRunAdvances(String text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | contextStart | contextEnd | advancesIndex | end - start | start - contextStart | contextEnd - end | text.length() - contextEnd | (advances == null ? 0 : advances.length - advancesIndex - (end - start))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl ? 5 : 4, advances, advancesIndex);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float totalAdvance = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl ? 5 : 4, advances, advancesIndex);
        this.setTextSize(oldSize);
        if (advances != null) {
            int i = advancesIndex;
            int e = i + (end - start);
            while (i < e) {
                int n = i++;
                advances[n] = advances[n] * this.mInvCompatScaling;
            }
        }
        return totalAdvance * this.mInvCompatScaling;
    }

    private final int $$robo$$android_graphics_Paint$getTextRunCursor(char[] text, int contextStart, int contextLength, int dir, int offset, int cursorOpt) {
        int contextEnd = contextStart + contextLength;
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.nGetTextRunCursor(this.mNativePaint, this.mNativeTypeface, text, contextStart, contextLength, dir, offset, cursorOpt);
    }

    private final int $$robo$$android_graphics_Paint$getTextRunCursor(CharSequence text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextRunCursor(text.toString(), contextStart, contextEnd, dir, offset, cursorOpt);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextRunCursor(contextStart, contextEnd, dir, offset, cursorOpt, this);
        }
        int contextLen = contextEnd - contextStart;
        char[] buf = TemporaryBuffer.obtain(contextLen);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        int relPos = this.getTextRunCursor(buf, 0, contextLen, dir, offset - contextStart, cursorOpt);
        TemporaryBuffer.recycle(buf);
        return relPos == -1 ? -1 : relPos + contextStart;
    }

    private final int $$robo$$android_graphics_Paint$getTextRunCursor(String text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length() - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.nGetTextRunCursor(this.mNativePaint, this.mNativeTypeface, text, contextStart, contextEnd, dir, offset, cursorOpt);
    }

    private final void $$robo$$android_graphics_Paint$getTextPath(char[] text, int index, int count, float x, float y, Path path) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Paint.nGetTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, text, index, count, x, y, path.mutateNI());
    }

    private final void $$robo$$android_graphics_Paint$getTextPath(String text, int start, int end, float x, float y, Path path) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Paint.nGetTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, text, start, end, x, y, path.mutateNI());
    }

    private final void $$robo$$android_graphics_Paint$getTextBounds(String text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nGetStringBounds(this.mNativePaint, this.mNativeTypeface, text, start, end, this.mBidiFlags, bounds);
    }

    private final void $$robo$$android_graphics_Paint$getTextBounds(CharSequence text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        this.getTextBounds(buf, 0, end - start, bounds);
        TemporaryBuffer.recycle(buf);
    }

    private final void $$robo$$android_graphics_Paint$getTextBounds(char[] text, int index, int count, Rect bounds) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nGetCharArrayBounds(this.mNativePaint, this.mNativeTypeface, text, index, count, this.mBidiFlags, bounds);
    }

    private final boolean $$robo$$android_graphics_Paint$hasGlyph(String string2) {
        return Paint.nHasGlyph(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, string2);
    }

    private final float $$robo$$android_graphics_Paint$getRunAdvance(char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | offset | end | contextEnd | start - contextStart | offset - start | end - offset | contextEnd - end | text.length - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return 0.0f;
        }
        return Paint.nGetRunAdvance(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl, offset);
    }

    private final float $$robo$$android_graphics_Paint$getRunAdvance(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | offset | end | contextEnd | start - contextStart | offset - start | end - offset | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return 0.0f;
        }
        char[] buf = TemporaryBuffer.obtain(contextEnd - contextStart);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        float result = this.getRunAdvance(buf, start - contextStart, end - contextStart, 0, contextEnd - contextStart, isRtl, offset - contextStart);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final int $$robo$$android_graphics_Paint$getOffsetForAdvance(char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | end | contextEnd | start - contextStart | end - start | contextEnd - end | text.length - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return Paint.nGetOffsetForAdvance(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl, advance);
    }

    private final int $$robo$$android_graphics_Paint$getOffsetForAdvance(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | end | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] buf = TemporaryBuffer.obtain(contextEnd - contextStart);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        int result = this.getOffsetForAdvance(buf, start - contextStart, end - contextStart, 0, contextEnd - contextStart, isRtl, advance) + contextStart;
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private static final long $$robo$$android_graphics_Paint$nGetNativeFinalizer() {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Paint$nInit() {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Paint$nInitWithPaint(long l) {
        return 0L;
    }

    private static final int $$robo$$android_graphics_Paint$nBreakText(long l, long l2, char[] cArray, int n, int n2, float f, int n3, float[] fArray) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Paint$nBreakText(long l, long l2, String string2, boolean bl, float f, int n, float[] fArray) {
        return 0;
    }

    private static final float $$robo$$android_graphics_Paint$nGetTextAdvances(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        return 0.0f;
    }

    private static final float $$robo$$android_graphics_Paint$nGetTextAdvances(long l, long l2, String string2, int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        return 0.0f;
    }

    private final int $$robo$$android_graphics_Paint$nGetTextRunCursor(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    private final int $$robo$$android_graphics_Paint$nGetTextRunCursor(long l, long l2, String string2, int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Paint$nGetTextPath(long l, long l2, int n, char[] cArray, int n2, int n3, float f, float f2, long l3) {
    }

    private static final void $$robo$$android_graphics_Paint$nGetTextPath(long l, long l2, int n, String string2, int n2, int n3, float f, float f2, long l3) {
    }

    private static final void $$robo$$android_graphics_Paint$nGetStringBounds(long l, long l2, String string2, int n, int n2, int n3, Rect rect) {
    }

    private static final void $$robo$$android_graphics_Paint$nGetCharArrayBounds(long l, long l2, char[] cArray, int n, int n2, int n3, Rect rect) {
    }

    private static final boolean $$robo$$android_graphics_Paint$nHasGlyph(long l, long l2, int n, String string2) {
        return false;
    }

    private static final float $$robo$$android_graphics_Paint$nGetRunAdvance(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, boolean bl, int n5) {
        return 0.0f;
    }

    private static final int $$robo$$android_graphics_Paint$nGetOffsetForAdvance(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, boolean bl, float f) {
        return 0;
    }

    @FastNative
    private static final int $$robo$$android_graphics_Paint$nSetTextLocales(long l, String string2) {
        return 0;
    }

    @FastNative
    private static final void $$robo$$android_graphics_Paint$nSetFontFeatureSettings(long l, String string2) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_Paint$nGetFontMetrics(long l, long l2, FontMetrics fontMetrics) {
        return 0.0f;
    }

    @FastNative
    private static final int $$robo$$android_graphics_Paint$nGetFontMetricsInt(long l, long l2, FontMetricsInt fontMetricsInt) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nReset(long l) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSet(long l, long l2) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Paint$nGetStyle(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetStyle(long l, int n) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Paint$nGetStrokeCap(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetStrokeCap(long l, int n) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Paint$nGetStrokeJoin(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetStrokeJoin(long l, int n) {
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Paint$nGetFillPath(long l, long l2, long l3) {
        return false;
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_Paint$nSetShader(long l, long l2) {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_Paint$nSetColorFilter(long l, long l2) {
        return 0L;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetXfermode(long l, int n) {
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_Paint$nSetPathEffect(long l, long l2) {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_Paint$nSetMaskFilter(long l, long l2) {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_Paint$nSetTypeface(long l, long l2) {
        return 0L;
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Paint$nGetTextAlign(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetTextAlign(long l, int n) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetTextLocalesByMinikinLangListId(long l, int n) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetShadowLayer(long l, float f, float f2, float f3, int n) {
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Paint$nHasShadowLayer(long l) {
        return false;
    }

    @CriticalNative
    private static final float $$robo$$android_graphics_Paint$nGetLetterSpacing(long l) {
        return 0.0f;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetLetterSpacing(long l, float f) {
    }

    @CriticalNative
    private static final float $$robo$$android_graphics_Paint$nGetWordSpacing(long l) {
        return 0.0f;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetWordSpacing(long l, float f) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Paint$nGetHyphenEdit(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetHyphenEdit(long l, int n) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetStrokeMiter(long l, float f) {
    }

    @CriticalNative
    private static final float $$robo$$android_graphics_Paint$nGetStrokeMiter(long l) {
        return 0.0f;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetStrokeWidth(long l, float f) {
    }

    @CriticalNative
    private static final float $$robo$$android_graphics_Paint$nGetStrokeWidth(long l) {
        return 0.0f;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetAlpha(long l, int n) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetDither(long l, boolean bl) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Paint$nGetFlags(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetFlags(long l, int n) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Paint$nGetHinting(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetHinting(long l, int n) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetAntiAlias(long l, boolean bl) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetLinearText(long l, boolean bl) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetSubpixelText(long l, boolean bl) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetUnderlineText(long l, boolean bl) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetFakeBoldText(long l, boolean bl) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetFilterBitmap(long l, boolean bl) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Paint$nGetColor(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetColor(long l, int n) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Paint$nGetAlpha(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetStrikeThruText(long l, boolean bl) {
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Paint$nIsElegantTextHeight(long l) {
        return false;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetElegantTextHeight(long l, boolean bl) {
    }

    @CriticalNative
    private static final float $$robo$$android_graphics_Paint$nGetTextSize(long l) {
        return 0.0f;
    }

    @CriticalNative
    private static final float $$robo$$android_graphics_Paint$nGetTextScaleX(long l) {
        return 0.0f;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetTextScaleX(long l, float f) {
    }

    @CriticalNative
    private static final float $$robo$$android_graphics_Paint$nGetTextSkewX(long l) {
        return 0.0f;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetTextSkewX(long l, float f) {
    }

    @CriticalNative
    private static final float $$robo$$android_graphics_Paint$nAscent(long l, long l2) {
        return 0.0f;
    }

    @CriticalNative
    private static final float $$robo$$android_graphics_Paint$nDescent(long l, long l2) {
        return 0.0f;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Paint$nSetTextSize(long l, float f) {
    }

    static void __staticInitializer__() {
        sCacheLock = new Object();
        sMinikinLangListIdCache = new HashMap();
        sStyleArray = new Style[]{Style.FILL, Style.STROKE, Style.FILL_AND_STROKE};
        sCapArray = new Cap[]{Cap.BUTT, Cap.ROUND, Cap.SQUARE};
        sJoinArray = new Join[]{Join.MITER, Join.ROUND, Join.BEVEL};
        sAlignArray = new Align[]{Align.LEFT, Align.CENTER, Align.RIGHT};
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Paint$__constructor__();
    }

    public Paint() {
        this(0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_graphics_Paint$__constructor__(n);
    }

    public Paint(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(Paint paint) {
        this.$$robo$$android_graphics_Paint$__constructor__(paint);
    }

    public Paint(Paint paint) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint$__constructor__(android.graphics.Paint ), 0, this, paint);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_graphics_Paint$reset(), 0, this);
    }

    public void set(Paint paint) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_graphics_Paint$set(android.graphics.Paint ), 0, this, paint);
    }

    private void setClassVariablesFrom(Paint paint) {
        InvokeDynamicSupport.bootstrap("setClassVariablesFrom", $$robo$$android_graphics_Paint$setClassVariablesFrom(android.graphics.Paint ), 0, this, paint);
    }

    public void setCompatibilityScaling(float f) {
        InvokeDynamicSupport.bootstrap("setCompatibilityScaling", $$robo$$android_graphics_Paint$setCompatibilityScaling(float ), 0, this, f);
    }

    public long getNativeInstance() {
        return (long)InvokeDynamicSupport.bootstrap("getNativeInstance", $$robo$$android_graphics_Paint$getNativeInstance(), 0, this);
    }

    public int getBidiFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getBidiFlags", $$robo$$android_graphics_Paint$getBidiFlags(), 0, this);
    }

    public void setBidiFlags(int n) {
        InvokeDynamicSupport.bootstrap("setBidiFlags", $$robo$$android_graphics_Paint$setBidiFlags(int ), 0, this, n);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_graphics_Paint$getFlags(), 0, this);
    }

    public void setFlags(int n) {
        InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_graphics_Paint$setFlags(int ), 0, this, n);
    }

    public int getHinting() {
        return (int)InvokeDynamicSupport.bootstrap("getHinting", $$robo$$android_graphics_Paint$getHinting(), 0, this);
    }

    public void setHinting(int n) {
        InvokeDynamicSupport.bootstrap("setHinting", $$robo$$android_graphics_Paint$setHinting(int ), 0, this, n);
    }

    public boolean isAntiAlias() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAntiAlias", $$robo$$android_graphics_Paint$isAntiAlias(), 0, this);
    }

    public void setAntiAlias(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAntiAlias", $$robo$$android_graphics_Paint$setAntiAlias(boolean ), 0, this, bl);
    }

    public boolean isDither() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDither", $$robo$$android_graphics_Paint$isDither(), 0, this);
    }

    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_Paint$setDither(boolean ), 0, this, bl);
    }

    public boolean isLinearText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLinearText", $$robo$$android_graphics_Paint$isLinearText(), 0, this);
    }

    public void setLinearText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLinearText", $$robo$$android_graphics_Paint$setLinearText(boolean ), 0, this, bl);
    }

    public boolean isSubpixelText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSubpixelText", $$robo$$android_graphics_Paint$isSubpixelText(), 0, this);
    }

    public void setSubpixelText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSubpixelText", $$robo$$android_graphics_Paint$setSubpixelText(boolean ), 0, this, bl);
    }

    public boolean isUnderlineText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnderlineText", $$robo$$android_graphics_Paint$isUnderlineText(), 0, this);
    }

    public void setUnderlineText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUnderlineText", $$robo$$android_graphics_Paint$setUnderlineText(boolean ), 0, this, bl);
    }

    public boolean isStrikeThruText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStrikeThruText", $$robo$$android_graphics_Paint$isStrikeThruText(), 0, this);
    }

    public void setStrikeThruText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStrikeThruText", $$robo$$android_graphics_Paint$setStrikeThruText(boolean ), 0, this, bl);
    }

    public boolean isFakeBoldText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFakeBoldText", $$robo$$android_graphics_Paint$isFakeBoldText(), 0, this);
    }

    public void setFakeBoldText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFakeBoldText", $$robo$$android_graphics_Paint$setFakeBoldText(boolean ), 0, this, bl);
    }

    public boolean isFilterBitmap() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFilterBitmap", $$robo$$android_graphics_Paint$isFilterBitmap(), 0, this);
    }

    public void setFilterBitmap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFilterBitmap", $$robo$$android_graphics_Paint$setFilterBitmap(boolean ), 0, this, bl);
    }

    public Style getStyle() {
        return InvokeDynamicSupport.bootstrap("getStyle", $$robo$$android_graphics_Paint$getStyle(), 0, this);
    }

    public void setStyle(Style style2) {
        InvokeDynamicSupport.bootstrap("setStyle", $$robo$$android_graphics_Paint$setStyle(android.graphics.Paint$Style ), 0, this, style2);
    }

    public int getColor() {
        return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_graphics_Paint$getColor(), 0, this);
    }

    public void setColor(int n) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_graphics_Paint$setColor(int ), 0, this, n);
    }

    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_Paint$getAlpha(), 0, this);
    }

    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_Paint$setAlpha(int ), 0, this, n);
    }

    public void setARGB(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setARGB", $$robo$$android_graphics_Paint$setARGB(int int int int ), 0, this, n, n2, n3, n4);
    }

    public float getStrokeWidth() {
        return (float)InvokeDynamicSupport.bootstrap("getStrokeWidth", $$robo$$android_graphics_Paint$getStrokeWidth(), 0, this);
    }

    public void setStrokeWidth(float f) {
        InvokeDynamicSupport.bootstrap("setStrokeWidth", $$robo$$android_graphics_Paint$setStrokeWidth(float ), 0, this, f);
    }

    public float getStrokeMiter() {
        return (float)InvokeDynamicSupport.bootstrap("getStrokeMiter", $$robo$$android_graphics_Paint$getStrokeMiter(), 0, this);
    }

    public void setStrokeMiter(float f) {
        InvokeDynamicSupport.bootstrap("setStrokeMiter", $$robo$$android_graphics_Paint$setStrokeMiter(float ), 0, this, f);
    }

    public Cap getStrokeCap() {
        return InvokeDynamicSupport.bootstrap("getStrokeCap", $$robo$$android_graphics_Paint$getStrokeCap(), 0, this);
    }

    public void setStrokeCap(Cap cap) {
        InvokeDynamicSupport.bootstrap("setStrokeCap", $$robo$$android_graphics_Paint$setStrokeCap(android.graphics.Paint$Cap ), 0, this, cap);
    }

    public Join getStrokeJoin() {
        return InvokeDynamicSupport.bootstrap("getStrokeJoin", $$robo$$android_graphics_Paint$getStrokeJoin(), 0, this);
    }

    public void setStrokeJoin(Join join) {
        InvokeDynamicSupport.bootstrap("setStrokeJoin", $$robo$$android_graphics_Paint$setStrokeJoin(android.graphics.Paint$Join ), 0, this, join);
    }

    public boolean getFillPath(Path path, Path path2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getFillPath", $$robo$$android_graphics_Paint$getFillPath(android.graphics.Path android.graphics.Path ), 0, this, path, path2);
    }

    public Shader getShader() {
        return InvokeDynamicSupport.bootstrap("getShader", $$robo$$android_graphics_Paint$getShader(), 0, this);
    }

    public Shader setShader(Shader shader) {
        return InvokeDynamicSupport.bootstrap("setShader", $$robo$$android_graphics_Paint$setShader(android.graphics.Shader ), 0, this, shader);
    }

    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_Paint$getColorFilter(), 0, this);
    }

    public ColorFilter setColorFilter(ColorFilter colorFilter) {
        return InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_Paint$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    public Xfermode getXfermode() {
        return InvokeDynamicSupport.bootstrap("getXfermode", $$robo$$android_graphics_Paint$getXfermode(), 0, this);
    }

    public Xfermode setXfermode(Xfermode xfermode) {
        return InvokeDynamicSupport.bootstrap("setXfermode", $$robo$$android_graphics_Paint$setXfermode(android.graphics.Xfermode ), 0, this, xfermode);
    }

    public PathEffect getPathEffect() {
        return InvokeDynamicSupport.bootstrap("getPathEffect", $$robo$$android_graphics_Paint$getPathEffect(), 0, this);
    }

    public PathEffect setPathEffect(PathEffect pathEffect) {
        return InvokeDynamicSupport.bootstrap("setPathEffect", $$robo$$android_graphics_Paint$setPathEffect(android.graphics.PathEffect ), 0, this, pathEffect);
    }

    public MaskFilter getMaskFilter() {
        return InvokeDynamicSupport.bootstrap("getMaskFilter", $$robo$$android_graphics_Paint$getMaskFilter(), 0, this);
    }

    public MaskFilter setMaskFilter(MaskFilter maskFilter) {
        return InvokeDynamicSupport.bootstrap("setMaskFilter", $$robo$$android_graphics_Paint$setMaskFilter(android.graphics.MaskFilter ), 0, this, maskFilter);
    }

    public Typeface getTypeface() {
        return InvokeDynamicSupport.bootstrap("getTypeface", $$robo$$android_graphics_Paint$getTypeface(), 0, this);
    }

    public Typeface setTypeface(Typeface typeface) {
        return InvokeDynamicSupport.bootstrap("setTypeface", $$robo$$android_graphics_Paint$setTypeface(android.graphics.Typeface ), 0, this, typeface);
    }

    @Deprecated
    public Rasterizer getRasterizer() {
        return InvokeDynamicSupport.bootstrap("getRasterizer", $$robo$$android_graphics_Paint$getRasterizer(), 0, this);
    }

    @Deprecated
    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        return InvokeDynamicSupport.bootstrap("setRasterizer", $$robo$$android_graphics_Paint$setRasterizer(android.graphics.Rasterizer ), 0, this, rasterizer);
    }

    public void setShadowLayer(float f, float f2, float f3, int n) {
        InvokeDynamicSupport.bootstrap("setShadowLayer", $$robo$$android_graphics_Paint$setShadowLayer(float float float int ), 0, this, f, f2, f3, n);
    }

    public void clearShadowLayer() {
        InvokeDynamicSupport.bootstrap("clearShadowLayer", $$robo$$android_graphics_Paint$clearShadowLayer(), 0, this);
    }

    public boolean hasShadowLayer() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasShadowLayer", $$robo$$android_graphics_Paint$hasShadowLayer(), 0, this);
    }

    public Align getTextAlign() {
        return InvokeDynamicSupport.bootstrap("getTextAlign", $$robo$$android_graphics_Paint$getTextAlign(), 0, this);
    }

    public void setTextAlign(Align align) {
        InvokeDynamicSupport.bootstrap("setTextAlign", $$robo$$android_graphics_Paint$setTextAlign(android.graphics.Paint$Align ), 0, this, align);
    }

    public Locale getTextLocale() {
        return InvokeDynamicSupport.bootstrap("getTextLocale", $$robo$$android_graphics_Paint$getTextLocale(), 0, this);
    }

    public LocaleList getTextLocales() {
        return InvokeDynamicSupport.bootstrap("getTextLocales", $$robo$$android_graphics_Paint$getTextLocales(), 0, this);
    }

    public void setTextLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setTextLocale", $$robo$$android_graphics_Paint$setTextLocale(java.util.Locale ), 0, this, locale);
    }

    public void setTextLocales(LocaleList localeList) {
        InvokeDynamicSupport.bootstrap("setTextLocales", $$robo$$android_graphics_Paint$setTextLocales(android.os.LocaleList ), 0, this, localeList);
    }

    private void syncTextLocalesWithMinikin() {
        InvokeDynamicSupport.bootstrap("syncTextLocalesWithMinikin", $$robo$$android_graphics_Paint$syncTextLocalesWithMinikin(), 0, this);
    }

    public boolean isElegantTextHeight() {
        return (boolean)InvokeDynamicSupport.bootstrap("isElegantTextHeight", $$robo$$android_graphics_Paint$isElegantTextHeight(), 0, this);
    }

    public void setElegantTextHeight(boolean bl) {
        InvokeDynamicSupport.bootstrap("setElegantTextHeight", $$robo$$android_graphics_Paint$setElegantTextHeight(boolean ), 0, this, bl);
    }

    public float getTextSize() {
        return (float)InvokeDynamicSupport.bootstrap("getTextSize", $$robo$$android_graphics_Paint$getTextSize(), 0, this);
    }

    public void setTextSize(float f) {
        InvokeDynamicSupport.bootstrap("setTextSize", $$robo$$android_graphics_Paint$setTextSize(float ), 0, this, f);
    }

    public float getTextScaleX() {
        return (float)InvokeDynamicSupport.bootstrap("getTextScaleX", $$robo$$android_graphics_Paint$getTextScaleX(), 0, this);
    }

    public void setTextScaleX(float f) {
        InvokeDynamicSupport.bootstrap("setTextScaleX", $$robo$$android_graphics_Paint$setTextScaleX(float ), 0, this, f);
    }

    public float getTextSkewX() {
        return (float)InvokeDynamicSupport.bootstrap("getTextSkewX", $$robo$$android_graphics_Paint$getTextSkewX(), 0, this);
    }

    public void setTextSkewX(float f) {
        InvokeDynamicSupport.bootstrap("setTextSkewX", $$robo$$android_graphics_Paint$setTextSkewX(float ), 0, this, f);
    }

    public float getLetterSpacing() {
        return (float)InvokeDynamicSupport.bootstrap("getLetterSpacing", $$robo$$android_graphics_Paint$getLetterSpacing(), 0, this);
    }

    public void setLetterSpacing(float f) {
        InvokeDynamicSupport.bootstrap("setLetterSpacing", $$robo$$android_graphics_Paint$setLetterSpacing(float ), 0, this, f);
    }

    public float getWordSpacing() {
        return (float)InvokeDynamicSupport.bootstrap("getWordSpacing", $$robo$$android_graphics_Paint$getWordSpacing(), 0, this);
    }

    public void setWordSpacing(float f) {
        InvokeDynamicSupport.bootstrap("setWordSpacing", $$robo$$android_graphics_Paint$setWordSpacing(float ), 0, this, f);
    }

    public String getFontFeatureSettings() {
        return InvokeDynamicSupport.bootstrap("getFontFeatureSettings", $$robo$$android_graphics_Paint$getFontFeatureSettings(), 0, this);
    }

    public void setFontFeatureSettings(String string2) {
        InvokeDynamicSupport.bootstrap("setFontFeatureSettings", $$robo$$android_graphics_Paint$setFontFeatureSettings(java.lang.String ), 0, this, string2);
    }

    public String getFontVariationSettings() {
        return InvokeDynamicSupport.bootstrap("getFontVariationSettings", $$robo$$android_graphics_Paint$getFontVariationSettings(), 0, this);
    }

    public boolean setFontVariationSettings(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFontVariationSettings", $$robo$$android_graphics_Paint$setFontVariationSettings(java.lang.String ), 0, this, string2);
    }

    public int getHyphenEdit() {
        return (int)InvokeDynamicSupport.bootstrap("getHyphenEdit", $$robo$$android_graphics_Paint$getHyphenEdit(), 0, this);
    }

    public void setHyphenEdit(int n) {
        InvokeDynamicSupport.bootstrap("setHyphenEdit", $$robo$$android_graphics_Paint$setHyphenEdit(int ), 0, this, n);
    }

    public float ascent() {
        return (float)InvokeDynamicSupport.bootstrap("ascent", $$robo$$android_graphics_Paint$ascent(), 0, this);
    }

    public float descent() {
        return (float)InvokeDynamicSupport.bootstrap("descent", $$robo$$android_graphics_Paint$descent(), 0, this);
    }

    public float getFontMetrics(FontMetrics fontMetrics) {
        return (float)InvokeDynamicSupport.bootstrap("getFontMetrics", $$robo$$android_graphics_Paint$getFontMetrics(android.graphics.Paint$FontMetrics ), 0, this, fontMetrics);
    }

    public FontMetrics getFontMetrics() {
        return InvokeDynamicSupport.bootstrap("getFontMetrics", $$robo$$android_graphics_Paint$getFontMetrics(), 0, this);
    }

    public int getFontMetricsInt(FontMetricsInt fontMetricsInt) {
        return (int)InvokeDynamicSupport.bootstrap("getFontMetricsInt", $$robo$$android_graphics_Paint$getFontMetricsInt(android.graphics.Paint$FontMetricsInt ), 0, this, fontMetricsInt);
    }

    public FontMetricsInt getFontMetricsInt() {
        return InvokeDynamicSupport.bootstrap("getFontMetricsInt", $$robo$$android_graphics_Paint$getFontMetricsInt(), 0, this);
    }

    public float getFontSpacing() {
        return (float)InvokeDynamicSupport.bootstrap("getFontSpacing", $$robo$$android_graphics_Paint$getFontSpacing(), 0, this);
    }

    public float measureText(char[] cArray, int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_graphics_Paint$measureText(char[] int int ), 0, this, cArray, n, n2);
    }

    public float measureText(String string2, int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_graphics_Paint$measureText(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public float measureText(String string2) {
        return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_graphics_Paint$measureText(java.lang.String ), 0, this, string2);
    }

    public float measureText(CharSequence charSequence, int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_graphics_Paint$measureText(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    public int breakText(char[] cArray, int n, int n2, float f, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("breakText", $$robo$$android_graphics_Paint$breakText(char[] int int float float[] ), 0, this, cArray, n, n2, f, fArray);
    }

    public int breakText(CharSequence charSequence, int n, int n2, boolean bl, float f, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("breakText", $$robo$$android_graphics_Paint$breakText(java.lang.CharSequence int int boolean float float[] ), 0, this, charSequence, n, n2, bl, f, fArray);
    }

    public int breakText(String string2, boolean bl, float f, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("breakText", $$robo$$android_graphics_Paint$breakText(java.lang.String boolean float float[] ), 0, this, string2, bl, f, fArray);
    }

    public int getTextWidths(char[] cArray, int n, int n2, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_graphics_Paint$getTextWidths(char[] int int float[] ), 0, this, cArray, n, n2, fArray);
    }

    public int getTextWidths(CharSequence charSequence, int n, int n2, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_graphics_Paint$getTextWidths(java.lang.CharSequence int int float[] ), 0, this, charSequence, n, n2, fArray);
    }

    public int getTextWidths(String string2, int n, int n2, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_graphics_Paint$getTextWidths(java.lang.String int int float[] ), 0, this, string2, n, n2, fArray);
    }

    public int getTextWidths(String string2, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_graphics_Paint$getTextWidths(java.lang.String float[] ), 0, this, string2, fArray);
    }

    public float getTextRunAdvances(char[] cArray, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return (float)InvokeDynamicSupport.bootstrap("getTextRunAdvances", $$robo$$android_graphics_Paint$getTextRunAdvances(char[] int int int int boolean float[] int ), 0, this, cArray, n, n2, n3, n4, bl, fArray, n5);
    }

    public float getTextRunAdvances(CharSequence charSequence, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return (float)InvokeDynamicSupport.bootstrap("getTextRunAdvances", $$robo$$android_graphics_Paint$getTextRunAdvances(java.lang.CharSequence int int int int boolean float[] int ), 0, this, charSequence, n, n2, n3, n4, bl, fArray, n5);
    }

    public float getTextRunAdvances(String string2, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return (float)InvokeDynamicSupport.bootstrap("getTextRunAdvances", $$robo$$android_graphics_Paint$getTextRunAdvances(java.lang.String int int int int boolean float[] int ), 0, this, string2, n, n2, n3, n4, bl, fArray, n5);
    }

    public int getTextRunCursor(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("getTextRunCursor", $$robo$$android_graphics_Paint$getTextRunCursor(char[] int int int int int ), 0, this, cArray, n, n2, n3, n4, n5);
    }

    public int getTextRunCursor(CharSequence charSequence, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("getTextRunCursor", $$robo$$android_graphics_Paint$getTextRunCursor(java.lang.CharSequence int int int int int ), 0, this, charSequence, n, n2, n3, n4, n5);
    }

    public int getTextRunCursor(String string2, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("getTextRunCursor", $$robo$$android_graphics_Paint$getTextRunCursor(java.lang.String int int int int int ), 0, this, string2, n, n2, n3, n4, n5);
    }

    public void getTextPath(char[] cArray, int n, int n2, float f, float f2, Path path) {
        InvokeDynamicSupport.bootstrap("getTextPath", $$robo$$android_graphics_Paint$getTextPath(char[] int int float float android.graphics.Path ), 0, this, cArray, n, n2, f, f2, path);
    }

    public void getTextPath(String string2, int n, int n2, float f, float f2, Path path) {
        InvokeDynamicSupport.bootstrap("getTextPath", $$robo$$android_graphics_Paint$getTextPath(java.lang.String int int float float android.graphics.Path ), 0, this, string2, n, n2, f, f2, path);
    }

    public void getTextBounds(String string2, int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrap("getTextBounds", $$robo$$android_graphics_Paint$getTextBounds(java.lang.String int int android.graphics.Rect ), 0, this, string2, n, n2, rect);
    }

    public void getTextBounds(CharSequence charSequence, int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrap("getTextBounds", $$robo$$android_graphics_Paint$getTextBounds(java.lang.CharSequence int int android.graphics.Rect ), 0, this, charSequence, n, n2, rect);
    }

    public void getTextBounds(char[] cArray, int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrap("getTextBounds", $$robo$$android_graphics_Paint$getTextBounds(char[] int int android.graphics.Rect ), 0, this, cArray, n, n2, rect);
    }

    public boolean hasGlyph(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasGlyph", $$robo$$android_graphics_Paint$hasGlyph(java.lang.String ), 0, this, string2);
    }

    public float getRunAdvance(char[] cArray, int n, int n2, int n3, int n4, boolean bl, int n5) {
        return (float)InvokeDynamicSupport.bootstrap("getRunAdvance", $$robo$$android_graphics_Paint$getRunAdvance(char[] int int int int boolean int ), 0, this, cArray, n, n2, n3, n4, bl, n5);
    }

    public float getRunAdvance(CharSequence charSequence, int n, int n2, int n3, int n4, boolean bl, int n5) {
        return (float)InvokeDynamicSupport.bootstrap("getRunAdvance", $$robo$$android_graphics_Paint$getRunAdvance(java.lang.CharSequence int int int int boolean int ), 0, this, charSequence, n, n2, n3, n4, bl, n5);
    }

    public int getOffsetForAdvance(char[] cArray, int n, int n2, int n3, int n4, boolean bl, float f) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetForAdvance", $$robo$$android_graphics_Paint$getOffsetForAdvance(char[] int int int int boolean float ), 0, this, cArray, n, n2, n3, n4, bl, f);
    }

    public int getOffsetForAdvance(CharSequence charSequence, int n, int n2, int n3, int n4, boolean bl, float f) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetForAdvance", $$robo$$android_graphics_Paint$getOffsetForAdvance(java.lang.CharSequence int int int int boolean float ), 0, this, charSequence, n, n2, n3, n4, bl, f);
    }

    private static final native /* synthetic */ long $$robo$$nGetNativeFinalizer$nativeBinding();

    private static long nGetNativeFinalizer() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetNativeFinalizer", $$robo$$android_graphics_Paint$nGetNativeFinalizer(), 1);
    }

    private static final native /* synthetic */ long $$robo$$nInit$nativeBinding();

    private static long nInit() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nInit", $$robo$$android_graphics_Paint$nInit(), 1);
    }

    private static final native /* synthetic */ long $$robo$$nInitWithPaint$nativeBinding(long var0);

    private static long nInitWithPaint(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nInitWithPaint", $$robo$$android_graphics_Paint$nInitWithPaint(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nBreakText$nativeBinding(long var0, long var2, char[] var4, int var5, int var6, float var7, int var8, float[] var9);

    private static int nBreakText(long l, long l2, char[] cArray, int n, int n2, float f, int n3, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nBreakText", $$robo$$android_graphics_Paint$nBreakText(long long char[] int int float int float[] ), 1, (long)l, (long)l2, (char[])cArray, (int)n, (int)n2, (float)f, (int)n3, (float[])fArray);
    }

    private static final native /* synthetic */ int $$robo$$nBreakText$nativeBinding(long var0, long var2, String var4, boolean var5, float var6, int var7, float[] var8);

    private static int nBreakText(long l, long l2, String string2, boolean bl, float f, int n, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nBreakText", $$robo$$android_graphics_Paint$nBreakText(long long java.lang.String boolean float int float[] ), 1, (long)l, (long)l2, (String)string2, (boolean)bl, (float)f, (int)n, (float[])fArray);
    }

    private static final native /* synthetic */ float $$robo$$nGetTextAdvances$nativeBinding(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, int var9, float[] var10, int var11);

    private static float nGetTextAdvances(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTextAdvances", $$robo$$android_graphics_Paint$nGetTextAdvances(long long char[] int int int int int float[] int ), 1, (long)l, (long)l2, (char[])cArray, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (float[])fArray, (int)n6);
    }

    private static final native /* synthetic */ float $$robo$$nGetTextAdvances$nativeBinding(long var0, long var2, String var4, int var5, int var6, int var7, int var8, int var9, float[] var10, int var11);

    private static float nGetTextAdvances(long l, long l2, String string2, int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTextAdvances", $$robo$$android_graphics_Paint$nGetTextAdvances(long long java.lang.String int int int int int float[] int ), 1, (long)l, (long)l2, (String)string2, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (float[])fArray, (int)n6);
    }

    private final native /* synthetic */ int $$robo$$nGetTextRunCursor$nativeBinding(long var1, long var3, char[] var5, int var6, int var7, int var8, int var9, int var10);

    private int nGetTextRunCursor(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("nGetTextRunCursor", $$robo$$android_graphics_Paint$nGetTextRunCursor(long long char[] int int int int int ), 1, this, l, l2, cArray, n, n2, n3, n4, n5);
    }

    private final native /* synthetic */ int $$robo$$nGetTextRunCursor$nativeBinding(long var1, long var3, String var5, int var6, int var7, int var8, int var9, int var10);

    private int nGetTextRunCursor(long l, long l2, String string2, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("nGetTextRunCursor", $$robo$$android_graphics_Paint$nGetTextRunCursor(long long java.lang.String int int int int int ), 1, this, l, l2, string2, n, n2, n3, n4, n5);
    }

    private static final native /* synthetic */ void $$robo$$nGetTextPath$nativeBinding(long var0, long var2, int var4, char[] var5, int var6, int var7, float var8, float var9, long var10);

    private static void nGetTextPath(long l, long l2, int n, char[] cArray, int n2, int n3, float f, float f2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nGetTextPath", $$robo$$android_graphics_Paint$nGetTextPath(long long int char[] int int float float long ), 1, (long)l, (long)l2, (int)n, (char[])cArray, (int)n2, (int)n3, (float)f, (float)f2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$nGetTextPath$nativeBinding(long var0, long var2, int var4, String var5, int var6, int var7, float var8, float var9, long var10);

    private static void nGetTextPath(long l, long l2, int n, String string2, int n2, int n3, float f, float f2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nGetTextPath", $$robo$$android_graphics_Paint$nGetTextPath(long long int java.lang.String int int float float long ), 1, (long)l, (long)l2, (int)n, (String)string2, (int)n2, (int)n3, (float)f, (float)f2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$nGetStringBounds$nativeBinding(long var0, long var2, String var4, int var5, int var6, int var7, Rect var8);

    private static void nGetStringBounds(long l, long l2, String string2, int n, int n2, int n3, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nGetStringBounds", $$robo$$android_graphics_Paint$nGetStringBounds(long long java.lang.String int int int android.graphics.Rect ), 1, (long)l, (long)l2, (String)string2, (int)n, (int)n2, (int)n3, (Rect)rect);
    }

    private static final native /* synthetic */ void $$robo$$nGetCharArrayBounds$nativeBinding(long var0, long var2, char[] var4, int var5, int var6, int var7, Rect var8);

    private static void nGetCharArrayBounds(long l, long l2, char[] cArray, int n, int n2, int n3, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nGetCharArrayBounds", $$robo$$android_graphics_Paint$nGetCharArrayBounds(long long char[] int int int android.graphics.Rect ), 1, (long)l, (long)l2, (char[])cArray, (int)n, (int)n2, (int)n3, (Rect)rect);
    }

    private static final native /* synthetic */ boolean $$robo$$nHasGlyph$nativeBinding(long var0, long var2, int var4, String var5);

    private static boolean nHasGlyph(long l, long l2, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nHasGlyph", $$robo$$android_graphics_Paint$nHasGlyph(long long int java.lang.String ), 1, (long)l, (long)l2, (int)n, (String)string2);
    }

    private static final native /* synthetic */ float $$robo$$nGetRunAdvance$nativeBinding(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, boolean var9, int var10);

    private static float nGetRunAdvance(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, boolean bl, int n5) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetRunAdvance", $$robo$$android_graphics_Paint$nGetRunAdvance(long long char[] int int int int boolean int ), 1, (long)l, (long)l2, (char[])cArray, (int)n, (int)n2, (int)n3, (int)n4, (boolean)bl, (int)n5);
    }

    private static final native /* synthetic */ int $$robo$$nGetOffsetForAdvance$nativeBinding(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

    private static int nGetOffsetForAdvance(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, boolean bl, float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetOffsetForAdvance", $$robo$$android_graphics_Paint$nGetOffsetForAdvance(long long char[] int int int int boolean float ), 1, (long)l, (long)l2, (char[])cArray, (int)n, (int)n2, (int)n3, (int)n4, (boolean)bl, (float)f);
    }

    private static final native /* synthetic */ int $$robo$$nSetTextLocales$nativeBinding(long var0, String var2);

    private static int nSetTextLocales(long l, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nSetTextLocales", $$robo$$android_graphics_Paint$nSetTextLocales(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$nSetFontFeatureSettings$nativeBinding(long var0, String var2);

    private static void nSetFontFeatureSettings(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("nSetFontFeatureSettings", $$robo$$android_graphics_Paint$nSetFontFeatureSettings(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ float $$robo$$nGetFontMetrics$nativeBinding(long var0, long var2, FontMetrics var4);

    private static float nGetFontMetrics(long l, long l2, FontMetrics fontMetrics) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetFontMetrics", $$robo$$android_graphics_Paint$nGetFontMetrics(long long android.graphics.Paint$FontMetrics ), 1, (long)l, (long)l2, (FontMetrics)fontMetrics);
    }

    private static final native /* synthetic */ int $$robo$$nGetFontMetricsInt$nativeBinding(long var0, long var2, FontMetricsInt var4);

    private static int nGetFontMetricsInt(long l, long l2, FontMetricsInt fontMetricsInt) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetFontMetricsInt", $$robo$$android_graphics_Paint$nGetFontMetricsInt(long long android.graphics.Paint$FontMetricsInt ), 1, (long)l, (long)l2, (FontMetricsInt)fontMetricsInt);
    }

    private static final native /* synthetic */ void $$robo$$nReset$nativeBinding(long var0);

    private static void nReset(long l) {
        InvokeDynamicSupport.bootstrapStatic("nReset", $$robo$$android_graphics_Paint$nReset(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSet$nativeBinding(long var0, long var2);

    private static void nSet(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSet", $$robo$$android_graphics_Paint$nSet(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$nGetStyle$nativeBinding(long var0);

    private static int nGetStyle(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetStyle", $$robo$$android_graphics_Paint$nGetStyle(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetStyle$nativeBinding(long var0, int var2);

    private static void nSetStyle(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetStyle", $$robo$$android_graphics_Paint$nSetStyle(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nGetStrokeCap$nativeBinding(long var0);

    private static int nGetStrokeCap(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetStrokeCap", $$robo$$android_graphics_Paint$nGetStrokeCap(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetStrokeCap$nativeBinding(long var0, int var2);

    private static void nSetStrokeCap(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetStrokeCap", $$robo$$android_graphics_Paint$nSetStrokeCap(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nGetStrokeJoin$nativeBinding(long var0);

    private static int nGetStrokeJoin(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetStrokeJoin", $$robo$$android_graphics_Paint$nGetStrokeJoin(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetStrokeJoin$nativeBinding(long var0, int var2);

    private static void nSetStrokeJoin(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetStrokeJoin", $$robo$$android_graphics_Paint$nSetStrokeJoin(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$nGetFillPath$nativeBinding(long var0, long var2, long var4);

    private static boolean nGetFillPath(long l, long l2, long l3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nGetFillPath", $$robo$$android_graphics_Paint$nGetFillPath(long long long ), 1, (long)l, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ long $$robo$$nSetShader$nativeBinding(long var0, long var2);

    private static long nSetShader(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nSetShader", $$robo$$android_graphics_Paint$nSetShader(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$nSetColorFilter$nativeBinding(long var0, long var2);

    private static long nSetColorFilter(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nSetColorFilter", $$robo$$android_graphics_Paint$nSetColorFilter(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nSetXfermode$nativeBinding(long var0, int var2);

    private static void nSetXfermode(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetXfermode", $$robo$$android_graphics_Paint$nSetXfermode(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nSetPathEffect$nativeBinding(long var0, long var2);

    private static long nSetPathEffect(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nSetPathEffect", $$robo$$android_graphics_Paint$nSetPathEffect(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$nSetMaskFilter$nativeBinding(long var0, long var2);

    private static long nSetMaskFilter(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nSetMaskFilter", $$robo$$android_graphics_Paint$nSetMaskFilter(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$nSetTypeface$nativeBinding(long var0, long var2);

    private static long nSetTypeface(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nSetTypeface", $$robo$$android_graphics_Paint$nSetTypeface(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$nGetTextAlign$nativeBinding(long var0);

    private static int nGetTextAlign(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetTextAlign", $$robo$$android_graphics_Paint$nGetTextAlign(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetTextAlign$nativeBinding(long var0, int var2);

    private static void nSetTextAlign(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetTextAlign", $$robo$$android_graphics_Paint$nSetTextAlign(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nSetTextLocalesByMinikinLangListId$nativeBinding(long var0, int var2);

    private static void nSetTextLocalesByMinikinLangListId(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetTextLocalesByMinikinLangListId", $$robo$$android_graphics_Paint$nSetTextLocalesByMinikinLangListId(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nSetShadowLayer$nativeBinding(long var0, float var2, float var3, float var4, int var5);

    private static void nSetShadowLayer(long l, float f, float f2, float f3, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetShadowLayer", $$robo$$android_graphics_Paint$nSetShadowLayer(long float float float int ), 1, (long)l, (float)f, (float)f2, (float)f3, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$nHasShadowLayer$nativeBinding(long var0);

    private static boolean nHasShadowLayer(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nHasShadowLayer", $$robo$$android_graphics_Paint$nHasShadowLayer(long ), 1, (long)l);
    }

    private static final native /* synthetic */ float $$robo$$nGetLetterSpacing$nativeBinding(long var0);

    private static float nGetLetterSpacing(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetLetterSpacing", $$robo$$android_graphics_Paint$nGetLetterSpacing(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetLetterSpacing$nativeBinding(long var0, float var2);

    private static void nSetLetterSpacing(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetLetterSpacing", $$robo$$android_graphics_Paint$nSetLetterSpacing(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ float $$robo$$nGetWordSpacing$nativeBinding(long var0);

    private static float nGetWordSpacing(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetWordSpacing", $$robo$$android_graphics_Paint$nGetWordSpacing(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetWordSpacing$nativeBinding(long var0, float var2);

    private static void nSetWordSpacing(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetWordSpacing", $$robo$$android_graphics_Paint$nSetWordSpacing(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ int $$robo$$nGetHyphenEdit$nativeBinding(long var0);

    private static int nGetHyphenEdit(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetHyphenEdit", $$robo$$android_graphics_Paint$nGetHyphenEdit(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetHyphenEdit$nativeBinding(long var0, int var2);

    private static void nSetHyphenEdit(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetHyphenEdit", $$robo$$android_graphics_Paint$nSetHyphenEdit(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nSetStrokeMiter$nativeBinding(long var0, float var2);

    private static void nSetStrokeMiter(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetStrokeMiter", $$robo$$android_graphics_Paint$nSetStrokeMiter(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ float $$robo$$nGetStrokeMiter$nativeBinding(long var0);

    private static float nGetStrokeMiter(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetStrokeMiter", $$robo$$android_graphics_Paint$nGetStrokeMiter(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetStrokeWidth$nativeBinding(long var0, float var2);

    private static void nSetStrokeWidth(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetStrokeWidth", $$robo$$android_graphics_Paint$nSetStrokeWidth(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ float $$robo$$nGetStrokeWidth$nativeBinding(long var0);

    private static float nGetStrokeWidth(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetStrokeWidth", $$robo$$android_graphics_Paint$nGetStrokeWidth(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetAlpha$nativeBinding(long var0, int var2);

    private static void nSetAlpha(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetAlpha", $$robo$$android_graphics_Paint$nSetAlpha(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nSetDither$nativeBinding(long var0, boolean var2);

    private static void nSetDither(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetDither", $$robo$$android_graphics_Paint$nSetDither(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$nGetFlags$nativeBinding(long var0);

    private static int nGetFlags(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetFlags", $$robo$$android_graphics_Paint$nGetFlags(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetFlags$nativeBinding(long var0, int var2);

    private static void nSetFlags(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetFlags", $$robo$$android_graphics_Paint$nSetFlags(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nGetHinting$nativeBinding(long var0);

    private static int nGetHinting(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetHinting", $$robo$$android_graphics_Paint$nGetHinting(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetHinting$nativeBinding(long var0, int var2);

    private static void nSetHinting(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetHinting", $$robo$$android_graphics_Paint$nSetHinting(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nSetAntiAlias$nativeBinding(long var0, boolean var2);

    private static void nSetAntiAlias(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetAntiAlias", $$robo$$android_graphics_Paint$nSetAntiAlias(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nSetLinearText$nativeBinding(long var0, boolean var2);

    private static void nSetLinearText(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetLinearText", $$robo$$android_graphics_Paint$nSetLinearText(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nSetSubpixelText$nativeBinding(long var0, boolean var2);

    private static void nSetSubpixelText(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetSubpixelText", $$robo$$android_graphics_Paint$nSetSubpixelText(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nSetUnderlineText$nativeBinding(long var0, boolean var2);

    private static void nSetUnderlineText(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetUnderlineText", $$robo$$android_graphics_Paint$nSetUnderlineText(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nSetFakeBoldText$nativeBinding(long var0, boolean var2);

    private static void nSetFakeBoldText(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetFakeBoldText", $$robo$$android_graphics_Paint$nSetFakeBoldText(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nSetFilterBitmap$nativeBinding(long var0, boolean var2);

    private static void nSetFilterBitmap(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetFilterBitmap", $$robo$$android_graphics_Paint$nSetFilterBitmap(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$nGetColor$nativeBinding(long var0);

    private static int nGetColor(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetColor", $$robo$$android_graphics_Paint$nGetColor(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetColor$nativeBinding(long var0, int var2);

    private static void nSetColor(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetColor", $$robo$$android_graphics_Paint$nSetColor(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nGetAlpha$nativeBinding(long var0);

    private static int nGetAlpha(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetAlpha", $$robo$$android_graphics_Paint$nGetAlpha(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetStrikeThruText$nativeBinding(long var0, boolean var2);

    private static void nSetStrikeThruText(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetStrikeThruText", $$robo$$android_graphics_Paint$nSetStrikeThruText(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ boolean $$robo$$nIsElegantTextHeight$nativeBinding(long var0);

    private static boolean nIsElegantTextHeight(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nIsElegantTextHeight", $$robo$$android_graphics_Paint$nIsElegantTextHeight(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetElegantTextHeight$nativeBinding(long var0, boolean var2);

    private static void nSetElegantTextHeight(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetElegantTextHeight", $$robo$$android_graphics_Paint$nSetElegantTextHeight(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ float $$robo$$nGetTextSize$nativeBinding(long var0);

    private static float nGetTextSize(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTextSize", $$robo$$android_graphics_Paint$nGetTextSize(long ), 1, (long)l);
    }

    private static final native /* synthetic */ float $$robo$$nGetTextScaleX$nativeBinding(long var0);

    private static float nGetTextScaleX(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTextScaleX", $$robo$$android_graphics_Paint$nGetTextScaleX(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetTextScaleX$nativeBinding(long var0, float var2);

    private static void nSetTextScaleX(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetTextScaleX", $$robo$$android_graphics_Paint$nSetTextScaleX(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ float $$robo$$nGetTextSkewX$nativeBinding(long var0);

    private static float nGetTextSkewX(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTextSkewX", $$robo$$android_graphics_Paint$nGetTextSkewX(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetTextSkewX$nativeBinding(long var0, float var2);

    private static void nSetTextSkewX(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetTextSkewX", $$robo$$android_graphics_Paint$nSetTextSkewX(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ float $$robo$$nAscent$nativeBinding(long var0, long var2);

    private static float nAscent(long l, long l2) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nAscent", $$robo$$android_graphics_Paint$nAscent(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ float $$robo$$nDescent$nativeBinding(long var0, long var2);

    private static float nDescent(long l, long l2) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nDescent", $$robo$$android_graphics_Paint$nDescent(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nSetTextSize$nativeBinding(long var0, float var2);

    private static void nSetTextSize(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetTextSize", $$robo$$android_graphics_Paint$nSetTextSize(long float ), 1, (long)l, (float)f);
    }

    static {
        RobolectricInternals.classInitializing(Paint.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Paint)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FontMetricsInt
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int top;
        public int ascent;
        public int descent;
        public int bottom;
        public int leading;

        private void $$robo$$android_graphics_Paint_FontMetricsInt$__constructor__() {
        }

        private final String $$robo$$android_graphics_Paint_FontMetricsInt$toString() {
            return "FontMetricsInt: top=" + this.top + " ascent=" + this.ascent + " descent=" + this.descent + " bottom=" + this.bottom + " leading=" + this.leading;
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_Paint_FontMetricsInt$__constructor__();
        }

        public FontMetricsInt() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_FontMetricsInt$__constructor__(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_graphics_Paint_FontMetricsInt$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontMetricsInt)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class FontMetrics
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public float top;
        public float ascent;
        public float descent;
        public float bottom;
        public float leading;

        private void $$robo$$android_graphics_Paint_FontMetrics$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_Paint_FontMetrics$__constructor__();
        }

        public FontMetrics() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_FontMetrics$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontMetrics)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Align
    extends Enum<Align> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Align LEFT;
        public static /* enum */ Align CENTER;
        public static /* enum */ Align RIGHT;
        int nativeInt;
        private static /* synthetic */ Align[] $VALUES;

        private static final Align[] $$robo$$android_graphics_Paint_Align$values() {
            return (Align[])$VALUES.clone();
        }

        private static final Align $$robo$$android_graphics_Paint_Align$valueOf(String name) {
            return Enum.valueOf(Align.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Paint_Align$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            LEFT = new Align(0);
            CENTER = new Align(1);
            RIGHT = new Align(2);
            $VALUES = new Align[]{LEFT, CENTER, RIGHT};
        }

        public static Align[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Paint_Align$values(), 0);
        }

        public static Align valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Paint_Align$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Paint_Align$__constructor__(string2, n, n2);
        }

        private Align(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_Align$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Align.class);
        }

        public /* synthetic */ Align() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Align)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Join
    extends Enum<Join> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Join MITER;
        public static /* enum */ Join ROUND;
        public static /* enum */ Join BEVEL;
        int nativeInt;
        private static /* synthetic */ Join[] $VALUES;

        private static final Join[] $$robo$$android_graphics_Paint_Join$values() {
            return (Join[])$VALUES.clone();
        }

        private static final Join $$robo$$android_graphics_Paint_Join$valueOf(String name) {
            return Enum.valueOf(Join.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Paint_Join$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            MITER = new Join(0);
            ROUND = new Join(1);
            BEVEL = new Join(2);
            $VALUES = new Join[]{MITER, ROUND, BEVEL};
        }

        public static Join[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Paint_Join$values(), 0);
        }

        public static Join valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Paint_Join$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Paint_Join$__constructor__(string2, n, n2);
        }

        private Join(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_Join$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Join.class);
        }

        public /* synthetic */ Join() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Join)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Cap
    extends Enum<Cap> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Cap BUTT;
        public static /* enum */ Cap ROUND;
        public static /* enum */ Cap SQUARE;
        int nativeInt;
        private static /* synthetic */ Cap[] $VALUES;

        private static final Cap[] $$robo$$android_graphics_Paint_Cap$values() {
            return (Cap[])$VALUES.clone();
        }

        private static final Cap $$robo$$android_graphics_Paint_Cap$valueOf(String name) {
            return Enum.valueOf(Cap.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Paint_Cap$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            BUTT = new Cap(0);
            ROUND = new Cap(1);
            SQUARE = new Cap(2);
            $VALUES = new Cap[]{BUTT, ROUND, SQUARE};
        }

        public static Cap[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Paint_Cap$values(), 0);
        }

        public static Cap valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Paint_Cap$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Paint_Cap$__constructor__(string2, n, n2);
        }

        private Cap(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_Cap$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Cap.class);
        }

        public /* synthetic */ Cap() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Style
    extends Enum<Style> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Style FILL;
        public static /* enum */ Style STROKE;
        public static /* enum */ Style FILL_AND_STROKE;
        int nativeInt;
        private static /* synthetic */ Style[] $VALUES;

        private static final Style[] $$robo$$android_graphics_Paint_Style$values() {
            return (Style[])$VALUES.clone();
        }

        private static final Style $$robo$$android_graphics_Paint_Style$valueOf(String name) {
            return Enum.valueOf(Style.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Paint_Style$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            FILL = new Style(0);
            STROKE = new Style(1);
            FILL_AND_STROKE = new Style(2);
            $VALUES = new Style[]{FILL, STROKE, FILL_AND_STROKE};
        }

        public static Style[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Paint_Style$values(), 0);
        }

        public static Style valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Paint_Style$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Paint_Style$__constructor__(string2, n, n2);
        }

        private Style(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_Style$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Style.class);
        }

        public /* synthetic */ Style() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Style)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class NoImagePreloadHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static NativeAllocationRegistry sRegistry;

        private void $$robo$$android_graphics_Paint_NoImagePreloadHolder$__constructor__() {
        }

        static void __staticInitializer__() {
            sRegistry = new NativeAllocationRegistry(Paint.class.getClassLoader(), Paint.nGetNativeFinalizer(), 98L);
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_Paint_NoImagePreloadHolder$__constructor__();
        }

        private NoImagePreloadHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_NoImagePreloadHolder$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(NoImagePreloadHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoImagePreloadHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

