/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Rect
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public int left;
    public int top;
    public int right;
    public int bottom;
    public static Parcelable.Creator<Rect> CREATOR;

    private void $$robo$$android_graphics_Rect$__constructor__() {
    }

    private void $$robo$$android_graphics_Rect$__constructor__(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    private void $$robo$$android_graphics_Rect$__constructor__(Rect r) {
        if (r == null) {
            this.bottom = 0;
            this.right = 0;
            this.top = 0;
            this.left = 0;
        } else {
            this.left = r.left;
            this.top = r.top;
            this.right = r.right;
            this.bottom = r.bottom;
        }
    }

    private final boolean $$robo$$android_graphics_Rect$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rect r = (Rect)o;
        return this.left == r.left && this.top == r.top && this.right == r.right && this.bottom == r.bottom;
    }

    private final int $$robo$$android_graphics_Rect$hashCode() {
        int result = this.left;
        result = 31 * result + this.top;
        result = 31 * result + this.right;
        result = 31 * result + this.bottom;
        return result;
    }

    private final String $$robo$$android_graphics_Rect$toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("Rect(");
        sb.append(this.left);
        sb.append(", ");
        sb.append(this.top);
        sb.append(" - ");
        sb.append(this.right);
        sb.append(", ");
        sb.append(this.bottom);
        sb.append(")");
        return sb.toString();
    }

    private final String $$robo$$android_graphics_Rect$toShortString() {
        return this.toShortString(new StringBuilder(32));
    }

    private final String $$robo$$android_graphics_Rect$toShortString(StringBuilder sb) {
        sb.setLength(0);
        sb.append('[');
        sb.append(this.left);
        sb.append(',');
        sb.append(this.top);
        sb.append("][");
        sb.append(this.right);
        sb.append(',');
        sb.append(this.bottom);
        sb.append(']');
        return sb.toString();
    }

    private final String $$robo$$android_graphics_Rect$flattenToString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.left);
        sb.append(' ');
        sb.append(this.top);
        sb.append(' ');
        sb.append(this.right);
        sb.append(' ');
        sb.append(this.bottom);
        return sb.toString();
    }

    private static final Rect $$robo$$android_graphics_Rect$unflattenFromString(String str) {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        Matcher matcher = UnflattenHelper.getMatcher(str);
        if (!matcher.matches()) {
            return null;
        }
        return new Rect(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
    }

    private final void $$robo$$android_graphics_Rect$printShortString(PrintWriter pw) {
        pw.print('[');
        pw.print(this.left);
        pw.print(',');
        pw.print(this.top);
        pw.print("][");
        pw.print(this.right);
        pw.print(',');
        pw.print(this.bottom);
        pw.print(']');
    }

    private final boolean $$robo$$android_graphics_Rect$isEmpty() {
        return this.left >= this.right || this.top >= this.bottom;
    }

    private final int $$robo$$android_graphics_Rect$width() {
        return this.right - this.left;
    }

    private final int $$robo$$android_graphics_Rect$height() {
        return this.bottom - this.top;
    }

    private final int $$robo$$android_graphics_Rect$centerX() {
        return this.left + this.right >> 1;
    }

    private final int $$robo$$android_graphics_Rect$centerY() {
        return this.top + this.bottom >> 1;
    }

    private final float $$robo$$android_graphics_Rect$exactCenterX() {
        return (float)(this.left + this.right) * 0.5f;
    }

    private final float $$robo$$android_graphics_Rect$exactCenterY() {
        return (float)(this.top + this.bottom) * 0.5f;
    }

    private final void $$robo$$android_graphics_Rect$setEmpty() {
        this.bottom = 0;
        this.top = 0;
        this.right = 0;
        this.left = 0;
    }

    private final void $$robo$$android_graphics_Rect$set(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    private final void $$robo$$android_graphics_Rect$set(Rect src) {
        this.left = src.left;
        this.top = src.top;
        this.right = src.right;
        this.bottom = src.bottom;
    }

    private final void $$robo$$android_graphics_Rect$offset(int dx, int dy) {
        this.left += dx;
        this.top += dy;
        this.right += dx;
        this.bottom += dy;
    }

    private final void $$robo$$android_graphics_Rect$offsetTo(int newLeft, int newTop) {
        this.right += newLeft - this.left;
        this.bottom += newTop - this.top;
        this.left = newLeft;
        this.top = newTop;
    }

    private final void $$robo$$android_graphics_Rect$inset(int dx, int dy) {
        this.left += dx;
        this.top += dy;
        this.right -= dx;
        this.bottom -= dy;
    }

    private final void $$robo$$android_graphics_Rect$inset(Rect insets) {
        this.left += insets.left;
        this.top += insets.top;
        this.right -= insets.right;
        this.bottom -= insets.bottom;
    }

    private final void $$robo$$android_graphics_Rect$inset(int left, int top, int right, int bottom) {
        this.left += left;
        this.top += top;
        this.right -= right;
        this.bottom -= bottom;
    }

    private final boolean $$robo$$android_graphics_Rect$contains(int x, int y) {
        return this.left < this.right && this.top < this.bottom && x >= this.left && x < this.right && y >= this.top && y < this.bottom;
    }

    private final boolean $$robo$$android_graphics_Rect$contains(int left, int top, int right, int bottom) {
        return this.left < this.right && this.top < this.bottom && this.left <= left && this.top <= top && this.right >= right && this.bottom >= bottom;
    }

    private final boolean $$robo$$android_graphics_Rect$contains(Rect r) {
        return this.left < this.right && this.top < this.bottom && this.left <= r.left && this.top <= r.top && this.right >= r.right && this.bottom >= r.bottom;
    }

    private final boolean $$robo$$android_graphics_Rect$intersect(int left, int top, int right, int bottom) {
        if (this.left < right && left < this.right && this.top < bottom && top < this.bottom) {
            if (this.left < left) {
                this.left = left;
            }
            if (this.top < top) {
                this.top = top;
            }
            if (this.right > right) {
                this.right = right;
            }
            if (this.bottom > bottom) {
                this.bottom = bottom;
            }
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_Rect$intersect(Rect r) {
        return this.intersect(r.left, r.top, r.right, r.bottom);
    }

    private final boolean $$robo$$android_graphics_Rect$setIntersect(Rect a, Rect b) {
        if (a.left < b.right && b.left < a.right && a.top < b.bottom && b.top < a.bottom) {
            this.left = Math.max(a.left, b.left);
            this.top = Math.max(a.top, b.top);
            this.right = Math.min(a.right, b.right);
            this.bottom = Math.min(a.bottom, b.bottom);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_Rect$intersects(int left, int top, int right, int bottom) {
        return this.left < right && left < this.right && this.top < bottom && top < this.bottom;
    }

    private static final boolean $$robo$$android_graphics_Rect$intersects(Rect a, Rect b) {
        return a.left < b.right && b.left < a.right && a.top < b.bottom && b.top < a.bottom;
    }

    private final void $$robo$$android_graphics_Rect$union(int left, int top, int right, int bottom) {
        if (left < right && top < bottom) {
            if (this.left < this.right && this.top < this.bottom) {
                if (this.left > left) {
                    this.left = left;
                }
                if (this.top > top) {
                    this.top = top;
                }
                if (this.right < right) {
                    this.right = right;
                }
                if (this.bottom < bottom) {
                    this.bottom = bottom;
                }
            } else {
                this.left = left;
                this.top = top;
                this.right = right;
                this.bottom = bottom;
            }
        }
    }

    private final void $$robo$$android_graphics_Rect$union(Rect r) {
        this.union(r.left, r.top, r.right, r.bottom);
    }

    private final void $$robo$$android_graphics_Rect$union(int x, int y) {
        if (x < this.left) {
            this.left = x;
        } else if (x > this.right) {
            this.right = x;
        }
        if (y < this.top) {
            this.top = y;
        } else if (y > this.bottom) {
            this.bottom = y;
        }
    }

    private final void $$robo$$android_graphics_Rect$sort() {
        int temp;
        if (this.left > this.right) {
            temp = this.left;
            this.left = this.right;
            this.right = temp;
        }
        if (this.top > this.bottom) {
            temp = this.top;
            this.top = this.bottom;
            this.bottom = temp;
        }
    }

    private final int $$robo$$android_graphics_Rect$describeContents() {
        return 0;
    }

    private final void $$robo$$android_graphics_Rect$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.left);
        out.writeInt(this.top);
        out.writeInt(this.right);
        out.writeInt(this.bottom);
    }

    private final void $$robo$$android_graphics_Rect$readFromParcel(Parcel in) {
        this.left = in.readInt();
        this.top = in.readInt();
        this.right = in.readInt();
        this.bottom = in.readInt();
    }

    private final void $$robo$$android_graphics_Rect$scale(float scale) {
        if (scale != 1.0f) {
            this.left = (int)((float)this.left * scale + 0.5f);
            this.top = (int)((float)this.top * scale + 0.5f);
            this.right = (int)((float)this.right * scale + 0.5f);
            this.bottom = (int)((float)this.bottom * scale + 0.5f);
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Rect>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_Rect_1$__constructor__() {
            }

            private final Rect $$robo$$android_graphics_Rect_1$createFromParcel(Parcel in) {
                Rect r = new Rect();
                r.readFromParcel(in);
                return r;
            }

            private final Rect[] $$robo$$android_graphics_Rect_1$newArray(int size) {
                return new Rect[size];
            }

            private void __constructor__() {
                this.$$robo$$android_graphics_Rect_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Rect_1$__constructor__(), 0, this);
            }

            @Override
            public Rect createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_graphics_Rect_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Rect[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_graphics_Rect_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Rect$__constructor__();
    }

    public Rect() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Rect$__constructor__(), 0, this);
    }

    private void __constructor__(int n, int n2, int n3, int n4) {
        this.$$robo$$android_graphics_Rect$__constructor__(n, n2, n3, n4);
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Rect$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
    }

    private void __constructor__(Rect rect) {
        this.$$robo$$android_graphics_Rect$__constructor__(rect);
    }

    public Rect(Rect rect) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Rect$__constructor__(android.graphics.Rect ), 0, this, rect);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_graphics_Rect$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_graphics_Rect$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_graphics_Rect$toString(), 0, this);
    }

    public String toShortString() {
        return InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_graphics_Rect$toShortString(), 0, this);
    }

    public String toShortString(StringBuilder stringBuilder) {
        return InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_graphics_Rect$toShortString(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    public String flattenToString() {
        return InvokeDynamicSupport.bootstrap("flattenToString", $$robo$$android_graphics_Rect$flattenToString(), 0, this);
    }

    public static Rect unflattenFromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("unflattenFromString", $$robo$$android_graphics_Rect$unflattenFromString(java.lang.String ), 0, (String)string2);
    }

    public void printShortString(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("printShortString", $$robo$$android_graphics_Rect$printShortString(java.io.PrintWriter ), 0, this, printWriter);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_graphics_Rect$isEmpty(), 0, this);
    }

    public int width() {
        return (int)InvokeDynamicSupport.bootstrap("width", $$robo$$android_graphics_Rect$width(), 0, this);
    }

    public int height() {
        return (int)InvokeDynamicSupport.bootstrap("height", $$robo$$android_graphics_Rect$height(), 0, this);
    }

    public int centerX() {
        return (int)InvokeDynamicSupport.bootstrap("centerX", $$robo$$android_graphics_Rect$centerX(), 0, this);
    }

    public int centerY() {
        return (int)InvokeDynamicSupport.bootstrap("centerY", $$robo$$android_graphics_Rect$centerY(), 0, this);
    }

    public float exactCenterX() {
        return (float)InvokeDynamicSupport.bootstrap("exactCenterX", $$robo$$android_graphics_Rect$exactCenterX(), 0, this);
    }

    public float exactCenterY() {
        return (float)InvokeDynamicSupport.bootstrap("exactCenterY", $$robo$$android_graphics_Rect$exactCenterY(), 0, this);
    }

    public void setEmpty() {
        InvokeDynamicSupport.bootstrap("setEmpty", $$robo$$android_graphics_Rect$setEmpty(), 0, this);
    }

    public void set(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_graphics_Rect$set(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void set(Rect rect) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_graphics_Rect$set(android.graphics.Rect ), 0, this, rect);
    }

    public void offset(int n, int n2) {
        InvokeDynamicSupport.bootstrap("offset", $$robo$$android_graphics_Rect$offset(int int ), 0, this, n, n2);
    }

    public void offsetTo(int n, int n2) {
        InvokeDynamicSupport.bootstrap("offsetTo", $$robo$$android_graphics_Rect$offsetTo(int int ), 0, this, n, n2);
    }

    public void inset(int n, int n2) {
        InvokeDynamicSupport.bootstrap("inset", $$robo$$android_graphics_Rect$inset(int int ), 0, this, n, n2);
    }

    public void inset(Rect rect) {
        InvokeDynamicSupport.bootstrap("inset", $$robo$$android_graphics_Rect$inset(android.graphics.Rect ), 0, this, rect);
    }

    public void inset(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("inset", $$robo$$android_graphics_Rect$inset(int int int int ), 0, this, n, n2, n3, n4);
    }

    public boolean contains(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_graphics_Rect$contains(int int ), 0, this, n, n2);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_graphics_Rect$contains(int int int int ), 0, this, n, n2, n3, n4);
    }

    public boolean contains(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_graphics_Rect$contains(android.graphics.Rect ), 0, this, rect);
    }

    public boolean intersect(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("intersect", $$robo$$android_graphics_Rect$intersect(int int int int ), 0, this, n, n2, n3, n4);
    }

    public boolean intersect(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("intersect", $$robo$$android_graphics_Rect$intersect(android.graphics.Rect ), 0, this, rect);
    }

    public boolean setIntersect(Rect rect, Rect rect2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setIntersect", $$robo$$android_graphics_Rect$setIntersect(android.graphics.Rect android.graphics.Rect ), 0, this, rect, rect2);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("intersects", $$robo$$android_graphics_Rect$intersects(int int int int ), 0, this, n, n2, n3, n4);
    }

    public static boolean intersects(Rect rect, Rect rect2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("intersects", $$robo$$android_graphics_Rect$intersects(android.graphics.Rect android.graphics.Rect ), 0, (Rect)rect, (Rect)rect2);
    }

    public void union(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("union", $$robo$$android_graphics_Rect$union(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void union(Rect rect) {
        InvokeDynamicSupport.bootstrap("union", $$robo$$android_graphics_Rect$union(android.graphics.Rect ), 0, this, rect);
    }

    public void union(int n, int n2) {
        InvokeDynamicSupport.bootstrap("union", $$robo$$android_graphics_Rect$union(int int ), 0, this, n, n2);
    }

    public void sort() {
        InvokeDynamicSupport.bootstrap("sort", $$robo$$android_graphics_Rect$sort(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_graphics_Rect$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_graphics_Rect$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_graphics_Rect$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    public void scale(float f) {
        InvokeDynamicSupport.bootstrap("scale", $$robo$$android_graphics_Rect$scale(float ), 0, this, f);
    }

    static {
        RobolectricInternals.classInitializing(Rect.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Rect)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class UnflattenHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static Pattern FLATTENED_PATTERN;

        private void $$robo$$android_graphics_Rect_UnflattenHelper$__constructor__() {
        }

        private static final Matcher $$robo$$android_graphics_Rect_UnflattenHelper$getMatcher(String str) {
            return FLATTENED_PATTERN.matcher(str);
        }

        static void __staticInitializer__() {
            FLATTENED_PATTERN = Pattern.compile("(-?\\d+) (-?\\d+) (-?\\d+) (-?\\d+)");
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_Rect_UnflattenHelper$__constructor__();
        }

        private UnflattenHelper() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Rect_UnflattenHelper$__constructor__(), 0, this);
        }

        static Matcher getMatcher(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getMatcher", $$robo$$android_graphics_Rect_UnflattenHelper$getMatcher(java.lang.String ), 0, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(UnflattenHelper.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnflattenHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

