/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BitmapDrawable
extends Drawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DEFAULT_PAINT_FLAGS = 6;
    private static int TILE_MODE_UNDEFINED = -2;
    private static int TILE_MODE_DISABLED = -1;
    private static int TILE_MODE_CLAMP = 0;
    private static int TILE_MODE_REPEAT = 1;
    private static int TILE_MODE_MIRROR = 2;
    private Rect mDstRect;
    private BitmapState mBitmapState;
    private PorterDuffColorFilter mTintFilter;
    private int mTargetDensity;
    private boolean mDstRectAndInsetsDirty;
    private boolean mMutated;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private Insets mOpticalInsets;
    private Matrix mMirrorMatrix;

    @Deprecated
    private void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__() {
        this.mDstRect = new Rect();
        this.mTargetDensity = 160;
        this.mDstRectAndInsetsDirty = true;
        this.mOpticalInsets = Insets.NONE;
        this.mBitmapState = new BitmapState((Bitmap)null);
    }

    @Deprecated
    private void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(Resources res) {
        this.mDstRect = new Rect();
        this.mTargetDensity = 160;
        this.mDstRectAndInsetsDirty = true;
        this.mOpticalInsets = Insets.NONE;
        this.mBitmapState = new BitmapState((Bitmap)null);
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
    }

    @Deprecated
    private void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(Bitmap bitmap) {
    }

    private void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(Resources res, Bitmap bitmap) {
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
    }

    @Deprecated
    private void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(String filepath) {
        if (this.mBitmapState.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + filepath);
        }
    }

    private void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(Resources res, String filepath) {
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
        if (this.mBitmapState.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + filepath);
        }
    }

    @Deprecated
    private void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(InputStream is) {
        if (this.mBitmapState.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + is);
        }
    }

    private void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(Resources res, InputStream is) {
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
        if (this.mBitmapState.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + is);
        }
    }

    private final Paint $$robo$$android_graphics_drawable_BitmapDrawable$getPaint() {
        return this.mBitmapState.mPaint;
    }

    private final Bitmap $$robo$$android_graphics_drawable_BitmapDrawable$getBitmap() {
        return this.mBitmapState.mBitmap;
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$computeBitmapSize() {
        Bitmap bitmap = this.mBitmapState.mBitmap;
        if (bitmap != null) {
            this.mBitmapWidth = bitmap.getScaledWidth(this.mTargetDensity);
            this.mBitmapHeight = bitmap.getScaledHeight(this.mTargetDensity);
        } else {
            this.mBitmapHeight = -1;
            this.mBitmapWidth = -1;
        }
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setBitmap(Bitmap bitmap) {
        if (this.mBitmapState.mBitmap != bitmap) {
            this.mBitmapState.mBitmap = bitmap;
            this.computeBitmapSize();
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setTargetDensity(DisplayMetrics metrics) {
        this.setTargetDensity(metrics.densityDpi);
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setTargetDensity(int density) {
        if (this.mTargetDensity != density) {
            int n = this.mTargetDensity = density == 0 ? 160 : density;
            if (this.mBitmapState.mBitmap != null) {
                this.computeBitmapSize();
            }
            this.invalidateSelf();
        }
    }

    private final int $$robo$$android_graphics_drawable_BitmapDrawable$getGravity() {
        return this.mBitmapState.mGravity;
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setGravity(int gravity) {
        if (this.mBitmapState.mGravity != gravity) {
            this.mBitmapState.mGravity = gravity;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setMipMap(boolean mipMap) {
        if (this.mBitmapState.mBitmap != null) {
            this.mBitmapState.mBitmap.setHasMipMap(mipMap);
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_BitmapDrawable$hasMipMap() {
        return this.mBitmapState.mBitmap != null && this.mBitmapState.mBitmap.hasMipMap();
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setAntiAlias(boolean aa) {
        this.mBitmapState.mPaint.setAntiAlias(aa);
        this.invalidateSelf();
    }

    private final boolean $$robo$$android_graphics_drawable_BitmapDrawable$hasAntiAlias() {
        return this.mBitmapState.mPaint.isAntiAlias();
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setFilterBitmap(boolean filter) {
        this.mBitmapState.mPaint.setFilterBitmap(filter);
        this.invalidateSelf();
    }

    private final boolean $$robo$$android_graphics_drawable_BitmapDrawable$isFilterBitmap() {
        return this.mBitmapState.mPaint.isFilterBitmap();
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setDither(boolean dither) {
        this.mBitmapState.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    private final Shader.TileMode $$robo$$android_graphics_drawable_BitmapDrawable$getTileModeX() {
        return this.mBitmapState.mTileModeX;
    }

    private final Shader.TileMode $$robo$$android_graphics_drawable_BitmapDrawable$getTileModeY() {
        return this.mBitmapState.mTileModeY;
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setTileModeX(Shader.TileMode mode) {
        this.setTileModeXY(mode, this.mBitmapState.mTileModeY);
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setTileModeY(Shader.TileMode mode) {
        this.setTileModeXY(this.mBitmapState.mTileModeX, mode);
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setTileModeXY(Shader.TileMode xmode, Shader.TileMode ymode) {
        BitmapState state = this.mBitmapState;
        if (state.mTileModeX != xmode || state.mTileModeY != ymode) {
            state.mTileModeX = xmode;
            state.mTileModeY = ymode;
            state.mRebuildShader = true;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setAutoMirrored(boolean mirrored) {
        if (this.mBitmapState.mAutoMirrored != mirrored) {
            this.mBitmapState.mAutoMirrored = mirrored;
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_BitmapDrawable$isAutoMirrored() {
        return this.mBitmapState.mAutoMirrored;
    }

    private final int $$robo$$android_graphics_drawable_BitmapDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mBitmapState.getChangingConfigurations();
    }

    private final boolean $$robo$$android_graphics_drawable_BitmapDrawable$needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$onBoundsChange(Rect bounds) {
        this.mDstRectAndInsetsDirty = true;
        Bitmap bitmap = this.mBitmapState.mBitmap;
        Shader shader = this.mBitmapState.mPaint.getShader();
        if (bitmap != null && shader != null) {
            this.updateShaderMatrix(bitmap, this.mBitmapState.mPaint, shader, this.needMirroring());
        }
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$draw(Canvas canvas) {
        boolean clearColorFilter;
        int restoreAlpha;
        Bitmap bitmap = this.mBitmapState.mBitmap;
        if (bitmap == null) {
            return;
        }
        BitmapState state = this.mBitmapState;
        Paint paint = state.mPaint;
        if (state.mRebuildShader) {
            Shader.TileMode tmx = state.mTileModeX;
            Shader.TileMode tmy = state.mTileModeY;
            if (tmx == null && tmy == null) {
                paint.setShader(null);
            } else {
                paint.setShader(new BitmapShader(bitmap, tmx == null ? Shader.TileMode.CLAMP : tmx, tmy == null ? Shader.TileMode.CLAMP : tmy));
            }
            state.mRebuildShader = false;
        }
        if (state.mBaseAlpha != 1.0f) {
            Paint p = this.getPaint();
            restoreAlpha = p.getAlpha();
            p.setAlpha((int)((float)restoreAlpha * state.mBaseAlpha + 0.5f));
        } else {
            restoreAlpha = -1;
        }
        if (this.mTintFilter != null && paint.getColorFilter() == null) {
            paint.setColorFilter(this.mTintFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        this.updateDstRectAndInsetsIfDirty();
        Shader shader = paint.getShader();
        boolean needMirroring = this.needMirroring();
        if (shader == null) {
            if (needMirroring) {
                canvas.save();
                canvas.translate(this.mDstRect.right - this.mDstRect.left, 0.0f);
                canvas.scale(-1.0f, 1.0f);
            }
            canvas.drawBitmap(bitmap, null, this.mDstRect, paint);
            if (needMirroring) {
                canvas.restore();
            }
        } else {
            this.updateShaderMatrix(bitmap, paint, shader, needMirroring);
            canvas.drawRect(this.mDstRect, paint);
        }
        if (clearColorFilter) {
            paint.setColorFilter(null);
        }
        if (restoreAlpha >= 0) {
            paint.setAlpha(restoreAlpha);
        }
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$updateShaderMatrix(Bitmap bitmap, Paint paint, Shader shader, boolean needMirroring) {
        boolean needScaling;
        int sourceDensity = bitmap.getDensity();
        int targetDensity = this.mTargetDensity;
        boolean bl = needScaling = sourceDensity != 0 && sourceDensity != targetDensity;
        if (needScaling || needMirroring) {
            Matrix matrix = this.getOrCreateMirrorMatrix();
            matrix.reset();
            if (needMirroring) {
                int dx = this.mDstRect.right - this.mDstRect.left;
                matrix.setTranslate(dx, 0.0f);
                matrix.setScale(-1.0f, 1.0f);
            }
            if (needScaling) {
                float densityScale = (float)targetDensity / (float)sourceDensity;
                matrix.postScale(densityScale, densityScale);
            }
            shader.setLocalMatrix(matrix);
        } else {
            this.mMirrorMatrix = null;
            shader.setLocalMatrix(Matrix.IDENTITY_MATRIX);
        }
        paint.setShader(shader);
    }

    private final Matrix $$robo$$android_graphics_drawable_BitmapDrawable$getOrCreateMirrorMatrix() {
        if (this.mMirrorMatrix == null) {
            this.mMirrorMatrix = new Matrix();
        }
        return this.mMirrorMatrix;
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$updateDstRectAndInsetsIfDirty() {
        if (this.mDstRectAndInsetsDirty) {
            if (this.mBitmapState.mTileModeX == null && this.mBitmapState.mTileModeY == null) {
                Rect bounds = this.getBounds();
                int layoutDirection = this.getLayoutDirection();
                Gravity.apply(this.mBitmapState.mGravity, this.mBitmapWidth, this.mBitmapHeight, bounds, this.mDstRect, layoutDirection);
                int left = this.mDstRect.left - bounds.left;
                int top = this.mDstRect.top - bounds.top;
                int right = bounds.right - this.mDstRect.right;
                int bottom = bounds.bottom - this.mDstRect.bottom;
                this.mOpticalInsets = Insets.of(left, top, right, bottom);
            } else {
                this.copyBounds(this.mDstRect);
                this.mOpticalInsets = Insets.NONE;
            }
        }
        this.mDstRectAndInsetsDirty = false;
    }

    private final Insets $$robo$$android_graphics_drawable_BitmapDrawable$getOpticalInsets() {
        this.updateDstRectAndInsetsIfDirty();
        return this.mOpticalInsets;
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$getOutline(Outline outline) {
        this.updateDstRectAndInsetsIfDirty();
        outline.setRect(this.mDstRect);
        boolean opaqueOverShape = this.mBitmapState.mBitmap != null && !this.mBitmapState.mBitmap.hasAlpha();
        outline.setAlpha(opaqueOverShape ? (float)this.getAlpha() / 255.0f : 0.0f);
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setAlpha(int alpha) {
        int oldAlpha = this.mBitmapState.mPaint.getAlpha();
        if (alpha != oldAlpha) {
            this.mBitmapState.mPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    private final int $$robo$$android_graphics_drawable_BitmapDrawable$getAlpha() {
        return this.mBitmapState.mPaint.getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setColorFilter(ColorFilter colorFilter) {
        this.mBitmapState.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    private final ColorFilter $$robo$$android_graphics_drawable_BitmapDrawable$getColorFilter() {
        return this.mBitmapState.mPaint.getColorFilter();
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setTintList(ColorStateList tint) {
        BitmapState state = this.mBitmapState;
        if (state.mTint != tint) {
            state.mTint = tint;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, this.mBitmapState.mTintMode);
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setTintMode(PorterDuff.Mode tintMode) {
        BitmapState state = this.mBitmapState;
        if (state.mTintMode != tintMode) {
            state.mTintMode = tintMode;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mBitmapState.mTint, tintMode);
            this.invalidateSelf();
        }
    }

    private final ColorStateList $$robo$$android_graphics_drawable_BitmapDrawable$getTint() {
        return this.mBitmapState.mTint;
    }

    private final PorterDuff.Mode $$robo$$android_graphics_drawable_BitmapDrawable$getTintMode() {
        return this.mBitmapState.mTintMode;
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$setXfermode(Xfermode xfermode) {
        this.mBitmapState.mPaint.setXfermode(xfermode);
        this.invalidateSelf();
    }

    private final Drawable $$robo$$android_graphics_drawable_BitmapDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mBitmapState = new BitmapState(this.mBitmapState);
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    private final boolean $$robo$$android_graphics_drawable_BitmapDrawable$onStateChange(int[] stateSet) {
        BitmapState state = this.mBitmapState;
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_BitmapDrawable$isStateful() {
        return this.mBitmapState.mTint != null && this.mBitmapState.mTint.isStateful() || super.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_BitmapDrawable$hasFocusStateSpecified() {
        return this.mBitmapState.mTint != null && this.mBitmapState.mTint.hasFocusStateSpecified();
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = BitmapDrawable.obtainAttributes(r, theme, attrs, R.styleable.BitmapDrawable);
        this.updateStateFromTypedArray(a, this.mSrcDensityOverride);
        this.verifyRequiredAttributes(a);
        a.recycle();
        this.updateLocalState(r);
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        BitmapState state = this.mBitmapState;
        if (state.mBitmap == null && (state.mThemeAttrs == null || state.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <bitmap> requires a valid 'src' attribute");
        }
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$updateStateFromTypedArray(TypedArray a, int srcDensityOverride) throws XmlPullParserException {
        int tileModeY;
        int tileModeX;
        ColorStateList tint;
        Resources r = a.getResources();
        BitmapState state = this.mBitmapState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mSrcDensityOverride = srcDensityOverride;
        state.mTargetDensity = Drawable.resolveDensity(r, 0);
        int srcResId = a.getResourceId(1, 0);
        if (srcResId != 0) {
            TypedValue value = new TypedValue();
            r.getValueForDensity(srcResId, srcDensityOverride, value, true);
            if (srcDensityOverride > 0 && value.density > 0 && value.density != 65535) {
                value.density = value.density == srcDensityOverride ? r.getDisplayMetrics().densityDpi : value.density * r.getDisplayMetrics().densityDpi / srcDensityOverride;
            }
            Bitmap bitmap = null;
            try (InputStream is2 = r.openRawResource(srcResId, value);){
                bitmap = BitmapFactory.decodeResourceStream(r, value, is2, null, null);
            }
            catch (Exception is2) {
                // empty catch block
            }
            if (bitmap == null) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <bitmap> requires a valid 'src' attribute");
            }
            state.mBitmap = bitmap;
        }
        boolean defMipMap = state.mBitmap != null ? state.mBitmap.hasMipMap() : false;
        this.setMipMap(a.getBoolean(8, defMipMap));
        state.mAutoMirrored = a.getBoolean(9, state.mAutoMirrored);
        state.mBaseAlpha = a.getFloat(7, state.mBaseAlpha);
        int tintMode = a.getInt(10, -1);
        if (tintMode != -1) {
            state.mTintMode = Drawable.parseTintMode(tintMode, PorterDuff.Mode.SRC_IN);
        }
        if ((tint = a.getColorStateList(5)) != null) {
            state.mTint = tint;
        }
        Paint paint = this.mBitmapState.mPaint;
        paint.setAntiAlias(a.getBoolean(2, paint.isAntiAlias()));
        paint.setFilterBitmap(a.getBoolean(3, paint.isFilterBitmap()));
        paint.setDither(a.getBoolean(4, paint.isDither()));
        this.setGravity(a.getInt(0, state.mGravity));
        int tileMode = a.getInt(6, -2);
        if (tileMode != -2) {
            Shader.TileMode mode = BitmapDrawable.parseTileMode(tileMode);
            this.setTileModeXY(mode, mode);
        }
        if ((tileModeX = a.getInt(11, -2)) != -2) {
            this.setTileModeX(BitmapDrawable.parseTileMode(tileModeX));
        }
        if ((tileModeY = a.getInt(12, -2)) != -2) {
            this.setTileModeY(BitmapDrawable.parseTileMode(tileModeY));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_BitmapDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        BitmapState state = this.mBitmapState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.BitmapDrawable);
            try {
                this.updateStateFromTypedArray(a, state.mSrcDensityOverride);
            }
            catch (XmlPullParserException e) {
                BitmapDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        this.updateLocalState(t.getResources());
    }

    private static final Shader.TileMode $$robo$$android_graphics_drawable_BitmapDrawable$parseTileMode(int tileMode) {
        switch (tileMode) {
            case 0: {
                return Shader.TileMode.CLAMP;
            }
            case 1: {
                return Shader.TileMode.REPEAT;
            }
            case 2: {
                return Shader.TileMode.MIRROR;
            }
        }
        return null;
    }

    private final boolean $$robo$$android_graphics_drawable_BitmapDrawable$canApplyTheme() {
        return this.mBitmapState != null && this.mBitmapState.canApplyTheme();
    }

    private final int $$robo$$android_graphics_drawable_BitmapDrawable$getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    private final int $$robo$$android_graphics_drawable_BitmapDrawable$getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    private final int $$robo$$android_graphics_drawable_BitmapDrawable$getOpacity() {
        if (this.mBitmapState.mGravity != 119) {
            return -3;
        }
        Bitmap bitmap = this.mBitmapState.mBitmap;
        return bitmap == null || bitmap.hasAlpha() || this.mBitmapState.mPaint.getAlpha() < 255 ? -3 : -1;
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_BitmapDrawable$getConstantState() {
        this.mBitmapState.mChangingConfigurations |= this.getChangingConfigurations();
        return this.mBitmapState;
    }

    private void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(BitmapState state, Resources res) {
        this.mDstRect = new Rect();
        this.mTargetDensity = 160;
        this.mDstRectAndInsetsDirty = true;
        this.mOpticalInsets = Insets.NONE;
        this.mBitmapState = state;
        this.updateLocalState(res);
    }

    private final void $$robo$$android_graphics_drawable_BitmapDrawable$updateLocalState(Resources res) {
        this.mTargetDensity = BitmapDrawable.resolveDensity(res, this.mBitmapState.mTargetDensity);
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mBitmapState.mTint, this.mBitmapState.mTintMode);
        this.computeBitmapSize();
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(BitmapState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__();
    }

    public BitmapDrawable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Resources resources) {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(resources);
    }

    public BitmapDrawable(Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(android.content.res.Resources ), 0, this, resources);
    }

    private void __constructor__(Bitmap bitmap) {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(bitmap);
    }

    public BitmapDrawable(Bitmap bitmap) {
        this(new BitmapState(bitmap), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(android.graphics.Bitmap ), 0, this, bitmap);
    }

    private void __constructor__(Resources resources, Bitmap bitmap) {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(resources, bitmap);
    }

    public BitmapDrawable(Resources resources, Bitmap bitmap) {
        this(new BitmapState(bitmap), resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(android.content.res.Resources android.graphics.Bitmap ), 0, this, resources, bitmap);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(string2);
    }

    public BitmapDrawable(String string2) {
        this(new BitmapState(BitmapFactory.decodeFile(string2)), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(Resources resources, String string2) {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(resources, string2);
    }

    public BitmapDrawable(Resources resources, String string2) {
        this(new BitmapState(BitmapFactory.decodeFile(string2)), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(android.content.res.Resources java.lang.String ), 0, this, resources, string2);
    }

    private void __constructor__(InputStream inputStream) {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(inputStream);
    }

    public BitmapDrawable(InputStream inputStream) {
        this(new BitmapState(BitmapFactory.decodeStream(inputStream)), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(java.io.InputStream ), 0, this, inputStream);
    }

    private void __constructor__(Resources resources, InputStream inputStream) {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(resources, inputStream);
    }

    public BitmapDrawable(Resources resources, InputStream inputStream) {
        this(new BitmapState(BitmapFactory.decodeStream(inputStream)), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(android.content.res.Resources java.io.InputStream ), 0, this, resources, inputStream);
    }

    public Paint getPaint() {
        return InvokeDynamicSupport.bootstrap("getPaint", $$robo$$android_graphics_drawable_BitmapDrawable$getPaint(), 0, this);
    }

    public Bitmap getBitmap() {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_graphics_drawable_BitmapDrawable$getBitmap(), 0, this);
    }

    private void computeBitmapSize() {
        InvokeDynamicSupport.bootstrap("computeBitmapSize", $$robo$$android_graphics_drawable_BitmapDrawable$computeBitmapSize(), 0, this);
    }

    public void setBitmap(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_graphics_drawable_BitmapDrawable$setBitmap(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public void setTargetDensity(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_BitmapDrawable$setTargetDensity(android.graphics.Canvas ), 0, this, canvas);
    }

    public void setTargetDensity(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_BitmapDrawable$setTargetDensity(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public void setTargetDensity(int n) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_BitmapDrawable$setTargetDensity(int ), 0, this, n);
    }

    public int getGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_graphics_drawable_BitmapDrawable$getGravity(), 0, this);
    }

    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_graphics_drawable_BitmapDrawable$setGravity(int ), 0, this, n);
    }

    public void setMipMap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMipMap", $$robo$$android_graphics_drawable_BitmapDrawable$setMipMap(boolean ), 0, this, bl);
    }

    public boolean hasMipMap() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMipMap", $$robo$$android_graphics_drawable_BitmapDrawable$hasMipMap(), 0, this);
    }

    public void setAntiAlias(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAntiAlias", $$robo$$android_graphics_drawable_BitmapDrawable$setAntiAlias(boolean ), 0, this, bl);
    }

    public boolean hasAntiAlias() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAntiAlias", $$robo$$android_graphics_drawable_BitmapDrawable$hasAntiAlias(), 0, this);
    }

    @Override
    public void setFilterBitmap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFilterBitmap", $$robo$$android_graphics_drawable_BitmapDrawable$setFilterBitmap(boolean ), 0, this, bl);
    }

    @Override
    public boolean isFilterBitmap() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFilterBitmap", $$robo$$android_graphics_drawable_BitmapDrawable$isFilterBitmap(), 0, this);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_BitmapDrawable$setDither(boolean ), 0, this, bl);
    }

    public Shader.TileMode getTileModeX() {
        return InvokeDynamicSupport.bootstrap("getTileModeX", $$robo$$android_graphics_drawable_BitmapDrawable$getTileModeX(), 0, this);
    }

    public Shader.TileMode getTileModeY() {
        return InvokeDynamicSupport.bootstrap("getTileModeY", $$robo$$android_graphics_drawable_BitmapDrawable$getTileModeY(), 0, this);
    }

    public void setTileModeX(Shader.TileMode tileMode) {
        InvokeDynamicSupport.bootstrap("setTileModeX", $$robo$$android_graphics_drawable_BitmapDrawable$setTileModeX(android.graphics.Shader$TileMode ), 0, this, tileMode);
    }

    public void setTileModeY(Shader.TileMode tileMode) {
        InvokeDynamicSupport.bootstrap("setTileModeY", $$robo$$android_graphics_drawable_BitmapDrawable$setTileModeY(android.graphics.Shader$TileMode ), 0, this, tileMode);
    }

    public void setTileModeXY(Shader.TileMode tileMode, Shader.TileMode tileMode2) {
        InvokeDynamicSupport.bootstrap("setTileModeXY", $$robo$$android_graphics_drawable_BitmapDrawable$setTileModeXY(android.graphics.Shader$TileMode android.graphics.Shader$TileMode ), 0, this, tileMode, tileMode2);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_BitmapDrawable$setAutoMirrored(boolean ), 0, this, bl);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_BitmapDrawable$isAutoMirrored(), 0, this);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_BitmapDrawable$getChangingConfigurations(), 0, this);
    }

    private boolean needMirroring() {
        return (boolean)InvokeDynamicSupport.bootstrap("needMirroring", $$robo$$android_graphics_drawable_BitmapDrawable$needMirroring(), 0, this);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_BitmapDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_BitmapDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    private void updateShaderMatrix(Bitmap bitmap, Paint paint, Shader shader, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateShaderMatrix", $$robo$$android_graphics_drawable_BitmapDrawable$updateShaderMatrix(android.graphics.Bitmap android.graphics.Paint android.graphics.Shader boolean ), 0, this, bitmap, paint, shader, bl);
    }

    private Matrix getOrCreateMirrorMatrix() {
        return InvokeDynamicSupport.bootstrap("getOrCreateMirrorMatrix", $$robo$$android_graphics_drawable_BitmapDrawable$getOrCreateMirrorMatrix(), 0, this);
    }

    private void updateDstRectAndInsetsIfDirty() {
        InvokeDynamicSupport.bootstrap("updateDstRectAndInsetsIfDirty", $$robo$$android_graphics_drawable_BitmapDrawable$updateDstRectAndInsetsIfDirty(), 0, this);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_BitmapDrawable$getOpticalInsets(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_BitmapDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_BitmapDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_BitmapDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_BitmapDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_drawable_BitmapDrawable$getColorFilter(), 0, this);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_BitmapDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_BitmapDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public ColorStateList getTint() {
        return InvokeDynamicSupport.bootstrap("getTint", $$robo$$android_graphics_drawable_BitmapDrawable$getTint(), 0, this);
    }

    public PorterDuff.Mode getTintMode() {
        return InvokeDynamicSupport.bootstrap("getTintMode", $$robo$$android_graphics_drawable_BitmapDrawable$getTintMode(), 0, this);
    }

    @Override
    public void setXfermode(Xfermode xfermode) {
        InvokeDynamicSupport.bootstrap("setXfermode", $$robo$$android_graphics_drawable_BitmapDrawable$setXfermode(android.graphics.Xfermode ), 0, this, xfermode);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_BitmapDrawable$mutate(), 0, this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_BitmapDrawable$clearMutated(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_BitmapDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_BitmapDrawable$isStateful(), 0, this);
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_BitmapDrawable$hasFocusStateSpecified(), 0, this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_BitmapDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_BitmapDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateStateFromTypedArray(TypedArray typedArray, int n) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_BitmapDrawable$updateStateFromTypedArray(android.content.res.TypedArray int ), 0, this, typedArray, n);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_BitmapDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private static Shader.TileMode parseTileMode(int n) {
        return InvokeDynamicSupport.bootstrapStatic("parseTileMode", $$robo$$android_graphics_drawable_BitmapDrawable$parseTileMode(int ), 0, (int)n);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_BitmapDrawable$canApplyTheme(), 0, this);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_BitmapDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_BitmapDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_BitmapDrawable$getOpacity(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_BitmapDrawable$getConstantState(), 0, this);
    }

    private void __constructor__(BitmapState bitmapState, Resources resources) {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(bitmapState, resources);
    }

    private BitmapDrawable(BitmapState bitmapState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(android.graphics.drawable.BitmapDrawable$BitmapState android.content.res.Resources ), 0, this, bitmapState, resources);
    }

    private void updateLocalState(Resources resources) {
        InvokeDynamicSupport.bootstrap("updateLocalState", $$robo$$android_graphics_drawable_BitmapDrawable$updateLocalState(android.content.res.Resources ), 0, this, resources);
    }

    private /* synthetic */ void __constructor__(BitmapState bitmapState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_BitmapDrawable$__constructor__(bitmapState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BitmapDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class BitmapState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Paint mPaint;
        int[] mThemeAttrs;
        Bitmap mBitmap;
        ColorStateList mTint;
        PorterDuff.Mode mTintMode;
        int mGravity;
        float mBaseAlpha;
        Shader.TileMode mTileModeX;
        Shader.TileMode mTileModeY;
        int mSrcDensityOverride;
        int mTargetDensity;
        boolean mAutoMirrored;
        int mChangingConfigurations;
        boolean mRebuildShader;

        private void $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$__constructor__(Bitmap bitmap) {
            this.mThemeAttrs = null;
            this.mBitmap = null;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mGravity = 119;
            this.mBaseAlpha = 1.0f;
            this.mTileModeX = null;
            this.mTileModeY = null;
            this.mSrcDensityOverride = 0;
            this.mTargetDensity = 160;
            this.mAutoMirrored = false;
            this.mBitmap = bitmap;
            this.mPaint = new Paint(6);
        }

        private void $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$__constructor__(BitmapState bitmapState) {
            this.mThemeAttrs = null;
            this.mBitmap = null;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mGravity = 119;
            this.mBaseAlpha = 1.0f;
            this.mTileModeX = null;
            this.mTileModeY = null;
            this.mSrcDensityOverride = 0;
            this.mTargetDensity = 160;
            this.mAutoMirrored = false;
            this.mBitmap = bitmapState.mBitmap;
            this.mTint = bitmapState.mTint;
            this.mTintMode = bitmapState.mTintMode;
            this.mThemeAttrs = bitmapState.mThemeAttrs;
            this.mChangingConfigurations = bitmapState.mChangingConfigurations;
            this.mGravity = bitmapState.mGravity;
            this.mTileModeX = bitmapState.mTileModeX;
            this.mTileModeY = bitmapState.mTileModeY;
            this.mSrcDensityOverride = bitmapState.mSrcDensityOverride;
            this.mTargetDensity = bitmapState.mTargetDensity;
            this.mBaseAlpha = bitmapState.mBaseAlpha;
            this.mPaint = new Paint(bitmapState.mPaint);
            this.mRebuildShader = bitmapState.mRebuildShader;
            this.mAutoMirrored = bitmapState.mAutoMirrored;
        }

        private final boolean $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$canApplyTheme() {
            return this.mThemeAttrs != null || this.mTint != null && this.mTint.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$newDrawable() {
            return new BitmapDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$newDrawable(Resources res) {
            return new BitmapDrawable(this, res);
        }

        private final int $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }

        private void __constructor__(Bitmap bitmap) {
            this.$$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$__constructor__(bitmap);
        }

        BitmapState(Bitmap bitmap) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$__constructor__(android.graphics.Bitmap ), 0, this, bitmap);
        }

        private void __constructor__(BitmapState bitmapState) {
            this.$$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$__constructor__(bitmapState);
        }

        BitmapState(BitmapState bitmapState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$__constructor__(android.graphics.drawable.BitmapDrawable$BitmapState ), 0, this, bitmapState);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$canApplyTheme(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_BitmapDrawable_BitmapState$getChangingConfigurations(), 0, this);
        }

        public /* synthetic */ BitmapState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BitmapState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

