/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ClipDrawable
extends DrawableWrapper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int HORIZONTAL = 1;
    public static int VERTICAL = 2;
    private static int MAX_LEVEL = 10000;
    private Rect mTmpRect;
    private ClipState mState;

    private void $$robo$$android_graphics_drawable_ClipDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_ClipDrawable$__constructor__(Drawable drawable2, int gravity, int orientation) {
        this.mState.mGravity = gravity;
        this.mState.mOrientation = orientation;
        this.setDrawable(drawable2);
    }

    private final void $$robo$$android_graphics_drawable_ClipDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = ClipDrawable.obtainAttributes(r, theme, attrs, R.styleable.ClipDrawable);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_ClipDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        ClipState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.ClipDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                ClipDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_ClipDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <clip> tag requires a 'drawable' attribute or child tag defining a drawable");
        }
    }

    private final void $$robo$$android_graphics_drawable_ClipDrawable$updateStateFromTypedArray(TypedArray a) {
        ClipState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        ClipState.access$002(state, a.extractThemeAttrs());
        state.mOrientation = a.getInt(2, state.mOrientation);
        state.mGravity = a.getInt(0, state.mGravity);
    }

    private final boolean $$robo$$android_graphics_drawable_ClipDrawable$onLevelChange(int level) {
        super.onLevelChange(level);
        this.invalidateSelf();
        return true;
    }

    private final int $$robo$$android_graphics_drawable_ClipDrawable$getOpacity() {
        Drawable dr = this.getDrawable();
        int opacity = dr.getOpacity();
        if (opacity == -2 || dr.getLevel() == 0) {
            return -2;
        }
        int level = this.getLevel();
        if (level >= 10000) {
            return dr.getOpacity();
        }
        return -3;
    }

    private final void $$robo$$android_graphics_drawable_ClipDrawable$draw(Canvas canvas) {
        Drawable dr = this.getDrawable();
        if (dr.getLevel() == 0) {
            return;
        }
        Rect r = this.mTmpRect;
        Rect bounds = this.getBounds();
        int level = this.getLevel();
        int w = bounds.width();
        boolean iw = false;
        if ((this.mState.mOrientation & 1) != 0) {
            w -= (w - 0) * (10000 - level) / 10000;
        }
        int h = bounds.height();
        boolean ih = false;
        if ((this.mState.mOrientation & 2) != 0) {
            h -= (h - 0) * (10000 - level) / 10000;
        }
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(this.mState.mGravity, w, h, bounds, r, layoutDirection);
        if (w > 0 && h > 0) {
            canvas.save();
            canvas.clipRect(r);
            dr.draw(canvas);
            canvas.restore();
        }
    }

    private final DrawableWrapper.DrawableWrapperState $$robo$$android_graphics_drawable_ClipDrawable$mutateConstantState() {
        this.mState = new ClipState(this.mState, null);
        return this.mState;
    }

    private void $$robo$$android_graphics_drawable_ClipDrawable$__constructor__(ClipState state, Resources res) {
        this.mTmpRect = new Rect();
        this.mState = state;
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_ClipDrawable$__constructor__(ClipState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_ClipDrawable$__constructor__();
    }

    ClipDrawable() {
        this(new ClipState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ClipDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Drawable drawable2, int n, int n2) {
        this.$$robo$$android_graphics_drawable_ClipDrawable$__constructor__(drawable2, n, n2);
    }

    public ClipDrawable(Drawable drawable2, int n, int n2) {
        this(new ClipState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ClipDrawable$__constructor__(android.graphics.drawable.Drawable int int ), 0, this, drawable2, n, n2);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_ClipDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_ClipDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_ClipDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_ClipDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_ClipDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_ClipDrawable$getOpacity(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_ClipDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        return InvokeDynamicSupport.bootstrap("mutateConstantState", $$robo$$android_graphics_drawable_ClipDrawable$mutateConstantState(), 0, this);
    }

    private void __constructor__(ClipState clipState, Resources resources) {
        this.$$robo$$android_graphics_drawable_ClipDrawable$__constructor__(clipState, resources);
    }

    private ClipDrawable(ClipState clipState, Resources resources) {
        super(clipState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ClipDrawable$__constructor__(android.graphics.drawable.ClipDrawable$ClipState android.content.res.Resources ), 0, this, clipState, resources);
    }

    private /* synthetic */ void __constructor__(ClipState clipState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_ClipDrawable$__constructor__(clipState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClipDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ClipState
    extends DrawableWrapper.DrawableWrapperState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mThemeAttrs;
        int mOrientation;
        int mGravity;

        private void $$robo$$android_graphics_drawable_ClipDrawable_ClipState$__constructor__(ClipState orig, Resources res) {
            this.mOrientation = 1;
            this.mGravity = 3;
            if (orig != null) {
                this.mOrientation = orig.mOrientation;
                this.mGravity = orig.mGravity;
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_ClipDrawable_ClipState$newDrawable(Resources res) {
            return new ClipDrawable(this, res);
        }

        static /* synthetic */ int[] access$002(ClipState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }

        private void __constructor__(ClipState clipState, Resources resources) {
            this.$$robo$$android_graphics_drawable_ClipDrawable_ClipState$__constructor__(clipState, resources);
        }

        ClipState(ClipState clipState, Resources resources) {
            super(clipState, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ClipDrawable_ClipState$__constructor__(android.graphics.drawable.ClipDrawable$ClipState android.content.res.Resources ), 0, this, clipState, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_ClipDrawable_ClipState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        public /* synthetic */ ClipState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClipState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

