/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InsetDrawable
extends DrawableWrapper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Rect mTmpRect;
    private Rect mTmpInsetRect;
    private InsetState mState;

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(Drawable drawable2, int inset) {
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(Drawable drawable2, float inset) {
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(Drawable drawable2, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        this.mState.mInsetLeft = new InsetValue(0.0f, insetLeft);
        this.mState.mInsetTop = new InsetValue(0.0f, insetTop);
        this.mState.mInsetRight = new InsetValue(0.0f, insetRight);
        this.mState.mInsetBottom = new InsetValue(0.0f, insetBottom);
        this.setDrawable(drawable2);
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(Drawable drawable2, float insetLeftFraction, float insetTopFraction, float insetRightFraction, float insetBottomFraction) {
        this.mState.mInsetLeft = new InsetValue(insetLeftFraction, 0);
        this.mState.mInsetTop = new InsetValue(insetTopFraction, 0);
        this.mState.mInsetRight = new InsetValue(insetRightFraction, 0);
        this.mState.mInsetBottom = new InsetValue(insetBottomFraction, 0);
        this.setDrawable(drawable2);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = InsetDrawable.obtainAttributes(r, theme, attrs, R.styleable.InsetDrawable);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_InsetDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        InsetState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.InsetDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                InsetDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or child tag defining a drawable");
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$updateStateFromTypedArray(TypedArray a) {
        InsetState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        InsetState.access$002(state, a.extractThemeAttrs());
        if (a.hasValue(6)) {
            InsetValue inset;
            state.mInsetLeft = inset = this.getInset(a, 6, new InsetValue());
            state.mInsetTop = inset;
            state.mInsetRight = inset;
            state.mInsetBottom = inset;
        }
        state.mInsetLeft = this.getInset(a, 2, state.mInsetLeft);
        state.mInsetTop = this.getInset(a, 4, state.mInsetTop);
        state.mInsetRight = this.getInset(a, 3, state.mInsetRight);
        state.mInsetBottom = this.getInset(a, 5, state.mInsetBottom);
    }

    private final InsetValue $$robo$$android_graphics_drawable_InsetDrawable$getInset(TypedArray a, int index, InsetValue defaultValue) {
        if (a.hasValue(index)) {
            TypedValue tv = a.peekValue(index);
            if (tv.type == 6) {
                float f = tv.getFraction(1.0f, 1.0f);
                if (f >= 1.0f) {
                    throw new IllegalStateException("Fraction cannot be larger than 1");
                }
                return new InsetValue(f, 0);
            }
            int dimension = a.getDimensionPixelOffset(index, 0);
            if (dimension != 0) {
                return new InsetValue(0.0f, dimension);
            }
        }
        return defaultValue;
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$getInsets(Rect out) {
        Rect b = this.getBounds();
        out.left = this.mState.mInsetLeft.getDimension(b.width());
        out.right = this.mState.mInsetRight.getDimension(b.width());
        out.top = this.mState.mInsetTop.getDimension(b.height());
        out.bottom = this.mState.mInsetBottom.getDimension(b.height());
    }

    private final boolean $$robo$$android_graphics_drawable_InsetDrawable$getPadding(Rect padding) {
        boolean pad = super.getPadding(padding);
        this.getInsets(this.mTmpInsetRect);
        padding.left += this.mTmpInsetRect.left;
        padding.right += this.mTmpInsetRect.right;
        padding.top += this.mTmpInsetRect.top;
        padding.bottom += this.mTmpInsetRect.bottom;
        return pad || (this.mTmpInsetRect.left | this.mTmpInsetRect.right | this.mTmpInsetRect.top | this.mTmpInsetRect.bottom) != 0;
    }

    private final Insets $$robo$$android_graphics_drawable_InsetDrawable$getOpticalInsets() {
        Insets contentInsets = super.getOpticalInsets();
        this.getInsets(this.mTmpInsetRect);
        return Insets.of(contentInsets.left + this.mTmpInsetRect.left, contentInsets.top + this.mTmpInsetRect.top, contentInsets.right + this.mTmpInsetRect.right, contentInsets.bottom + this.mTmpInsetRect.bottom);
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getOpacity() {
        InsetState state = this.mState;
        int opacity = this.getDrawable().getOpacity();
        this.getInsets(this.mTmpInsetRect);
        if (opacity == -1 && (this.mTmpInsetRect.left > 0 || this.mTmpInsetRect.top > 0 || this.mTmpInsetRect.right > 0 || this.mTmpInsetRect.bottom > 0)) {
            return -3;
        }
        return opacity;
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$onBoundsChange(Rect bounds) {
        Rect r = this.mTmpRect;
        r.set(bounds);
        r.left += this.mState.mInsetLeft.getDimension(bounds.width());
        r.top += this.mState.mInsetTop.getDimension(bounds.height());
        r.right -= this.mState.mInsetRight.getDimension(bounds.width());
        r.bottom -= this.mState.mInsetBottom.getDimension(bounds.height());
        super.onBoundsChange(r);
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicWidth() {
        int childWidth = this.getDrawable().getIntrinsicWidth();
        float fraction2 = this.mState.mInsetLeft.mFraction + this.mState.mInsetRight.mFraction;
        if (childWidth < 0 || fraction2 >= 1.0f) {
            return -1;
        }
        return (int)((float)childWidth / (1.0f - fraction2)) + this.mState.mInsetLeft.mDimension + this.mState.mInsetRight.mDimension;
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicHeight() {
        int childHeight = this.getDrawable().getIntrinsicHeight();
        float fraction2 = this.mState.mInsetTop.mFraction + this.mState.mInsetBottom.mFraction;
        if (childHeight < 0 || fraction2 >= 1.0f) {
            return -1;
        }
        return (int)((float)childHeight / (1.0f - fraction2)) + this.mState.mInsetTop.mDimension + this.mState.mInsetBottom.mDimension;
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$getOutline(Outline outline) {
        this.getDrawable().getOutline(outline);
    }

    private final DrawableWrapper.DrawableWrapperState $$robo$$android_graphics_drawable_InsetDrawable$mutateConstantState() {
        this.mState = new InsetState(this.mState, null);
        return this.mState;
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(InsetState state, Resources res) {
        this.mTmpRect = new Rect();
        this.mTmpInsetRect = new Rect();
        this.mState = state;
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(InsetState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__();
    }

    InsetDrawable() {
        this(new InsetState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Drawable drawable2, int n) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(drawable2, n);
    }

    public InsetDrawable(Drawable drawable2, int n) {
        this(drawable2, n, n, n, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.Drawable int ), 0, this, drawable2, n);
    }

    private void __constructor__(Drawable drawable2, float f) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(drawable2, f);
    }

    public InsetDrawable(Drawable drawable2, float f) {
        this(drawable2, f, f, f, f);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.Drawable float ), 0, this, drawable2, f);
    }

    private void __constructor__(Drawable drawable2, int n, int n2, int n3, int n4) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(drawable2, n, n2, n3, n4);
    }

    public InsetDrawable(Drawable drawable2, int n, int n2, int n3, int n4) {
        this(new InsetState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.Drawable int int int int ), 0, this, drawable2, n, n2, n3, n4);
    }

    private void __constructor__(Drawable drawable2, float f, float f2, float f3, float f4) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(drawable2, f, f2, f3, f4);
    }

    public InsetDrawable(Drawable drawable2, float f, float f2, float f3, float f4) {
        this(new InsetState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.Drawable float float float float ), 0, this, drawable2, f, f2, f3, f4);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_InsetDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_InsetDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_InsetDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_InsetDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private InsetValue getInset(TypedArray typedArray, int n, InsetValue insetValue) {
        return InvokeDynamicSupport.bootstrap("getInset", $$robo$$android_graphics_drawable_InsetDrawable$getInset(android.content.res.TypedArray int android.graphics.drawable.InsetDrawable$InsetValue ), 0, this, typedArray, n, insetValue);
    }

    private void getInsets(Rect rect) {
        InvokeDynamicSupport.bootstrap("getInsets", $$robo$$android_graphics_drawable_InsetDrawable$getInsets(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_InsetDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_InsetDrawable$getOpticalInsets(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_InsetDrawable$getOpacity(), 0, this);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_InsetDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_InsetDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        return InvokeDynamicSupport.bootstrap("mutateConstantState", $$robo$$android_graphics_drawable_InsetDrawable$mutateConstantState(), 0, this);
    }

    private void __constructor__(InsetState insetState, Resources resources) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(insetState, resources);
    }

    private InsetDrawable(InsetState insetState, Resources resources) {
        super(insetState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.InsetDrawable$InsetState android.content.res.Resources ), 0, this, insetState, resources);
    }

    private /* synthetic */ void __constructor__(InsetState insetState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(insetState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsetDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class InsetValue
    implements Cloneable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        float mFraction;
        int mDimension;

        private void $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$__constructor__() {
        }

        private void $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$__constructor__(float fraction2, int dimension) {
            this.mFraction = fraction2;
            this.mDimension = dimension;
        }

        private final int $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$getDimension(int boundSize) {
            return (int)((float)boundSize * this.mFraction) + this.mDimension;
        }

        private final void $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$scaleFromDensity(int sourceDensity, int targetDensity) {
            if (this.mDimension != 0) {
                this.mDimension = Bitmap.scaleFromDensity(this.mDimension, sourceDensity, targetDensity);
            }
        }

        private final InsetValue $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$clone() {
            return new InsetValue(this.mFraction, this.mDimension);
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_InsetDrawable_InsetValue$__constructor__();
        }

        public InsetValue() {
            this(0.0f, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$__constructor__(), 0, this);
        }

        private void __constructor__(float f, int n) {
            this.$$robo$$android_graphics_drawable_InsetDrawable_InsetValue$__constructor__(f, n);
        }

        public InsetValue(float f, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$__constructor__(float int ), 0, this, f, n);
        }

        int getDimension(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getDimension", $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$getDimension(int ), 0, this, n);
        }

        void scaleFromDensity(int n, int n2) {
            InvokeDynamicSupport.bootstrap("scaleFromDensity", $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$scaleFromDensity(int int ), 0, this, n, n2);
        }

        public InsetValue clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_graphics_drawable_InsetDrawable_InsetValue$clone(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsetValue)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class InsetState
    extends DrawableWrapper.DrawableWrapperState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mThemeAttrs;
        InsetValue mInsetLeft;
        InsetValue mInsetTop;
        InsetValue mInsetRight;
        InsetValue mInsetBottom;

        private void $$robo$$android_graphics_drawable_InsetDrawable_InsetState$__constructor__(InsetState orig, Resources res) {
            if (orig != null) {
                this.mInsetLeft = orig.mInsetLeft.clone();
                this.mInsetTop = orig.mInsetTop.clone();
                this.mInsetRight = orig.mInsetRight.clone();
                this.mInsetBottom = orig.mInsetBottom.clone();
                if (orig.mDensity != this.mDensity) {
                    this.applyDensityScaling(orig.mDensity, this.mDensity);
                }
            } else {
                this.mInsetLeft = new InsetValue();
                this.mInsetTop = new InsetValue();
                this.mInsetRight = new InsetValue();
                this.mInsetBottom = new InsetValue();
            }
        }

        private final void $$robo$$android_graphics_drawable_InsetDrawable_InsetState$onDensityChanged(int sourceDensity, int targetDensity) {
            super.onDensityChanged(sourceDensity, targetDensity);
            this.applyDensityScaling(sourceDensity, targetDensity);
        }

        private final void $$robo$$android_graphics_drawable_InsetDrawable_InsetState$applyDensityScaling(int sourceDensity, int targetDensity) {
            this.mInsetLeft.scaleFromDensity(sourceDensity, targetDensity);
            this.mInsetTop.scaleFromDensity(sourceDensity, targetDensity);
            this.mInsetRight.scaleFromDensity(sourceDensity, targetDensity);
            this.mInsetBottom.scaleFromDensity(sourceDensity, targetDensity);
        }

        private final Drawable $$robo$$android_graphics_drawable_InsetDrawable_InsetState$newDrawable(Resources res) {
            InsetState state;
            if (res != null) {
                int density;
                int densityDpi = res.getDisplayMetrics().densityDpi;
                int n = density = densityDpi == 0 ? 160 : densityDpi;
                state = density != this.mDensity ? new InsetState(this, res) : this;
            } else {
                state = this;
            }
            return new InsetDrawable(state, res);
        }

        static /* synthetic */ int[] access$002(InsetState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }

        private void __constructor__(InsetState insetState, Resources resources) {
            this.$$robo$$android_graphics_drawable_InsetDrawable_InsetState$__constructor__(insetState, resources);
        }

        InsetState(InsetState insetState, Resources resources) {
            super(insetState, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$__constructor__(android.graphics.drawable.InsetDrawable$InsetState android.content.res.Resources ), 0, this, insetState, resources);
        }

        @Override
        void onDensityChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onDensityChanged", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$onDensityChanged(int int ), 0, this, n, n2);
        }

        private void applyDensityScaling(int n, int n2) {
            InvokeDynamicSupport.bootstrap("applyDensityScaling", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$applyDensityScaling(int int ), 0, this, n, n2);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        public /* synthetic */ InsetState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsetState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

