/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.BurstHolder;
import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.CaptureCollector;
import android.hardware.camera2.legacy.GLThreadManager;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.LegacyFaceDetectMapper;
import android.hardware.camera2.legacy.LegacyFocusStateMapper;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.LegacyResultMapper;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.legacy.RequestHandlerThread;
import android.hardware.camera2.legacy.RequestHolder;
import android.hardware.camera2.legacy.RequestQueue;
import android.hardware.camera2.utils.SizeAreaComparator;
import android.hardware.camera2.utils.SubmitInfo;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.MutableLong;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RequestThreadManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    private int mCameraId;
    private RequestHandlerThread mRequestThread;
    private static boolean DEBUG = false;
    private static boolean VERBOSE = false;
    private Camera mCamera;
    private CameraCharacteristics mCharacteristics;
    private CameraDeviceState mDeviceState;
    private CaptureCollector mCaptureCollector;
    private LegacyFocusStateMapper mFocusStateMapper;
    private LegacyFaceDetectMapper mFaceDetectMapper;
    private static int MSG_CONFIGURE_OUTPUTS = 1;
    private static int MSG_SUBMIT_CAPTURE_REQUEST = 2;
    private static int MSG_CLEANUP = 3;
    private static int MAX_IN_FLIGHT_REQUESTS = 2;
    private static int PREVIEW_FRAME_TIMEOUT = 1000;
    private static int JPEG_FRAME_TIMEOUT = 4000;
    private static int REQUEST_COMPLETE_TIMEOUT = 4000;
    private static float ASPECT_RATIO_TOLERANCE = 0.01f;
    private boolean mPreviewRunning;
    private List<Surface> mPreviewOutputs;
    private List<Surface> mCallbackOutputs;
    private GLThreadManager mGLThreadManager;
    private SurfaceTexture mPreviewTexture;
    private Camera.Parameters mParams;
    private List<Long> mJpegSurfaceIds;
    private Size mIntermediateBufferSize;
    private RequestQueue mRequestQueue;
    private LegacyRequest mLastRequest;
    private SurfaceTexture mDummyTexture;
    private Surface mDummySurface;
    private Object mIdleLock;
    private FpsCounter mPrevCounter;
    private FpsCounter mRequestCounter;
    private AtomicBoolean mQuit;
    private static boolean USE_BLOB_FORMAT_OVERRIDE = true;
    private Camera.ErrorCallback mErrorCallback;
    private ConditionVariable mReceivedJpeg;
    private Camera.PictureCallback mJpegCallback;
    private Camera.ShutterCallback mJpegShutterCallback;
    private SurfaceTexture.OnFrameAvailableListener mPreviewCallback;
    private Handler.Callback mRequestHandlerCb;

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$createDummySurface() {
        if (this.mDummyTexture == null || this.mDummySurface == null) {
            this.mDummyTexture = new SurfaceTexture(0);
            this.mDummyTexture.setDefaultBufferSize(640, 480);
            this.mDummySurface = new Surface(this.mDummyTexture);
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$stopPreview() {
        if (this.mPreviewRunning) {
            this.mCamera.stopPreview();
            this.mPreviewRunning = false;
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$startPreview() {
        if (!this.mPreviewRunning) {
            this.mCamera.startPreview();
            this.mPreviewRunning = true;
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doJpegCapturePrepare(RequestHolder request) throws IOException {
        if (!this.mPreviewRunning) {
            this.createDummySurface();
            this.mCamera.setPreviewTexture(this.mDummyTexture);
            this.startPreview();
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doJpegCapture(RequestHolder request) {
        this.mCamera.takePicture(this.mJpegShutterCallback, null, this.mJpegCallback);
        this.mPreviewRunning = false;
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doPreviewCapture(RequestHolder request) throws IOException {
        if (this.mPreviewRunning) {
            return;
        }
        if (this.mPreviewTexture == null) {
            throw new IllegalStateException("Preview capture called with no preview surfaces configured.");
        }
        this.mPreviewTexture.setDefaultBufferSize(this.mIntermediateBufferSize.getWidth(), this.mIntermediateBufferSize.getHeight());
        this.mCamera.setPreviewTexture(this.mPreviewTexture);
        this.startPreview();
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$configureOutputs(Collection<Pair<Surface, Size>> outputs) {
        try {
            this.stopPreview();
        }
        catch (RuntimeException e) {
            Log.e(this.TAG, "Received device exception in configure call: ", e);
            this.mDeviceState.setError(1);
            return;
        }
        try {
            this.mCamera.setPreviewTexture(null);
        }
        catch (IOException e) {
            Log.w(this.TAG, "Failed to clear prior SurfaceTexture, may cause GL deadlock: ", e);
        }
        catch (RuntimeException e) {
            Log.e(this.TAG, "Received device exception in configure call: ", e);
            this.mDeviceState.setError(1);
            return;
        }
        if (this.mGLThreadManager != null) {
            this.mGLThreadManager.waitUntilStarted();
            this.mGLThreadManager.ignoreNewFrames();
            this.mGLThreadManager.waitUntilIdle();
        }
        this.resetJpegSurfaceFormats(this.mCallbackOutputs);
        for (Surface s : this.mCallbackOutputs) {
            try {
                LegacyCameraDevice.disconnectSurface(s);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                Log.w(this.TAG, "Surface abandoned, skipping...", e);
            }
        }
        this.mPreviewOutputs.clear();
        this.mCallbackOutputs.clear();
        this.mJpegSurfaceIds.clear();
        this.mPreviewTexture = null;
        ArrayList<Size> previewOutputSizes = new ArrayList<Size>();
        ArrayList<Size> callbackOutputSizes = new ArrayList<Size>();
        int facing = this.mCharacteristics.get(CameraCharacteristics.LENS_FACING);
        int orientation = this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (outputs != null) {
            for (Pair<Surface, Size> outPair : outputs) {
                Surface s = (Surface)outPair.first;
                Size outSize = (Size)outPair.second;
                try {
                    int format = LegacyCameraDevice.detectSurfaceType(s);
                    LegacyCameraDevice.setSurfaceOrientation(s, facing, orientation);
                    switch (format) {
                        case 33: {
                            LegacyCameraDevice.setSurfaceFormat(s, 1);
                            this.mJpegSurfaceIds.add(LegacyCameraDevice.getSurfaceId(s));
                            this.mCallbackOutputs.add(s);
                            callbackOutputSizes.add(outSize);
                            LegacyCameraDevice.connectSurface(s);
                            break;
                        }
                        default: {
                            LegacyCameraDevice.setScalingMode(s, 1);
                            this.mPreviewOutputs.add(s);
                            previewOutputSizes.add(outSize);
                            break;
                        }
                    }
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.w(this.TAG, "Surface abandoned, skipping...", e);
                }
            }
        }
        try {
            this.mParams = this.mCamera.getParameters();
        }
        catch (RuntimeException e) {
            Log.e(this.TAG, "Received device exception: ", e);
            this.mDeviceState.setError(1);
            return;
        }
        List<int[]> supportedFpsRanges = this.mParams.getSupportedPreviewFpsRange();
        int[] bestRange = this.getPhotoPreviewFpsRange(supportedFpsRanges);
        this.mParams.setPreviewFpsRange(bestRange[0], bestRange[1]);
        Size smallestSupportedJpegSize = this.calculatePictureSize(this.mCallbackOutputs, callbackOutputSizes, this.mParams);
        if (previewOutputSizes.size() > 0) {
            Size largestOutput = SizeAreaComparator.findLargestByArea(previewOutputSizes);
            Size largestJpegDimen = ParameterUtils.getLargestSupportedJpegSizeByArea(this.mParams);
            Size chosenJpegDimen = smallestSupportedJpegSize != null ? smallestSupportedJpegSize : largestJpegDimen;
            List<Size> supportedPreviewSizes = ParameterUtils.convertSizeList(this.mParams.getSupportedPreviewSizes());
            long largestOutputArea = (long)largestOutput.getHeight() * (long)largestOutput.getWidth();
            Size bestPreviewDimen = SizeAreaComparator.findLargestByArea(supportedPreviewSizes);
            for (Size s : supportedPreviewSizes) {
                long currArea = s.getWidth() * s.getHeight();
                long bestArea = bestPreviewDimen.getWidth() * bestPreviewDimen.getHeight();
                if (!RequestThreadManager.checkAspectRatiosMatch(chosenJpegDimen, s) || currArea >= bestArea || currArea < largestOutputArea) continue;
                bestPreviewDimen = s;
            }
            this.mIntermediateBufferSize = bestPreviewDimen;
            this.mParams.setPreviewSize(this.mIntermediateBufferSize.getWidth(), this.mIntermediateBufferSize.getHeight());
        } else {
            this.mIntermediateBufferSize = null;
        }
        if (smallestSupportedJpegSize != null) {
            Log.i(this.TAG, "configureOutputs - set take picture size to " + smallestSupportedJpegSize);
            this.mParams.setPictureSize(smallestSupportedJpegSize.getWidth(), smallestSupportedJpegSize.getHeight());
        }
        if (this.mGLThreadManager == null) {
            this.mGLThreadManager = new GLThreadManager(this.mCameraId, facing, this.mDeviceState);
            this.mGLThreadManager.start();
        }
        this.mGLThreadManager.waitUntilStarted();
        ArrayList<Pair<Surface, Size>> previews = new ArrayList<Pair<Surface, Size>>();
        Iterator previewSizeIter = previewOutputSizes.iterator();
        for (Surface p : this.mPreviewOutputs) {
            previews.add(new Pair(p, previewSizeIter.next()));
        }
        this.mGLThreadManager.setConfigurationAndWait(previews, this.mCaptureCollector);
        this.mGLThreadManager.allowNewFrames();
        this.mPreviewTexture = this.mGLThreadManager.getCurrentSurfaceTexture();
        if (this.mPreviewTexture != null) {
            this.mPreviewTexture.setOnFrameAvailableListener(this.mPreviewCallback);
        }
        try {
            this.mCamera.setParameters(this.mParams);
        }
        catch (RuntimeException e) {
            Log.e(this.TAG, "Received device exception while configuring: ", e);
            this.mDeviceState.setError(1);
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$resetJpegSurfaceFormats(Collection<Surface> surfaces) {
        if (surfaces == null) {
            return;
        }
        for (Surface s : surfaces) {
            if (s == null || !s.isValid()) {
                Log.w(this.TAG, "Jpeg surface is invalid, skipping...");
                continue;
            }
            try {
                LegacyCameraDevice.setSurfaceFormat(s, 33);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                Log.w(this.TAG, "Surface abandoned, skipping...", e);
            }
        }
    }

    private final Size $$robo$$android_hardware_camera2_legacy_RequestThreadManager$calculatePictureSize(List<Surface> callbackOutputs, List<Size> callbackSizes, Camera.Parameters params) {
        if (callbackOutputs.size() != callbackSizes.size()) {
            throw new IllegalStateException("Input collections must be same length");
        }
        ArrayList<Object> configuredJpegSizes = new ArrayList<Object>();
        Iterator<Size> sizeIterator = callbackSizes.iterator();
        for (Surface callbackSurface : callbackOutputs) {
            Size jpegSize = sizeIterator.next();
            if (!LegacyCameraDevice.containsSurfaceId(callbackSurface, this.mJpegSurfaceIds)) continue;
            configuredJpegSizes.add(jpegSize);
        }
        if (!configuredJpegSizes.isEmpty()) {
            int maxConfiguredJpegWidth = -1;
            int maxConfiguredJpegHeight = -1;
            for (Size size : configuredJpegSizes) {
                maxConfiguredJpegWidth = size.getWidth() > maxConfiguredJpegWidth ? size.getWidth() : maxConfiguredJpegWidth;
                maxConfiguredJpegHeight = size.getHeight() > maxConfiguredJpegHeight ? size.getHeight() : maxConfiguredJpegHeight;
            }
            Size smallestBoundJpegSize = new Size(maxConfiguredJpegWidth, maxConfiguredJpegHeight);
            List<Size> list = ParameterUtils.convertSizeList(params.getSupportedPictureSizes());
            ArrayList<Size> candidateSupportedJpegSizes = new ArrayList<Size>();
            for (Size supportedJpegSize : list) {
                if (supportedJpegSize.getWidth() < maxConfiguredJpegWidth || supportedJpegSize.getHeight() < maxConfiguredJpegHeight) continue;
                candidateSupportedJpegSizes.add(supportedJpegSize);
            }
            if (candidateSupportedJpegSizes.isEmpty()) {
                throw new AssertionError((Object)("Could not find any supported JPEG sizes large enough to fit " + smallestBoundJpegSize));
            }
            Size smallestSupportedJpegSize = Collections.min(candidateSupportedJpegSizes, new SizeAreaComparator());
            if (!smallestSupportedJpegSize.equals(smallestBoundJpegSize)) {
                Log.w(this.TAG, String.format("configureOutputs - Will need to crop picture %s into smallest bound size %s", smallestSupportedJpegSize, smallestBoundJpegSize));
            }
            return smallestSupportedJpegSize;
        }
        return null;
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_RequestThreadManager$checkAspectRatiosMatch(Size a, Size b) {
        float bAspect;
        float aAspect = (float)a.getWidth() / (float)a.getHeight();
        return Math.abs(aAspect - (bAspect = (float)b.getWidth() / (float)b.getHeight())) < 0.01f;
    }

    private final int[] $$robo$$android_hardware_camera2_legacy_RequestThreadManager$getPhotoPreviewFpsRange(List<int[]> frameRates) {
        if (frameRates.size() == 0) {
            Log.e(this.TAG, "No supported frame rates returned!");
            return null;
        }
        int bestMin = 0;
        int bestMax = 0;
        int bestIndex = 0;
        int index = 0;
        for (int[] rate : frameRates) {
            int minFps = rate[0];
            int maxFps = rate[1];
            if (maxFps > bestMax || maxFps == bestMax && minFps > bestMin) {
                bestMin = minFps;
                bestMax = maxFps;
                bestIndex = index;
            }
            ++index;
        }
        return frameRates.get(bestIndex);
    }

    private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$__constructor__(int cameraId, Camera camera, CameraCharacteristics characteristics, CameraDeviceState deviceState) {
        String name;
        this.mPreviewRunning = false;
        this.mPreviewOutputs = new ArrayList<Surface>();
        this.mCallbackOutputs = new ArrayList<Surface>();
        this.mJpegSurfaceIds = new ArrayList<Long>();
        this.mRequestQueue = new RequestQueue(this.mJpegSurfaceIds);
        this.mLastRequest = null;
        this.mIdleLock = new Object();
        this.mPrevCounter = new FpsCounter("Incoming Preview");
        this.mRequestCounter = new FpsCounter("Incoming Requests");
        this.mQuit = new AtomicBoolean(false);
        this.mErrorCallback = new Camera.ErrorCallback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$__constructor__(RequestThreadManager this$0) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$onError(int i, Camera camera) {
                switch (i) {
                    case 2: {
                        this.this$0.flush();
                        this.this$0.mDeviceState.setError(0);
                        break;
                    }
                    default: {
                        Log.e(this.this$0.TAG, "Received error " + i + " from the Camera1 ErrorCallback");
                        this.this$0.mDeviceState.setError(1);
                    }
                }
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public void onError(int n, Camera camera) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$onError(int android.hardware.Camera ), 0, this, n, camera);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mReceivedJpeg = new ConditionVariable(false);
        this.mJpegCallback = new Camera.PictureCallback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$__constructor__(RequestThreadManager this$0) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$onPictureTaken(byte[] data, Camera camera) {
                Log.i(this.this$0.TAG, "Received jpeg.");
                Pair<RequestHolder, Long> captureInfo = this.this$0.mCaptureCollector.jpegProduced();
                if (captureInfo == null || captureInfo.first == null) {
                    Log.e(this.this$0.TAG, "Dropping jpeg frame.");
                    return;
                }
                RequestHolder holder = (RequestHolder)captureInfo.first;
                long timestamp = (Long)captureInfo.second;
                for (Surface s : holder.getHolderTargets()) {
                    try {
                        if (!LegacyCameraDevice.containsSurfaceId(s, this.this$0.mJpegSurfaceIds)) continue;
                        Log.i(this.this$0.TAG, "Producing jpeg buffer...");
                        int totalSize = data.length + LegacyCameraDevice.nativeGetJpegFooterSize();
                        totalSize = totalSize + 3 & 0xFFFFFFFC;
                        LegacyCameraDevice.setNextTimestamp(s, timestamp);
                        LegacyCameraDevice.setSurfaceFormat(s, 1);
                        int dimen2 = (int)Math.ceil(Math.sqrt(totalSize));
                        dimen2 = dimen2 + 15 & 0xFFFFFFF0;
                        LegacyCameraDevice.setSurfaceDimens(s, dimen2, dimen2);
                        LegacyCameraDevice.produceFrame(s, data, dimen2, dimen2, 33);
                    }
                    catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                        Log.w(this.this$0.TAG, "Surface abandoned, dropping frame. ", e);
                    }
                }
                this.this$0.mReceivedJpeg.open();
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public void onPictureTaken(byte[] byArray, Camera camera) {
                InvokeDynamicSupport.bootstrap("onPictureTaken", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$onPictureTaken(byte[] android.hardware.Camera ), 0, this, byArray, camera);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mJpegShutterCallback = new Camera.ShutterCallback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$__constructor__(RequestThreadManager this$0) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$onShutter() {
                this.this$0.mCaptureCollector.jpegCaptured(SystemClock.elapsedRealtimeNanos());
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public void onShutter() {
                InvokeDynamicSupport.bootstrap("onShutter", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$onShutter(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPreviewCallback = new SurfaceTexture.OnFrameAvailableListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$__constructor__(RequestThreadManager this$0) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$onFrameAvailable(SurfaceTexture surfaceTexture) {
                this.this$0.mGLThreadManager.queueNewFrame();
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                InvokeDynamicSupport.bootstrap("onFrameAvailable", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$onFrameAvailable(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRequestHandlerCb = new Handler.Callback(this){
            public transient /* synthetic */ Object __robo_data__;
            private boolean mCleanup;
            private LegacyResultMapper mMapper;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$__constructor__(RequestThreadManager this$0) {
                this.mCleanup = false;
                this.mMapper = new LegacyResultMapper();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            private final boolean $$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$handleMessage(Message msg) {
                if (this.mCleanup) {
                    return true;
                }
                startTime = 0L;
                switch (msg.what) {
                    case 1: {
                        config = (ConfigureHolder)msg.obj;
                        sizes = config.surfaces != null ? config.surfaces.size() : 0;
                        Log.i(RequestThreadManager.access$100(this.this$0), "Configure outputs: " + sizes + " surfaces configured.");
                        try {
                            success = RequestThreadManager.access$200(this.this$0).waitForEmpty(4000L, TimeUnit.MILLISECONDS);
                            if (!success) {
                                Log.e(RequestThreadManager.access$100(this.this$0), "Timed out while queueing configure request.");
                                RequestThreadManager.access$200(this.this$0).failAll();
                            }
                        }
                        catch (InterruptedException e) {
                            Log.e(RequestThreadManager.access$100(this.this$0), "Interrupted while waiting for requests to complete.");
                            RequestThreadManager.access$000(this.this$0).setError(1);
                            break;
                        }
                        RequestThreadManager.access$600(this.this$0, config.surfaces);
                        config.condition.open();
                        break;
                    }
                    case 2: {
                        handler = RequestThreadManager.access$700(this.this$0).getHandler();
                        anyRequestOutputAbandoned = false;
                        nextBurst = RequestThreadManager.access$800(this.this$0).getNext();
                        if (nextBurst != null) ** GOTO lbl55
                        try {
                            success = RequestThreadManager.access$200(this.this$0).waitForEmpty(4000L, TimeUnit.MILLISECONDS);
                            if (!success) {
                                Log.e(RequestThreadManager.access$100(this.this$0), "Timed out while waiting for prior requests to complete.");
                                RequestThreadManager.access$200(this.this$0).failAll();
                            }
                        }
                        catch (InterruptedException e) {
                            Log.e(RequestThreadManager.access$100(this.this$0), "Interrupted while waiting for requests to complete: ", e);
                            RequestThreadManager.access$000(this.this$0).setError(1);
                            break;
                        }
                        e = RequestThreadManager.access$900(this.this$0);
                        synchronized (e) {
                            nextBurst = RequestThreadManager.access$800(this.this$0).getNext();
                            if (nextBurst == null) {
                                RequestThreadManager.access$000(this.this$0).setIdle();
                                break;
                            }
                        }
lbl55:
                        // 2 sources

                        if (nextBurst != null) {
                            handler.sendEmptyMessage(2);
                        }
                        requests = ((BurstHolder)nextBurst.first).produceRequestHolders((Long)nextBurst.second);
                        for (RequestHolder holder : requests) {
                            request = holder.getRequest();
                            paramsChanged = false;
                            if (RequestThreadManager.access$1000(this.this$0) == null || RequestThreadManager.access$1000((RequestThreadManager)this.this$0).captureRequest != request) {
                                previewSize = ParameterUtils.convertSize(RequestThreadManager.access$1100(this.this$0).getPreviewSize());
                                legacyRequest = new LegacyRequest(RequestThreadManager.access$1200(this.this$0), request, previewSize, RequestThreadManager.access$1100(this.this$0));
                                LegacyMetadataMapper.convertRequestMetadata(legacyRequest);
                                if (!RequestThreadManager.access$1100(this.this$0).same(legacyRequest.parameters)) {
                                    try {
                                        RequestThreadManager.access$1300(this.this$0).setParameters(legacyRequest.parameters);
                                    }
                                    catch (RuntimeException e) {
                                        Log.e(RequestThreadManager.access$100(this.this$0), "Exception while setting camera parameters: ", e);
                                        holder.failRequest();
                                        RequestThreadManager.access$000(this.this$0).setCaptureStart(holder, 0L, 3);
                                        continue;
                                    }
                                    paramsChanged = true;
                                    RequestThreadManager.access$1102(this.this$0, legacyRequest.parameters);
                                }
                                RequestThreadManager.access$1002(this.this$0, legacyRequest);
                            }
                            try {
                                success = RequestThreadManager.access$200(this.this$0).queueRequest(holder, RequestThreadManager.access$1000(this.this$0), 4000L, TimeUnit.MILLISECONDS);
                                if (!success) {
                                    Log.e(RequestThreadManager.access$100(this.this$0), "Timed out while queueing capture request.");
                                    holder.failRequest();
                                    RequestThreadManager.access$000(this.this$0).setCaptureStart(holder, 0L, 3);
                                    continue;
                                }
                                if (holder.hasPreviewTargets()) {
                                    RequestThreadManager.access$1400(this.this$0, holder);
                                }
                                if (holder.hasJpegTargets()) {
                                    while (!RequestThreadManager.access$200(this.this$0).waitForPreviewsEmpty(1000L, TimeUnit.MILLISECONDS)) {
                                        Log.e(RequestThreadManager.access$100(this.this$0), "Timed out while waiting for preview requests to complete.");
                                        RequestThreadManager.access$200(this.this$0).failNextPreview();
                                    }
                                    RequestThreadManager.access$400(this.this$0).close();
                                    RequestThreadManager.access$1500(this.this$0, holder);
                                }
                                RequestThreadManager.access$1600(this.this$0).processFaceDetectMode(request, RequestThreadManager.access$1100(this.this$0));
                                RequestThreadManager.access$1700(this.this$0).processRequestTriggers(request, RequestThreadManager.access$1100(this.this$0));
                                if (!holder.hasJpegTargets()) ** GOTO lbl126
                                RequestThreadManager.access$1800(this.this$0, holder);
                                if (!RequestThreadManager.access$400(this.this$0).block(4000L)) {
                                    Log.e(RequestThreadManager.access$100(this.this$0), "Hit timeout for jpeg callback!");
                                    RequestThreadManager.access$200(this.this$0).failNextJpeg();
                                }
                            }
                            catch (IOException e) {
                                Log.e(RequestThreadManager.access$100(this.this$0), "Received device exception during capture call: ", e);
                                RequestThreadManager.access$000(this.this$0).setError(1);
                                break;
                            }
                            catch (InterruptedException e) {
                                Log.e(RequestThreadManager.access$100(this.this$0), "Interrupted during capture: ", e);
                                RequestThreadManager.access$000(this.this$0).setError(1);
                                break;
                            }
                            catch (RuntimeException e) {
                                Log.e(RequestThreadManager.access$100(this.this$0), "Received device exception during capture call: ", e);
                                RequestThreadManager.access$000(this.this$0).setError(1);
                                break;
                            }
lbl126:
                            // 3 sources

                            if (paramsChanged) {
                                try {
                                    RequestThreadManager.access$1102(this.this$0, RequestThreadManager.access$1300(this.this$0).getParameters());
                                }
                                catch (RuntimeException e) {
                                    Log.e(RequestThreadManager.access$100(this.this$0), "Received device exception: ", e);
                                    RequestThreadManager.access$000(this.this$0).setError(1);
                                    break;
                                }
                                RequestThreadManager.access$1000(this.this$0).setParameters(RequestThreadManager.access$1100(this.this$0));
                            }
                            timestampMutable = new MutableLong(0L);
                            try {
                                success = RequestThreadManager.access$200(this.this$0).waitForRequestCompleted(holder, 4000L, TimeUnit.MILLISECONDS, timestampMutable);
                                if (!success) {
                                    Log.e(RequestThreadManager.access$100(this.this$0), "Timed out while waiting for request to complete.");
                                    RequestThreadManager.access$200(this.this$0).failAll();
                                }
                            }
                            catch (InterruptedException e) {
                                Log.e(RequestThreadManager.access$100(this.this$0), "Interrupted waiting for request completion: ", e);
                                RequestThreadManager.access$000(this.this$0).setError(1);
                                break;
                            }
                            result = this.mMapper.cachedConvertResultMetadata(RequestThreadManager.access$1000(this.this$0), timestampMutable.value);
                            RequestThreadManager.access$1700(this.this$0).mapResultTriggers(result);
                            RequestThreadManager.access$1600(this.this$0).mapResultFaces(result, RequestThreadManager.access$1000(this.this$0));
                            if (!holder.requestFailed()) {
                                RequestThreadManager.access$000(this.this$0).setCaptureResult(holder, result);
                            }
                            if (!holder.isOutputAbandoned()) continue;
                            anyRequestOutputAbandoned = true;
                        }
                        if (!anyRequestOutputAbandoned || !((BurstHolder)nextBurst.first).isRepeating()) break;
                        lastFrameNumber = this.this$0.cancelRepeating(((BurstHolder)nextBurst.first).getRequestId());
                        RequestThreadManager.access$000(this.this$0).setRepeatingRequestError(lastFrameNumber);
                        break;
                    }
                    case 3: {
                        this.mCleanup = true;
                        try {
                            success = RequestThreadManager.access$200(this.this$0).waitForEmpty(4000L, TimeUnit.MILLISECONDS);
                            if (!success) {
                                Log.e(RequestThreadManager.access$100(this.this$0), "Timed out while queueing cleanup request.");
                                RequestThreadManager.access$200(this.this$0).failAll();
                            }
                        }
                        catch (InterruptedException e) {
                            Log.e(RequestThreadManager.access$100(this.this$0), "Interrupted while waiting for requests to complete: ", e);
                            RequestThreadManager.access$000(this.this$0).setError(1);
                        }
                        if (RequestThreadManager.access$500(this.this$0) != null) {
                            RequestThreadManager.access$500(this.this$0).quit();
                            RequestThreadManager.access$502(this.this$0, null);
                        }
                        if (RequestThreadManager.access$1300(this.this$0) != null) {
                            RequestThreadManager.access$1300(this.this$0).release();
                            RequestThreadManager.access$1302(this.this$0, null);
                        }
                        RequestThreadManager.access$2000(this.this$0, RequestThreadManager.access$1900(this.this$0));
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled message " + msg.what + " on RequestThread."));
                    }
                }
                return true;
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public boolean handleMessage(Message message) {
                return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
        this.mCameraId = cameraId;
        this.mCharacteristics = Preconditions.checkNotNull(characteristics, "characteristics must not be null");
        this.TAG = name = String.format("RequestThread-%d", cameraId);
        this.mDeviceState = Preconditions.checkNotNull(deviceState, "deviceState must not be null");
        this.mFocusStateMapper = new LegacyFocusStateMapper(this.mCamera);
        this.mFaceDetectMapper = new LegacyFaceDetectMapper(this.mCamera, this.mCharacteristics);
        this.mCaptureCollector = new CaptureCollector(2, this.mDeviceState);
        this.mRequestThread = new RequestHandlerThread(name, this.mRequestHandlerCb);
        this.mCamera.setErrorCallback(this.mErrorCallback);
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$start() {
        this.mRequestThread.start();
    }

    private final long $$robo$$android_hardware_camera2_legacy_RequestThreadManager$flush() {
        Log.i(this.TAG, "Flushing all pending requests.");
        long lastFrame = this.mRequestQueue.stopRepeating();
        this.mCaptureCollector.failAll();
        return lastFrame;
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$quit() {
        if (!this.mQuit.getAndSet(true)) {
            Handler handler = this.mRequestThread.waitAndGetHandler();
            handler.sendMessageAtFrontOfQueue(handler.obtainMessage(3));
            this.mRequestThread.quitSafely();
            try {
                this.mRequestThread.join();
            }
            catch (InterruptedException e) {
                Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mRequestThread.getName(), this.mRequestThread.getId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubmitInfo $$robo$$android_hardware_camera2_legacy_RequestThreadManager$submitCaptureRequests(CaptureRequest[] requests, boolean repeating) {
        SubmitInfo info;
        Handler handler = this.mRequestThread.waitAndGetHandler();
        Object object = this.mIdleLock;
        synchronized (object) {
            info = this.mRequestQueue.submit(requests, repeating);
            handler.sendEmptyMessage(2);
        }
        return info;
    }

    private final long $$robo$$android_hardware_camera2_legacy_RequestThreadManager$cancelRepeating(int requestId) {
        return this.mRequestQueue.stopRepeating(requestId);
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$configure(Collection<Pair<Surface, Size>> outputs) {
        Handler handler = this.mRequestThread.waitAndGetHandler();
        ConditionVariable condition = new ConditionVariable(false);
        ConfigureHolder holder = new ConfigureHolder(condition, outputs);
        handler.sendMessage(handler.obtainMessage(1, 0, 0, holder));
        condition.block();
    }

    static /* synthetic */ void access$600(RequestThreadManager x0, Collection x1) {
        x0.configureOutputs(x1);
    }

    static /* synthetic */ RequestHandlerThread access$700(RequestThreadManager x0) {
        return x0.mRequestThread;
    }

    static /* synthetic */ RequestQueue access$800(RequestThreadManager x0) {
        return x0.mRequestQueue;
    }

    static /* synthetic */ Object access$900(RequestThreadManager x0) {
        return x0.mIdleLock;
    }

    static /* synthetic */ LegacyRequest access$1000(RequestThreadManager x0) {
        return x0.mLastRequest;
    }

    static /* synthetic */ Camera.Parameters access$1100(RequestThreadManager x0) {
        return x0.mParams;
    }

    static /* synthetic */ CameraCharacteristics access$1200(RequestThreadManager x0) {
        return x0.mCharacteristics;
    }

    static /* synthetic */ Camera access$1300(RequestThreadManager x0) {
        return x0.mCamera;
    }

    static /* synthetic */ Camera.Parameters access$1102(RequestThreadManager x0, Camera.Parameters x1) {
        x0.mParams = x1;
        return x0.mParams;
    }

    static /* synthetic */ LegacyRequest access$1002(RequestThreadManager x0, LegacyRequest x1) {
        x0.mLastRequest = x1;
        return x0.mLastRequest;
    }

    static /* synthetic */ void access$1400(RequestThreadManager x0, RequestHolder x1) throws IOException {
        x0.doPreviewCapture(x1);
    }

    static /* synthetic */ void access$1500(RequestThreadManager x0, RequestHolder x1) throws IOException {
        x0.doJpegCapturePrepare(x1);
    }

    static /* synthetic */ LegacyFaceDetectMapper access$1600(RequestThreadManager x0) {
        return x0.mFaceDetectMapper;
    }

    static /* synthetic */ LegacyFocusStateMapper access$1700(RequestThreadManager x0) {
        return x0.mFocusStateMapper;
    }

    static /* synthetic */ void access$1800(RequestThreadManager x0, RequestHolder x1) {
        x0.doJpegCapture(x1);
    }

    static /* synthetic */ GLThreadManager access$502(RequestThreadManager x0, GLThreadManager x1) {
        x0.mGLThreadManager = x1;
        return x0.mGLThreadManager;
    }

    static /* synthetic */ Camera access$1302(RequestThreadManager x0, Camera x1) {
        x0.mCamera = x1;
        return x0.mCamera;
    }

    static /* synthetic */ List access$1900(RequestThreadManager x0) {
        return x0.mCallbackOutputs;
    }

    static /* synthetic */ void access$2000(RequestThreadManager x0, Collection x1) {
        x0.resetJpegSurfaceFormats(x1);
    }

    private void createDummySurface() {
        InvokeDynamicSupport.bootstrap("createDummySurface", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$createDummySurface(), 0, this);
    }

    private void stopPreview() {
        InvokeDynamicSupport.bootstrap("stopPreview", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$stopPreview(), 0, this);
    }

    private void startPreview() {
        InvokeDynamicSupport.bootstrap("startPreview", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$startPreview(), 0, this);
    }

    private void doJpegCapturePrepare(RequestHolder requestHolder) throws IOException {
        InvokeDynamicSupport.bootstrap("doJpegCapturePrepare", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doJpegCapturePrepare(android.hardware.camera2.legacy.RequestHolder ), 0, this, requestHolder);
    }

    private void doJpegCapture(RequestHolder requestHolder) {
        InvokeDynamicSupport.bootstrap("doJpegCapture", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doJpegCapture(android.hardware.camera2.legacy.RequestHolder ), 0, this, requestHolder);
    }

    private void doPreviewCapture(RequestHolder requestHolder) throws IOException {
        InvokeDynamicSupport.bootstrap("doPreviewCapture", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doPreviewCapture(android.hardware.camera2.legacy.RequestHolder ), 0, this, requestHolder);
    }

    private void configureOutputs(Collection<Pair<Surface, Size>> collection) {
        InvokeDynamicSupport.bootstrap("configureOutputs", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$configureOutputs(java.util.Collection<android.util.Pair<android.view.Surface, android.util.Size>> ), 0, this, collection);
    }

    private void resetJpegSurfaceFormats(Collection<Surface> collection) {
        InvokeDynamicSupport.bootstrap("resetJpegSurfaceFormats", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$resetJpegSurfaceFormats(java.util.Collection<android.view.Surface> ), 0, this, collection);
    }

    private Size calculatePictureSize(List<Surface> list, List<Size> list2, Camera.Parameters parameters) {
        return InvokeDynamicSupport.bootstrap("calculatePictureSize", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$calculatePictureSize(java.util.List<android.view.Surface> java.util.List<android.util.Size> android.hardware.Camera$Parameters ), 0, this, list, list2, parameters);
    }

    private static boolean checkAspectRatiosMatch(Size size, Size size2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkAspectRatiosMatch", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$checkAspectRatiosMatch(android.util.Size android.util.Size ), 0, (Size)size, (Size)size2);
    }

    private int[] getPhotoPreviewFpsRange(List<int[]> list) {
        return InvokeDynamicSupport.bootstrap("getPhotoPreviewFpsRange", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$getPhotoPreviewFpsRange(java.util.List<int[]> ), 0, this, list);
    }

    private void __constructor__(int n, Camera camera, CameraCharacteristics cameraCharacteristics, CameraDeviceState cameraDeviceState) {
        this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager$__constructor__(n, camera, cameraCharacteristics, cameraDeviceState);
    }

    public RequestThreadManager(int n, Camera camera, CameraCharacteristics cameraCharacteristics, CameraDeviceState cameraDeviceState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$__constructor__(int android.hardware.Camera android.hardware.camera2.CameraCharacteristics android.hardware.camera2.legacy.CameraDeviceState ), 0, this, n, camera, cameraCharacteristics, cameraDeviceState);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$start(), 0, this);
    }

    public long flush() {
        return (long)InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$flush(), 0, this);
    }

    public void quit() {
        InvokeDynamicSupport.bootstrap("quit", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$quit(), 0, this);
    }

    public SubmitInfo submitCaptureRequests(CaptureRequest[] captureRequestArray, boolean bl) {
        return InvokeDynamicSupport.bootstrap("submitCaptureRequests", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$submitCaptureRequests(android.hardware.camera2.CaptureRequest[] boolean ), 0, this, captureRequestArray, bl);
    }

    public long cancelRepeating(int n) {
        return (long)InvokeDynamicSupport.bootstrap("cancelRepeating", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$cancelRepeating(int ), 0, this, n);
    }

    public void configure(Collection<Pair<Surface, Size>> collection) {
        InvokeDynamicSupport.bootstrap("configure", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$configure(java.util.Collection<android.util.Pair<android.view.Surface, android.util.Size>> ), 0, this, collection);
    }

    public /* synthetic */ RequestThreadManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestThreadManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FpsCounter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "FpsCounter";
        private int mFrameCount;
        private long mLastTime;
        private long mLastPrintTime;
        private double mLastFps;
        private String mStreamType;
        private static long NANO_PER_SECOND = 1000000000L;

        private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$__constructor__(String streamType) {
            this.mFrameCount = 0;
            this.mLastTime = 0L;
            this.mLastPrintTime = 0L;
            this.mLastFps = 0.0;
            this.mStreamType = streamType;
        }

        private final synchronized void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$countFrame() {
            ++this.mFrameCount;
            long nextTime = SystemClock.elapsedRealtimeNanos();
            if (this.mLastTime == 0L) {
                this.mLastTime = nextTime;
            }
            if (nextTime > this.mLastTime + 1000000000L) {
                long elapsed = nextTime - this.mLastTime;
                this.mLastFps = (double)this.mFrameCount * (1.0E9 / (double)elapsed);
                this.mFrameCount = 0;
                this.mLastTime = nextTime;
            }
        }

        private final synchronized double $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$checkFps() {
            return this.mLastFps;
        }

        private final synchronized void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$staggeredLog() {
            if (this.mLastTime > this.mLastPrintTime + 5000000000L) {
                this.mLastPrintTime = this.mLastTime;
                Log.d("FpsCounter", "FPS for " + this.mStreamType + " stream: " + this.mLastFps);
            }
        }

        private final synchronized void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$countAndLog() {
            this.countFrame();
            this.staggeredLog();
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$__constructor__(string2);
        }

        public FpsCounter(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$__constructor__(java.lang.String ), 0, this, string2);
        }

        public synchronized void countFrame() {
            InvokeDynamicSupport.bootstrap("countFrame", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$countFrame(), 0, this);
        }

        public synchronized double checkFps() {
            return (double)InvokeDynamicSupport.bootstrap("checkFps", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$checkFps(), 0, this);
        }

        public synchronized void staggeredLog() {
            InvokeDynamicSupport.bootstrap("staggeredLog", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$staggeredLog(), 0, this);
        }

        public synchronized void countAndLog() {
            InvokeDynamicSupport.bootstrap("countAndLog", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$countAndLog(), 0, this);
        }

        public /* synthetic */ FpsCounter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FpsCounter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ConfigureHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ConditionVariable condition;
        public Collection<Pair<Surface, Size>> surfaces;

        private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_ConfigureHolder$__constructor__(ConditionVariable condition, Collection<Pair<Surface, Size>> surfaces) {
            this.condition = condition;
            this.surfaces = surfaces;
        }

        private void __constructor__(ConditionVariable conditionVariable, Collection<Pair<Surface, Size>> collection) {
            this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_ConfigureHolder$__constructor__(conditionVariable, collection);
        }

        public ConfigureHolder(ConditionVariable conditionVariable, Collection<Pair<Surface, Size>> collection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_ConfigureHolder$__constructor__(android.os.ConditionVariable java.util.Collection<android.util.Pair<android.view.Surface, android.util.Size>> ), 0, this, conditionVariable, collection);
        }

        public /* synthetic */ ConfigureHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfigureHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

