/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UsbManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "UsbManager";
    public static String ACTION_USB_STATE = "android.hardware.usb.action.USB_STATE";
    public static String ACTION_USB_PORT_CHANGED = "android.hardware.usb.action.USB_PORT_CHANGED";
    public static String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    public static String ACTION_USB_DEVICE_DETACHED = "android.hardware.usb.action.USB_DEVICE_DETACHED";
    public static String ACTION_USB_ACCESSORY_ATTACHED = "android.hardware.usb.action.USB_ACCESSORY_ATTACHED";
    public static String ACTION_USB_ACCESSORY_DETACHED = "android.hardware.usb.action.USB_ACCESSORY_DETACHED";
    public static String USB_CONNECTED = "connected";
    public static String USB_HOST_CONNECTED = "host_connected";
    public static String USB_CONFIGURED = "configured";
    public static String USB_DATA_UNLOCKED = "unlocked";
    public static String USB_CONFIG_CHANGED = "config_changed";
    public static String USB_FUNCTION_NONE = "none";
    public static String USB_FUNCTION_ADB = "adb";
    public static String USB_FUNCTION_RNDIS = "rndis";
    public static String USB_FUNCTION_MTP = "mtp";
    public static String USB_FUNCTION_PTP = "ptp";
    public static String USB_FUNCTION_AUDIO_SOURCE = "audio_source";
    public static String USB_FUNCTION_MIDI = "midi";
    public static String USB_FUNCTION_ACCESSORY = "accessory";
    public static String EXTRA_PORT = "port";
    public static String EXTRA_PORT_STATUS = "portStatus";
    public static String EXTRA_DEVICE = "device";
    public static String EXTRA_ACCESSORY = "accessory";
    public static String EXTRA_PERMISSION_GRANTED = "permission";
    private Context mContext;
    private IUsbManager mService;

    private void $$robo$$android_hardware_usb_UsbManager$__constructor__(Context context, IUsbManager service) {
        this.mContext = context;
        this.mService = service;
    }

    private final HashMap<String, UsbDevice> $$robo$$android_hardware_usb_UsbManager$getDeviceList() {
        Bundle bundle = new Bundle();
        try {
            this.mService.getDeviceList(bundle);
            HashMap<String, UsbDevice> result = new HashMap<String, UsbDevice>();
            for (String name : bundle.keySet()) {
                result.put(name, (UsbDevice)bundle.get(name));
            }
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final UsbDeviceConnection $$robo$$android_hardware_usb_UsbManager$openDevice(UsbDevice device) {
        try {
            String deviceName = device.getDeviceName();
            ParcelFileDescriptor pfd = this.mService.openDevice(deviceName);
            if (pfd != null) {
                UsbDeviceConnection connection = new UsbDeviceConnection(device);
                boolean result = connection.open(deviceName, pfd, this.mContext);
                pfd.close();
                if (result) {
                    return connection;
                }
            }
        }
        catch (Exception e) {
            Log.e("UsbManager", "exception in UsbManager.openDevice", e);
        }
        return null;
    }

    private final UsbAccessory[] $$robo$$android_hardware_usb_UsbManager$getAccessoryList() {
        try {
            UsbAccessory accessory = this.mService.getCurrentAccessory();
            if (accessory == null) {
                return null;
            }
            return new UsbAccessory[]{accessory};
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ParcelFileDescriptor $$robo$$android_hardware_usb_UsbManager$openAccessory(UsbAccessory accessory) {
        try {
            return this.mService.openAccessory(accessory);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_hardware_usb_UsbManager$hasPermission(UsbDevice device) {
        try {
            return this.mService.hasDevicePermission(device);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_hardware_usb_UsbManager$hasPermission(UsbAccessory accessory) {
        try {
            return this.mService.hasAccessoryPermission(accessory);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$requestPermission(UsbDevice device, PendingIntent pi) {
        try {
            this.mService.requestDevicePermission(device, this.mContext.getPackageName(), pi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$requestPermission(UsbAccessory accessory, PendingIntent pi) {
        try {
            this.mService.requestAccessoryPermission(accessory, this.mContext.getPackageName(), pi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$grantPermission(UsbDevice device) {
        this.grantPermission(device, Process.myUid());
    }

    private final void $$robo$$android_hardware_usb_UsbManager$grantPermission(UsbDevice device, int uid) {
        try {
            this.mService.grantDevicePermission(device, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$grantPermission(UsbDevice device, String packageName) {
        try {
            int uid = this.mContext.getPackageManager().getPackageUidAsUser(packageName, this.mContext.getUserId());
            this.grantPermission(device, uid);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("UsbManager", "Package " + packageName + " not found.", e);
        }
    }

    private final boolean $$robo$$android_hardware_usb_UsbManager$isFunctionEnabled(String function) {
        try {
            return this.mService.isFunctionEnabled(function);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$setCurrentFunction(String function, boolean usbDataUnlocked) {
        try {
            this.mService.setCurrentFunction(function, usbDataUnlocked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final UsbPort[] $$robo$$android_hardware_usb_UsbManager$getPorts() {
        try {
            return this.mService.getPorts();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final UsbPortStatus $$robo$$android_hardware_usb_UsbManager$getPortStatus(UsbPort port) {
        Preconditions.checkNotNull(port, "port must not be null");
        try {
            return this.mService.getPortStatus(port.getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$setPortRoles(UsbPort port, int powerRole, int dataRole) {
        Preconditions.checkNotNull(port, "port must not be null");
        UsbPort.checkRoles(powerRole, dataRole);
        try {
            this.mService.setPortRoles(port.getId(), powerRole, dataRole);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$setUsbDeviceConnectionHandler(ComponentName usbDeviceConnectionHandler) {
        try {
            this.mService.setUsbDeviceConnectionHandler(usbDeviceConnectionHandler);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final String $$robo$$android_hardware_usb_UsbManager$addFunction(String functions, String function) {
        if ("none".equals(functions)) {
            return function;
        }
        if (!UsbManager.containsFunction(functions, function)) {
            if (functions.length() > 0) {
                functions = functions + ",";
            }
            functions = functions + function;
        }
        return functions;
    }

    private static final String $$robo$$android_hardware_usb_UsbManager$removeFunction(String functions, String function) {
        String[] split = functions.split(",");
        for (int i = 0; i < split.length; ++i) {
            if (!function.equals(split[i])) continue;
            split[i] = null;
        }
        if (split.length == 1 && split[0] == null) {
            return "none";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (s == null) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    private static final boolean $$robo$$android_hardware_usb_UsbManager$containsFunction(String functions, String function) {
        int index = functions.indexOf(function);
        if (index < 0) {
            return false;
        }
        if (index > 0 && functions.charAt(index - 1) != ',') {
            return false;
        }
        int charAfter = index + function.length();
        return charAfter >= functions.length() || functions.charAt(charAfter) == ',';
    }

    private void __constructor__(Context context, IUsbManager iUsbManager) {
        this.$$robo$$android_hardware_usb_UsbManager$__constructor__(context, iUsbManager);
    }

    public UsbManager(Context context, IUsbManager iUsbManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_UsbManager$__constructor__(android.content.Context android.hardware.usb.IUsbManager ), 0, this, context, iUsbManager);
    }

    public HashMap<String, UsbDevice> getDeviceList() {
        return InvokeDynamicSupport.bootstrap("getDeviceList", $$robo$$android_hardware_usb_UsbManager$getDeviceList(), 0, this);
    }

    public UsbDeviceConnection openDevice(UsbDevice usbDevice) {
        return InvokeDynamicSupport.bootstrap("openDevice", $$robo$$android_hardware_usb_UsbManager$openDevice(android.hardware.usb.UsbDevice ), 0, this, usbDevice);
    }

    public UsbAccessory[] getAccessoryList() {
        return InvokeDynamicSupport.bootstrap("getAccessoryList", $$robo$$android_hardware_usb_UsbManager$getAccessoryList(), 0, this);
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory usbAccessory) {
        return InvokeDynamicSupport.bootstrap("openAccessory", $$robo$$android_hardware_usb_UsbManager$openAccessory(android.hardware.usb.UsbAccessory ), 0, this, usbAccessory);
    }

    public boolean hasPermission(UsbDevice usbDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPermission", $$robo$$android_hardware_usb_UsbManager$hasPermission(android.hardware.usb.UsbDevice ), 0, this, usbDevice);
    }

    public boolean hasPermission(UsbAccessory usbAccessory) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPermission", $$robo$$android_hardware_usb_UsbManager$hasPermission(android.hardware.usb.UsbAccessory ), 0, this, usbAccessory);
    }

    public void requestPermission(UsbDevice usbDevice, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestPermission", $$robo$$android_hardware_usb_UsbManager$requestPermission(android.hardware.usb.UsbDevice android.app.PendingIntent ), 0, this, usbDevice, pendingIntent);
    }

    public void requestPermission(UsbAccessory usbAccessory, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestPermission", $$robo$$android_hardware_usb_UsbManager$requestPermission(android.hardware.usb.UsbAccessory android.app.PendingIntent ), 0, this, usbAccessory, pendingIntent);
    }

    public void grantPermission(UsbDevice usbDevice) {
        InvokeDynamicSupport.bootstrap("grantPermission", $$robo$$android_hardware_usb_UsbManager$grantPermission(android.hardware.usb.UsbDevice ), 0, this, usbDevice);
    }

    public void grantPermission(UsbDevice usbDevice, int n) {
        InvokeDynamicSupport.bootstrap("grantPermission", $$robo$$android_hardware_usb_UsbManager$grantPermission(android.hardware.usb.UsbDevice int ), 0, this, usbDevice, n);
    }

    public void grantPermission(UsbDevice usbDevice, String string2) {
        InvokeDynamicSupport.bootstrap("grantPermission", $$robo$$android_hardware_usb_UsbManager$grantPermission(android.hardware.usb.UsbDevice java.lang.String ), 0, this, usbDevice, string2);
    }

    public boolean isFunctionEnabled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFunctionEnabled", $$robo$$android_hardware_usb_UsbManager$isFunctionEnabled(java.lang.String ), 0, this, string2);
    }

    public void setCurrentFunction(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentFunction", $$robo$$android_hardware_usb_UsbManager$setCurrentFunction(java.lang.String boolean ), 0, this, string2, bl);
    }

    public UsbPort[] getPorts() {
        return InvokeDynamicSupport.bootstrap("getPorts", $$robo$$android_hardware_usb_UsbManager$getPorts(), 0, this);
    }

    public UsbPortStatus getPortStatus(UsbPort usbPort) {
        return InvokeDynamicSupport.bootstrap("getPortStatus", $$robo$$android_hardware_usb_UsbManager$getPortStatus(android.hardware.usb.UsbPort ), 0, this, usbPort);
    }

    public void setPortRoles(UsbPort usbPort, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setPortRoles", $$robo$$android_hardware_usb_UsbManager$setPortRoles(android.hardware.usb.UsbPort int int ), 0, this, usbPort, n, n2);
    }

    public void setUsbDeviceConnectionHandler(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("setUsbDeviceConnectionHandler", $$robo$$android_hardware_usb_UsbManager$setUsbDeviceConnectionHandler(android.content.ComponentName ), 0, this, componentName);
    }

    public static String addFunction(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("addFunction", $$robo$$android_hardware_usb_UsbManager$addFunction(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String removeFunction(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("removeFunction", $$robo$$android_hardware_usb_UsbManager$removeFunction(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static boolean containsFunction(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsFunction", $$robo$$android_hardware_usb_UsbManager$containsFunction(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public /* synthetic */ UsbManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsbManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

