/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CollationWeights
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int middleLength;
    private int[] minBytes;
    private int[] maxBytes;
    private WeightRange[] ranges;
    private int rangeIndex;
    private int rangeCount;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_coll_CollationWeights$__constructor__() {
        this.minBytes = new int[5];
        this.maxBytes = new int[5];
        this.ranges = new WeightRange[7];
    }

    private final void $$robo$$android_icu_impl_coll_CollationWeights$initForPrimary(boolean compressible) {
        this.middleLength = 1;
        this.minBytes[1] = 3;
        this.maxBytes[1] = 255;
        if (compressible) {
            this.minBytes[2] = 4;
            this.maxBytes[2] = 254;
        } else {
            this.minBytes[2] = 2;
            this.maxBytes[2] = 255;
        }
        this.minBytes[3] = 2;
        this.maxBytes[3] = 255;
        this.minBytes[4] = 2;
        this.maxBytes[4] = 255;
    }

    private final void $$robo$$android_icu_impl_coll_CollationWeights$initForSecondary() {
        this.middleLength = 3;
        this.minBytes[1] = 0;
        this.maxBytes[1] = 0;
        this.minBytes[2] = 0;
        this.maxBytes[2] = 0;
        this.minBytes[3] = 2;
        this.maxBytes[3] = 255;
        this.minBytes[4] = 2;
        this.maxBytes[4] = 255;
    }

    private final void $$robo$$android_icu_impl_coll_CollationWeights$initForTertiary() {
        this.middleLength = 3;
        this.minBytes[1] = 0;
        this.maxBytes[1] = 0;
        this.minBytes[2] = 0;
        this.maxBytes[2] = 0;
        this.minBytes[3] = 2;
        this.maxBytes[3] = 63;
        this.minBytes[4] = 2;
        this.maxBytes[4] = 63;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationWeights$allocWeights(long lowerLimit, long upperLimit, int n) {
        int minLength;
        if (!this.getWeightRanges(lowerLimit, upperLimit)) {
            return false;
        }
        while (!this.allocWeightsInShortRanges(n, minLength = this.ranges[0].length)) {
            if (minLength == 4) {
                return false;
            }
            if (this.allocWeightsInMinLengthRanges(n, minLength)) break;
            int i = 0;
            while (this.ranges[i].length == minLength) {
                this.lengthenRange(this.ranges[i]);
                ++i;
            }
        }
        this.rangeIndex = 0;
        if (this.rangeCount < this.ranges.length) {
            this.ranges[this.rangeCount] = null;
        }
        return true;
    }

    private final long $$robo$$android_icu_impl_coll_CollationWeights$nextWeight() {
        if (this.rangeIndex >= this.rangeCount) {
            return 0xFFFFFFFFL;
        }
        WeightRange range = this.ranges[this.rangeIndex];
        long weight = range.start;
        if (--range.count == 0) {
            ++this.rangeIndex;
        } else {
            range.start = this.incWeight(weight, range.length);
            if (!$assertionsDisabled && range.start > range.end) {
                throw new AssertionError();
            }
        }
        return weight;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationWeights$lengthOfWeight(long weight) {
        if ((weight & 0xFFFFFFL) == 0L) {
            return 1;
        }
        if ((weight & 0xFFFFL) == 0L) {
            return 2;
        }
        if ((weight & 0xFFL) == 0L) {
            return 3;
        }
        return 4;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationWeights$getWeightTrail(long weight, int length) {
        return (int)(weight >> 8 * (4 - length)) & 0xFF;
    }

    private static final long $$robo$$android_icu_impl_coll_CollationWeights$setWeightTrail(long weight, int length, int trail) {
        length = 8 * (4 - length);
        return weight & 0xFFFFFF00L << length | (long)trail << length;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationWeights$getWeightByte(long weight, int idx) {
        return CollationWeights.getWeightTrail(weight, idx);
    }

    private static final long $$robo$$android_icu_impl_coll_CollationWeights$setWeightByte(long weight, int idx, int b) {
        long mask = (idx *= 8) < 32 ? 0xFFFFFFFFL >> idx : 0L;
        idx = 32 - idx;
        return weight & (mask |= 0xFFFFFF00L << idx) | (long)b << idx;
    }

    private static final long $$robo$$android_icu_impl_coll_CollationWeights$truncateWeight(long weight, int length) {
        return weight & 0xFFFFFFFFL << 8 * (4 - length);
    }

    private static final long $$robo$$android_icu_impl_coll_CollationWeights$incWeightTrail(long weight, int length) {
        return weight + (1L << 8 * (4 - length));
    }

    private static final long $$robo$$android_icu_impl_coll_CollationWeights$decWeightTrail(long weight, int length) {
        return weight - (1L << 8 * (4 - length));
    }

    private final int $$robo$$android_icu_impl_coll_CollationWeights$countBytes(int idx) {
        return this.maxBytes[idx] - this.minBytes[idx] + 1;
    }

    private final long $$robo$$android_icu_impl_coll_CollationWeights$incWeight(long weight, int length) {
        do {
            int b;
            if ((b = CollationWeights.getWeightByte(weight, length)) < this.maxBytes[length]) {
                return CollationWeights.setWeightByte(weight, length, b + 1);
            }
            weight = CollationWeights.setWeightByte(weight, length, this.minBytes[length]);
        } while ($assertionsDisabled || --length > 0);
        throw new AssertionError();
    }

    private final long $$robo$$android_icu_impl_coll_CollationWeights$incWeightByOffset(long weight, int length, int offset) {
        do {
            if ((offset += CollationWeights.getWeightByte(weight, length)) <= this.maxBytes[length]) {
                return CollationWeights.setWeightByte(weight, length, offset);
            }
            weight = CollationWeights.setWeightByte(weight, length, this.minBytes[length] + (offset -= this.minBytes[length]) % this.countBytes(length));
            offset /= this.countBytes(length);
        } while ($assertionsDisabled || --length > 0);
        throw new AssertionError();
    }

    private final void $$robo$$android_icu_impl_coll_CollationWeights$lengthenRange(WeightRange range) {
        int length = range.length + 1;
        range.start = CollationWeights.setWeightTrail(range.start, length, this.minBytes[length]);
        range.end = CollationWeights.setWeightTrail(range.end, length, this.maxBytes[length]);
        range.count *= this.countBytes(length);
        range.length = length;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationWeights$getWeightRanges(long lowerLimit, long upperLimit) {
        int trail;
        int length;
        if (!$assertionsDisabled && lowerLimit == 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && upperLimit == 0L) {
            throw new AssertionError();
        }
        int lowerLength = CollationWeights.lengthOfWeight(lowerLimit);
        int upperLength = CollationWeights.lengthOfWeight(upperLimit);
        if (!$assertionsDisabled && lowerLength < this.middleLength) {
            throw new AssertionError();
        }
        if (lowerLimit >= upperLimit) {
            return false;
        }
        if (lowerLength < upperLength && lowerLimit == CollationWeights.truncateWeight(upperLimit, lowerLength)) {
            return false;
        }
        WeightRange[] lower = new WeightRange[5];
        WeightRange middle = new WeightRange();
        WeightRange[] upper = new WeightRange[5];
        long weight = lowerLimit;
        for (length = lowerLength; length > this.middleLength; --length) {
            trail = CollationWeights.getWeightTrail(weight, length);
            if (trail < this.maxBytes[length]) {
                lower[length] = new WeightRange();
                lower[length].start = CollationWeights.incWeightTrail(weight, length);
                lower[length].end = CollationWeights.setWeightTrail(weight, length, this.maxBytes[length]);
                lower[length].length = length;
                lower[length].count = this.maxBytes[length] - trail;
            }
            weight = CollationWeights.truncateWeight(weight, length - 1);
        }
        middle.start = weight < 0xFF000000L ? CollationWeights.incWeightTrail(weight, this.middleLength) : 0xFFFFFFFFL;
        weight = upperLimit;
        for (length = upperLength; length > this.middleLength; --length) {
            trail = CollationWeights.getWeightTrail(weight, length);
            if (trail > this.minBytes[length]) {
                upper[length] = new WeightRange();
                upper[length].start = CollationWeights.setWeightTrail(weight, length, this.minBytes[length]);
                upper[length].end = CollationWeights.decWeightTrail(weight, length);
                upper[length].length = length;
                upper[length].count = trail - this.minBytes[length];
            }
            weight = CollationWeights.truncateWeight(weight, length - 1);
        }
        middle.end = CollationWeights.decWeightTrail(weight, this.middleLength);
        middle.length = this.middleLength;
        if (middle.end >= middle.start) {
            middle.count = (int)(middle.end - middle.start >> 8 * (4 - this.middleLength)) + 1;
        } else {
            for (length = 4; length > this.middleLength; --length) {
                if (lower[length] == null || upper[length] == null || lower[length].count <= 0 || upper[length].count <= 0) continue;
                long lowerEnd = lower[length].end;
                long upperStart = upper[length].start;
                boolean merged = false;
                if (lowerEnd > upperStart) {
                    if (!$assertionsDisabled && CollationWeights.truncateWeight(lowerEnd, length - 1) != CollationWeights.truncateWeight(upperStart, length - 1)) {
                        throw new AssertionError();
                    }
                    lower[length].end = upper[length].end;
                    lower[length].count = CollationWeights.getWeightTrail(lower[length].end, length) - CollationWeights.getWeightTrail(lower[length].start, length) + 1;
                    merged = true;
                } else if (lowerEnd == upperStart) {
                    if (!$assertionsDisabled && this.minBytes[length] >= this.maxBytes[length]) {
                        throw new AssertionError();
                    }
                } else if (this.incWeight(lowerEnd, length) == upperStart) {
                    lower[length].end = upper[length].end;
                    lower[length].count += upper[length].count;
                    merged = true;
                }
                if (!merged) continue;
                upper[length].count = 0;
                while (--length > this.middleLength) {
                    upper[length] = null;
                    lower[length] = null;
                }
                break;
            }
        }
        this.rangeCount = 0;
        if (middle.count > 0) {
            this.ranges[0] = middle;
            this.rangeCount = 1;
        }
        for (length = this.middleLength + 1; length <= 4; ++length) {
            if (upper[length] != null && upper[length].count > 0) {
                this.ranges[this.rangeCount++] = upper[length];
            }
            if (lower[length] == null || lower[length].count <= 0) continue;
            this.ranges[this.rangeCount++] = lower[length];
        }
        return this.rangeCount > 0;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationWeights$allocWeightsInShortRanges(int n, int minLength) {
        for (int i = 0; i < this.rangeCount && this.ranges[i].length <= minLength + 1; ++i) {
            if (n <= this.ranges[i].count) {
                if (this.ranges[i].length > minLength) {
                    this.ranges[i].count = n;
                }
                this.rangeCount = i + 1;
                if (this.rangeCount > 1) {
                    Arrays.sort(this.ranges, 0, this.rangeCount);
                }
                return true;
            }
            n -= this.ranges[i].count;
        }
        return false;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationWeights$allocWeightsInMinLengthRanges(int n, int minLength) {
        int minLengthRangeCount;
        int count = 0;
        for (minLengthRangeCount = 0; minLengthRangeCount < this.rangeCount && this.ranges[minLengthRangeCount].length == minLength; ++minLengthRangeCount) {
            count += this.ranges[minLengthRangeCount].count;
        }
        int nextCountBytes = this.countBytes(minLength + 1);
        if (n > count * nextCountBytes) {
            return false;
        }
        long start = this.ranges[0].start;
        long end = this.ranges[0].end;
        for (int i = 1; i < minLengthRangeCount; ++i) {
            if (this.ranges[i].start < start) {
                start = this.ranges[i].start;
            }
            if (this.ranges[i].end <= end) continue;
            end = this.ranges[i].end;
        }
        int count2 = (n - count) / (nextCountBytes - 1);
        int count1 = count - count2;
        if (!(count2 != 0 && count1 + count2 * nextCountBytes >= n || $assertionsDisabled || --count1 + ++count2 * nextCountBytes >= n)) {
            throw new AssertionError();
        }
        this.ranges[0].start = start;
        if (count1 == 0) {
            this.ranges[0].end = end;
            this.ranges[0].count = count;
            this.lengthenRange(this.ranges[0]);
            this.rangeCount = 1;
        } else {
            this.ranges[0].end = this.incWeightByOffset(start, minLength, count1 - 1);
            this.ranges[0].count = count1;
            if (this.ranges[1] == null) {
                this.ranges[1] = new WeightRange();
            }
            this.ranges[1].start = this.incWeight(this.ranges[0].end, minLength);
            this.ranges[1].end = end;
            this.ranges[1].length = minLength;
            this.ranges[1].count = count2;
            this.lengthenRange(this.ranges[1]);
            this.rangeCount = 2;
        }
        return true;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CollationWeights.class.desiredAssertionStatus();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_coll_CollationWeights$__constructor__();
    }

    public CollationWeights() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationWeights$__constructor__(), 0, this);
    }

    public void initForPrimary(boolean bl) {
        InvokeDynamicSupport.bootstrap("initForPrimary", $$robo$$android_icu_impl_coll_CollationWeights$initForPrimary(boolean ), 0, this, bl);
    }

    public void initForSecondary() {
        InvokeDynamicSupport.bootstrap("initForSecondary", $$robo$$android_icu_impl_coll_CollationWeights$initForSecondary(), 0, this);
    }

    public void initForTertiary() {
        InvokeDynamicSupport.bootstrap("initForTertiary", $$robo$$android_icu_impl_coll_CollationWeights$initForTertiary(), 0, this);
    }

    public boolean allocWeights(long l, long l2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("allocWeights", $$robo$$android_icu_impl_coll_CollationWeights$allocWeights(long long int ), 0, this, l, l2, n);
    }

    public long nextWeight() {
        return (long)InvokeDynamicSupport.bootstrap("nextWeight", $$robo$$android_icu_impl_coll_CollationWeights$nextWeight(), 0, this);
    }

    public static int lengthOfWeight(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lengthOfWeight", $$robo$$android_icu_impl_coll_CollationWeights$lengthOfWeight(long ), 0, (long)l);
    }

    private static int getWeightTrail(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getWeightTrail", $$robo$$android_icu_impl_coll_CollationWeights$getWeightTrail(long int ), 0, (long)l, (int)n);
    }

    private static long setWeightTrail(long l, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("setWeightTrail", $$robo$$android_icu_impl_coll_CollationWeights$setWeightTrail(long int int ), 0, (long)l, (int)n, (int)n2);
    }

    private static int getWeightByte(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getWeightByte", $$robo$$android_icu_impl_coll_CollationWeights$getWeightByte(long int ), 0, (long)l, (int)n);
    }

    private static long setWeightByte(long l, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("setWeightByte", $$robo$$android_icu_impl_coll_CollationWeights$setWeightByte(long int int ), 0, (long)l, (int)n, (int)n2);
    }

    private static long truncateWeight(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("truncateWeight", $$robo$$android_icu_impl_coll_CollationWeights$truncateWeight(long int ), 0, (long)l, (int)n);
    }

    private static long incWeightTrail(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("incWeightTrail", $$robo$$android_icu_impl_coll_CollationWeights$incWeightTrail(long int ), 0, (long)l, (int)n);
    }

    private static long decWeightTrail(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("decWeightTrail", $$robo$$android_icu_impl_coll_CollationWeights$decWeightTrail(long int ), 0, (long)l, (int)n);
    }

    private int countBytes(int n) {
        return (int)InvokeDynamicSupport.bootstrap("countBytes", $$robo$$android_icu_impl_coll_CollationWeights$countBytes(int ), 0, this, n);
    }

    private long incWeight(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("incWeight", $$robo$$android_icu_impl_coll_CollationWeights$incWeight(long int ), 0, this, l, n);
    }

    private long incWeightByOffset(long l, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("incWeightByOffset", $$robo$$android_icu_impl_coll_CollationWeights$incWeightByOffset(long int int ), 0, this, l, n, n2);
    }

    private void lengthenRange(WeightRange weightRange) {
        InvokeDynamicSupport.bootstrap("lengthenRange", $$robo$$android_icu_impl_coll_CollationWeights$lengthenRange(android.icu.impl.coll.CollationWeights$WeightRange ), 0, this, weightRange);
    }

    private boolean getWeightRanges(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getWeightRanges", $$robo$$android_icu_impl_coll_CollationWeights$getWeightRanges(long long ), 0, this, l, l2);
    }

    private boolean allocWeightsInShortRanges(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("allocWeightsInShortRanges", $$robo$$android_icu_impl_coll_CollationWeights$allocWeightsInShortRanges(int int ), 0, this, n, n2);
    }

    private boolean allocWeightsInMinLengthRanges(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("allocWeightsInMinLengthRanges", $$robo$$android_icu_impl_coll_CollationWeights$allocWeightsInMinLengthRanges(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(CollationWeights.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationWeights)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class WeightRange
    implements Comparable<WeightRange> {
        public transient /* synthetic */ Object __robo_data__;
        long start;
        long end;
        int length;
        int count;

        private void $$robo$$android_icu_impl_coll_CollationWeights_WeightRange$__constructor__() {
        }

        private final int $$robo$$android_icu_impl_coll_CollationWeights_WeightRange$compareTo(WeightRange other) {
            long l = this.start;
            long r = other.start;
            if (l < r) {
                return -1;
            }
            if (l > r) {
                return 1;
            }
            return 0;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_coll_CollationWeights_WeightRange$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_coll_CollationWeights_WeightRange$__constructor__();
        }

        private WeightRange() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationWeights_WeightRange$__constructor__(), 0, this);
        }

        @Override
        public int compareTo(WeightRange weightRange) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_impl_coll_CollationWeights_WeightRange$compareTo(android.icu.impl.coll.CollationWeights$WeightRange ), 0, this, weightRange);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_coll_CollationWeights_WeightRange$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WeightRange)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

