/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.locale;

import android.icu.impl.locale.AsciiUtil;
import android.icu.impl.locale.BaseLocale;
import android.icu.impl.locale.Extension;
import android.icu.impl.locale.LocaleExtensions;
import android.icu.impl.locale.ParseStatus;
import android.icu.impl.locale.StringTokenIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LanguageTag
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean JDKIMPL = false;
    public static String SEP = "-";
    public static String PRIVATEUSE = "x";
    public static String UNDETERMINED;
    public static String PRIVUSE_VARIANT_PREFIX = "lvariant";
    private String _language;
    private String _script;
    private String _region;
    private String _privateuse;
    private List<String> _extlangs;
    private List<String> _variants;
    private List<String> _extensions;
    private static Map<AsciiUtil.CaseInsensitiveKey, String[]> GRANDFATHERED;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_locale_LanguageTag$__constructor__() {
        this._language = "";
        this._script = "";
        this._region = "";
        this._privateuse = "";
        this._extlangs = Collections.emptyList();
        this._variants = Collections.emptyList();
        this._extensions = Collections.emptyList();
    }

    private static final LanguageTag $$robo$$android_icu_impl_locale_LanguageTag$parse(String languageTag, ParseStatus sts) {
        StringTokenIterator itr;
        if (sts == null) {
            sts = new ParseStatus();
        } else {
            sts.reset();
        }
        boolean isGrandfathered = false;
        String[] gfmap = GRANDFATHERED.get(new AsciiUtil.CaseInsensitiveKey(languageTag));
        if (gfmap != null) {
            itr = new StringTokenIterator(gfmap[1], "-");
            isGrandfathered = true;
        } else {
            itr = new StringTokenIterator(languageTag, "-");
        }
        LanguageTag tag = new LanguageTag();
        if (tag.parseLanguage(itr, sts)) {
            tag.parseExtlangs(itr, sts);
            tag.parseScript(itr, sts);
            tag.parseRegion(itr, sts);
            tag.parseVariants(itr, sts);
            tag.parseExtensions(itr, sts);
        }
        tag.parsePrivateuse(itr, sts);
        if (isGrandfathered) {
            if (!$assertionsDisabled && !itr.isDone()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && sts.isError()) {
                throw new AssertionError();
            }
            sts._parseLength = languageTag.length();
        } else if (!itr.isDone() && !sts.isError()) {
            String s = itr.current();
            sts._errorIndex = itr.currentStart();
            sts._errorMsg = s.length() == 0 ? "Empty subtag" : "Invalid subtag: " + s;
        }
        return tag;
    }

    private final boolean $$robo$$android_icu_impl_locale_LanguageTag$parseLanguage(StringTokenIterator itr, ParseStatus sts) {
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        String s = itr.current();
        if (LanguageTag.isLanguage(s)) {
            found = true;
            this._language = s;
            sts._parseLength = itr.currentEnd();
            itr.next();
        }
        return found;
    }

    private final boolean $$robo$$android_icu_impl_locale_LanguageTag$parseExtlangs(StringTokenIterator itr, ParseStatus sts) {
        String s;
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        while (!itr.isDone() && LanguageTag.isExtlang(s = itr.current())) {
            found = true;
            if (this._extlangs.isEmpty()) {
                this._extlangs = new ArrayList<String>(3);
            }
            this._extlangs.add(s);
            sts._parseLength = itr.currentEnd();
            itr.next();
            if (this._extlangs.size() != 3) continue;
            break;
        }
        return found;
    }

    private final boolean $$robo$$android_icu_impl_locale_LanguageTag$parseScript(StringTokenIterator itr, ParseStatus sts) {
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        String s = itr.current();
        if (LanguageTag.isScript(s)) {
            found = true;
            this._script = s;
            sts._parseLength = itr.currentEnd();
            itr.next();
        }
        return found;
    }

    private final boolean $$robo$$android_icu_impl_locale_LanguageTag$parseRegion(StringTokenIterator itr, ParseStatus sts) {
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        String s = itr.current();
        if (LanguageTag.isRegion(s)) {
            found = true;
            this._region = s;
            sts._parseLength = itr.currentEnd();
            itr.next();
        }
        return found;
    }

    private final boolean $$robo$$android_icu_impl_locale_LanguageTag$parseVariants(StringTokenIterator itr, ParseStatus sts) {
        String s;
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        while (!itr.isDone() && LanguageTag.isVariant(s = itr.current())) {
            found = true;
            if (this._variants.isEmpty()) {
                this._variants = new ArrayList<String>(3);
            }
            this._variants.add(s);
            sts._parseLength = itr.currentEnd();
            itr.next();
        }
        return found;
    }

    private final boolean $$robo$$android_icu_impl_locale_LanguageTag$parseExtensions(StringTokenIterator itr, ParseStatus sts) {
        String s;
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        while (!itr.isDone() && LanguageTag.isExtensionSingleton(s = itr.current())) {
            int start = itr.currentStart();
            String singleton = s;
            StringBuilder sb = new StringBuilder(singleton);
            itr.next();
            while (!itr.isDone() && LanguageTag.isExtensionSubtag(s = itr.current())) {
                sb.append("-").append(s);
                sts._parseLength = itr.currentEnd();
                itr.next();
            }
            if (sts._parseLength <= start) {
                sts._errorIndex = start;
                sts._errorMsg = "Incomplete extension '" + singleton + "'";
                break;
            }
            if (this._extensions.size() == 0) {
                this._extensions = new ArrayList<String>(4);
            }
            this._extensions.add(sb.toString());
            found = true;
        }
        return found;
    }

    private final boolean $$robo$$android_icu_impl_locale_LanguageTag$parsePrivateuse(StringTokenIterator itr, ParseStatus sts) {
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        String s = itr.current();
        if (LanguageTag.isPrivateusePrefix(s)) {
            int start = itr.currentStart();
            StringBuilder sb = new StringBuilder(s);
            itr.next();
            while (!itr.isDone() && LanguageTag.isPrivateuseSubtag(s = itr.current())) {
                sb.append("-").append(s);
                sts._parseLength = itr.currentEnd();
                itr.next();
            }
            if (sts._parseLength <= start) {
                sts._errorIndex = start;
                sts._errorMsg = "Incomplete privateuse";
            } else {
                this._privateuse = sb.toString();
                found = true;
            }
        }
        return found;
    }

    private static final LanguageTag $$robo$$android_icu_impl_locale_LanguageTag$parseLocale(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        LanguageTag tag = new LanguageTag();
        String language = baseLocale.getLanguage();
        String script = baseLocale.getScript();
        String region = baseLocale.getRegion();
        String variant = baseLocale.getVariant();
        boolean hasSubtag = false;
        String privuseVar = null;
        if (language.length() > 0 && LanguageTag.isLanguage(language)) {
            if (language.equals("iw")) {
                language = "he";
            } else if (language.equals("ji")) {
                language = "yi";
            } else if (language.equals("in")) {
                language = "id";
            }
            tag._language = language;
        }
        if (script.length() > 0 && LanguageTag.isScript(script)) {
            tag._script = LanguageTag.canonicalizeScript(script);
            hasSubtag = true;
        }
        if (region.length() > 0 && LanguageTag.isRegion(region)) {
            tag._region = LanguageTag.canonicalizeRegion(region);
            hasSubtag = true;
        }
        if (variant.length() > 0) {
            String var;
            ArrayList<String> variants = null;
            StringTokenIterator varitr = new StringTokenIterator(variant, "_");
            while (!varitr.isDone() && LanguageTag.isVariant(var = varitr.current())) {
                if (variants == null) {
                    variants = new ArrayList<String>();
                }
                variants.add(LanguageTag.canonicalizeVariant(var));
                varitr.next();
            }
            if (variants != null) {
                tag._variants = variants;
                hasSubtag = true;
            }
            if (!varitr.isDone()) {
                String prvv;
                StringBuilder buf = new StringBuilder();
                while (!varitr.isDone() && LanguageTag.isPrivateuseSubtag(prvv = varitr.current())) {
                    if (buf.length() > 0) {
                        buf.append("-");
                    }
                    prvv = AsciiUtil.toLowerString(prvv);
                    buf.append(prvv);
                    varitr.next();
                }
                if (buf.length() > 0) {
                    privuseVar = buf.toString();
                }
            }
        }
        ArrayList<String> extensions = null;
        String privateuse = null;
        Set<Character> locextKeys = localeExtensions.getKeys();
        for (Character locextKey : locextKeys) {
            Extension ext = localeExtensions.getExtension(locextKey);
            if (LanguageTag.isPrivateusePrefixChar(locextKey.charValue())) {
                privateuse = ext.getValue();
                continue;
            }
            if (extensions == null) {
                extensions = new ArrayList<String>();
            }
            extensions.add(locextKey.toString() + "-" + ext.getValue());
        }
        if (extensions != null) {
            tag._extensions = extensions;
            hasSubtag = true;
        }
        if (privuseVar != null) {
            privateuse = privateuse == null ? "lvariant-" + privuseVar : privateuse + "-" + "lvariant" + "-" + privuseVar.replace("_", "-");
        }
        if (privateuse != null) {
            tag._privateuse = privateuse;
        }
        if (tag._language.length() == 0 && (hasSubtag || privateuse == null)) {
            tag._language = UNDETERMINED;
        }
        return tag;
    }

    private final String $$robo$$android_icu_impl_locale_LanguageTag$getLanguage() {
        return this._language;
    }

    private final List<String> $$robo$$android_icu_impl_locale_LanguageTag$getExtlangs() {
        return Collections.unmodifiableList(this._extlangs);
    }

    private final String $$robo$$android_icu_impl_locale_LanguageTag$getScript() {
        return this._script;
    }

    private final String $$robo$$android_icu_impl_locale_LanguageTag$getRegion() {
        return this._region;
    }

    private final List<String> $$robo$$android_icu_impl_locale_LanguageTag$getVariants() {
        return Collections.unmodifiableList(this._variants);
    }

    private final List<String> $$robo$$android_icu_impl_locale_LanguageTag$getExtensions() {
        return Collections.unmodifiableList(this._extensions);
    }

    private final String $$robo$$android_icu_impl_locale_LanguageTag$getPrivateuse() {
        return this._privateuse;
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isLanguage(String s) {
        return s.length() >= 2 && s.length() <= 8 && AsciiUtil.isAlphaString(s);
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isExtlang(String s) {
        return s.length() == 3 && AsciiUtil.isAlphaString(s);
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isScript(String s) {
        return s.length() == 4 && AsciiUtil.isAlphaString(s);
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isRegion(String s) {
        return s.length() == 2 && AsciiUtil.isAlphaString(s) || s.length() == 3 && AsciiUtil.isNumericString(s);
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isVariant(String s) {
        int len = s.length();
        if (len >= 5 && len <= 8) {
            return AsciiUtil.isAlphaNumericString(s);
        }
        if (len == 4) {
            return AsciiUtil.isNumeric(s.charAt(0)) && AsciiUtil.isAlphaNumeric(s.charAt(1)) && AsciiUtil.isAlphaNumeric(s.charAt(2)) && AsciiUtil.isAlphaNumeric(s.charAt(3));
        }
        return false;
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isExtensionSingleton(String s) {
        return s.length() == 1 && AsciiUtil.isAlphaString(s) && !AsciiUtil.caseIgnoreMatch("x", s);
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isExtensionSingletonChar(char c) {
        return LanguageTag.isExtensionSingleton(String.valueOf(c));
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isExtensionSubtag(String s) {
        return s.length() >= 2 && s.length() <= 8 && AsciiUtil.isAlphaNumericString(s);
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isPrivateusePrefix(String s) {
        return s.length() == 1 && AsciiUtil.caseIgnoreMatch("x", s);
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isPrivateusePrefixChar(char c) {
        return AsciiUtil.caseIgnoreMatch("x", String.valueOf(c));
    }

    private static final boolean $$robo$$android_icu_impl_locale_LanguageTag$isPrivateuseSubtag(String s) {
        return s.length() >= 1 && s.length() <= 8 && AsciiUtil.isAlphaNumericString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeLanguage(String s) {
        return AsciiUtil.toLowerString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeExtlang(String s) {
        return AsciiUtil.toLowerString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeScript(String s) {
        return AsciiUtil.toTitleString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeRegion(String s) {
        return AsciiUtil.toUpperString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeVariant(String s) {
        return AsciiUtil.toLowerString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeExtension(String s) {
        return AsciiUtil.toLowerString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeExtensionSingleton(String s) {
        return AsciiUtil.toLowerString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeExtensionSubtag(String s) {
        return AsciiUtil.toLowerString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizePrivateuse(String s) {
        return AsciiUtil.toLowerString(s);
    }

    private static final String $$robo$$android_icu_impl_locale_LanguageTag$canonicalizePrivateuseSubtag(String s) {
        return AsciiUtil.toLowerString(s);
    }

    private final String $$robo$$android_icu_impl_locale_LanguageTag$toString() {
        StringBuilder sb = new StringBuilder();
        if (this._language.length() > 0) {
            sb.append(this._language);
            for (String extlang : this._extlangs) {
                sb.append("-").append(extlang);
            }
            if (this._script.length() > 0) {
                sb.append("-").append(this._script);
            }
            if (this._region.length() > 0) {
                sb.append("-").append(this._region);
            }
            for (String variant : this._variants) {
                sb.append("-").append(variant);
            }
            for (String extension : this._extensions) {
                sb.append("-").append(extension);
            }
        }
        if (this._privateuse.length() > 0) {
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(this._privateuse);
        }
        return sb.toString();
    }

    static void __staticInitializer__() {
        String[][] entries;
        $assertionsDisabled = !LanguageTag.class.desiredAssertionStatus();
        UNDETERMINED = "und";
        GRANDFATHERED = new HashMap<AsciiUtil.CaseInsensitiveKey, String[]>();
        for (String[] e : entries = new String[][]{{"art-lojban", "jbo"}, {"cel-gaulish", "xtg-x-cel-gaulish"}, {"en-GB-oed", "en-GB-x-oed"}, {"i-ami", "ami"}, {"i-bnn", "bnn"}, {"i-default", "en-x-i-default"}, {"i-enochian", "und-x-i-enochian"}, {"i-hak", "hak"}, {"i-klingon", "tlh"}, {"i-lux", "lb"}, {"i-mingo", "see-x-i-mingo"}, {"i-navajo", "nv"}, {"i-pwn", "pwn"}, {"i-tao", "tao"}, {"i-tay", "tay"}, {"i-tsu", "tsu"}, {"no-bok", "nb"}, {"no-nyn", "nn"}, {"sgn-BE-FR", "sfb"}, {"sgn-BE-NL", "vgt"}, {"sgn-CH-DE", "sgg"}, {"zh-guoyu", "cmn"}, {"zh-hakka", "hak"}, {"zh-min", "nan-x-zh-min"}, {"zh-min-nan", "nan"}, {"zh-xiang", "hsn"}}) {
            GRANDFATHERED.put(new AsciiUtil.CaseInsensitiveKey(e[0]), e);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_locale_LanguageTag$__constructor__();
    }

    private LanguageTag() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_LanguageTag$__constructor__(), 0, this);
    }

    public static LanguageTag parse(String string2, ParseStatus parseStatus) {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_icu_impl_locale_LanguageTag$parse(java.lang.String android.icu.impl.locale.ParseStatus ), 0, (String)string2, (ParseStatus)parseStatus);
    }

    private boolean parseLanguage(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseLanguage", $$robo$$android_icu_impl_locale_LanguageTag$parseLanguage(android.icu.impl.locale.StringTokenIterator android.icu.impl.locale.ParseStatus ), 0, this, stringTokenIterator, parseStatus);
    }

    private boolean parseExtlangs(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseExtlangs", $$robo$$android_icu_impl_locale_LanguageTag$parseExtlangs(android.icu.impl.locale.StringTokenIterator android.icu.impl.locale.ParseStatus ), 0, this, stringTokenIterator, parseStatus);
    }

    private boolean parseScript(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseScript", $$robo$$android_icu_impl_locale_LanguageTag$parseScript(android.icu.impl.locale.StringTokenIterator android.icu.impl.locale.ParseStatus ), 0, this, stringTokenIterator, parseStatus);
    }

    private boolean parseRegion(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseRegion", $$robo$$android_icu_impl_locale_LanguageTag$parseRegion(android.icu.impl.locale.StringTokenIterator android.icu.impl.locale.ParseStatus ), 0, this, stringTokenIterator, parseStatus);
    }

    private boolean parseVariants(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseVariants", $$robo$$android_icu_impl_locale_LanguageTag$parseVariants(android.icu.impl.locale.StringTokenIterator android.icu.impl.locale.ParseStatus ), 0, this, stringTokenIterator, parseStatus);
    }

    private boolean parseExtensions(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseExtensions", $$robo$$android_icu_impl_locale_LanguageTag$parseExtensions(android.icu.impl.locale.StringTokenIterator android.icu.impl.locale.ParseStatus ), 0, this, stringTokenIterator, parseStatus);
    }

    private boolean parsePrivateuse(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        return (boolean)InvokeDynamicSupport.bootstrap("parsePrivateuse", $$robo$$android_icu_impl_locale_LanguageTag$parsePrivateuse(android.icu.impl.locale.StringTokenIterator android.icu.impl.locale.ParseStatus ), 0, this, stringTokenIterator, parseStatus);
    }

    public static LanguageTag parseLocale(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        return InvokeDynamicSupport.bootstrapStatic("parseLocale", $$robo$$android_icu_impl_locale_LanguageTag$parseLocale(android.icu.impl.locale.BaseLocale android.icu.impl.locale.LocaleExtensions ), 0, (BaseLocale)baseLocale, (LocaleExtensions)localeExtensions);
    }

    public String getLanguage() {
        return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_icu_impl_locale_LanguageTag$getLanguage(), 0, this);
    }

    public List<String> getExtlangs() {
        return InvokeDynamicSupport.bootstrap("getExtlangs", $$robo$$android_icu_impl_locale_LanguageTag$getExtlangs(), 0, this);
    }

    public String getScript() {
        return InvokeDynamicSupport.bootstrap("getScript", $$robo$$android_icu_impl_locale_LanguageTag$getScript(), 0, this);
    }

    public String getRegion() {
        return InvokeDynamicSupport.bootstrap("getRegion", $$robo$$android_icu_impl_locale_LanguageTag$getRegion(), 0, this);
    }

    public List<String> getVariants() {
        return InvokeDynamicSupport.bootstrap("getVariants", $$robo$$android_icu_impl_locale_LanguageTag$getVariants(), 0, this);
    }

    public List<String> getExtensions() {
        return InvokeDynamicSupport.bootstrap("getExtensions", $$robo$$android_icu_impl_locale_LanguageTag$getExtensions(), 0, this);
    }

    public String getPrivateuse() {
        return InvokeDynamicSupport.bootstrap("getPrivateuse", $$robo$$android_icu_impl_locale_LanguageTag$getPrivateuse(), 0, this);
    }

    public static boolean isLanguage(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLanguage", $$robo$$android_icu_impl_locale_LanguageTag$isLanguage(java.lang.String ), 0, (String)string2);
    }

    public static boolean isExtlang(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExtlang", $$robo$$android_icu_impl_locale_LanguageTag$isExtlang(java.lang.String ), 0, (String)string2);
    }

    public static boolean isScript(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isScript", $$robo$$android_icu_impl_locale_LanguageTag$isScript(java.lang.String ), 0, (String)string2);
    }

    public static boolean isRegion(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRegion", $$robo$$android_icu_impl_locale_LanguageTag$isRegion(java.lang.String ), 0, (String)string2);
    }

    public static boolean isVariant(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVariant", $$robo$$android_icu_impl_locale_LanguageTag$isVariant(java.lang.String ), 0, (String)string2);
    }

    public static boolean isExtensionSingleton(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExtensionSingleton", $$robo$$android_icu_impl_locale_LanguageTag$isExtensionSingleton(java.lang.String ), 0, (String)string2);
    }

    public static boolean isExtensionSingletonChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExtensionSingletonChar", $$robo$$android_icu_impl_locale_LanguageTag$isExtensionSingletonChar(char ), 0, (char)c);
    }

    public static boolean isExtensionSubtag(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExtensionSubtag", $$robo$$android_icu_impl_locale_LanguageTag$isExtensionSubtag(java.lang.String ), 0, (String)string2);
    }

    public static boolean isPrivateusePrefix(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrivateusePrefix", $$robo$$android_icu_impl_locale_LanguageTag$isPrivateusePrefix(java.lang.String ), 0, (String)string2);
    }

    public static boolean isPrivateusePrefixChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrivateusePrefixChar", $$robo$$android_icu_impl_locale_LanguageTag$isPrivateusePrefixChar(char ), 0, (char)c);
    }

    public static boolean isPrivateuseSubtag(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrivateuseSubtag", $$robo$$android_icu_impl_locale_LanguageTag$isPrivateuseSubtag(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizeLanguage(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizeLanguage", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeLanguage(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizeExtlang(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizeExtlang", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeExtlang(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizeScript(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizeScript", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeScript(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizeRegion(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizeRegion", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeRegion(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizeVariant(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizeVariant", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeVariant(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizeExtension(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizeExtension", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeExtension(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizeExtensionSingleton(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizeExtensionSingleton", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeExtensionSingleton(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizeExtensionSubtag(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizeExtensionSubtag", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizeExtensionSubtag(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizePrivateuse(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizePrivateuse", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizePrivateuse(java.lang.String ), 0, (String)string2);
    }

    public static String canonicalizePrivateuseSubtag(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizePrivateuseSubtag", $$robo$$android_icu_impl_locale_LanguageTag$canonicalizePrivateuseSubtag(java.lang.String ), 0, (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_LanguageTag$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(LanguageTag.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LanguageTag)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

