/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.locale;

import android.icu.impl.locale.AsciiUtil;
import android.icu.impl.locale.Extension;
import android.icu.impl.locale.InternalLocaleBuilder;
import android.icu.impl.locale.LanguageTag;
import android.icu.impl.locale.UnicodeLocaleExtension;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocaleExtensions
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SortedMap<Character, Extension> _map;
    private String _id;
    private static SortedMap<Character, Extension> EMPTY_MAP;
    public static LocaleExtensions EMPTY_EXTENSIONS;
    public static LocaleExtensions CALENDAR_JAPANESE;
    public static LocaleExtensions NUMBER_THAI;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_locale_LocaleExtensions$__constructor__() {
    }

    private void $$robo$$android_icu_impl_locale_LocaleExtensions$__constructor__(Map<InternalLocaleBuilder.CaseInsensitiveChar, String> extensions, Set<InternalLocaleBuilder.CaseInsensitiveString> uattributes, Map<InternalLocaleBuilder.CaseInsensitiveString, String> ukeywords) {
        boolean hasUKeywords;
        boolean hasExtension = extensions != null && extensions.size() > 0;
        boolean hasUAttributes = uattributes != null && uattributes.size() > 0;
        boolean bl = hasUKeywords = ukeywords != null && ukeywords.size() > 0;
        if (!(hasExtension || hasUAttributes || hasUKeywords)) {
            this._map = EMPTY_MAP;
            this._id = "";
            return;
        }
        this._map = new TreeMap<Character, Extension>();
        if (hasExtension) {
            for (Map.Entry<InternalLocaleBuilder.CaseInsensitiveChar, String> ext : extensions.entrySet()) {
                char key = AsciiUtil.toLower(ext.getKey().value());
                String value = ext.getValue();
                if (LanguageTag.isPrivateusePrefixChar(key) && (value = InternalLocaleBuilder.removePrivateuseVariant(value)) == null) continue;
                Extension e = new Extension(key, AsciiUtil.toLowerString(value));
                this._map.put(Character.valueOf(key), e);
            }
        }
        if (hasUAttributes || hasUKeywords) {
            TreeSet<String> uaset = null;
            TreeMap<String, String> ukmap = null;
            if (hasUAttributes) {
                uaset = new TreeSet<String>();
                for (InternalLocaleBuilder.CaseInsensitiveString cis : uattributes) {
                    uaset.add(AsciiUtil.toLowerString(cis.value()));
                }
            }
            if (hasUKeywords) {
                ukmap = new TreeMap<String, String>();
                for (Map.Entry<InternalLocaleBuilder.CaseInsensitiveString, String> kwd : ukeywords.entrySet()) {
                    String key = AsciiUtil.toLowerString(kwd.getKey().value());
                    String type = AsciiUtil.toLowerString(kwd.getValue());
                    ukmap.put(key, type);
                }
            }
            UnicodeLocaleExtension ule = new UnicodeLocaleExtension(uaset, ukmap);
            this._map.put(Character.valueOf('u'), ule);
        }
        if (this._map.size() == 0) {
            this._map = EMPTY_MAP;
            this._id = "";
        } else {
            this._id = LocaleExtensions.toID(this._map);
        }
    }

    private final Set<Character> $$robo$$android_icu_impl_locale_LocaleExtensions$getKeys() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    private final Extension $$robo$$android_icu_impl_locale_LocaleExtensions$getExtension(Character key) {
        return (Extension)this._map.get(Character.valueOf(AsciiUtil.toLower(key.charValue())));
    }

    private final String $$robo$$android_icu_impl_locale_LocaleExtensions$getExtensionValue(Character key) {
        Extension ext = (Extension)this._map.get(Character.valueOf(AsciiUtil.toLower(key.charValue())));
        if (ext == null) {
            return null;
        }
        return ext.getValue();
    }

    private final Set<String> $$robo$$android_icu_impl_locale_LocaleExtensions$getUnicodeLocaleAttributes() {
        Extension ext = (Extension)this._map.get(Character.valueOf('u'));
        if (ext == null) {
            return Collections.emptySet();
        }
        if (!$assertionsDisabled && !(ext instanceof UnicodeLocaleExtension)) {
            throw new AssertionError();
        }
        return ((UnicodeLocaleExtension)ext).getUnicodeLocaleAttributes();
    }

    private final Set<String> $$robo$$android_icu_impl_locale_LocaleExtensions$getUnicodeLocaleKeys() {
        Extension ext = (Extension)this._map.get(Character.valueOf('u'));
        if (ext == null) {
            return Collections.emptySet();
        }
        if (!$assertionsDisabled && !(ext instanceof UnicodeLocaleExtension)) {
            throw new AssertionError();
        }
        return ((UnicodeLocaleExtension)ext).getUnicodeLocaleKeys();
    }

    private final String $$robo$$android_icu_impl_locale_LocaleExtensions$getUnicodeLocaleType(String unicodeLocaleKey) {
        Extension ext = (Extension)this._map.get(Character.valueOf('u'));
        if (ext == null) {
            return null;
        }
        if (!$assertionsDisabled && !(ext instanceof UnicodeLocaleExtension)) {
            throw new AssertionError();
        }
        return ((UnicodeLocaleExtension)ext).getUnicodeLocaleType(AsciiUtil.toLowerString(unicodeLocaleKey));
    }

    private final boolean $$robo$$android_icu_impl_locale_LocaleExtensions$isEmpty() {
        return this._map.isEmpty();
    }

    private static final boolean $$robo$$android_icu_impl_locale_LocaleExtensions$isValidKey(char c) {
        return LanguageTag.isExtensionSingletonChar(c) || LanguageTag.isPrivateusePrefixChar(c);
    }

    private static final boolean $$robo$$android_icu_impl_locale_LocaleExtensions$isValidUnicodeLocaleKey(String ukey) {
        return UnicodeLocaleExtension.isKey(ukey);
    }

    private static final String $$robo$$android_icu_impl_locale_LocaleExtensions$toID(SortedMap<Character, Extension> map) {
        StringBuilder buf = new StringBuilder();
        Extension privuse = null;
        for (Map.Entry<Character, Extension> entry : map.entrySet()) {
            char singleton = entry.getKey().charValue();
            Extension extension = entry.getValue();
            if (LanguageTag.isPrivateusePrefixChar(singleton)) {
                privuse = extension;
                continue;
            }
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append(extension);
        }
        if (privuse != null) {
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append(privuse);
        }
        return buf.toString();
    }

    private final String $$robo$$android_icu_impl_locale_LocaleExtensions$toString() {
        return this._id;
    }

    private final String $$robo$$android_icu_impl_locale_LocaleExtensions$getID() {
        return this._id;
    }

    private final int $$robo$$android_icu_impl_locale_LocaleExtensions$hashCode() {
        return this._id.hashCode();
    }

    private final boolean $$robo$$android_icu_impl_locale_LocaleExtensions$equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocaleExtensions)) {
            return false;
        }
        return this._id.equals(((LocaleExtensions)other)._id);
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !LocaleExtensions.class.desiredAssertionStatus();
        EMPTY_MAP = Collections.unmodifiableSortedMap(new TreeMap());
        EMPTY_EXTENSIONS = new LocaleExtensions();
        LocaleExtensions.EMPTY_EXTENSIONS._id = "";
        LocaleExtensions.EMPTY_EXTENSIONS._map = EMPTY_MAP;
        CALENDAR_JAPANESE = new LocaleExtensions();
        LocaleExtensions.CALENDAR_JAPANESE._id = "u-ca-japanese";
        LocaleExtensions.CALENDAR_JAPANESE._map = new TreeMap<Character, Extension>();
        LocaleExtensions.CALENDAR_JAPANESE._map.put(Character.valueOf('u'), UnicodeLocaleExtension.CA_JAPANESE);
        NUMBER_THAI = new LocaleExtensions();
        LocaleExtensions.NUMBER_THAI._id = "u-nu-thai";
        LocaleExtensions.NUMBER_THAI._map = new TreeMap<Character, Extension>();
        LocaleExtensions.NUMBER_THAI._map.put(Character.valueOf('u'), UnicodeLocaleExtension.NU_THAI);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_locale_LocaleExtensions$__constructor__();
    }

    private LocaleExtensions() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_LocaleExtensions$__constructor__(), 0, this);
    }

    private void __constructor__(Map<InternalLocaleBuilder.CaseInsensitiveChar, String> map, Set<InternalLocaleBuilder.CaseInsensitiveString> set, Map<InternalLocaleBuilder.CaseInsensitiveString, String> map2) {
        this.$$robo$$android_icu_impl_locale_LocaleExtensions$__constructor__(map, set, map2);
    }

    LocaleExtensions(Map<InternalLocaleBuilder.CaseInsensitiveChar, String> map, Set<InternalLocaleBuilder.CaseInsensitiveString> set, Map<InternalLocaleBuilder.CaseInsensitiveString, String> map2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_LocaleExtensions$__constructor__(java.util.Map<android.icu.impl.locale.InternalLocaleBuilder$CaseInsensitiveChar, java.lang.String> java.util.Set<android.icu.impl.locale.InternalLocaleBuilder$CaseInsensitiveString> java.util.Map<android.icu.impl.locale.InternalLocaleBuilder$CaseInsensitiveString, java.lang.String> ), 0, this, map, set, map2);
    }

    public Set<Character> getKeys() {
        return InvokeDynamicSupport.bootstrap("getKeys", $$robo$$android_icu_impl_locale_LocaleExtensions$getKeys(), 0, this);
    }

    public Extension getExtension(Character c) {
        return InvokeDynamicSupport.bootstrap("getExtension", $$robo$$android_icu_impl_locale_LocaleExtensions$getExtension(java.lang.Character ), 0, this, c);
    }

    public String getExtensionValue(Character c) {
        return InvokeDynamicSupport.bootstrap("getExtensionValue", $$robo$$android_icu_impl_locale_LocaleExtensions$getExtensionValue(java.lang.Character ), 0, this, c);
    }

    public Set<String> getUnicodeLocaleAttributes() {
        return InvokeDynamicSupport.bootstrap("getUnicodeLocaleAttributes", $$robo$$android_icu_impl_locale_LocaleExtensions$getUnicodeLocaleAttributes(), 0, this);
    }

    public Set<String> getUnicodeLocaleKeys() {
        return InvokeDynamicSupport.bootstrap("getUnicodeLocaleKeys", $$robo$$android_icu_impl_locale_LocaleExtensions$getUnicodeLocaleKeys(), 0, this);
    }

    public String getUnicodeLocaleType(String string2) {
        return InvokeDynamicSupport.bootstrap("getUnicodeLocaleType", $$robo$$android_icu_impl_locale_LocaleExtensions$getUnicodeLocaleType(java.lang.String ), 0, this, string2);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_icu_impl_locale_LocaleExtensions$isEmpty(), 0, this);
    }

    public static boolean isValidKey(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidKey", $$robo$$android_icu_impl_locale_LocaleExtensions$isValidKey(char ), 0, (char)c);
    }

    public static boolean isValidUnicodeLocaleKey(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidUnicodeLocaleKey", $$robo$$android_icu_impl_locale_LocaleExtensions$isValidUnicodeLocaleKey(java.lang.String ), 0, (String)string2);
    }

    private static String toID(SortedMap<Character, Extension> sortedMap) {
        return InvokeDynamicSupport.bootstrapStatic("toID", $$robo$$android_icu_impl_locale_LocaleExtensions$toID(java.util.SortedMap<java.lang.Character, android.icu.impl.locale.Extension> ), 0, sortedMap);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_LocaleExtensions$toString(), 0, this);
    }

    public String getID() {
        return InvokeDynamicSupport.bootstrap("getID", $$robo$$android_icu_impl_locale_LocaleExtensions$getID(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_locale_LocaleExtensions$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_locale_LocaleExtensions$equals(java.lang.Object ), 0, this, object);
    }

    static {
        RobolectricInternals.classInitializing(LocaleExtensions.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleExtensions)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

