/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.lang.UCharacter;
import android.icu.text.Collator;
import android.icu.text.Normalizer2;
import android.icu.text.RuleBasedCollator;
import android.icu.text.UTF16;
import android.icu.text.UnicodeSet;
import android.icu.text.UnicodeSetIterator;
import android.icu.util.LocaleData;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AlphabeticIndex<V>
implements Iterable<Bucket<V>> {
    public transient /* synthetic */ Object __robo_data__;
    private static String BASE = "\ufdd0";
    private static char CGJ = '\u034f';
    private static Comparator<String> binaryCmp;
    private RuleBasedCollator collatorOriginal;
    private RuleBasedCollator collatorPrimaryOnly;
    private RuleBasedCollator collatorExternal;
    private Comparator<Record<V>> recordComparator;
    private List<String> firstCharsInScripts;
    private UnicodeSet initialLabels;
    private List<Record<V>> inputList;
    private BucketList<V> buckets;
    private String overflowLabel;
    private String underflowLabel;
    private String inflowLabel;
    private int maxLabelCount;
    private static int GC_LU_MASK = 2;
    private static int GC_LL_MASK = 4;
    private static int GC_LT_MASK = 8;
    private static int GC_LM_MASK = 16;
    private static int GC_LO_MASK = 32;
    private static int GC_L_MASK = 62;
    private static int GC_CN_MASK = 1;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_AlphabeticIndex$__constructor__(ULocale locale) {
    }

    private void $$robo$$android_icu_text_AlphabeticIndex$__constructor__(Locale locale) {
    }

    private void $$robo$$android_icu_text_AlphabeticIndex$__constructor__(RuleBasedCollator collator) {
    }

    private void $$robo$$android_icu_text_AlphabeticIndex$__constructor__(ULocale locale, RuleBasedCollator collator) {
        this.recordComparator = new Comparator<Record<V>>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AlphabeticIndex this$0;

            private void $$robo$$android_icu_text_AlphabeticIndex_1$__constructor__(AlphabeticIndex this$0) {
            }

            private final int $$robo$$android_icu_text_AlphabeticIndex_1$compare(Record<V> o1, Record<V> o2) {
                return this.this$0.collatorOriginal.compare(o1.name, o2.name);
            }

            private void __constructor__(AlphabeticIndex alphabeticIndex) {
                this.$$robo$$android_icu_text_AlphabeticIndex_1$__constructor__(alphabeticIndex);
            }
            {
                this.this$0 = alphabeticIndex;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex_1$__constructor__(android.icu.text.AlphabeticIndex ), 0, this, alphabeticIndex);
            }

            @Override
            public int compare(Record<V> record, Record<V> record2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_text_AlphabeticIndex_1$compare(android.icu.text.AlphabeticIndex$Record<V> android.icu.text.AlphabeticIndex$Record<V> ), 0, this, record, record2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.initialLabels = new UnicodeSet();
        this.overflowLabel = "\u2026";
        this.underflowLabel = "\u2026";
        this.inflowLabel = "\u2026";
        this.maxLabelCount = 99;
        this.collatorOriginal = collator != null ? collator : (RuleBasedCollator)Collator.getInstance(locale);
        try {
            this.collatorPrimaryOnly = this.collatorOriginal.cloneAsThawed();
        }
        catch (Exception e) {
            throw new IllegalStateException("Collator cannot be cloned", e);
        }
        this.collatorPrimaryOnly.setStrength(0);
        this.collatorPrimaryOnly.freeze();
        this.firstCharsInScripts = this.getFirstCharactersInScripts();
        Collections.sort(this.firstCharsInScripts, this.collatorPrimaryOnly);
        while (true) {
            if (this.firstCharsInScripts.isEmpty()) {
                throw new IllegalArgumentException("AlphabeticIndex requires some non-ignorable script boundary strings");
            }
            if (this.collatorPrimaryOnly.compare(this.firstCharsInScripts.get(0), "") != 0) break;
            this.firstCharsInScripts.remove(0);
        }
        if (!this.addChineseIndexCharacters() && locale != null) {
            this.addIndexExemplars(locale);
        }
    }

    private final AlphabeticIndex<V> $$robo$$android_icu_text_AlphabeticIndex$addLabels(UnicodeSet additions) {
        this.initialLabels.addAll(additions);
        this.buckets = null;
        return this;
    }

    private final AlphabeticIndex<V> $$robo$$android_icu_text_AlphabeticIndex$addLabels(ULocale ... additions) {
        for (ULocale addition : additions) {
            this.addIndexExemplars(addition);
        }
        this.buckets = null;
        return this;
    }

    private final AlphabeticIndex<V> $$robo$$android_icu_text_AlphabeticIndex$addLabels(Locale ... additions) {
        for (Locale addition : additions) {
            this.addIndexExemplars(ULocale.forLocale(addition));
        }
        this.buckets = null;
        return this;
    }

    private final AlphabeticIndex<V> $$robo$$android_icu_text_AlphabeticIndex$setOverflowLabel(String overflowLabel) {
        this.overflowLabel = overflowLabel;
        this.buckets = null;
        return this;
    }

    private final String $$robo$$android_icu_text_AlphabeticIndex$getUnderflowLabel() {
        return this.underflowLabel;
    }

    private final AlphabeticIndex<V> $$robo$$android_icu_text_AlphabeticIndex$setUnderflowLabel(String underflowLabel) {
        this.underflowLabel = underflowLabel;
        this.buckets = null;
        return this;
    }

    private final String $$robo$$android_icu_text_AlphabeticIndex$getOverflowLabel() {
        return this.overflowLabel;
    }

    private final AlphabeticIndex<V> $$robo$$android_icu_text_AlphabeticIndex$setInflowLabel(String inflowLabel) {
        this.inflowLabel = inflowLabel;
        this.buckets = null;
        return this;
    }

    private final String $$robo$$android_icu_text_AlphabeticIndex$getInflowLabel() {
        return this.inflowLabel;
    }

    private final int $$robo$$android_icu_text_AlphabeticIndex$getMaxLabelCount() {
        return this.maxLabelCount;
    }

    private final AlphabeticIndex<V> $$robo$$android_icu_text_AlphabeticIndex$setMaxLabelCount(int maxLabelCount) {
        this.maxLabelCount = maxLabelCount;
        this.buckets = null;
        return this;
    }

    private final List<String> $$robo$$android_icu_text_AlphabeticIndex$initLabels() {
        Normalizer2 nfkdNormalizer = Normalizer2.getNFKDInstance();
        ArrayList<String> indexCharacters = new ArrayList<String>();
        String firstScriptBoundary = this.firstCharsInScripts.get(0);
        String overflowBoundary = this.firstCharsInScripts.get(this.firstCharsInScripts.size() - 1);
        for (String item : this.initialLabels) {
            boolean checkDistinct;
            if (!UTF16.hasMoreCodePointsThan(item, 1)) {
                checkDistinct = false;
            } else if (item.charAt(item.length() - 1) == '*' && item.charAt(item.length() - 2) != '*') {
                item = item.substring(0, item.length() - 1);
                checkDistinct = false;
            } else {
                checkDistinct = true;
            }
            if (this.collatorPrimaryOnly.compare(item, firstScriptBoundary) < 0 || this.collatorPrimaryOnly.compare(item, overflowBoundary) >= 0 || checkDistinct && this.collatorPrimaryOnly.compare(item, this.separated(item)) == 0) continue;
            int insertionPoint = Collections.binarySearch(indexCharacters, item, this.collatorPrimaryOnly);
            if (insertionPoint < 0) {
                indexCharacters.add(~insertionPoint, item);
                continue;
            }
            String itemAlreadyIn = (String)indexCharacters.get(insertionPoint);
            if (!AlphabeticIndex.isOneLabelBetterThanOther(nfkdNormalizer, item, itemAlreadyIn)) continue;
            indexCharacters.set(insertionPoint, item);
        }
        int size = indexCharacters.size() - 1;
        if (size > this.maxLabelCount) {
            int count = 0;
            int old = -1;
            Iterator it = indexCharacters.iterator();
            while (it.hasNext()) {
                it.next();
                int bump = ++count * this.maxLabelCount / size;
                if (bump == old) {
                    it.remove();
                    continue;
                }
                old = bump;
            }
        }
        return indexCharacters;
    }

    private static final String $$robo$$android_icu_text_AlphabeticIndex$fixLabel(String current) {
        if (!current.startsWith("\ufdd0")) {
            return current;
        }
        char rest = current.charAt("\ufdd0".length());
        if ('\u2800' < rest && rest <= '\u28ff') {
            return rest - 10240 + "\u5283";
        }
        return current.substring("\ufdd0".length());
    }

    private final void $$robo$$android_icu_text_AlphabeticIndex$addIndexExemplars(ULocale locale) {
        Object exemplars = LocaleData.getExemplarSet(locale, 0, 2);
        if (exemplars != null) {
            this.initialLabels.addAll((UnicodeSet)exemplars);
            return;
        }
        exemplars = LocaleData.getExemplarSet(locale, 0, 0);
        if (((UnicodeSet)(exemplars = ((UnicodeSet)exemplars).cloneAsThawed())).containsSome(97, 122) || ((UnicodeSet)exemplars).size() == 0) {
            ((UnicodeSet)exemplars).addAll(97, 122);
        }
        if (((UnicodeSet)exemplars).containsSome(44032, 55203)) {
            ((UnicodeSet)exemplars).remove(44032, 55203).add(44032).add(45208).add(45796).add(46972).add(47560).add(48148).add(49324).add(50500).add(51088).add(52264).add(52852).add(53440).add(54028).add(54616);
        }
        if (((UnicodeSet)exemplars).containsSome(4608, 4991)) {
            UnicodeSet ethiopic = new UnicodeSet("[[:Block=Ethiopic:]&[:Script=Ethiopic:]]");
            UnicodeSetIterator it = new UnicodeSetIterator(ethiopic);
            while (it.next() && it.codepoint != UnicodeSetIterator.IS_STRING) {
                if ((it.codepoint & 7) == 0) continue;
                ((UnicodeSet)exemplars).remove(it.codepoint);
            }
        }
        Iterator<String> iterator = ((UnicodeSet)exemplars).iterator();
        while (iterator.hasNext()) {
            String item = iterator.next();
            this.initialLabels.add(UCharacter.toUpperCase(locale, item));
        }
    }

    private final boolean $$robo$$android_icu_text_AlphabeticIndex$addChineseIndexCharacters() {
        UnicodeSet contractions = new UnicodeSet();
        try {
            this.collatorPrimaryOnly.internalAddContractions("\ufdd0".charAt(0), contractions);
        }
        catch (Exception e) {
            return false;
        }
        if (contractions.isEmpty()) {
            return false;
        }
        this.initialLabels.addAll(contractions);
        for (String s : contractions) {
            if (!$assertionsDisabled && !s.startsWith("\ufdd0")) {
                throw new AssertionError();
            }
            char c = s.charAt(s.length() - 1);
            if ('A' > c || c > 'Z') continue;
            this.initialLabels.add(65, 90);
            break;
        }
        return true;
    }

    private final String $$robo$$android_icu_text_AlphabeticIndex$separated(String item) {
        StringBuilder result = new StringBuilder();
        char last = item.charAt(0);
        result.append(last);
        for (int i = 1; i < item.length(); ++i) {
            char ch = item.charAt(i);
            if (!UCharacter.isHighSurrogate(last) || !UCharacter.isLowSurrogate(ch)) {
                result.append('\u034f');
            }
            result.append(ch);
            last = ch;
        }
        return result.toString();
    }

    private final ImmutableIndex<V> $$robo$$android_icu_text_AlphabeticIndex$buildImmutableIndex() {
        BucketList<V> immutableBucketList;
        if (this.inputList != null && !this.inputList.isEmpty()) {
            immutableBucketList = this.createBucketList();
        } else {
            if (this.buckets == null) {
                this.buckets = this.createBucketList();
            }
            immutableBucketList = this.buckets;
        }
        return new ImmutableIndex(immutableBucketList, this.collatorPrimaryOnly);
    }

    private final List<String> $$robo$$android_icu_text_AlphabeticIndex$getBucketLabels() {
        this.initBuckets();
        ArrayList<String> result = new ArrayList<String>();
        for (Bucket<V> bucket : this.buckets) {
            result.add(bucket.getLabel());
        }
        return result;
    }

    private final RuleBasedCollator $$robo$$android_icu_text_AlphabeticIndex$getCollator() {
        if (this.collatorExternal == null) {
            try {
                this.collatorExternal = (RuleBasedCollator)this.collatorOriginal.clone();
            }
            catch (Exception e) {
                throw new IllegalStateException("Collator cannot be cloned", e);
            }
        }
        return this.collatorExternal;
    }

    private final AlphabeticIndex<V> $$robo$$android_icu_text_AlphabeticIndex$addRecord(CharSequence name, V data) {
        this.buckets = null;
        if (this.inputList == null) {
            this.inputList = new ArrayList<Record<V>>();
        }
        this.inputList.add(new Record(name, data));
        return this;
    }

    private final int $$robo$$android_icu_text_AlphabeticIndex$getBucketIndex(CharSequence name) {
        this.initBuckets();
        return ((BucketList)this.buckets).getBucketIndex(name, this.collatorPrimaryOnly);
    }

    private final AlphabeticIndex<V> $$robo$$android_icu_text_AlphabeticIndex$clearRecords() {
        if (this.inputList != null && !this.inputList.isEmpty()) {
            this.inputList.clear();
            this.buckets = null;
        }
        return this;
    }

    private final int $$robo$$android_icu_text_AlphabeticIndex$getBucketCount() {
        this.initBuckets();
        return ((BucketList)this.buckets).getBucketCount();
    }

    private final int $$robo$$android_icu_text_AlphabeticIndex$getRecordCount() {
        return this.inputList != null ? this.inputList.size() : 0;
    }

    private final Iterator<Bucket<V>> $$robo$$android_icu_text_AlphabeticIndex$iterator() {
        this.initBuckets();
        return this.buckets.iterator();
    }

    private final void $$robo$$android_icu_text_AlphabeticIndex$initBuckets() {
        String upperBoundary;
        Bucket nextBucket;
        if (this.buckets != null) {
            return;
        }
        this.buckets = this.createBucketList();
        if (this.inputList == null || this.inputList.isEmpty()) {
            return;
        }
        Collections.sort(this.inputList, this.recordComparator);
        Iterator bucketIterator = ((BucketList)this.buckets).fullIterator();
        Bucket currentBucket = (Bucket)bucketIterator.next();
        if (bucketIterator.hasNext()) {
            nextBucket = (Bucket)bucketIterator.next();
            upperBoundary = nextBucket.lowerBoundary;
        } else {
            nextBucket = null;
            upperBoundary = null;
        }
        for (Record<V> r : this.inputList) {
            while (upperBoundary != null && this.collatorPrimaryOnly.compare(((Record)r).name, (Object)upperBoundary) >= 0) {
                currentBucket = nextBucket;
                if (bucketIterator.hasNext()) {
                    nextBucket = (Bucket)bucketIterator.next();
                    upperBoundary = nextBucket.lowerBoundary;
                    continue;
                }
                upperBoundary = null;
            }
            Bucket bucket = currentBucket;
            if (bucket.displayBucket != null) {
                bucket = bucket.displayBucket;
            }
            if (bucket.records == null) {
                bucket.records = new ArrayList();
            }
            bucket.records.add(r);
        }
    }

    private static final boolean $$robo$$android_icu_text_AlphabeticIndex$isOneLabelBetterThanOther(Normalizer2 nfkdNormalizer, String one, String other) {
        String n1 = nfkdNormalizer.normalize(one);
        String n2 = nfkdNormalizer.normalize(other);
        int result = n1.codePointCount(0, n1.length()) - n2.codePointCount(0, n2.length());
        if (result != 0) {
            return result < 0;
        }
        result = binaryCmp.compare(n1, n2);
        if (result != 0) {
            return result < 0;
        }
        return binaryCmp.compare(one, other) < 0;
    }

    private final BucketList<V> $$robo$$android_icu_text_AlphabeticIndex$createBucketList() {
        Bucket bucket;
        List<String> indexCharacters = this.initLabels();
        long variableTop = this.collatorPrimaryOnly.isAlternateHandlingShifted() ? (long)this.collatorPrimaryOnly.getVariableTop() & 0xFFFFFFFFL : 0L;
        boolean hasInvisibleBuckets = false;
        Bucket[] asciiBuckets = new Bucket[26];
        Bucket[] pinyinBuckets = new Bucket[26];
        boolean hasPinyin = false;
        ArrayList bucketList = new ArrayList();
        bucketList.add(new Bucket(this.getUnderflowLabel(), "", Bucket.LabelType.UNDERFLOW));
        int scriptIndex = -1;
        String scriptUpperBoundary = "";
        block0: for (String current : indexCharacters) {
            Bucket singleBucket;
            char c;
            if (this.collatorPrimaryOnly.compare(current, scriptUpperBoundary) >= 0) {
                String inflowBoundary = scriptUpperBoundary;
                boolean skippedScript = false;
                while (this.collatorPrimaryOnly.compare(current, scriptUpperBoundary = this.firstCharsInScripts.get(++scriptIndex)) >= 0) {
                    skippedScript = true;
                }
                if (skippedScript && bucketList.size() > 1) {
                    bucketList.add(new Bucket(this.getInflowLabel(), inflowBoundary, Bucket.LabelType.INFLOW));
                }
            }
            bucket = new Bucket(AlphabeticIndex.fixLabel(current), current, Bucket.LabelType.NORMAL);
            bucketList.add(bucket);
            if (current.length() == 1 && 'A' <= (c = current.charAt(0)) && c <= 'Z') {
                asciiBuckets[c - 65] = bucket;
            } else if (current.length() == "\ufdd0".length() + 1 && current.startsWith("\ufdd0") && 'A' <= (c = current.charAt("\ufdd0".length())) && c <= 'Z') {
                pinyinBuckets[c - 65] = bucket;
                hasPinyin = true;
            }
            if (current.startsWith("\ufdd0") || !AlphabeticIndex.hasMultiplePrimaryWeights(this.collatorPrimaryOnly, variableTop, current) || current.endsWith("\uffff")) continue;
            int n = bucketList.size() - 2;
            while ((singleBucket = (Bucket)bucketList.get(n)).labelType == Bucket.LabelType.NORMAL) {
                if (singleBucket.displayBucket == null && !AlphabeticIndex.hasMultiplePrimaryWeights(this.collatorPrimaryOnly, variableTop, singleBucket.lowerBoundary)) {
                    bucket = new Bucket("", current + "\uffff", Bucket.LabelType.NORMAL);
                    bucket.displayBucket = singleBucket;
                    bucketList.add(bucket);
                    hasInvisibleBuckets = true;
                    continue block0;
                }
                --n;
            }
        }
        if (bucketList.size() == 1) {
            return new BucketList(bucketList, bucketList);
        }
        bucketList.add(new Bucket(this.getOverflowLabel(), scriptUpperBoundary, Bucket.LabelType.OVERFLOW));
        if (hasPinyin) {
            Bucket asciiBucket = null;
            for (int i = 0; i < 26; ++i) {
                if (asciiBuckets[i] != null) {
                    asciiBucket = asciiBuckets[i];
                }
                if (pinyinBuckets[i] == null || asciiBucket == null) continue;
                pinyinBuckets[i].displayBucket = asciiBucket;
                hasInvisibleBuckets = true;
            }
        }
        if (!hasInvisibleBuckets) {
            return new BucketList(bucketList, bucketList);
        }
        int i = bucketList.size() - 1;
        Bucket nextBucket = (Bucket)bucketList.get(i);
        while (--i > 0) {
            bucket = (Bucket)bucketList.get(i);
            if (bucket.displayBucket != null) continue;
            if (bucket.labelType == Bucket.LabelType.INFLOW && nextBucket.labelType != Bucket.LabelType.NORMAL) {
                bucket.displayBucket = nextBucket;
                continue;
            }
            nextBucket = bucket;
        }
        ArrayList<Bucket> publicBucketList = new ArrayList<Bucket>();
        for (Bucket bucket2 : bucketList) {
            if (bucket2.displayBucket != null) continue;
            publicBucketList.add(bucket2);
        }
        return new BucketList(bucketList, publicBucketList);
    }

    private static final boolean $$robo$$android_icu_text_AlphabeticIndex$hasMultiplePrimaryWeights(RuleBasedCollator coll, long variableTop, String s) {
        long[] ces = coll.internalGetCEs(s);
        boolean seenPrimary = false;
        for (int i = 0; i < ces.length; ++i) {
            long ce = ces[i];
            long p = ce >>> 32;
            if (p <= variableTop) continue;
            if (seenPrimary) {
                return true;
            }
            seenPrimary = true;
        }
        return false;
    }

    @Deprecated
    private final List<String> $$robo$$android_icu_text_AlphabeticIndex$getFirstCharactersInScripts() {
        ArrayList<String> dest = new ArrayList<String>(200);
        UnicodeSet set = new UnicodeSet();
        this.collatorPrimaryOnly.internalAddContractions(64977, set);
        if (set.isEmpty()) {
            throw new UnsupportedOperationException("AlphabeticIndex requires script-first-primary contractions");
        }
        for (String boundary : set) {
            int gcMask = 1 << UCharacter.getType(boundary.codePointAt(1));
            if ((gcMask & 0x3F) == 0) continue;
            dest.add(boundary);
        }
        return dest;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !AlphabeticIndex.class.desiredAssertionStatus();
        binaryCmp = new UTF16.StringComparator(true, false, 0);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_text_AlphabeticIndex$__constructor__(uLocale);
    }

    public AlphabeticIndex(ULocale uLocale) {
        this(uLocale, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_text_AlphabeticIndex$__constructor__(locale);
    }

    public AlphabeticIndex(Locale locale) {
        this(ULocale.forLocale(locale), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex$__constructor__(java.util.Locale ), 0, this, locale);
    }

    private void __constructor__(RuleBasedCollator ruleBasedCollator) {
        this.$$robo$$android_icu_text_AlphabeticIndex$__constructor__(ruleBasedCollator);
    }

    public AlphabeticIndex(RuleBasedCollator ruleBasedCollator) {
        this(null, ruleBasedCollator);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex$__constructor__(android.icu.text.RuleBasedCollator ), 0, this, ruleBasedCollator);
    }

    private void __constructor__(ULocale uLocale, RuleBasedCollator ruleBasedCollator) {
        this.$$robo$$android_icu_text_AlphabeticIndex$__constructor__(uLocale, ruleBasedCollator);
    }

    private AlphabeticIndex(ULocale uLocale, RuleBasedCollator ruleBasedCollator) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex$__constructor__(android.icu.util.ULocale android.icu.text.RuleBasedCollator ), 0, this, uLocale, ruleBasedCollator);
    }

    public AlphabeticIndex<V> addLabels(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("addLabels", $$robo$$android_icu_text_AlphabeticIndex$addLabels(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public AlphabeticIndex<V> addLabels(ULocale ... uLocaleArray) {
        return InvokeDynamicSupport.bootstrap("addLabels", $$robo$$android_icu_text_AlphabeticIndex$addLabels(android.icu.util.ULocale[] ), 0, this, uLocaleArray);
    }

    public AlphabeticIndex<V> addLabels(Locale ... localeArray) {
        return InvokeDynamicSupport.bootstrap("addLabels", $$robo$$android_icu_text_AlphabeticIndex$addLabels(java.util.Locale[] ), 0, this, localeArray);
    }

    public AlphabeticIndex<V> setOverflowLabel(String string2) {
        return InvokeDynamicSupport.bootstrap("setOverflowLabel", $$robo$$android_icu_text_AlphabeticIndex$setOverflowLabel(java.lang.String ), 0, this, string2);
    }

    public String getUnderflowLabel() {
        return InvokeDynamicSupport.bootstrap("getUnderflowLabel", $$robo$$android_icu_text_AlphabeticIndex$getUnderflowLabel(), 0, this);
    }

    public AlphabeticIndex<V> setUnderflowLabel(String string2) {
        return InvokeDynamicSupport.bootstrap("setUnderflowLabel", $$robo$$android_icu_text_AlphabeticIndex$setUnderflowLabel(java.lang.String ), 0, this, string2);
    }

    public String getOverflowLabel() {
        return InvokeDynamicSupport.bootstrap("getOverflowLabel", $$robo$$android_icu_text_AlphabeticIndex$getOverflowLabel(), 0, this);
    }

    public AlphabeticIndex<V> setInflowLabel(String string2) {
        return InvokeDynamicSupport.bootstrap("setInflowLabel", $$robo$$android_icu_text_AlphabeticIndex$setInflowLabel(java.lang.String ), 0, this, string2);
    }

    public String getInflowLabel() {
        return InvokeDynamicSupport.bootstrap("getInflowLabel", $$robo$$android_icu_text_AlphabeticIndex$getInflowLabel(), 0, this);
    }

    public int getMaxLabelCount() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxLabelCount", $$robo$$android_icu_text_AlphabeticIndex$getMaxLabelCount(), 0, this);
    }

    public AlphabeticIndex<V> setMaxLabelCount(int n) {
        return InvokeDynamicSupport.bootstrap("setMaxLabelCount", $$robo$$android_icu_text_AlphabeticIndex$setMaxLabelCount(int ), 0, this, n);
    }

    private List<String> initLabels() {
        return InvokeDynamicSupport.bootstrap("initLabels", $$robo$$android_icu_text_AlphabeticIndex$initLabels(), 0, this);
    }

    private static String fixLabel(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fixLabel", $$robo$$android_icu_text_AlphabeticIndex$fixLabel(java.lang.String ), 0, (String)string2);
    }

    private void addIndexExemplars(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("addIndexExemplars", $$robo$$android_icu_text_AlphabeticIndex$addIndexExemplars(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private boolean addChineseIndexCharacters() {
        return (boolean)InvokeDynamicSupport.bootstrap("addChineseIndexCharacters", $$robo$$android_icu_text_AlphabeticIndex$addChineseIndexCharacters(), 0, this);
    }

    private String separated(String string2) {
        return InvokeDynamicSupport.bootstrap("separated", $$robo$$android_icu_text_AlphabeticIndex$separated(java.lang.String ), 0, this, string2);
    }

    public ImmutableIndex<V> buildImmutableIndex() {
        return InvokeDynamicSupport.bootstrap("buildImmutableIndex", $$robo$$android_icu_text_AlphabeticIndex$buildImmutableIndex(), 0, this);
    }

    public List<String> getBucketLabels() {
        return InvokeDynamicSupport.bootstrap("getBucketLabels", $$robo$$android_icu_text_AlphabeticIndex$getBucketLabels(), 0, this);
    }

    public RuleBasedCollator getCollator() {
        return InvokeDynamicSupport.bootstrap("getCollator", $$robo$$android_icu_text_AlphabeticIndex$getCollator(), 0, this);
    }

    public AlphabeticIndex<V> addRecord(CharSequence charSequence, V v) {
        return InvokeDynamicSupport.bootstrap("addRecord", $$robo$$android_icu_text_AlphabeticIndex$addRecord(java.lang.CharSequence V ), 0, this, charSequence, v);
    }

    public int getBucketIndex(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrap("getBucketIndex", $$robo$$android_icu_text_AlphabeticIndex$getBucketIndex(java.lang.CharSequence ), 0, this, charSequence);
    }

    public AlphabeticIndex<V> clearRecords() {
        return InvokeDynamicSupport.bootstrap("clearRecords", $$robo$$android_icu_text_AlphabeticIndex$clearRecords(), 0, this);
    }

    public int getBucketCount() {
        return (int)InvokeDynamicSupport.bootstrap("getBucketCount", $$robo$$android_icu_text_AlphabeticIndex$getBucketCount(), 0, this);
    }

    public int getRecordCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRecordCount", $$robo$$android_icu_text_AlphabeticIndex$getRecordCount(), 0, this);
    }

    @Override
    public Iterator<Bucket<V>> iterator() {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_text_AlphabeticIndex$iterator(), 0, this);
    }

    private void initBuckets() {
        InvokeDynamicSupport.bootstrap("initBuckets", $$robo$$android_icu_text_AlphabeticIndex$initBuckets(), 0, this);
    }

    private static boolean isOneLabelBetterThanOther(Normalizer2 normalizer2, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOneLabelBetterThanOther", $$robo$$android_icu_text_AlphabeticIndex$isOneLabelBetterThanOther(android.icu.text.Normalizer2 java.lang.String java.lang.String ), 0, (Normalizer2)normalizer2, (String)string2, (String)string3);
    }

    private BucketList<V> createBucketList() {
        return InvokeDynamicSupport.bootstrap("createBucketList", $$robo$$android_icu_text_AlphabeticIndex$createBucketList(), 0, this);
    }

    private static boolean hasMultiplePrimaryWeights(RuleBasedCollator ruleBasedCollator, long l, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasMultiplePrimaryWeights", $$robo$$android_icu_text_AlphabeticIndex$hasMultiplePrimaryWeights(android.icu.text.RuleBasedCollator long java.lang.String ), 0, (RuleBasedCollator)ruleBasedCollator, (long)l, (String)string2);
    }

    @Deprecated
    public List<String> getFirstCharactersInScripts() {
        return InvokeDynamicSupport.bootstrap("getFirstCharactersInScripts", $$robo$$android_icu_text_AlphabeticIndex$getFirstCharactersInScripts(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AlphabeticIndex.class);
    }

    public /* synthetic */ AlphabeticIndex() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlphabeticIndex)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class BucketList<V>
    implements Iterable<Bucket<V>> {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<Bucket<V>> bucketList;
        private List<Bucket<V>> immutableVisibleList;

        private void $$robo$$android_icu_text_AlphabeticIndex_BucketList$__constructor__(ArrayList<Bucket<V>> bucketList, ArrayList<Bucket<V>> publicBucketList) {
            this.bucketList = bucketList;
            int displayIndex = 0;
            for (Bucket<V> bucket : publicBucketList) {
                ((Bucket)bucket).displayIndex = displayIndex++;
            }
            this.immutableVisibleList = Collections.unmodifiableList(publicBucketList);
        }

        private final int $$robo$$android_icu_text_AlphabeticIndex_BucketList$getBucketCount() {
            return this.immutableVisibleList.size();
        }

        private final int $$robo$$android_icu_text_AlphabeticIndex_BucketList$getBucketIndex(CharSequence name, Collator collatorPrimaryOnly) {
            int start = 0;
            int limit = this.bucketList.size();
            while (start + 1 < limit) {
                int i = (start + limit) / 2;
                Bucket<V> bucket = this.bucketList.get(i);
                int nameVsBucket = collatorPrimaryOnly.compare(name, (Object)((Bucket)bucket).lowerBoundary);
                if (nameVsBucket < 0) {
                    limit = i;
                    continue;
                }
                start = i;
            }
            Bucket bucket = this.bucketList.get(start);
            if (bucket.displayBucket != null) {
                bucket = bucket.displayBucket;
            }
            return bucket.displayIndex;
        }

        private final Iterator<Bucket<V>> $$robo$$android_icu_text_AlphabeticIndex_BucketList$fullIterator() {
            return this.bucketList.iterator();
        }

        private final Iterator<Bucket<V>> $$robo$$android_icu_text_AlphabeticIndex_BucketList$iterator() {
            return this.immutableVisibleList.iterator();
        }

        private /* synthetic */ void $$robo$$android_icu_text_AlphabeticIndex_BucketList$__constructor__(ArrayList x0, ArrayList x1, 1 x2) {
        }

        private void __constructor__(ArrayList<Bucket<V>> arrayList, ArrayList<Bucket<V>> arrayList2) {
            this.$$robo$$android_icu_text_AlphabeticIndex_BucketList$__constructor__(arrayList, arrayList2);
        }

        private BucketList(ArrayList<Bucket<V>> arrayList, ArrayList<Bucket<V>> arrayList2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex_BucketList$__constructor__(java.util.ArrayList<android.icu.text.AlphabeticIndex$Bucket<V>> java.util.ArrayList<android.icu.text.AlphabeticIndex$Bucket<V>> ), 0, this, arrayList, arrayList2);
        }

        private int getBucketCount() {
            return (int)InvokeDynamicSupport.bootstrap("getBucketCount", $$robo$$android_icu_text_AlphabeticIndex_BucketList$getBucketCount(), 0, this);
        }

        private int getBucketIndex(CharSequence charSequence, Collator collator) {
            return (int)InvokeDynamicSupport.bootstrap("getBucketIndex", $$robo$$android_icu_text_AlphabeticIndex_BucketList$getBucketIndex(java.lang.CharSequence android.icu.text.Collator ), 0, this, charSequence, collator);
        }

        private Iterator<Bucket<V>> fullIterator() {
            return InvokeDynamicSupport.bootstrap("fullIterator", $$robo$$android_icu_text_AlphabeticIndex_BucketList$fullIterator(), 0, this);
        }

        @Override
        public Iterator<Bucket<V>> iterator() {
            return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_text_AlphabeticIndex_BucketList$iterator(), 0, this);
        }

        private /* synthetic */ void __constructor__(ArrayList arrayList, ArrayList arrayList2, 1 var3_3) {
            this.$$robo$$android_icu_text_AlphabeticIndex_BucketList$__constructor__(arrayList, arrayList2, var3_3);
        }

        public /* synthetic */ BucketList() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BucketList)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Bucket<V>
    implements Iterable<Record<V>> {
        public transient /* synthetic */ Object __robo_data__;
        private String label;
        private String lowerBoundary;
        private LabelType labelType;
        private Bucket<V> displayBucket;
        private int displayIndex;
        private List<Record<V>> records;

        private void $$robo$$android_icu_text_AlphabeticIndex_Bucket$__constructor__(String label, String lowerBoundary, LabelType labelType) {
            this.label = label;
            this.lowerBoundary = lowerBoundary;
            this.labelType = labelType;
        }

        private final String $$robo$$android_icu_text_AlphabeticIndex_Bucket$getLabel() {
            return this.label;
        }

        private final LabelType $$robo$$android_icu_text_AlphabeticIndex_Bucket$getLabelType() {
            return this.labelType;
        }

        private final int $$robo$$android_icu_text_AlphabeticIndex_Bucket$size() {
            return this.records == null ? 0 : this.records.size();
        }

        private final Iterator<Record<V>> $$robo$$android_icu_text_AlphabeticIndex_Bucket$iterator() {
            if (this.records == null) {
                return Collections.emptyList().iterator();
            }
            return this.records.iterator();
        }

        private final String $$robo$$android_icu_text_AlphabeticIndex_Bucket$toString() {
            return "{labelType=" + (Object)((Object)this.labelType) + ", lowerBoundary=" + this.lowerBoundary + ", label=" + this.label + "}";
        }

        private /* synthetic */ void $$robo$$android_icu_text_AlphabeticIndex_Bucket$__constructor__(String x0, String x1, LabelType x2, 1 x3) {
        }

        private void __constructor__(String string2, String string3, LabelType labelType) {
            this.$$robo$$android_icu_text_AlphabeticIndex_Bucket$__constructor__(string2, string3, labelType);
        }

        private Bucket(String string2, String string3, LabelType labelType) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex_Bucket$__constructor__(java.lang.String java.lang.String android.icu.text.AlphabeticIndex$Bucket$LabelType ), 0, this, string2, string3, labelType);
        }

        public String getLabel() {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_icu_text_AlphabeticIndex_Bucket$getLabel(), 0, this);
        }

        public LabelType getLabelType() {
            return InvokeDynamicSupport.bootstrap("getLabelType", $$robo$$android_icu_text_AlphabeticIndex_Bucket$getLabelType(), 0, this);
        }

        public int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_icu_text_AlphabeticIndex_Bucket$size(), 0, this);
        }

        @Override
        public Iterator<Record<V>> iterator() {
            return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_text_AlphabeticIndex_Bucket$iterator(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_AlphabeticIndex_Bucket$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(String string2, String string3, LabelType labelType, 1 var4_4) {
            this.$$robo$$android_icu_text_AlphabeticIndex_Bucket$__constructor__(string2, string3, labelType, var4_4);
        }

        public /* synthetic */ Bucket() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Bucket)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class LabelType
        extends Enum<LabelType> {
            public transient /* synthetic */ Object __robo_data__;
            public static /* enum */ LabelType NORMAL;
            public static /* enum */ LabelType UNDERFLOW;
            public static /* enum */ LabelType INFLOW;
            public static /* enum */ LabelType OVERFLOW;
            private static /* synthetic */ LabelType[] $VALUES;

            private static final LabelType[] $$robo$$android_icu_text_AlphabeticIndex_Bucket_LabelType$values() {
                return (LabelType[])$VALUES.clone();
            }

            private static final LabelType $$robo$$android_icu_text_AlphabeticIndex_Bucket_LabelType$valueOf(String name) {
                return Enum.valueOf(LabelType.class, name);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void $$robo$$android_icu_text_AlphabeticIndex_Bucket_LabelType$__constructor__(String string2, int n) {
            }

            static void __staticInitializer__() {
                NORMAL = new LabelType();
                UNDERFLOW = new LabelType();
                INFLOW = new LabelType();
                OVERFLOW = new LabelType();
                $VALUES = new LabelType[]{NORMAL, UNDERFLOW, INFLOW, OVERFLOW};
            }

            public static LabelType[] values() {
                return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_AlphabeticIndex_Bucket_LabelType$values(), 0);
            }

            public static LabelType valueOf(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_AlphabeticIndex_Bucket_LabelType$valueOf(java.lang.String ), 0, (String)string2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void __constructor__(String string2, int n) {
                this.$$robo$$android_icu_text_AlphabeticIndex_Bucket_LabelType$__constructor__(string2, n);
            }

            private LabelType() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex_Bucket_LabelType$__constructor__(java.lang.String int ), 0, this, string2, n);
            }

            static {
                RobolectricInternals.classInitializing(LabelType.class);
            }

            public /* synthetic */ LabelType() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LabelType)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class Record<V> {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence name;
        private V data;

        private void $$robo$$android_icu_text_AlphabeticIndex_Record$__constructor__(CharSequence name, V data) {
            this.name = name;
            this.data = data;
        }

        private final CharSequence $$robo$$android_icu_text_AlphabeticIndex_Record$getName() {
            return this.name;
        }

        private final V $$robo$$android_icu_text_AlphabeticIndex_Record$getData() {
            return this.data;
        }

        private final String $$robo$$android_icu_text_AlphabeticIndex_Record$toString() {
            return this.name + "=" + this.data;
        }

        private /* synthetic */ void $$robo$$android_icu_text_AlphabeticIndex_Record$__constructor__(CharSequence x0, Object x1, 1 x2) {
        }

        private void __constructor__(CharSequence charSequence, V v) {
            this.$$robo$$android_icu_text_AlphabeticIndex_Record$__constructor__(charSequence, v);
        }

        private Record(CharSequence charSequence, V v) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex_Record$__constructor__(java.lang.CharSequence V ), 0, this, charSequence, v);
        }

        public CharSequence getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_text_AlphabeticIndex_Record$getName(), 0, this);
        }

        public V getData() {
            return (V)InvokeDynamicSupport.bootstrap("getData", $$robo$$android_icu_text_AlphabeticIndex_Record$getData(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_AlphabeticIndex_Record$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(CharSequence charSequence, Object object, 1 var3_3) {
            this.$$robo$$android_icu_text_AlphabeticIndex_Record$__constructor__(charSequence, object, var3_3);
        }

        public /* synthetic */ Record() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Record)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ImmutableIndex<V>
    implements Iterable<Bucket<V>> {
        public transient /* synthetic */ Object __robo_data__;
        private BucketList<V> buckets;
        private Collator collatorPrimaryOnly;

        private void $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$__constructor__(BucketList<V> bucketList, Collator collatorPrimaryOnly) {
            this.buckets = bucketList;
            this.collatorPrimaryOnly = collatorPrimaryOnly;
        }

        private final int $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$getBucketCount() {
            return ((BucketList)this.buckets).getBucketCount();
        }

        private final int $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$getBucketIndex(CharSequence name) {
            return ((BucketList)this.buckets).getBucketIndex(name, this.collatorPrimaryOnly);
        }

        private final Bucket<V> $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$getBucket(int index) {
            if (0 <= index && index < ((BucketList)this.buckets).getBucketCount()) {
                return (Bucket)((BucketList)this.buckets).immutableVisibleList.get(index);
            }
            return null;
        }

        private final Iterator<Bucket<V>> $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$iterator() {
            return this.buckets.iterator();
        }

        private /* synthetic */ void $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$__constructor__(BucketList x0, Collator x1, 1 x2) {
        }

        private void __constructor__(BucketList<V> bucketList, Collator collator) {
            this.$$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$__constructor__(bucketList, collator);
        }

        private ImmutableIndex(BucketList<V> bucketList, Collator collator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$__constructor__(android.icu.text.AlphabeticIndex$BucketList<V> android.icu.text.Collator ), 0, this, bucketList, collator);
        }

        public int getBucketCount() {
            return (int)InvokeDynamicSupport.bootstrap("getBucketCount", $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$getBucketCount(), 0, this);
        }

        public int getBucketIndex(CharSequence charSequence) {
            return (int)InvokeDynamicSupport.bootstrap("getBucketIndex", $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$getBucketIndex(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Bucket<V> getBucket(int n) {
            return InvokeDynamicSupport.bootstrap("getBucket", $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$getBucket(int ), 0, this, n);
        }

        @Override
        public Iterator<Bucket<V>> iterator() {
            return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$iterator(), 0, this);
        }

        private /* synthetic */ void __constructor__(BucketList bucketList, Collator collator, 1 var3_3) {
            this.$$robo$$android_icu_text_AlphabeticIndex_ImmutableIndex$__constructor__(bucketList, collator, var3_3);
        }

        public /* synthetic */ ImmutableIndex() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImmutableIndex)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

