/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.impl.UResource;
import android.icu.text.DecimalFormat;
import android.icu.text.NumberingSystem;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CompactDecimalDataCache
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String SHORT_STYLE = "short";
    private static String LONG_STYLE = "long";
    private static String SHORT_CURRENCY_STYLE = "shortCurrency";
    private static String NUMBER_ELEMENTS = "NumberElements";
    private static String PATTERNS_LONG = "patternsLong";
    private static String PATTERNS_SHORT = "patternsShort";
    private static String DECIMAL_FORMAT = "decimalFormat";
    private static String CURRENCY_FORMAT = "currencyFormat";
    private static String LATIN_NUMBERING_SYSTEM = "latn";
    public static String OTHER = "other";
    static int MAX_DIGITS = 15;
    private ICUCache<ULocale, DataBundle> cache;

    private void $$robo$$android_icu_text_CompactDecimalDataCache$__constructor__() {
        this.cache = new SimpleCache<ULocale, DataBundle>();
    }

    private final DataBundle $$robo$$android_icu_text_CompactDecimalDataCache$get(ULocale locale) {
        DataBundle result = this.cache.get(locale);
        if (result == null) {
            result = CompactDecimalDataCache.load(locale);
            this.cache.put(locale, result);
        }
        return result;
    }

    private static final DataBundle $$robo$$android_icu_text_CompactDecimalDataCache$load(ULocale ulocale) throws MissingResourceException {
        DataBundle dataBundle = DataBundle.createEmpty();
        String nsName = NumberingSystem.getInstance(ulocale).getName();
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", ulocale);
        CompactDecimalDataSink sink = new CompactDecimalDataSink(dataBundle, ulocale);
        sink.isFallback = false;
        if (!nsName.equals("latn")) {
            sink.isLatin = false;
            try {
                r.getAllItemsWithFallback("NumberElements/" + nsName, sink);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            sink.isFallback = true;
        }
        sink.isLatin = true;
        r.getAllItemsWithFallback("NumberElements/latn", sink);
        if (dataBundle.longData.isEmpty()) {
            dataBundle.longData = dataBundle.shortData;
        }
        CompactDecimalDataCache.checkForOtherVariants(dataBundle.longData, ulocale, "long");
        CompactDecimalDataCache.checkForOtherVariants(dataBundle.shortData, ulocale, "short");
        CompactDecimalDataCache.checkForOtherVariants(dataBundle.shortCurrencyData, ulocale, "shortCurrency");
        CompactDecimalDataCache.fillInMissing(dataBundle.longData);
        CompactDecimalDataCache.fillInMissing(dataBundle.shortData);
        CompactDecimalDataCache.fillInMissing(dataBundle.shortCurrencyData);
        return dataBundle;
    }

    private static final int $$robo$$android_icu_text_CompactDecimalDataCache$populatePrefixSuffix(String pluralVariant, int idx, String template, ULocale locale, String style2, Data destination, boolean overwrite) {
        int i;
        String suffix;
        int firstIdx = template.indexOf("0");
        int lastIdx = template.lastIndexOf("0");
        if (firstIdx == -1) {
            throw new IllegalArgumentException("Expect at least one zero in template '" + template + "' for variant '" + pluralVariant + "' for 10^" + idx + " in " + CompactDecimalDataCache.localeAndStyle(locale, style2));
        }
        String prefix = template.substring(0, firstIdx);
        boolean saved = CompactDecimalDataCache.saveUnit(new DecimalFormat.Unit(prefix, suffix = template.substring(lastIdx + 1)), pluralVariant, idx, destination.units, overwrite);
        if (!saved) {
            return -1;
        }
        if (prefix.trim().length() == 0 && suffix.trim().length() == 0) {
            return idx + 1;
        }
        for (i = firstIdx + 1; i <= lastIdx && template.charAt(i) == '0'; ++i) {
        }
        return i - firstIdx;
    }

    private static final long $$robo$$android_icu_text_CompactDecimalDataCache$calculateDivisor(long power10, int numZeros) {
        long divisor = power10;
        for (int i = 1; i < numZeros; ++i) {
            divisor /= 10L;
        }
        return divisor;
    }

    private static final String $$robo$$android_icu_text_CompactDecimalDataCache$localeAndStyle(ULocale locale, String style2) {
        return "locale '" + locale + "' style '" + style2 + "'";
    }

    private static final void $$robo$$android_icu_text_CompactDecimalDataCache$checkForOtherVariants(Data data, ULocale locale, String style2) {
        DecimalFormat.Unit[] otherByBase = data.units.get("other");
        if (otherByBase == null) {
            throw new IllegalArgumentException("No 'other' plural variants defined in " + CompactDecimalDataCache.localeAndStyle(locale, style2));
        }
        for (Map.Entry<String, DecimalFormat.Unit[]> entry : data.units.entrySet()) {
            if (entry.getKey() == "other") continue;
            DecimalFormat.Unit[] variantByBase = entry.getValue();
            for (int log10Value = 0; log10Value < 15; ++log10Value) {
                if (variantByBase[log10Value] == null || otherByBase[log10Value] != null) continue;
                throw new IllegalArgumentException("No 'other' plural variant defined for 10^" + log10Value + " but a '" + entry.getKey() + "' variant is defined in " + CompactDecimalDataCache.localeAndStyle(locale, style2));
            }
        }
    }

    private static final void $$robo$$android_icu_text_CompactDecimalDataCache$fillInMissing(Data result) {
        long lastDivisor = 1L;
        for (int i = 0; i < result.divisors.length; ++i) {
            if (result.units.get("other")[i] == null) {
                result.divisors[i] = lastDivisor;
                CompactDecimalDataCache.copyFromPreviousIndex(i, result.units);
                continue;
            }
            lastDivisor = result.divisors[i];
            CompactDecimalDataCache.propagateOtherToMissing(i, result.units);
        }
    }

    private static final void $$robo$$android_icu_text_CompactDecimalDataCache$propagateOtherToMissing(int idx, Map<String, DecimalFormat.Unit[]> units) {
        DecimalFormat.Unit otherVariantValue = units.get("other")[idx];
        for (DecimalFormat.Unit[] byBase : units.values()) {
            if (byBase[idx] != null) continue;
            byBase[idx] = otherVariantValue;
        }
    }

    private static final void $$robo$$android_icu_text_CompactDecimalDataCache$copyFromPreviousIndex(int idx, Map<String, DecimalFormat.Unit[]> units) {
        for (DecimalFormat.Unit[] byBase : units.values()) {
            if (idx == 0) {
                byBase[idx] = DecimalFormat.NULL_UNIT;
                continue;
            }
            byBase[idx] = byBase[idx - 1];
        }
    }

    private static final boolean $$robo$$android_icu_text_CompactDecimalDataCache$saveUnit(DecimalFormat.Unit unit, String pluralVariant, int idx, Map<String, DecimalFormat.Unit[]> units, boolean overwrite) {
        DecimalFormat.Unit[] byBase = units.get(pluralVariant);
        if (byBase == null) {
            byBase = new DecimalFormat.Unit[15];
            units.put(pluralVariant, byBase);
        }
        if (!overwrite && byBase[idx] != null) {
            return false;
        }
        byBase[idx] = unit;
        return true;
    }

    private static final DecimalFormat.Unit $$robo$$android_icu_text_CompactDecimalDataCache$getUnit(Map<String, DecimalFormat.Unit[]> units, String variant, int base) {
        DecimalFormat.Unit[] byBase = units.get(variant);
        if (byBase == null) {
            byBase = units.get("other");
        }
        return byBase[base];
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_CompactDecimalDataCache$__constructor__();
    }

    CompactDecimalDataCache() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache$__constructor__(), 0, this);
    }

    DataBundle get(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_text_CompactDecimalDataCache$get(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private static DataBundle load(ULocale uLocale) throws MissingResourceException {
        return InvokeDynamicSupport.bootstrapStatic("load", $$robo$$android_icu_text_CompactDecimalDataCache$load(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private static int populatePrefixSuffix(String string2, int n, String string3, ULocale uLocale, String string4, Data data, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("populatePrefixSuffix", $$robo$$android_icu_text_CompactDecimalDataCache$populatePrefixSuffix(java.lang.String int java.lang.String android.icu.util.ULocale java.lang.String android.icu.text.CompactDecimalDataCache$Data boolean ), 0, (String)string2, (int)n, (String)string3, (ULocale)uLocale, (String)string4, (Data)data, (boolean)bl);
    }

    private static long calculateDivisor(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("calculateDivisor", $$robo$$android_icu_text_CompactDecimalDataCache$calculateDivisor(long int ), 0, (long)l, (int)n);
    }

    private static String localeAndStyle(ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("localeAndStyle", $$robo$$android_icu_text_CompactDecimalDataCache$localeAndStyle(android.icu.util.ULocale java.lang.String ), 0, (ULocale)uLocale, (String)string2);
    }

    private static void checkForOtherVariants(Data data, ULocale uLocale, String string2) {
        InvokeDynamicSupport.bootstrapStatic("checkForOtherVariants", $$robo$$android_icu_text_CompactDecimalDataCache$checkForOtherVariants(android.icu.text.CompactDecimalDataCache$Data android.icu.util.ULocale java.lang.String ), 0, (Data)data, (ULocale)uLocale, (String)string2);
    }

    private static void fillInMissing(Data data) {
        InvokeDynamicSupport.bootstrapStatic("fillInMissing", $$robo$$android_icu_text_CompactDecimalDataCache$fillInMissing(android.icu.text.CompactDecimalDataCache$Data ), 0, (Data)data);
    }

    private static void propagateOtherToMissing(int n, Map<String, DecimalFormat.Unit[]> map) {
        InvokeDynamicSupport.bootstrapStatic("propagateOtherToMissing", $$robo$$android_icu_text_CompactDecimalDataCache$propagateOtherToMissing(int java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> ), 0, (int)n, map);
    }

    private static void copyFromPreviousIndex(int n, Map<String, DecimalFormat.Unit[]> map) {
        InvokeDynamicSupport.bootstrapStatic("copyFromPreviousIndex", $$robo$$android_icu_text_CompactDecimalDataCache$copyFromPreviousIndex(int java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> ), 0, (int)n, map);
    }

    private static boolean saveUnit(DecimalFormat.Unit unit, String string2, int n, Map<String, DecimalFormat.Unit[]> map, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("saveUnit", $$robo$$android_icu_text_CompactDecimalDataCache$saveUnit(android.icu.text.DecimalFormat$Unit java.lang.String int java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> boolean ), 0, (DecimalFormat.Unit)unit, (String)string2, (int)n, map, (boolean)bl);
    }

    static DecimalFormat.Unit getUnit(Map<String, DecimalFormat.Unit[]> map, String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getUnit", $$robo$$android_icu_text_CompactDecimalDataCache$getUnit(java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> java.lang.String int ), 0, map, (String)string2, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompactDecimalDataCache)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CompactDecimalDataSink
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private DataBundle dataBundle;
        private ULocale locale;
        private boolean isLatin;
        private boolean isFallback;

        private void $$robo$$android_icu_text_CompactDecimalDataCache_CompactDecimalDataSink$__constructor__(DataBundle dataBundle, ULocale locale) {
            this.dataBundle = dataBundle;
            this.locale = locale;
        }

        private final void $$robo$$android_icu_text_CompactDecimalDataCache_CompactDecimalDataSink$put(UResource.Key key, UResource.Value value, boolean isRoot) {
            if (isRoot && !this.isLatin) {
                return;
            }
            UResource.Table patternsTable = value.getTable();
            int i1 = 0;
            while (patternsTable.getKeyAndValue(i1, key, value)) {
                block14: {
                    PatternsTableKey patternsTableKey;
                    block13: {
                        block12: {
                            if (!key.contentEquals("patternsShort")) break block12;
                            patternsTableKey = PatternsTableKey.PATTERNS_SHORT;
                            break block13;
                        }
                        if (!key.contentEquals("patternsLong")) break block14;
                        patternsTableKey = PatternsTableKey.PATTERNS_LONG;
                    }
                    UResource.Table formatsTable = value.getTable();
                    int i2 = 0;
                    while (formatsTable.getKeyAndValue(i2, key, value)) {
                        block17: {
                            Data destination;
                            String style2;
                            block19: {
                                FormatsTableKey formatsTableKey;
                                block20: {
                                    block18: {
                                        block16: {
                                            block15: {
                                                if (!key.contentEquals("decimalFormat")) break block15;
                                                formatsTableKey = FormatsTableKey.DECIMAL_FORMAT;
                                                break block16;
                                            }
                                            if (!key.contentEquals("currencyFormat")) break block17;
                                            formatsTableKey = FormatsTableKey.CURRENCY_FORMAT;
                                        }
                                        style2 = null;
                                        destination = null;
                                        if (patternsTableKey != PatternsTableKey.PATTERNS_LONG || formatsTableKey != FormatsTableKey.DECIMAL_FORMAT) break block18;
                                        style2 = "long";
                                        destination = this.dataBundle.longData;
                                        break block19;
                                    }
                                    if (patternsTableKey != PatternsTableKey.PATTERNS_SHORT || formatsTableKey != FormatsTableKey.DECIMAL_FORMAT) break block20;
                                    style2 = "short";
                                    destination = this.dataBundle.shortData;
                                    break block19;
                                }
                                if (patternsTableKey != PatternsTableKey.PATTERNS_SHORT || formatsTableKey != FormatsTableKey.CURRENCY_FORMAT) break block17;
                                style2 = "shortCurrency";
                                destination = this.dataBundle.shortCurrencyData;
                            }
                            if (!(this.isFallback && style2 == "long" && !this.dataBundle.shortData.isEmpty() && !this.dataBundle.shortData.fromFallback || isRoot && style2 == "long" && this.dataBundle.longData.isEmpty() && !this.dataBundle.shortData.isEmpty())) {
                                destination.fromFallback = this.isFallback;
                                UResource.Table powersOfTenTable = value.getTable();
                                int i3 = 0;
                                while (powersOfTenTable.getKeyAndValue(i3, key, value)) {
                                    long power10 = Long.parseLong(key.toString());
                                    int log10Value = (int)Math.log10(power10);
                                    if (log10Value < 15) {
                                        UResource.Table pluralVariantsTable = value.getTable();
                                        int i4 = 0;
                                        while (pluralVariantsTable.getKeyAndValue(i4, key, value)) {
                                            String template;
                                            String pluralVariant = key.toString();
                                            int numZeros = CompactDecimalDataCache.populatePrefixSuffix(pluralVariant, log10Value, template = value.toString(), this.locale, style2, destination, false);
                                            if (numZeros >= 0) {
                                                long divisor = CompactDecimalDataCache.calculateDivisor(power10, numZeros);
                                                if (destination.divisors[log10Value] != 0L && destination.divisors[log10Value] != divisor) {
                                                    throw new IllegalArgumentException("Plural variant '" + pluralVariant + "' template '" + template + "' for 10^" + log10Value + " has wrong number of zeros in " + CompactDecimalDataCache.localeAndStyle(this.locale, style2));
                                                }
                                                destination.divisors[log10Value] = divisor;
                                            }
                                            ++i4;
                                        }
                                    }
                                    ++i3;
                                }
                            }
                        }
                        ++i2;
                    }
                }
                ++i1;
            }
        }

        private void __constructor__(DataBundle dataBundle, ULocale uLocale) {
            this.$$robo$$android_icu_text_CompactDecimalDataCache_CompactDecimalDataSink$__constructor__(dataBundle, uLocale);
        }

        public CompactDecimalDataSink(DataBundle dataBundle, ULocale uLocale) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache_CompactDecimalDataSink$__constructor__(android.icu.text.CompactDecimalDataCache$DataBundle android.icu.util.ULocale ), 0, this, dataBundle, uLocale);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_CompactDecimalDataCache_CompactDecimalDataSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        public /* synthetic */ CompactDecimalDataSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompactDecimalDataSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class DataBundle
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Data shortData;
        Data longData;
        Data shortCurrencyData;

        private void $$robo$$android_icu_text_CompactDecimalDataCache_DataBundle$__constructor__(Data shortData, Data longData, Data shortCurrencyData) {
            this.shortData = shortData;
            this.longData = longData;
            this.shortCurrencyData = shortCurrencyData;
        }

        private static final DataBundle $$robo$$android_icu_text_CompactDecimalDataCache_DataBundle$createEmpty() {
            return new DataBundle(new Data(new long[15], new HashMap<String, DecimalFormat.Unit[]>()), new Data(new long[15], new HashMap<String, DecimalFormat.Unit[]>()), new Data(new long[15], new HashMap<String, DecimalFormat.Unit[]>()));
        }

        private void __constructor__(Data data, Data data2, Data data3) {
            this.$$robo$$android_icu_text_CompactDecimalDataCache_DataBundle$__constructor__(data, data2, data3);
        }

        private DataBundle(Data data, Data data2, Data data3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache_DataBundle$__constructor__(android.icu.text.CompactDecimalDataCache$Data android.icu.text.CompactDecimalDataCache$Data android.icu.text.CompactDecimalDataCache$Data ), 0, this, data, data2, data3);
        }

        private static DataBundle createEmpty() {
            return InvokeDynamicSupport.bootstrapStatic("createEmpty", $$robo$$android_icu_text_CompactDecimalDataCache_DataBundle$createEmpty(), 0);
        }

        public /* synthetic */ DataBundle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataBundle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Data
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long[] divisors;
        Map<String, DecimalFormat.Unit[]> units;
        boolean fromFallback;

        private void $$robo$$android_icu_text_CompactDecimalDataCache_Data$__constructor__(long[] divisors, Map<String, DecimalFormat.Unit[]> units) {
            this.divisors = divisors;
            this.units = units;
        }

        private final boolean $$robo$$android_icu_text_CompactDecimalDataCache_Data$isEmpty() {
            return this.units == null || this.units.isEmpty();
        }

        private void __constructor__(long[] lArray, Map<String, DecimalFormat.Unit[]> map) {
            this.$$robo$$android_icu_text_CompactDecimalDataCache_Data$__constructor__(lArray, map);
        }

        Data(long[] lArray, Map<String, DecimalFormat.Unit[]> map) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache_Data$__constructor__(long[] java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> ), 0, this, lArray, map);
        }

        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_icu_text_CompactDecimalDataCache_Data$isEmpty(), 0, this);
        }

        public /* synthetic */ Data() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Data)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class FormatsTableKey
    extends Enum<FormatsTableKey> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ FormatsTableKey DECIMAL_FORMAT;
        public static /* enum */ FormatsTableKey CURRENCY_FORMAT;
        private static /* synthetic */ FormatsTableKey[] $VALUES;

        private static final FormatsTableKey[] $$robo$$android_icu_text_CompactDecimalDataCache_FormatsTableKey$values() {
            return (FormatsTableKey[])$VALUES.clone();
        }

        private static final FormatsTableKey $$robo$$android_icu_text_CompactDecimalDataCache_FormatsTableKey$valueOf(String name) {
            return Enum.valueOf(FormatsTableKey.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_CompactDecimalDataCache_FormatsTableKey$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            DECIMAL_FORMAT = new FormatsTableKey();
            CURRENCY_FORMAT = new FormatsTableKey();
            $VALUES = new FormatsTableKey[]{DECIMAL_FORMAT, CURRENCY_FORMAT};
        }

        public static FormatsTableKey[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_CompactDecimalDataCache_FormatsTableKey$values(), 0);
        }

        public static FormatsTableKey valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_CompactDecimalDataCache_FormatsTableKey$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_CompactDecimalDataCache_FormatsTableKey$__constructor__(string2, n);
        }

        private FormatsTableKey() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache_FormatsTableKey$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(FormatsTableKey.class);
        }

        public /* synthetic */ FormatsTableKey() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FormatsTableKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class PatternsTableKey
    extends Enum<PatternsTableKey> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ PatternsTableKey PATTERNS_LONG;
        public static /* enum */ PatternsTableKey PATTERNS_SHORT;
        private static /* synthetic */ PatternsTableKey[] $VALUES;

        private static final PatternsTableKey[] $$robo$$android_icu_text_CompactDecimalDataCache_PatternsTableKey$values() {
            return (PatternsTableKey[])$VALUES.clone();
        }

        private static final PatternsTableKey $$robo$$android_icu_text_CompactDecimalDataCache_PatternsTableKey$valueOf(String name) {
            return Enum.valueOf(PatternsTableKey.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_CompactDecimalDataCache_PatternsTableKey$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            PATTERNS_LONG = new PatternsTableKey();
            PATTERNS_SHORT = new PatternsTableKey();
            $VALUES = new PatternsTableKey[]{PATTERNS_LONG, PATTERNS_SHORT};
        }

        public static PatternsTableKey[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_CompactDecimalDataCache_PatternsTableKey$values(), 0);
        }

        public static PatternsTableKey valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_CompactDecimalDataCache_PatternsTableKey$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_CompactDecimalDataCache_PatternsTableKey$__constructor__(string2, n);
        }

        private PatternsTableKey() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache_PatternsTableKey$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(PatternsTableKey.class);
        }

        public /* synthetic */ PatternsTableKey() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternsTableKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

