/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.text.AbsoluteValueSubstitution;
import android.icu.text.DecimalFormat;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.FractionalPartSubstitution;
import android.icu.text.IntegralPartSubstitution;
import android.icu.text.ModulusSubstitution;
import android.icu.text.MultiplierSubstitution;
import android.icu.text.NFRule;
import android.icu.text.NFRuleSet;
import android.icu.text.NumeratorSubstitution;
import android.icu.text.RuleBasedNumberFormat;
import android.icu.text.SameValueSubstitution;
import java.text.ParsePosition;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class NFSubstitution
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    int pos;
    NFRuleSet ruleSet;
    DecimalFormat numberFormat;
    static /* synthetic */ boolean $assertionsDisabled;

    private static final NFSubstitution $$robo$$android_icu_text_NFSubstitution$makeSubstitution(int pos, NFRule rule, NFRule rulePredecessor, NFRuleSet ruleSet, RuleBasedNumberFormat formatter, String description) {
        if (description.length() == 0) {
            return null;
        }
        switch (description.charAt(0)) {
            case '<': {
                if (rule.getBaseValue() == -1L) {
                    throw new IllegalArgumentException("<< not allowed in negative-number rule");
                }
                if (rule.getBaseValue() == -2L || rule.getBaseValue() == -3L || rule.getBaseValue() == -4L) {
                    return new IntegralPartSubstitution(pos, ruleSet, description);
                }
                if (ruleSet.isFractionSet()) {
                    return new NumeratorSubstitution(pos, rule.getBaseValue(), formatter.getDefaultRuleSet(), description);
                }
                return new MultiplierSubstitution(pos, rule, ruleSet, description);
            }
            case '>': {
                if (rule.getBaseValue() == -1L) {
                    return new AbsoluteValueSubstitution(pos, ruleSet, description);
                }
                if (rule.getBaseValue() == -2L || rule.getBaseValue() == -3L || rule.getBaseValue() == -4L) {
                    return new FractionalPartSubstitution(pos, ruleSet, description);
                }
                if (ruleSet.isFractionSet()) {
                    throw new IllegalArgumentException(">> not allowed in fraction rule set");
                }
                return new ModulusSubstitution(pos, rule, rulePredecessor, ruleSet, description);
            }
            case '=': {
                return new SameValueSubstitution(pos, ruleSet, description);
            }
        }
        throw new IllegalArgumentException("Illegal substitution character");
    }

    private void $$robo$$android_icu_text_NFSubstitution$__constructor__(int pos, NFRuleSet ruleSet, String description) {
        this.pos = pos;
        int descriptionLen = description.length();
        if (descriptionLen >= 2 && description.charAt(0) == description.charAt(descriptionLen - 1)) {
            description = description.substring(1, descriptionLen - 1);
        } else if (descriptionLen != 0) {
            throw new IllegalArgumentException("Illegal substitution syntax");
        }
        if (description.length() == 0) {
            this.ruleSet = ruleSet;
            this.numberFormat = null;
        } else if (description.charAt(0) == '%') {
            this.ruleSet = ruleSet.owner.findRuleSet(description);
            this.numberFormat = null;
        } else if (description.charAt(0) == '#' || description.charAt(0) == '0') {
            this.ruleSet = null;
            this.numberFormat = (DecimalFormat)ruleSet.owner.getDecimalFormat().clone();
            this.numberFormat.applyPattern(description);
        } else if (description.charAt(0) == '>') {
            this.ruleSet = ruleSet;
            this.numberFormat = null;
        } else {
            throw new IllegalArgumentException("Illegal substitution syntax");
        }
    }

    private final void $$robo$$android_icu_text_NFSubstitution$setDivisor(int radix, short exponent) {
    }

    private final boolean $$robo$$android_icu_text_NFSubstitution$equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (this.getClass() == that.getClass()) {
            NFSubstitution that2 = (NFSubstitution)that;
            return this.pos == that2.pos && (this.ruleSet != null || that2.ruleSet == null) && (this.numberFormat == null ? that2.numberFormat == null : this.numberFormat.equals(that2.numberFormat));
        }
        return false;
    }

    private final int $$robo$$android_icu_text_NFSubstitution$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    private final String $$robo$$android_icu_text_NFSubstitution$toString() {
        if (this.ruleSet != null) {
            return this.tokenChar() + this.ruleSet.getName() + this.tokenChar();
        }
        return this.tokenChar() + this.numberFormat.toPattern() + this.tokenChar();
    }

    private final void $$robo$$android_icu_text_NFSubstitution$doSubstitution(long number, StringBuilder toInsertInto, int position, int recursionCount) {
        long numberToFormat = this.transformNumber(number);
        if (this.ruleSet != null) {
            this.ruleSet.format(numberToFormat, toInsertInto, position + this.pos, recursionCount);
        } else {
            toInsertInto.insert(position + this.pos, this.numberFormat.format(numberToFormat));
        }
    }

    private final void $$robo$$android_icu_text_NFSubstitution$doSubstitution(double number, StringBuilder toInsertInto, int position, int recursionCount) {
        double numberToFormat = this.transformNumber(number);
        if (Double.isInfinite(numberToFormat)) {
            NFRule infiniteRule = this.ruleSet.findRule(Double.POSITIVE_INFINITY);
            infiniteRule.doFormat(numberToFormat, toInsertInto, position + this.pos, recursionCount);
            return;
        }
        if (numberToFormat == Math.floor(numberToFormat) && this.ruleSet != null) {
            this.ruleSet.format((long)numberToFormat, toInsertInto, position + this.pos, recursionCount);
        } else if (this.ruleSet != null) {
            this.ruleSet.format(numberToFormat, toInsertInto, position + this.pos, recursionCount);
        } else {
            toInsertInto.insert(position + this.pos, this.numberFormat.format(numberToFormat));
        }
    }

    public abstract long transformNumber(long var1);

    public abstract double transformNumber(double var1);

    private final Number $$robo$$android_icu_text_NFSubstitution$doParse(String text, ParsePosition parsePosition, double baseValue, double upperBound, boolean lenientParse) {
        Number tempResult;
        upperBound = this.calcUpperBound(upperBound);
        if (this.ruleSet != null) {
            tempResult = this.ruleSet.parse(text, parsePosition, upperBound);
            if (lenientParse && !this.ruleSet.isFractionSet() && parsePosition.getIndex() == 0) {
                tempResult = this.ruleSet.owner.getDecimalFormat().parse(text, parsePosition);
            }
        } else {
            tempResult = this.numberFormat.parse(text, parsePosition);
        }
        if (parsePosition.getIndex() != 0) {
            double result = tempResult.doubleValue();
            if ((result = this.composeRuleValue(result, baseValue)) == (double)((long)result)) {
                return (long)result;
            }
            return new Double(result);
        }
        return tempResult;
    }

    public abstract double composeRuleValue(double var1, double var3);

    public abstract double calcUpperBound(double var1);

    private final int $$robo$$android_icu_text_NFSubstitution$getPos() {
        return this.pos;
    }

    abstract char tokenChar();

    private final boolean $$robo$$android_icu_text_NFSubstitution$isModulusSubstitution() {
        return false;
    }

    private final void $$robo$$android_icu_text_NFSubstitution$setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        if (this.numberFormat != null) {
            this.numberFormat.setDecimalFormatSymbols(newSymbols);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !NFSubstitution.class.desiredAssertionStatus();
    }

    public static NFSubstitution makeSubstitution(int n, NFRule nFRule, NFRule nFRule2, NFRuleSet nFRuleSet, RuleBasedNumberFormat ruleBasedNumberFormat, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeSubstitution", $$robo$$android_icu_text_NFSubstitution$makeSubstitution(int android.icu.text.NFRule android.icu.text.NFRule android.icu.text.NFRuleSet android.icu.text.RuleBasedNumberFormat java.lang.String ), 0, (int)n, (NFRule)nFRule, (NFRule)nFRule2, (NFRuleSet)nFRuleSet, (RuleBasedNumberFormat)ruleBasedNumberFormat, (String)string2);
    }

    private void __constructor__(int n, NFRuleSet nFRuleSet, String string2) {
        this.$$robo$$android_icu_text_NFSubstitution$__constructor__(n, nFRuleSet, string2);
    }

    NFSubstitution(int n, NFRuleSet nFRuleSet, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NFSubstitution$__constructor__(int android.icu.text.NFRuleSet java.lang.String ), 0, this, n, nFRuleSet, string2);
    }

    public void setDivisor(int n, short s) {
        InvokeDynamicSupport.bootstrap("setDivisor", $$robo$$android_icu_text_NFSubstitution$setDivisor(int short ), 0, this, n, s);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_NFSubstitution$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_NFSubstitution$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_NFSubstitution$toString(), 0, this);
    }

    public void doSubstitution(long l, StringBuilder stringBuilder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("doSubstitution", $$robo$$android_icu_text_NFSubstitution$doSubstitution(long java.lang.StringBuilder int int ), 0, this, l, stringBuilder, n, n2);
    }

    public void doSubstitution(double d, StringBuilder stringBuilder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("doSubstitution", $$robo$$android_icu_text_NFSubstitution$doSubstitution(double java.lang.StringBuilder int int ), 0, this, d, stringBuilder, n, n2);
    }

    public Number doParse(String string2, ParsePosition parsePosition, double d, double d2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("doParse", $$robo$$android_icu_text_NFSubstitution$doParse(java.lang.String java.text.ParsePosition double double boolean ), 0, this, string2, parsePosition, d, d2, bl);
    }

    public int getPos() {
        return (int)InvokeDynamicSupport.bootstrap("getPos", $$robo$$android_icu_text_NFSubstitution$getPos(), 0, this);
    }

    public boolean isModulusSubstitution() {
        return (boolean)InvokeDynamicSupport.bootstrap("isModulusSubstitution", $$robo$$android_icu_text_NFSubstitution$isModulusSubstitution(), 0, this);
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        InvokeDynamicSupport.bootstrap("setDecimalFormatSymbols", $$robo$$android_icu_text_NFSubstitution$setDecimalFormatSymbols(android.icu.text.DecimalFormatSymbols ), 0, this, decimalFormatSymbols);
    }

    static {
        RobolectricInternals.classInitializing(NFSubstitution.class);
    }

    public /* synthetic */ NFSubstitution() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFSubstitution)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

