/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.CalendarUtil;
import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.impl.SimpleFormatterImpl;
import android.icu.impl.SoftCache;
import android.icu.text.DateFormat;
import android.icu.text.DateFormatSymbols;
import android.icu.text.SimpleDateFormat;
import android.icu.util.BasicTimeZone;
import android.icu.util.BuddhistCalendar;
import android.icu.util.ChineseCalendar;
import android.icu.util.CopticCalendar;
import android.icu.util.DangiCalendar;
import android.icu.util.EthiopicCalendar;
import android.icu.util.GregorianCalendar;
import android.icu.util.HebrewCalendar;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.IndianCalendar;
import android.icu.util.IslamicCalendar;
import android.icu.util.JapaneseCalendar;
import android.icu.util.PersianCalendar;
import android.icu.util.TaiwanCalendar;
import android.icu.util.TimeZone;
import android.icu.util.TimeZoneTransition;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    public transient /* synthetic */ Object __robo_data__;
    public static int ERA = 0;
    public static int YEAR = 1;
    public static int MONTH = 2;
    public static int WEEK_OF_YEAR = 3;
    public static int WEEK_OF_MONTH = 4;
    public static int DATE = 5;
    public static int DAY_OF_MONTH = 5;
    public static int DAY_OF_YEAR = 6;
    public static int DAY_OF_WEEK = 7;
    public static int DAY_OF_WEEK_IN_MONTH = 8;
    public static int AM_PM = 9;
    public static int HOUR = 10;
    public static int HOUR_OF_DAY = 11;
    public static int MINUTE = 12;
    public static int SECOND = 13;
    public static int MILLISECOND = 14;
    public static int ZONE_OFFSET = 15;
    public static int DST_OFFSET = 16;
    public static int YEAR_WOY = 17;
    public static int DOW_LOCAL = 18;
    public static int EXTENDED_YEAR = 19;
    public static int JULIAN_DAY = 20;
    public static int MILLISECONDS_IN_DAY = 21;
    public static int IS_LEAP_MONTH = 22;
    @Deprecated
    protected static int BASE_FIELD_COUNT = 23;
    @Deprecated
    protected static int MAX_FIELD_COUNT = 32;
    public static int SUNDAY = 1;
    public static int MONDAY = 2;
    public static int TUESDAY = 3;
    public static int WEDNESDAY = 4;
    public static int THURSDAY = 5;
    public static int FRIDAY = 6;
    public static int SATURDAY = 7;
    public static int JANUARY = 0;
    public static int FEBRUARY = 1;
    public static int MARCH = 2;
    public static int APRIL = 3;
    public static int MAY = 4;
    public static int JUNE = 5;
    public static int JULY = 6;
    public static int AUGUST = 7;
    public static int SEPTEMBER = 8;
    public static int OCTOBER = 9;
    public static int NOVEMBER = 10;
    public static int DECEMBER = 11;
    public static int UNDECIMBER = 12;
    public static int AM = 0;
    public static int PM = 1;
    @Deprecated
    public static int WEEKDAY = 0;
    @Deprecated
    public static int WEEKEND = 1;
    @Deprecated
    public static int WEEKEND_ONSET = 2;
    @Deprecated
    public static int WEEKEND_CEASE = 3;
    public static int WALLTIME_LAST = 0;
    public static int WALLTIME_FIRST = 1;
    public static int WALLTIME_NEXT_VALID = 2;
    protected static int ONE_SECOND = 1000;
    protected static int ONE_MINUTE = 60000;
    protected static int ONE_HOUR = 3600000;
    protected static long ONE_DAY = 86400000L;
    protected static long ONE_WEEK = 604800000L;
    protected static int JAN_1_1_JULIAN_DAY = 1721426;
    protected static int EPOCH_JULIAN_DAY = 2440588;
    protected static int MIN_JULIAN = -2130706432;
    protected static long MIN_MILLIS = -184303902528000000L;
    protected static Date MIN_DATE;
    protected static int MAX_JULIAN = 0x7F000000;
    protected static long MAX_MILLIS = 183882168921600000L;
    protected static Date MAX_DATE;
    private transient int[] fields;
    private transient int[] stamp;
    private long time;
    private transient boolean isTimeSet;
    private transient boolean areFieldsSet;
    private transient boolean areAllFieldsSet;
    private transient boolean areFieldsVirtuallySet;
    private boolean lenient;
    private TimeZone zone;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private int weekendOnset;
    private int weekendOnsetMillis;
    private int weekendCease;
    private int weekendCeaseMillis;
    private int repeatedWallTime;
    private int skippedWallTime;
    protected static int UNSET = 0;
    protected static int INTERNALLY_SET = 1;
    protected static int MINIMUM_USER_STAMP = 2;
    private transient int nextStamp;
    private static int STAMP_MAX;
    private static long serialVersionUID = 6222646104888790989L;
    private transient int internalSetMask;
    private transient int gregorianYear;
    private transient int gregorianMonth;
    private transient int gregorianDayOfYear;
    private transient int gregorianDayOfMonth;
    private static ICUCache<String, PatternData> PATTERN_CACHE;
    private static String[] DEFAULT_PATTERNS;
    private static char QUOTE = '\'';
    private static int FIELD_DIFF_MAX_INT = Integer.MAX_VALUE;
    private static int[][] LIMITS;
    protected static int MINIMUM = 0;
    protected static int GREATEST_MINIMUM = 1;
    protected static int LEAST_MAXIMUM = 2;
    protected static int MAXIMUM = 3;
    private static WeekDataCache WEEK_DATA_CACHE;
    protected static int RESOLVE_REMAP = 32;
    static int[][][] DATE_PRECEDENCE;
    static int[][][] DOW_PRECEDENCE;
    private static int[] FIND_ZONE_TRANSITION_TIME_UNITS;
    private static int[][] GREGORIAN_MONTH_COUNT;
    private static String[] FIELD_NAME;
    private ULocale validLocale;
    private ULocale actualLocale;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_util_Calendar$__constructor__() {
    }

    private void $$robo$$android_icu_util_Calendar$__constructor__(TimeZone zone, Locale aLocale) {
    }

    private void $$robo$$android_icu_util_Calendar$__constructor__(TimeZone zone, ULocale locale) {
        this.lenient = true;
        this.repeatedWallTime = 0;
        this.skippedWallTime = 0;
        this.nextStamp = 2;
        this.zone = zone;
        this.setWeekData(Calendar.getRegionForCalendar(locale));
        this.setCalendarLocale(locale);
        this.initInternal();
    }

    private final void $$robo$$android_icu_util_Calendar$setCalendarLocale(ULocale locale) {
        ULocale calLocale = locale;
        if (locale.getVariant().length() != 0 || locale.getKeywords() != null) {
            String calType;
            String region;
            StringBuilder buf = new StringBuilder();
            buf.append(locale.getLanguage());
            String script = locale.getScript();
            if (script.length() > 0) {
                buf.append("_").append(script);
            }
            if ((region = locale.getCountry()).length() > 0) {
                buf.append("_").append(region);
            }
            if ((calType = locale.getKeywordValue("calendar")) != null) {
                buf.append("@calendar=").append(calType);
            }
            calLocale = new ULocale(buf.toString());
        }
        this.setLocale(calLocale, calLocale);
    }

    private final void $$robo$$android_icu_util_Calendar$recalculateStamp() {
        this.nextStamp = 1;
        for (int j = 0; j < this.stamp.length; ++j) {
            int currentValue = STAMP_MAX;
            int index = -1;
            for (int i = 0; i < this.stamp.length; ++i) {
                if (this.stamp[i] <= this.nextStamp || this.stamp[i] >= currentValue) continue;
                currentValue = this.stamp[i];
                index = i;
            }
            if (index < 0) break;
            this.stamp[index] = ++this.nextStamp;
        }
        ++this.nextStamp;
    }

    private final void $$robo$$android_icu_util_Calendar$initInternal() {
        this.fields = this.handleCreateFields();
        if (this.fields == null || this.fields.length < 23 || this.fields.length > 32) {
            throw new IllegalStateException("Invalid fields[]");
        }
        this.stamp = new int[this.fields.length];
        int mask = 4718695;
        for (int i = 23; i < this.fields.length; ++i) {
            mask |= 1 << i;
        }
        this.internalSetMask = mask;
    }

    private static final Calendar $$robo$$android_icu_util_Calendar$getInstance() {
        return Calendar.getInstanceInternal(null, null);
    }

    private static final Calendar $$robo$$android_icu_util_Calendar$getInstance(TimeZone zone) {
        return Calendar.getInstanceInternal(zone, null);
    }

    private static final Calendar $$robo$$android_icu_util_Calendar$getInstance(Locale aLocale) {
        return Calendar.getInstanceInternal(null, ULocale.forLocale(aLocale));
    }

    private static final Calendar $$robo$$android_icu_util_Calendar$getInstance(ULocale locale) {
        return Calendar.getInstanceInternal(null, locale);
    }

    private static final Calendar $$robo$$android_icu_util_Calendar$getInstance(TimeZone zone, Locale aLocale) {
        return Calendar.getInstanceInternal(zone, ULocale.forLocale(aLocale));
    }

    private static final Calendar $$robo$$android_icu_util_Calendar$getInstance(TimeZone zone, ULocale locale) {
        return Calendar.getInstanceInternal(zone, locale);
    }

    private static final Calendar $$robo$$android_icu_util_Calendar$getInstanceInternal(TimeZone tz, ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault(ULocale.Category.FORMAT);
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        Calendar cal = Calendar.createInstance(locale);
        cal.setTimeZone(tz);
        cal.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        return cal;
    }

    private static final String $$robo$$android_icu_util_Calendar$getRegionForCalendar(ULocale loc) {
        String region = ULocale.getRegionForSupplementalData(loc, true);
        if (region.length() == 0) {
            region = "001";
        }
        return region;
    }

    private static final CalType $$robo$$android_icu_util_Calendar$getCalendarTypeForLocale(ULocale l) {
        String s = CalendarUtil.getCalendarType(l);
        if (s != null) {
            s = s.toLowerCase(Locale.ENGLISH);
            for (CalType type : CalType.values()) {
                if (!s.equals(type.id)) continue;
                return type;
            }
        }
        return CalType.UNKNOWN;
    }

    private static final Calendar $$robo$$android_icu_util_Calendar$createInstance(ULocale locale) {
        Calendar cal = null;
        TimeZone zone = TimeZone.getDefault();
        CalType calType = Calendar.getCalendarTypeForLocale(locale);
        if (calType == CalType.UNKNOWN) {
            calType = CalType.GREGORIAN;
        }
        switch (1.$SwitchMap$android$icu$util$Calendar$CalType[calType.ordinal()]) {
            case 1: {
                cal = new GregorianCalendar(zone, locale);
                break;
            }
            case 2: {
                cal = new GregorianCalendar(zone, locale);
                cal.setFirstDayOfWeek(2);
                cal.setMinimalDaysInFirstWeek(4);
                break;
            }
            case 3: {
                cal = new BuddhistCalendar(zone, locale);
                break;
            }
            case 4: {
                cal = new ChineseCalendar(zone, locale);
                break;
            }
            case 5: {
                cal = new CopticCalendar(zone, locale);
                break;
            }
            case 6: {
                cal = new DangiCalendar(zone, locale);
                break;
            }
            case 7: {
                cal = new EthiopicCalendar(zone, locale);
                break;
            }
            case 8: {
                cal = new EthiopicCalendar(zone, locale);
                ((EthiopicCalendar)cal).setAmeteAlemEra(true);
                break;
            }
            case 9: {
                cal = new HebrewCalendar(zone, locale);
                break;
            }
            case 10: {
                cal = new IndianCalendar(zone, locale);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                cal = new IslamicCalendar(zone, locale);
                break;
            }
            case 16: {
                cal = new JapaneseCalendar(zone, locale);
                break;
            }
            case 17: {
                cal = new PersianCalendar(zone, locale);
                break;
            }
            case 18: {
                cal = new TaiwanCalendar(zone, locale);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown calendar type");
            }
        }
        return cal;
    }

    private static final Locale[] $$robo$$android_icu_util_Calendar$getAvailableLocales() {
        return ICUResourceBundle.getAvailableLocales();
    }

    private static final ULocale[] $$robo$$android_icu_util_Calendar$getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    private static final String[] $$robo$$android_icu_util_Calendar$getKeywordValuesForLocale(String key, ULocale locale, boolean commonlyUsed) {
        String prefRegion = ULocale.getRegionForSupplementalData(locale, true);
        ArrayList<String> values = new ArrayList<String>();
        UResourceBundle rb = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle calPref = rb.get("calendarPreferenceData");
        UResourceBundle order = null;
        try {
            order = calPref.get(prefRegion);
        }
        catch (MissingResourceException mre) {
            order = calPref.get("001");
        }
        String[] caltypes = order.getStringArray();
        if (commonlyUsed) {
            return caltypes;
        }
        for (int i = 0; i < caltypes.length; ++i) {
            values.add(caltypes[i]);
        }
        for (CalType t : CalType.values()) {
            if (values.contains(t.id)) continue;
            values.add(t.id);
        }
        return values.toArray(new String[values.size()]);
    }

    private final Date $$robo$$android_icu_util_Calendar$getTime() {
        return new Date(this.getTimeInMillis());
    }

    private final void $$robo$$android_icu_util_Calendar$setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    private final long $$robo$$android_icu_util_Calendar$getTimeInMillis() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        return this.time;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_icu_util_Calendar$setTimeInMillis(long millis) {
        if (millis > 183882168921600000L) {
            if (!this.isLenient()) throw new IllegalArgumentException("millis value greater than upper bounds for a Calendar : " + millis);
            millis = 183882168921600000L;
        } else if (millis < -184303902528000000L) {
            if (!this.isLenient()) throw new IllegalArgumentException("millis value less than lower bounds for a Calendar : " + millis);
            millis = -184303902528000000L;
        }
        this.time = millis;
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
        this.areFieldsVirtuallySet = true;
        this.isTimeSet = true;
        for (int i = 0; i < this.fields.length; ++i) {
            this.stamp[i] = 0;
            this.fields[i] = 0;
        }
    }

    private final int $$robo$$android_icu_util_Calendar$get(int field) {
        this.complete();
        return this.fields[field];
    }

    private final int $$robo$$android_icu_util_Calendar$internalGet(int field) {
        return this.fields[field];
    }

    private final int $$robo$$android_icu_util_Calendar$internalGet(int field, int defaultValue) {
        return this.stamp[field] > 0 ? this.fields[field] : defaultValue;
    }

    private final void $$robo$$android_icu_util_Calendar$set(int field, int value) {
        if (this.areFieldsVirtuallySet) {
            this.computeFields();
        }
        this.fields[field] = value;
        if (this.nextStamp == STAMP_MAX) {
            this.recalculateStamp();
        }
        ++this.nextStamp;
        this.areFieldsVirtuallySet = false;
        this.areFieldsSet = false;
        this.isTimeSet = false;
    }

    private final void $$robo$$android_icu_util_Calendar$set(int year, int month, int date) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
    }

    private final void $$robo$$android_icu_util_Calendar$set(int year, int month, int date, int hour, int minute) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
    }

    private final void $$robo$$android_icu_util_Calendar$set(int year, int month, int date, int hour, int minute, int second) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    private static final int $$robo$$android_icu_util_Calendar$gregoYearFromIslamicStart(int year) {
        int shift = 0;
        if (year >= 1397) {
            int cycle = (year - 1397) / 67;
            int offset = (year - 1397) % 67;
            shift = 2 * cycle + (offset >= 33 ? 1 : 0);
        } else {
            int cycle = (year - 1396) / 67 - 1;
            int offset = -(year - 1396) % 67;
            shift = 2 * cycle + (offset <= 33 ? 1 : 0);
        }
        return year + 579 - shift;
    }

    @Deprecated
    private final int $$robo$$android_icu_util_Calendar$getRelatedYear() {
        int year = this.get(19);
        CalType type = CalType.GREGORIAN;
        String typeString = this.getType();
        for (CalType testType : CalType.values()) {
            if (!typeString.equals(testType.id)) continue;
            type = testType;
            break;
        }
        switch (1.$SwitchMap$android$icu$util$Calendar$CalType[type.ordinal()]) {
            case 17: {
                year += 622;
                break;
            }
            case 9: {
                year -= 3760;
                break;
            }
            case 4: {
                year -= 2637;
                break;
            }
            case 10: {
                year += 79;
                break;
            }
            case 5: {
                year += 284;
                break;
            }
            case 7: {
                year += 8;
                break;
            }
            case 8: {
                year -= 5492;
                break;
            }
            case 6: {
                year -= 2333;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                year = Calendar.gregoYearFromIslamicStart(year);
                break;
            }
        }
        return year;
    }

    private static final int $$robo$$android_icu_util_Calendar$firstIslamicStartYearFromGrego(int year) {
        int shift = 0;
        if (year >= 1977) {
            int cycle = (year - 1977) / 65;
            int offset = (year - 1977) % 65;
            shift = 2 * cycle + (offset >= 32 ? 1 : 0);
        } else {
            int cycle = (year - 1976) / 65 - 1;
            int offset = -(year - 1976) % 65;
            shift = 2 * cycle + (offset <= 32 ? 1 : 0);
        }
        return year - 579 + shift;
    }

    @Deprecated
    private final void $$robo$$android_icu_util_Calendar$setRelatedYear(int year) {
        CalType type = CalType.GREGORIAN;
        String typeString = this.getType();
        for (CalType testType : CalType.values()) {
            if (!typeString.equals(testType.id)) continue;
            type = testType;
            break;
        }
        switch (1.$SwitchMap$android$icu$util$Calendar$CalType[type.ordinal()]) {
            case 17: {
                year -= 622;
                break;
            }
            case 9: {
                year += 3760;
                break;
            }
            case 4: {
                year += 2637;
                break;
            }
            case 10: {
                year -= 79;
                break;
            }
            case 5: {
                year -= 284;
                break;
            }
            case 7: {
                year -= 8;
                break;
            }
            case 8: {
                year += 5492;
                break;
            }
            case 6: {
                year += 2333;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                year = Calendar.firstIslamicStartYearFromGrego(year);
                break;
            }
        }
        this.set(19, year);
    }

    private final void $$robo$$android_icu_util_Calendar$clear() {
        for (int i = 0; i < this.fields.length; ++i) {
            this.stamp[i] = 0;
            this.fields[i] = 0;
        }
        this.areFieldsVirtuallySet = false;
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
        this.isTimeSet = false;
    }

    private final void $$robo$$android_icu_util_Calendar$clear(int field) {
        if (this.areFieldsVirtuallySet) {
            this.computeFields();
        }
        this.fields[field] = 0;
        this.stamp[field] = 0;
        this.areFieldsVirtuallySet = false;
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
        this.isTimeSet = false;
    }

    private final boolean $$robo$$android_icu_util_Calendar$isSet(int field) {
        return this.areFieldsVirtuallySet || this.stamp[field] != 0;
    }

    private final void $$robo$$android_icu_util_Calendar$complete() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
            this.areAllFieldsSet = true;
        }
    }

    private final boolean $$robo$$android_icu_util_Calendar$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Calendar that = (Calendar)obj;
        return this.isEquivalentTo(that) && this.getTimeInMillis() == that.getTime().getTime();
    }

    private final boolean $$robo$$android_icu_util_Calendar$isEquivalentTo(Calendar other) {
        return this.getClass() == other.getClass() && this.isLenient() == other.isLenient() && this.getFirstDayOfWeek() == other.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == other.getMinimalDaysInFirstWeek() && this.getTimeZone().equals(other.getTimeZone()) && this.getRepeatedWallTimeOption() == other.getRepeatedWallTimeOption() && this.getSkippedWallTimeOption() == other.getSkippedWallTimeOption();
    }

    private final int $$robo$$android_icu_util_Calendar$hashCode() {
        return (this.lenient ? 1 : 0) | this.firstDayOfWeek << 1 | this.minimalDaysInFirstWeek << 4 | this.repeatedWallTime << 7 | this.skippedWallTime << 9 | this.zone.hashCode() << 11;
    }

    private final long $$robo$$android_icu_util_Calendar$compare(Object that) {
        long thatMs;
        if (that instanceof Calendar) {
            thatMs = ((Calendar)that).getTimeInMillis();
        } else if (that instanceof Date) {
            thatMs = ((Date)that).getTime();
        } else {
            throw new IllegalArgumentException(that + "is not a Calendar or Date");
        }
        return this.getTimeInMillis() - thatMs;
    }

    private final boolean $$robo$$android_icu_util_Calendar$before(Object when) {
        return this.compare(when) < 0L;
    }

    private final boolean $$robo$$android_icu_util_Calendar$after(Object when) {
        return this.compare(when) > 0L;
    }

    private final int $$robo$$android_icu_util_Calendar$getActualMaximum(int field) {
        int result;
        switch (field) {
            case 5: {
                Calendar cal = (Calendar)this.clone();
                cal.setLenient(true);
                cal.prepareGetActual(field, false);
                result = this.handleGetMonthLength(cal.get(19), cal.get(2));
                break;
            }
            case 6: {
                Calendar cal = (Calendar)this.clone();
                cal.setLenient(true);
                cal.prepareGetActual(field, false);
                result = this.handleGetYearLength(cal.get(19));
                break;
            }
            case 0: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                result = this.getMaximum(field);
                break;
            }
            default: {
                result = this.getActualHelper(field, this.getLeastMaximum(field), this.getMaximum(field));
            }
        }
        return result;
    }

    private final int $$robo$$android_icu_util_Calendar$getActualMinimum(int field) {
        int result;
        switch (field) {
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                result = this.getMinimum(field);
                break;
            }
            default: {
                result = this.getActualHelper(field, this.getGreatestMinimum(field), this.getMinimum(field));
            }
        }
        return result;
    }

    private final void $$robo$$android_icu_util_Calendar$prepareGetActual(int field, boolean isMinimum) {
        this.set(21, 0);
        switch (field) {
            case 1: 
            case 19: {
                this.set(6, this.getGreatestMinimum(6));
                break;
            }
            case 17: {
                this.set(3, this.getGreatestMinimum(3));
                break;
            }
            case 2: {
                this.set(5, this.getGreatestMinimum(5));
                break;
            }
            case 8: {
                this.set(5, 1);
                this.set(7, this.get(7));
                break;
            }
            case 3: 
            case 4: {
                int dow = this.firstDayOfWeek;
                if (isMinimum && (dow = (dow + 6) % 7) < 1) {
                    dow += 7;
                }
                this.set(7, dow);
            }
        }
        this.set(field, this.getGreatestMinimum(field));
    }

    private final int $$robo$$android_icu_util_Calendar$getActualHelper(int field, int startValue, int endValue) {
        if (startValue == endValue) {
            return startValue;
        }
        int delta = endValue > startValue ? 1 : -1;
        Calendar work = (Calendar)this.clone();
        work.complete();
        work.setLenient(true);
        work.prepareGetActual(field, delta < 0);
        work.set(field, startValue);
        if (work.get(field) != startValue && field != 4 && delta > 0) {
            return startValue;
        }
        int result = startValue;
        do {
            work.add(field, delta);
            if (work.get(field) != (startValue += delta)) break;
            result = startValue;
        } while (startValue != endValue);
        return result;
    }

    private final void $$robo$$android_icu_util_Calendar$roll(int field, boolean up) {
        this.roll(field, up ? 1 : -1);
    }

    private final void $$robo$$android_icu_util_Calendar$roll(int field, int amount) {
        if (amount == 0) {
            return;
        }
        this.complete();
        switch (field) {
            case 0: 
            case 5: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                int min = this.getActualMinimum(field);
                int max = this.getActualMaximum(field);
                int gap = max - min + 1;
                int value = this.internalGet(field) + amount;
                value = (value - min) % gap;
                if (value < 0) {
                    value += gap;
                }
                this.set(field, value += min);
                return;
            }
            case 10: 
            case 11: {
                long start = this.getTimeInMillis();
                int oldHour = this.internalGet(field);
                int max = this.getMaximum(field);
                int newHour = (oldHour + amount) % (max + 1);
                if (newHour < 0) {
                    newHour += max + 1;
                }
                this.setTimeInMillis(start + 3600000L * ((long)newHour - (long)oldHour));
                return;
            }
            case 2: {
                int max = this.getActualMaximum(2);
                int mon = (this.internalGet(2) + amount) % (max + 1);
                if (mon < 0) {
                    mon += max + 1;
                }
                this.set(2, mon);
                this.pinField(5);
                return;
            }
            case 1: 
            case 17: {
                String calType;
                boolean era0WithYearsThatGoBackwards = false;
                int era = this.get(0);
                if (era == 0 && ((calType = this.getType()).equals("gregorian") || calType.equals("roc") || calType.equals("coptic"))) {
                    amount = -amount;
                    era0WithYearsThatGoBackwards = true;
                }
                int newYear = this.internalGet(field) + amount;
                if (era > 0 || newYear >= 1) {
                    int maxYear = this.getActualMaximum(field);
                    if (maxYear < 32768) {
                        if (newYear < 1) {
                            newYear = maxYear - -newYear % maxYear;
                        } else if (newYear > maxYear) {
                            newYear = (newYear - 1) % maxYear + 1;
                        }
                    } else if (newYear < 1) {
                        newYear = 1;
                    }
                } else if (era0WithYearsThatGoBackwards) {
                    newYear = 1;
                }
                this.set(field, newYear);
                this.pinField(2);
                this.pinField(5);
                return;
            }
            case 19: {
                this.set(field, this.internalGet(field) + amount);
                this.pinField(2);
                this.pinField(5);
                return;
            }
            case 4: {
                int fdm;
                int dow = this.internalGet(7) - this.getFirstDayOfWeek();
                if (dow < 0) {
                    dow += 7;
                }
                if ((fdm = (dow - this.internalGet(5) + 1) % 7) < 0) {
                    fdm += 7;
                }
                int start = 7 - fdm < this.getMinimalDaysInFirstWeek() ? 8 - fdm : 1 - fdm;
                int monthLen = this.getActualMaximum(5);
                int ldm = (monthLen - this.internalGet(5) + dow) % 7;
                int limit = monthLen + 7 - ldm;
                int gap = limit - start;
                int day_of_month = (this.internalGet(5) + amount * 7 - start) % gap;
                if (day_of_month < 0) {
                    day_of_month += gap;
                }
                if ((day_of_month += start) < 1) {
                    day_of_month = 1;
                }
                if (day_of_month > monthLen) {
                    day_of_month = monthLen;
                }
                this.set(5, day_of_month);
                return;
            }
            case 3: {
                int fdy;
                int dow = this.internalGet(7) - this.getFirstDayOfWeek();
                if (dow < 0) {
                    dow += 7;
                }
                if ((fdy = (dow - this.internalGet(6) + 1) % 7) < 0) {
                    fdy += 7;
                }
                int start = 7 - fdy < this.getMinimalDaysInFirstWeek() ? 8 - fdy : 1 - fdy;
                int yearLen = this.getActualMaximum(6);
                int ldy = (yearLen - this.internalGet(6) + dow) % 7;
                int limit = yearLen + 7 - ldy;
                int gap = limit - start;
                int day_of_year = (this.internalGet(6) + amount * 7 - start) % gap;
                if (day_of_year < 0) {
                    day_of_year += gap;
                }
                if ((day_of_year += start) < 1) {
                    day_of_year = 1;
                }
                if (day_of_year > yearLen) {
                    day_of_year = yearLen;
                }
                this.set(6, day_of_year);
                this.clear(2);
                return;
            }
            case 6: {
                long delta = (long)amount * 86400000L;
                long min2 = this.time - (long)(this.internalGet(6) - 1) * 86400000L;
                int yearLength = this.getActualMaximum(6);
                this.time = (this.time + delta - min2) % ((long)yearLength * 86400000L);
                if (this.time < 0L) {
                    this.time += (long)yearLength * 86400000L;
                }
                this.setTimeInMillis(this.time + min2);
                return;
            }
            case 7: 
            case 18: {
                long delta = (long)amount * 86400000L;
                int leadDays = this.internalGet(field);
                if ((leadDays -= field == 7 ? this.getFirstDayOfWeek() : 1) < 0) {
                    leadDays += 7;
                }
                long min2 = this.time - (long)leadDays * 86400000L;
                this.time = (this.time + delta - min2) % 604800000L;
                if (this.time < 0L) {
                    this.time += 604800000L;
                }
                this.setTimeInMillis(this.time + min2);
                return;
            }
            case 8: {
                long delta = (long)amount * 604800000L;
                int preWeeks = (this.internalGet(5) - 1) / 7;
                int postWeeks = (this.getActualMaximum(5) - this.internalGet(5)) / 7;
                long min2 = this.time - (long)preWeeks * 604800000L;
                long gap2 = 604800000L * (long)(preWeeks + postWeeks + 1);
                this.time = (this.time + delta - min2) % gap2;
                if (this.time < 0L) {
                    this.time += gap2;
                }
                this.setTimeInMillis(this.time + min2);
                return;
            }
            case 20: {
                this.set(field, this.internalGet(field) + amount);
                return;
            }
        }
        throw new IllegalArgumentException("Calendar.roll(" + this.fieldName(field) + ") not supported");
    }

    private final void $$robo$$android_icu_util_Calendar$add(int field, int amount) {
        int newWallTime;
        if (amount == 0) {
            return;
        }
        long delta = amount;
        boolean keepWallTimeInvariant = true;
        switch (field) {
            case 0: {
                this.set(field, this.get(field) + amount);
                this.pinField(0);
                return;
            }
            case 1: 
            case 17: {
                String calType;
                int era = this.get(0);
                if (era == 0 && ((calType = this.getType()).equals("gregorian") || calType.equals("roc") || calType.equals("coptic"))) {
                    amount = -amount;
                }
            }
            case 2: 
            case 19: {
                boolean oldLenient = this.isLenient();
                this.setLenient(true);
                this.set(field, this.get(field) + amount);
                this.pinField(5);
                if (!oldLenient) {
                    this.complete();
                    this.setLenient(oldLenient);
                }
                return;
            }
            case 3: 
            case 4: 
            case 8: {
                delta *= 604800000L;
                break;
            }
            case 9: {
                delta *= 43200000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 20: {
                delta *= 86400000L;
                break;
            }
            case 10: 
            case 11: {
                delta *= 3600000L;
                keepWallTimeInvariant = false;
                break;
            }
            case 12: {
                delta *= 60000L;
                keepWallTimeInvariant = false;
                break;
            }
            case 13: {
                delta *= 1000L;
                keepWallTimeInvariant = false;
                break;
            }
            case 14: 
            case 21: {
                keepWallTimeInvariant = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Calendar.add(" + this.fieldName(field) + ") not supported");
            }
        }
        int prevOffset = 0;
        int prevWallTime = 0;
        if (keepWallTimeInvariant) {
            prevOffset = this.get(16) + this.get(15);
            prevWallTime = this.get(21);
        }
        this.setTimeInMillis(this.getTimeInMillis() + delta);
        if (keepWallTimeInvariant && (newWallTime = this.get(21)) != prevWallTime) {
            long t = this.internalGetTimeInMillis();
            int newOffset = this.get(16) + this.get(15);
            if (newOffset != prevOffset) {
                long adjAmount = (long)(prevOffset - newOffset) % 86400000L;
                if (adjAmount != 0L) {
                    this.setTimeInMillis(t + adjAmount);
                    newWallTime = this.get(21);
                }
                if (newWallTime != prevWallTime) {
                    switch (this.skippedWallTime) {
                        case 1: {
                            if (adjAmount <= 0L) break;
                            this.setTimeInMillis(t);
                            break;
                        }
                        case 0: {
                            if (adjAmount >= 0L) break;
                            this.setTimeInMillis(t);
                            break;
                        }
                        case 2: {
                            long tmpT = adjAmount > 0L ? this.internalGetTimeInMillis() : t;
                            Long immediatePrevTrans = this.getImmediatePreviousZoneTransition(tmpT);
                            if (immediatePrevTrans != null) {
                                this.setTimeInMillis(immediatePrevTrans);
                                break;
                            }
                            throw new RuntimeException("Could not locate a time zone transition before " + tmpT);
                        }
                    }
                }
            }
        }
    }

    private final String $$robo$$android_icu_util_Calendar$getDisplayName(Locale loc) {
        return this.getClass().getName();
    }

    private final String $$robo$$android_icu_util_Calendar$getDisplayName(ULocale loc) {
        return this.getClass().getName();
    }

    private final int $$robo$$android_icu_util_Calendar$compareTo(Calendar that) {
        long v = this.getTimeInMillis() - that.getTimeInMillis();
        return v < 0L ? -1 : (v > 0L ? 1 : 0);
    }

    private final DateFormat $$robo$$android_icu_util_Calendar$getDateTimeFormat(int dateStyle, int timeStyle, Locale loc) {
        return Calendar.formatHelper(this, ULocale.forLocale(loc), dateStyle, timeStyle);
    }

    private final DateFormat $$robo$$android_icu_util_Calendar$getDateTimeFormat(int dateStyle, int timeStyle, ULocale loc) {
        return Calendar.formatHelper(this, loc, dateStyle, timeStyle);
    }

    private final DateFormat $$robo$$android_icu_util_Calendar$handleGetDateFormat(String pattern, Locale locale) {
        return this.handleGetDateFormat(pattern, null, ULocale.forLocale(locale));
    }

    private final DateFormat $$robo$$android_icu_util_Calendar$handleGetDateFormat(String pattern, String override, Locale locale) {
        return this.handleGetDateFormat(pattern, override, ULocale.forLocale(locale));
    }

    private final DateFormat $$robo$$android_icu_util_Calendar$handleGetDateFormat(String pattern, ULocale locale) {
        return this.handleGetDateFormat(pattern, null, locale);
    }

    private final DateFormat $$robo$$android_icu_util_Calendar$handleGetDateFormat(String pattern, String override, ULocale locale) {
        FormatConfiguration fmtConfig = new FormatConfiguration();
        fmtConfig.pattern = pattern;
        fmtConfig.override = override;
        fmtConfig.formatData = new DateFormatSymbols(this, locale);
        fmtConfig.loc = locale;
        fmtConfig.cal = this;
        return SimpleDateFormat.getInstance(fmtConfig);
    }

    private static final DateFormat $$robo$$android_icu_util_Calendar$formatHelper(Calendar cal, ULocale loc, int dateStyle, int timeStyle) {
        if (timeStyle < -1 || timeStyle > 3) {
            throw new IllegalArgumentException("Illegal time style " + timeStyle);
        }
        if (dateStyle < -1 || dateStyle > 3) {
            throw new IllegalArgumentException("Illegal date style " + dateStyle);
        }
        PatternData patternData = PatternData.make(cal, loc);
        String override = null;
        String pattern = null;
        if (timeStyle >= 0 && dateStyle >= 0) {
            pattern = SimpleFormatterImpl.formatRawPattern(patternData.getDateTimePattern(dateStyle), 2, 2, patternData.patterns[timeStyle], patternData.patterns[dateStyle + 4]);
            if (patternData.overrides != null) {
                String dateOverride = patternData.overrides[dateStyle + 4];
                String timeOverride = patternData.overrides[timeStyle];
                override = Calendar.mergeOverrideStrings(patternData.patterns[dateStyle + 4], patternData.patterns[timeStyle], dateOverride, timeOverride);
            }
        } else if (timeStyle >= 0) {
            pattern = patternData.patterns[timeStyle];
            if (patternData.overrides != null) {
                override = patternData.overrides[timeStyle];
            }
        } else if (dateStyle >= 0) {
            pattern = patternData.patterns[dateStyle + 4];
            if (patternData.overrides != null) {
                override = patternData.overrides[dateStyle + 4];
            }
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        DateFormat result = cal.handleGetDateFormat(pattern, override, loc);
        result.setCalendar(cal);
        return result;
    }

    private static final String $$robo$$android_icu_util_Calendar$getDateTimeFormatString(ULocale loc, String calType, int dateStyle, int timeStyle) {
        if (timeStyle < -1 || timeStyle > 3) {
            throw new IllegalArgumentException("Illegal time style " + timeStyle);
        }
        if (dateStyle < -1 || dateStyle > 3) {
            throw new IllegalArgumentException("Illegal date style " + dateStyle);
        }
        PatternData patternData = PatternData.make(loc, calType);
        String pattern = null;
        if (timeStyle >= 0 && dateStyle >= 0) {
            pattern = SimpleFormatterImpl.formatRawPattern(patternData.getDateTimePattern(dateStyle), 2, 2, patternData.patterns[timeStyle], patternData.patterns[dateStyle + 4]);
        } else if (timeStyle >= 0) {
            pattern = patternData.patterns[timeStyle];
        } else if (dateStyle >= 0) {
            pattern = patternData.patterns[dateStyle + 4];
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        return pattern;
    }

    private static final PatternData $$robo$$android_icu_util_Calendar$getPatternData(ULocale locale, String calType) {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", locale);
        ICUResourceBundle dtPatternsRb = rb.findWithFallback("calendar/" + calType + "/DateTimePatterns");
        if (dtPatternsRb == null) {
            dtPatternsRb = rb.getWithFallback("calendar/gregorian/DateTimePatterns");
        }
        int patternsSize = dtPatternsRb.getSize();
        String[] dateTimePatterns = new String[patternsSize];
        String[] dateTimePatternsOverrides = new String[patternsSize];
        block4: for (int i = 0; i < patternsSize; ++i) {
            ICUResourceBundle concatenationPatternRb = (ICUResourceBundle)dtPatternsRb.get(i);
            switch (concatenationPatternRb.getType()) {
                case 0: {
                    dateTimePatterns[i] = concatenationPatternRb.getString();
                    continue block4;
                }
                case 8: {
                    dateTimePatterns[i] = concatenationPatternRb.getString(0);
                    dateTimePatternsOverrides[i] = concatenationPatternRb.getString(1);
                }
            }
        }
        return new PatternData(dateTimePatterns, dateTimePatternsOverrides);
    }

    @Deprecated
    private static final String $$robo$$android_icu_util_Calendar$getDateTimePattern(Calendar cal, ULocale uLocale, int dateStyle) {
        PatternData patternData = PatternData.make(cal, uLocale);
        return patternData.getDateTimePattern(dateStyle);
    }

    private static final String $$robo$$android_icu_util_Calendar$mergeOverrideStrings(String datePattern, String timePattern, String dateOverride, String timeOverride) {
        if (dateOverride == null && timeOverride == null) {
            return null;
        }
        if (dateOverride == null) {
            return Calendar.expandOverride(timePattern, timeOverride);
        }
        if (timeOverride == null) {
            return Calendar.expandOverride(datePattern, dateOverride);
        }
        if (dateOverride.equals(timeOverride)) {
            return dateOverride;
        }
        return Calendar.expandOverride(datePattern, dateOverride) + ";" + Calendar.expandOverride(timePattern, timeOverride);
    }

    private static final String $$robo$$android_icu_util_Calendar$expandOverride(String pattern, String override) {
        if (override.indexOf(61) >= 0) {
            return override;
        }
        boolean inQuotes = false;
        char prevChar = ' ';
        StringBuilder result = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(pattern);
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\'') {
                inQuotes = !inQuotes;
                prevChar = c;
            } else {
                if (!inQuotes && c != prevChar) {
                    if (result.length() > 0) {
                        result.append(";");
                    }
                    result.append(c);
                    result.append("=");
                    result.append(override);
                }
                prevChar = c;
            }
            c = it.next();
        }
        return result.toString();
    }

    private final void $$robo$$android_icu_util_Calendar$pinField(int field) {
        int max = this.getActualMaximum(field);
        int min = this.getActualMinimum(field);
        if (this.fields[field] > max) {
            this.set(field, max);
        } else if (this.fields[field] < min) {
            this.set(field, min);
        }
    }

    private final int $$robo$$android_icu_util_Calendar$weekNumber(int desiredDay, int dayOfPeriod, int dayOfWeek) {
        int periodStartDayOfWeek = (dayOfWeek - this.getFirstDayOfWeek() - dayOfPeriod + 1) % 7;
        if (periodStartDayOfWeek < 0) {
            periodStartDayOfWeek += 7;
        }
        int weekNo = (desiredDay + periodStartDayOfWeek - 1) / 7;
        if (7 - periodStartDayOfWeek >= this.getMinimalDaysInFirstWeek()) {
            ++weekNo;
        }
        return weekNo;
    }

    private final int $$robo$$android_icu_util_Calendar$weekNumber(int dayOfPeriod, int dayOfWeek) {
        return this.weekNumber(dayOfPeriod, dayOfPeriod, dayOfWeek);
    }

    private final int $$robo$$android_icu_util_Calendar$fieldDifference(Date when, int field) {
        long targetMs;
        int min = 0;
        long startMs = this.getTimeInMillis();
        if (startMs < (targetMs = when.getTime())) {
            int max;
            block13: {
                max = 1;
                while (true) {
                    this.setTimeInMillis(startMs);
                    this.add(field, max);
                    long ms = this.getTimeInMillis();
                    if (ms == targetMs) {
                        return max;
                    }
                    if (ms > targetMs) break block13;
                    if (max >= Integer.MAX_VALUE) break;
                    min = max;
                    if ((max <<= 1) >= 0) continue;
                    max = Integer.MAX_VALUE;
                }
                throw new RuntimeException();
            }
            while (max - min > 1) {
                int t = min + (max - min) / 2;
                this.setTimeInMillis(startMs);
                this.add(field, t);
                long ms = this.getTimeInMillis();
                if (ms == targetMs) {
                    return t;
                }
                if (ms > targetMs) {
                    max = t;
                    continue;
                }
                min = t;
            }
        } else if (startMs > targetMs) {
            int max;
            block14: {
                max = -1;
                do {
                    this.setTimeInMillis(startMs);
                    this.add(field, max);
                    long ms = this.getTimeInMillis();
                    if (ms == targetMs) {
                        return max;
                    }
                    if (ms < targetMs) break block14;
                    min = max;
                } while ((max <<= 1) != 0);
                throw new RuntimeException();
            }
            while (min - max > 1) {
                int t = min + (max - min) / 2;
                this.setTimeInMillis(startMs);
                this.add(field, t);
                long ms = this.getTimeInMillis();
                if (ms == targetMs) {
                    return t;
                }
                if (ms < targetMs) {
                    max = t;
                    continue;
                }
                min = t;
            }
        }
        this.setTimeInMillis(startMs);
        this.add(field, min);
        return min;
    }

    private final void $$robo$$android_icu_util_Calendar$setTimeZone(TimeZone value) {
        this.zone = value;
        this.areFieldsSet = false;
    }

    private final TimeZone $$robo$$android_icu_util_Calendar$getTimeZone() {
        return this.zone;
    }

    private final void $$robo$$android_icu_util_Calendar$setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    private final boolean $$robo$$android_icu_util_Calendar$isLenient() {
        return this.lenient;
    }

    private final void $$robo$$android_icu_util_Calendar$setRepeatedWallTimeOption(int option) {
        if (option != 0 && option != 1) {
            throw new IllegalArgumentException("Illegal repeated wall time option - " + option);
        }
        this.repeatedWallTime = option;
    }

    private final int $$robo$$android_icu_util_Calendar$getRepeatedWallTimeOption() {
        return this.repeatedWallTime;
    }

    private final void $$robo$$android_icu_util_Calendar$setSkippedWallTimeOption(int option) {
        if (option != 0 && option != 1 && option != 2) {
            throw new IllegalArgumentException("Illegal skipped wall time option - " + option);
        }
        this.skippedWallTime = option;
    }

    private final int $$robo$$android_icu_util_Calendar$getSkippedWallTimeOption() {
        return this.skippedWallTime;
    }

    private final void $$robo$$android_icu_util_Calendar$setFirstDayOfWeek(int value) {
        if (this.firstDayOfWeek != value) {
            if (value < 1 || value > 7) {
                throw new IllegalArgumentException("Invalid day of week");
            }
            this.firstDayOfWeek = value;
            this.areFieldsSet = false;
        }
    }

    private final int $$robo$$android_icu_util_Calendar$getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    private final void $$robo$$android_icu_util_Calendar$setMinimalDaysInFirstWeek(int value) {
        if (value < 1) {
            value = 1;
        } else if (value > 7) {
            value = 7;
        }
        if (this.minimalDaysInFirstWeek != value) {
            this.minimalDaysInFirstWeek = value;
            this.areFieldsSet = false;
        }
    }

    private final int $$robo$$android_icu_util_Calendar$getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    protected abstract int handleGetLimit(int var1, int var2);

    private final int $$robo$$android_icu_util_Calendar$getLimit(int field, int limitType) {
        switch (field) {
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                return LIMITS[field][limitType];
            }
            case 4: {
                int limit;
                if (limitType == 0) {
                    limit = this.getMinimalDaysInFirstWeek() == 1 ? 1 : 0;
                } else if (limitType == 1) {
                    limit = 1;
                } else {
                    int minDaysInFirst = this.getMinimalDaysInFirstWeek();
                    int daysInMonth = this.handleGetLimit(5, limitType);
                    limit = limitType == 2 ? (daysInMonth + (7 - minDaysInFirst)) / 7 : (daysInMonth + 6 + (7 - minDaysInFirst)) / 7;
                }
                return limit;
            }
        }
        return this.handleGetLimit(field, limitType);
    }

    private final int $$robo$$android_icu_util_Calendar$getMinimum(int field) {
        return this.getLimit(field, 0);
    }

    private final int $$robo$$android_icu_util_Calendar$getMaximum(int field) {
        return this.getLimit(field, 3);
    }

    private final int $$robo$$android_icu_util_Calendar$getGreatestMinimum(int field) {
        return this.getLimit(field, 1);
    }

    private final int $$robo$$android_icu_util_Calendar$getLeastMaximum(int field) {
        return this.getLimit(field, 2);
    }

    @Deprecated
    private final int $$robo$$android_icu_util_Calendar$getDayOfWeekType(int dayOfWeek) {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("Invalid day of week");
        }
        if (this.weekendOnset == this.weekendCease) {
            if (dayOfWeek != this.weekendOnset) {
                return 0;
            }
            return this.weekendOnsetMillis == 0 ? 1 : 2;
        }
        if (this.weekendOnset < this.weekendCease ? dayOfWeek < this.weekendOnset || dayOfWeek > this.weekendCease : dayOfWeek > this.weekendCease && dayOfWeek < this.weekendOnset) {
            return 0;
        }
        if (dayOfWeek == this.weekendOnset) {
            return this.weekendOnsetMillis == 0 ? 1 : 2;
        }
        if (dayOfWeek == this.weekendCease) {
            return this.weekendCeaseMillis >= 86400000 ? 1 : 3;
        }
        return 1;
    }

    @Deprecated
    private final int $$robo$$android_icu_util_Calendar$getWeekendTransition(int dayOfWeek) {
        if (dayOfWeek == this.weekendOnset) {
            return this.weekendOnsetMillis;
        }
        if (dayOfWeek == this.weekendCease) {
            return this.weekendCeaseMillis;
        }
        throw new IllegalArgumentException("Not weekend transition day");
    }

    private final boolean $$robo$$android_icu_util_Calendar$isWeekend(Date date) {
        this.setTime(date);
        return this.isWeekend();
    }

    private final boolean $$robo$$android_icu_util_Calendar$isWeekend() {
        int dow = this.get(7);
        int dowt = this.getDayOfWeekType(dow);
        switch (dowt) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        int millisInDay = this.internalGet(14) + 1000 * (this.internalGet(13) + 60 * (this.internalGet(12) + 60 * this.internalGet(11)));
        int transition2 = this.getWeekendTransition(dow);
        return dowt == 2 ? millisInDay >= transition2 : millisInDay < transition2;
    }

    private final Object $$robo$$android_icu_util_Calendar$clone() {
        try {
            Calendar other = (Calendar)super.clone();
            other.fields = new int[this.fields.length];
            other.stamp = new int[this.fields.length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.fields, (int)0, (int[])other.fields, (int)0, (int)this.fields.length);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.stamp, (int)0, (int[])other.stamp, (int)0, (int)this.fields.length);
            other.zone = (TimeZone)this.zone.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    private final String $$robo$$android_icu_util_Calendar$toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName());
        buffer.append("[time=");
        buffer.append(this.isTimeSet ? String.valueOf(this.time) : "?");
        buffer.append(",areFieldsSet=");
        buffer.append(this.areFieldsSet);
        buffer.append(",areAllFieldsSet=");
        buffer.append(this.areAllFieldsSet);
        buffer.append(",lenient=");
        buffer.append(this.lenient);
        buffer.append(",zone=");
        buffer.append(this.zone);
        buffer.append(",firstDayOfWeek=");
        buffer.append(this.firstDayOfWeek);
        buffer.append(",minimalDaysInFirstWeek=");
        buffer.append(this.minimalDaysInFirstWeek);
        buffer.append(",repeatedWallTime=");
        buffer.append(this.repeatedWallTime);
        buffer.append(",skippedWallTime=");
        buffer.append(this.skippedWallTime);
        for (int i = 0; i < this.fields.length; ++i) {
            buffer.append(',').append(this.fieldName(i)).append('=');
            buffer.append(this.isSet(i) ? String.valueOf(this.fields[i]) : "?");
        }
        buffer.append(']');
        return buffer.toString();
    }

    private static final WeekData $$robo$$android_icu_util_Calendar$getWeekDataForRegion(String region) {
        return WEEK_DATA_CACHE.createInstance(region, region);
    }

    private final WeekData $$robo$$android_icu_util_Calendar$getWeekData() {
        return new WeekData(this.firstDayOfWeek, this.minimalDaysInFirstWeek, this.weekendOnset, this.weekendOnsetMillis, this.weekendCease, this.weekendCeaseMillis);
    }

    private final Calendar $$robo$$android_icu_util_Calendar$setWeekData(WeekData wdata) {
        this.setFirstDayOfWeek(wdata.firstDayOfWeek);
        this.setMinimalDaysInFirstWeek(wdata.minimalDaysInFirstWeek);
        this.weekendOnset = wdata.weekendOnset;
        this.weekendOnsetMillis = wdata.weekendOnsetMillis;
        this.weekendCease = wdata.weekendCease;
        this.weekendCeaseMillis = wdata.weekendCeaseMillis;
        return this;
    }

    private static final WeekData $$robo$$android_icu_util_Calendar$getWeekDataForRegionInternal(String region) {
        if (region == null) {
            region = "001";
        }
        UResourceBundle rb = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle weekDataInfo = rb.get("weekData");
        UResourceBundle weekDataBundle = null;
        try {
            weekDataBundle = weekDataInfo.get(region);
        }
        catch (MissingResourceException mre) {
            if (!region.equals("001")) {
                weekDataBundle = weekDataInfo.get("001");
            }
            throw mre;
        }
        int[] wdi = weekDataBundle.getIntVector();
        return new WeekData(wdi[0], wdi[1], wdi[2], wdi[3], wdi[4], wdi[5]);
    }

    private final void $$robo$$android_icu_util_Calendar$setWeekData(String region) {
        if (region == null) {
            region = "001";
        }
        WeekData wdata = (WeekData)WEEK_DATA_CACHE.getInstance(region, region);
        this.setWeekData(wdata);
    }

    private final void $$robo$$android_icu_util_Calendar$updateTime() {
        this.computeTime();
        if (this.isLenient() || !this.areAllFieldsSet) {
            this.areFieldsSet = false;
        }
        this.isTimeSet = true;
        this.areFieldsVirtuallySet = false;
    }

    private final void $$robo$$android_icu_util_Calendar$writeObject(ObjectOutputStream stream) throws IOException {
        if (!this.isTimeSet) {
            try {
                this.updateTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        stream.defaultWriteObject();
    }

    private final void $$robo$$android_icu_util_Calendar$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initInternal();
        this.isTimeSet = true;
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
        this.areFieldsVirtuallySet = true;
        this.nextStamp = 2;
    }

    private final void $$robo$$android_icu_util_Calendar$computeFields() {
        int millisInDay;
        int[] offsets = new int[2];
        this.getTimeZone().getOffset(this.time, false, offsets);
        long localMillis = this.time + (long)offsets[0] + (long)offsets[1];
        int mask = this.internalSetMask;
        for (int i = 0; i < this.fields.length; ++i) {
            this.stamp[i] = (mask & 1) == 0 ? 1 : 0;
            mask >>= 1;
        }
        long days = Calendar.floorDivide(localMillis, 86400000L);
        this.fields[20] = (int)days + 2440588;
        this.computeGregorianAndDOWFields(this.fields[20]);
        this.handleComputeFields(this.fields[20]);
        this.computeWeekFields();
        this.fields[21] = millisInDay = (int)(localMillis - days * 86400000L);
        this.fields[14] = millisInDay % 1000;
        this.fields[13] = (millisInDay /= 1000) % 60;
        this.fields[12] = (millisInDay /= 60) % 60;
        this.fields[11] = millisInDay /= 60;
        this.fields[9] = millisInDay / 12;
        this.fields[10] = millisInDay % 12;
        this.fields[15] = offsets[0];
        this.fields[16] = offsets[1];
    }

    private final void $$robo$$android_icu_util_Calendar$computeGregorianAndDOWFields(int julianDay) {
        this.computeGregorianFields(julianDay);
        int dow = this.fields[7] = Calendar.julianDayToDayOfWeek(julianDay);
        int dowLocal = dow - this.getFirstDayOfWeek() + 1;
        if (dowLocal < 1) {
            dowLocal += 7;
        }
        this.fields[18] = dowLocal;
    }

    private final void $$robo$$android_icu_util_Calendar$computeGregorianFields(int julianDay) {
        int march1;
        long gregorianEpochDay = julianDay - 1721426;
        int[] rem = new int[1];
        int n400 = Calendar.floorDivide(gregorianEpochDay, 146097, rem);
        int n100 = Calendar.floorDivide(rem[0], 36524, rem);
        int n4 = Calendar.floorDivide(rem[0], 1461, rem);
        int n1 = Calendar.floorDivide(rem[0], 365, rem);
        int year = 400 * n400 + 100 * n100 + 4 * n4 + n1;
        int dayOfYear = rem[0];
        if (n100 == 4 || n1 == 4) {
            dayOfYear = 365;
        } else {
            ++year;
        }
        boolean isLeap = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
        int correction = 0;
        int n = march1 = isLeap ? 60 : 59;
        if (dayOfYear >= march1) {
            correction = isLeap ? 1 : 2;
        }
        int month = (12 * (dayOfYear + correction) + 6) / 367;
        int dayOfMonth = dayOfYear - GREGORIAN_MONTH_COUNT[month][isLeap ? 3 : 2] + 1;
        this.gregorianYear = year;
        this.gregorianMonth = month;
        this.gregorianDayOfMonth = dayOfMonth;
        this.gregorianDayOfYear = dayOfYear + 1;
    }

    private final void $$robo$$android_icu_util_Calendar$computeWeekFields() {
        int eyear = this.fields[19];
        int dayOfWeek = this.fields[7];
        int dayOfYear = this.fields[6];
        int yearOfWeekOfYear = eyear;
        int relDow = (dayOfWeek + 7 - this.getFirstDayOfWeek()) % 7;
        int relDowJan1 = (dayOfWeek - dayOfYear + 7001 - this.getFirstDayOfWeek()) % 7;
        int woy = (dayOfYear - 1 + relDowJan1) / 7;
        if (7 - relDowJan1 >= this.getMinimalDaysInFirstWeek()) {
            ++woy;
        }
        if (woy == 0) {
            int prevDoy = dayOfYear + this.handleGetYearLength(eyear - 1);
            woy = this.weekNumber(prevDoy, dayOfWeek);
        } else {
            int lastDoy = this.handleGetYearLength(eyear);
            if (dayOfYear >= lastDoy - 5) {
                int lastRelDow = (relDow + lastDoy - dayOfYear) % 7;
                if (lastRelDow < 0) {
                    lastRelDow += 7;
                }
                if (6 - lastRelDow >= this.getMinimalDaysInFirstWeek() && dayOfYear + 7 - relDow > lastDoy) {
                    woy = 1;
                    ++yearOfWeekOfYear;
                }
            }
        }
        this.fields[3] = woy;
        this.fields[17] = --yearOfWeekOfYear;
        int dayOfMonth = this.fields[5];
        this.fields[4] = this.weekNumber(dayOfMonth, dayOfWeek);
        this.fields[8] = (dayOfMonth - 1) / 7 + 1;
    }

    private final int $$robo$$android_icu_util_Calendar$resolveFields(int[][][] precedenceTable) {
        int bestField = -1;
        for (int g = 0; g < precedenceTable.length && bestField < 0; ++g) {
            int[][] group = precedenceTable[g];
            int bestStamp = 0;
            block1: for (int l = 0; l < group.length; ++l) {
                int i;
                int[] line = group[l];
                int lineStamp = 0;
                int n = i = line[0] >= 32 ? 1 : 0;
                while (i < line.length) {
                    int s = this.stamp[line[i]];
                    if (s == 0) continue block1;
                    lineStamp = Math.max(lineStamp, s);
                    ++i;
                }
                if (lineStamp <= bestStamp) continue;
                int tempBestField = line[0];
                if (tempBestField >= 32) {
                    if ((tempBestField &= 0x1F) != 5 || this.stamp[4] < this.stamp[tempBestField]) {
                        bestField = tempBestField;
                    }
                } else {
                    bestField = tempBestField;
                }
                if (bestField != tempBestField) continue;
                bestStamp = lineStamp;
            }
        }
        return bestField >= 32 ? bestField & 0x1F : bestField;
    }

    private final int $$robo$$android_icu_util_Calendar$newestStamp(int first, int last, int bestStampSoFar) {
        int bestStamp = bestStampSoFar;
        for (int i = first; i <= last; ++i) {
            if (this.stamp[i] <= bestStamp) continue;
            bestStamp = this.stamp[i];
        }
        return bestStamp;
    }

    private final int $$robo$$android_icu_util_Calendar$getStamp(int field) {
        return this.stamp[field];
    }

    private final int $$robo$$android_icu_util_Calendar$newerField(int defaultField, int alternateField) {
        if (this.stamp[alternateField] > this.stamp[defaultField]) {
            return alternateField;
        }
        return defaultField;
    }

    private final void $$robo$$android_icu_util_Calendar$validateFields() {
        for (int field = 0; field < this.fields.length; ++field) {
            if (this.stamp[field] < 2) continue;
            this.validateField(field);
        }
    }

    private final void $$robo$$android_icu_util_Calendar$validateField(int field) {
        switch (field) {
            case 5: {
                int y = this.handleGetExtendedYear();
                this.validateField(field, 1, this.handleGetMonthLength(y, this.internalGet(2)));
                break;
            }
            case 6: {
                int y = this.handleGetExtendedYear();
                this.validateField(field, 1, this.handleGetYearLength(y));
                break;
            }
            case 8: {
                if (this.internalGet(field) == 0) {
                    throw new IllegalArgumentException("DAY_OF_WEEK_IN_MONTH cannot be zero");
                }
                this.validateField(field, this.getMinimum(field), this.getMaximum(field));
                break;
            }
            default: {
                this.validateField(field, this.getMinimum(field), this.getMaximum(field));
            }
        }
    }

    private final void $$robo$$android_icu_util_Calendar$validateField(int field, int min, int max) {
        int value = this.fields[field];
        if (value < min || value > max) {
            throw new IllegalArgumentException(this.fieldName(field) + '=' + value + ", valid range=" + min + ".." + max);
        }
    }

    private final void $$robo$$android_icu_util_Calendar$computeTime() {
        if (!this.isLenient()) {
            this.validateFields();
        }
        int julianDay = this.computeJulianDay();
        long millis = Calendar.julianDayToMillis(julianDay);
        int millisInDay = this.stamp[21] >= 2 && this.newestStamp(9, 14, 0) <= this.stamp[21] ? this.internalGet(21) : this.computeMillisInDay();
        if (this.stamp[15] >= 2 || this.stamp[16] >= 2) {
            this.time = millis + (long)millisInDay - (long)(this.internalGet(15) + this.internalGet(16));
        } else if (!this.lenient || this.skippedWallTime == 2) {
            long tmpTime;
            int zoneOffset1;
            int zoneOffset = this.computeZoneOffset(millis, millisInDay);
            if (zoneOffset != (zoneOffset1 = this.zone.getOffset(tmpTime = millis + (long)millisInDay - (long)zoneOffset))) {
                if (!this.lenient) {
                    throw new IllegalArgumentException("The specified wall time does not exist due to time zone offset transition.");
                }
                if (!$assertionsDisabled && this.skippedWallTime != 2) {
                    throw new AssertionError(this.skippedWallTime);
                }
                Long immediatePrevTransition = this.getImmediatePreviousZoneTransition(tmpTime);
                if (immediatePrevTransition == null) {
                    throw new RuntimeException("Could not locate a time zone transition before " + tmpTime);
                }
                this.time = immediatePrevTransition;
            } else {
                this.time = tmpTime;
            }
        } else {
            this.time = millis + (long)millisInDay - (long)this.computeZoneOffset(millis, millisInDay);
        }
    }

    private final Long $$robo$$android_icu_util_Calendar$getImmediatePreviousZoneTransition(long base) {
        Long transitionTime = null;
        if (this.zone instanceof BasicTimeZone) {
            TimeZoneTransition transition2 = ((BasicTimeZone)this.zone).getPreviousTransition(base, true);
            if (transition2 != null) {
                transitionTime = transition2.getTime();
            }
        } else {
            transitionTime = Calendar.getPreviousZoneTransitionTime(this.zone, base, 0x6DDD00L);
            if (transitionTime == null) {
                transitionTime = Calendar.getPreviousZoneTransitionTime(this.zone, base, 108000000L);
            }
        }
        return transitionTime;
    }

    private static final Long $$robo$$android_icu_util_Calendar$getPreviousZoneTransitionTime(TimeZone tz, long base, long duration) {
        int offsetL;
        if (!$assertionsDisabled && duration <= 0L) {
            throw new AssertionError();
        }
        long upper = base;
        long lower = base - duration - 1L;
        int offsetU = tz.getOffset(upper);
        if (offsetU == (offsetL = tz.getOffset(lower))) {
            return null;
        }
        return Calendar.findPreviousZoneTransitionTime(tz, offsetU, upper, lower);
    }

    private static final Long $$robo$$android_icu_util_Calendar$findPreviousZoneTransitionTime(TimeZone tz, int upperOffset, long upper, long lower) {
        boolean onUnitTime = false;
        long mid = 0L;
        for (int unit : FIND_ZONE_TRANSITION_TIME_UNITS) {
            long uunits = upper / (long)unit;
            long lunits = lower / (long)unit;
            if (uunits <= lunits) continue;
            mid = (lunits + uunits + 1L >>> 1) * (long)unit;
            onUnitTime = true;
            break;
        }
        if (!onUnitTime) {
            mid = upper + lower >>> 1;
        }
        if (onUnitTime) {
            if (mid != upper) {
                int midOffset = tz.getOffset(mid);
                if (midOffset != upperOffset) {
                    return Calendar.findPreviousZoneTransitionTime(tz, upperOffset, upper, mid);
                }
                upper = mid;
            }
            --mid;
        } else {
            mid = upper + lower >>> 1;
        }
        if (mid == lower) {
            return upper;
        }
        int midOffset = tz.getOffset(mid);
        if (midOffset != upperOffset) {
            if (onUnitTime) {
                return upper;
            }
            return Calendar.findPreviousZoneTransitionTime(tz, upperOffset, upper, mid);
        }
        return Calendar.findPreviousZoneTransitionTime(tz, upperOffset, mid, lower);
    }

    private final int $$robo$$android_icu_util_Calendar$computeMillisInDay() {
        int bestStamp;
        int millisInDay = 0;
        int hourOfDayStamp = this.stamp[11];
        int hourStamp = Math.max(this.stamp[10], this.stamp[9]);
        int n = bestStamp = hourStamp > hourOfDayStamp ? hourStamp : hourOfDayStamp;
        if (bestStamp != 0) {
            if (bestStamp == hourOfDayStamp) {
                millisInDay += this.internalGet(11);
            } else {
                millisInDay += this.internalGet(10);
                millisInDay += 12 * this.internalGet(9);
            }
        }
        millisInDay *= 60;
        millisInDay += this.internalGet(12);
        millisInDay *= 60;
        millisInDay += this.internalGet(13);
        millisInDay *= 1000;
        return millisInDay += this.internalGet(14);
    }

    private final int $$robo$$android_icu_util_Calendar$computeZoneOffset(long millis, int millisInDay) {
        int[] offsets = new int[2];
        long wall = millis + (long)millisInDay;
        if (this.zone instanceof BasicTimeZone) {
            int duplicatedTimeOpt = this.repeatedWallTime == 1 ? 4 : 12;
            int nonExistingTimeOpt = this.skippedWallTime == 1 ? 12 : 4;
            ((BasicTimeZone)this.zone).getOffsetFromLocal(wall, nonExistingTimeOpt, duplicatedTimeOpt, offsets);
        } else {
            long tgmt;
            this.zone.getOffset(wall, true, offsets);
            boolean sawRecentNegativeShift = false;
            if (this.repeatedWallTime == 1) {
                tgmt = wall - (long)(offsets[0] + offsets[1]);
                int offsetBefore6 = this.zone.getOffset(tgmt - 21600000L);
                int offsetDelta = offsets[0] + offsets[1] - offsetBefore6;
                if (!$assertionsDisabled && offsetDelta <= -21600000) {
                    throw new AssertionError(offsetDelta);
                }
                if (offsetDelta < 0) {
                    sawRecentNegativeShift = true;
                    this.zone.getOffset(wall + (long)offsetDelta, true, offsets);
                }
            }
            if (!sawRecentNegativeShift && this.skippedWallTime == 1) {
                tgmt = wall - (long)(offsets[0] + offsets[1]);
                this.zone.getOffset(tgmt, false, offsets);
            }
        }
        return offsets[0] + offsets[1];
    }

    private final int $$robo$$android_icu_util_Calendar$computeJulianDay() {
        int bestField;
        if (this.stamp[20] >= 2) {
            int bestStamp = this.newestStamp(0, 8, 0);
            if ((bestStamp = this.newestStamp(17, 19, bestStamp)) <= this.stamp[20]) {
                return this.internalGet(20);
            }
        }
        if ((bestField = this.resolveFields(this.getFieldResolutionTable())) < 0) {
            bestField = 5;
        }
        return this.handleComputeJulianDay(bestField);
    }

    private final int[][][] $$robo$$android_icu_util_Calendar$getFieldResolutionTable() {
        return DATE_PRECEDENCE;
    }

    protected abstract int handleComputeMonthStart(int var1, int var2, boolean var3);

    protected abstract int handleGetExtendedYear();

    private final int $$robo$$android_icu_util_Calendar$handleGetMonthLength(int extendedYear, int month) {
        return this.handleComputeMonthStart(extendedYear, month + 1, true) - this.handleComputeMonthStart(extendedYear, month, true);
    }

    private final int $$robo$$android_icu_util_Calendar$handleGetYearLength(int eyear) {
        return this.handleComputeMonthStart(eyear + 1, 0, false) - this.handleComputeMonthStart(eyear, 0, false);
    }

    private final int[] $$robo$$android_icu_util_Calendar$handleCreateFields() {
        return new int[23];
    }

    private final int $$robo$$android_icu_util_Calendar$getDefaultMonthInYear(int extendedYear) {
        return 0;
    }

    private final int $$robo$$android_icu_util_Calendar$getDefaultDayInMonth(int extendedYear, int month) {
        return 1;
    }

    private final int $$robo$$android_icu_util_Calendar$handleComputeJulianDay(int bestField) {
        boolean useMonth = bestField == 5 || bestField == 4 || bestField == 8;
        int year = bestField == 3 ? this.internalGet(17, this.handleGetExtendedYear()) : this.handleGetExtendedYear();
        this.internalSet(19, year);
        int month = useMonth ? this.internalGet(2, this.getDefaultMonthInYear(year)) : 0;
        int julianDay = this.handleComputeMonthStart(year, month, useMonth);
        if (bestField == 5) {
            if (this.isSet(5)) {
                return julianDay + this.internalGet(5, this.getDefaultDayInMonth(year, month));
            }
            return julianDay + this.getDefaultDayInMonth(year, month);
        }
        if (bestField == 6) {
            return julianDay + this.internalGet(6);
        }
        int firstDOW = this.getFirstDayOfWeek();
        int first = Calendar.julianDayToDayOfWeek(julianDay + 1) - firstDOW;
        if (first < 0) {
            first += 7;
        }
        int dowLocal = 0;
        switch (this.resolveFields(DOW_PRECEDENCE)) {
            case 7: {
                dowLocal = this.internalGet(7) - firstDOW;
                break;
            }
            case 18: {
                dowLocal = this.internalGet(18) - 1;
            }
        }
        if ((dowLocal %= 7) < 0) {
            dowLocal += 7;
        }
        int date = 1 - first + dowLocal;
        if (bestField == 8) {
            int dim;
            if (date < 1) {
                date += 7;
            }
            if ((dim = this.internalGet(8, 1)) >= 0) {
                date += 7 * (dim - 1);
            } else {
                int m = this.internalGet(2, 0);
                int monthLength = this.handleGetMonthLength(year, m);
                date += ((monthLength - date) / 7 + dim + 1) * 7;
            }
        } else {
            if (7 - first < this.getMinimalDaysInFirstWeek()) {
                date += 7;
            }
            date += 7 * (this.internalGet(bestField) - 1);
        }
        return julianDay + date;
    }

    private final int $$robo$$android_icu_util_Calendar$computeGregorianMonthStart(int year, int month) {
        if (month < 0 || month > 11) {
            int[] rem = new int[1];
            year += Calendar.floorDivide(month, 12, rem);
            month = rem[0];
        }
        boolean isLeap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int y = year - 1;
        int julianDay = 365 * y + Calendar.floorDivide(y, 4) - Calendar.floorDivide(y, 100) + Calendar.floorDivide(y, 400) + 1721426 - 1;
        if (month != 0) {
            julianDay += GREGORIAN_MONTH_COUNT[month][isLeap ? 3 : 2];
        }
        return julianDay;
    }

    private final void $$robo$$android_icu_util_Calendar$handleComputeFields(int julianDay) {
        this.internalSet(2, this.getGregorianMonth());
        this.internalSet(5, this.getGregorianDayOfMonth());
        this.internalSet(6, this.getGregorianDayOfYear());
        int eyear = this.getGregorianYear();
        this.internalSet(19, eyear);
        int era = 1;
        if (eyear < 1) {
            era = 0;
            eyear = 1 - eyear;
        }
        this.internalSet(0, era);
        this.internalSet(1, eyear);
    }

    private final int $$robo$$android_icu_util_Calendar$getGregorianYear() {
        return this.gregorianYear;
    }

    private final int $$robo$$android_icu_util_Calendar$getGregorianMonth() {
        return this.gregorianMonth;
    }

    private final int $$robo$$android_icu_util_Calendar$getGregorianDayOfYear() {
        return this.gregorianDayOfYear;
    }

    private final int $$robo$$android_icu_util_Calendar$getGregorianDayOfMonth() {
        return this.gregorianDayOfMonth;
    }

    private final int $$robo$$android_icu_util_Calendar$getFieldCount() {
        return this.fields.length;
    }

    private final void $$robo$$android_icu_util_Calendar$internalSet(int field, int value) {
        if ((1 << field & this.internalSetMask) == 0) {
            throw new IllegalStateException("Subclass cannot set " + this.fieldName(field));
        }
        this.fields[field] = value;
        this.stamp[field] = 1;
    }

    private static final boolean $$robo$$android_icu_util_Calendar$isGregorianLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static final int $$robo$$android_icu_util_Calendar$gregorianMonthLength(int y, int m) {
        return GREGORIAN_MONTH_COUNT[m][Calendar.isGregorianLeapYear(y) ? 1 : 0];
    }

    private static final int $$robo$$android_icu_util_Calendar$gregorianPreviousMonthLength(int y, int m) {
        return m > 0 ? Calendar.gregorianMonthLength(y, m - 1) : 31;
    }

    private static final long $$robo$$android_icu_util_Calendar$floorDivide(long numerator, long denominator) {
        return numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
    }

    private static final int $$robo$$android_icu_util_Calendar$floorDivide(int numerator, int denominator) {
        return numerator >= 0 ? numerator / denominator : (numerator + 1) / denominator - 1;
    }

    private static final int $$robo$$android_icu_util_Calendar$floorDivide(int numerator, int denominator, int[] remainder) {
        if (numerator >= 0) {
            remainder[0] = numerator % denominator;
            return numerator / denominator;
        }
        int quotient = (numerator + 1) / denominator - 1;
        remainder[0] = numerator - quotient * denominator;
        return quotient;
    }

    private static final int $$robo$$android_icu_util_Calendar$floorDivide(long numerator, int denominator, int[] remainder) {
        if (numerator >= 0L) {
            remainder[0] = (int)(numerator % (long)denominator);
            return (int)(numerator / (long)denominator);
        }
        int quotient = (int)((numerator + 1L) / (long)denominator - 1L);
        remainder[0] = (int)(numerator - (long)quotient * (long)denominator);
        return quotient;
    }

    private final String $$robo$$android_icu_util_Calendar$fieldName(int field) {
        try {
            return FIELD_NAME[field];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Field " + field;
        }
    }

    private static final int $$robo$$android_icu_util_Calendar$millisToJulianDay(long millis) {
        return (int)(2440588L + Calendar.floorDivide(millis, 86400000L));
    }

    private static final long $$robo$$android_icu_util_Calendar$julianDayToMillis(int julian) {
        return (long)(julian - 2440588) * 86400000L;
    }

    private static final int $$robo$$android_icu_util_Calendar$julianDayToDayOfWeek(int julian) {
        int dayOfWeek = (julian + 2) % 7;
        if (dayOfWeek < 1) {
            dayOfWeek += 7;
        }
        return dayOfWeek;
    }

    private final long $$robo$$android_icu_util_Calendar$internalGetTimeInMillis() {
        return this.time;
    }

    private final String $$robo$$android_icu_util_Calendar$getType() {
        return "unknown";
    }

    @Deprecated
    private final boolean $$robo$$android_icu_util_Calendar$haveDefaultCentury() {
        return true;
    }

    private final ULocale $$robo$$android_icu_util_Calendar$getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    private final void $$robo$$android_icu_util_Calendar$setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !Calendar.class.desiredAssertionStatus();
        MIN_DATE = new Date(-184303902528000000L);
        MAX_DATE = new Date(183882168921600000L);
        STAMP_MAX = 10000;
        PATTERN_CACHE = new SimpleCache<String, PatternData>();
        DEFAULT_PATTERNS = new String[]{"HH:mm:ss z", "HH:mm:ss z", "HH:mm:ss", "HH:mm", "EEEE, yyyy MMMM dd", "yyyy MMMM d", "yyyy MMM d", "yy/MM/dd", "{1} {0}", "{1} {0}", "{1} {0}", "{1} {0}", "{1} {0}"};
        LIMITS = new int[][]{new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {1, 1, 7, 7}, new int[0], {0, 0, 1, 1}, {0, 0, 11, 11}, {0, 0, 23, 23}, {0, 0, 59, 59}, {0, 0, 59, 59}, {0, 0, 999, 999}, {-43200000, -43200000, 43200000, 43200000}, {0, 0, 3600000, 3600000}, new int[0], {1, 1, 7, 7}, new int[0], {-2130706432, -2130706432, 0x7F000000, 0x7F000000}, {0, 0, 86399999, 86399999}, {0, 0, 1, 1}};
        WEEK_DATA_CACHE = new WeekDataCache();
        DATE_PRECEDENCE = new int[][][]{new int[][]{{5}, {3, 7}, {4, 7}, {8, 7}, {3, 18}, {4, 18}, {8, 18}, {6}, {37, 1}, {35, 17}}, new int[][]{{3}, {4}, {8}, {40, 7}, {40, 18}}};
        DOW_PRECEDENCE = new int[][][]{new int[][]{{7}, {18}}};
        FIND_ZONE_TRANSITION_TIME_UNITS = new int[]{3600000, 1800000, 60000, 1000};
        GREGORIAN_MONTH_COUNT = new int[][]{{31, 31, 0, 0}, {28, 29, 31, 31}, {31, 31, 59, 60}, {30, 30, 90, 91}, {31, 31, 120, 121}, {30, 30, 151, 152}, {31, 31, 181, 182}, {31, 31, 212, 213}, {30, 30, 243, 244}, {31, 31, 273, 274}, {30, 30, 304, 305}, {31, 31, 334, 335}};
        FIELD_NAME = new String[]{"ERA", "YEAR", "MONTH", "WEEK_OF_YEAR", "WEEK_OF_MONTH", "DAY_OF_MONTH", "DAY_OF_YEAR", "DAY_OF_WEEK", "DAY_OF_WEEK_IN_MONTH", "AM_PM", "HOUR", "HOUR_OF_DAY", "MINUTE", "SECOND", "MILLISECOND", "ZONE_OFFSET", "DST_OFFSET", "YEAR_WOY", "DOW_LOCAL", "EXTENDED_YEAR", "JULIAN_DAY", "MILLISECONDS_IN_DAY"};
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_Calendar$__constructor__();
    }

    protected Calendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Calendar$__constructor__(), 0, this);
    }

    private void __constructor__(TimeZone timeZone, Locale locale) {
        this.$$robo$$android_icu_util_Calendar$__constructor__(timeZone, locale);
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        this(timeZone, ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Calendar$__constructor__(android.icu.util.TimeZone java.util.Locale ), 0, this, timeZone, locale);
    }

    private void __constructor__(TimeZone timeZone, ULocale uLocale) {
        this.$$robo$$android_icu_util_Calendar$__constructor__(timeZone, uLocale);
    }

    protected Calendar(TimeZone timeZone, ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Calendar$__constructor__(android.icu.util.TimeZone android.icu.util.ULocale ), 0, this, timeZone, uLocale);
    }

    private void setCalendarLocale(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("setCalendarLocale", $$robo$$android_icu_util_Calendar$setCalendarLocale(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void recalculateStamp() {
        InvokeDynamicSupport.bootstrap("recalculateStamp", $$robo$$android_icu_util_Calendar$recalculateStamp(), 0, this);
    }

    private void initInternal() {
        InvokeDynamicSupport.bootstrap("initInternal", $$robo$$android_icu_util_Calendar$initInternal(), 0, this);
    }

    public static Calendar getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Calendar$getInstance(), 0);
    }

    public static Calendar getInstance(TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Calendar$getInstance(android.icu.util.TimeZone ), 0, (TimeZone)timeZone);
    }

    public static Calendar getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Calendar$getInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static Calendar getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Calendar$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static Calendar getInstance(TimeZone timeZone, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Calendar$getInstance(android.icu.util.TimeZone java.util.Locale ), 0, (TimeZone)timeZone, (Locale)locale);
    }

    public static Calendar getInstance(TimeZone timeZone, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Calendar$getInstance(android.icu.util.TimeZone android.icu.util.ULocale ), 0, (TimeZone)timeZone, (ULocale)uLocale);
    }

    private static Calendar getInstanceInternal(TimeZone timeZone, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceInternal", $$robo$$android_icu_util_Calendar$getInstanceInternal(android.icu.util.TimeZone android.icu.util.ULocale ), 0, (TimeZone)timeZone, (ULocale)uLocale);
    }

    private static String getRegionForCalendar(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getRegionForCalendar", $$robo$$android_icu_util_Calendar$getRegionForCalendar(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private static CalType getCalendarTypeForLocale(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getCalendarTypeForLocale", $$robo$$android_icu_util_Calendar$getCalendarTypeForLocale(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private static Calendar createInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("createInstance", $$robo$$android_icu_util_Calendar$createInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_util_Calendar$getAvailableLocales(), 0);
    }

    public static ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_util_Calendar$getAvailableULocales(), 0);
    }

    public static String[] getKeywordValuesForLocale(String string2, ULocale uLocale, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getKeywordValuesForLocale", $$robo$$android_icu_util_Calendar$getKeywordValuesForLocale(java.lang.String android.icu.util.ULocale boolean ), 0, (String)string2, (ULocale)uLocale, (boolean)bl);
    }

    public Date getTime() {
        return InvokeDynamicSupport.bootstrap("getTime", $$robo$$android_icu_util_Calendar$getTime(), 0, this);
    }

    public void setTime(Date date) {
        InvokeDynamicSupport.bootstrap("setTime", $$robo$$android_icu_util_Calendar$setTime(java.util.Date ), 0, this, date);
    }

    public long getTimeInMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getTimeInMillis", $$robo$$android_icu_util_Calendar$getTimeInMillis(), 0, this);
    }

    public void setTimeInMillis(long l) {
        InvokeDynamicSupport.bootstrap("setTimeInMillis", $$robo$$android_icu_util_Calendar$setTimeInMillis(long ), 0, this, l);
    }

    public int get(int n) {
        return (int)InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_util_Calendar$get(int ), 0, this, n);
    }

    protected int internalGet(int n) {
        return (int)InvokeDynamicSupport.bootstrap("internalGet", $$robo$$android_icu_util_Calendar$internalGet(int ), 0, this, n);
    }

    protected int internalGet(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("internalGet", $$robo$$android_icu_util_Calendar$internalGet(int int ), 0, this, n, n2);
    }

    public void set(int n, int n2) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_util_Calendar$set(int int ), 0, this, n, n2);
    }

    public void set(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_util_Calendar$set(int int int ), 0, this, n, n2, n3);
    }

    public void set(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_util_Calendar$set(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_util_Calendar$set(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    private static int gregoYearFromIslamicStart(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("gregoYearFromIslamicStart", $$robo$$android_icu_util_Calendar$gregoYearFromIslamicStart(int ), 0, (int)n);
    }

    @Deprecated
    public int getRelatedYear() {
        return (int)InvokeDynamicSupport.bootstrap("getRelatedYear", $$robo$$android_icu_util_Calendar$getRelatedYear(), 0, this);
    }

    private static int firstIslamicStartYearFromGrego(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("firstIslamicStartYearFromGrego", $$robo$$android_icu_util_Calendar$firstIslamicStartYearFromGrego(int ), 0, (int)n);
    }

    @Deprecated
    public void setRelatedYear(int n) {
        InvokeDynamicSupport.bootstrap("setRelatedYear", $$robo$$android_icu_util_Calendar$setRelatedYear(int ), 0, this, n);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_util_Calendar$clear(), 0, this);
    }

    public void clear(int n) {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_util_Calendar$clear(int ), 0, this, n);
    }

    public boolean isSet(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSet", $$robo$$android_icu_util_Calendar$isSet(int ), 0, this, n);
    }

    protected void complete() {
        InvokeDynamicSupport.bootstrap("complete", $$robo$$android_icu_util_Calendar$complete(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_Calendar$equals(java.lang.Object ), 0, this, object);
    }

    public boolean isEquivalentTo(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEquivalentTo", $$robo$$android_icu_util_Calendar$isEquivalentTo(android.icu.util.Calendar ), 0, this, calendar);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_Calendar$hashCode(), 0, this);
    }

    private long compare(Object object) {
        return (long)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_util_Calendar$compare(java.lang.Object ), 0, this, object);
    }

    public boolean before(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("before", $$robo$$android_icu_util_Calendar$before(java.lang.Object ), 0, this, object);
    }

    public boolean after(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("after", $$robo$$android_icu_util_Calendar$after(java.lang.Object ), 0, this, object);
    }

    public int getActualMaximum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getActualMaximum", $$robo$$android_icu_util_Calendar$getActualMaximum(int ), 0, this, n);
    }

    public int getActualMinimum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getActualMinimum", $$robo$$android_icu_util_Calendar$getActualMinimum(int ), 0, this, n);
    }

    protected void prepareGetActual(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("prepareGetActual", $$robo$$android_icu_util_Calendar$prepareGetActual(int boolean ), 0, this, n, bl);
    }

    private int getActualHelper(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("getActualHelper", $$robo$$android_icu_util_Calendar$getActualHelper(int int int ), 0, this, n, n2, n3);
    }

    public void roll(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("roll", $$robo$$android_icu_util_Calendar$roll(int boolean ), 0, this, n, bl);
    }

    public void roll(int n, int n2) {
        InvokeDynamicSupport.bootstrap("roll", $$robo$$android_icu_util_Calendar$roll(int int ), 0, this, n, n2);
    }

    public void add(int n, int n2) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_Calendar$add(int int ), 0, this, n, n2);
    }

    public String getDisplayName(Locale locale) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_Calendar$getDisplayName(java.util.Locale ), 0, this, locale);
    }

    public String getDisplayName(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_Calendar$getDisplayName(android.icu.util.ULocale ), 0, this, uLocale);
    }

    @Override
    public int compareTo(Calendar calendar) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_util_Calendar$compareTo(android.icu.util.Calendar ), 0, this, calendar);
    }

    public DateFormat getDateTimeFormat(int n, int n2, Locale locale) {
        return InvokeDynamicSupport.bootstrap("getDateTimeFormat", $$robo$$android_icu_util_Calendar$getDateTimeFormat(int int java.util.Locale ), 0, this, n, n2, locale);
    }

    public DateFormat getDateTimeFormat(int n, int n2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDateTimeFormat", $$robo$$android_icu_util_Calendar$getDateTimeFormat(int int android.icu.util.ULocale ), 0, this, n, n2, uLocale);
    }

    protected DateFormat handleGetDateFormat(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrap("handleGetDateFormat", $$robo$$android_icu_util_Calendar$handleGetDateFormat(java.lang.String java.util.Locale ), 0, this, string2, locale);
    }

    protected DateFormat handleGetDateFormat(String string2, String string3, Locale locale) {
        return InvokeDynamicSupport.bootstrap("handleGetDateFormat", $$robo$$android_icu_util_Calendar$handleGetDateFormat(java.lang.String java.lang.String java.util.Locale ), 0, this, string2, string3, locale);
    }

    protected DateFormat handleGetDateFormat(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("handleGetDateFormat", $$robo$$android_icu_util_Calendar$handleGetDateFormat(java.lang.String android.icu.util.ULocale ), 0, this, string2, uLocale);
    }

    protected DateFormat handleGetDateFormat(String string2, String string3, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("handleGetDateFormat", $$robo$$android_icu_util_Calendar$handleGetDateFormat(java.lang.String java.lang.String android.icu.util.ULocale ), 0, this, string2, string3, uLocale);
    }

    private static DateFormat formatHelper(Calendar calendar, ULocale uLocale, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("formatHelper", $$robo$$android_icu_util_Calendar$formatHelper(android.icu.util.Calendar android.icu.util.ULocale int int ), 0, (Calendar)calendar, (ULocale)uLocale, (int)n, (int)n2);
    }

    public static String getDateTimeFormatString(ULocale uLocale, String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getDateTimeFormatString", $$robo$$android_icu_util_Calendar$getDateTimeFormatString(android.icu.util.ULocale java.lang.String int int ), 0, (ULocale)uLocale, (String)string2, (int)n, (int)n2);
    }

    private static PatternData getPatternData(ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getPatternData", $$robo$$android_icu_util_Calendar$getPatternData(android.icu.util.ULocale java.lang.String ), 0, (ULocale)uLocale, (String)string2);
    }

    @Deprecated
    public static String getDateTimePattern(Calendar calendar, ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDateTimePattern", $$robo$$android_icu_util_Calendar$getDateTimePattern(android.icu.util.Calendar android.icu.util.ULocale int ), 0, (Calendar)calendar, (ULocale)uLocale, (int)n);
    }

    private static String mergeOverrideStrings(String string2, String string3, String string4, String string5) {
        return InvokeDynamicSupport.bootstrapStatic("mergeOverrideStrings", $$robo$$android_icu_util_Calendar$mergeOverrideStrings(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    private static String expandOverride(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("expandOverride", $$robo$$android_icu_util_Calendar$expandOverride(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    protected void pinField(int n) {
        InvokeDynamicSupport.bootstrap("pinField", $$robo$$android_icu_util_Calendar$pinField(int ), 0, this, n);
    }

    protected int weekNumber(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("weekNumber", $$robo$$android_icu_util_Calendar$weekNumber(int int int ), 0, this, n, n2, n3);
    }

    protected int weekNumber(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("weekNumber", $$robo$$android_icu_util_Calendar$weekNumber(int int ), 0, this, n, n2);
    }

    public int fieldDifference(Date date, int n) {
        return (int)InvokeDynamicSupport.bootstrap("fieldDifference", $$robo$$android_icu_util_Calendar$fieldDifference(java.util.Date int ), 0, this, date, n);
    }

    public void setTimeZone(TimeZone timeZone) {
        InvokeDynamicSupport.bootstrap("setTimeZone", $$robo$$android_icu_util_Calendar$setTimeZone(android.icu.util.TimeZone ), 0, this, timeZone);
    }

    public TimeZone getTimeZone() {
        return InvokeDynamicSupport.bootstrap("getTimeZone", $$robo$$android_icu_util_Calendar$getTimeZone(), 0, this);
    }

    public void setLenient(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLenient", $$robo$$android_icu_util_Calendar$setLenient(boolean ), 0, this, bl);
    }

    public boolean isLenient() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLenient", $$robo$$android_icu_util_Calendar$isLenient(), 0, this);
    }

    public void setRepeatedWallTimeOption(int n) {
        InvokeDynamicSupport.bootstrap("setRepeatedWallTimeOption", $$robo$$android_icu_util_Calendar$setRepeatedWallTimeOption(int ), 0, this, n);
    }

    public int getRepeatedWallTimeOption() {
        return (int)InvokeDynamicSupport.bootstrap("getRepeatedWallTimeOption", $$robo$$android_icu_util_Calendar$getRepeatedWallTimeOption(), 0, this);
    }

    public void setSkippedWallTimeOption(int n) {
        InvokeDynamicSupport.bootstrap("setSkippedWallTimeOption", $$robo$$android_icu_util_Calendar$setSkippedWallTimeOption(int ), 0, this, n);
    }

    public int getSkippedWallTimeOption() {
        return (int)InvokeDynamicSupport.bootstrap("getSkippedWallTimeOption", $$robo$$android_icu_util_Calendar$getSkippedWallTimeOption(), 0, this);
    }

    public void setFirstDayOfWeek(int n) {
        InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_icu_util_Calendar$setFirstDayOfWeek(int ), 0, this, n);
    }

    public int getFirstDayOfWeek() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfWeek", $$robo$$android_icu_util_Calendar$getFirstDayOfWeek(), 0, this);
    }

    public void setMinimalDaysInFirstWeek(int n) {
        InvokeDynamicSupport.bootstrap("setMinimalDaysInFirstWeek", $$robo$$android_icu_util_Calendar$setMinimalDaysInFirstWeek(int ), 0, this, n);
    }

    public int getMinimalDaysInFirstWeek() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimalDaysInFirstWeek", $$robo$$android_icu_util_Calendar$getMinimalDaysInFirstWeek(), 0, this);
    }

    protected int getLimit(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getLimit", $$robo$$android_icu_util_Calendar$getLimit(int int ), 0, this, n, n2);
    }

    public int getMinimum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMinimum", $$robo$$android_icu_util_Calendar$getMinimum(int ), 0, this, n);
    }

    public int getMaximum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMaximum", $$robo$$android_icu_util_Calendar$getMaximum(int ), 0, this, n);
    }

    public int getGreatestMinimum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getGreatestMinimum", $$robo$$android_icu_util_Calendar$getGreatestMinimum(int ), 0, this, n);
    }

    public int getLeastMaximum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLeastMaximum", $$robo$$android_icu_util_Calendar$getLeastMaximum(int ), 0, this, n);
    }

    @Deprecated
    public int getDayOfWeekType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDayOfWeekType", $$robo$$android_icu_util_Calendar$getDayOfWeekType(int ), 0, this, n);
    }

    @Deprecated
    public int getWeekendTransition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getWeekendTransition", $$robo$$android_icu_util_Calendar$getWeekendTransition(int ), 0, this, n);
    }

    public boolean isWeekend(Date date) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWeekend", $$robo$$android_icu_util_Calendar$isWeekend(java.util.Date ), 0, this, date);
    }

    public boolean isWeekend() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWeekend", $$robo$$android_icu_util_Calendar$isWeekend(), 0, this);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_util_Calendar$clone(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_Calendar$toString(), 0, this);
    }

    public static WeekData getWeekDataForRegion(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getWeekDataForRegion", $$robo$$android_icu_util_Calendar$getWeekDataForRegion(java.lang.String ), 0, (String)string2);
    }

    public WeekData getWeekData() {
        return InvokeDynamicSupport.bootstrap("getWeekData", $$robo$$android_icu_util_Calendar$getWeekData(), 0, this);
    }

    public Calendar setWeekData(WeekData weekData) {
        return InvokeDynamicSupport.bootstrap("setWeekData", $$robo$$android_icu_util_Calendar$setWeekData(android.icu.util.Calendar$WeekData ), 0, this, weekData);
    }

    private static WeekData getWeekDataForRegionInternal(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getWeekDataForRegionInternal", $$robo$$android_icu_util_Calendar$getWeekDataForRegionInternal(java.lang.String ), 0, (String)string2);
    }

    private void setWeekData(String string2) {
        InvokeDynamicSupport.bootstrap("setWeekData", $$robo$$android_icu_util_Calendar$setWeekData(java.lang.String ), 0, this, string2);
    }

    private void updateTime() {
        InvokeDynamicSupport.bootstrap("updateTime", $$robo$$android_icu_util_Calendar$updateTime(), 0, this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_util_Calendar$writeObject(java.io.ObjectOutputStream ), 0, this, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_util_Calendar$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    protected void computeFields() {
        InvokeDynamicSupport.bootstrap("computeFields", $$robo$$android_icu_util_Calendar$computeFields(), 0, this);
    }

    private void computeGregorianAndDOWFields(int n) {
        InvokeDynamicSupport.bootstrap("computeGregorianAndDOWFields", $$robo$$android_icu_util_Calendar$computeGregorianAndDOWFields(int ), 0, this, n);
    }

    protected void computeGregorianFields(int n) {
        InvokeDynamicSupport.bootstrap("computeGregorianFields", $$robo$$android_icu_util_Calendar$computeGregorianFields(int ), 0, this, n);
    }

    private void computeWeekFields() {
        InvokeDynamicSupport.bootstrap("computeWeekFields", $$robo$$android_icu_util_Calendar$computeWeekFields(), 0, this);
    }

    protected int resolveFields(int[][][] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("resolveFields", $$robo$$android_icu_util_Calendar$resolveFields(int[][][] ), 0, this, nArray);
    }

    protected int newestStamp(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("newestStamp", $$robo$$android_icu_util_Calendar$newestStamp(int int int ), 0, this, n, n2, n3);
    }

    protected int getStamp(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStamp", $$robo$$android_icu_util_Calendar$getStamp(int ), 0, this, n);
    }

    protected int newerField(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("newerField", $$robo$$android_icu_util_Calendar$newerField(int int ), 0, this, n, n2);
    }

    protected void validateFields() {
        InvokeDynamicSupport.bootstrap("validateFields", $$robo$$android_icu_util_Calendar$validateFields(), 0, this);
    }

    protected void validateField(int n) {
        InvokeDynamicSupport.bootstrap("validateField", $$robo$$android_icu_util_Calendar$validateField(int ), 0, this, n);
    }

    protected void validateField(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("validateField", $$robo$$android_icu_util_Calendar$validateField(int int int ), 0, this, n, n2, n3);
    }

    protected void computeTime() {
        InvokeDynamicSupport.bootstrap("computeTime", $$robo$$android_icu_util_Calendar$computeTime(), 0, this);
    }

    private Long getImmediatePreviousZoneTransition(long l) {
        return InvokeDynamicSupport.bootstrap("getImmediatePreviousZoneTransition", $$robo$$android_icu_util_Calendar$getImmediatePreviousZoneTransition(long ), 0, this, l);
    }

    private static Long getPreviousZoneTransitionTime(TimeZone timeZone, long l, long l2) {
        return InvokeDynamicSupport.bootstrapStatic("getPreviousZoneTransitionTime", $$robo$$android_icu_util_Calendar$getPreviousZoneTransitionTime(android.icu.util.TimeZone long long ), 0, (TimeZone)timeZone, (long)l, (long)l2);
    }

    private static Long findPreviousZoneTransitionTime(TimeZone timeZone, int n, long l, long l2) {
        return InvokeDynamicSupport.bootstrapStatic("findPreviousZoneTransitionTime", $$robo$$android_icu_util_Calendar$findPreviousZoneTransitionTime(android.icu.util.TimeZone int long long ), 0, (TimeZone)timeZone, (int)n, (long)l, (long)l2);
    }

    protected int computeMillisInDay() {
        return (int)InvokeDynamicSupport.bootstrap("computeMillisInDay", $$robo$$android_icu_util_Calendar$computeMillisInDay(), 0, this);
    }

    protected int computeZoneOffset(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrap("computeZoneOffset", $$robo$$android_icu_util_Calendar$computeZoneOffset(long int ), 0, this, l, n);
    }

    protected int computeJulianDay() {
        return (int)InvokeDynamicSupport.bootstrap("computeJulianDay", $$robo$$android_icu_util_Calendar$computeJulianDay(), 0, this);
    }

    protected int[][][] getFieldResolutionTable() {
        return InvokeDynamicSupport.bootstrap("getFieldResolutionTable", $$robo$$android_icu_util_Calendar$getFieldResolutionTable(), 0, this);
    }

    protected int handleGetMonthLength(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetMonthLength", $$robo$$android_icu_util_Calendar$handleGetMonthLength(int int ), 0, this, n, n2);
    }

    protected int handleGetYearLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetYearLength", $$robo$$android_icu_util_Calendar$handleGetYearLength(int ), 0, this, n);
    }

    protected int[] handleCreateFields() {
        return InvokeDynamicSupport.bootstrap("handleCreateFields", $$robo$$android_icu_util_Calendar$handleCreateFields(), 0, this);
    }

    protected int getDefaultMonthInYear(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultMonthInYear", $$robo$$android_icu_util_Calendar$getDefaultMonthInYear(int ), 0, this, n);
    }

    protected int getDefaultDayInMonth(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultDayInMonth", $$robo$$android_icu_util_Calendar$getDefaultDayInMonth(int int ), 0, this, n, n2);
    }

    protected int handleComputeJulianDay(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handleComputeJulianDay", $$robo$$android_icu_util_Calendar$handleComputeJulianDay(int ), 0, this, n);
    }

    protected int computeGregorianMonthStart(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("computeGregorianMonthStart", $$robo$$android_icu_util_Calendar$computeGregorianMonthStart(int int ), 0, this, n, n2);
    }

    protected void handleComputeFields(int n) {
        InvokeDynamicSupport.bootstrap("handleComputeFields", $$robo$$android_icu_util_Calendar$handleComputeFields(int ), 0, this, n);
    }

    protected int getGregorianYear() {
        return (int)InvokeDynamicSupport.bootstrap("getGregorianYear", $$robo$$android_icu_util_Calendar$getGregorianYear(), 0, this);
    }

    protected int getGregorianMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getGregorianMonth", $$robo$$android_icu_util_Calendar$getGregorianMonth(), 0, this);
    }

    protected int getGregorianDayOfYear() {
        return (int)InvokeDynamicSupport.bootstrap("getGregorianDayOfYear", $$robo$$android_icu_util_Calendar$getGregorianDayOfYear(), 0, this);
    }

    protected int getGregorianDayOfMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getGregorianDayOfMonth", $$robo$$android_icu_util_Calendar$getGregorianDayOfMonth(), 0, this);
    }

    public int getFieldCount() {
        return (int)InvokeDynamicSupport.bootstrap("getFieldCount", $$robo$$android_icu_util_Calendar$getFieldCount(), 0, this);
    }

    protected void internalSet(int n, int n2) {
        InvokeDynamicSupport.bootstrap("internalSet", $$robo$$android_icu_util_Calendar$internalSet(int int ), 0, this, n, n2);
    }

    protected static boolean isGregorianLeapYear(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGregorianLeapYear", $$robo$$android_icu_util_Calendar$isGregorianLeapYear(int ), 0, (int)n);
    }

    protected static int gregorianMonthLength(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("gregorianMonthLength", $$robo$$android_icu_util_Calendar$gregorianMonthLength(int int ), 0, (int)n, (int)n2);
    }

    protected static int gregorianPreviousMonthLength(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("gregorianPreviousMonthLength", $$robo$$android_icu_util_Calendar$gregorianPreviousMonthLength(int int ), 0, (int)n, (int)n2);
    }

    protected static long floorDivide(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("floorDivide", $$robo$$android_icu_util_Calendar$floorDivide(long long ), 0, (long)l, (long)l2);
    }

    protected static int floorDivide(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("floorDivide", $$robo$$android_icu_util_Calendar$floorDivide(int int ), 0, (int)n, (int)n2);
    }

    protected static int floorDivide(int n, int n2, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("floorDivide", $$robo$$android_icu_util_Calendar$floorDivide(int int int[] ), 0, (int)n, (int)n2, (int[])nArray);
    }

    protected static int floorDivide(long l, int n, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("floorDivide", $$robo$$android_icu_util_Calendar$floorDivide(long int int[] ), 0, (long)l, (int)n, (int[])nArray);
    }

    protected String fieldName(int n) {
        return InvokeDynamicSupport.bootstrap("fieldName", $$robo$$android_icu_util_Calendar$fieldName(int ), 0, this, n);
    }

    protected static int millisToJulianDay(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("millisToJulianDay", $$robo$$android_icu_util_Calendar$millisToJulianDay(long ), 0, (long)l);
    }

    protected static long julianDayToMillis(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("julianDayToMillis", $$robo$$android_icu_util_Calendar$julianDayToMillis(int ), 0, (int)n);
    }

    protected static int julianDayToDayOfWeek(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("julianDayToDayOfWeek", $$robo$$android_icu_util_Calendar$julianDayToDayOfWeek(int ), 0, (int)n);
    }

    protected long internalGetTimeInMillis() {
        return (long)InvokeDynamicSupport.bootstrap("internalGetTimeInMillis", $$robo$$android_icu_util_Calendar$internalGetTimeInMillis(), 0, this);
    }

    public String getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_util_Calendar$getType(), 0, this);
    }

    @Deprecated
    public boolean haveDefaultCentury() {
        return (boolean)InvokeDynamicSupport.bootstrap("haveDefaultCentury", $$robo$$android_icu_util_Calendar$haveDefaultCentury(), 0, this);
    }

    public ULocale getLocale(ULocale.Type type) {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_util_Calendar$getLocale(android.icu.util.ULocale$Type ), 0, this, type);
    }

    void setLocale(ULocale uLocale, ULocale uLocale2) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_util_Calendar$setLocale(android.icu.util.ULocale android.icu.util.ULocale ), 0, this, uLocale, uLocale2);
    }

    static {
        RobolectricInternals.classInitializing(Calendar.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Calendar)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class WeekDataCache
    extends SoftCache<String, WeekData, String> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_util_Calendar_WeekDataCache$__constructor__() {
        }

        private final WeekData $$robo$$android_icu_util_Calendar_WeekDataCache$createInstance(String key, String data) {
            return Calendar.getWeekDataForRegionInternal(key);
        }

        private /* synthetic */ void $$robo$$android_icu_util_Calendar_WeekDataCache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_Calendar_WeekDataCache$__constructor__();
        }

        private WeekDataCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Calendar_WeekDataCache$__constructor__(), 0, this);
        }

        @Override
        protected WeekData createInstance(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_util_Calendar_WeekDataCache$createInstance(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_util_Calendar_WeekDataCache$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WeekDataCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class WeekData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int firstDayOfWeek;
        public int minimalDaysInFirstWeek;
        public int weekendOnset;
        public int weekendOnsetMillis;
        public int weekendCease;
        public int weekendCeaseMillis;

        private void $$robo$$android_icu_util_Calendar_WeekData$__constructor__(int fdow, int mdifw, int weekendOnset, int weekendOnsetMillis, int weekendCease, int weekendCeaseMillis) {
            this.firstDayOfWeek = fdow;
            this.minimalDaysInFirstWeek = mdifw;
            this.weekendOnset = weekendOnset;
            this.weekendOnsetMillis = weekendOnsetMillis;
            this.weekendCease = weekendCease;
            this.weekendCeaseMillis = weekendCeaseMillis;
        }

        private final int $$robo$$android_icu_util_Calendar_WeekData$hashCode() {
            return ((((this.firstDayOfWeek * 37 + this.minimalDaysInFirstWeek) * 37 + this.weekendOnset) * 37 + this.weekendOnsetMillis) * 37 + this.weekendCease) * 37 + this.weekendCeaseMillis;
        }

        private final boolean $$robo$$android_icu_util_Calendar_WeekData$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WeekData)) {
                return false;
            }
            WeekData that = (WeekData)other;
            return this.firstDayOfWeek == that.firstDayOfWeek && this.minimalDaysInFirstWeek == that.minimalDaysInFirstWeek && this.weekendOnset == that.weekendOnset && this.weekendOnsetMillis == that.weekendOnsetMillis && this.weekendCease == that.weekendCease && this.weekendCeaseMillis == that.weekendCeaseMillis;
        }

        private final String $$robo$$android_icu_util_Calendar_WeekData$toString() {
            return "{" + this.firstDayOfWeek + ", " + this.minimalDaysInFirstWeek + ", " + this.weekendOnset + ", " + this.weekendOnsetMillis + ", " + this.weekendCease + ", " + this.weekendCeaseMillis + "}";
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6) {
            this.$$robo$$android_icu_util_Calendar_WeekData$__constructor__(n, n2, n3, n4, n5, n6);
        }

        public WeekData(int n, int n2, int n3, int n4, int n5, int n6) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Calendar_WeekData$__constructor__(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_Calendar_WeekData$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_Calendar_WeekData$equals(java.lang.Object ), 0, this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_Calendar_WeekData$toString(), 0, this);
        }

        public /* synthetic */ WeekData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WeekData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class FormatConfiguration
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String pattern;
        private String override;
        private DateFormatSymbols formatData;
        private Calendar cal;
        private ULocale loc;

        private void $$robo$$android_icu_util_Calendar_FormatConfiguration$__constructor__() {
        }

        @Deprecated
        private final String $$robo$$android_icu_util_Calendar_FormatConfiguration$getPatternString() {
            return this.pattern;
        }

        @Deprecated
        private final String $$robo$$android_icu_util_Calendar_FormatConfiguration$getOverrideString() {
            return this.override;
        }

        @Deprecated
        private final Calendar $$robo$$android_icu_util_Calendar_FormatConfiguration$getCalendar() {
            return this.cal;
        }

        @Deprecated
        private final ULocale $$robo$$android_icu_util_Calendar_FormatConfiguration$getLocale() {
            return this.loc;
        }

        @Deprecated
        private final DateFormatSymbols $$robo$$android_icu_util_Calendar_FormatConfiguration$getDateFormatSymbols() {
            return this.formatData;
        }

        private /* synthetic */ void $$robo$$android_icu_util_Calendar_FormatConfiguration$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_Calendar_FormatConfiguration$__constructor__();
        }

        private FormatConfiguration() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Calendar_FormatConfiguration$__constructor__(), 0, this);
        }

        @Deprecated
        public String getPatternString() {
            return InvokeDynamicSupport.bootstrap("getPatternString", $$robo$$android_icu_util_Calendar_FormatConfiguration$getPatternString(), 0, this);
        }

        @Deprecated
        public String getOverrideString() {
            return InvokeDynamicSupport.bootstrap("getOverrideString", $$robo$$android_icu_util_Calendar_FormatConfiguration$getOverrideString(), 0, this);
        }

        @Deprecated
        public Calendar getCalendar() {
            return InvokeDynamicSupport.bootstrap("getCalendar", $$robo$$android_icu_util_Calendar_FormatConfiguration$getCalendar(), 0, this);
        }

        @Deprecated
        public ULocale getLocale() {
            return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_util_Calendar_FormatConfiguration$getLocale(), 0, this);
        }

        @Deprecated
        public DateFormatSymbols getDateFormatSymbols() {
            return InvokeDynamicSupport.bootstrap("getDateFormatSymbols", $$robo$$android_icu_util_Calendar_FormatConfiguration$getDateFormatSymbols(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_util_Calendar_FormatConfiguration$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FormatConfiguration)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PatternData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String[] patterns;
        private String[] overrides;

        private void $$robo$$android_icu_util_Calendar_PatternData$__constructor__(String[] patterns, String[] overrides) {
            this.patterns = patterns;
            this.overrides = overrides;
        }

        private final String $$robo$$android_icu_util_Calendar_PatternData$getDateTimePattern(int dateStyle) {
            int glueIndex = 8;
            if (this.patterns.length >= 13) {
                glueIndex += dateStyle + 1;
            }
            String dateTimePattern = this.patterns[glueIndex];
            return dateTimePattern;
        }

        private static final PatternData $$robo$$android_icu_util_Calendar_PatternData$make(Calendar cal, ULocale loc) {
            return PatternData.make(loc, cal.getType());
        }

        private static final PatternData $$robo$$android_icu_util_Calendar_PatternData$make(ULocale loc, String calType) {
            String key = loc.getBaseName() + "+" + calType;
            PatternData patternData = (PatternData)PATTERN_CACHE.get(key);
            if (patternData == null) {
                try {
                    patternData = Calendar.getPatternData(loc, calType);
                }
                catch (MissingResourceException e) {
                    patternData = new PatternData(DEFAULT_PATTERNS, null);
                }
                PATTERN_CACHE.put(key, patternData);
            }
            return patternData;
        }

        private void __constructor__(String[] stringArray, String[] stringArray2) {
            this.$$robo$$android_icu_util_Calendar_PatternData$__constructor__(stringArray, stringArray2);
        }

        public PatternData(String[] stringArray, String[] stringArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Calendar_PatternData$__constructor__(java.lang.String[] java.lang.String[] ), 0, this, stringArray, stringArray2);
        }

        private String getDateTimePattern(int n) {
            return InvokeDynamicSupport.bootstrap("getDateTimePattern", $$robo$$android_icu_util_Calendar_PatternData$getDateTimePattern(int ), 0, this, n);
        }

        private static PatternData make(Calendar calendar, ULocale uLocale) {
            return InvokeDynamicSupport.bootstrapStatic("make", $$robo$$android_icu_util_Calendar_PatternData$make(android.icu.util.Calendar android.icu.util.ULocale ), 0, (Calendar)calendar, (ULocale)uLocale);
        }

        private static PatternData make(ULocale uLocale, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("make", $$robo$$android_icu_util_Calendar_PatternData$make(android.icu.util.ULocale java.lang.String ), 0, (ULocale)uLocale, (String)string2);
        }

        public /* synthetic */ PatternData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CalType
    extends Enum<CalType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ CalType GREGORIAN;
        public static /* enum */ CalType ISO8601;
        public static /* enum */ CalType BUDDHIST;
        public static /* enum */ CalType CHINESE;
        public static /* enum */ CalType COPTIC;
        public static /* enum */ CalType DANGI;
        public static /* enum */ CalType ETHIOPIC;
        public static /* enum */ CalType ETHIOPIC_AMETE_ALEM;
        public static /* enum */ CalType HEBREW;
        public static /* enum */ CalType INDIAN;
        public static /* enum */ CalType ISLAMIC;
        public static /* enum */ CalType ISLAMIC_CIVIL;
        public static /* enum */ CalType ISLAMIC_RGSA;
        public static /* enum */ CalType ISLAMIC_TBLA;
        public static /* enum */ CalType ISLAMIC_UMALQURA;
        public static /* enum */ CalType JAPANESE;
        public static /* enum */ CalType PERSIAN;
        public static /* enum */ CalType ROC;
        public static /* enum */ CalType UNKNOWN;
        String id;
        private static /* synthetic */ CalType[] $VALUES;

        private static final CalType[] $$robo$$android_icu_util_Calendar_CalType$values() {
            return (CalType[])$VALUES.clone();
        }

        private static final CalType $$robo$$android_icu_util_Calendar_CalType$valueOf(String name) {
            return Enum.valueOf(CalType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_Calendar_CalType$__constructor__(String string2, int n, String id2) {
            this.id = id2;
        }

        static void __staticInitializer__() {
            GREGORIAN = new CalType("gregorian");
            ISO8601 = new CalType("iso8601");
            BUDDHIST = new CalType("buddhist");
            CHINESE = new CalType("chinese");
            COPTIC = new CalType("coptic");
            DANGI = new CalType("dangi");
            ETHIOPIC = new CalType("ethiopic");
            ETHIOPIC_AMETE_ALEM = new CalType("ethiopic-amete-alem");
            HEBREW = new CalType("hebrew");
            INDIAN = new CalType("indian");
            ISLAMIC = new CalType("islamic");
            ISLAMIC_CIVIL = new CalType("islamic-civil");
            ISLAMIC_RGSA = new CalType("islamic-rgsa");
            ISLAMIC_TBLA = new CalType("islamic-tbla");
            ISLAMIC_UMALQURA = new CalType("islamic-umalqura");
            JAPANESE = new CalType("japanese");
            PERSIAN = new CalType("persian");
            ROC = new CalType("roc");
            UNKNOWN = new CalType("unknown");
            $VALUES = new CalType[]{GREGORIAN, ISO8601, BUDDHIST, CHINESE, COPTIC, DANGI, ETHIOPIC, ETHIOPIC_AMETE_ALEM, HEBREW, INDIAN, ISLAMIC, ISLAMIC_CIVIL, ISLAMIC_RGSA, ISLAMIC_TBLA, ISLAMIC_UMALQURA, JAPANESE, PERSIAN, ROC, UNKNOWN};
        }

        public static CalType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_Calendar_CalType$values(), 0);
        }

        public static CalType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_Calendar_CalType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, String string3) {
            this.$$robo$$android_icu_util_Calendar_CalType$__constructor__(string2, n, string3);
        }

        private CalType(String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Calendar_CalType$__constructor__(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
        }

        static {
            RobolectricInternals.classInitializing(CalType.class);
        }

        public /* synthetic */ CalType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

