/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.text.UTF16;
import android.icu.text.UnicodeSet;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class StringTokenizer
implements Enumeration<Object> {
    public transient /* synthetic */ Object __robo_data__;
    private int m_tokenOffset_;
    private int m_tokenSize_;
    private int[] m_tokenStart_;
    private int[] m_tokenLimit_;
    private UnicodeSet m_delimiters_;
    private String m_source_;
    private int m_length_;
    private int m_nextOffset_;
    private boolean m_returnDelimiters_;
    private boolean m_coalesceDelimiters_;
    private static UnicodeSet DEFAULT_DELIMITERS_;
    private static int TOKEN_SIZE_ = 100;
    private static UnicodeSet EMPTY_DELIMITER_;
    private boolean[] delims;

    private void $$robo$$android_icu_util_StringTokenizer$__constructor__(String str, UnicodeSet delim, boolean returndelims) {
    }

    @Deprecated
    private void $$robo$$android_icu_util_StringTokenizer$__constructor__(String str, UnicodeSet delim, boolean returndelims, boolean coalescedelims) {
        this.m_source_ = str;
        this.m_length_ = str.length();
        this.m_delimiters_ = delim == null ? EMPTY_DELIMITER_ : delim;
        this.m_returnDelimiters_ = returndelims;
        this.m_coalesceDelimiters_ = coalescedelims;
        this.m_tokenOffset_ = -1;
        this.m_tokenSize_ = -1;
        if (this.m_length_ == 0) {
            this.m_nextOffset_ = -1;
        } else {
            this.m_nextOffset_ = 0;
            if (!returndelims) {
                this.m_nextOffset_ = this.getNextNonDelimiter(0);
            }
        }
    }

    private void $$robo$$android_icu_util_StringTokenizer$__constructor__(String str, UnicodeSet delim) {
    }

    private void $$robo$$android_icu_util_StringTokenizer$__constructor__(String str, String delim, boolean returndelims) {
    }

    @Deprecated
    private void $$robo$$android_icu_util_StringTokenizer$__constructor__(String str, String delim, boolean returndelims, boolean coalescedelims) {
        this.m_delimiters_ = EMPTY_DELIMITER_;
        if (delim != null && delim.length() > 0) {
            this.m_delimiters_ = new UnicodeSet();
            this.m_delimiters_.addAll(delim);
            this.checkDelimiters();
        }
        this.m_coalesceDelimiters_ = coalescedelims;
        this.m_source_ = str;
        this.m_length_ = str.length();
        this.m_returnDelimiters_ = returndelims;
        this.m_tokenOffset_ = -1;
        this.m_tokenSize_ = -1;
        if (this.m_length_ == 0) {
            this.m_nextOffset_ = -1;
        } else {
            this.m_nextOffset_ = 0;
            if (!returndelims) {
                this.m_nextOffset_ = this.getNextNonDelimiter(0);
            }
        }
    }

    private void $$robo$$android_icu_util_StringTokenizer$__constructor__(String str, String delim) {
    }

    private void $$robo$$android_icu_util_StringTokenizer$__constructor__(String str) {
    }

    private final boolean $$robo$$android_icu_util_StringTokenizer$hasMoreTokens() {
        return this.m_nextOffset_ >= 0;
    }

    private final String $$robo$$android_icu_util_StringTokenizer$nextToken() {
        if (this.m_tokenOffset_ < 0) {
            String result;
            if (this.m_nextOffset_ < 0) {
                throw new NoSuchElementException("No more tokens in String");
            }
            if (this.m_returnDelimiters_) {
                boolean contains;
                int tokenlimit = 0;
                int c = UTF16.charAt(this.m_source_, this.m_nextOffset_);
                boolean bl = this.delims == null ? this.m_delimiters_.contains(c) : (contains = c < this.delims.length && this.delims[c]);
                if (contains) {
                    if (this.m_coalesceDelimiters_) {
                        tokenlimit = this.getNextNonDelimiter(this.m_nextOffset_);
                    } else {
                        tokenlimit = this.m_nextOffset_ + UTF16.getCharCount(c);
                        if (tokenlimit == this.m_length_) {
                            tokenlimit = -1;
                        }
                    }
                } else {
                    tokenlimit = this.getNextDelimiter(this.m_nextOffset_);
                }
                String result2 = tokenlimit < 0 ? this.m_source_.substring(this.m_nextOffset_) : this.m_source_.substring(this.m_nextOffset_, tokenlimit);
                this.m_nextOffset_ = tokenlimit;
                return result2;
            }
            int tokenlimit = this.getNextDelimiter(this.m_nextOffset_);
            if (tokenlimit < 0) {
                result = this.m_source_.substring(this.m_nextOffset_);
                this.m_nextOffset_ = tokenlimit;
            } else {
                result = this.m_source_.substring(this.m_nextOffset_, tokenlimit);
                this.m_nextOffset_ = this.getNextNonDelimiter(tokenlimit);
            }
            return result;
        }
        if (this.m_tokenOffset_ >= this.m_tokenSize_) {
            throw new NoSuchElementException("No more tokens in String");
        }
        String result = this.m_tokenLimit_[this.m_tokenOffset_] >= 0 ? this.m_source_.substring(this.m_tokenStart_[this.m_tokenOffset_], this.m_tokenLimit_[this.m_tokenOffset_]) : this.m_source_.substring(this.m_tokenStart_[this.m_tokenOffset_]);
        ++this.m_tokenOffset_;
        this.m_nextOffset_ = -1;
        if (this.m_tokenOffset_ < this.m_tokenSize_) {
            this.m_nextOffset_ = this.m_tokenStart_[this.m_tokenOffset_];
        }
        return result;
    }

    private final String $$robo$$android_icu_util_StringTokenizer$nextToken(String delim) {
        this.m_delimiters_ = EMPTY_DELIMITER_;
        if (delim != null && delim.length() > 0) {
            this.m_delimiters_ = new UnicodeSet();
            this.m_delimiters_.addAll(delim);
        }
        return this.nextToken(this.m_delimiters_);
    }

    private final String $$robo$$android_icu_util_StringTokenizer$nextToken(UnicodeSet delim) {
        this.m_delimiters_ = delim;
        this.checkDelimiters();
        this.m_tokenOffset_ = -1;
        this.m_tokenSize_ = -1;
        if (!this.m_returnDelimiters_) {
            this.m_nextOffset_ = this.getNextNonDelimiter(this.m_nextOffset_);
        }
        return this.nextToken();
    }

    private final boolean $$robo$$android_icu_util_StringTokenizer$hasMoreElements() {
        return this.hasMoreTokens();
    }

    private final Object $$robo$$android_icu_util_StringTokenizer$nextElement() {
        return this.nextToken();
    }

    private final int $$robo$$android_icu_util_StringTokenizer$countTokens() {
        int result = 0;
        if (this.hasMoreTokens()) {
            if (this.m_tokenOffset_ >= 0) {
                return this.m_tokenSize_ - this.m_tokenOffset_;
            }
            if (this.m_tokenStart_ == null) {
                this.m_tokenStart_ = new int[100];
                this.m_tokenLimit_ = new int[100];
            }
            do {
                if (this.m_tokenStart_.length == result) {
                    int[] temptokenindex = this.m_tokenStart_;
                    int[] temptokensize = this.m_tokenLimit_;
                    int originalsize = temptokenindex.length;
                    int newsize = originalsize + 100;
                    this.m_tokenStart_ = new int[newsize];
                    this.m_tokenLimit_ = new int[newsize];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])temptokenindex, (int)0, (int[])this.m_tokenStart_, (int)0, (int)originalsize);
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])temptokensize, (int)0, (int[])this.m_tokenLimit_, (int)0, (int)originalsize);
                }
                this.m_tokenStart_[result] = this.m_nextOffset_;
                if (this.m_returnDelimiters_) {
                    boolean contains;
                    int c = UTF16.charAt(this.m_source_, this.m_nextOffset_);
                    boolean bl = this.delims == null ? this.m_delimiters_.contains(c) : (contains = c < this.delims.length && this.delims[c]);
                    if (contains) {
                        if (this.m_coalesceDelimiters_) {
                            this.m_tokenLimit_[result] = this.getNextNonDelimiter(this.m_nextOffset_);
                        } else {
                            int p = this.m_nextOffset_ + 1;
                            if (p == this.m_length_) {
                                p = -1;
                            }
                            this.m_tokenLimit_[result] = p;
                        }
                    } else {
                        this.m_tokenLimit_[result] = this.getNextDelimiter(this.m_nextOffset_);
                    }
                    this.m_nextOffset_ = this.m_tokenLimit_[result];
                } else {
                    this.m_tokenLimit_[result] = this.getNextDelimiter(this.m_nextOffset_);
                    this.m_nextOffset_ = this.getNextNonDelimiter(this.m_tokenLimit_[result]);
                }
                ++result;
            } while (this.m_nextOffset_ >= 0);
            this.m_tokenOffset_ = 0;
            this.m_tokenSize_ = result;
            this.m_nextOffset_ = this.m_tokenStart_[0];
        }
        return result;
    }

    private final int $$robo$$android_icu_util_StringTokenizer$getNextDelimiter(int offset) {
        if (offset >= 0) {
            int result = offset;
            int c = 0;
            if (this.delims == null) {
                while (!this.m_delimiters_.contains(c = UTF16.charAt(this.m_source_, result)) && ++result < this.m_length_) {
                }
            } else {
                while (!((c = UTF16.charAt(this.m_source_, result)) < this.delims.length && this.delims[c] || ++result >= this.m_length_)) {
                }
            }
            if (result < this.m_length_) {
                return result;
            }
        }
        return -1 - this.m_length_;
    }

    private final int $$robo$$android_icu_util_StringTokenizer$getNextNonDelimiter(int offset) {
        if (offset >= 0) {
            int result = offset;
            int c = 0;
            if (this.delims == null) {
                while (this.m_delimiters_.contains(c = UTF16.charAt(this.m_source_, result)) && ++result < this.m_length_) {
                }
            } else {
                while ((c = UTF16.charAt(this.m_source_, result)) < this.delims.length && this.delims[c] && ++result < this.m_length_) {
                }
            }
            if (result < this.m_length_) {
                return result;
            }
        }
        return -1 - this.m_length_;
    }

    private final void $$robo$$android_icu_util_StringTokenizer$checkDelimiters() {
        if (this.m_delimiters_ == null || this.m_delimiters_.size() == 0) {
            this.delims = new boolean[0];
        } else {
            int maxChar = this.m_delimiters_.getRangeEnd(this.m_delimiters_.getRangeCount() - 1);
            if (maxChar < 127) {
                int ch;
                this.delims = new boolean[maxChar + 1];
                int i = 0;
                while (-1 != (ch = this.m_delimiters_.charAt(i))) {
                    this.delims[ch] = true;
                    ++i;
                }
            } else {
                this.delims = null;
            }
        }
    }

    static void __staticInitializer__() {
        DEFAULT_DELIMITERS_ = new UnicodeSet(9, 10, 12, 13, 32, 32);
        EMPTY_DELIMITER_ = UnicodeSet.EMPTY;
    }

    private void __constructor__(String string2, UnicodeSet unicodeSet, boolean bl) {
        this.$$robo$$android_icu_util_StringTokenizer$__constructor__(string2, unicodeSet, bl);
    }

    public StringTokenizer(String string2, UnicodeSet unicodeSet, boolean bl) {
        this(string2, unicodeSet, bl, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTokenizer$__constructor__(java.lang.String android.icu.text.UnicodeSet boolean ), 0, this, string2, unicodeSet, bl);
    }

    private void __constructor__(String string2, UnicodeSet unicodeSet, boolean bl, boolean bl2) {
        this.$$robo$$android_icu_util_StringTokenizer$__constructor__(string2, unicodeSet, bl, bl2);
    }

    public StringTokenizer(String string2, UnicodeSet unicodeSet, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTokenizer$__constructor__(java.lang.String android.icu.text.UnicodeSet boolean boolean ), 0, this, string2, unicodeSet, bl, bl2);
    }

    private void __constructor__(String string2, UnicodeSet unicodeSet) {
        this.$$robo$$android_icu_util_StringTokenizer$__constructor__(string2, unicodeSet);
    }

    public StringTokenizer(String string2, UnicodeSet unicodeSet) {
        this(string2, unicodeSet, false, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTokenizer$__constructor__(java.lang.String android.icu.text.UnicodeSet ), 0, this, string2, unicodeSet);
    }

    private void __constructor__(String string2, String string3, boolean bl) {
        this.$$robo$$android_icu_util_StringTokenizer$__constructor__(string2, string3, bl);
    }

    public StringTokenizer(String string2, String string3, boolean bl) {
        this(string2, string3, bl, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTokenizer$__constructor__(java.lang.String java.lang.String boolean ), 0, this, string2, string3, bl);
    }

    private void __constructor__(String string2, String string3, boolean bl, boolean bl2) {
        this.$$robo$$android_icu_util_StringTokenizer$__constructor__(string2, string3, bl, bl2);
    }

    public StringTokenizer(String string2, String string3, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTokenizer$__constructor__(java.lang.String java.lang.String boolean boolean ), 0, this, string2, string3, bl, bl2);
    }

    private void __constructor__(String string2, String string3) {
        this.$$robo$$android_icu_util_StringTokenizer$__constructor__(string2, string3);
    }

    public StringTokenizer(String string2, String string3) {
        this(string2, string3, false, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTokenizer$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_util_StringTokenizer$__constructor__(string2);
    }

    public StringTokenizer(String string2) {
        this(string2, DEFAULT_DELIMITERS_, false, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTokenizer$__constructor__(java.lang.String ), 0, this, string2);
    }

    public boolean hasMoreTokens() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMoreTokens", $$robo$$android_icu_util_StringTokenizer$hasMoreTokens(), 0, this);
    }

    public String nextToken() {
        return InvokeDynamicSupport.bootstrap("nextToken", $$robo$$android_icu_util_StringTokenizer$nextToken(), 0, this);
    }

    public String nextToken(String string2) {
        return InvokeDynamicSupport.bootstrap("nextToken", $$robo$$android_icu_util_StringTokenizer$nextToken(java.lang.String ), 0, this, string2);
    }

    public String nextToken(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("nextToken", $$robo$$android_icu_util_StringTokenizer$nextToken(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    @Override
    public boolean hasMoreElements() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMoreElements", $$robo$$android_icu_util_StringTokenizer$hasMoreElements(), 0, this);
    }

    @Override
    public Object nextElement() {
        return InvokeDynamicSupport.bootstrap("nextElement", $$robo$$android_icu_util_StringTokenizer$nextElement(), 0, this);
    }

    public int countTokens() {
        return (int)InvokeDynamicSupport.bootstrap("countTokens", $$robo$$android_icu_util_StringTokenizer$countTokens(), 0, this);
    }

    private int getNextDelimiter(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNextDelimiter", $$robo$$android_icu_util_StringTokenizer$getNextDelimiter(int ), 0, this, n);
    }

    private int getNextNonDelimiter(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNextNonDelimiter", $$robo$$android_icu_util_StringTokenizer$getNextNonDelimiter(int ), 0, this, n);
    }

    void checkDelimiters() {
        InvokeDynamicSupport.bootstrap("checkDelimiters", $$robo$$android_icu_util_StringTokenizer$checkDelimiters(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(StringTokenizer.class);
    }

    public /* synthetic */ StringTokenizer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringTokenizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

