/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyboardView
extends View
implements View.OnClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static int NOT_A_KEY = -1;
    private static int[] KEY_DELETE;
    private static int[] LONG_PRESSABLE_STATE_SET;
    private Keyboard mKeyboard;
    private int mCurrentKeyIndex;
    private int mLabelTextSize;
    private int mKeyTextSize;
    private int mKeyTextColor;
    private float mShadowRadius;
    private int mShadowColor;
    private float mBackgroundDimAmount;
    private TextView mPreviewText;
    private PopupWindow mPreviewPopup;
    private int mPreviewTextSizeLarge;
    private int mPreviewOffset;
    private int mPreviewHeight;
    private int[] mCoordinates;
    private PopupWindow mPopupKeyboard;
    private View mMiniKeyboardContainer;
    private KeyboardView mMiniKeyboard;
    private boolean mMiniKeyboardOnScreen;
    private View mPopupParent;
    private int mMiniKeyboardOffsetX;
    private int mMiniKeyboardOffsetY;
    private Map<Keyboard.Key, View> mMiniKeyboardCache;
    private Keyboard.Key[] mKeys;
    private OnKeyboardActionListener mKeyboardActionListener;
    private static int MSG_SHOW_PREVIEW = 1;
    private static int MSG_REMOVE_PREVIEW = 2;
    private static int MSG_REPEAT = 3;
    private static int MSG_LONGPRESS = 4;
    private static int DELAY_BEFORE_PREVIEW = 0;
    private static int DELAY_AFTER_PREVIEW = 70;
    private static int DEBOUNCE_TIME = 70;
    private int mVerticalCorrection;
    private int mProximityThreshold;
    private boolean mPreviewCentered;
    private boolean mShowPreview;
    private boolean mShowTouchPoints;
    private int mPopupPreviewX;
    private int mPopupPreviewY;
    private int mLastX;
    private int mLastY;
    private int mStartX;
    private int mStartY;
    private boolean mProximityCorrectOn;
    private Paint mPaint;
    private Rect mPadding;
    private long mDownTime;
    private long mLastMoveTime;
    private int mLastKey;
    private int mLastCodeX;
    private int mLastCodeY;
    private int mCurrentKey;
    private int mDownKey;
    private long mLastKeyTime;
    private long mCurrentKeyTime;
    private int[] mKeyIndices;
    private GestureDetector mGestureDetector;
    private int mPopupX;
    private int mPopupY;
    private int mRepeatKeyIndex;
    private int mPopupLayout;
    private boolean mAbortKey;
    private Keyboard.Key mInvalidatedKey;
    private Rect mClipRegion;
    private boolean mPossiblePoly;
    private SwipeTracker mSwipeTracker;
    private int mSwipeThreshold;
    private boolean mDisambiguateSwipe;
    private int mOldPointerCount;
    private float mOldPointerX;
    private float mOldPointerY;
    private Drawable mKeyBackground;
    private static int REPEAT_INTERVAL = 50;
    private static int REPEAT_START_DELAY = 400;
    private static int LONGPRESS_TIMEOUT;
    private static int MAX_NEARBY_KEYS;
    private int[] mDistances;
    private int mLastSentIndex;
    private int mTapCount;
    private long mLastTapTime;
    private boolean mInMultiTap;
    private static int MULTITAP_INTERVAL = 800;
    private StringBuilder mPreviewLabel;
    private boolean mDrawPending;
    private Rect mDirtyRect;
    private Bitmap mBuffer;
    private boolean mKeyboardChanged;
    private Canvas mCanvas;
    private AccessibilityManager mAccessibilityManager;
    private AudioManager mAudioManager;
    private boolean mHeadsetRequiredToHearPasswordsAnnounced;
    Handler mHandler;

    private void $$robo$$android_inputmethodservice_KeyboardView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_inputmethodservice_KeyboardView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_inputmethodservice_KeyboardView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mCurrentKeyIndex = -1;
        this.mCoordinates = new int[2];
        this.mPreviewCentered = false;
        this.mShowPreview = true;
        this.mShowTouchPoints = true;
        this.mCurrentKey = -1;
        this.mDownKey = -1;
        this.mKeyIndices = new int[12];
        this.mRepeatKeyIndex = -1;
        this.mClipRegion = new Rect(0, 0, 0, 0);
        this.mSwipeTracker = new SwipeTracker();
        this.mOldPointerCount = 1;
        this.mDistances = new int[MAX_NEARBY_KEYS];
        this.mPreviewLabel = new StringBuilder(1);
        this.mDirtyRect = new Rect();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyboardView, defStyleAttr, defStyleRes);
        LayoutInflater inflate = (LayoutInflater)context.getSystemService("layout_inflater");
        int previewLayout = 0;
        boolean keyTextSize = false;
        int n = a.getIndexCount();
        block13: for (int i = 0; i < n; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 2: {
                    this.mKeyBackground = a.getDrawable(attr2);
                    continue block13;
                }
                case 9: {
                    this.mVerticalCorrection = a.getDimensionPixelOffset(attr2, 0);
                    continue block13;
                }
                case 6: {
                    previewLayout = a.getResourceId(attr2, 0);
                    continue block13;
                }
                case 7: {
                    this.mPreviewOffset = a.getDimensionPixelOffset(attr2, 0);
                    continue block13;
                }
                case 8: {
                    this.mPreviewHeight = a.getDimensionPixelSize(attr2, 80);
                    continue block13;
                }
                case 3: {
                    this.mKeyTextSize = a.getDimensionPixelSize(attr2, 18);
                    continue block13;
                }
                case 5: {
                    this.mKeyTextColor = a.getColor(attr2, -16777216);
                    continue block13;
                }
                case 4: {
                    this.mLabelTextSize = a.getDimensionPixelSize(attr2, 14);
                    continue block13;
                }
                case 10: {
                    this.mPopupLayout = a.getResourceId(attr2, 0);
                    continue block13;
                }
                case 0: {
                    this.mShadowColor = a.getColor(attr2, 0);
                    continue block13;
                }
                case 1: {
                    this.mShadowRadius = a.getFloat(attr2, 0.0f);
                }
            }
        }
        a = this.mContext.obtainStyledAttributes(R.styleable.Theme);
        this.mBackgroundDimAmount = a.getFloat(2, 0.5f);
        this.mPreviewPopup = new PopupWindow(context);
        if (previewLayout != 0) {
            this.mPreviewText = (TextView)inflate.inflate(previewLayout, null);
            this.mPreviewTextSizeLarge = (int)this.mPreviewText.getTextSize();
            this.mPreviewPopup.setContentView(this.mPreviewText);
            this.mPreviewPopup.setBackgroundDrawable(null);
        } else {
            this.mShowPreview = false;
        }
        this.mPreviewPopup.setTouchable(false);
        this.mPopupKeyboard = new PopupWindow(context);
        this.mPopupKeyboard.setBackgroundDrawable(null);
        this.mPopupParent = this;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize((float)keyTextSize);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setAlpha(255);
        this.mPadding = new Rect(0, 0, 0, 0);
        this.mMiniKeyboardCache = new HashMap<Keyboard.Key, View>();
        this.mKeyBackground.getPadding(this.mPadding);
        this.mSwipeThreshold = (int)(500.0f * this.getResources().getDisplayMetrics().density);
        this.mDisambiguateSwipe = this.getResources().getBoolean(17957022);
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.resetMultiTap();
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.initGestureDetector();
        if (this.mHandler == null) {
            this.mHandler = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ KeyboardView this$0;

                private void $$robo$$android_inputmethodservice_KeyboardView_1$__constructor__(KeyboardView this$0) {
                }

                private final void $$robo$$android_inputmethodservice_KeyboardView_1$handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            this.this$0.showKey(msg.arg1);
                            break;
                        }
                        case 2: {
                            this.this$0.mPreviewText.setVisibility(4);
                            break;
                        }
                        case 3: {
                            if (!this.this$0.repeatKey()) break;
                            Message repeat = Message.obtain((Handler)this, 3);
                            this.sendMessageDelayed(repeat, 50L);
                            break;
                        }
                        case 4: {
                            this.this$0.openPopupIfRequired((MotionEvent)msg.obj);
                        }
                    }
                }

                private void __constructor__(KeyboardView keyboardView) {
                    this.$$robo$$android_inputmethodservice_KeyboardView_1$__constructor__(keyboardView);
                }
                {
                    this.this$0 = keyboardView;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_KeyboardView_1$__constructor__(android.inputmethodservice.KeyboardView ), 0, this, keyboardView);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_inputmethodservice_KeyboardView_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$initGestureDetector() {
        if (this.mGestureDetector == null) {
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ KeyboardView this$0;

                private void $$robo$$android_inputmethodservice_KeyboardView_2$__constructor__(KeyboardView this$0) {
                }

                /*
                 * Enabled aggressive block sorting
                 */
                private final boolean $$robo$$android_inputmethodservice_KeyboardView_2$onFling(MotionEvent me1, MotionEvent me2, float velocityX, float velocityY) {
                    boolean sendDownKey;
                    block14: {
                        if (this.this$0.mPossiblePoly) {
                            return false;
                        }
                        float absX = Math.abs(velocityX);
                        float absY = Math.abs(velocityY);
                        float deltaX = me2.getX() - me1.getX();
                        float deltaY = me2.getY() - me1.getY();
                        int travelX = this.this$0.getWidth() / 2;
                        int travelY = this.this$0.getHeight() / 2;
                        this.this$0.mSwipeTracker.computeCurrentVelocity(1000);
                        float endingVelocityX = this.this$0.mSwipeTracker.getXVelocity();
                        float endingVelocityY = this.this$0.mSwipeTracker.getYVelocity();
                        sendDownKey = false;
                        if (velocityX > (float)this.this$0.mSwipeThreshold && absY < absX && deltaX > (float)travelX) {
                            if (this.this$0.mDisambiguateSwipe && endingVelocityX < velocityX / 4.0f) {
                                sendDownKey = true;
                                break block14;
                            } else {
                                this.this$0.swipeRight();
                                return true;
                            }
                        }
                        if (velocityX < (float)(-this.this$0.mSwipeThreshold) && absY < absX && deltaX < (float)(-travelX)) {
                            if (this.this$0.mDisambiguateSwipe && endingVelocityX > velocityX / 4.0f) {
                                sendDownKey = true;
                                break block14;
                            } else {
                                this.this$0.swipeLeft();
                                return true;
                            }
                        }
                        if (velocityY < (float)(-this.this$0.mSwipeThreshold) && absX < absY && deltaY < (float)(-travelY)) {
                            if (this.this$0.mDisambiguateSwipe && endingVelocityY > velocityY / 4.0f) {
                                sendDownKey = true;
                                break block14;
                            } else {
                                this.this$0.swipeUp();
                                return true;
                            }
                        }
                        if (velocityY > (float)this.this$0.mSwipeThreshold && absX < absY / 2.0f && deltaY > (float)travelY) {
                            if (this.this$0.mDisambiguateSwipe && endingVelocityY < velocityY / 4.0f) {
                                sendDownKey = true;
                            } else {
                                this.this$0.swipeDown();
                                return true;
                            }
                        }
                    }
                    if (sendDownKey) {
                        this.this$0.detectAndSendKey(this.this$0.mDownKey, this.this$0.mStartX, this.this$0.mStartY, me1.getEventTime());
                    }
                    return false;
                }

                private void __constructor__(KeyboardView keyboardView) {
                    this.$$robo$$android_inputmethodservice_KeyboardView_2$__constructor__(keyboardView);
                }
                {
                    this.this$0 = keyboardView;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_KeyboardView_2$__constructor__(android.inputmethodservice.KeyboardView ), 0, this, keyboardView);
                }

                @Override
                public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("onFling", $$robo$$android_inputmethodservice_KeyboardView_2$onFling(android.view.MotionEvent android.view.MotionEvent float float ), 0, this, motionEvent, motionEvent2, f, f2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mGestureDetector.setIsLongpressEnabled(false);
        }
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$setOnKeyboardActionListener(OnKeyboardActionListener listener) {
        this.mKeyboardActionListener = listener;
    }

    private final OnKeyboardActionListener $$robo$$android_inputmethodservice_KeyboardView$getOnKeyboardActionListener() {
        return this.mKeyboardActionListener;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$setKeyboard(Keyboard keyboard) {
        if (this.mKeyboard != null) {
            this.showPreview(-1);
        }
        this.removeMessages();
        this.mKeyboard = keyboard;
        List<Keyboard.Key> keys = this.mKeyboard.getKeys();
        this.mKeys = keys.toArray(new Keyboard.Key[keys.size()]);
        this.requestLayout();
        this.mKeyboardChanged = true;
        this.invalidateAllKeys();
        this.computeProximityThreshold(keyboard);
        this.mMiniKeyboardCache.clear();
        this.mAbortKey = true;
    }

    private final Keyboard $$robo$$android_inputmethodservice_KeyboardView$getKeyboard() {
        return this.mKeyboard;
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$setShifted(boolean shifted) {
        if (this.mKeyboard != null && this.mKeyboard.setShifted(shifted)) {
            this.invalidateAllKeys();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$isShifted() {
        if (this.mKeyboard != null) {
            return this.mKeyboard.isShifted();
        }
        return false;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$setPreviewEnabled(boolean previewEnabled) {
        this.mShowPreview = previewEnabled;
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$isPreviewEnabled() {
        return this.mShowPreview;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$setVerticalCorrection(int verticalOffset) {
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$setPopupParent(View v) {
        this.mPopupParent = v;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$setPopupOffset(int x, int y) {
        this.mMiniKeyboardOffsetX = x;
        this.mMiniKeyboardOffsetY = y;
        if (this.mPreviewPopup.isShowing()) {
            this.mPreviewPopup.dismiss();
        }
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$setProximityCorrectionEnabled(boolean enabled) {
        this.mProximityCorrectOn = enabled;
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$isProximityCorrectionEnabled() {
        return this.mProximityCorrectOn;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$onClick(View v) {
        this.dismissPopupKeyboard();
    }

    private final CharSequence $$robo$$android_inputmethodservice_KeyboardView$adjustCase(CharSequence label) {
        if (this.mKeyboard.isShifted() && label != null && label.length() < 3 && Character.isLowerCase(label.charAt(0))) {
            label = label.toString().toUpperCase();
        }
        return label;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mKeyboard == null) {
            this.setMeasuredDimension(this.mPaddingLeft + this.mPaddingRight, this.mPaddingTop + this.mPaddingBottom);
        } else {
            int width = this.mKeyboard.getMinWidth() + this.mPaddingLeft + this.mPaddingRight;
            if (View.MeasureSpec.getSize(widthMeasureSpec) < width + 10) {
                width = View.MeasureSpec.getSize(widthMeasureSpec);
            }
            this.setMeasuredDimension(width, this.mKeyboard.getHeight() + this.mPaddingTop + this.mPaddingBottom);
        }
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$computeProximityThreshold(Keyboard keyboard) {
        if (keyboard == null) {
            return;
        }
        Keyboard.Key[] keys = this.mKeys;
        if (keys == null) {
            return;
        }
        int length = keys.length;
        int dimensionSum = 0;
        for (int i = 0; i < length; ++i) {
            Keyboard.Key key = keys[i];
            dimensionSum += Math.min(key.width, key.height) + key.gap;
        }
        if (dimensionSum < 0 || length == 0) {
            return;
        }
        this.mProximityThreshold = (int)((float)dimensionSum * 1.4f / (float)length);
        this.mProximityThreshold *= this.mProximityThreshold;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mKeyboard != null) {
            this.mKeyboard.resize(w, h);
        }
        this.mBuffer = null;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawPending || this.mBuffer == null || this.mKeyboardChanged) {
            this.onBufferDraw();
        }
        canvas.drawBitmap(this.mBuffer, 0.0f, 0.0f, null);
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$onBufferDraw() {
        if (this.mBuffer == null || this.mKeyboardChanged) {
            if (this.mBuffer == null || this.mKeyboardChanged && (this.mBuffer.getWidth() != this.getWidth() || this.mBuffer.getHeight() != this.getHeight())) {
                int width = Math.max(1, this.getWidth());
                int height = Math.max(1, this.getHeight());
                this.mBuffer = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                this.mCanvas = new Canvas(this.mBuffer);
            }
            this.invalidateAllKeys();
            this.mKeyboardChanged = false;
        }
        Canvas canvas = this.mCanvas;
        canvas.clipRect(this.mDirtyRect, Region.Op.REPLACE);
        if (this.mKeyboard == null) {
            return;
        }
        Paint paint = this.mPaint;
        Drawable keyBackground = this.mKeyBackground;
        Rect clipRegion = this.mClipRegion;
        Rect padding = this.mPadding;
        int kbdPaddingLeft = this.mPaddingLeft;
        int kbdPaddingTop = this.mPaddingTop;
        Keyboard.Key[] keys = this.mKeys;
        Keyboard.Key invalidKey = this.mInvalidatedKey;
        paint.setColor(this.mKeyTextColor);
        boolean drawSingleKey = false;
        if (invalidKey != null && canvas.getClipBounds(clipRegion) && invalidKey.x + kbdPaddingLeft - 1 <= clipRegion.left && invalidKey.y + kbdPaddingTop - 1 <= clipRegion.top && invalidKey.x + invalidKey.width + kbdPaddingLeft + 1 >= clipRegion.right && invalidKey.y + invalidKey.height + kbdPaddingTop + 1 >= clipRegion.bottom) {
            drawSingleKey = true;
        }
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        for (Keyboard.Key key : keys) {
            if (drawSingleKey && invalidKey != key) continue;
            int[] drawableState = key.getCurrentDrawableState();
            keyBackground.setState(drawableState);
            String label = key.label == null ? null : this.adjustCase(key.label).toString();
            Rect bounds = keyBackground.getBounds();
            if (key.width != bounds.right || key.height != bounds.bottom) {
                keyBackground.setBounds(0, 0, key.width, key.height);
            }
            canvas.translate(key.x + kbdPaddingLeft, key.y + kbdPaddingTop);
            keyBackground.draw(canvas);
            if (label != null) {
                if (label.length() > 1 && key.codes.length < 2) {
                    paint.setTextSize(this.mLabelTextSize);
                    paint.setTypeface(Typeface.DEFAULT_BOLD);
                } else {
                    paint.setTextSize(this.mKeyTextSize);
                    paint.setTypeface(Typeface.DEFAULT);
                }
                paint.setShadowLayer(this.mShadowRadius, 0.0f, 0.0f, this.mShadowColor);
                canvas.drawText(label, (key.width - padding.left - padding.right) / 2 + padding.left, (float)((key.height - padding.top - padding.bottom) / 2) + (paint.getTextSize() - paint.descent()) / 2.0f + (float)padding.top, paint);
                paint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            } else if (key.icon != null) {
                int drawableX = (key.width - padding.left - padding.right - key.icon.getIntrinsicWidth()) / 2 + padding.left;
                int drawableY = (key.height - padding.top - padding.bottom - key.icon.getIntrinsicHeight()) / 2 + padding.top;
                canvas.translate(drawableX, drawableY);
                key.icon.setBounds(0, 0, key.icon.getIntrinsicWidth(), key.icon.getIntrinsicHeight());
                key.icon.draw(canvas);
                canvas.translate(-drawableX, -drawableY);
            }
            canvas.translate(-key.x - kbdPaddingLeft, -key.y - kbdPaddingTop);
        }
        this.mInvalidatedKey = null;
        if (this.mMiniKeyboardOnScreen) {
            paint.setColor((int)(this.mBackgroundDimAmount * 255.0f) << 24);
            canvas.drawRect(0.0f, 0.0f, this.getWidth(), this.getHeight(), paint);
        }
        this.mDrawPending = false;
        this.mDirtyRect.setEmpty();
    }

    private final int $$robo$$android_inputmethodservice_KeyboardView$getKeyIndices(int x, int y, int[] allKeys) {
        Keyboard.Key[] keys = this.mKeys;
        int primaryIndex = -1;
        int closestKey = -1;
        int closestKeyDist = this.mProximityThreshold + 1;
        Arrays.fill(this.mDistances, Integer.MAX_VALUE);
        int[] nearestKeyIndices = this.mKeyboard.getNearestKeys(x, y);
        int keyCount = nearestKeyIndices.length;
        block0: for (int i = 0; i < keyCount; ++i) {
            Keyboard.Key key = keys[nearestKeyIndices[i]];
            int dist = 0;
            boolean isInside = key.isInside(x, y);
            if (isInside) {
                primaryIndex = nearestKeyIndices[i];
            }
            if ((!this.mProximityCorrectOn || (dist = key.squaredDistanceFrom(x, y)) >= this.mProximityThreshold) && !isInside || key.codes[0] <= 32) continue;
            int nCodes = key.codes.length;
            if (dist < closestKeyDist) {
                closestKeyDist = dist;
                closestKey = nearestKeyIndices[i];
            }
            if (allKeys == null) continue;
            for (int j = 0; j < this.mDistances.length; ++j) {
                if (this.mDistances[j] <= dist) continue;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mDistances, (int)j, (int[])this.mDistances, (int)(j + nCodes), (int)(this.mDistances.length - j - nCodes));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])allKeys, (int)j, (int[])allKeys, (int)(j + nCodes), (int)(allKeys.length - j - nCodes));
                for (int c = 0; c < nCodes; ++c) {
                    allKeys[j + c] = key.codes[c];
                    this.mDistances[j + c] = dist;
                }
                continue block0;
            }
        }
        if (primaryIndex == -1) {
            primaryIndex = closestKey;
        }
        return primaryIndex;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$detectAndSendKey(int index, int x, int y, long eventTime) {
        if (index != -1 && index < this.mKeys.length) {
            Keyboard.Key key = this.mKeys[index];
            if (key.text != null) {
                this.mKeyboardActionListener.onText(key.text);
                this.mKeyboardActionListener.onRelease(-1);
            } else {
                int code = key.codes[0];
                int[] codes = new int[MAX_NEARBY_KEYS];
                Arrays.fill(codes, -1);
                this.getKeyIndices(x, y, codes);
                if (this.mInMultiTap) {
                    if (this.mTapCount != -1) {
                        this.mKeyboardActionListener.onKey(-5, KEY_DELETE);
                    } else {
                        this.mTapCount = 0;
                    }
                    code = key.codes[this.mTapCount];
                }
                this.mKeyboardActionListener.onKey(code, codes);
                this.mKeyboardActionListener.onRelease(code);
            }
            this.mLastSentIndex = index;
            this.mLastTapTime = eventTime;
        }
    }

    private final CharSequence $$robo$$android_inputmethodservice_KeyboardView$getPreviewText(Keyboard.Key key) {
        if (this.mInMultiTap) {
            this.mPreviewLabel.setLength(0);
            this.mPreviewLabel.append((char)key.codes[this.mTapCount < 0 ? 0 : this.mTapCount]);
            return this.adjustCase(this.mPreviewLabel);
        }
        return this.adjustCase(key.label);
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$showPreview(int keyIndex) {
        int oldKeyIndex = this.mCurrentKeyIndex;
        PopupWindow previewPopup = this.mPreviewPopup;
        this.mCurrentKeyIndex = keyIndex;
        Keyboard.Key[] keys = this.mKeys;
        if (oldKeyIndex != this.mCurrentKeyIndex) {
            int keyCode;
            if (oldKeyIndex != -1 && keys.length > oldKeyIndex) {
                Keyboard.Key oldKey = keys[oldKeyIndex];
                oldKey.onReleased(this.mCurrentKeyIndex == -1);
                this.invalidateKey(oldKeyIndex);
                keyCode = oldKey.codes[0];
                this.sendAccessibilityEventForUnicodeCharacter(256, keyCode);
                this.sendAccessibilityEventForUnicodeCharacter(65536, keyCode);
            }
            if (this.mCurrentKeyIndex != -1 && keys.length > this.mCurrentKeyIndex) {
                Keyboard.Key newKey = keys[this.mCurrentKeyIndex];
                newKey.onPressed();
                this.invalidateKey(this.mCurrentKeyIndex);
                keyCode = newKey.codes[0];
                this.sendAccessibilityEventForUnicodeCharacter(128, keyCode);
                this.sendAccessibilityEventForUnicodeCharacter(32768, keyCode);
            }
        }
        if (oldKeyIndex != this.mCurrentKeyIndex && this.mShowPreview) {
            this.mHandler.removeMessages(1);
            if (previewPopup.isShowing() && keyIndex == -1) {
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 70L);
            }
            if (keyIndex != -1) {
                if (previewPopup.isShowing() && this.mPreviewText.getVisibility() == 0) {
                    this.showKey(keyIndex);
                } else {
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, keyIndex, 0), 0L);
                }
            }
        }
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$showKey(int keyIndex) {
        PopupWindow previewPopup = this.mPreviewPopup;
        Keyboard.Key[] keys = this.mKeys;
        if (keyIndex < 0 || keyIndex >= this.mKeys.length) {
            return;
        }
        Keyboard.Key key = keys[keyIndex];
        if (key.icon != null) {
            this.mPreviewText.setCompoundDrawables(null, null, null, key.iconPreview != null ? key.iconPreview : key.icon);
            this.mPreviewText.setText(null);
        } else {
            this.mPreviewText.setCompoundDrawables(null, null, null, null);
            this.mPreviewText.setText(this.getPreviewText(key));
            if (key.label.length() > 1 && key.codes.length < 2) {
                this.mPreviewText.setTextSize(0, this.mKeyTextSize);
                this.mPreviewText.setTypeface(Typeface.DEFAULT_BOLD);
            } else {
                this.mPreviewText.setTextSize(0, this.mPreviewTextSizeLarge);
                this.mPreviewText.setTypeface(Typeface.DEFAULT);
            }
        }
        this.mPreviewText.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
        int popupWidth = Math.max(this.mPreviewText.getMeasuredWidth(), key.width + this.mPreviewText.getPaddingLeft() + this.mPreviewText.getPaddingRight());
        int popupHeight = this.mPreviewHeight;
        ViewGroup.LayoutParams lp = this.mPreviewText.getLayoutParams();
        if (lp != null) {
            lp.width = popupWidth;
            lp.height = popupHeight;
        }
        if (!this.mPreviewCentered) {
            this.mPopupPreviewX = key.x - this.mPreviewText.getPaddingLeft() + this.mPaddingLeft;
            this.mPopupPreviewY = key.y - popupHeight + this.mPreviewOffset;
        } else {
            this.mPopupPreviewX = 160 - this.mPreviewText.getMeasuredWidth() / 2;
            this.mPopupPreviewY = -this.mPreviewText.getMeasuredHeight();
        }
        this.mHandler.removeMessages(2);
        this.getLocationInWindow(this.mCoordinates);
        this.mCoordinates[0] = this.mCoordinates[0] + this.mMiniKeyboardOffsetX;
        this.mCoordinates[1] = this.mCoordinates[1] + this.mMiniKeyboardOffsetY;
        this.mPreviewText.getBackground().setState(key.popupResId != 0 ? LONG_PRESSABLE_STATE_SET : EMPTY_STATE_SET);
        this.mPopupPreviewX += this.mCoordinates[0];
        this.mPopupPreviewY += this.mCoordinates[1];
        this.getLocationOnScreen(this.mCoordinates);
        if (this.mPopupPreviewY + this.mCoordinates[1] < 0) {
            this.mPopupPreviewX = key.x + key.width <= this.getWidth() / 2 ? (this.mPopupPreviewX += (int)((double)key.width * 2.5)) : (this.mPopupPreviewX -= (int)((double)key.width * 2.5));
            this.mPopupPreviewY += popupHeight;
        }
        if (previewPopup.isShowing()) {
            previewPopup.update(this.mPopupPreviewX, this.mPopupPreviewY, popupWidth, popupHeight);
        } else {
            previewPopup.setWidth(popupWidth);
            previewPopup.setHeight(popupHeight);
            previewPopup.showAtLocation(this.mPopupParent, 0, this.mPopupPreviewX, this.mPopupPreviewY);
        }
        this.mPreviewText.setVisibility(0);
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$sendAccessibilityEventForUnicodeCharacter(int eventType, int code) {
        if (this.mAccessibilityManager.isEnabled()) {
            String text;
            AccessibilityEvent event = AccessibilityEvent.obtain(eventType);
            this.onInitializeAccessibilityEvent(event);
            switch (code) {
                case -6: {
                    text = this.mContext.getString(17040001);
                    break;
                }
                case -3: {
                    text = this.mContext.getString(17040002);
                    break;
                }
                case -5: {
                    text = this.mContext.getString(17040003);
                    break;
                }
                case -4: {
                    text = this.mContext.getString(17040004);
                    break;
                }
                case -2: {
                    text = this.mContext.getString(17040006);
                    break;
                }
                case -1: {
                    text = this.mContext.getString(17040007);
                    break;
                }
                case 10: {
                    text = this.mContext.getString(17040005);
                    break;
                }
                default: {
                    text = String.valueOf((char)code);
                }
            }
            event.getText().add(text);
            this.mAccessibilityManager.sendAccessibilityEvent(event);
        }
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$invalidateAllKeys() {
        this.mDirtyRect.union(0, 0, this.getWidth(), this.getHeight());
        this.mDrawPending = true;
        this.invalidate();
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$invalidateKey(int keyIndex) {
        Keyboard.Key key;
        if (this.mKeys == null) {
            return;
        }
        if (keyIndex < 0 || keyIndex >= this.mKeys.length) {
            return;
        }
        this.mInvalidatedKey = key = this.mKeys[keyIndex];
        this.mDirtyRect.union(key.x + this.mPaddingLeft, key.y + this.mPaddingTop, key.x + key.width + this.mPaddingLeft, key.y + key.height + this.mPaddingTop);
        this.onBufferDraw();
        this.invalidate(key.x + this.mPaddingLeft, key.y + this.mPaddingTop, key.x + key.width + this.mPaddingLeft, key.y + key.height + this.mPaddingTop);
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$openPopupIfRequired(MotionEvent me) {
        if (this.mPopupLayout == 0) {
            return false;
        }
        if (this.mCurrentKey < 0 || this.mCurrentKey >= this.mKeys.length) {
            return false;
        }
        Keyboard.Key popupKey = this.mKeys[this.mCurrentKey];
        boolean result = this.onLongPress(popupKey);
        if (result) {
            this.mAbortKey = true;
            this.showPreview(-1);
        }
        return result;
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$onLongPress(Keyboard.Key popupKey) {
        int popupKeyboardId = popupKey.popupResId;
        if (popupKeyboardId != 0) {
            this.mMiniKeyboardContainer = this.mMiniKeyboardCache.get(popupKey);
            if (this.mMiniKeyboardContainer == null) {
                LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
                this.mMiniKeyboardContainer = inflater.inflate(this.mPopupLayout, null);
                this.mMiniKeyboard = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
                Object closeButton = this.mMiniKeyboardContainer.findViewById(16908327);
                if (closeButton != null) {
                    ((View)closeButton).setOnClickListener(this);
                }
                this.mMiniKeyboard.setOnKeyboardActionListener(new OnKeyboardActionListener(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ KeyboardView this$0;

                    private void $$robo$$android_inputmethodservice_KeyboardView_3$__constructor__(KeyboardView this$0) {
                    }

                    private final void $$robo$$android_inputmethodservice_KeyboardView_3$onKey(int primaryCode, int[] keyCodes) {
                        this.this$0.mKeyboardActionListener.onKey(primaryCode, keyCodes);
                        this.this$0.dismissPopupKeyboard();
                    }

                    private final void $$robo$$android_inputmethodservice_KeyboardView_3$onText(CharSequence text) {
                        this.this$0.mKeyboardActionListener.onText(text);
                        this.this$0.dismissPopupKeyboard();
                    }

                    private final void $$robo$$android_inputmethodservice_KeyboardView_3$swipeLeft() {
                    }

                    private final void $$robo$$android_inputmethodservice_KeyboardView_3$swipeRight() {
                    }

                    private final void $$robo$$android_inputmethodservice_KeyboardView_3$swipeUp() {
                    }

                    private final void $$robo$$android_inputmethodservice_KeyboardView_3$swipeDown() {
                    }

                    private final void $$robo$$android_inputmethodservice_KeyboardView_3$onPress(int primaryCode) {
                        this.this$0.mKeyboardActionListener.onPress(primaryCode);
                    }

                    private final void $$robo$$android_inputmethodservice_KeyboardView_3$onRelease(int primaryCode) {
                        this.this$0.mKeyboardActionListener.onRelease(primaryCode);
                    }

                    private void __constructor__(KeyboardView keyboardView) {
                        this.$$robo$$android_inputmethodservice_KeyboardView_3$__constructor__(keyboardView);
                    }
                    {
                        this.this$0 = keyboardView;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_KeyboardView_3$__constructor__(android.inputmethodservice.KeyboardView ), 0, this, keyboardView);
                    }

                    @Override
                    public void onKey(int n, int[] nArray) {
                        InvokeDynamicSupport.bootstrap("onKey", $$robo$$android_inputmethodservice_KeyboardView_3$onKey(int int[] ), 0, this, n, nArray);
                    }

                    @Override
                    public void onText(CharSequence charSequence) {
                        InvokeDynamicSupport.bootstrap("onText", $$robo$$android_inputmethodservice_KeyboardView_3$onText(java.lang.CharSequence ), 0, this, charSequence);
                    }

                    @Override
                    public void swipeLeft() {
                        InvokeDynamicSupport.bootstrap("swipeLeft", $$robo$$android_inputmethodservice_KeyboardView_3$swipeLeft(), 0, this);
                    }

                    @Override
                    public void swipeRight() {
                        InvokeDynamicSupport.bootstrap("swipeRight", $$robo$$android_inputmethodservice_KeyboardView_3$swipeRight(), 0, this);
                    }

                    @Override
                    public void swipeUp() {
                        InvokeDynamicSupport.bootstrap("swipeUp", $$robo$$android_inputmethodservice_KeyboardView_3$swipeUp(), 0, this);
                    }

                    @Override
                    public void swipeDown() {
                        InvokeDynamicSupport.bootstrap("swipeDown", $$robo$$android_inputmethodservice_KeyboardView_3$swipeDown(), 0, this);
                    }

                    @Override
                    public void onPress(int n) {
                        InvokeDynamicSupport.bootstrap("onPress", $$robo$$android_inputmethodservice_KeyboardView_3$onPress(int ), 0, this, n);
                    }

                    @Override
                    public void onRelease(int n) {
                        InvokeDynamicSupport.bootstrap("onRelease", $$robo$$android_inputmethodservice_KeyboardView_3$onRelease(int ), 0, this, n);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                Keyboard keyboard = popupKey.popupCharacters != null ? new Keyboard(this.getContext(), popupKeyboardId, popupKey.popupCharacters, -1, this.getPaddingLeft() + this.getPaddingRight()) : new Keyboard(this.getContext(), popupKeyboardId);
                this.mMiniKeyboard.setKeyboard(keyboard);
                this.mMiniKeyboard.setPopupParent(this);
                this.mMiniKeyboardContainer.measure(View.MeasureSpec.makeMeasureSpec(this.getWidth(), Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(this.getHeight(), Integer.MIN_VALUE));
                this.mMiniKeyboardCache.put(popupKey, this.mMiniKeyboardContainer);
            } else {
                this.mMiniKeyboard = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
            }
            this.getLocationInWindow(this.mCoordinates);
            this.mPopupX = popupKey.x + this.mPaddingLeft;
            this.mPopupY = popupKey.y + this.mPaddingTop;
            this.mPopupX = this.mPopupX + popupKey.width - this.mMiniKeyboardContainer.getMeasuredWidth();
            this.mPopupY -= this.mMiniKeyboardContainer.getMeasuredHeight();
            int x = this.mPopupX + this.mMiniKeyboardContainer.getPaddingRight() + this.mCoordinates[0];
            int y = this.mPopupY + this.mMiniKeyboardContainer.getPaddingBottom() + this.mCoordinates[1];
            this.mMiniKeyboard.setPopupOffset(x < 0 ? 0 : x, y);
            this.mMiniKeyboard.setShifted(this.isShifted());
            this.mPopupKeyboard.setContentView(this.mMiniKeyboardContainer);
            this.mPopupKeyboard.setWidth(this.mMiniKeyboardContainer.getMeasuredWidth());
            this.mPopupKeyboard.setHeight(this.mMiniKeyboardContainer.getMeasuredHeight());
            this.mPopupKeyboard.showAtLocation(this, 0, x, y);
            this.mMiniKeyboardOnScreen = true;
            this.invalidateAllKeys();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$onHoverEvent(MotionEvent event) {
        if (this.mAccessibilityManager.isTouchExplorationEnabled() && event.getPointerCount() == 1) {
            int action = event.getAction();
            switch (action) {
                case 9: {
                    event.setAction(0);
                    break;
                }
                case 7: {
                    event.setAction(2);
                    break;
                }
                case 10: {
                    event.setAction(1);
                }
            }
            return this.onTouchEvent(event);
        }
        return true;
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$onTouchEvent(MotionEvent me) {
        int pointerCount = me.getPointerCount();
        int action = me.getAction();
        boolean result = false;
        long now = me.getEventTime();
        if (pointerCount != this.mOldPointerCount) {
            if (pointerCount == 1) {
                MotionEvent down = MotionEvent.obtain(now, now, 0, me.getX(), me.getY(), me.getMetaState());
                result = this.onModifiedTouchEvent(down, false);
                down.recycle();
                if (action == 1) {
                    result = this.onModifiedTouchEvent(me, true);
                }
            } else {
                MotionEvent up = MotionEvent.obtain(now, now, 1, this.mOldPointerX, this.mOldPointerY, me.getMetaState());
                result = this.onModifiedTouchEvent(up, true);
                up.recycle();
            }
        } else if (pointerCount == 1) {
            result = this.onModifiedTouchEvent(me, false);
            this.mOldPointerX = me.getX();
            this.mOldPointerY = me.getY();
        } else {
            result = true;
        }
        this.mOldPointerCount = pointerCount;
        return result;
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$onModifiedTouchEvent(MotionEvent me, boolean possiblePoly) {
        int touchX = (int)me.getX() - this.mPaddingLeft;
        int touchY = (int)me.getY() - this.mPaddingTop;
        if (touchY >= -this.mVerticalCorrection) {
            touchY += this.mVerticalCorrection;
        }
        int action = me.getAction();
        long eventTime = me.getEventTime();
        int keyIndex = this.getKeyIndices(touchX, touchY, null);
        this.mPossiblePoly = possiblePoly;
        if (action == 0) {
            this.mSwipeTracker.clear();
        }
        this.mSwipeTracker.addMovement(me);
        if (this.mAbortKey && action != 0 && action != 3) {
            return true;
        }
        if (this.mGestureDetector.onTouchEvent(me)) {
            this.showPreview(-1);
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(4);
            return true;
        }
        if (this.mMiniKeyboardOnScreen && action != 3) {
            return true;
        }
        switch (action) {
            case 0: {
                Message msg;
                this.mAbortKey = false;
                this.mStartX = touchX;
                this.mStartY = touchY;
                this.mLastCodeX = touchX;
                this.mLastCodeY = touchY;
                this.mLastKeyTime = 0L;
                this.mCurrentKeyTime = 0L;
                this.mLastKey = -1;
                this.mCurrentKey = keyIndex;
                this.mDownKey = keyIndex;
                this.mLastMoveTime = this.mDownTime = me.getEventTime();
                this.checkMultiTap(eventTime, keyIndex);
                this.mKeyboardActionListener.onPress(keyIndex != -1 ? this.mKeys[keyIndex].codes[0] : 0);
                if (this.mCurrentKey >= 0 && this.mKeys[this.mCurrentKey].repeatable) {
                    this.mRepeatKeyIndex = this.mCurrentKey;
                    msg = this.mHandler.obtainMessage(3);
                    this.mHandler.sendMessageDelayed(msg, 400L);
                    this.repeatKey();
                    if (this.mAbortKey) {
                        this.mRepeatKeyIndex = -1;
                        break;
                    }
                }
                if (this.mCurrentKey != -1) {
                    msg = this.mHandler.obtainMessage(4, me);
                    this.mHandler.sendMessageDelayed(msg, LONGPRESS_TIMEOUT);
                }
                this.showPreview(keyIndex);
                break;
            }
            case 2: {
                boolean continueLongPress = false;
                if (keyIndex != -1) {
                    if (this.mCurrentKey == -1) {
                        this.mCurrentKey = keyIndex;
                        this.mCurrentKeyTime = eventTime - this.mDownTime;
                    } else if (keyIndex == this.mCurrentKey) {
                        this.mCurrentKeyTime += eventTime - this.mLastMoveTime;
                        continueLongPress = true;
                    } else if (this.mRepeatKeyIndex == -1) {
                        this.resetMultiTap();
                        this.mLastKey = this.mCurrentKey;
                        this.mLastCodeX = this.mLastX;
                        this.mLastCodeY = this.mLastY;
                        this.mLastKeyTime = this.mCurrentKeyTime + eventTime - this.mLastMoveTime;
                        this.mCurrentKey = keyIndex;
                        this.mCurrentKeyTime = 0L;
                    }
                }
                if (!continueLongPress) {
                    this.mHandler.removeMessages(4);
                    if (keyIndex != -1) {
                        Message msg = this.mHandler.obtainMessage(4, me);
                        this.mHandler.sendMessageDelayed(msg, LONGPRESS_TIMEOUT);
                    }
                }
                this.showPreview(this.mCurrentKey);
                this.mLastMoveTime = eventTime;
                break;
            }
            case 1: {
                this.removeMessages();
                if (keyIndex == this.mCurrentKey) {
                    this.mCurrentKeyTime += eventTime - this.mLastMoveTime;
                } else {
                    this.resetMultiTap();
                    this.mLastKey = this.mCurrentKey;
                    this.mLastKeyTime = this.mCurrentKeyTime + eventTime - this.mLastMoveTime;
                    this.mCurrentKey = keyIndex;
                    this.mCurrentKeyTime = 0L;
                }
                if (this.mCurrentKeyTime < this.mLastKeyTime && this.mCurrentKeyTime < 70L && this.mLastKey != -1) {
                    this.mCurrentKey = this.mLastKey;
                    touchX = this.mLastCodeX;
                    touchY = this.mLastCodeY;
                }
                this.showPreview(-1);
                Arrays.fill(this.mKeyIndices, -1);
                if (this.mRepeatKeyIndex == -1 && !this.mMiniKeyboardOnScreen && !this.mAbortKey) {
                    this.detectAndSendKey(this.mCurrentKey, touchX, touchY, eventTime);
                }
                this.invalidateKey(keyIndex);
                this.mRepeatKeyIndex = -1;
                break;
            }
            case 3: {
                this.removeMessages();
                this.dismissPopupKeyboard();
                this.mAbortKey = true;
                this.showPreview(-1);
                this.invalidateKey(this.mCurrentKey);
            }
        }
        this.mLastX = touchX;
        this.mLastY = touchY;
        return true;
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$repeatKey() {
        Keyboard.Key key = this.mKeys[this.mRepeatKeyIndex];
        this.detectAndSendKey(this.mCurrentKey, key.x, key.y, this.mLastTapTime);
        return true;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$swipeRight() {
        this.mKeyboardActionListener.swipeRight();
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$swipeLeft() {
        this.mKeyboardActionListener.swipeLeft();
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$swipeUp() {
        this.mKeyboardActionListener.swipeUp();
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$swipeDown() {
        this.mKeyboardActionListener.swipeDown();
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$closing() {
        if (this.mPreviewPopup.isShowing()) {
            this.mPreviewPopup.dismiss();
        }
        this.removeMessages();
        this.dismissPopupKeyboard();
        this.mBuffer = null;
        this.mCanvas = null;
        this.mMiniKeyboardCache.clear();
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$removeMessages() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(4);
            this.mHandler.removeMessages(1);
        }
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closing();
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$dismissPopupKeyboard() {
        if (this.mPopupKeyboard.isShowing()) {
            this.mPopupKeyboard.dismiss();
            this.mMiniKeyboardOnScreen = false;
            this.invalidateAllKeys();
        }
    }

    private final boolean $$robo$$android_inputmethodservice_KeyboardView$handleBack() {
        if (this.mPopupKeyboard.isShowing()) {
            this.dismissPopupKeyboard();
            return true;
        }
        return false;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$resetMultiTap() {
        this.mLastSentIndex = -1;
        this.mTapCount = 0;
        this.mLastTapTime = -1L;
        this.mInMultiTap = false;
    }

    private final void $$robo$$android_inputmethodservice_KeyboardView$checkMultiTap(long eventTime, int keyIndex) {
        if (keyIndex == -1) {
            return;
        }
        Keyboard.Key key = this.mKeys[keyIndex];
        if (key.codes.length > 1) {
            this.mInMultiTap = true;
            if (eventTime < this.mLastTapTime + 800L && keyIndex == this.mLastSentIndex) {
                this.mTapCount = (this.mTapCount + 1) % key.codes.length;
                return;
            }
            this.mTapCount = -1;
            return;
        }
        if (eventTime > this.mLastTapTime + 800L || keyIndex != this.mLastSentIndex) {
            this.resetMultiTap();
        }
    }

    static void __staticInitializer__() {
        KEY_DELETE = new int[]{-5};
        LONG_PRESSABLE_STATE_SET = new int[]{16843324};
        LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
        MAX_NEARBY_KEYS = 12;
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_inputmethodservice_KeyboardView$__constructor__(context, attributeSet);
    }

    public KeyboardView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1110050);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_KeyboardView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_inputmethodservice_KeyboardView$__constructor__(context, attributeSet, n);
    }

    public KeyboardView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_KeyboardView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_inputmethodservice_KeyboardView$__constructor__(context, attributeSet, n, n2);
    }

    public KeyboardView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_KeyboardView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_inputmethodservice_KeyboardView$onAttachedToWindow(), 0, this);
    }

    private void initGestureDetector() {
        InvokeDynamicSupport.bootstrap("initGestureDetector", $$robo$$android_inputmethodservice_KeyboardView$initGestureDetector(), 0, this);
    }

    public void setOnKeyboardActionListener(OnKeyboardActionListener onKeyboardActionListener) {
        InvokeDynamicSupport.bootstrap("setOnKeyboardActionListener", $$robo$$android_inputmethodservice_KeyboardView$setOnKeyboardActionListener(android.inputmethodservice.KeyboardView$OnKeyboardActionListener ), 0, this, onKeyboardActionListener);
    }

    protected OnKeyboardActionListener getOnKeyboardActionListener() {
        return InvokeDynamicSupport.bootstrap("getOnKeyboardActionListener", $$robo$$android_inputmethodservice_KeyboardView$getOnKeyboardActionListener(), 0, this);
    }

    public void setKeyboard(Keyboard keyboard) {
        InvokeDynamicSupport.bootstrap("setKeyboard", $$robo$$android_inputmethodservice_KeyboardView$setKeyboard(android.inputmethodservice.Keyboard ), 0, this, keyboard);
    }

    public Keyboard getKeyboard() {
        return InvokeDynamicSupport.bootstrap("getKeyboard", $$robo$$android_inputmethodservice_KeyboardView$getKeyboard(), 0, this);
    }

    public boolean setShifted(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setShifted", $$robo$$android_inputmethodservice_KeyboardView$setShifted(boolean ), 0, this, bl);
    }

    public boolean isShifted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShifted", $$robo$$android_inputmethodservice_KeyboardView$isShifted(), 0, this);
    }

    public void setPreviewEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPreviewEnabled", $$robo$$android_inputmethodservice_KeyboardView$setPreviewEnabled(boolean ), 0, this, bl);
    }

    public boolean isPreviewEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPreviewEnabled", $$robo$$android_inputmethodservice_KeyboardView$isPreviewEnabled(), 0, this);
    }

    public void setVerticalCorrection(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalCorrection", $$robo$$android_inputmethodservice_KeyboardView$setVerticalCorrection(int ), 0, this, n);
    }

    public void setPopupParent(View view) {
        InvokeDynamicSupport.bootstrap("setPopupParent", $$robo$$android_inputmethodservice_KeyboardView$setPopupParent(android.view.View ), 0, this, view);
    }

    public void setPopupOffset(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setPopupOffset", $$robo$$android_inputmethodservice_KeyboardView$setPopupOffset(int int ), 0, this, n, n2);
    }

    public void setProximityCorrectionEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setProximityCorrectionEnabled", $$robo$$android_inputmethodservice_KeyboardView$setProximityCorrectionEnabled(boolean ), 0, this, bl);
    }

    public boolean isProximityCorrectionEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProximityCorrectionEnabled", $$robo$$android_inputmethodservice_KeyboardView$isProximityCorrectionEnabled(), 0, this);
    }

    @Override
    public void onClick(View view) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_inputmethodservice_KeyboardView$onClick(android.view.View ), 0, this, view);
    }

    private CharSequence adjustCase(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("adjustCase", $$robo$$android_inputmethodservice_KeyboardView$adjustCase(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_inputmethodservice_KeyboardView$onMeasure(int int ), 0, this, n, n2);
    }

    private void computeProximityThreshold(Keyboard keyboard) {
        InvokeDynamicSupport.bootstrap("computeProximityThreshold", $$robo$$android_inputmethodservice_KeyboardView$computeProximityThreshold(android.inputmethodservice.Keyboard ), 0, this, keyboard);
    }

    @Override
    public void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_inputmethodservice_KeyboardView$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_inputmethodservice_KeyboardView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    private void onBufferDraw() {
        InvokeDynamicSupport.bootstrap("onBufferDraw", $$robo$$android_inputmethodservice_KeyboardView$onBufferDraw(), 0, this);
    }

    private int getKeyIndices(int n, int n2, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("getKeyIndices", $$robo$$android_inputmethodservice_KeyboardView$getKeyIndices(int int int[] ), 0, this, n, n2, nArray);
    }

    private void detectAndSendKey(int n, int n2, int n3, long l) {
        InvokeDynamicSupport.bootstrap("detectAndSendKey", $$robo$$android_inputmethodservice_KeyboardView$detectAndSendKey(int int int long ), 0, this, n, n2, n3, l);
    }

    private CharSequence getPreviewText(Keyboard.Key key) {
        return InvokeDynamicSupport.bootstrap("getPreviewText", $$robo$$android_inputmethodservice_KeyboardView$getPreviewText(android.inputmethodservice.Keyboard$Key ), 0, this, key);
    }

    private void showPreview(int n) {
        InvokeDynamicSupport.bootstrap("showPreview", $$robo$$android_inputmethodservice_KeyboardView$showPreview(int ), 0, this, n);
    }

    private void showKey(int n) {
        InvokeDynamicSupport.bootstrap("showKey", $$robo$$android_inputmethodservice_KeyboardView$showKey(int ), 0, this, n);
    }

    private void sendAccessibilityEventForUnicodeCharacter(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEventForUnicodeCharacter", $$robo$$android_inputmethodservice_KeyboardView$sendAccessibilityEventForUnicodeCharacter(int int ), 0, this, n, n2);
    }

    public void invalidateAllKeys() {
        InvokeDynamicSupport.bootstrap("invalidateAllKeys", $$robo$$android_inputmethodservice_KeyboardView$invalidateAllKeys(), 0, this);
    }

    public void invalidateKey(int n) {
        InvokeDynamicSupport.bootstrap("invalidateKey", $$robo$$android_inputmethodservice_KeyboardView$invalidateKey(int ), 0, this, n);
    }

    private boolean openPopupIfRequired(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("openPopupIfRequired", $$robo$$android_inputmethodservice_KeyboardView$openPopupIfRequired(android.view.MotionEvent ), 0, this, motionEvent);
    }

    protected boolean onLongPress(Keyboard.Key key) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLongPress", $$robo$$android_inputmethodservice_KeyboardView$onLongPress(android.inputmethodservice.Keyboard$Key ), 0, this, key);
    }

    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onHoverEvent", $$robo$$android_inputmethodservice_KeyboardView$onHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_inputmethodservice_KeyboardView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private boolean onModifiedTouchEvent(MotionEvent motionEvent, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onModifiedTouchEvent", $$robo$$android_inputmethodservice_KeyboardView$onModifiedTouchEvent(android.view.MotionEvent boolean ), 0, this, motionEvent, bl);
    }

    private boolean repeatKey() {
        return (boolean)InvokeDynamicSupport.bootstrap("repeatKey", $$robo$$android_inputmethodservice_KeyboardView$repeatKey(), 0, this);
    }

    protected void swipeRight() {
        InvokeDynamicSupport.bootstrap("swipeRight", $$robo$$android_inputmethodservice_KeyboardView$swipeRight(), 0, this);
    }

    protected void swipeLeft() {
        InvokeDynamicSupport.bootstrap("swipeLeft", $$robo$$android_inputmethodservice_KeyboardView$swipeLeft(), 0, this);
    }

    protected void swipeUp() {
        InvokeDynamicSupport.bootstrap("swipeUp", $$robo$$android_inputmethodservice_KeyboardView$swipeUp(), 0, this);
    }

    protected void swipeDown() {
        InvokeDynamicSupport.bootstrap("swipeDown", $$robo$$android_inputmethodservice_KeyboardView$swipeDown(), 0, this);
    }

    public void closing() {
        InvokeDynamicSupport.bootstrap("closing", $$robo$$android_inputmethodservice_KeyboardView$closing(), 0, this);
    }

    private void removeMessages() {
        InvokeDynamicSupport.bootstrap("removeMessages", $$robo$$android_inputmethodservice_KeyboardView$removeMessages(), 0, this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_inputmethodservice_KeyboardView$onDetachedFromWindow(), 0, this);
    }

    private void dismissPopupKeyboard() {
        InvokeDynamicSupport.bootstrap("dismissPopupKeyboard", $$robo$$android_inputmethodservice_KeyboardView$dismissPopupKeyboard(), 0, this);
    }

    public boolean handleBack() {
        return (boolean)InvokeDynamicSupport.bootstrap("handleBack", $$robo$$android_inputmethodservice_KeyboardView$handleBack(), 0, this);
    }

    private void resetMultiTap() {
        InvokeDynamicSupport.bootstrap("resetMultiTap", $$robo$$android_inputmethodservice_KeyboardView$resetMultiTap(), 0, this);
    }

    private void checkMultiTap(long l, int n) {
        InvokeDynamicSupport.bootstrap("checkMultiTap", $$robo$$android_inputmethodservice_KeyboardView$checkMultiTap(long int ), 0, this, l, n);
    }

    static {
        RobolectricInternals.classInitializing(KeyboardView.class);
    }

    public /* synthetic */ KeyboardView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyboardView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SwipeTracker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int NUM_PAST = 4;
        static int LONGEST_PAST_TIME = 200;
        float[] mPastX;
        float[] mPastY;
        long[] mPastTime;
        float mYVelocity;
        float mXVelocity;

        private void $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$__constructor__() {
            this.mPastX = new float[4];
            this.mPastY = new float[4];
            this.mPastTime = new long[4];
        }

        private final void $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$clear() {
            this.mPastTime[0] = 0L;
        }

        private final void $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$addMovement(MotionEvent ev) {
            long time = ev.getEventTime();
            int N = ev.getHistorySize();
            for (int i = 0; i < N; ++i) {
                this.addPoint(ev.getHistoricalX(i), ev.getHistoricalY(i), ev.getHistoricalEventTime(i));
            }
            this.addPoint(ev.getX(), ev.getY(), time);
        }

        private final void $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$addPoint(float x, float y, long time) {
            int i;
            int drop = -1;
            long[] pastTime = this.mPastTime;
            for (i = 0; i < 4 && pastTime[i] != 0L; ++i) {
                if (pastTime[i] >= time - 200L) continue;
                drop = i;
            }
            if (i == 4 && drop < 0) {
                drop = 0;
            }
            if (drop == i) {
                --drop;
            }
            float[] pastX = this.mPastX;
            float[] pastY = this.mPastY;
            if (drop >= 0) {
                int start = drop + 1;
                int count = 4 - drop - 1;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])pastX, (int)start, (float[])pastX, (int)0, (int)count);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])pastY, (int)start, (float[])pastY, (int)0, (int)count);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])pastTime, (int)start, (long[])pastTime, (int)0, (int)count);
                i -= drop + 1;
            }
            pastX[i] = x;
            pastY[i] = y;
            pastTime[i] = time;
            if (++i < 4) {
                pastTime[i] = 0L;
            }
        }

        private final void $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$computeCurrentVelocity(int units) {
            this.computeCurrentVelocity(units, Float.MAX_VALUE);
        }

        private final void $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$computeCurrentVelocity(int units, float maxVelocity) {
            int N;
            float[] pastX = this.mPastX;
            float[] pastY = this.mPastY;
            long[] pastTime = this.mPastTime;
            float oldestX = pastX[0];
            float oldestY = pastY[0];
            long oldestTime = pastTime[0];
            float accumX = 0.0f;
            float accumY = 0.0f;
            for (N = 0; N < 4 && pastTime[N] != 0L; ++N) {
            }
            for (int i = 1; i < N; ++i) {
                int dur = (int)(pastTime[i] - oldestTime);
                if (dur == 0) continue;
                float dist = pastX[i] - oldestX;
                float vel = dist / (float)dur * (float)units;
                accumX = accumX == 0.0f ? vel : (accumX + vel) * 0.5f;
                dist = pastY[i] - oldestY;
                vel = dist / (float)dur * (float)units;
                accumY = accumY == 0.0f ? vel : (accumY + vel) * 0.5f;
            }
            this.mXVelocity = accumX < 0.0f ? Math.max(accumX, -maxVelocity) : Math.min(accumX, maxVelocity);
            this.mYVelocity = accumY < 0.0f ? Math.max(accumY, -maxVelocity) : Math.min(accumY, maxVelocity);
        }

        private final float $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$getXVelocity() {
            return this.mXVelocity;
        }

        private final float $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$getYVelocity() {
            return this.mYVelocity;
        }

        private /* synthetic */ void $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$__constructor__();
        }

        private SwipeTracker() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$__constructor__(), 0, this);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$clear(), 0, this);
        }

        public void addMovement(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("addMovement", $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$addMovement(android.view.MotionEvent ), 0, this, motionEvent);
        }

        private void addPoint(float f, float f2, long l) {
            InvokeDynamicSupport.bootstrap("addPoint", $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$addPoint(float float long ), 0, this, f, f2, l);
        }

        public void computeCurrentVelocity(int n) {
            InvokeDynamicSupport.bootstrap("computeCurrentVelocity", $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$computeCurrentVelocity(int ), 0, this, n);
        }

        public void computeCurrentVelocity(int n, float f) {
            InvokeDynamicSupport.bootstrap("computeCurrentVelocity", $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$computeCurrentVelocity(int float ), 0, this, n, f);
        }

        public float getXVelocity() {
            return (float)InvokeDynamicSupport.bootstrap("getXVelocity", $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$getXVelocity(), 0, this);
        }

        public float getYVelocity() {
            return (float)InvokeDynamicSupport.bootstrap("getYVelocity", $$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$getYVelocity(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_inputmethodservice_KeyboardView_SwipeTracker$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SwipeTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnKeyboardActionListener
    extends InstrumentedInterface {
        public void onPress(int var1);

        public void onRelease(int var1);

        public void onKey(int var1, int[] var2);

        public void onText(CharSequence var1);

        public void swipeLeft();

        public void swipeRight();

        public void swipeDown();

        public void swipeUp();
    }
}

