/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Address
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Locale mLocale;
    private String mFeatureName;
    private HashMap<Integer, String> mAddressLines;
    private int mMaxAddressLineIndex;
    private String mAdminArea;
    private String mSubAdminArea;
    private String mLocality;
    private String mSubLocality;
    private String mThoroughfare;
    private String mSubThoroughfare;
    private String mPremises;
    private String mPostalCode;
    private String mCountryCode;
    private String mCountryName;
    private double mLatitude;
    private double mLongitude;
    private boolean mHasLatitude;
    private boolean mHasLongitude;
    private String mPhone;
    private String mUrl;
    private Bundle mExtras;
    public static Parcelable.Creator<Address> CREATOR;

    private void $$robo$$android_location_Address$__constructor__(Locale locale) {
        this.mMaxAddressLineIndex = -1;
        this.mHasLatitude = false;
        this.mHasLongitude = false;
        this.mExtras = null;
        this.mLocale = locale;
    }

    private final Locale $$robo$$android_location_Address$getLocale() {
        return this.mLocale;
    }

    private final int $$robo$$android_location_Address$getMaxAddressLineIndex() {
        return this.mMaxAddressLineIndex;
    }

    private final String $$robo$$android_location_Address$getAddressLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index = " + index + " < 0");
        }
        return this.mAddressLines == null ? null : this.mAddressLines.get(index);
    }

    private final void $$robo$$android_location_Address$setAddressLine(int index, String line) {
        if (index < 0) {
            throw new IllegalArgumentException("index = " + index + " < 0");
        }
        if (this.mAddressLines == null) {
            this.mAddressLines = new HashMap();
        }
        this.mAddressLines.put(index, line);
        if (line == null) {
            this.mMaxAddressLineIndex = -1;
            for (Integer i : this.mAddressLines.keySet()) {
                this.mMaxAddressLineIndex = Math.max(this.mMaxAddressLineIndex, i);
            }
        } else {
            this.mMaxAddressLineIndex = Math.max(this.mMaxAddressLineIndex, index);
        }
    }

    private final String $$robo$$android_location_Address$getFeatureName() {
        return this.mFeatureName;
    }

    private final void $$robo$$android_location_Address$setFeatureName(String featureName) {
        this.mFeatureName = featureName;
    }

    private final String $$robo$$android_location_Address$getAdminArea() {
        return this.mAdminArea;
    }

    private final void $$robo$$android_location_Address$setAdminArea(String adminArea) {
        this.mAdminArea = adminArea;
    }

    private final String $$robo$$android_location_Address$getSubAdminArea() {
        return this.mSubAdminArea;
    }

    private final void $$robo$$android_location_Address$setSubAdminArea(String subAdminArea) {
        this.mSubAdminArea = subAdminArea;
    }

    private final String $$robo$$android_location_Address$getLocality() {
        return this.mLocality;
    }

    private final void $$robo$$android_location_Address$setLocality(String locality) {
        this.mLocality = locality;
    }

    private final String $$robo$$android_location_Address$getSubLocality() {
        return this.mSubLocality;
    }

    private final void $$robo$$android_location_Address$setSubLocality(String sublocality) {
        this.mSubLocality = sublocality;
    }

    private final String $$robo$$android_location_Address$getThoroughfare() {
        return this.mThoroughfare;
    }

    private final void $$robo$$android_location_Address$setThoroughfare(String thoroughfare) {
        this.mThoroughfare = thoroughfare;
    }

    private final String $$robo$$android_location_Address$getSubThoroughfare() {
        return this.mSubThoroughfare;
    }

    private final void $$robo$$android_location_Address$setSubThoroughfare(String subthoroughfare) {
        this.mSubThoroughfare = subthoroughfare;
    }

    private final String $$robo$$android_location_Address$getPremises() {
        return this.mPremises;
    }

    private final void $$robo$$android_location_Address$setPremises(String premises) {
        this.mPremises = premises;
    }

    private final String $$robo$$android_location_Address$getPostalCode() {
        return this.mPostalCode;
    }

    private final void $$robo$$android_location_Address$setPostalCode(String postalCode) {
        this.mPostalCode = postalCode;
    }

    private final String $$robo$$android_location_Address$getCountryCode() {
        return this.mCountryCode;
    }

    private final void $$robo$$android_location_Address$setCountryCode(String countryCode) {
        this.mCountryCode = countryCode;
    }

    private final String $$robo$$android_location_Address$getCountryName() {
        return this.mCountryName;
    }

    private final void $$robo$$android_location_Address$setCountryName(String countryName) {
        this.mCountryName = countryName;
    }

    private final boolean $$robo$$android_location_Address$hasLatitude() {
        return this.mHasLatitude;
    }

    private final double $$robo$$android_location_Address$getLatitude() {
        if (this.mHasLatitude) {
            return this.mLatitude;
        }
        throw new IllegalStateException();
    }

    private final void $$robo$$android_location_Address$setLatitude(double latitude) {
        this.mLatitude = latitude;
        this.mHasLatitude = true;
    }

    private final void $$robo$$android_location_Address$clearLatitude() {
        this.mHasLatitude = false;
    }

    private final boolean $$robo$$android_location_Address$hasLongitude() {
        return this.mHasLongitude;
    }

    private final double $$robo$$android_location_Address$getLongitude() {
        if (this.mHasLongitude) {
            return this.mLongitude;
        }
        throw new IllegalStateException();
    }

    private final void $$robo$$android_location_Address$setLongitude(double longitude) {
        this.mLongitude = longitude;
        this.mHasLongitude = true;
    }

    private final void $$robo$$android_location_Address$clearLongitude() {
        this.mHasLongitude = false;
    }

    private final String $$robo$$android_location_Address$getPhone() {
        return this.mPhone;
    }

    private final void $$robo$$android_location_Address$setPhone(String phone) {
        this.mPhone = phone;
    }

    private final String $$robo$$android_location_Address$getUrl() {
        return this.mUrl;
    }

    private final void $$robo$$android_location_Address$setUrl(String Url) {
        this.mUrl = Url;
    }

    private final Bundle $$robo$$android_location_Address$getExtras() {
        return this.mExtras;
    }

    private final void $$robo$$android_location_Address$setExtras(Bundle extras) {
        this.mExtras = extras == null ? null : new Bundle(extras);
    }

    private final String $$robo$$android_location_Address$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Address[addressLines=[");
        for (int i = 0; i <= this.mMaxAddressLineIndex; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(i);
            sb.append(':');
            String line = this.mAddressLines.get(i);
            if (line == null) {
                sb.append("null");
                continue;
            }
            sb.append('\"');
            sb.append(line);
            sb.append('\"');
        }
        sb.append(']');
        sb.append(",feature=");
        sb.append(this.mFeatureName);
        sb.append(",admin=");
        sb.append(this.mAdminArea);
        sb.append(",sub-admin=");
        sb.append(this.mSubAdminArea);
        sb.append(",locality=");
        sb.append(this.mLocality);
        sb.append(",thoroughfare=");
        sb.append(this.mThoroughfare);
        sb.append(",postalCode=");
        sb.append(this.mPostalCode);
        sb.append(",countryCode=");
        sb.append(this.mCountryCode);
        sb.append(",countryName=");
        sb.append(this.mCountryName);
        sb.append(",hasLatitude=");
        sb.append(this.mHasLatitude);
        sb.append(",latitude=");
        sb.append(this.mLatitude);
        sb.append(",hasLongitude=");
        sb.append(this.mHasLongitude);
        sb.append(",longitude=");
        sb.append(this.mLongitude);
        sb.append(",phone=");
        sb.append(this.mPhone);
        sb.append(",url=");
        sb.append(this.mUrl);
        sb.append(",extras=");
        sb.append(this.mExtras);
        sb.append(']');
        return sb.toString();
    }

    private final int $$robo$$android_location_Address$describeContents() {
        return this.mExtras != null ? this.mExtras.describeContents() : 0;
    }

    private final void $$robo$$android_location_Address$writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mLocale.getLanguage());
        parcel.writeString(this.mLocale.getCountry());
        if (this.mAddressLines == null) {
            parcel.writeInt(0);
        } else {
            Set<Map.Entry<Integer, String>> entries = this.mAddressLines.entrySet();
            parcel.writeInt(entries.size());
            for (Map.Entry<Integer, String> e : entries) {
                parcel.writeInt(e.getKey());
                parcel.writeString(e.getValue());
            }
        }
        parcel.writeString(this.mFeatureName);
        parcel.writeString(this.mAdminArea);
        parcel.writeString(this.mSubAdminArea);
        parcel.writeString(this.mLocality);
        parcel.writeString(this.mSubLocality);
        parcel.writeString(this.mThoroughfare);
        parcel.writeString(this.mSubThoroughfare);
        parcel.writeString(this.mPremises);
        parcel.writeString(this.mPostalCode);
        parcel.writeString(this.mCountryCode);
        parcel.writeString(this.mCountryName);
        parcel.writeInt(this.mHasLatitude ? 1 : 0);
        if (this.mHasLatitude) {
            parcel.writeDouble(this.mLatitude);
        }
        parcel.writeInt(this.mHasLongitude ? 1 : 0);
        if (this.mHasLongitude) {
            parcel.writeDouble(this.mLongitude);
        }
        parcel.writeString(this.mPhone);
        parcel.writeString(this.mUrl);
        parcel.writeBundle(this.mExtras);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Address>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_location_Address_1$__constructor__() {
            }

            private final Address $$robo$$android_location_Address_1$createFromParcel(Parcel in) {
                String language = in.readString();
                String country = in.readString();
                Locale locale = country.length() > 0 ? new Locale(language, country) : new Locale(language);
                Address a = new Address(locale);
                int N = in.readInt();
                if (N > 0) {
                    a.mAddressLines = new HashMap(N);
                    for (int i = 0; i < N; ++i) {
                        int index = in.readInt();
                        String line = in.readString();
                        a.mAddressLines.put(index, line);
                        a.mMaxAddressLineIndex = Math.max(a.mMaxAddressLineIndex, index);
                    }
                } else {
                    a.mAddressLines = null;
                    a.mMaxAddressLineIndex = -1;
                }
                a.mFeatureName = in.readString();
                a.mAdminArea = in.readString();
                a.mSubAdminArea = in.readString();
                a.mLocality = in.readString();
                a.mSubLocality = in.readString();
                a.mThoroughfare = in.readString();
                a.mSubThoroughfare = in.readString();
                a.mPremises = in.readString();
                a.mPostalCode = in.readString();
                a.mCountryCode = in.readString();
                a.mCountryName = in.readString();
                a.mHasLatitude = in.readInt() != 0;
                if (a.mHasLatitude) {
                    a.mLatitude = in.readDouble();
                }
                a.mHasLongitude = in.readInt() != 0;
                if (a.mHasLongitude) {
                    a.mLongitude = in.readDouble();
                }
                a.mPhone = in.readString();
                a.mUrl = in.readString();
                a.mExtras = in.readBundle();
                return a;
            }

            private final Address[] $$robo$$android_location_Address_1$newArray(int size) {
                return new Address[size];
            }

            private void __constructor__() {
                this.$$robo$$android_location_Address_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Address_1$__constructor__(), 0, this);
            }

            @Override
            public Address createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_location_Address_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Address[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_location_Address_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_location_Address$__constructor__(locale);
    }

    public Address(Locale locale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Address$__constructor__(java.util.Locale ), 0, this, locale);
    }

    public Locale getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_location_Address$getLocale(), 0, this);
    }

    public int getMaxAddressLineIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxAddressLineIndex", $$robo$$android_location_Address$getMaxAddressLineIndex(), 0, this);
    }

    public String getAddressLine(int n) {
        return InvokeDynamicSupport.bootstrap("getAddressLine", $$robo$$android_location_Address$getAddressLine(int ), 0, this, n);
    }

    public void setAddressLine(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setAddressLine", $$robo$$android_location_Address$setAddressLine(int java.lang.String ), 0, this, n, string2);
    }

    public String getFeatureName() {
        return InvokeDynamicSupport.bootstrap("getFeatureName", $$robo$$android_location_Address$getFeatureName(), 0, this);
    }

    public void setFeatureName(String string2) {
        InvokeDynamicSupport.bootstrap("setFeatureName", $$robo$$android_location_Address$setFeatureName(java.lang.String ), 0, this, string2);
    }

    public String getAdminArea() {
        return InvokeDynamicSupport.bootstrap("getAdminArea", $$robo$$android_location_Address$getAdminArea(), 0, this);
    }

    public void setAdminArea(String string2) {
        InvokeDynamicSupport.bootstrap("setAdminArea", $$robo$$android_location_Address$setAdminArea(java.lang.String ), 0, this, string2);
    }

    public String getSubAdminArea() {
        return InvokeDynamicSupport.bootstrap("getSubAdminArea", $$robo$$android_location_Address$getSubAdminArea(), 0, this);
    }

    public void setSubAdminArea(String string2) {
        InvokeDynamicSupport.bootstrap("setSubAdminArea", $$robo$$android_location_Address$setSubAdminArea(java.lang.String ), 0, this, string2);
    }

    public String getLocality() {
        return InvokeDynamicSupport.bootstrap("getLocality", $$robo$$android_location_Address$getLocality(), 0, this);
    }

    public void setLocality(String string2) {
        InvokeDynamicSupport.bootstrap("setLocality", $$robo$$android_location_Address$setLocality(java.lang.String ), 0, this, string2);
    }

    public String getSubLocality() {
        return InvokeDynamicSupport.bootstrap("getSubLocality", $$robo$$android_location_Address$getSubLocality(), 0, this);
    }

    public void setSubLocality(String string2) {
        InvokeDynamicSupport.bootstrap("setSubLocality", $$robo$$android_location_Address$setSubLocality(java.lang.String ), 0, this, string2);
    }

    public String getThoroughfare() {
        return InvokeDynamicSupport.bootstrap("getThoroughfare", $$robo$$android_location_Address$getThoroughfare(), 0, this);
    }

    public void setThoroughfare(String string2) {
        InvokeDynamicSupport.bootstrap("setThoroughfare", $$robo$$android_location_Address$setThoroughfare(java.lang.String ), 0, this, string2);
    }

    public String getSubThoroughfare() {
        return InvokeDynamicSupport.bootstrap("getSubThoroughfare", $$robo$$android_location_Address$getSubThoroughfare(), 0, this);
    }

    public void setSubThoroughfare(String string2) {
        InvokeDynamicSupport.bootstrap("setSubThoroughfare", $$robo$$android_location_Address$setSubThoroughfare(java.lang.String ), 0, this, string2);
    }

    public String getPremises() {
        return InvokeDynamicSupport.bootstrap("getPremises", $$robo$$android_location_Address$getPremises(), 0, this);
    }

    public void setPremises(String string2) {
        InvokeDynamicSupport.bootstrap("setPremises", $$robo$$android_location_Address$setPremises(java.lang.String ), 0, this, string2);
    }

    public String getPostalCode() {
        return InvokeDynamicSupport.bootstrap("getPostalCode", $$robo$$android_location_Address$getPostalCode(), 0, this);
    }

    public void setPostalCode(String string2) {
        InvokeDynamicSupport.bootstrap("setPostalCode", $$robo$$android_location_Address$setPostalCode(java.lang.String ), 0, this, string2);
    }

    public String getCountryCode() {
        return InvokeDynamicSupport.bootstrap("getCountryCode", $$robo$$android_location_Address$getCountryCode(), 0, this);
    }

    public void setCountryCode(String string2) {
        InvokeDynamicSupport.bootstrap("setCountryCode", $$robo$$android_location_Address$setCountryCode(java.lang.String ), 0, this, string2);
    }

    public String getCountryName() {
        return InvokeDynamicSupport.bootstrap("getCountryName", $$robo$$android_location_Address$getCountryName(), 0, this);
    }

    public void setCountryName(String string2) {
        InvokeDynamicSupport.bootstrap("setCountryName", $$robo$$android_location_Address$setCountryName(java.lang.String ), 0, this, string2);
    }

    public boolean hasLatitude() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasLatitude", $$robo$$android_location_Address$hasLatitude(), 0, this);
    }

    public double getLatitude() {
        return (double)InvokeDynamicSupport.bootstrap("getLatitude", $$robo$$android_location_Address$getLatitude(), 0, this);
    }

    public void setLatitude(double d) {
        InvokeDynamicSupport.bootstrap("setLatitude", $$robo$$android_location_Address$setLatitude(double ), 0, this, d);
    }

    public void clearLatitude() {
        InvokeDynamicSupport.bootstrap("clearLatitude", $$robo$$android_location_Address$clearLatitude(), 0, this);
    }

    public boolean hasLongitude() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasLongitude", $$robo$$android_location_Address$hasLongitude(), 0, this);
    }

    public double getLongitude() {
        return (double)InvokeDynamicSupport.bootstrap("getLongitude", $$robo$$android_location_Address$getLongitude(), 0, this);
    }

    public void setLongitude(double d) {
        InvokeDynamicSupport.bootstrap("setLongitude", $$robo$$android_location_Address$setLongitude(double ), 0, this, d);
    }

    public void clearLongitude() {
        InvokeDynamicSupport.bootstrap("clearLongitude", $$robo$$android_location_Address$clearLongitude(), 0, this);
    }

    public String getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$android_location_Address$getPhone(), 0, this);
    }

    public void setPhone(String string2) {
        InvokeDynamicSupport.bootstrap("setPhone", $$robo$$android_location_Address$setPhone(java.lang.String ), 0, this, string2);
    }

    public String getUrl() {
        return InvokeDynamicSupport.bootstrap("getUrl", $$robo$$android_location_Address$getUrl(), 0, this);
    }

    public void setUrl(String string2) {
        InvokeDynamicSupport.bootstrap("setUrl", $$robo$$android_location_Address$setUrl(java.lang.String ), 0, this, string2);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_location_Address$getExtras(), 0, this);
    }

    public void setExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_location_Address$setExtras(android.os.Bundle ), 0, this, bundle);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_location_Address$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_location_Address$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_location_Address$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(Address.class);
    }

    public /* synthetic */ Address() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Address)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

