/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.IntDef;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AudioFormat
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ENCODING_INVALID = 0;
    public static int ENCODING_DEFAULT = 1;
    public static int ENCODING_PCM_16BIT = 2;
    public static int ENCODING_PCM_8BIT = 3;
    public static int ENCODING_PCM_FLOAT = 4;
    public static int ENCODING_AC3 = 5;
    public static int ENCODING_E_AC3 = 6;
    public static int ENCODING_DTS = 7;
    public static int ENCODING_DTS_HD = 8;
    public static int ENCODING_MP3 = 9;
    public static int ENCODING_AAC_LC = 10;
    public static int ENCODING_AAC_HE_V1 = 11;
    public static int ENCODING_AAC_HE_V2 = 12;
    public static int ENCODING_IEC61937 = 13;
    public static int ENCODING_DOLBY_TRUEHD = 14;
    @Deprecated
    public static int CHANNEL_CONFIGURATION_INVALID = 0;
    @Deprecated
    public static int CHANNEL_CONFIGURATION_DEFAULT = 1;
    @Deprecated
    public static int CHANNEL_CONFIGURATION_MONO = 2;
    @Deprecated
    public static int CHANNEL_CONFIGURATION_STEREO = 3;
    public static int CHANNEL_INVALID = 0;
    public static int CHANNEL_OUT_DEFAULT = 1;
    public static int CHANNEL_OUT_FRONT_LEFT = 4;
    public static int CHANNEL_OUT_FRONT_RIGHT = 8;
    public static int CHANNEL_OUT_FRONT_CENTER = 16;
    public static int CHANNEL_OUT_LOW_FREQUENCY = 32;
    public static int CHANNEL_OUT_BACK_LEFT = 64;
    public static int CHANNEL_OUT_BACK_RIGHT = 128;
    public static int CHANNEL_OUT_FRONT_LEFT_OF_CENTER = 256;
    public static int CHANNEL_OUT_FRONT_RIGHT_OF_CENTER = 512;
    public static int CHANNEL_OUT_BACK_CENTER = 1024;
    public static int CHANNEL_OUT_SIDE_LEFT = 2048;
    public static int CHANNEL_OUT_SIDE_RIGHT = 4096;
    public static int CHANNEL_OUT_TOP_CENTER = 8192;
    public static int CHANNEL_OUT_TOP_FRONT_LEFT = 16384;
    public static int CHANNEL_OUT_TOP_FRONT_CENTER = 32768;
    public static int CHANNEL_OUT_TOP_FRONT_RIGHT = 65536;
    public static int CHANNEL_OUT_TOP_BACK_LEFT = 131072;
    public static int CHANNEL_OUT_TOP_BACK_CENTER = 262144;
    public static int CHANNEL_OUT_TOP_BACK_RIGHT = 524288;
    public static int CHANNEL_OUT_MONO = 4;
    public static int CHANNEL_OUT_STEREO = 12;
    public static int CHANNEL_OUT_QUAD = 204;
    public static int CHANNEL_OUT_QUAD_SIDE = 6156;
    public static int CHANNEL_OUT_SURROUND = 1052;
    public static int CHANNEL_OUT_5POINT1 = 252;
    public static int CHANNEL_OUT_5POINT1_SIDE = 6204;
    @Deprecated
    public static int CHANNEL_OUT_7POINT1 = 1020;
    public static int CHANNEL_OUT_7POINT1_SURROUND = 6396;
    public static int SAMPLE_RATE_HZ_MIN = 4000;
    public static int SAMPLE_RATE_HZ_MAX = 192000;
    public static int SAMPLE_RATE_UNSPECIFIED = 0;
    public static int CHANNEL_IN_DEFAULT = 1;
    public static int CHANNEL_IN_LEFT = 4;
    public static int CHANNEL_IN_RIGHT = 8;
    public static int CHANNEL_IN_FRONT = 16;
    public static int CHANNEL_IN_BACK = 32;
    public static int CHANNEL_IN_LEFT_PROCESSED = 64;
    public static int CHANNEL_IN_RIGHT_PROCESSED = 128;
    public static int CHANNEL_IN_FRONT_PROCESSED = 256;
    public static int CHANNEL_IN_BACK_PROCESSED = 512;
    public static int CHANNEL_IN_PRESSURE = 1024;
    public static int CHANNEL_IN_X_AXIS = 2048;
    public static int CHANNEL_IN_Y_AXIS = 4096;
    public static int CHANNEL_IN_Z_AXIS = 8192;
    public static int CHANNEL_IN_VOICE_UPLINK = 16384;
    public static int CHANNEL_IN_VOICE_DNLINK = 32768;
    public static int CHANNEL_IN_MONO = 16;
    public static int CHANNEL_IN_STEREO = 12;
    public static int CHANNEL_IN_FRONT_BACK = 48;
    public static int AUDIO_FORMAT_HAS_PROPERTY_NONE = 0;
    public static int AUDIO_FORMAT_HAS_PROPERTY_ENCODING = 1;
    public static int AUDIO_FORMAT_HAS_PROPERTY_SAMPLE_RATE = 2;
    public static int AUDIO_FORMAT_HAS_PROPERTY_CHANNEL_MASK = 4;
    public static int AUDIO_FORMAT_HAS_PROPERTY_CHANNEL_INDEX_MASK = 8;
    private int mEncoding;
    private int mSampleRate;
    private int mChannelMask;
    private int mChannelIndexMask;
    private int mPropertySetMask;
    public static Parcelable.Creator<AudioFormat> CREATOR;

    private static final int $$robo$$android_media_AudioFormat$inChannelMaskFromOutChannelMask(int outMask) throws IllegalArgumentException {
        if (outMask == 1) {
            throw new IllegalArgumentException("Illegal CHANNEL_OUT_DEFAULT channel mask for input.");
        }
        switch (AudioFormat.channelCountFromOutChannelMask(outMask)) {
            case 1: {
                return 16;
            }
            case 2: {
                return 12;
            }
        }
        throw new IllegalArgumentException("Unsupported channel configuration for input.");
    }

    private static final int $$robo$$android_media_AudioFormat$channelCountFromInChannelMask(int mask) {
        return Integer.bitCount(mask);
    }

    private static final int $$robo$$android_media_AudioFormat$channelCountFromOutChannelMask(int mask) {
        return Integer.bitCount(mask);
    }

    private static final int $$robo$$android_media_AudioFormat$convertChannelOutMaskToNativeMask(int javaMask) {
        return javaMask >> 2;
    }

    private static final int $$robo$$android_media_AudioFormat$convertNativeChannelMaskToOutMask(int nativeMask) {
        return nativeMask << 2;
    }

    private static final int $$robo$$android_media_AudioFormat$getBytesPerSample(int audioFormat) {
        switch (audioFormat) {
            case 3: {
                return 1;
            }
            case 1: 
            case 2: 
            case 13: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Bad audio format " + audioFormat);
    }

    private static final boolean $$robo$$android_media_AudioFormat$isValidEncoding(int audioFormat) {
        switch (audioFormat) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private static final boolean $$robo$$android_media_AudioFormat$isPublicEncoding(int audioFormat) {
        switch (audioFormat) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private static final boolean $$robo$$android_media_AudioFormat$isEncodingLinearPcm(int audioFormat) {
        switch (audioFormat) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return false;
            }
        }
        throw new IllegalArgumentException("Bad audio format " + audioFormat);
    }

    private static final boolean $$robo$$android_media_AudioFormat$isEncodingLinearFrames(int audioFormat) {
        switch (audioFormat) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
        }
        throw new IllegalArgumentException("Bad audio format " + audioFormat);
    }

    private static final int[] $$robo$$android_media_AudioFormat$filterPublicFormats(int[] formats) {
        if (formats == null) {
            return null;
        }
        int[] myCopy = Arrays.copyOf(formats, formats.length);
        int size = 0;
        for (int i = 0; i < myCopy.length; ++i) {
            if (!AudioFormat.isPublicEncoding(myCopy[i])) continue;
            if (size != i) {
                myCopy[size] = myCopy[i];
            }
            ++size;
        }
        return Arrays.copyOf(myCopy, size);
    }

    private void $$robo$$android_media_AudioFormat$__constructor__() {
        throw new UnsupportedOperationException("There is no valid usage of this constructor");
    }

    private void $$robo$$android_media_AudioFormat$__constructor__(int ignoredArgument) {
    }

    private void $$robo$$android_media_AudioFormat$__constructor__(int encoding, int sampleRate, int channelMask, int channelIndexMask) {
        this.mEncoding = encoding;
        this.mSampleRate = sampleRate;
        this.mChannelMask = channelMask;
        this.mChannelIndexMask = channelIndexMask;
        this.mPropertySetMask = 15;
    }

    private final int $$robo$$android_media_AudioFormat$getEncoding() {
        if ((this.mPropertySetMask & 1) == 0) {
            return 0;
        }
        return this.mEncoding;
    }

    private final int $$robo$$android_media_AudioFormat$getSampleRate() {
        return this.mSampleRate;
    }

    private final int $$robo$$android_media_AudioFormat$getChannelMask() {
        if ((this.mPropertySetMask & 4) == 0) {
            return 0;
        }
        return this.mChannelMask;
    }

    private final int $$robo$$android_media_AudioFormat$getChannelIndexMask() {
        if ((this.mPropertySetMask & 8) == 0) {
            return 0;
        }
        return this.mChannelIndexMask;
    }

    private final int $$robo$$android_media_AudioFormat$getChannelCount() {
        int channelIndexCount = Integer.bitCount(this.getChannelIndexMask());
        int channelCount = AudioFormat.channelCountFromOutChannelMask(this.getChannelMask());
        if (channelCount == 0) {
            channelCount = channelIndexCount;
        } else if (channelCount != channelIndexCount && channelIndexCount != 0) {
            channelCount = 0;
        }
        return channelCount;
    }

    private final int $$robo$$android_media_AudioFormat$getPropertySetMask() {
        return this.mPropertySetMask;
    }

    private final boolean $$robo$$android_media_AudioFormat$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioFormat that = (AudioFormat)o;
        if (this.mPropertySetMask != that.mPropertySetMask) {
            return false;
        }
        return !((this.mPropertySetMask & 1) != 0 && this.mEncoding != that.mEncoding || (this.mPropertySetMask & 2) != 0 && this.mSampleRate != that.mSampleRate || (this.mPropertySetMask & 4) != 0 && this.mChannelMask != that.mChannelMask || (this.mPropertySetMask & 8) != 0 && this.mChannelIndexMask != that.mChannelIndexMask);
    }

    private final int $$robo$$android_media_AudioFormat$hashCode() {
        return Objects.hash(this.mPropertySetMask, this.mSampleRate, this.mEncoding, this.mChannelMask, this.mChannelIndexMask);
    }

    private final int $$robo$$android_media_AudioFormat$describeContents() {
        return 0;
    }

    private final void $$robo$$android_media_AudioFormat$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPropertySetMask);
        dest.writeInt(this.mEncoding);
        dest.writeInt(this.mSampleRate);
        dest.writeInt(this.mChannelMask);
        dest.writeInt(this.mChannelIndexMask);
    }

    private void $$robo$$android_media_AudioFormat$__constructor__(Parcel in) {
        this.mPropertySetMask = in.readInt();
        this.mEncoding = in.readInt();
        this.mSampleRate = in.readInt();
        this.mChannelMask = in.readInt();
        this.mChannelIndexMask = in.readInt();
    }

    private final String $$robo$$android_media_AudioFormat$toString() {
        return new String("AudioFormat: props=" + this.mPropertySetMask + " enc=" + this.mEncoding + " chan=0x" + Integer.toHexString(this.mChannelMask).toUpperCase() + " chan_index=0x" + Integer.toHexString(this.mChannelIndexMask).toUpperCase() + " rate=" + this.mSampleRate);
    }

    private /* synthetic */ void $$robo$$android_media_AudioFormat$__constructor__(int x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_media_AudioFormat$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AudioFormat>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_AudioFormat_1$__constructor__() {
            }

            private final AudioFormat $$robo$$android_media_AudioFormat_1$createFromParcel(Parcel p) {
                return new AudioFormat(p);
            }

            private final AudioFormat[] $$robo$$android_media_AudioFormat_1$newArray(int size) {
                return new AudioFormat[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_AudioFormat_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFormat_1$__constructor__(), 0, this);
            }

            @Override
            public AudioFormat createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_AudioFormat_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AudioFormat[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_AudioFormat_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static int inChannelMaskFromOutChannelMask(int n) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("inChannelMaskFromOutChannelMask", $$robo$$android_media_AudioFormat$inChannelMaskFromOutChannelMask(int ), 0, (int)n);
    }

    public static int channelCountFromInChannelMask(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("channelCountFromInChannelMask", $$robo$$android_media_AudioFormat$channelCountFromInChannelMask(int ), 0, (int)n);
    }

    public static int channelCountFromOutChannelMask(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("channelCountFromOutChannelMask", $$robo$$android_media_AudioFormat$channelCountFromOutChannelMask(int ), 0, (int)n);
    }

    public static int convertChannelOutMaskToNativeMask(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertChannelOutMaskToNativeMask", $$robo$$android_media_AudioFormat$convertChannelOutMaskToNativeMask(int ), 0, (int)n);
    }

    public static int convertNativeChannelMaskToOutMask(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertNativeChannelMaskToOutMask", $$robo$$android_media_AudioFormat$convertNativeChannelMaskToOutMask(int ), 0, (int)n);
    }

    public static int getBytesPerSample(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBytesPerSample", $$robo$$android_media_AudioFormat$getBytesPerSample(int ), 0, (int)n);
    }

    public static boolean isValidEncoding(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidEncoding", $$robo$$android_media_AudioFormat$isValidEncoding(int ), 0, (int)n);
    }

    public static boolean isPublicEncoding(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPublicEncoding", $$robo$$android_media_AudioFormat$isPublicEncoding(int ), 0, (int)n);
    }

    public static boolean isEncodingLinearPcm(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEncodingLinearPcm", $$robo$$android_media_AudioFormat$isEncodingLinearPcm(int ), 0, (int)n);
    }

    public static boolean isEncodingLinearFrames(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEncodingLinearFrames", $$robo$$android_media_AudioFormat$isEncodingLinearFrames(int ), 0, (int)n);
    }

    public static int[] filterPublicFormats(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("filterPublicFormats", $$robo$$android_media_AudioFormat$filterPublicFormats(int[] ), 0, (int[])nArray);
    }

    private void __constructor__() {
        this.$$robo$$android_media_AudioFormat$__constructor__();
    }

    public AudioFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFormat$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_media_AudioFormat$__constructor__(n);
    }

    private AudioFormat(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFormat$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(int n, int n2, int n3, int n4) {
        this.$$robo$$android_media_AudioFormat$__constructor__(n, n2, n3, n4);
    }

    private AudioFormat(int n, int n2, int n3, int n4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFormat$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
    }

    public int getEncoding() {
        return (int)InvokeDynamicSupport.bootstrap("getEncoding", $$robo$$android_media_AudioFormat$getEncoding(), 0, this);
    }

    public int getSampleRate() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleRate", $$robo$$android_media_AudioFormat$getSampleRate(), 0, this);
    }

    public int getChannelMask() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelMask", $$robo$$android_media_AudioFormat$getChannelMask(), 0, this);
    }

    public int getChannelIndexMask() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelIndexMask", $$robo$$android_media_AudioFormat$getChannelIndexMask(), 0, this);
    }

    public int getChannelCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelCount", $$robo$$android_media_AudioFormat$getChannelCount(), 0, this);
    }

    public int getPropertySetMask() {
        return (int)InvokeDynamicSupport.bootstrap("getPropertySetMask", $$robo$$android_media_AudioFormat$getPropertySetMask(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_AudioFormat$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_AudioFormat$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_AudioFormat$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_AudioFormat$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_AudioFormat$__constructor__(parcel);
    }

    private AudioFormat(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFormat$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_AudioFormat$toString(), 0, this);
    }

    private /* synthetic */ void __constructor__(int n, 1 var2_2) {
        this.$$robo$$android_media_AudioFormat$__constructor__(n, var2_2);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_AudioFormat$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AudioFormat.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioFormat)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 3L, 2L, 4L, 5L, 6L, 7L, 8L, 13L})
    public static @interface Encoding {
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mEncoding;
        private int mSampleRate;
        private int mChannelMask;
        private int mChannelIndexMask;
        private int mPropertySetMask;

        private void $$robo$$android_media_AudioFormat_Builder$__constructor__() {
            this.mEncoding = 0;
            this.mSampleRate = 0;
            this.mChannelMask = 0;
            this.mChannelIndexMask = 0;
            this.mPropertySetMask = 0;
        }

        private void $$robo$$android_media_AudioFormat_Builder$__constructor__(AudioFormat af) {
            this.mEncoding = 0;
            this.mSampleRate = 0;
            this.mChannelMask = 0;
            this.mChannelIndexMask = 0;
            this.mPropertySetMask = 0;
            this.mEncoding = af.mEncoding;
            this.mSampleRate = af.mSampleRate;
            this.mChannelMask = af.mChannelMask;
            this.mChannelIndexMask = af.mChannelIndexMask;
            this.mPropertySetMask = af.mPropertySetMask;
        }

        private final AudioFormat $$robo$$android_media_AudioFormat_Builder$build() {
            AudioFormat af = new AudioFormat(1980);
            af.mEncoding = this.mEncoding;
            af.mSampleRate = this.mSampleRate;
            af.mChannelMask = this.mChannelMask;
            af.mChannelIndexMask = this.mChannelIndexMask;
            af.mPropertySetMask = this.mPropertySetMask;
            return af;
        }

        private final Builder $$robo$$android_media_AudioFormat_Builder$setEncoding(int encoding) throws IllegalArgumentException {
            switch (encoding) {
                case 1: {
                    this.mEncoding = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 13: {
                    this.mEncoding = encoding;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid encoding " + encoding);
                }
            }
            this.mPropertySetMask |= 1;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFormat_Builder$setChannelMask(int channelMask) {
            if (channelMask == 0) {
                throw new IllegalArgumentException("Invalid zero channel mask");
            }
            if (this.mChannelIndexMask != 0 && Integer.bitCount(channelMask) != Integer.bitCount(this.mChannelIndexMask)) {
                throw new IllegalArgumentException("Mismatched channel count for mask " + Integer.toHexString(channelMask).toUpperCase());
            }
            this.mChannelMask = channelMask;
            this.mPropertySetMask |= 4;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFormat_Builder$setChannelIndexMask(int channelIndexMask) {
            if (channelIndexMask == 0) {
                throw new IllegalArgumentException("Invalid zero channel index mask");
            }
            if (this.mChannelMask != 0 && Integer.bitCount(channelIndexMask) != Integer.bitCount(this.mChannelMask)) {
                throw new IllegalArgumentException("Mismatched channel count for index mask " + Integer.toHexString(channelIndexMask).toUpperCase());
            }
            this.mChannelIndexMask = channelIndexMask;
            this.mPropertySetMask |= 8;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFormat_Builder$setSampleRate(int sampleRate) throws IllegalArgumentException {
            if ((sampleRate < 4000 || sampleRate > 192000) && sampleRate != 0) {
                throw new IllegalArgumentException("Invalid sample rate " + sampleRate);
            }
            this.mSampleRate = sampleRate;
            this.mPropertySetMask |= 2;
            return this;
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioFormat_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFormat_Builder$__constructor__(), 0, this);
        }

        private void __constructor__(AudioFormat audioFormat) {
            this.$$robo$$android_media_AudioFormat_Builder$__constructor__(audioFormat);
        }

        public Builder(AudioFormat audioFormat) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFormat_Builder$__constructor__(android.media.AudioFormat ), 0, this, audioFormat);
        }

        public AudioFormat build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_AudioFormat_Builder$build(), 0, this);
        }

        public Builder setEncoding(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setEncoding", $$robo$$android_media_AudioFormat_Builder$setEncoding(int ), 0, this, n);
        }

        public Builder setChannelMask(int n) {
            return InvokeDynamicSupport.bootstrap("setChannelMask", $$robo$$android_media_AudioFormat_Builder$setChannelMask(int ), 0, this, n);
        }

        public Builder setChannelIndexMask(int n) {
            return InvokeDynamicSupport.bootstrap("setChannelIndexMask", $$robo$$android_media_AudioFormat_Builder$setChannelIndexMask(int ), 0, this, n);
        }

        public Builder setSampleRate(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setSampleRate", $$robo$$android_media_AudioFormat_Builder$setSampleRate(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

