/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.ICas;
import android.media.ICasListener;
import android.media.IMediaCasService;
import android.media.MediaCasException;
import android.media.MediaCasStateException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Singleton;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaCas
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaCas";
    private ParcelableCasData mCasData;
    private ICas mICas;
    private EventListener mListener;
    private HandlerThread mHandlerThread;
    private EventHandler mEventHandler;
    private static Singleton<IMediaCasService> gDefault;
    private ICasListener.Stub mBinder;

    private static final IMediaCasService $$robo$$android_media_MediaCas$getService() {
        return gDefault.get();
    }

    private final void $$robo$$android_media_MediaCas$validateInternalStates() {
        if (this.mICas == null) {
            throw new IllegalStateException();
        }
    }

    private final void $$robo$$android_media_MediaCas$cleanupAndRethrowIllegalState() {
        this.mICas = null;
        throw new IllegalStateException();
    }

    private final Session $$robo$$android_media_MediaCas$createFromSessionId(byte[] sessionId) {
        if (sessionId == null || sessionId.length == 0) {
            return null;
        }
        return new Session(this, sessionId);
    }

    private static final boolean $$robo$$android_media_MediaCas$isSystemIdSupported(int CA_system_id) {
        IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                return service.isSystemIdSupported(CA_system_id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    private static final PluginDescriptor[] $$robo$$android_media_MediaCas$enumeratePlugins() {
        IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                ParcelableCasPluginDescriptor[] descriptors = service.enumeratePlugins();
                if (descriptors.length == 0) {
                    return null;
                }
                PluginDescriptor[] results = new PluginDescriptor[descriptors.length];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = descriptors[i];
                }
                return results;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    private void $$robo$$android_media_MediaCas$__constructor__(int CA_system_id) throws MediaCasException.UnsupportedCasException {
        block5: {
            this.mCasData = new ParcelableCasData();
            this.mBinder = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ MediaCas this$0;

                private void $$robo$$android_media_MediaCas_2$__constructor__(MediaCas this$0) {
                }

                private final void $$robo$$android_media_MediaCas_2$onEvent(int event, int arg, byte[] data) throws RemoteException {
                    this.this$0.mEventHandler.sendMessage(this.this$0.mEventHandler.obtainMessage(0, event, arg, data));
                }

                private void __constructor__(MediaCas mediaCas) {
                    this.$$robo$$android_media_MediaCas_2$__constructor__(mediaCas);
                }
                {
                    this.this$0 = mediaCas;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_2$__constructor__(android.media.MediaCas ), 0, this, mediaCas);
                }

                @Override
                public void onEvent(int n, int n2, byte[] byArray) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onEvent", $$robo$$android_media_MediaCas_2$onEvent(int int byte[] ), 0, this, n, n2, byArray);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            try {
                this.mICas = MediaCas.getService().createPlugin(CA_system_id, this.mBinder);
            }
            catch (Exception e) {
                Log.e("MediaCas", "Failed to create plugin: " + e);
                this.mICas = null;
            }
            finally {
                if (this.mICas != null) break block5;
                throw new MediaCasException.UnsupportedCasException("Unsupported CA_system_id " + CA_system_id);
            }
        }
    }

    private final IBinder $$robo$$android_media_MediaCas$getBinder() {
        this.validateInternalStates();
        return this.mICas.asBinder();
    }

    private final void $$robo$$android_media_MediaCas$setEventListener(EventListener listener, Handler handler) {
        Looper looper;
        this.mListener = listener;
        if (this.mListener == null) {
            this.mEventHandler = null;
            return;
        }
        Looper looper2 = looper = handler != null ? handler.getLooper() : null;
        if (looper == null && (looper = Looper.myLooper()) == null && (looper = Looper.getMainLooper()) == null) {
            if (this.mHandlerThread == null || !this.mHandlerThread.isAlive()) {
                this.mHandlerThread = new HandlerThread("MediaCasEventThread", -2);
                this.mHandlerThread.start();
            }
            looper = this.mHandlerThread.getLooper();
        }
        this.mEventHandler = new EventHandler(this, looper);
    }

    private final void $$robo$$android_media_MediaCas$setPrivateData(byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mICas.setPrivateData(data);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final Session $$robo$$android_media_MediaCas$openSession() throws MediaCasException {
        this.validateInternalStates();
        try {
            return this.createFromSessionId(this.mICas.openSession());
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
        return null;
    }

    private final void $$robo$$android_media_MediaCas$processEmm(byte[] data, int offset, int length) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mCasData.set(data, offset, length);
            this.mICas.processEmm(this.mCasData);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final void $$robo$$android_media_MediaCas$processEmm(byte[] data) throws MediaCasException {
        this.processEmm(data, 0, data.length);
    }

    private final void $$robo$$android_media_MediaCas$sendEvent(int event, int arg, byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mICas.sendEvent(event, arg, data);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final void $$robo$$android_media_MediaCas$provision(String provisionString) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mICas.provision(provisionString);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final void $$robo$$android_media_MediaCas$refreshEntitlements(int refreshType, byte[] refreshData) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mICas.refreshEntitlements(refreshType, refreshData);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final void $$robo$$android_media_MediaCas$close() {
        if (this.mICas != null) {
            try {
                this.mICas.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mICas = null;
            }
        }
    }

    private final void $$robo$$android_media_MediaCas$finalize() {
        this.close();
    }

    static void __staticInitializer__() {
        gDefault = new Singleton<IMediaCasService>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_MediaCas_1$__constructor__() {
            }

            private final IMediaCasService $$robo$$android_media_MediaCas_1$create() {
                return IMediaCasService.Stub.asInterface(ServiceManager.getService("media.cas"));
            }

            private void __constructor__() {
                this.$$robo$$android_media_MediaCas_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_1$__constructor__(), 0, this);
            }

            @Override
            protected IMediaCasService create() {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$android_media_MediaCas_1$create(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    static IMediaCasService getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_media_MediaCas$getService(), 0);
    }

    private void validateInternalStates() {
        InvokeDynamicSupport.bootstrap("validateInternalStates", $$robo$$android_media_MediaCas$validateInternalStates(), 0, this);
    }

    private void cleanupAndRethrowIllegalState() {
        InvokeDynamicSupport.bootstrap("cleanupAndRethrowIllegalState", $$robo$$android_media_MediaCas$cleanupAndRethrowIllegalState(), 0, this);
    }

    Session createFromSessionId(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("createFromSessionId", $$robo$$android_media_MediaCas$createFromSessionId(byte[] ), 0, this, byArray);
    }

    public static boolean isSystemIdSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemIdSupported", $$robo$$android_media_MediaCas$isSystemIdSupported(int ), 0, (int)n);
    }

    public static PluginDescriptor[] enumeratePlugins() {
        return InvokeDynamicSupport.bootstrapStatic("enumeratePlugins", $$robo$$android_media_MediaCas$enumeratePlugins(), 0);
    }

    private void __constructor__(int n) throws MediaCasException.UnsupportedCasException {
        this.$$robo$$android_media_MediaCas$__constructor__(n);
    }

    public MediaCas(int n) throws MediaCasException.UnsupportedCasException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas$__constructor__(int ), 0, this, n);
    }

    IBinder getBinder() {
        return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_MediaCas$getBinder(), 0, this);
    }

    public void setEventListener(EventListener eventListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setEventListener", $$robo$$android_media_MediaCas$setEventListener(android.media.MediaCas$EventListener android.os.Handler ), 0, this, eventListener, handler);
    }

    public void setPrivateData(byte[] byArray) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("setPrivateData", $$robo$$android_media_MediaCas$setPrivateData(byte[] ), 0, this, byArray);
    }

    public Session openSession() throws MediaCasException {
        return InvokeDynamicSupport.bootstrap("openSession", $$robo$$android_media_MediaCas$openSession(), 0, this);
    }

    public void processEmm(byte[] byArray, int n, int n2) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("processEmm", $$robo$$android_media_MediaCas$processEmm(byte[] int int ), 0, this, byArray, n, n2);
    }

    public void processEmm(byte[] byArray) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("processEmm", $$robo$$android_media_MediaCas$processEmm(byte[] ), 0, this, byArray);
    }

    public void sendEvent(int n, int n2, byte[] byArray) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("sendEvent", $$robo$$android_media_MediaCas$sendEvent(int int byte[] ), 0, this, n, n2, byArray);
    }

    public void provision(String string2) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("provision", $$robo$$android_media_MediaCas$provision(java.lang.String ), 0, this, string2);
    }

    public void refreshEntitlements(int n, byte[] byArray) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("refreshEntitlements", $$robo$$android_media_MediaCas$refreshEntitlements(int byte[] ), 0, this, n, byArray);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaCas$close(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaCas$finalize(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MediaCas.class);
    }

    public /* synthetic */ MediaCas() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaCas)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface EventListener
    extends InstrumentedInterface {
        public void onEvent(MediaCas var1, int var2, int var3, byte[] var4);
    }

    public static class ParcelableCasPluginDescriptor
    extends PluginDescriptor
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Parcelable.Creator<ParcelableCasPluginDescriptor> CREATOR;

        private void $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor$__constructor__(int CA_system_id, String name) {
        }

        private final int $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor$writeToParcel(Parcel dest, int flags) {
            Log.w("MediaCas", "ParcelableCasPluginDescriptor.writeToParcel shouldn't be called!");
        }

        private /* synthetic */ void $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor$__constructor__(int x0, String x1, 1 x2) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableCasPluginDescriptor>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor_1$__constructor__() {
                }

                private final ParcelableCasPluginDescriptor $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor_1$createFromParcel(Parcel in) {
                    int CA_system_id = in.readInt();
                    String name = in.readString();
                    return new ParcelableCasPluginDescriptor(CA_system_id, name);
                }

                private final ParcelableCasPluginDescriptor[] $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor_1$newArray(int size) {
                    return new ParcelableCasPluginDescriptor[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor_1$__constructor__(), 0, this);
                }

                @Override
                public ParcelableCasPluginDescriptor createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ParcelableCasPluginDescriptor[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor$__constructor__(n, string2);
        }

        private ParcelableCasPluginDescriptor(int n, String string2) {
            super(n, string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(int n, String string2, 1 var3_3) {
            this.$$robo$$android_media_MediaCas_ParcelableCasPluginDescriptor$__constructor__(n, string2, var3_3);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableCasPluginDescriptor.class);
        }

        public /* synthetic */ ParcelableCasPluginDescriptor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableCasPluginDescriptor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class Session
    implements AutoCloseable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        byte[] mSessionId;
        /* synthetic */ MediaCas this$0;

        private void $$robo$$android_media_MediaCas_Session$__constructor__(MediaCas this$0, byte[] sessionId) {
            this.mSessionId = sessionId;
        }

        private final void $$robo$$android_media_MediaCas_Session$setPrivateData(byte[] data) throws MediaCasException {
            this.this$0.validateInternalStates();
            try {
                this.this$0.mICas.setSessionPrivateData(this.mSessionId, data);
            }
            catch (ServiceSpecificException e) {
                MediaCasException.throwExceptions(e);
            }
            catch (RemoteException e) {
                this.this$0.cleanupAndRethrowIllegalState();
            }
        }

        private final void $$robo$$android_media_MediaCas_Session$processEcm(byte[] data, int offset, int length) throws MediaCasException {
            this.this$0.validateInternalStates();
            try {
                this.this$0.mCasData.set(data, offset, length);
                this.this$0.mICas.processEcm(this.mSessionId, this.this$0.mCasData);
            }
            catch (ServiceSpecificException e) {
                MediaCasException.throwExceptions(e);
            }
            catch (RemoteException e) {
                this.this$0.cleanupAndRethrowIllegalState();
            }
        }

        private final void $$robo$$android_media_MediaCas_Session$processEcm(byte[] data) throws MediaCasException {
            this.processEcm(data, 0, data.length);
        }

        private final void $$robo$$android_media_MediaCas_Session$close() {
            this.this$0.validateInternalStates();
            try {
                this.this$0.mICas.closeSession(this.mSessionId);
            }
            catch (ServiceSpecificException e) {
                MediaCasStateException.throwExceptions(e);
            }
            catch (RemoteException e) {
                this.this$0.cleanupAndRethrowIllegalState();
            }
        }

        private void __constructor__(MediaCas mediaCas, byte[] byArray) {
            this.$$robo$$android_media_MediaCas_Session$__constructor__(mediaCas, byArray);
        }

        Session(MediaCas mediaCas, byte[] byArray) {
            this.this$0 = mediaCas;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_Session$__constructor__(android.media.MediaCas byte[] ), 0, this, mediaCas, byArray);
        }

        public void setPrivateData(byte[] byArray) throws MediaCasException {
            InvokeDynamicSupport.bootstrap("setPrivateData", $$robo$$android_media_MediaCas_Session$setPrivateData(byte[] ), 0, this, byArray);
        }

        public void processEcm(byte[] byArray, int n, int n2) throws MediaCasException {
            InvokeDynamicSupport.bootstrap("processEcm", $$robo$$android_media_MediaCas_Session$processEcm(byte[] int int ), 0, this, byArray, n, n2);
        }

        public void processEcm(byte[] byArray) throws MediaCasException {
            InvokeDynamicSupport.bootstrap("processEcm", $$robo$$android_media_MediaCas_Session$processEcm(byte[] ), 0, this, byArray);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaCas_Session$close(), 0, this);
        }

        public /* synthetic */ Session() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Session)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PluginDescriptor
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mCASystemId;
        private String mName;

        private void $$robo$$android_media_MediaCas_PluginDescriptor$__constructor__() {
            this.mCASystemId = 65535;
            this.mName = null;
        }

        private void $$robo$$android_media_MediaCas_PluginDescriptor$__constructor__(int CA_system_id, String name) {
            this.mCASystemId = CA_system_id;
            this.mName = name;
        }

        private final int $$robo$$android_media_MediaCas_PluginDescriptor$getSystemId() {
            return this.mCASystemId;
        }

        private final String $$robo$$android_media_MediaCas_PluginDescriptor$getName() {
            return this.mName;
        }

        private final String $$robo$$android_media_MediaCas_PluginDescriptor$toString() {
            return "PluginDescriptor {" + this.mCASystemId + ", " + this.mName + "}";
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCas_PluginDescriptor$__constructor__();
        }

        private PluginDescriptor() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_PluginDescriptor$__constructor__(), 0, this);
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_media_MediaCas_PluginDescriptor$__constructor__(n, string2);
        }

        PluginDescriptor(int n, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_PluginDescriptor$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        public int getSystemId() {
            return (int)InvokeDynamicSupport.bootstrap("getSystemId", $$robo$$android_media_MediaCas_PluginDescriptor$getSystemId(), 0, this);
        }

        public String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaCas_PluginDescriptor$getName(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaCas_PluginDescriptor$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PluginDescriptor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParcelableCasData
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mData;
        private int mOffset;
        private int mLength;
        public static Parcelable.Creator<ParcelableCasData> CREATOR;

        private void $$robo$$android_media_MediaCas_ParcelableCasData$__constructor__() {
            this.mData = null;
            this.mLength = 0;
            this.mOffset = 0;
        }

        private void $$robo$$android_media_MediaCas_ParcelableCasData$__constructor__(Parcel in) {
        }

        private final void $$robo$$android_media_MediaCas_ParcelableCasData$set(byte[] data, int offset, int length) {
            this.mData = data;
            this.mOffset = offset;
            this.mLength = length;
        }

        private final int $$robo$$android_media_MediaCas_ParcelableCasData$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_MediaCas_ParcelableCasData$writeToParcel(Parcel dest, int flags) {
            dest.writeByteArray(this.mData, this.mOffset, this.mLength);
        }

        private /* synthetic */ void $$robo$$android_media_MediaCas_ParcelableCasData$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableCasData>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_MediaCas_ParcelableCasData_1$__constructor__() {
                }

                private final ParcelableCasData $$robo$$android_media_MediaCas_ParcelableCasData_1$createFromParcel(Parcel in) {
                    return new ParcelableCasData(in);
                }

                private final ParcelableCasData[] $$robo$$android_media_MediaCas_ParcelableCasData_1$newArray(int size) {
                    return new ParcelableCasData[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_MediaCas_ParcelableCasData_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_ParcelableCasData_1$__constructor__(), 0, this);
                }

                @Override
                public ParcelableCasData createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_MediaCas_ParcelableCasData_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ParcelableCasData[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_MediaCas_ParcelableCasData_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCas_ParcelableCasData$__constructor__();
        }

        ParcelableCasData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_ParcelableCasData$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_MediaCas_ParcelableCasData$__constructor__(parcel);
        }

        private ParcelableCasData(Parcel parcel) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_ParcelableCasData$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        void set(byte[] byArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_media_MediaCas_ParcelableCasData$set(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_MediaCas_ParcelableCasData$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_MediaCas_ParcelableCasData$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_media_MediaCas_ParcelableCasData$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableCasData.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableCasData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MSG_CAS_EVENT = 0;
        /* synthetic */ MediaCas this$0;

        private void $$robo$$android_media_MediaCas_EventHandler$__constructor__(MediaCas mediaCas, Looper looper) {
        }

        private final void $$robo$$android_media_MediaCas_EventHandler$handleMessage(Message msg) {
            if (msg.what == 0) {
                this.this$0.mListener.onEvent(this.this$0, msg.arg1, msg.arg2, (byte[])msg.obj);
            }
        }

        private void __constructor__(MediaCas mediaCas, Looper looper) {
            this.$$robo$$android_media_MediaCas_EventHandler$__constructor__(mediaCas, looper);
        }

        public EventHandler(MediaCas mediaCas, Looper looper) {
            this.this$0 = mediaCas;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_EventHandler$__constructor__(android.media.MediaCas android.os.Looper ), 0, this, mediaCas, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaCas_EventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

