/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.AudioAttributes;
import android.media.IAudioService;
import android.media.IPlayer;
import android.media.VolumeShaper;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class PlayerBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PlayerBase";
    private static boolean DEBUG = false;
    private static IAudioService sService;
    private static boolean DEBUG_APP_OPS = false;
    protected AudioAttributes mAttributes;
    protected float mLeftVolume;
    protected float mRightVolume;
    protected float mAuxEffectSendLevel;
    private IAppOpsService mAppOps;
    private IAppOpsCallback mAppOpsCallback;
    private boolean mHasAppOpsPlayAudio;
    private Object mLock;
    private int mImplType;
    private int mPlayerIId;
    private int mState;
    private int mStartDelayMs;
    private float mPanMultiplierL;
    private float mPanMultiplierR;

    private void $$robo$$android_media_PlayerBase$__constructor__(AudioAttributes attr2, int implType) {
        this.mLeftVolume = 1.0f;
        this.mRightVolume = 1.0f;
        this.mAuxEffectSendLevel = 0.0f;
        this.mHasAppOpsPlayAudio = true;
        this.mLock = new Object();
        this.mStartDelayMs = 0;
        this.mPanMultiplierL = 1.0f;
        this.mPanMultiplierR = 1.0f;
        if (attr2 == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        this.mAttributes = attr2;
        this.mImplType = implType;
        this.mState = 1;
    }

    private final void $$robo$$android_media_PlayerBase$baseRegisterPlayer() {
        int newPiid = -1;
        IBinder b = ServiceManager.getService("appops");
        this.mAppOps = IAppOpsService.Stub.asInterface(b);
        this.updateAppOpsPlayAudio();
        this.mAppOpsCallback = new IAppOpsCallbackWrapper(this);
        try {
            this.mAppOps.startWatchingMode(28, ActivityThread.currentPackageName(), this.mAppOpsCallback);
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
        try {
            newPiid = PlayerBase.getService().trackPlayer(new PlayerIdCard(this.mImplType, this.mAttributes, new IPlayerWrapper(this)));
        }
        catch (RemoteException e) {
            Log.e("PlayerBase", "Error talking to audio service, player will not be tracked", e);
        }
        this.mPlayerIId = newPiid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_PlayerBase$baseUpdateAudioAttributes(AudioAttributes attr2) {
        if (attr2 == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        try {
            PlayerBase.getService().playerAttributes(this.mPlayerIId, attr2);
        }
        catch (RemoteException e) {
            Log.e("PlayerBase", "Error talking to audio service, STARTED state will not be tracked", e);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mAttributes = attr2;
            this.updateAppOpsPlayAudio_sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_PlayerBase$baseStart() {
        Object object;
        try {
            object = this.mLock;
            synchronized (object) {
                this.mState = 2;
                PlayerBase.getService().playerEvent(this.mPlayerIId, this.mState);
            }
        }
        catch (RemoteException e) {
            Log.e("PlayerBase", "Error talking to audio service, STARTED state will not be tracked", e);
        }
        object = this.mLock;
        synchronized (object) {
            if (this.isRestricted_sync()) {
                this.playerSetVolume(true, 0.0f, 0.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_PlayerBase$baseSetStartDelayMs(int delayMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mStartDelayMs = Math.max(delayMs, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_PlayerBase$getStartDelayMs() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mStartDelayMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_PlayerBase$basePause() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mState = 3;
                PlayerBase.getService().playerEvent(this.mPlayerIId, this.mState);
            }
        }
        catch (RemoteException e) {
            Log.e("PlayerBase", "Error talking to audio service, PAUSED state will not be tracked", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_PlayerBase$baseStop() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mState = 4;
                PlayerBase.getService().playerEvent(this.mPlayerIId, this.mState);
            }
        }
        catch (RemoteException e) {
            Log.e("PlayerBase", "Error talking to audio service, STOPPED state will not be tracked", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_PlayerBase$baseSetPan(float pan) {
        float p = Math.min(Math.max(-1.0f, pan), 1.0f);
        Object object = this.mLock;
        synchronized (object) {
            if (p >= 0.0f) {
                this.mPanMultiplierL = 1.0f - p;
                this.mPanMultiplierR = 1.0f;
            } else {
                this.mPanMultiplierL = 1.0f;
                this.mPanMultiplierR = 1.0f + p;
            }
        }
        this.baseSetVolume(this.mLeftVolume, this.mRightVolume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_PlayerBase$baseSetVolume(float leftVolume, float rightVolume) {
        boolean hasAppOpsPlayAudio;
        Object object = this.mLock;
        synchronized (object) {
            this.mLeftVolume = leftVolume;
            this.mRightVolume = rightVolume;
            hasAppOpsPlayAudio = this.mHasAppOpsPlayAudio;
            if (this.isRestricted_sync()) {
                return;
            }
        }
        this.playerSetVolume(!hasAppOpsPlayAudio, leftVolume * this.mPanMultiplierL, rightVolume * this.mPanMultiplierR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_PlayerBase$baseSetAuxEffectSendLevel(float level) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAuxEffectSendLevel = level;
            if (this.isRestricted_sync()) {
                return 0;
            }
        }
        return this.playerSetAuxEffectSendLevel(false, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_PlayerBase$baseRelease() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mState != 0) {
                    PlayerBase.getService().releasePlayer(this.mPlayerIId);
                    this.mState = 0;
                }
            }
        }
        catch (RemoteException e) {
            Log.e("PlayerBase", "Error talking to audio service, the player will still be tracked", e);
        }
        try {
            if (this.mAppOps != null) {
                this.mAppOps.stopWatchingMode(this.mAppOpsCallback);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_PlayerBase$updateAppOpsPlayAudio() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateAppOpsPlayAudio_sync();
        }
    }

    private final void $$robo$$android_media_PlayerBase$updateAppOpsPlayAudio_sync() {
        boolean oldHasAppOpsPlayAudio = this.mHasAppOpsPlayAudio;
        try {
            int mode = 1;
            if (this.mAppOps != null) {
                mode = this.mAppOps.checkAudioOperation(28, this.mAttributes.getUsage(), Process.myUid(), ActivityThread.currentPackageName());
            }
            this.mHasAppOpsPlayAudio = mode == 0;
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
        try {
            if (oldHasAppOpsPlayAudio != this.mHasAppOpsPlayAudio) {
                if (this.mHasAppOpsPlayAudio) {
                    this.playerSetVolume(false, this.mLeftVolume * this.mPanMultiplierL, this.mRightVolume * this.mPanMultiplierR);
                    this.playerSetAuxEffectSendLevel(false, this.mAuxEffectSendLevel);
                } else {
                    this.playerSetVolume(true, 0.0f, 0.0f);
                    this.playerSetAuxEffectSendLevel(true, 0.0f);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_media_PlayerBase$isRestricted_sync() {
        if (this.mHasAppOpsPlayAudio) {
            return false;
        }
        if ((this.mAttributes.getAllFlags() & 0x40) != 0) {
            return false;
        }
        if ((this.mAttributes.getAllFlags() & 1) != 0 && this.mAttributes.getUsage() == 13) {
            boolean cameraSoundForced = false;
            try {
                cameraSoundForced = PlayerBase.getService().isCameraSoundForced();
            }
            catch (RemoteException e) {
                Log.e("PlayerBase", "Cannot access AudioService in isRestricted_sync()");
            }
            catch (NullPointerException e) {
                Log.e("PlayerBase", "Null AudioService in isRestricted_sync()");
            }
            if (cameraSoundForced) {
                return false;
            }
        }
        return true;
    }

    private static final IAudioService $$robo$$android_media_PlayerBase$getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    private final void $$robo$$android_media_PlayerBase$setStartDelayMs(int delayMs) {
        this.baseSetStartDelayMs(delayMs);
    }

    abstract void playerSetVolume(boolean var1, float var2, float var3);

    abstract int playerApplyVolumeShaper(VolumeShaper.Configuration var1, VolumeShaper.Operation var2);

    abstract VolumeShaper.State playerGetVolumeShaperState(int var1);

    abstract int playerSetAuxEffectSendLevel(boolean var1, float var2);

    abstract void playerStart();

    abstract void playerPause();

    abstract void playerStop();

    private static final void $$robo$$android_media_PlayerBase$deprecateStreamTypeForPlayback(int streamType, String className, String opName) throws IllegalArgumentException {
        if (streamType == 10) {
            throw new IllegalArgumentException("Use of STREAM_ACCESSIBILITY is reserved for volume control");
        }
        Log.w(className, "Use of stream types is deprecated for operations other than volume control");
        Log.w(className, "See the documentation of " + opName + " for what to use instead with android.media.AudioAttributes to qualify your playback use case");
    }

    private void __constructor__(AudioAttributes audioAttributes, int n) {
        this.$$robo$$android_media_PlayerBase$__constructor__(audioAttributes, n);
    }

    PlayerBase(AudioAttributes audioAttributes, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerBase$__constructor__(android.media.AudioAttributes int ), 0, this, audioAttributes, n);
    }

    protected void baseRegisterPlayer() {
        InvokeDynamicSupport.bootstrap("baseRegisterPlayer", $$robo$$android_media_PlayerBase$baseRegisterPlayer(), 0, this);
    }

    void baseUpdateAudioAttributes(AudioAttributes audioAttributes) {
        InvokeDynamicSupport.bootstrap("baseUpdateAudioAttributes", $$robo$$android_media_PlayerBase$baseUpdateAudioAttributes(android.media.AudioAttributes ), 0, this, audioAttributes);
    }

    void baseStart() {
        InvokeDynamicSupport.bootstrap("baseStart", $$robo$$android_media_PlayerBase$baseStart(), 0, this);
    }

    void baseSetStartDelayMs(int n) {
        InvokeDynamicSupport.bootstrap("baseSetStartDelayMs", $$robo$$android_media_PlayerBase$baseSetStartDelayMs(int ), 0, this, n);
    }

    protected int getStartDelayMs() {
        return (int)InvokeDynamicSupport.bootstrap("getStartDelayMs", $$robo$$android_media_PlayerBase$getStartDelayMs(), 0, this);
    }

    void basePause() {
        InvokeDynamicSupport.bootstrap("basePause", $$robo$$android_media_PlayerBase$basePause(), 0, this);
    }

    void baseStop() {
        InvokeDynamicSupport.bootstrap("baseStop", $$robo$$android_media_PlayerBase$baseStop(), 0, this);
    }

    void baseSetPan(float f) {
        InvokeDynamicSupport.bootstrap("baseSetPan", $$robo$$android_media_PlayerBase$baseSetPan(float ), 0, this, f);
    }

    void baseSetVolume(float f, float f2) {
        InvokeDynamicSupport.bootstrap("baseSetVolume", $$robo$$android_media_PlayerBase$baseSetVolume(float float ), 0, this, f, f2);
    }

    int baseSetAuxEffectSendLevel(float f) {
        return (int)InvokeDynamicSupport.bootstrap("baseSetAuxEffectSendLevel", $$robo$$android_media_PlayerBase$baseSetAuxEffectSendLevel(float ), 0, this, f);
    }

    void baseRelease() {
        InvokeDynamicSupport.bootstrap("baseRelease", $$robo$$android_media_PlayerBase$baseRelease(), 0, this);
    }

    private void updateAppOpsPlayAudio() {
        InvokeDynamicSupport.bootstrap("updateAppOpsPlayAudio", $$robo$$android_media_PlayerBase$updateAppOpsPlayAudio(), 0, this);
    }

    void updateAppOpsPlayAudio_sync() {
        InvokeDynamicSupport.bootstrap("updateAppOpsPlayAudio_sync", $$robo$$android_media_PlayerBase$updateAppOpsPlayAudio_sync(), 0, this);
    }

    boolean isRestricted_sync() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRestricted_sync", $$robo$$android_media_PlayerBase$isRestricted_sync(), 0, this);
    }

    private static IAudioService getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_media_PlayerBase$getService(), 0);
    }

    public void setStartDelayMs(int n) {
        InvokeDynamicSupport.bootstrap("setStartDelayMs", $$robo$$android_media_PlayerBase$setStartDelayMs(int ), 0, this, n);
    }

    public static void deprecateStreamTypeForPlayback(int n, String string2, String string3) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrapStatic("deprecateStreamTypeForPlayback", $$robo$$android_media_PlayerBase$deprecateStreamTypeForPlayback(int java.lang.String java.lang.String ), 0, (int)n, (String)string2, (String)string3);
    }

    public /* synthetic */ PlayerBase() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlayerBase)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PlayerIdCard
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int mPlayerType;
        public static int AUDIO_ATTRIBUTES_NONE = 0;
        public static int AUDIO_ATTRIBUTES_DEFINED = 1;
        public AudioAttributes mAttributes;
        public IPlayer mIPlayer;
        public static Parcelable.Creator<PlayerIdCard> CREATOR;

        private void $$robo$$android_media_PlayerBase_PlayerIdCard$__constructor__(int type, AudioAttributes attr2, IPlayer iplayer) {
            this.mPlayerType = type;
            this.mAttributes = attr2;
            this.mIPlayer = iplayer;
        }

        private final int $$robo$$android_media_PlayerBase_PlayerIdCard$hashCode() {
            return Objects.hash(this.mPlayerType);
        }

        private final int $$robo$$android_media_PlayerBase_PlayerIdCard$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_PlayerBase_PlayerIdCard$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mPlayerType);
            this.mAttributes.writeToParcel(dest, 0);
            dest.writeStrongBinder(this.mIPlayer == null ? null : this.mIPlayer.asBinder());
        }

        private void $$robo$$android_media_PlayerBase_PlayerIdCard$__constructor__(Parcel in) {
            this.mPlayerType = in.readInt();
            this.mAttributes = AudioAttributes.CREATOR.createFromParcel(in);
            IBinder b = in.readStrongBinder();
            this.mIPlayer = b == null ? null : IPlayer.Stub.asInterface(b);
        }

        private final boolean $$robo$$android_media_PlayerBase_PlayerIdCard$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof PlayerIdCard)) {
                return false;
            }
            PlayerIdCard that = (PlayerIdCard)o;
            return this.mPlayerType == that.mPlayerType && this.mAttributes.equals(that.mAttributes);
        }

        private /* synthetic */ void $$robo$$android_media_PlayerBase_PlayerIdCard$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<PlayerIdCard>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_PlayerBase_PlayerIdCard_1$__constructor__() {
                }

                private final PlayerIdCard $$robo$$android_media_PlayerBase_PlayerIdCard_1$createFromParcel(Parcel p) {
                    return new PlayerIdCard(p);
                }

                private final PlayerIdCard[] $$robo$$android_media_PlayerBase_PlayerIdCard_1$newArray(int size) {
                    return new PlayerIdCard[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_PlayerBase_PlayerIdCard_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerBase_PlayerIdCard_1$__constructor__(), 0, this);
                }

                @Override
                public PlayerIdCard createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_PlayerBase_PlayerIdCard_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public PlayerIdCard[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_PlayerBase_PlayerIdCard_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, AudioAttributes audioAttributes, IPlayer iPlayer) {
            this.$$robo$$android_media_PlayerBase_PlayerIdCard$__constructor__(n, audioAttributes, iPlayer);
        }

        PlayerIdCard(int n, AudioAttributes audioAttributes, IPlayer iPlayer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerBase_PlayerIdCard$__constructor__(int android.media.AudioAttributes android.media.IPlayer ), 0, this, n, audioAttributes, iPlayer);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_PlayerBase_PlayerIdCard$hashCode(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_PlayerBase_PlayerIdCard$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_PlayerBase_PlayerIdCard$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_PlayerBase_PlayerIdCard$__constructor__(parcel);
        }

        private PlayerIdCard(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerBase_PlayerIdCard$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_PlayerBase_PlayerIdCard$equals(java.lang.Object ), 0, this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_media_PlayerBase_PlayerIdCard$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(PlayerIdCard.class);
        }

        public /* synthetic */ PlayerIdCard() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlayerIdCard)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class IPlayerWrapper
    extends IPlayer.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<PlayerBase> mWeakPB;

        private void $$robo$$android_media_PlayerBase_IPlayerWrapper$__constructor__(PlayerBase pb) {
            this.mWeakPB = new WeakReference<PlayerBase>(pb);
        }

        private final void $$robo$$android_media_PlayerBase_IPlayerWrapper$start() {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerStart();
            }
        }

        private final void $$robo$$android_media_PlayerBase_IPlayerWrapper$pause() {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerPause();
            }
        }

        private final void $$robo$$android_media_PlayerBase_IPlayerWrapper$stop() {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerStop();
            }
        }

        private final void $$robo$$android_media_PlayerBase_IPlayerWrapper$setVolume(float vol) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.baseSetVolume(vol, vol);
            }
        }

        private final void $$robo$$android_media_PlayerBase_IPlayerWrapper$setPan(float pan) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.baseSetPan(pan);
            }
        }

        private final void $$robo$$android_media_PlayerBase_IPlayerWrapper$setStartDelayMs(int delayMs) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.baseSetStartDelayMs(delayMs);
            }
        }

        private final void $$robo$$android_media_PlayerBase_IPlayerWrapper$applyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerApplyVolumeShaper(configuration, operation);
            }
        }

        private void __constructor__(PlayerBase playerBase) {
            this.$$robo$$android_media_PlayerBase_IPlayerWrapper$__constructor__(playerBase);
        }

        public IPlayerWrapper(PlayerBase playerBase) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerBase_IPlayerWrapper$__constructor__(android.media.PlayerBase ), 0, this, playerBase);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_media_PlayerBase_IPlayerWrapper$start(), 0, this);
        }

        @Override
        public void pause() {
            InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_PlayerBase_IPlayerWrapper$pause(), 0, this);
        }

        @Override
        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_PlayerBase_IPlayerWrapper$stop(), 0, this);
        }

        @Override
        public void setVolume(float f) {
            InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_PlayerBase_IPlayerWrapper$setVolume(float ), 0, this, f);
        }

        @Override
        public void setPan(float f) {
            InvokeDynamicSupport.bootstrap("setPan", $$robo$$android_media_PlayerBase_IPlayerWrapper$setPan(float ), 0, this, f);
        }

        @Override
        public void setStartDelayMs(int n) {
            InvokeDynamicSupport.bootstrap("setStartDelayMs", $$robo$$android_media_PlayerBase_IPlayerWrapper$setStartDelayMs(int ), 0, this, n);
        }

        @Override
        public void applyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
            InvokeDynamicSupport.bootstrap("applyVolumeShaper", $$robo$$android_media_PlayerBase_IPlayerWrapper$applyVolumeShaper(android.media.VolumeShaper$Configuration android.media.VolumeShaper$Operation ), 0, this, configuration, operation);
        }

        public /* synthetic */ IPlayerWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IPlayerWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class IAppOpsCallbackWrapper
    extends IAppOpsCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<PlayerBase> mWeakPB;

        private void $$robo$$android_media_PlayerBase_IAppOpsCallbackWrapper$__constructor__(PlayerBase pb) {
            this.mWeakPB = new WeakReference<PlayerBase>(pb);
        }

        private final void $$robo$$android_media_PlayerBase_IAppOpsCallbackWrapper$opChanged(int op, int uid, String packageName) {
            PlayerBase pb;
            if (op == 28 && (pb = (PlayerBase)this.mWeakPB.get()) != null) {
                pb.updateAppOpsPlayAudio();
            }
        }

        private void __constructor__(PlayerBase playerBase) {
            this.$$robo$$android_media_PlayerBase_IAppOpsCallbackWrapper$__constructor__(playerBase);
        }

        public IAppOpsCallbackWrapper(PlayerBase playerBase) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerBase_IAppOpsCallbackWrapper$__constructor__(android.media.PlayerBase ), 0, this, playerBase);
        }

        @Override
        public void opChanged(int n, int n2, String string2) {
            InvokeDynamicSupport.bootstrap("opChanged", $$robo$$android_media_PlayerBase_IAppOpsCallbackWrapper$opChanged(int int java.lang.String ), 0, this, n, n2, string2);
        }

        public /* synthetic */ IAppOpsCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IAppOpsCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

