/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.TextTrackCue;
import android.media.TextTrackCueSpan;
import android.media.WebVttRenderingWidget;
import android.media.WebVttTrack;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SRTTrack
extends WebVttTrack
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MEDIA_TIMED_TEXT = 99;
    private static int KEY_STRUCT_TEXT = 16;
    private static int KEY_START_TIME = 7;
    private static int KEY_LOCAL_SETTING = 102;
    private static String TAG = "SRTTrack";
    private Handler mEventHandler;

    private void $$robo$$android_media_SRTTrack$__constructor__(WebVttRenderingWidget renderingWidget, MediaFormat format) {
        this.mEventHandler = null;
    }

    private void $$robo$$android_media_SRTTrack$__constructor__(Handler eventHandler, MediaFormat format) {
        this.mEventHandler = eventHandler;
    }

    private final void $$robo$$android_media_SRTTrack$onData(SubtitleData data) {
        try {
            TextTrackCue cue = new TextTrackCue();
            cue.mStartTimeMs = data.getStartTimeUs() / 1000L;
            cue.mEndTimeMs = (data.getStartTimeUs() + data.getDurationUs()) / 1000L;
            String paragraph = new String(data.getData(), "UTF-8");
            String[] lines = paragraph.split("\\r?\\n");
            cue.mLines = new TextTrackCueSpan[lines.length][];
            int i = 0;
            for (String line : lines) {
                TextTrackCueSpan[] span = new TextTrackCueSpan[]{new TextTrackCueSpan(line, -1L)};
                cue.mLines[i++] = span;
            }
            this.addCue(cue);
        }
        catch (UnsupportedEncodingException e) {
            Log.w("SRTTrack", "subtitle data is not UTF-8 encoded: " + e);
        }
    }

    private final void $$robo$$android_media_SRTTrack$onData(byte[] data, boolean eos, long runID) {
        try {
            String header;
            InputStreamReader r = new InputStreamReader((InputStream)new ByteArrayInputStream(data), "UTF-8");
            BufferedReader br = new BufferedReader(r);
            while ((header = br.readLine()) != null && (header = br.readLine()) != null) {
                String s;
                TextTrackCue cue = new TextTrackCue();
                String[] startEnd = header.split("-->");
                cue.mStartTimeMs = SRTTrack.parseMs(startEnd[0]);
                cue.mEndTimeMs = SRTTrack.parseMs(startEnd[1]);
                ArrayList<String> paragraph = new ArrayList<String>();
                while ((s = br.readLine()) != null && !s.trim().equals("")) {
                    paragraph.add(s);
                }
                int i = 0;
                cue.mLines = new TextTrackCueSpan[paragraph.size()][];
                cue.mStrings = paragraph.toArray(new String[0]);
                for (String line : paragraph) {
                    TextTrackCueSpan[] span = new TextTrackCueSpan[]{new TextTrackCueSpan(line, -1L)};
                    cue.mStrings[i] = line;
                    cue.mLines[i++] = span;
                }
                this.addCue(cue);
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.w("SRTTrack", "subtitle data is not UTF-8 encoded: " + e);
        }
        catch (IOException ioe) {
            Log.e("SRTTrack", ioe.getMessage(), ioe);
        }
    }

    private final void $$robo$$android_media_SRTTrack$updateView(Vector<SubtitleTrack.Cue> activeCues) {
        if (this.getRenderingWidget() != null) {
            super.updateView(activeCues);
            return;
        }
        if (this.mEventHandler == null) {
            return;
        }
        for (SubtitleTrack.Cue cue : activeCues) {
            TextTrackCue ttc = (TextTrackCue)cue;
            Parcel parcel = Parcel.obtain();
            parcel.writeInt(102);
            parcel.writeInt(7);
            parcel.writeInt((int)cue.mStartTimeMs);
            parcel.writeInt(16);
            StringBuilder sb = new StringBuilder();
            for (String line : ttc.mStrings) {
                sb.append(line).append('\n');
            }
            byte[] buf = sb.toString().getBytes();
            parcel.writeInt(buf.length);
            parcel.writeByteArray(buf);
            Message msg = this.mEventHandler.obtainMessage(99, 0, 0, parcel);
            this.mEventHandler.sendMessage(msg);
        }
        activeCues.clear();
    }

    private static final long $$robo$$android_media_SRTTrack$parseMs(String in) {
        long hours = Long.parseLong(in.split(":")[0].trim());
        long minutes = Long.parseLong(in.split(":")[1].trim());
        long seconds = Long.parseLong(in.split(":")[2].split(",")[0].trim());
        long millies = Long.parseLong(in.split(":")[2].split(",")[1].trim());
        return hours * 60L * 60L * 1000L + minutes * 60L * 1000L + seconds * 1000L + millies;
    }

    private void __constructor__(WebVttRenderingWidget webVttRenderingWidget, MediaFormat mediaFormat) {
        this.$$robo$$android_media_SRTTrack$__constructor__(webVttRenderingWidget, mediaFormat);
    }

    SRTTrack(WebVttRenderingWidget webVttRenderingWidget, MediaFormat mediaFormat) {
        super(webVttRenderingWidget, mediaFormat);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SRTTrack$__constructor__(android.media.WebVttRenderingWidget android.media.MediaFormat ), 0, this, webVttRenderingWidget, mediaFormat);
    }

    private void __constructor__(Handler handler, MediaFormat mediaFormat) {
        this.$$robo$$android_media_SRTTrack$__constructor__(handler, mediaFormat);
    }

    SRTTrack(Handler handler, MediaFormat mediaFormat) {
        super(null, mediaFormat);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SRTTrack$__constructor__(android.os.Handler android.media.MediaFormat ), 0, this, handler, mediaFormat);
    }

    @Override
    protected void onData(SubtitleData subtitleData) {
        InvokeDynamicSupport.bootstrap("onData", $$robo$$android_media_SRTTrack$onData(android.media.SubtitleData ), 0, this, subtitleData);
    }

    @Override
    public void onData(byte[] byArray, boolean bl, long l) {
        InvokeDynamicSupport.bootstrap("onData", $$robo$$android_media_SRTTrack$onData(byte[] boolean long ), 0, this, byArray, bl, l);
    }

    @Override
    public void updateView(Vector<SubtitleTrack.Cue> vector) {
        InvokeDynamicSupport.bootstrap("updateView", $$robo$$android_media_SRTTrack$updateView(java.util.Vector<android.media.SubtitleTrack$Cue> ), 0, this, vector);
    }

    private static long parseMs(String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("parseMs", $$robo$$android_media_SRTTrack$parseMs(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ SRTTrack() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SRTTrack)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

