/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.SubtitleTrack;
import android.media.TextTrackCue;
import android.media.TextTrackCueSpan;
import android.media.TextTrackRegion;
import android.media.Tokenizer;
import android.media.UnstyledTextExtractor;
import android.media.WebVttCueListener;
import android.media.WebVttParser;
import android.media.WebVttRenderingWidget;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WebVttTrack
extends SubtitleTrack
implements WebVttCueListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WebVttTrack";
    private WebVttParser mParser;
    private UnstyledTextExtractor mExtractor;
    private Tokenizer mTokenizer;
    private Vector<Long> mTimestamps;
    private WebVttRenderingWidget mRenderingWidget;
    private Map<String, TextTrackRegion> mRegions;
    private Long mCurrentRunID;

    private void $$robo$$android_media_WebVttTrack$__constructor__(WebVttRenderingWidget renderingWidget, MediaFormat format) {
        this.mParser = new WebVttParser(this);
        this.mExtractor = new UnstyledTextExtractor();
        this.mTokenizer = new Tokenizer(this.mExtractor);
        this.mTimestamps = new Vector();
        this.mRegions = new HashMap<String, TextTrackRegion>();
        this.mRenderingWidget = renderingWidget;
    }

    private final WebVttRenderingWidget $$robo$$android_media_WebVttTrack$getRenderingWidget() {
        return this.mRenderingWidget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_WebVttTrack$onData(byte[] data, boolean eos, long runID) {
        try {
            String str = new String(data, "UTF-8");
            WebVttParser webVttParser = this.mParser;
            synchronized (webVttParser) {
                if (this.mCurrentRunID != null && runID != this.mCurrentRunID) {
                    throw new IllegalStateException("Run #" + this.mCurrentRunID + " in progress.  Cannot process run #" + runID);
                }
                this.mCurrentRunID = runID;
                this.mParser.parse(str);
                if (eos) {
                    this.finishedRun(runID);
                    this.mParser.eos();
                    this.mRegions.clear();
                    this.mCurrentRunID = null;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.w("WebVttTrack", "subtitle data is not UTF-8 encoded: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_WebVttTrack$onCueParsed(TextTrackCue cue) {
        WebVttParser webVttParser = this.mParser;
        synchronized (webVttParser) {
            if (cue.mRegionId.length() != 0) {
                cue.mRegion = this.mRegions.get(cue.mRegionId);
            }
            if (this.DEBUG) {
                Log.v("WebVttTrack", "adding cue " + cue);
            }
            this.mTokenizer.reset();
            for (String s : cue.mStrings) {
                this.mTokenizer.tokenize(s);
            }
            cue.mLines = this.mExtractor.getText();
            if (this.DEBUG) {
                Log.v("WebVttTrack", cue.appendLinesToBuilder(cue.appendStringsToBuilder(new StringBuilder()).append(" simplified to: ")).toString());
            }
            String[] stringArray = cue.mLines;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String line;
                for (String span : line = stringArray[i]) {
                    if (((TextTrackCueSpan)((Object)span)).mTimestampMs <= cue.mStartTimeMs || ((TextTrackCueSpan)((Object)span)).mTimestampMs >= cue.mEndTimeMs || this.mTimestamps.contains(((TextTrackCueSpan)((Object)span)).mTimestampMs)) continue;
                    this.mTimestamps.add(((TextTrackCueSpan)((Object)span)).mTimestampMs);
                }
            }
            if (this.mTimestamps.size() > 0) {
                cue.mInnerTimesMs = new long[this.mTimestamps.size()];
                for (int ix = 0; ix < this.mTimestamps.size(); ++ix) {
                    cue.mInnerTimesMs[ix] = this.mTimestamps.get(ix);
                }
                this.mTimestamps.clear();
            } else {
                cue.mInnerTimesMs = null;
            }
            cue.mRunID = this.mCurrentRunID;
        }
        this.addCue(cue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_WebVttTrack$onRegionParsed(TextTrackRegion region) {
        WebVttParser webVttParser = this.mParser;
        synchronized (webVttParser) {
            this.mRegions.put(region.mId, region);
        }
    }

    private final void $$robo$$android_media_WebVttTrack$updateView(Vector<SubtitleTrack.Cue> activeCues) {
        if (!this.mVisible) {
            return;
        }
        if (this.DEBUG && this.mTimeProvider != null) {
            try {
                Log.d("WebVttTrack", "at " + this.mTimeProvider.getCurrentTimeUs(false, true) / 1000L + " ms the active cues are:");
            }
            catch (IllegalStateException e) {
                Log.d("WebVttTrack", "at (illegal state) the active cues are:");
            }
        }
        if (this.mRenderingWidget != null) {
            this.mRenderingWidget.setActiveCues(activeCues);
        }
    }

    private void __constructor__(WebVttRenderingWidget webVttRenderingWidget, MediaFormat mediaFormat) {
        this.$$robo$$android_media_WebVttTrack$__constructor__(webVttRenderingWidget, mediaFormat);
    }

    WebVttTrack(WebVttRenderingWidget webVttRenderingWidget, MediaFormat mediaFormat) {
        super(mediaFormat);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttTrack$__constructor__(android.media.WebVttRenderingWidget android.media.MediaFormat ), 0, this, webVttRenderingWidget, mediaFormat);
    }

    @Override
    public WebVttRenderingWidget getRenderingWidget() {
        return InvokeDynamicSupport.bootstrap("getRenderingWidget", $$robo$$android_media_WebVttTrack$getRenderingWidget(), 0, this);
    }

    @Override
    public void onData(byte[] byArray, boolean bl, long l) {
        InvokeDynamicSupport.bootstrap("onData", $$robo$$android_media_WebVttTrack$onData(byte[] boolean long ), 0, this, byArray, bl, l);
    }

    @Override
    public void onCueParsed(TextTrackCue textTrackCue) {
        InvokeDynamicSupport.bootstrap("onCueParsed", $$robo$$android_media_WebVttTrack$onCueParsed(android.media.TextTrackCue ), 0, this, textTrackCue);
    }

    @Override
    public void onRegionParsed(TextTrackRegion textTrackRegion) {
        InvokeDynamicSupport.bootstrap("onRegionParsed", $$robo$$android_media_WebVttTrack$onRegionParsed(android.media.TextTrackRegion ), 0, this, textTrackRegion);
    }

    @Override
    public void updateView(Vector<SubtitleTrack.Cue> vector) {
        InvokeDynamicSupport.bootstrap("updateView", $$robo$$android_media_WebVttTrack$updateView(java.util.Vector<android.media.SubtitleTrack$Cue> ), 0, this, vector);
    }

    public /* synthetic */ WebVttTrack() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebVttTrack)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

