/*
 * Decompiled with CFR 0.152.
 */
package android.media.effect;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.GraphRunner;
import android.filterfw.core.SyncRunner;
import android.filterfw.io.GraphIOException;
import android.filterfw.io.GraphReader;
import android.filterfw.io.TextGraphReader;
import android.media.effect.EffectContext;
import android.media.effect.FilterEffect;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FilterGraphEffect
extends FilterEffect
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FilterGraphEffect";
    protected String mInputName;
    protected String mOutputName;
    protected GraphRunner mRunner;
    protected FilterGraph mGraph;
    protected Class mSchedulerClass;

    private void $$robo$$android_media_effect_FilterGraphEffect$__constructor__(EffectContext context, String name, String graphString, String inputName, String outputName, Class scheduler) {
        this.mInputName = inputName;
        this.mOutputName = outputName;
        this.mSchedulerClass = scheduler;
        this.createGraph(graphString);
    }

    private final void $$robo$$android_media_effect_FilterGraphEffect$createGraph(String graphString) {
        TextGraphReader reader = new TextGraphReader();
        try {
            this.mGraph = ((GraphReader)reader).readGraphString(graphString);
        }
        catch (GraphIOException e) {
            throw new RuntimeException("Could not setup effect", e);
        }
        if (this.mGraph == null) {
            throw new RuntimeException("Could not setup effect");
        }
        this.mRunner = new SyncRunner(this.getFilterContext(), this.mGraph, this.mSchedulerClass);
    }

    private final void $$robo$$android_media_effect_FilterGraphEffect$apply(int inputTexId, int width, int height, int outputTexId) {
        this.beginGLEffect();
        Filter src = this.mGraph.getFilter(this.mInputName);
        if (src == null) {
            throw new RuntimeException("Internal error applying effect");
        }
        src.setInputValue("texId", inputTexId);
        src.setInputValue("width", width);
        src.setInputValue("height", height);
        Filter dest = this.mGraph.getFilter(this.mOutputName);
        if (dest == null) {
            throw new RuntimeException("Internal error applying effect");
        }
        dest.setInputValue("texId", outputTexId);
        try {
            this.mRunner.run();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Internal error applying effect: ", e);
        }
        this.endGLEffect();
    }

    private final void $$robo$$android_media_effect_FilterGraphEffect$setParameter(String parameterKey, Object value) {
    }

    private final void $$robo$$android_media_effect_FilterGraphEffect$release() {
        this.mGraph.tearDown(this.getFilterContext());
        this.mGraph = null;
    }

    private void __constructor__(EffectContext effectContext, String string2, String string3, String string4, String string5, Class clazz) {
        this.$$robo$$android_media_effect_FilterGraphEffect$__constructor__(effectContext, string2, string3, string4, string5, clazz);
    }

    public FilterGraphEffect(EffectContext effectContext, String string2, String string3, String string4, String string5, Class clazz) {
        super(effectContext, string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_effect_FilterGraphEffect$__constructor__(android.media.effect.EffectContext java.lang.String java.lang.String java.lang.String java.lang.String java.lang.Class ), 0, this, effectContext, string2, string3, string4, string5, clazz);
    }

    private void createGraph(String string2) {
        InvokeDynamicSupport.bootstrap("createGraph", $$robo$$android_media_effect_FilterGraphEffect$createGraph(java.lang.String ), 0, this, string2);
    }

    @Override
    public void apply(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("apply", $$robo$$android_media_effect_FilterGraphEffect$apply(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void setParameter(String string2, Object object) {
        InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_effect_FilterGraphEffect$setParameter(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    @Override
    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_effect_FilterGraphEffect$release(), 0, this);
    }

    public /* synthetic */ FilterGraphEffect() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FilterGraphEffect)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

