/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.bluetooth.BluetoothDevice;
import android.media.midi.IMidiDeviceListener;
import android.media.midi.IMidiDeviceOpenCallback;
import android.media.midi.IMidiDeviceServer;
import android.media.midi.IMidiManager;
import android.media.midi.MidiDevice;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiDeviceServer;
import android.media.midi.MidiDeviceStatus;
import android.media.midi.MidiReceiver;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MidiManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MidiManager";
    public static String BLUETOOTH_MIDI_SERVICE_INTENT = "android.media.midi.BluetoothMidiService";
    public static String BLUETOOTH_MIDI_SERVICE_PACKAGE = "com.android.bluetoothmidiservice";
    public static String BLUETOOTH_MIDI_SERVICE_CLASS = "com.android.bluetoothmidiservice.BluetoothMidiService";
    private IMidiManager mService;
    private IBinder mToken;
    private ConcurrentHashMap<DeviceCallback, DeviceListener> mDeviceListeners;

    private void $$robo$$android_media_midi_MidiManager$__constructor__(IMidiManager service) {
        this.mToken = new Binder();
        this.mDeviceListeners = new ConcurrentHashMap();
        this.mService = service;
    }

    private final void $$robo$$android_media_midi_MidiManager$registerDeviceCallback(DeviceCallback callback, Handler handler) {
        DeviceListener deviceListener = new DeviceListener(this, callback, handler);
        try {
            this.mService.registerListener(this.mToken, deviceListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.mDeviceListeners.put(callback, deviceListener);
    }

    private final void $$robo$$android_media_midi_MidiManager$unregisterDeviceCallback(DeviceCallback callback) {
        DeviceListener deviceListener = this.mDeviceListeners.remove(callback);
        if (deviceListener != null) {
            try {
                this.mService.unregisterListener(this.mToken, deviceListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final MidiDeviceInfo[] $$robo$$android_media_midi_MidiManager$getDevices() {
        try {
            return this.mService.getDevices();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_midi_MidiManager$sendOpenDeviceResponse(MidiDevice device, OnDeviceOpenedListener listener, Handler handler) {
        if (handler != null) {
            handler.post(new Runnable(this, listener, device){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ OnDeviceOpenedListener val$listener;
                /* synthetic */ MidiDevice val$device;
                /* synthetic */ MidiManager this$0;

                private void $$robo$$android_media_midi_MidiManager_1$__constructor__(MidiManager this$0, OnDeviceOpenedListener onDeviceOpenedListener, MidiDevice midiDevice) {
                }

                private final void $$robo$$android_media_midi_MidiManager_1$run() {
                    this.val$listener.onDeviceOpened(this.val$device);
                }

                private void __constructor__(MidiManager midiManager, OnDeviceOpenedListener onDeviceOpenedListener, MidiDevice midiDevice) {
                    this.$$robo$$android_media_midi_MidiManager_1$__constructor__(midiManager, onDeviceOpenedListener, midiDevice);
                }
                {
                    this.this$0 = midiManager;
                    this.val$listener = onDeviceOpenedListener;
                    this.val$device = midiDevice;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiManager_1$__constructor__(android.media.midi.MidiManager android.media.midi.MidiManager$OnDeviceOpenedListener android.media.midi.MidiDevice ), 0, this, midiManager, onDeviceOpenedListener, midiDevice);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_midi_MidiManager_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        } else {
            listener.onDeviceOpened(device);
        }
    }

    private final void $$robo$$android_media_midi_MidiManager$openDevice(MidiDeviceInfo deviceInfo, OnDeviceOpenedListener listener, Handler handler) {
        MidiDeviceInfo deviceInfoF = deviceInfo;
        OnDeviceOpenedListener listenerF = listener;
        Handler handlerF = handler;
        ShadowedObject callback = new ShadowedObject(this, deviceInfoF, listenerF, handlerF){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MidiDeviceInfo val$deviceInfoF;
            /* synthetic */ OnDeviceOpenedListener val$listenerF;
            /* synthetic */ Handler val$handlerF;
            /* synthetic */ MidiManager this$0;

            private void $$robo$$android_media_midi_MidiManager_2$__constructor__(MidiManager this$0, MidiDeviceInfo midiDeviceInfo, OnDeviceOpenedListener onDeviceOpenedListener, Handler handler) {
            }

            private final void $$robo$$android_media_midi_MidiManager_2$onDeviceOpened(IMidiDeviceServer server, IBinder deviceToken) {
                MidiDevice device = server != null ? new MidiDevice(this.val$deviceInfoF, server, this.this$0.mService, this.this$0.mToken, deviceToken) : null;
                this.this$0.sendOpenDeviceResponse(device, this.val$listenerF, this.val$handlerF);
            }

            private void __constructor__(MidiManager midiManager, MidiDeviceInfo midiDeviceInfo, OnDeviceOpenedListener onDeviceOpenedListener, Handler handler) {
                this.$$robo$$android_media_midi_MidiManager_2$__constructor__(midiManager, midiDeviceInfo, onDeviceOpenedListener, handler);
            }
            {
                this.this$0 = midiManager;
                this.val$deviceInfoF = midiDeviceInfo;
                this.val$listenerF = onDeviceOpenedListener;
                this.val$handlerF = handler;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiManager_2$__constructor__(android.media.midi.MidiManager android.media.midi.MidiDeviceInfo android.media.midi.MidiManager$OnDeviceOpenedListener android.os.Handler ), 0, this, midiManager, midiDeviceInfo, onDeviceOpenedListener, handler);
            }

            @Override
            public void onDeviceOpened(IMidiDeviceServer iMidiDeviceServer, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onDeviceOpened", $$robo$$android_media_midi_MidiManager_2$onDeviceOpened(android.media.midi.IMidiDeviceServer android.os.IBinder ), 0, this, iMidiDeviceServer, iBinder);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            this.mService.openDevice(this.mToken, deviceInfo, (IMidiDeviceOpenCallback)callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_midi_MidiManager$openBluetoothDevice(BluetoothDevice bluetoothDevice, OnDeviceOpenedListener listener, Handler handler) {
        OnDeviceOpenedListener listenerF = listener;
        Handler handlerF = handler;
        ShadowedObject callback = new ShadowedObject(this, listenerF, handlerF){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ OnDeviceOpenedListener val$listenerF;
            /* synthetic */ Handler val$handlerF;
            /* synthetic */ MidiManager this$0;

            private void $$robo$$android_media_midi_MidiManager_3$__constructor__(MidiManager this$0, OnDeviceOpenedListener onDeviceOpenedListener, Handler handler) {
            }

            private final void $$robo$$android_media_midi_MidiManager_3$onDeviceOpened(IMidiDeviceServer server, IBinder deviceToken) {
                MidiDevice device = null;
                if (server != null) {
                    try {
                        MidiDeviceInfo deviceInfo = server.getDeviceInfo();
                        device = new MidiDevice(deviceInfo, server, this.this$0.mService, this.this$0.mToken, deviceToken);
                    }
                    catch (RemoteException e) {
                        Log.e("MidiManager", "remote exception in getDeviceInfo()");
                    }
                }
                this.this$0.sendOpenDeviceResponse(device, this.val$listenerF, this.val$handlerF);
            }

            private void __constructor__(MidiManager midiManager, OnDeviceOpenedListener onDeviceOpenedListener, Handler handler) {
                this.$$robo$$android_media_midi_MidiManager_3$__constructor__(midiManager, onDeviceOpenedListener, handler);
            }
            {
                this.this$0 = midiManager;
                this.val$listenerF = onDeviceOpenedListener;
                this.val$handlerF = handler;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiManager_3$__constructor__(android.media.midi.MidiManager android.media.midi.MidiManager$OnDeviceOpenedListener android.os.Handler ), 0, this, midiManager, onDeviceOpenedListener, handler);
            }

            @Override
            public void onDeviceOpened(IMidiDeviceServer iMidiDeviceServer, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onDeviceOpened", $$robo$$android_media_midi_MidiManager_3$onDeviceOpened(android.media.midi.IMidiDeviceServer android.os.IBinder ), 0, this, iMidiDeviceServer, iBinder);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            this.mService.openBluetoothDevice(this.mToken, bluetoothDevice, (IMidiDeviceOpenCallback)callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final MidiDeviceServer $$robo$$android_media_midi_MidiManager$createDeviceServer(MidiReceiver[] inputPortReceivers, int numOutputPorts, String[] inputPortNames, String[] outputPortNames, Bundle properties, int type, MidiDeviceServer.Callback callback) {
        try {
            MidiDeviceServer server = new MidiDeviceServer(this.mService, inputPortReceivers, numOutputPorts, callback);
            MidiDeviceInfo deviceInfo = this.mService.registerDeviceServer(server.getBinderInterface(), inputPortReceivers.length, numOutputPorts, inputPortNames, outputPortNames, properties, type);
            if (deviceInfo == null) {
                Log.e("MidiManager", "registerVirtualDevice failed");
                return null;
            }
            return server;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void __constructor__(IMidiManager iMidiManager) {
        this.$$robo$$android_media_midi_MidiManager$__constructor__(iMidiManager);
    }

    public MidiManager(IMidiManager iMidiManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiManager$__constructor__(android.media.midi.IMidiManager ), 0, this, iMidiManager);
    }

    public void registerDeviceCallback(DeviceCallback deviceCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerDeviceCallback", $$robo$$android_media_midi_MidiManager$registerDeviceCallback(android.media.midi.MidiManager$DeviceCallback android.os.Handler ), 0, this, deviceCallback, handler);
    }

    public void unregisterDeviceCallback(DeviceCallback deviceCallback) {
        InvokeDynamicSupport.bootstrap("unregisterDeviceCallback", $$robo$$android_media_midi_MidiManager$unregisterDeviceCallback(android.media.midi.MidiManager$DeviceCallback ), 0, this, deviceCallback);
    }

    public MidiDeviceInfo[] getDevices() {
        return InvokeDynamicSupport.bootstrap("getDevices", $$robo$$android_media_midi_MidiManager$getDevices(), 0, this);
    }

    private void sendOpenDeviceResponse(MidiDevice midiDevice, OnDeviceOpenedListener onDeviceOpenedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("sendOpenDeviceResponse", $$robo$$android_media_midi_MidiManager$sendOpenDeviceResponse(android.media.midi.MidiDevice android.media.midi.MidiManager$OnDeviceOpenedListener android.os.Handler ), 0, this, midiDevice, onDeviceOpenedListener, handler);
    }

    public void openDevice(MidiDeviceInfo midiDeviceInfo, OnDeviceOpenedListener onDeviceOpenedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("openDevice", $$robo$$android_media_midi_MidiManager$openDevice(android.media.midi.MidiDeviceInfo android.media.midi.MidiManager$OnDeviceOpenedListener android.os.Handler ), 0, this, midiDeviceInfo, onDeviceOpenedListener, handler);
    }

    public void openBluetoothDevice(BluetoothDevice bluetoothDevice, OnDeviceOpenedListener onDeviceOpenedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("openBluetoothDevice", $$robo$$android_media_midi_MidiManager$openBluetoothDevice(android.bluetooth.BluetoothDevice android.media.midi.MidiManager$OnDeviceOpenedListener android.os.Handler ), 0, this, bluetoothDevice, onDeviceOpenedListener, handler);
    }

    public MidiDeviceServer createDeviceServer(MidiReceiver[] midiReceiverArray, int n, String[] stringArray, String[] stringArray2, Bundle bundle, int n2, MidiDeviceServer.Callback callback) {
        return InvokeDynamicSupport.bootstrap("createDeviceServer", $$robo$$android_media_midi_MidiManager$createDeviceServer(android.media.midi.MidiReceiver[] int java.lang.String[] java.lang.String[] android.os.Bundle int android.media.midi.MidiDeviceServer$Callback ), 0, this, midiReceiverArray, n, stringArray, stringArray2, bundle, n2, callback);
    }

    public /* synthetic */ MidiManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MidiManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnDeviceOpenedListener
    extends InstrumentedInterface {
        public void onDeviceOpened(MidiDevice var1);
    }

    public static class DeviceCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_midi_MidiManager_DeviceCallback$__constructor__() {
        }

        private final void $$robo$$android_media_midi_MidiManager_DeviceCallback$onDeviceAdded(MidiDeviceInfo device) {
        }

        private final void $$robo$$android_media_midi_MidiManager_DeviceCallback$onDeviceRemoved(MidiDeviceInfo device) {
        }

        private final void $$robo$$android_media_midi_MidiManager_DeviceCallback$onDeviceStatusChanged(MidiDeviceStatus status) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_midi_MidiManager_DeviceCallback$__constructor__();
        }

        public DeviceCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiManager_DeviceCallback$__constructor__(), 0, this);
        }

        public void onDeviceAdded(MidiDeviceInfo midiDeviceInfo) {
            InvokeDynamicSupport.bootstrap("onDeviceAdded", $$robo$$android_media_midi_MidiManager_DeviceCallback$onDeviceAdded(android.media.midi.MidiDeviceInfo ), 0, this, midiDeviceInfo);
        }

        public void onDeviceRemoved(MidiDeviceInfo midiDeviceInfo) {
            InvokeDynamicSupport.bootstrap("onDeviceRemoved", $$robo$$android_media_midi_MidiManager_DeviceCallback$onDeviceRemoved(android.media.midi.MidiDeviceInfo ), 0, this, midiDeviceInfo);
        }

        public void onDeviceStatusChanged(MidiDeviceStatus midiDeviceStatus) {
            InvokeDynamicSupport.bootstrap("onDeviceStatusChanged", $$robo$$android_media_midi_MidiManager_DeviceCallback$onDeviceStatusChanged(android.media.midi.MidiDeviceStatus ), 0, this, midiDeviceStatus);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeviceCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DeviceListener
    extends IMidiDeviceListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private DeviceCallback mCallback;
        private Handler mHandler;
        /* synthetic */ MidiManager this$0;

        private void $$robo$$android_media_midi_MidiManager_DeviceListener$__constructor__(MidiManager midiManager, DeviceCallback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        private final void $$robo$$android_media_midi_MidiManager_DeviceListener$onDeviceAdded(MidiDeviceInfo device) {
            if (this.mHandler != null) {
                MidiDeviceInfo deviceF = device;
                this.mHandler.post(new Runnable(this, deviceF){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ MidiDeviceInfo val$deviceF;
                    /* synthetic */ DeviceListener this$1;

                    private void $$robo$$android_media_midi_MidiManager_DeviceListener_1$__constructor__(DeviceListener this$1, MidiDeviceInfo midiDeviceInfo) {
                    }

                    private final void $$robo$$android_media_midi_MidiManager_DeviceListener_1$run() {
                        this.this$1.mCallback.onDeviceAdded(this.val$deviceF);
                    }

                    private void __constructor__(DeviceListener deviceListener, MidiDeviceInfo midiDeviceInfo) {
                        this.$$robo$$android_media_midi_MidiManager_DeviceListener_1$__constructor__(deviceListener, midiDeviceInfo);
                    }
                    {
                        this.this$1 = deviceListener;
                        this.val$deviceF = midiDeviceInfo;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiManager_DeviceListener_1$__constructor__(android.media.midi.MidiManager$DeviceListener android.media.midi.MidiDeviceInfo ), 0, this, deviceListener, midiDeviceInfo);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_midi_MidiManager_DeviceListener_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else {
                this.mCallback.onDeviceAdded(device);
            }
        }

        private final void $$robo$$android_media_midi_MidiManager_DeviceListener$onDeviceRemoved(MidiDeviceInfo device) {
            if (this.mHandler != null) {
                MidiDeviceInfo deviceF = device;
                this.mHandler.post(new Runnable(this, deviceF){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ MidiDeviceInfo val$deviceF;
                    /* synthetic */ DeviceListener this$1;

                    private void $$robo$$android_media_midi_MidiManager_DeviceListener_2$__constructor__(DeviceListener this$1, MidiDeviceInfo midiDeviceInfo) {
                    }

                    private final void $$robo$$android_media_midi_MidiManager_DeviceListener_2$run() {
                        this.this$1.mCallback.onDeviceRemoved(this.val$deviceF);
                    }

                    private void __constructor__(DeviceListener deviceListener, MidiDeviceInfo midiDeviceInfo) {
                        this.$$robo$$android_media_midi_MidiManager_DeviceListener_2$__constructor__(deviceListener, midiDeviceInfo);
                    }
                    {
                        this.this$1 = deviceListener;
                        this.val$deviceF = midiDeviceInfo;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiManager_DeviceListener_2$__constructor__(android.media.midi.MidiManager$DeviceListener android.media.midi.MidiDeviceInfo ), 0, this, deviceListener, midiDeviceInfo);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_midi_MidiManager_DeviceListener_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else {
                this.mCallback.onDeviceRemoved(device);
            }
        }

        private final void $$robo$$android_media_midi_MidiManager_DeviceListener$onDeviceStatusChanged(MidiDeviceStatus status) {
            if (this.mHandler != null) {
                MidiDeviceStatus statusF = status;
                this.mHandler.post(new Runnable(this, statusF){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ MidiDeviceStatus val$statusF;
                    /* synthetic */ DeviceListener this$1;

                    private void $$robo$$android_media_midi_MidiManager_DeviceListener_3$__constructor__(DeviceListener this$1, MidiDeviceStatus midiDeviceStatus) {
                    }

                    private final void $$robo$$android_media_midi_MidiManager_DeviceListener_3$run() {
                        this.this$1.mCallback.onDeviceStatusChanged(this.val$statusF);
                    }

                    private void __constructor__(DeviceListener deviceListener, MidiDeviceStatus midiDeviceStatus) {
                        this.$$robo$$android_media_midi_MidiManager_DeviceListener_3$__constructor__(deviceListener, midiDeviceStatus);
                    }
                    {
                        this.this$1 = deviceListener;
                        this.val$statusF = midiDeviceStatus;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiManager_DeviceListener_3$__constructor__(android.media.midi.MidiManager$DeviceListener android.media.midi.MidiDeviceStatus ), 0, this, deviceListener, midiDeviceStatus);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_midi_MidiManager_DeviceListener_3$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else {
                this.mCallback.onDeviceStatusChanged(status);
            }
        }

        private void __constructor__(MidiManager midiManager, DeviceCallback deviceCallback, Handler handler) {
            this.$$robo$$android_media_midi_MidiManager_DeviceListener$__constructor__(midiManager, deviceCallback, handler);
        }

        public DeviceListener(MidiManager midiManager, DeviceCallback deviceCallback, Handler handler) {
            this.this$0 = midiManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiManager_DeviceListener$__constructor__(android.media.midi.MidiManager android.media.midi.MidiManager$DeviceCallback android.os.Handler ), 0, this, midiManager, deviceCallback, handler);
        }

        @Override
        public void onDeviceAdded(MidiDeviceInfo midiDeviceInfo) {
            InvokeDynamicSupport.bootstrap("onDeviceAdded", $$robo$$android_media_midi_MidiManager_DeviceListener$onDeviceAdded(android.media.midi.MidiDeviceInfo ), 0, this, midiDeviceInfo);
        }

        @Override
        public void onDeviceRemoved(MidiDeviceInfo midiDeviceInfo) {
            InvokeDynamicSupport.bootstrap("onDeviceRemoved", $$robo$$android_media_midi_MidiManager_DeviceListener$onDeviceRemoved(android.media.midi.MidiDeviceInfo ), 0, this, midiDeviceInfo);
        }

        @Override
        public void onDeviceStatusChanged(MidiDeviceStatus midiDeviceStatus) {
            InvokeDynamicSupport.bootstrap("onDeviceStatusChanged", $$robo$$android_media_midi_MidiManager_DeviceListener$onDeviceStatusChanged(android.media.midi.MidiDeviceStatus ), 0, this, midiDeviceStatus);
        }

        public /* synthetic */ DeviceListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeviceListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

