/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.Context;
import android.media.tv.TvInputManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayDeque;
import java.util.Queue;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TvRecordingClient
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TvRecordingClient";
    private static boolean DEBUG = false;
    private RecordingCallback mCallback;
    private Handler mHandler;
    private TvInputManager mTvInputManager;
    private TvInputManager.Session mSession;
    private MySessionCallback mSessionCallback;
    private boolean mIsRecordingStarted;
    private boolean mIsTuned;
    private Queue<Pair<String, Bundle>> mPendingAppPrivateCommands;

    private void $$robo$$android_media_tv_TvRecordingClient$__constructor__(Context context, String tag, RecordingCallback callback, Handler handler) {
        this.mPendingAppPrivateCommands = new ArrayDeque<Pair<String, Bundle>>();
        this.mCallback = callback;
        this.mHandler = handler == null ? new Handler(Looper.getMainLooper()) : handler;
        this.mTvInputManager = (TvInputManager)context.getSystemService("tv_input");
    }

    private final void $$robo$$android_media_tv_TvRecordingClient$tune(String inputId, Uri channelUri) {
        this.tune(inputId, channelUri, null);
    }

    private final void $$robo$$android_media_tv_TvRecordingClient$tune(String inputId, Uri channelUri, Bundle params) {
        if (TextUtils.isEmpty(inputId)) {
            throw new IllegalArgumentException("inputId cannot be null or an empty string");
        }
        if (this.mIsRecordingStarted) {
            throw new IllegalStateException("tune failed - recording already started");
        }
        if (this.mSessionCallback != null && TextUtils.equals(this.mSessionCallback.mInputId, inputId)) {
            if (this.mSession != null) {
                this.mSession.tune(channelUri, params);
            } else {
                this.mSessionCallback.mChannelUri = channelUri;
                this.mSessionCallback.mConnectionParams = params;
            }
        } else {
            this.resetInternal();
            this.mSessionCallback = new MySessionCallback(this, inputId, channelUri, params);
            if (this.mTvInputManager != null) {
                this.mTvInputManager.createRecordingSession(inputId, this.mSessionCallback, this.mHandler);
            }
        }
    }

    private final void $$robo$$android_media_tv_TvRecordingClient$release() {
        this.resetInternal();
    }

    private final void $$robo$$android_media_tv_TvRecordingClient$resetInternal() {
        this.mSessionCallback = null;
        this.mPendingAppPrivateCommands.clear();
        if (this.mSession != null) {
            this.mSession.release();
            this.mSession = null;
        }
    }

    private final void $$robo$$android_media_tv_TvRecordingClient$startRecording(Uri programUri) {
        if (!this.mIsTuned) {
            throw new IllegalStateException("startRecording failed - not yet tuned");
        }
        if (this.mSession != null) {
            this.mSession.startRecording(programUri);
            this.mIsRecordingStarted = true;
        }
    }

    private final void $$robo$$android_media_tv_TvRecordingClient$stopRecording() {
        if (!this.mIsRecordingStarted) {
            Log.w("TvRecordingClient", "stopRecording failed - recording not yet started");
        }
        if (this.mSession != null) {
            this.mSession.stopRecording();
        }
    }

    private final void $$robo$$android_media_tv_TvRecordingClient$sendAppPrivateCommand(String action, Bundle data) {
        if (TextUtils.isEmpty(action)) {
            throw new IllegalArgumentException("action cannot be null or an empty string");
        }
        if (this.mSession != null) {
            this.mSession.sendAppPrivateCommand(action, data);
        } else {
            Log.w("TvRecordingClient", "sendAppPrivateCommand - session not yet created (action \"" + action + "\" pending)");
            this.mPendingAppPrivateCommands.add(Pair.create(action, data));
        }
    }

    private void __constructor__(Context context, String string2, RecordingCallback recordingCallback, Handler handler) {
        this.$$robo$$android_media_tv_TvRecordingClient$__constructor__(context, string2, recordingCallback, handler);
    }

    public TvRecordingClient(Context context, String string2, RecordingCallback recordingCallback, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvRecordingClient$__constructor__(android.content.Context java.lang.String android.media.tv.TvRecordingClient$RecordingCallback android.os.Handler ), 0, this, context, string2, recordingCallback, handler);
    }

    public void tune(String string2, Uri uri) {
        InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_TvRecordingClient$tune(java.lang.String android.net.Uri ), 0, this, string2, uri);
    }

    public void tune(String string2, Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_TvRecordingClient$tune(java.lang.String android.net.Uri android.os.Bundle ), 0, this, string2, uri, bundle);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_tv_TvRecordingClient$release(), 0, this);
    }

    private void resetInternal() {
        InvokeDynamicSupport.bootstrap("resetInternal", $$robo$$android_media_tv_TvRecordingClient$resetInternal(), 0, this);
    }

    public void startRecording(Uri uri) {
        InvokeDynamicSupport.bootstrap("startRecording", $$robo$$android_media_tv_TvRecordingClient$startRecording(android.net.Uri ), 0, this, uri);
    }

    public void stopRecording() {
        InvokeDynamicSupport.bootstrap("stopRecording", $$robo$$android_media_tv_TvRecordingClient$stopRecording(), 0, this);
    }

    public void sendAppPrivateCommand(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendAppPrivateCommand", $$robo$$android_media_tv_TvRecordingClient$sendAppPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    public /* synthetic */ TvRecordingClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvRecordingClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MySessionCallback
    extends TvInputManager.SessionCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mInputId;
        Uri mChannelUri;
        Bundle mConnectionParams;
        /* synthetic */ TvRecordingClient this$0;

        private void $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$__constructor__(TvRecordingClient tvRecordingClient, String inputId, Uri channelUri, Bundle connectionParams) {
            this.mInputId = inputId;
            this.mChannelUri = channelUri;
            this.mConnectionParams = connectionParams;
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onSessionCreated(TvInputManager.Session session) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvRecordingClient", "onSessionCreated - session already created");
                if (session != null) {
                    session.release();
                }
                return;
            }
            this.this$0.mSession = session;
            if (session != null) {
                for (Pair command : this.this$0.mPendingAppPrivateCommands) {
                    this.this$0.mSession.sendAppPrivateCommand((String)command.first, (Bundle)command.second);
                }
                this.this$0.mPendingAppPrivateCommands.clear();
                this.this$0.mSession.tune(this.mChannelUri, this.mConnectionParams);
            } else {
                this.this$0.mSessionCallback = null;
                if (this.this$0.mCallback != null) {
                    this.this$0.mCallback.onConnectionFailed(this.mInputId);
                }
            }
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onTuned(TvInputManager.Session session, Uri channelUri) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvRecordingClient", "onTuned - session not created");
                return;
            }
            this.this$0.mIsTuned = true;
            this.this$0.mCallback.onTuned(channelUri);
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onSessionReleased(TvInputManager.Session session) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvRecordingClient", "onSessionReleased - session not created");
                return;
            }
            this.this$0.mIsTuned = false;
            this.this$0.mIsRecordingStarted = false;
            this.this$0.mSessionCallback = null;
            this.this$0.mSession = null;
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onDisconnected(this.mInputId);
            }
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onRecordingStopped(TvInputManager.Session session, Uri recordedProgramUri) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvRecordingClient", "onRecordingStopped - session not created");
                return;
            }
            this.this$0.mIsRecordingStarted = false;
            this.this$0.mCallback.onRecordingStopped(recordedProgramUri);
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onError(TvInputManager.Session session, int error) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvRecordingClient", "onError - session not created");
                return;
            }
            this.this$0.mCallback.onError(error);
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onSessionEvent(TvInputManager.Session session, String eventType, Bundle eventArgs) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvRecordingClient", "onSessionEvent - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onEvent(this.mInputId, eventType, eventArgs);
            }
        }

        private void __constructor__(TvRecordingClient tvRecordingClient, String string2, Uri uri, Bundle bundle) {
            this.$$robo$$android_media_tv_TvRecordingClient_MySessionCallback$__constructor__(tvRecordingClient, string2, uri, bundle);
        }

        MySessionCallback(TvRecordingClient tvRecordingClient, String string2, Uri uri, Bundle bundle) {
            this.this$0 = tvRecordingClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$__constructor__(android.media.tv.TvRecordingClient java.lang.String android.net.Uri android.os.Bundle ), 0, this, tvRecordingClient, string2, uri, bundle);
        }

        @Override
        public void onSessionCreated(TvInputManager.Session session) {
            InvokeDynamicSupport.bootstrap("onSessionCreated", $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onSessionCreated(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        @Override
        void onTuned(TvInputManager.Session session, Uri uri) {
            InvokeDynamicSupport.bootstrap("onTuned", $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onTuned(android.media.tv.TvInputManager$Session android.net.Uri ), 0, this, session, uri);
        }

        @Override
        public void onSessionReleased(TvInputManager.Session session) {
            InvokeDynamicSupport.bootstrap("onSessionReleased", $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onSessionReleased(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        @Override
        public void onRecordingStopped(TvInputManager.Session session, Uri uri) {
            InvokeDynamicSupport.bootstrap("onRecordingStopped", $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onRecordingStopped(android.media.tv.TvInputManager$Session android.net.Uri ), 0, this, session, uri);
        }

        @Override
        public void onError(TvInputManager.Session session, int n) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onError(android.media.tv.TvInputManager$Session int ), 0, this, session, n);
        }

        @Override
        public void onSessionEvent(TvInputManager.Session session, String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onSessionEvent", $$robo$$android_media_tv_TvRecordingClient_MySessionCallback$onSessionEvent(android.media.tv.TvInputManager$Session java.lang.String android.os.Bundle ), 0, this, session, string2, bundle);
        }

        public /* synthetic */ MySessionCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MySessionCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class RecordingCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$__constructor__() {
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onConnectionFailed(String inputId) {
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onDisconnected(String inputId) {
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onTuned(Uri channelUri) {
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onRecordingStopped(Uri recordedProgramUri) {
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onError(int error) {
        }

        private final void $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onEvent(String inputId, String eventType, Bundle eventArgs) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvRecordingClient_RecordingCallback$__constructor__();
        }

        public RecordingCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$__constructor__(), 0, this);
        }

        public void onConnectionFailed(String string2) {
            InvokeDynamicSupport.bootstrap("onConnectionFailed", $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onConnectionFailed(java.lang.String ), 0, this, string2);
        }

        public void onDisconnected(String string2) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onDisconnected(java.lang.String ), 0, this, string2);
        }

        public void onTuned(Uri uri) {
            InvokeDynamicSupport.bootstrap("onTuned", $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onTuned(android.net.Uri ), 0, this, uri);
        }

        public void onRecordingStopped(Uri uri) {
            InvokeDynamicSupport.bootstrap("onRecordingStopped", $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onRecordingStopped(android.net.Uri ), 0, this, uri);
        }

        public void onError(int n) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onError(int ), 0, this, n);
        }

        public void onEvent(String string2, String string3, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onEvent", $$robo$$android_media_tv_TvRecordingClient_RecordingCallback$onEvent(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecordingCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

