/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.mtp.MtpDeviceInfo;
import android.mtp.MtpEvent;
import android.mtp.MtpObjectInfo;
import android.mtp.MtpStorageInfo;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.UserManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MtpDevice
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MtpDevice";
    private UsbDevice mDevice;
    @GuardedBy(value="mLock")
    private CloseGuard mCloseGuard;
    @GuardedBy(value="mLock")
    private UsbDeviceConnection mConnection;
    private Object mLock;
    private long mNativeContext;

    private void $$robo$$android_mtp_MtpDevice$__constructor__(UsbDevice device) {
        this.mCloseGuard = CloseGuard.get();
        this.mLock = new Object();
        Preconditions.checkNotNull(device);
        this.mDevice = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_mtp_MtpDevice$open(UsbDeviceConnection connection) {
        boolean result = false;
        Context context = connection.getContext();
        Object object = this.mLock;
        synchronized (object) {
            UserManager userManager;
            if (context != null && !(userManager = (UserManager)context.getSystemService("user")).hasUserRestriction("no_usb_file_transfer")) {
                result = this.native_open(this.mDevice.getDeviceName(), connection.getFileDescriptor());
            }
            if (!result) {
                connection.close();
            } else {
                this.mConnection = connection;
                this.mCloseGuard.open("close");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_mtp_MtpDevice$close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection != null) {
                this.mCloseGuard.close();
                this.native_close();
                this.mConnection.close();
                this.mConnection = null;
            }
        }
    }

    private final void $$robo$$android_mtp_MtpDevice$finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final String $$robo$$android_mtp_MtpDevice$getDeviceName() {
        return this.mDevice.getDeviceName();
    }

    private final int $$robo$$android_mtp_MtpDevice$getDeviceId() {
        return this.mDevice.getDeviceId();
    }

    private final String $$robo$$android_mtp_MtpDevice$toString() {
        return this.mDevice.getDeviceName();
    }

    private final MtpDeviceInfo $$robo$$android_mtp_MtpDevice$getDeviceInfo() {
        return this.native_get_device_info();
    }

    private final int[] $$robo$$android_mtp_MtpDevice$getStorageIds() {
        return this.native_get_storage_ids();
    }

    private final int[] $$robo$$android_mtp_MtpDevice$getObjectHandles(int storageId, int format, int objectHandle) {
        return this.native_get_object_handles(storageId, format, objectHandle);
    }

    private final byte[] $$robo$$android_mtp_MtpDevice$getObject(int objectHandle, int objectSize) {
        Preconditions.checkArgumentNonnegative(objectSize, "objectSize should not be negative");
        return this.native_get_object(objectHandle, objectSize);
    }

    private final long $$robo$$android_mtp_MtpDevice$getPartialObject(int objectHandle, long offset, long size, byte[] buffer) throws IOException {
        return this.native_get_partial_object(objectHandle, offset, size, buffer);
    }

    private final long $$robo$$android_mtp_MtpDevice$getPartialObject64(int objectHandle, long offset, long size, byte[] buffer) throws IOException {
        return this.native_get_partial_object_64(objectHandle, offset, size, buffer);
    }

    private final byte[] $$robo$$android_mtp_MtpDevice$getThumbnail(int objectHandle) {
        return this.native_get_thumbnail(objectHandle);
    }

    private final MtpStorageInfo $$robo$$android_mtp_MtpDevice$getStorageInfo(int storageId) {
        return this.native_get_storage_info(storageId);
    }

    private final MtpObjectInfo $$robo$$android_mtp_MtpDevice$getObjectInfo(int objectHandle) {
        return this.native_get_object_info(objectHandle);
    }

    private final boolean $$robo$$android_mtp_MtpDevice$deleteObject(int objectHandle) {
        return this.native_delete_object(objectHandle);
    }

    private final long $$robo$$android_mtp_MtpDevice$getParent(int objectHandle) {
        return this.native_get_parent(objectHandle);
    }

    private final long $$robo$$android_mtp_MtpDevice$getStorageId(int objectHandle) {
        return this.native_get_storage_id(objectHandle);
    }

    private final boolean $$robo$$android_mtp_MtpDevice$importFile(int objectHandle, String destPath) {
        return this.native_import_file(objectHandle, destPath);
    }

    private final boolean $$robo$$android_mtp_MtpDevice$importFile(int objectHandle, ParcelFileDescriptor descriptor) {
        return this.native_import_file(objectHandle, descriptor.getFd());
    }

    private final boolean $$robo$$android_mtp_MtpDevice$sendObject(int objectHandle, long size, ParcelFileDescriptor descriptor) {
        return this.native_send_object(objectHandle, size, descriptor.getFd());
    }

    private final MtpObjectInfo $$robo$$android_mtp_MtpDevice$sendObjectInfo(MtpObjectInfo info) {
        return this.native_send_object_info(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MtpEvent $$robo$$android_mtp_MtpDevice$readEvent(CancellationSignal signal) throws IOException {
        int handle = this.native_submit_event_request();
        Preconditions.checkState(handle >= 0, "Other thread is reading an event.");
        if (signal != null) {
            signal.setOnCancelListener(new CancellationSignal.OnCancelListener(this, handle){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$handle;
                /* synthetic */ MtpDevice this$0;

                private void $$robo$$android_mtp_MtpDevice_1$__constructor__(MtpDevice this$0, int n) {
                }

                private final void $$robo$$android_mtp_MtpDevice_1$onCancel() {
                    this.this$0.native_discard_event_request(this.val$handle);
                }

                private void __constructor__(MtpDevice mtpDevice, int n) {
                    this.$$robo$$android_mtp_MtpDevice_1$__constructor__(mtpDevice, n);
                }
                {
                    this.this$0 = mtpDevice;
                    this.val$handle = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpDevice_1$__constructor__(android.mtp.MtpDevice int ), 0, this, mtpDevice, n);
                }

                @Override
                public void onCancel() {
                    InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_mtp_MtpDevice_1$onCancel(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        try {
            MtpEvent mtpEvent = this.native_reap_event_request(handle);
            return mtpEvent;
        }
        finally {
            if (signal != null) {
                signal.setOnCancelListener(null);
            }
        }
    }

    private final long $$robo$$android_mtp_MtpDevice$getObjectSizeLong(int handle, int format) throws IOException {
        return this.native_get_object_size_long(handle, format);
    }

    private final boolean $$robo$$android_mtp_MtpDevice$native_open(String string2, int n) {
        return false;
    }

    private final void $$robo$$android_mtp_MtpDevice$native_close() {
    }

    private final MtpDeviceInfo $$robo$$android_mtp_MtpDevice$native_get_device_info() {
        return null;
    }

    private final int[] $$robo$$android_mtp_MtpDevice$native_get_storage_ids() {
        return null;
    }

    private final MtpStorageInfo $$robo$$android_mtp_MtpDevice$native_get_storage_info(int n) {
        return null;
    }

    private final int[] $$robo$$android_mtp_MtpDevice$native_get_object_handles(int n, int n2, int n3) {
        return null;
    }

    private final MtpObjectInfo $$robo$$android_mtp_MtpDevice$native_get_object_info(int n) {
        return null;
    }

    private final byte[] $$robo$$android_mtp_MtpDevice$native_get_object(int n, long l) {
        return null;
    }

    private final long $$robo$$android_mtp_MtpDevice$native_get_partial_object(int n, long l, long l2, byte[] byArray) throws IOException {
        return 0L;
    }

    private final int $$robo$$android_mtp_MtpDevice$native_get_partial_object_64(int n, long l, long l2, byte[] byArray) throws IOException {
        return 0;
    }

    private final byte[] $$robo$$android_mtp_MtpDevice$native_get_thumbnail(int n) {
        return null;
    }

    private final boolean $$robo$$android_mtp_MtpDevice$native_delete_object(int n) {
        return false;
    }

    private final int $$robo$$android_mtp_MtpDevice$native_get_parent(int n) {
        return 0;
    }

    private final int $$robo$$android_mtp_MtpDevice$native_get_storage_id(int n) {
        return 0;
    }

    private final boolean $$robo$$android_mtp_MtpDevice$native_import_file(int n, String string2) {
        return false;
    }

    private final boolean $$robo$$android_mtp_MtpDevice$native_import_file(int n, int n2) {
        return false;
    }

    private final boolean $$robo$$android_mtp_MtpDevice$native_send_object(int n, long l, int n2) {
        return false;
    }

    private final MtpObjectInfo $$robo$$android_mtp_MtpDevice$native_send_object_info(MtpObjectInfo mtpObjectInfo) {
        return null;
    }

    private final int $$robo$$android_mtp_MtpDevice$native_submit_event_request() throws IOException {
        return 0;
    }

    private final MtpEvent $$robo$$android_mtp_MtpDevice$native_reap_event_request(int n) throws IOException {
        return null;
    }

    private final void $$robo$$android_mtp_MtpDevice$native_discard_event_request(int n) {
    }

    private final long $$robo$$android_mtp_MtpDevice$native_get_object_size_long(int n, int n2) throws IOException {
        return 0L;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
    }

    private void __constructor__(UsbDevice usbDevice) {
        this.$$robo$$android_mtp_MtpDevice$__constructor__(usbDevice);
    }

    public MtpDevice(UsbDevice usbDevice) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpDevice$__constructor__(android.hardware.usb.UsbDevice ), 0, this, usbDevice);
    }

    public boolean open(UsbDeviceConnection usbDeviceConnection) {
        return (boolean)InvokeDynamicSupport.bootstrap("open", $$robo$$android_mtp_MtpDevice$open(android.hardware.usb.UsbDeviceConnection ), 0, this, usbDeviceConnection);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_mtp_MtpDevice$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_mtp_MtpDevice$finalize(), 0, this);
    }

    public String getDeviceName() {
        return InvokeDynamicSupport.bootstrap("getDeviceName", $$robo$$android_mtp_MtpDevice$getDeviceName(), 0, this);
    }

    public int getDeviceId() {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$android_mtp_MtpDevice$getDeviceId(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_mtp_MtpDevice$toString(), 0, this);
    }

    public MtpDeviceInfo getDeviceInfo() {
        return InvokeDynamicSupport.bootstrap("getDeviceInfo", $$robo$$android_mtp_MtpDevice$getDeviceInfo(), 0, this);
    }

    public int[] getStorageIds() {
        return InvokeDynamicSupport.bootstrap("getStorageIds", $$robo$$android_mtp_MtpDevice$getStorageIds(), 0, this);
    }

    public int[] getObjectHandles(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("getObjectHandles", $$robo$$android_mtp_MtpDevice$getObjectHandles(int int int ), 0, this, n, n2, n3);
    }

    public byte[] getObject(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getObject", $$robo$$android_mtp_MtpDevice$getObject(int int ), 0, this, n, n2);
    }

    public long getPartialObject(int n, long l, long l2, byte[] byArray) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("getPartialObject", $$robo$$android_mtp_MtpDevice$getPartialObject(int long long byte[] ), 0, this, n, l, l2, byArray);
    }

    public long getPartialObject64(int n, long l, long l2, byte[] byArray) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("getPartialObject64", $$robo$$android_mtp_MtpDevice$getPartialObject64(int long long byte[] ), 0, this, n, l, l2, byArray);
    }

    public byte[] getThumbnail(int n) {
        return InvokeDynamicSupport.bootstrap("getThumbnail", $$robo$$android_mtp_MtpDevice$getThumbnail(int ), 0, this, n);
    }

    public MtpStorageInfo getStorageInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getStorageInfo", $$robo$$android_mtp_MtpDevice$getStorageInfo(int ), 0, this, n);
    }

    public MtpObjectInfo getObjectInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getObjectInfo", $$robo$$android_mtp_MtpDevice$getObjectInfo(int ), 0, this, n);
    }

    public boolean deleteObject(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteObject", $$robo$$android_mtp_MtpDevice$deleteObject(int ), 0, this, n);
    }

    public long getParent(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getParent", $$robo$$android_mtp_MtpDevice$getParent(int ), 0, this, n);
    }

    public long getStorageId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getStorageId", $$robo$$android_mtp_MtpDevice$getStorageId(int ), 0, this, n);
    }

    public boolean importFile(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("importFile", $$robo$$android_mtp_MtpDevice$importFile(int java.lang.String ), 0, this, n, string2);
    }

    public boolean importFile(int n, ParcelFileDescriptor parcelFileDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrap("importFile", $$robo$$android_mtp_MtpDevice$importFile(int android.os.ParcelFileDescriptor ), 0, this, n, parcelFileDescriptor);
    }

    public boolean sendObject(int n, long l, ParcelFileDescriptor parcelFileDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendObject", $$robo$$android_mtp_MtpDevice$sendObject(int long android.os.ParcelFileDescriptor ), 0, this, n, l, parcelFileDescriptor);
    }

    public MtpObjectInfo sendObjectInfo(MtpObjectInfo mtpObjectInfo) {
        return InvokeDynamicSupport.bootstrap("sendObjectInfo", $$robo$$android_mtp_MtpDevice$sendObjectInfo(android.mtp.MtpObjectInfo ), 0, this, mtpObjectInfo);
    }

    public MtpEvent readEvent(CancellationSignal cancellationSignal) throws IOException {
        return InvokeDynamicSupport.bootstrap("readEvent", $$robo$$android_mtp_MtpDevice$readEvent(android.os.CancellationSignal ), 0, this, cancellationSignal);
    }

    public long getObjectSizeLong(int n, int n2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("getObjectSizeLong", $$robo$$android_mtp_MtpDevice$getObjectSizeLong(int int ), 0, this, n, n2);
    }

    private final native /* synthetic */ boolean $$robo$$native_open$nativeBinding(String var1, int var2);

    private boolean native_open(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_open", $$robo$$android_mtp_MtpDevice$native_open(java.lang.String int ), 1, this, string2, n);
    }

    private final native /* synthetic */ void $$robo$$native_close$nativeBinding();

    private void native_close() {
        InvokeDynamicSupport.bootstrap("native_close", $$robo$$android_mtp_MtpDevice$native_close(), 1, this);
    }

    private final native /* synthetic */ MtpDeviceInfo $$robo$$native_get_device_info$nativeBinding();

    private MtpDeviceInfo native_get_device_info() {
        return InvokeDynamicSupport.bootstrap("native_get_device_info", $$robo$$android_mtp_MtpDevice$native_get_device_info(), 1, this);
    }

    private final native /* synthetic */ int[] $$robo$$native_get_storage_ids$nativeBinding();

    private int[] native_get_storage_ids() {
        return InvokeDynamicSupport.bootstrap("native_get_storage_ids", $$robo$$android_mtp_MtpDevice$native_get_storage_ids(), 1, this);
    }

    private final native /* synthetic */ MtpStorageInfo $$robo$$native_get_storage_info$nativeBinding(int var1);

    private MtpStorageInfo native_get_storage_info(int n) {
        return InvokeDynamicSupport.bootstrap("native_get_storage_info", $$robo$$android_mtp_MtpDevice$native_get_storage_info(int ), 1, this, n);
    }

    private final native /* synthetic */ int[] $$robo$$native_get_object_handles$nativeBinding(int var1, int var2, int var3);

    private int[] native_get_object_handles(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("native_get_object_handles", $$robo$$android_mtp_MtpDevice$native_get_object_handles(int int int ), 1, this, n, n2, n3);
    }

    private final native /* synthetic */ MtpObjectInfo $$robo$$native_get_object_info$nativeBinding(int var1);

    private MtpObjectInfo native_get_object_info(int n) {
        return InvokeDynamicSupport.bootstrap("native_get_object_info", $$robo$$android_mtp_MtpDevice$native_get_object_info(int ), 1, this, n);
    }

    private final native /* synthetic */ byte[] $$robo$$native_get_object$nativeBinding(int var1, long var2);

    private byte[] native_get_object(int n, long l) {
        return InvokeDynamicSupport.bootstrap("native_get_object", $$robo$$android_mtp_MtpDevice$native_get_object(int long ), 1, this, n, l);
    }

    private final native /* synthetic */ long $$robo$$native_get_partial_object$nativeBinding(int var1, long var2, long var4, byte[] var6) throws IOException;

    private long native_get_partial_object(int n, long l, long l2, byte[] byArray) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("native_get_partial_object", $$robo$$android_mtp_MtpDevice$native_get_partial_object(int long long byte[] ), 1, this, n, l, l2, byArray);
    }

    private final native /* synthetic */ int $$robo$$native_get_partial_object_64$nativeBinding(int var1, long var2, long var4, byte[] var6) throws IOException;

    private int native_get_partial_object_64(int n, long l, long l2, byte[] byArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("native_get_partial_object_64", $$robo$$android_mtp_MtpDevice$native_get_partial_object_64(int long long byte[] ), 1, this, n, l, l2, byArray);
    }

    private final native /* synthetic */ byte[] $$robo$$native_get_thumbnail$nativeBinding(int var1);

    private byte[] native_get_thumbnail(int n) {
        return InvokeDynamicSupport.bootstrap("native_get_thumbnail", $$robo$$android_mtp_MtpDevice$native_get_thumbnail(int ), 1, this, n);
    }

    private final native /* synthetic */ boolean $$robo$$native_delete_object$nativeBinding(int var1);

    private boolean native_delete_object(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_delete_object", $$robo$$android_mtp_MtpDevice$native_delete_object(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_parent$nativeBinding(int var1);

    private int native_get_parent(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_get_parent", $$robo$$android_mtp_MtpDevice$native_get_parent(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_storage_id$nativeBinding(int var1);

    private int native_get_storage_id(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_get_storage_id", $$robo$$android_mtp_MtpDevice$native_get_storage_id(int ), 1, this, n);
    }

    private final native /* synthetic */ boolean $$robo$$native_import_file$nativeBinding(int var1, String var2);

    private boolean native_import_file(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_import_file", $$robo$$android_mtp_MtpDevice$native_import_file(int java.lang.String ), 1, this, n, string2);
    }

    private final native /* synthetic */ boolean $$robo$$native_import_file$nativeBinding(int var1, int var2);

    private boolean native_import_file(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_import_file", $$robo$$android_mtp_MtpDevice$native_import_file(int int ), 1, this, n, n2);
    }

    private final native /* synthetic */ boolean $$robo$$native_send_object$nativeBinding(int var1, long var2, int var4);

    private boolean native_send_object(int n, long l, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_send_object", $$robo$$android_mtp_MtpDevice$native_send_object(int long int ), 1, this, n, l, n2);
    }

    private final native /* synthetic */ MtpObjectInfo $$robo$$native_send_object_info$nativeBinding(MtpObjectInfo var1);

    private MtpObjectInfo native_send_object_info(MtpObjectInfo mtpObjectInfo) {
        return InvokeDynamicSupport.bootstrap("native_send_object_info", $$robo$$android_mtp_MtpDevice$native_send_object_info(android.mtp.MtpObjectInfo ), 1, this, mtpObjectInfo);
    }

    private final native /* synthetic */ int $$robo$$native_submit_event_request$nativeBinding() throws IOException;

    private int native_submit_event_request() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("native_submit_event_request", $$robo$$android_mtp_MtpDevice$native_submit_event_request(), 1, this);
    }

    private final native /* synthetic */ MtpEvent $$robo$$native_reap_event_request$nativeBinding(int var1) throws IOException;

    private MtpEvent native_reap_event_request(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("native_reap_event_request", $$robo$$android_mtp_MtpDevice$native_reap_event_request(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$native_discard_event_request$nativeBinding(int var1);

    private void native_discard_event_request(int n) {
        InvokeDynamicSupport.bootstrap("native_discard_event_request", $$robo$$android_mtp_MtpDevice$native_discard_event_request(int ), 1, this, n);
    }

    private final native /* synthetic */ long $$robo$$native_get_object_size_long$nativeBinding(int var1, int var2) throws IOException;

    private long native_get_object_size_long(int n, int n2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("native_get_object_size_long", $$robo$$android_mtp_MtpDevice$native_get_object_size_long(int int ), 1, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(MtpDevice.class);
    }

    public /* synthetic */ MtpDevice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MtpDevice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

