/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.BitUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NetworkCapabilities
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkCapabilities";
    private long mNetworkCapabilities;
    public static int NET_CAPABILITY_MMS = 0;
    public static int NET_CAPABILITY_SUPL = 1;
    public static int NET_CAPABILITY_DUN = 2;
    public static int NET_CAPABILITY_FOTA = 3;
    public static int NET_CAPABILITY_IMS = 4;
    public static int NET_CAPABILITY_CBS = 5;
    public static int NET_CAPABILITY_WIFI_P2P = 6;
    public static int NET_CAPABILITY_IA = 7;
    public static int NET_CAPABILITY_RCS = 8;
    public static int NET_CAPABILITY_XCAP = 9;
    public static int NET_CAPABILITY_EIMS = 10;
    public static int NET_CAPABILITY_NOT_METERED = 11;
    public static int NET_CAPABILITY_INTERNET = 12;
    public static int NET_CAPABILITY_NOT_RESTRICTED = 13;
    public static int NET_CAPABILITY_TRUSTED = 14;
    public static int NET_CAPABILITY_NOT_VPN = 15;
    public static int NET_CAPABILITY_VALIDATED = 16;
    public static int NET_CAPABILITY_CAPTIVE_PORTAL = 17;
    public static int NET_CAPABILITY_FOREGROUND = 18;
    private static int MIN_NET_CAPABILITY = 0;
    private static int MAX_NET_CAPABILITY = 18;
    private static long MUTABLE_CAPABILITIES = 475136L;
    private static long NON_REQUESTABLE_CAPABILITIES = 458752L;
    private static long DEFAULT_CAPABILITIES = 57344L;
    static long RESTRICTED_CAPABILITIES = 1980L;
    static long UNRESTRICTED_CAPABILITIES = 4163L;
    private long mTransportTypes;
    public static int TRANSPORT_CELLULAR = 0;
    public static int TRANSPORT_WIFI = 1;
    public static int TRANSPORT_BLUETOOTH = 2;
    public static int TRANSPORT_ETHERNET = 3;
    public static int TRANSPORT_VPN = 4;
    public static int TRANSPORT_WIFI_AWARE = 5;
    public static int MIN_TRANSPORT = 0;
    public static int MAX_TRANSPORT = 5;
    private static String[] TRANSPORT_NAMES;
    private int mLinkUpBandwidthKbps;
    private int mLinkDownBandwidthKbps;
    private NetworkSpecifier mNetworkSpecifier;
    public static int SIGNAL_STRENGTH_UNSPECIFIED = Integer.MIN_VALUE;
    private int mSignalStrength;
    public static Parcelable.Creator<NetworkCapabilities> CREATOR;

    private void $$robo$$android_net_NetworkCapabilities$__constructor__() {
        this.mNetworkSpecifier = null;
        this.clearAll();
        this.mNetworkCapabilities = 57344L;
    }

    private void $$robo$$android_net_NetworkCapabilities$__constructor__(NetworkCapabilities nc) {
        this.mNetworkSpecifier = null;
        if (nc != null) {
            this.mNetworkCapabilities = nc.mNetworkCapabilities;
            this.mTransportTypes = nc.mTransportTypes;
            this.mLinkUpBandwidthKbps = nc.mLinkUpBandwidthKbps;
            this.mLinkDownBandwidthKbps = nc.mLinkDownBandwidthKbps;
            this.mNetworkSpecifier = nc.mNetworkSpecifier;
            this.mSignalStrength = nc.mSignalStrength;
        }
    }

    private final void $$robo$$android_net_NetworkCapabilities$clearAll() {
        this.mTransportTypes = 0L;
        this.mNetworkCapabilities = 0L;
        this.mLinkDownBandwidthKbps = 0;
        this.mLinkUpBandwidthKbps = 0;
        this.mNetworkSpecifier = null;
        this.mSignalStrength = Integer.MIN_VALUE;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$addCapability(int capability) {
        if (capability < 0 || capability > 18) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities |= (long)(1 << capability);
        return this;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$removeCapability(int capability) {
        if (capability < 0 || capability > 18) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities &= (long)(~(1 << capability));
        return this;
    }

    private final int[] $$robo$$android_net_NetworkCapabilities$getCapabilities() {
        return BitUtils.unpackBits(this.mNetworkCapabilities);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$hasCapability(int capability) {
        if (capability < 0 || capability > 18) {
            return false;
        }
        return (this.mNetworkCapabilities & (long)(1 << capability)) != 0L;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineNetCapabilities(NetworkCapabilities nc) {
        this.mNetworkCapabilities |= nc.mNetworkCapabilities;
    }

    private final String $$robo$$android_net_NetworkCapabilities$describeFirstNonRequestableCapability() {
        if (this.hasCapability(16)) {
            return "NET_CAPABILITY_VALIDATED";
        }
        if (this.hasCapability(17)) {
            return "NET_CAPABILITY_CAPTIVE_PORTAL";
        }
        if (this.hasCapability(18)) {
            return "NET_CAPABILITY_FOREGROUND";
        }
        if ((this.mNetworkCapabilities & 0x70000L) != 0L) {
            return "unknown non-requestable capabilities " + Long.toHexString(this.mNetworkCapabilities);
        }
        if (this.mLinkUpBandwidthKbps != 0 || this.mLinkDownBandwidthKbps != 0) {
            return "link bandwidth";
        }
        if (this.hasSignalStrength()) {
            return "signalStrength";
        }
        return null;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByNetCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        long networkCapabilities = this.mNetworkCapabilities;
        if (onlyImmutable) {
            networkCapabilities &= 0xFFFFFFFFFFF8BFFFL;
        }
        return (nc.mNetworkCapabilities & networkCapabilities) == networkCapabilities;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsNetCapabilities(NetworkCapabilities nc) {
        return nc.mNetworkCapabilities == this.mNetworkCapabilities;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsNetCapabilitiesImmutable(NetworkCapabilities that) {
        return (this.mNetworkCapabilities & 0xFFFFFFFFFFF8BFFFL) == (that.mNetworkCapabilities & 0xFFFFFFFFFFF8BFFFL);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsNetCapabilitiesRequestable(NetworkCapabilities that) {
        return (this.mNetworkCapabilities & 0xFFFFFFFFFFF8FFFFL) == (that.mNetworkCapabilities & 0xFFFFFFFFFFF8FFFFL);
    }

    private final void $$robo$$android_net_NetworkCapabilities$maybeMarkCapabilitiesRestricted() {
        boolean hasRestrictedCapabilities;
        boolean hasUnrestrictedCapabilities = (this.mNetworkCapabilities & 0x1043L) != 0L;
        boolean bl = hasRestrictedCapabilities = (this.mNetworkCapabilities & 0x7BCL) != 0L;
        if (hasRestrictedCapabilities && !hasUnrestrictedCapabilities) {
            this.removeCapability(13);
        }
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$addTransportType(int transportType) {
        if (transportType < 0 || transportType > 5) {
            throw new IllegalArgumentException("TransportType out of range");
        }
        this.mTransportTypes |= (long)(1 << transportType);
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$removeTransportType(int transportType) {
        if (transportType < 0 || transportType > 5) {
            throw new IllegalArgumentException("TransportType out of range");
        }
        this.mTransportTypes &= (long)(~(1 << transportType));
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    private final int[] $$robo$$android_net_NetworkCapabilities$getTransportTypes() {
        return BitUtils.unpackBits(this.mTransportTypes);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$hasTransport(int transportType) {
        if (transportType < 0 || transportType > 5) {
            return false;
        }
        return (this.mTransportTypes & (long)(1 << transportType)) != 0L;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineTransportTypes(NetworkCapabilities nc) {
        this.mTransportTypes |= nc.mTransportTypes;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByTransportTypes(NetworkCapabilities nc) {
        return this.mTransportTypes == 0L || (this.mTransportTypes & nc.mTransportTypes) != 0L;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsTransportTypes(NetworkCapabilities nc) {
        return nc.mTransportTypes == this.mTransportTypes;
    }

    private final void $$robo$$android_net_NetworkCapabilities$setLinkUpstreamBandwidthKbps(int upKbps) {
        this.mLinkUpBandwidthKbps = upKbps;
    }

    private final int $$robo$$android_net_NetworkCapabilities$getLinkUpstreamBandwidthKbps() {
        return this.mLinkUpBandwidthKbps;
    }

    private final void $$robo$$android_net_NetworkCapabilities$setLinkDownstreamBandwidthKbps(int downKbps) {
        this.mLinkDownBandwidthKbps = downKbps;
    }

    private final int $$robo$$android_net_NetworkCapabilities$getLinkDownstreamBandwidthKbps() {
        return this.mLinkDownBandwidthKbps;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineLinkBandwidths(NetworkCapabilities nc) {
        this.mLinkUpBandwidthKbps = Math.max(this.mLinkUpBandwidthKbps, nc.mLinkUpBandwidthKbps);
        this.mLinkDownBandwidthKbps = Math.max(this.mLinkDownBandwidthKbps, nc.mLinkDownBandwidthKbps);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps <= nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps <= nc.mLinkDownBandwidthKbps;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps == nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps == nc.mLinkDownBandwidthKbps;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
        if (networkSpecifier != null && Long.bitCount(this.mTransportTypes) != 1) {
            throw new IllegalStateException("Must have a single transport specified to use setNetworkSpecifier");
        }
        this.mNetworkSpecifier = networkSpecifier;
        return this;
    }

    private final NetworkSpecifier $$robo$$android_net_NetworkCapabilities$getNetworkSpecifier() {
        return this.mNetworkSpecifier;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineSpecifiers(NetworkCapabilities nc) {
        if (this.mNetworkSpecifier != null && !this.mNetworkSpecifier.equals(nc.mNetworkSpecifier)) {
            throw new IllegalStateException("Can't combine two networkSpecifiers");
        }
        this.setNetworkSpecifier(nc.mNetworkSpecifier);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedBySpecifier(NetworkCapabilities nc) {
        return this.mNetworkSpecifier == null || this.mNetworkSpecifier.satisfiedBy(nc.mNetworkSpecifier) || nc.mNetworkSpecifier instanceof MatchAllNetworkSpecifier;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsSpecifier(NetworkCapabilities nc) {
        return Objects.equals(this.mNetworkSpecifier, nc.mNetworkSpecifier);
    }

    private final void $$robo$$android_net_NetworkCapabilities$setSignalStrength(int signalStrength) {
        this.mSignalStrength = signalStrength;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$hasSignalStrength() {
        return this.mSignalStrength > Integer.MIN_VALUE;
    }

    private final int $$robo$$android_net_NetworkCapabilities$getSignalStrength() {
        return this.mSignalStrength;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineSignalStrength(NetworkCapabilities nc) {
        this.mSignalStrength = Math.max(this.mSignalStrength, nc.mSignalStrength);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedBySignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength <= nc.mSignalStrength;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsSignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength == nc.mSignalStrength;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineCapabilities(NetworkCapabilities nc) {
        this.combineNetCapabilities(nc);
        this.combineTransportTypes(nc);
        this.combineLinkBandwidths(nc);
        this.combineSpecifiers(nc);
        this.combineSignalStrength(nc);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        return !(nc == null || !this.satisfiedByNetCapabilities(nc, onlyImmutable) || !this.satisfiedByTransportTypes(nc) || !onlyImmutable && !this.satisfiedByLinkBandwidths(nc) || !this.satisfiedBySpecifier(nc) || !onlyImmutable && !this.satisfiedBySignalStrength(nc));
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, false);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByImmutableNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, true);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalImmutableCapabilities(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        return this.equalsNetCapabilitiesImmutable(nc) && this.equalsTransportTypes(nc) && this.equalsSpecifier(nc);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalRequestableCapabilities(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        return this.equalsNetCapabilitiesRequestable(nc) && this.equalsTransportTypes(nc) && this.equalsSpecifier(nc);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkCapabilities)) {
            return false;
        }
        NetworkCapabilities that = (NetworkCapabilities)obj;
        return this.equalsNetCapabilities(that) && this.equalsTransportTypes(that) && this.equalsLinkBandwidths(that) && this.equalsSignalStrength(that) && this.equalsSpecifier(that);
    }

    private final int $$robo$$android_net_NetworkCapabilities$hashCode() {
        return (int)(this.mNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) + (int)(this.mNetworkCapabilities >> 32) * 3 + (int)(this.mTransportTypes & 0xFFFFFFFFFFFFFFFFL) * 5 + (int)(this.mTransportTypes >> 32) * 7 + this.mLinkUpBandwidthKbps * 11 + this.mLinkDownBandwidthKbps * 13 + Objects.hashCode(this.mNetworkSpecifier) * 17 + this.mSignalStrength * 19;
    }

    private final int $$robo$$android_net_NetworkCapabilities$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_NetworkCapabilities$writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mNetworkCapabilities);
        dest.writeLong(this.mTransportTypes);
        dest.writeInt(this.mLinkUpBandwidthKbps);
        dest.writeInt(this.mLinkDownBandwidthKbps);
        dest.writeParcelable((Parcelable)((Object)this.mNetworkSpecifier), flags);
        dest.writeInt(this.mSignalStrength);
    }

    private final String $$robo$$android_net_NetworkCapabilities$toString() {
        int[] types = this.getTransportTypes();
        String transports = types.length > 0 ? " Transports: " + NetworkCapabilities.transportNamesOf(types) : "";
        types = this.getCapabilities();
        String capabilities = types.length > 0 ? " Capabilities: " : "";
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 0: {
                    capabilities = capabilities + "MMS";
                    break;
                }
                case 1: {
                    capabilities = capabilities + "SUPL";
                    break;
                }
                case 2: {
                    capabilities = capabilities + "DUN";
                    break;
                }
                case 3: {
                    capabilities = capabilities + "FOTA";
                    break;
                }
                case 4: {
                    capabilities = capabilities + "IMS";
                    break;
                }
                case 5: {
                    capabilities = capabilities + "CBS";
                    break;
                }
                case 6: {
                    capabilities = capabilities + "WIFI_P2P";
                    break;
                }
                case 7: {
                    capabilities = capabilities + "IA";
                    break;
                }
                case 8: {
                    capabilities = capabilities + "RCS";
                    break;
                }
                case 9: {
                    capabilities = capabilities + "XCAP";
                    break;
                }
                case 10: {
                    capabilities = capabilities + "EIMS";
                    break;
                }
                case 11: {
                    capabilities = capabilities + "NOT_METERED";
                    break;
                }
                case 12: {
                    capabilities = capabilities + "INTERNET";
                    break;
                }
                case 13: {
                    capabilities = capabilities + "NOT_RESTRICTED";
                    break;
                }
                case 14: {
                    capabilities = capabilities + "TRUSTED";
                    break;
                }
                case 15: {
                    capabilities = capabilities + "NOT_VPN";
                    break;
                }
                case 16: {
                    capabilities = capabilities + "VALIDATED";
                    break;
                }
                case 17: {
                    capabilities = capabilities + "CAPTIVE_PORTAL";
                    break;
                }
                case 18: {
                    capabilities = capabilities + "FOREGROUND";
                }
            }
            if (++i >= types.length) continue;
            capabilities = capabilities + "&";
        }
        String upBand = this.mLinkUpBandwidthKbps > 0 ? " LinkUpBandwidth>=" + this.mLinkUpBandwidthKbps + "Kbps" : "";
        String dnBand = this.mLinkDownBandwidthKbps > 0 ? " LinkDnBandwidth>=" + this.mLinkDownBandwidthKbps + "Kbps" : "";
        String specifier = this.mNetworkSpecifier == null ? "" : " Specifier: <" + this.mNetworkSpecifier + ">";
        String signalStrength = this.hasSignalStrength() ? " SignalStrength: " + this.mSignalStrength : "";
        return "[" + transports + capabilities + upBand + dnBand + specifier + signalStrength + "]";
    }

    private static final String $$robo$$android_net_NetworkCapabilities$transportNamesOf(int[] types) {
        if (types == null || types.length == 0) {
            return "";
        }
        StringBuilder transports = new StringBuilder();
        for (int t : types) {
            transports.append("|").append(NetworkCapabilities.transportNameOf(t));
        }
        return transports.substring(1);
    }

    private static final String $$robo$$android_net_NetworkCapabilities$transportNameOf(int transport) {
        if (transport < 0 || TRANSPORT_NAMES.length <= transport) {
            return "UNKNOWN";
        }
        return TRANSPORT_NAMES[transport];
    }

    static void __staticInitializer__() {
        TRANSPORT_NAMES = new String[]{"CELLULAR", "WIFI", "BLUETOOTH", "ETHERNET", "VPN", "WIFI_AWARE"};
        CREATOR = new Parcelable.Creator<NetworkCapabilities>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkCapabilities_1$__constructor__() {
            }

            private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities_1$createFromParcel(Parcel in) {
                NetworkCapabilities netCap = new NetworkCapabilities();
                netCap.mNetworkCapabilities = in.readLong();
                netCap.mTransportTypes = in.readLong();
                netCap.mLinkUpBandwidthKbps = in.readInt();
                netCap.mLinkDownBandwidthKbps = in.readInt();
                netCap.mNetworkSpecifier = (NetworkSpecifier)in.readParcelable(null);
                netCap.mSignalStrength = in.readInt();
                return netCap;
            }

            private final NetworkCapabilities[] $$robo$$android_net_NetworkCapabilities_1$newArray(int size) {
                return new NetworkCapabilities[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkCapabilities_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkCapabilities_1$__constructor__(), 0, this);
            }

            @Override
            public NetworkCapabilities createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkCapabilities_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public NetworkCapabilities[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkCapabilities_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_NetworkCapabilities$__constructor__();
    }

    public NetworkCapabilities() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkCapabilities$__constructor__(), 0, this);
    }

    private void __constructor__(NetworkCapabilities networkCapabilities) {
        this.$$robo$$android_net_NetworkCapabilities$__constructor__(networkCapabilities);
    }

    public NetworkCapabilities(NetworkCapabilities networkCapabilities) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkCapabilities$__constructor__(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public void clearAll() {
        InvokeDynamicSupport.bootstrap("clearAll", $$robo$$android_net_NetworkCapabilities$clearAll(), 0, this);
    }

    public NetworkCapabilities addCapability(int n) {
        return InvokeDynamicSupport.bootstrap("addCapability", $$robo$$android_net_NetworkCapabilities$addCapability(int ), 0, this, n);
    }

    public NetworkCapabilities removeCapability(int n) {
        return InvokeDynamicSupport.bootstrap("removeCapability", $$robo$$android_net_NetworkCapabilities$removeCapability(int ), 0, this, n);
    }

    public int[] getCapabilities() {
        return InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_net_NetworkCapabilities$getCapabilities(), 0, this);
    }

    public boolean hasCapability(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCapability", $$robo$$android_net_NetworkCapabilities$hasCapability(int ), 0, this, n);
    }

    private void combineNetCapabilities(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineNetCapabilities", $$robo$$android_net_NetworkCapabilities$combineNetCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public String describeFirstNonRequestableCapability() {
        return InvokeDynamicSupport.bootstrap("describeFirstNonRequestableCapability", $$robo$$android_net_NetworkCapabilities$describeFirstNonRequestableCapability(), 0, this);
    }

    private boolean satisfiedByNetCapabilities(NetworkCapabilities networkCapabilities, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByNetCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByNetCapabilities(android.net.NetworkCapabilities boolean ), 0, this, networkCapabilities, bl);
    }

    public boolean equalsNetCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsNetCapabilities", $$robo$$android_net_NetworkCapabilities$equalsNetCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean equalsNetCapabilitiesImmutable(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsNetCapabilitiesImmutable", $$robo$$android_net_NetworkCapabilities$equalsNetCapabilitiesImmutable(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean equalsNetCapabilitiesRequestable(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsNetCapabilitiesRequestable", $$robo$$android_net_NetworkCapabilities$equalsNetCapabilitiesRequestable(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public void maybeMarkCapabilitiesRestricted() {
        InvokeDynamicSupport.bootstrap("maybeMarkCapabilitiesRestricted", $$robo$$android_net_NetworkCapabilities$maybeMarkCapabilitiesRestricted(), 0, this);
    }

    public NetworkCapabilities addTransportType(int n) {
        return InvokeDynamicSupport.bootstrap("addTransportType", $$robo$$android_net_NetworkCapabilities$addTransportType(int ), 0, this, n);
    }

    public NetworkCapabilities removeTransportType(int n) {
        return InvokeDynamicSupport.bootstrap("removeTransportType", $$robo$$android_net_NetworkCapabilities$removeTransportType(int ), 0, this, n);
    }

    public int[] getTransportTypes() {
        return InvokeDynamicSupport.bootstrap("getTransportTypes", $$robo$$android_net_NetworkCapabilities$getTransportTypes(), 0, this);
    }

    public boolean hasTransport(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasTransport", $$robo$$android_net_NetworkCapabilities$hasTransport(int ), 0, this, n);
    }

    private void combineTransportTypes(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineTransportTypes", $$robo$$android_net_NetworkCapabilities$combineTransportTypes(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean satisfiedByTransportTypes(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByTransportTypes", $$robo$$android_net_NetworkCapabilities$satisfiedByTransportTypes(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public boolean equalsTransportTypes(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsTransportTypes", $$robo$$android_net_NetworkCapabilities$equalsTransportTypes(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public void setLinkUpstreamBandwidthKbps(int n) {
        InvokeDynamicSupport.bootstrap("setLinkUpstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$setLinkUpstreamBandwidthKbps(int ), 0, this, n);
    }

    public int getLinkUpstreamBandwidthKbps() {
        return (int)InvokeDynamicSupport.bootstrap("getLinkUpstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$getLinkUpstreamBandwidthKbps(), 0, this);
    }

    public void setLinkDownstreamBandwidthKbps(int n) {
        InvokeDynamicSupport.bootstrap("setLinkDownstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$setLinkDownstreamBandwidthKbps(int ), 0, this, n);
    }

    public int getLinkDownstreamBandwidthKbps() {
        return (int)InvokeDynamicSupport.bootstrap("getLinkDownstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$getLinkDownstreamBandwidthKbps(), 0, this);
    }

    private void combineLinkBandwidths(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineLinkBandwidths", $$robo$$android_net_NetworkCapabilities$combineLinkBandwidths(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean satisfiedByLinkBandwidths(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByLinkBandwidths", $$robo$$android_net_NetworkCapabilities$satisfiedByLinkBandwidths(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean equalsLinkBandwidths(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsLinkBandwidths", $$robo$$android_net_NetworkCapabilities$equalsLinkBandwidths(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public NetworkCapabilities setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
        return InvokeDynamicSupport.bootstrap("setNetworkSpecifier", $$robo$$android_net_NetworkCapabilities$setNetworkSpecifier(android.net.NetworkSpecifier ), 0, this, networkSpecifier);
    }

    public NetworkSpecifier getNetworkSpecifier() {
        return InvokeDynamicSupport.bootstrap("getNetworkSpecifier", $$robo$$android_net_NetworkCapabilities$getNetworkSpecifier(), 0, this);
    }

    private void combineSpecifiers(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineSpecifiers", $$robo$$android_net_NetworkCapabilities$combineSpecifiers(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean satisfiedBySpecifier(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedBySpecifier", $$robo$$android_net_NetworkCapabilities$satisfiedBySpecifier(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean equalsSpecifier(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsSpecifier", $$robo$$android_net_NetworkCapabilities$equalsSpecifier(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public void setSignalStrength(int n) {
        InvokeDynamicSupport.bootstrap("setSignalStrength", $$robo$$android_net_NetworkCapabilities$setSignalStrength(int ), 0, this, n);
    }

    public boolean hasSignalStrength() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSignalStrength", $$robo$$android_net_NetworkCapabilities$hasSignalStrength(), 0, this);
    }

    public int getSignalStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$android_net_NetworkCapabilities$getSignalStrength(), 0, this);
    }

    private void combineSignalStrength(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineSignalStrength", $$robo$$android_net_NetworkCapabilities$combineSignalStrength(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean satisfiedBySignalStrength(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedBySignalStrength", $$robo$$android_net_NetworkCapabilities$satisfiedBySignalStrength(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean equalsSignalStrength(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsSignalStrength", $$robo$$android_net_NetworkCapabilities$equalsSignalStrength(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public void combineCapabilities(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineCapabilities", $$robo$$android_net_NetworkCapabilities$combineCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean satisfiedByNetworkCapabilities(NetworkCapabilities networkCapabilities, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByNetworkCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(android.net.NetworkCapabilities boolean ), 0, this, networkCapabilities, bl);
    }

    public boolean satisfiedByNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByNetworkCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public boolean satisfiedByImmutableNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByImmutableNetworkCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByImmutableNetworkCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public boolean equalImmutableCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalImmutableCapabilities", $$robo$$android_net_NetworkCapabilities$equalImmutableCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public boolean equalRequestableCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalRequestableCapabilities", $$robo$$android_net_NetworkCapabilities$equalRequestableCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkCapabilities$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_NetworkCapabilities$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkCapabilities$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkCapabilities$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkCapabilities$toString(), 0, this);
    }

    public static String transportNamesOf(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("transportNamesOf", $$robo$$android_net_NetworkCapabilities$transportNamesOf(int[] ), 0, (int[])nArray);
    }

    public static String transportNameOf(int n) {
        return InvokeDynamicSupport.bootstrapStatic("transportNameOf", $$robo$$android_net_NetworkCapabilities$transportNameOf(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(NetworkCapabilities.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkCapabilities)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

