/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class NetworkIdentity
implements Comparable<NetworkIdentity> {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkIdentity";
    @Deprecated
    public static boolean COMBINE_SUBTYPE_ENABLED = true;
    public static int SUBTYPE_COMBINED = -1;
    int mType;
    int mSubType;
    String mSubscriberId;
    String mNetworkId;
    boolean mRoaming;
    boolean mMetered;

    private void $$robo$$android_net_NetworkIdentity$__constructor__(int type, int subType, String subscriberId, String networkId, boolean roaming, boolean metered) {
        this.mType = type;
        this.mSubType = -1;
        this.mSubscriberId = subscriberId;
        this.mNetworkId = networkId;
        this.mRoaming = roaming;
        this.mMetered = metered;
    }

    private final int $$robo$$android_net_NetworkIdentity$hashCode() {
        return Objects.hash(this.mType, this.mSubType, this.mSubscriberId, this.mNetworkId, this.mRoaming, this.mMetered);
    }

    private final boolean $$robo$$android_net_NetworkIdentity$equals(Object obj) {
        if (obj instanceof NetworkIdentity) {
            NetworkIdentity ident = (NetworkIdentity)obj;
            return this.mType == ident.mType && this.mSubType == ident.mSubType && this.mRoaming == ident.mRoaming && Objects.equals(this.mSubscriberId, ident.mSubscriberId) && Objects.equals(this.mNetworkId, ident.mNetworkId) && this.mMetered == ident.mMetered;
        }
        return false;
    }

    private final String $$robo$$android_net_NetworkIdentity$toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append("type=").append(ConnectivityManager.getNetworkTypeName(this.mType));
        builder.append(", subType=");
        builder.append("COMBINED");
        if (this.mSubscriberId != null) {
            builder.append(", subscriberId=").append(NetworkIdentity.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mNetworkId != null) {
            builder.append(", networkId=").append(this.mNetworkId);
        }
        if (this.mRoaming) {
            builder.append(", ROAMING");
        }
        builder.append(", metered=").append(this.mMetered);
        return builder.append("}").toString();
    }

    private final void $$robo$$android_net_NetworkIdentity$writeToProto(ProtoOutputStream proto, long tag) {
        long start = proto.start(tag);
        proto.write(0x10300000001L, this.mType);
        if (this.mSubscriberId != null) {
            proto.write(1159641169922L, NetworkIdentity.scrubSubscriberId(this.mSubscriberId));
        }
        proto.write(1159641169923L, this.mNetworkId);
        proto.write(1155346202628L, this.mRoaming);
        proto.write(1155346202629L, this.mMetered);
        proto.end(start);
    }

    private final int $$robo$$android_net_NetworkIdentity$getType() {
        return this.mType;
    }

    private final int $$robo$$android_net_NetworkIdentity$getSubType() {
        return this.mSubType;
    }

    private final String $$robo$$android_net_NetworkIdentity$getSubscriberId() {
        return this.mSubscriberId;
    }

    private final String $$robo$$android_net_NetworkIdentity$getNetworkId() {
        return this.mNetworkId;
    }

    private final boolean $$robo$$android_net_NetworkIdentity$getRoaming() {
        return this.mRoaming;
    }

    private final boolean $$robo$$android_net_NetworkIdentity$getMetered() {
        return this.mMetered;
    }

    private static final String $$robo$$android_net_NetworkIdentity$scrubSubscriberId(String subscriberId) {
        if ("eng".equals(Build.TYPE)) {
            return subscriberId;
        }
        if (subscriberId != null) {
            return subscriberId.substring(0, Math.min(6, subscriberId.length())) + "...";
        }
        return "null";
    }

    private static final String[] $$robo$$android_net_NetworkIdentity$scrubSubscriberId(String[] subscriberId) {
        if (subscriberId == null) {
            return null;
        }
        String[] res = new String[subscriberId.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = NetworkIdentity.scrubSubscriberId(subscriberId[i]);
        }
        return res;
    }

    private static final NetworkIdentity $$robo$$android_net_NetworkIdentity$buildNetworkIdentity(Context context, NetworkState state) {
        boolean metered;
        int type = state.networkInfo.getType();
        int subType = state.networkInfo.getSubtype();
        String subscriberId = null;
        String networkId = null;
        boolean roaming = false;
        boolean bl = metered = !state.networkCapabilities.hasCapability(11);
        if (ConnectivityManager.isNetworkTypeMobile(type)) {
            if (state.subscriberId == null && state.networkInfo.getState() != NetworkInfo.State.DISCONNECTED && state.networkInfo.getState() != NetworkInfo.State.UNKNOWN) {
                Slog.w("NetworkIdentity", "Active mobile network without subscriber! ni = " + state.networkInfo);
            }
            subscriberId = state.subscriberId;
            roaming = state.networkInfo.isRoaming();
        } else if (type == 1) {
            WifiManager wifi;
            WifiInfo info;
            networkId = state.networkId != null ? state.networkId : ((info = (wifi = (WifiManager)context.getSystemService("wifi")).getConnectionInfo()) != null ? info.getSSID() : null);
        }
        return new NetworkIdentity(type, subType, subscriberId, networkId, roaming, metered);
    }

    private final int $$robo$$android_net_NetworkIdentity$compareTo(NetworkIdentity another) {
        int res = Integer.compare(this.mType, another.mType);
        if (res == 0) {
            res = Integer.compare(this.mSubType, another.mSubType);
        }
        if (res == 0 && this.mSubscriberId != null && another.mSubscriberId != null) {
            res = this.mSubscriberId.compareTo(another.mSubscriberId);
        }
        if (res == 0 && this.mNetworkId != null && another.mNetworkId != null) {
            res = this.mNetworkId.compareTo(another.mNetworkId);
        }
        if (res == 0) {
            res = Boolean.compare(this.mRoaming, another.mRoaming);
        }
        if (res == 0) {
            res = Boolean.compare(this.mMetered, another.mMetered);
        }
        return res;
    }

    private void __constructor__(int n, int n2, String string2, String string3, boolean bl, boolean bl2) {
        this.$$robo$$android_net_NetworkIdentity$__constructor__(n, n2, string2, string3, bl, bl2);
    }

    public NetworkIdentity(int n, int n2, String string2, String string3, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkIdentity$__constructor__(int int java.lang.String java.lang.String boolean boolean ), 0, this, n, n2, string2, string3, bl, bl2);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_NetworkIdentity$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkIdentity$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkIdentity$toString(), 0, this);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_net_NetworkIdentity$writeToProto(android.util.proto.ProtoOutputStream long ), 0, this, protoOutputStream, l);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_net_NetworkIdentity$getType(), 0, this);
    }

    public int getSubType() {
        return (int)InvokeDynamicSupport.bootstrap("getSubType", $$robo$$android_net_NetworkIdentity$getSubType(), 0, this);
    }

    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$android_net_NetworkIdentity$getSubscriberId(), 0, this);
    }

    public String getNetworkId() {
        return InvokeDynamicSupport.bootstrap("getNetworkId", $$robo$$android_net_NetworkIdentity$getNetworkId(), 0, this);
    }

    public boolean getRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("getRoaming", $$robo$$android_net_NetworkIdentity$getRoaming(), 0, this);
    }

    public boolean getMetered() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMetered", $$robo$$android_net_NetworkIdentity$getMetered(), 0, this);
    }

    public static String scrubSubscriberId(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("scrubSubscriberId", $$robo$$android_net_NetworkIdentity$scrubSubscriberId(java.lang.String ), 0, (String)string2);
    }

    public static String[] scrubSubscriberId(String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("scrubSubscriberId", $$robo$$android_net_NetworkIdentity$scrubSubscriberId(java.lang.String[] ), 0, (String[])stringArray);
    }

    public static NetworkIdentity buildNetworkIdentity(Context context, NetworkState networkState) {
        return InvokeDynamicSupport.bootstrapStatic("buildNetworkIdentity", $$robo$$android_net_NetworkIdentity$buildNetworkIdentity(android.content.Context android.net.NetworkState ), 0, (Context)context, (NetworkState)networkState);
    }

    @Override
    public int compareTo(NetworkIdentity networkIdentity) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_net_NetworkIdentity$compareTo(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    public /* synthetic */ NetworkIdentity() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkIdentity)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

