/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.NetworkPolicy;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.DebugUtils;
import java.util.Calendar;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkPolicyManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int POLICY_NONE = 0;
    public static int POLICY_REJECT_METERED_BACKGROUND = 1;
    public static int POLICY_ALLOW_METERED_BACKGROUND = 4;
    public static int RULE_NONE = 0;
    public static int RULE_ALLOW_METERED = 1;
    public static int RULE_TEMPORARY_ALLOW_METERED = 2;
    public static int RULE_REJECT_METERED = 4;
    public static int RULE_ALLOW_ALL = 32;
    public static int RULE_REJECT_ALL = 64;
    public static int MASK_METERED_NETWORKS = 15;
    public static int MASK_ALL_NETWORKS = 240;
    public static int FIREWALL_RULE_DEFAULT = 0;
    public static int FIREWALL_RULE_ALLOW = 1;
    public static int FIREWALL_RULE_DENY = 2;
    public static int FIREWALL_TYPE_WHITELIST = 0;
    public static int FIREWALL_TYPE_BLACKLIST = 1;
    public static int FIREWALL_CHAIN_NONE = 0;
    public static int FIREWALL_CHAIN_DOZABLE = 1;
    public static int FIREWALL_CHAIN_STANDBY = 2;
    public static int FIREWALL_CHAIN_POWERSAVE = 3;
    public static String FIREWALL_CHAIN_NAME_NONE = "none";
    public static String FIREWALL_CHAIN_NAME_DOZABLE = "dozable";
    public static String FIREWALL_CHAIN_NAME_STANDBY = "standby";
    public static String FIREWALL_CHAIN_NAME_POWERSAVE = "powersave";
    private static boolean ALLOW_PLATFORM_APP_POLICY = true;
    public static String EXTRA_NETWORK_TEMPLATE = "android.net.NETWORK_TEMPLATE";
    private Context mContext;
    private INetworkPolicyManager mService;

    private void $$robo$$android_net_NetworkPolicyManager$__constructor__(Context context, INetworkPolicyManager service) {
        if (service == null) {
            throw new IllegalArgumentException("missing INetworkPolicyManager");
        }
        this.mContext = context;
        this.mService = service;
    }

    private static final NetworkPolicyManager $$robo$$android_net_NetworkPolicyManager$from(Context context) {
        return (NetworkPolicyManager)context.getSystemService("netpolicy");
    }

    private final void $$robo$$android_net_NetworkPolicyManager$setUidPolicy(int uid, int policy) {
        try {
            this.mService.setUidPolicy(uid, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$addUidPolicy(int uid, int policy) {
        try {
            this.mService.addUidPolicy(uid, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$removeUidPolicy(int uid, int policy) {
        try {
            this.mService.removeUidPolicy(uid, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_NetworkPolicyManager$getUidPolicy(int uid) {
        try {
            return this.mService.getUidPolicy(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int[] $$robo$$android_net_NetworkPolicyManager$getUidsWithPolicy(int policy) {
        try {
            return this.mService.getUidsWithPolicy(policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$registerListener(INetworkPolicyListener listener) {
        try {
            this.mService.registerListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$unregisterListener(INetworkPolicyListener listener) {
        try {
            this.mService.unregisterListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$setNetworkPolicies(NetworkPolicy[] policies) {
        try {
            this.mService.setNetworkPolicies(policies);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final NetworkPolicy[] $$robo$$android_net_NetworkPolicyManager$getNetworkPolicies() {
        try {
            return this.mService.getNetworkPolicies(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$setRestrictBackground(boolean restrictBackground) {
        try {
            this.mService.setRestrictBackground(restrictBackground);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_NetworkPolicyManager$getRestrictBackground() {
        try {
            return this.mService.getRestrictBackground();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$factoryReset(String subscriber) {
        try {
            this.mService.factoryReset(subscriber);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final long $$robo$$android_net_NetworkPolicyManager$computeLastCycleBoundary(long currentTime, NetworkPolicy policy) {
        if (policy.cycleDay == -1) {
            throw new IllegalArgumentException("Unable to compute boundary without cycleDay");
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(policy.cycleTimezone));
        cal.setTimeInMillis(currentTime);
        NetworkPolicyManager.snapToCycleDay(cal, policy.cycleDay);
        if (cal.getTimeInMillis() >= currentTime) {
            cal.set(5, 1);
            cal.add(2, -1);
            NetworkPolicyManager.snapToCycleDay(cal, policy.cycleDay);
        }
        return cal.getTimeInMillis();
    }

    private static final long $$robo$$android_net_NetworkPolicyManager$computeNextCycleBoundary(long currentTime, NetworkPolicy policy) {
        if (policy.cycleDay == -1) {
            throw new IllegalArgumentException("Unable to compute boundary without cycleDay");
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(policy.cycleTimezone));
        cal.setTimeInMillis(currentTime);
        NetworkPolicyManager.snapToCycleDay(cal, policy.cycleDay);
        if (cal.getTimeInMillis() <= currentTime) {
            cal.set(5, 1);
            cal.add(2, 1);
            NetworkPolicyManager.snapToCycleDay(cal, policy.cycleDay);
        }
        return cal.getTimeInMillis();
    }

    private static final void $$robo$$android_net_NetworkPolicyManager$snapToCycleDay(Calendar cal, int cycleDay) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        if (cycleDay > cal.getActualMaximum(5)) {
            cal.add(2, 1);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.add(13, -1);
        } else {
            cal.set(5, cycleDay);
        }
    }

    @Deprecated
    private static final boolean $$robo$$android_net_NetworkPolicyManager$isUidValidForPolicy(Context context, int uid) {
        return UserHandle.isApp(uid);
    }

    private static final String $$robo$$android_net_NetworkPolicyManager$uidRulesToString(int uidRules) {
        StringBuilder string2 = new StringBuilder().append(uidRules).append(" (");
        if (uidRules == 0) {
            string2.append("NONE");
        } else {
            string2.append(DebugUtils.flagsToString(NetworkPolicyManager.class, "RULE_", uidRules));
        }
        string2.append(")");
        return string2.toString();
    }

    private static final String $$robo$$android_net_NetworkPolicyManager$uidPoliciesToString(int uidPolicies) {
        StringBuilder string2 = new StringBuilder().append(uidPolicies).append(" (");
        if (uidPolicies == 0) {
            string2.append("NONE");
        } else {
            string2.append(DebugUtils.flagsToString(NetworkPolicyManager.class, "POLICY_", uidPolicies));
        }
        string2.append(")");
        return string2.toString();
    }

    private static final boolean $$robo$$android_net_NetworkPolicyManager$isProcStateAllowedWhileIdleOrPowerSaveMode(int procState) {
        return procState <= 4;
    }

    private static final boolean $$robo$$android_net_NetworkPolicyManager$isProcStateAllowedWhileOnRestrictBackground(int procState) {
        return procState <= 4;
    }

    private void __constructor__(Context context, INetworkPolicyManager iNetworkPolicyManager) {
        this.$$robo$$android_net_NetworkPolicyManager$__constructor__(context, iNetworkPolicyManager);
    }

    public NetworkPolicyManager(Context context, INetworkPolicyManager iNetworkPolicyManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicyManager$__constructor__(android.content.Context android.net.INetworkPolicyManager ), 0, this, context, iNetworkPolicyManager);
    }

    public static NetworkPolicyManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_net_NetworkPolicyManager$from(android.content.Context ), 0, (Context)context);
    }

    public void setUidPolicy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setUidPolicy", $$robo$$android_net_NetworkPolicyManager$setUidPolicy(int int ), 0, this, n, n2);
    }

    public void addUidPolicy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("addUidPolicy", $$robo$$android_net_NetworkPolicyManager$addUidPolicy(int int ), 0, this, n, n2);
    }

    public void removeUidPolicy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidPolicy", $$robo$$android_net_NetworkPolicyManager$removeUidPolicy(int int ), 0, this, n, n2);
    }

    public int getUidPolicy(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getUidPolicy", $$robo$$android_net_NetworkPolicyManager$getUidPolicy(int ), 0, this, n);
    }

    public int[] getUidsWithPolicy(int n) {
        return InvokeDynamicSupport.bootstrap("getUidsWithPolicy", $$robo$$android_net_NetworkPolicyManager$getUidsWithPolicy(int ), 0, this, n);
    }

    public void registerListener(INetworkPolicyListener iNetworkPolicyListener) {
        InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_net_NetworkPolicyManager$registerListener(android.net.INetworkPolicyListener ), 0, this, iNetworkPolicyListener);
    }

    public void unregisterListener(INetworkPolicyListener iNetworkPolicyListener) {
        InvokeDynamicSupport.bootstrap("unregisterListener", $$robo$$android_net_NetworkPolicyManager$unregisterListener(android.net.INetworkPolicyListener ), 0, this, iNetworkPolicyListener);
    }

    public void setNetworkPolicies(NetworkPolicy[] networkPolicyArray) {
        InvokeDynamicSupport.bootstrap("setNetworkPolicies", $$robo$$android_net_NetworkPolicyManager$setNetworkPolicies(android.net.NetworkPolicy[] ), 0, this, networkPolicyArray);
    }

    public NetworkPolicy[] getNetworkPolicies() {
        return InvokeDynamicSupport.bootstrap("getNetworkPolicies", $$robo$$android_net_NetworkPolicyManager$getNetworkPolicies(), 0, this);
    }

    public void setRestrictBackground(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRestrictBackground", $$robo$$android_net_NetworkPolicyManager$setRestrictBackground(boolean ), 0, this, bl);
    }

    public boolean getRestrictBackground() {
        return (boolean)InvokeDynamicSupport.bootstrap("getRestrictBackground", $$robo$$android_net_NetworkPolicyManager$getRestrictBackground(), 0, this);
    }

    public void factoryReset(String string2) {
        InvokeDynamicSupport.bootstrap("factoryReset", $$robo$$android_net_NetworkPolicyManager$factoryReset(java.lang.String ), 0, this, string2);
    }

    public static long computeLastCycleBoundary(long l, NetworkPolicy networkPolicy) {
        return (long)InvokeDynamicSupport.bootstrapStatic("computeLastCycleBoundary", $$robo$$android_net_NetworkPolicyManager$computeLastCycleBoundary(long android.net.NetworkPolicy ), 0, (long)l, (NetworkPolicy)networkPolicy);
    }

    public static long computeNextCycleBoundary(long l, NetworkPolicy networkPolicy) {
        return (long)InvokeDynamicSupport.bootstrapStatic("computeNextCycleBoundary", $$robo$$android_net_NetworkPolicyManager$computeNextCycleBoundary(long android.net.NetworkPolicy ), 0, (long)l, (NetworkPolicy)networkPolicy);
    }

    public static void snapToCycleDay(Calendar calendar, int n) {
        InvokeDynamicSupport.bootstrapStatic("snapToCycleDay", $$robo$$android_net_NetworkPolicyManager$snapToCycleDay(java.util.Calendar int ), 0, (Calendar)calendar, (int)n);
    }

    @Deprecated
    public static boolean isUidValidForPolicy(Context context, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUidValidForPolicy", $$robo$$android_net_NetworkPolicyManager$isUidValidForPolicy(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static String uidRulesToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("uidRulesToString", $$robo$$android_net_NetworkPolicyManager$uidRulesToString(int ), 0, (int)n);
    }

    public static String uidPoliciesToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("uidPoliciesToString", $$robo$$android_net_NetworkPolicyManager$uidPoliciesToString(int ), 0, (int)n);
    }

    public static boolean isProcStateAllowedWhileIdleOrPowerSaveMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isProcStateAllowedWhileIdleOrPowerSaveMode", $$robo$$android_net_NetworkPolicyManager$isProcStateAllowedWhileIdleOrPowerSaveMode(int ), 0, (int)n);
    }

    public static boolean isProcStateAllowedWhileOnRestrictBackground(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isProcStateAllowedWhileOnRestrictBackground", $$robo$$android_net_NetworkPolicyManager$isProcStateAllowedWhileOnRestrictBackground(int ), 0, (int)n);
    }

    public /* synthetic */ NetworkPolicyManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkPolicyManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

