/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.ServiceManager;
import android.util.Log;
import com.android.net.IProxyService;
import com.google.android.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PacProxySelector
extends ProxySelector
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PacProxySelector";
    public static String PROXY_SERVICE = "com.android.net.IProxyService";
    private static String SOCKS = "SOCKS ";
    private static String PROXY = "PROXY ";
    private IProxyService mProxyService;
    private List<Proxy> mDefaultList;

    private void $$robo$$android_net_PacProxySelector$__constructor__() {
        this.mProxyService = IProxyService.Stub.asInterface(ServiceManager.getService("com.android.net.IProxyService"));
        if (this.mProxyService == null) {
            Log.e("PacProxySelector", "PacManager: no proxy service");
        }
        this.mDefaultList = Lists.newArrayList(Proxy.NO_PROXY);
    }

    private final List<Proxy> $$robo$$android_net_PacProxySelector$select(URI uri) {
        String urlString;
        if (this.mProxyService == null) {
            this.mProxyService = IProxyService.Stub.asInterface(ServiceManager.getService("com.android.net.IProxyService"));
        }
        if (this.mProxyService == null) {
            Log.e("PacProxySelector", "select: no proxy service return NO_PROXY");
            return Lists.newArrayList(Proxy.NO_PROXY);
        }
        String response = null;
        try {
            if (!"http".equalsIgnoreCase(uri.getScheme())) {
                uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), "/", null, null);
            }
            urlString = uri.toURL().toString();
        }
        catch (URISyntaxException e) {
            urlString = uri.getHost();
        }
        catch (MalformedURLException e) {
            urlString = uri.getHost();
        }
        try {
            response = this.mProxyService.resolvePacFile(uri.getHost(), urlString);
        }
        catch (Exception e) {
            Log.e("PacProxySelector", "Error resolving PAC File", e);
        }
        if (response == null) {
            return this.mDefaultList;
        }
        return PacProxySelector.parseResponse(response);
    }

    private static final List<Proxy> $$robo$$android_net_PacProxySelector$parseResponse(String response) {
        String[] split = response.split(";");
        ArrayList<Proxy> ret = Lists.newArrayList();
        for (String s : split) {
            Proxy proxy;
            String trimmed = s.trim();
            if (trimmed.equals("DIRECT")) {
                ret.add(Proxy.NO_PROXY);
                continue;
            }
            if (trimmed.startsWith("PROXY ")) {
                proxy = PacProxySelector.proxyFromHostPort(Proxy.Type.HTTP, trimmed.substring("PROXY ".length()));
                if (proxy == null) continue;
                ret.add(proxy);
                continue;
            }
            if (!trimmed.startsWith("SOCKS ") || (proxy = PacProxySelector.proxyFromHostPort(Proxy.Type.SOCKS, trimmed.substring("SOCKS ".length()))) == null) continue;
            ret.add(proxy);
        }
        if (ret.size() == 0) {
            ret.add(Proxy.NO_PROXY);
        }
        return ret;
    }

    private static final Proxy $$robo$$android_net_PacProxySelector$proxyFromHostPort(Proxy.Type type, String hostPortString) {
        try {
            String[] hostPort = hostPortString.split(":");
            String host = hostPort[0];
            int port = Integer.parseInt(hostPort[1]);
            return new Proxy(type, InetSocketAddress.createUnresolved(host, port));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            Log.d("PacProxySelector", "Unable to parse proxy " + hostPortString + " " + e);
            return null;
        }
    }

    private final void $$robo$$android_net_PacProxySelector$connectFailed(URI uri, SocketAddress address, IOException failure) {
    }

    private void __constructor__() {
        this.$$robo$$android_net_PacProxySelector$__constructor__();
    }

    public PacProxySelector() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_PacProxySelector$__constructor__(), 0, this);
    }

    @Override
    public List<Proxy> select(URI uRI) {
        return InvokeDynamicSupport.bootstrap("select", $$robo$$android_net_PacProxySelector$select(java.net.URI ), 0, this, uRI);
    }

    private static List<Proxy> parseResponse(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseResponse", $$robo$$android_net_PacProxySelector$parseResponse(java.lang.String ), 0, (String)string2);
    }

    private static Proxy proxyFromHostPort(Proxy.Type type, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("proxyFromHostPort", $$robo$$android_net_PacProxySelector$proxyFromHostPort(java.net.Proxy$Type java.lang.String ), 0, (Proxy.Type)type, (String)string2);
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        InvokeDynamicSupport.bootstrap("connectFailed", $$robo$$android_net_PacProxySelector$connectFailed(java.net.URI java.net.SocketAddress java.io.IOException ), 0, this, uRI, socketAddress, iOException);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PacProxySelector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

