/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkUtils;
import android.net.PacProxySelector;
import android.net.ProxyInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Proxy
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Proxy";
    private static ProxySelector sDefaultProxySelector;
    public static String PROXY_CHANGE_ACTION = "android.intent.action.PROXY_CHANGE";
    @Deprecated
    public static String EXTRA_PROXY_INFO = "android.intent.extra.PROXY_INFO";
    public static int PROXY_VALID = 0;
    public static int PROXY_HOSTNAME_EMPTY = 1;
    public static int PROXY_HOSTNAME_INVALID = 2;
    public static int PROXY_PORT_EMPTY = 3;
    public static int PROXY_PORT_INVALID = 4;
    public static int PROXY_EXCLLIST_INVALID = 5;
    private static ConnectivityManager sConnectivityManager;
    private static String NAME_IP_REGEX = "[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*(\\.[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*)*";
    private static String HOSTNAME_REGEXP = "^$|^[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*(\\.[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*)*$";
    private static Pattern HOSTNAME_PATTERN;
    private static String EXCL_REGEX = "[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*(\\.[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*)*";
    private static String EXCLLIST_REGEXP = "^$|^[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*(\\.[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*)*(,[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*(\\.[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*)*)*$";
    private static Pattern EXCLLIST_PATTERN;

    private void $$robo$$android_net_Proxy$__constructor__() {
    }

    private static final java.net.Proxy $$robo$$android_net_Proxy$getProxy(Context ctx, String url) {
        String host = "";
        if (url != null && !Proxy.isLocalHost(host)) {
            URI uri = URI.create(url);
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<java.net.Proxy> proxyList = proxySelector.select(uri);
            if (proxyList.size() > 0) {
                return proxyList.get(0);
            }
        }
        return java.net.Proxy.NO_PROXY;
    }

    @Deprecated
    private static final String $$robo$$android_net_Proxy$getHost(Context ctx) {
        java.net.Proxy proxy = Proxy.getProxy(ctx, null);
        if (proxy == java.net.Proxy.NO_PROXY) {
            return null;
        }
        try {
            return ((InetSocketAddress)proxy.address()).getHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    private static final int $$robo$$android_net_Proxy$getPort(Context ctx) {
        java.net.Proxy proxy = Proxy.getProxy(ctx, null);
        if (proxy == java.net.Proxy.NO_PROXY) {
            return -1;
        }
        try {
            return ((InetSocketAddress)proxy.address()).getPort();
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Deprecated
    private static final String $$robo$$android_net_Proxy$getDefaultHost() {
        String host = System.getProperty("http.proxyHost");
        if (TextUtils.isEmpty(host)) {
            return null;
        }
        return host;
    }

    @Deprecated
    private static final int $$robo$$android_net_Proxy$getDefaultPort() {
        if (Proxy.getDefaultHost() == null) {
            return -1;
        }
        try {
            return Integer.parseInt(System.getProperty("http.proxyPort"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static final boolean $$robo$$android_net_Proxy$isLocalHost(String host) {
        if (host == null) {
            return false;
        }
        try {
            if (host != null) {
                if (host.equalsIgnoreCase("localhost")) {
                    return true;
                }
                if (NetworkUtils.numericToInetAddress(host).isLoopbackAddress()) {
                    return true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private static final int $$robo$$android_net_Proxy$validate(String hostname, String port, String exclList) {
        Matcher match = HOSTNAME_PATTERN.matcher(hostname);
        Matcher listMatch = EXCLLIST_PATTERN.matcher(exclList);
        if (!match.matches()) {
            return 2;
        }
        if (!listMatch.matches()) {
            return 5;
        }
        if (hostname.length() > 0 && port.length() == 0) {
            return 3;
        }
        if (port.length() > 0) {
            if (hostname.length() == 0) {
                return 1;
            }
            int portVal = -1;
            try {
                portVal = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                return 4;
            }
            if (portVal <= 0 || portVal > 65535) {
                return 4;
            }
        }
        return 0;
    }

    private static final void $$robo$$android_net_Proxy$setHttpProxySystemProperty(ProxyInfo p) {
        String host = null;
        String port = null;
        String exclList = null;
        Uri pacFileUrl = Uri.EMPTY;
        if (p != null) {
            host = p.getHost();
            port = Integer.toString(p.getPort());
            exclList = p.getExclusionListAsString();
            pacFileUrl = p.getPacFileUrl();
        }
        Proxy.setHttpProxySystemProperty(host, port, exclList, pacFileUrl);
    }

    private static final void $$robo$$android_net_Proxy$setHttpProxySystemProperty(String host, String port, String exclList, Uri pacFileUrl) {
        if (exclList != null) {
            exclList = exclList.replace(",", "|");
        }
        if (host != null) {
            System.setProperty("http.proxyHost", host);
            System.setProperty("https.proxyHost", host);
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("https.proxyHost");
        }
        if (port != null) {
            System.setProperty("http.proxyPort", port);
            System.setProperty("https.proxyPort", port);
        } else {
            System.clearProperty("http.proxyPort");
            System.clearProperty("https.proxyPort");
        }
        if (exclList != null) {
            System.setProperty("http.nonProxyHosts", exclList);
            System.setProperty("https.nonProxyHosts", exclList);
        } else {
            System.clearProperty("http.nonProxyHosts");
            System.clearProperty("https.nonProxyHosts");
        }
        if (!Uri.EMPTY.equals(pacFileUrl)) {
            ProxySelector.setDefault(new PacProxySelector());
        } else {
            ProxySelector.setDefault(sDefaultProxySelector);
        }
    }

    static void __staticInitializer__() {
        sConnectivityManager = null;
        HOSTNAME_PATTERN = Pattern.compile("^$|^[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*(\\.[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*)*$");
        EXCLLIST_PATTERN = Pattern.compile("^$|^[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*(\\.[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*)*(,[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*(\\.[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*)*)*$");
        sDefaultProxySelector = ProxySelector.getDefault();
    }

    private void __constructor__() {
        this.$$robo$$android_net_Proxy$__constructor__();
    }

    public Proxy() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Proxy$__constructor__(), 0, this);
    }

    public static java.net.Proxy getProxy(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getProxy", $$robo$$android_net_Proxy$getProxy(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    @Deprecated
    public static String getHost(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getHost", $$robo$$android_net_Proxy$getHost(android.content.Context ), 0, (Context)context);
    }

    @Deprecated
    public static int getPort(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPort", $$robo$$android_net_Proxy$getPort(android.content.Context ), 0, (Context)context);
    }

    @Deprecated
    public static String getDefaultHost() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultHost", $$robo$$android_net_Proxy$getDefaultHost(), 0);
    }

    @Deprecated
    public static int getDefaultPort() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultPort", $$robo$$android_net_Proxy$getDefaultPort(), 0);
    }

    private static boolean isLocalHost(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocalHost", $$robo$$android_net_Proxy$isLocalHost(java.lang.String ), 0, (String)string2);
    }

    public static int validate(String string2, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("validate", $$robo$$android_net_Proxy$validate(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    public static void setHttpProxySystemProperty(ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrapStatic("setHttpProxySystemProperty", $$robo$$android_net_Proxy$setHttpProxySystemProperty(android.net.ProxyInfo ), 0, (ProxyInfo)proxyInfo);
    }

    public static void setHttpProxySystemProperty(String string2, String string3, String string4, Uri uri) {
        InvokeDynamicSupport.bootstrapStatic("setHttpProxySystemProperty", $$robo$$android_net_Proxy$setHttpProxySystemProperty(java.lang.String java.lang.String java.lang.String android.net.Uri ), 0, (String)string2, (String)string3, (String)string4, (Uri)uri);
    }

    static {
        RobolectricInternals.classInitializing(Proxy.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

