/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.NetworkUtils;
import android.net.util.BlockingSocketReader;
import android.net.util.ConnectivityPacketSummary;
import android.os.Handler;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.util.LocalLog;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import libcore.util.HexEncoding;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConnectivityPacketTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    private static String MARK_START = "--- START ---";
    private static String MARK_STOP = "--- STOP ---";
    private String mTag;
    private Handler mHandler;
    private LocalLog mLog;
    private BlockingSocketReader mPacketListener;

    private void $$robo$$android_net_ip_ConnectivityPacketTracker$__constructor__(NetworkInterface netif, LocalLog log) {
        int mtu;
        byte[] hwaddr;
        int ifindex;
        String ifname;
        try {
            ifname = netif.getName();
            ifindex = netif.getIndex();
            hwaddr = netif.getHardwareAddress();
            mtu = netif.getMTU();
        }
        catch (NullPointerException | SocketException e) {
            throw new IllegalArgumentException("bad network interface", e);
        }
        this.mTag = TAG + "." + ifname;
        this.mHandler = new Handler();
        this.mLog = log;
        this.mPacketListener = new PacketListener(this, ifindex, hwaddr, mtu);
    }

    private final void $$robo$$android_net_ip_ConnectivityPacketTracker$start() {
        this.mLog.log("--- START ---");
        this.mPacketListener.start();
    }

    private final void $$robo$$android_net_ip_ConnectivityPacketTracker$stop() {
        this.mPacketListener.stop();
        this.mLog.log("--- STOP ---");
    }

    static void __staticInitializer__() {
        TAG = ConnectivityPacketTracker.class.getSimpleName();
    }

    private void __constructor__(NetworkInterface networkInterface, LocalLog localLog) {
        this.$$robo$$android_net_ip_ConnectivityPacketTracker$__constructor__(networkInterface, localLog);
    }

    public ConnectivityPacketTracker(NetworkInterface networkInterface, LocalLog localLog) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_ConnectivityPacketTracker$__constructor__(java.net.NetworkInterface android.util.LocalLog ), 0, this, networkInterface, localLog);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_net_ip_ConnectivityPacketTracker$start(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_net_ip_ConnectivityPacketTracker$stop(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ConnectivityPacketTracker.class);
    }

    public /* synthetic */ ConnectivityPacketTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectivityPacketTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class PacketListener
    extends BlockingSocketReader
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mIfIndex;
        private byte[] mHwAddr;
        /* synthetic */ ConnectivityPacketTracker this$0;

        private void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$__constructor__(ConnectivityPacketTracker connectivityPacketTracker, int ifindex, byte[] hwaddr, int mtu) {
            this.mIfIndex = ifindex;
            this.mHwAddr = hwaddr;
        }

        private final FileDescriptor $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$createSocket() {
            FileDescriptor s = null;
            try {
                s = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, 0);
                NetworkUtils.attachControlPacketFilter(s, OsConstants.ARPHRD_ETHER);
                Os.bind(s, new PacketSocketAddress((short)OsConstants.ETH_P_ALL, this.mIfIndex));
            }
            catch (ErrnoException | IOException e) {
                this.logError("Failed to create packet tracking socket: ", e);
                PacketListener.closeSocket(s);
                return null;
            }
            return s;
        }

        private final void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$handlePacket(byte[] recvbuf, int length) {
            String summary = ConnectivityPacketSummary.summarize(this.mHwAddr, recvbuf, length);
            if (summary == null) {
                return;
            }
            this.addLogEntry(summary + "\n[" + new String(HexEncoding.encode(recvbuf, 0, length)) + "]");
        }

        private final void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$logError(String msg, Exception e) {
            Log.e(this.this$0.mTag, msg, e);
            this.addLogEntry(msg + e);
        }

        private final void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$addLogEntry(String entry) {
            this.this$0.mHandler.post(() -> this.this$0.mLog.log(entry));
        }

        private void __constructor__(ConnectivityPacketTracker connectivityPacketTracker, int n, byte[] byArray, int n2) {
            this.$$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$__constructor__(connectivityPacketTracker, n, byArray, n2);
        }

        PacketListener(ConnectivityPacketTracker connectivityPacketTracker, int n, byte[] byArray, int n2) {
            this.this$0 = connectivityPacketTracker;
            super(n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$__constructor__(android.net.ip.ConnectivityPacketTracker int byte[] int ), 0, this, connectivityPacketTracker, n, byArray, n2);
        }

        @Override
        protected FileDescriptor createSocket() {
            return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$createSocket(), 0, this);
        }

        @Override
        protected void handlePacket(byte[] byArray, int n) {
            InvokeDynamicSupport.bootstrap("handlePacket", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$handlePacket(byte[] int ), 0, this, byArray, n);
        }

        @Override
        protected void logError(String string2, Exception exception) {
            InvokeDynamicSupport.bootstrap("logError", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$logError(java.lang.String java.lang.Exception ), 0, this, string2, exception);
        }

        private void addLogEntry(String string2) {
            InvokeDynamicSupport.bootstrap("addLogEntry", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$addLogEntry(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ PacketListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PacketListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

