/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiLinkLayerStats;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiInfo";
    private static EnumMap<SupplicantState, NetworkInfo.DetailedState> stateMap;
    public static String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    private SupplicantState mSupplicantState;
    private String mBSSID;
    private WifiSsid mWifiSsid;
    private int mNetworkId;
    public static int INVALID_RSSI = -127;
    public static int MIN_RSSI = -126;
    public static int MAX_RSSI = 200;
    private int mRssi;
    public static String LINK_SPEED_UNITS = "Mbps";
    private int mLinkSpeed;
    public static String FREQUENCY_UNITS = "MHz";
    private int mFrequency;
    private InetAddress mIpAddress;
    private String mMacAddress;
    private boolean mEphemeral;
    public long txBad;
    public long txRetries;
    public long txSuccess;
    public long rxSuccess;
    public double txBadRate;
    public double txRetriesRate;
    public double txSuccessRate;
    public double rxSuccessRate;
    private static long RESET_TIME_STAMP = Long.MIN_VALUE;
    private static long FILTER_TIME_CONSTANT = 3000L;
    private static long OUTPUT_SCALE_FACTOR = 5000L;
    private long mLastPacketCountUpdateTimeStamp;
    public int badRssiCount;
    public int linkStuckCount;
    public int lowRssiCount;
    public int score;
    private boolean mMeteredHint;
    public static Parcelable.Creator<WifiInfo> CREATOR;

    private final void $$robo$$android_net_wifi_WifiInfo$updatePacketRates(WifiLinkLayerStats stats, long timeStamp) {
        if (stats != null) {
            long txgood = stats.txmpdu_be + stats.txmpdu_bk + stats.txmpdu_vi + stats.txmpdu_vo;
            long txretries = stats.retries_be + stats.retries_bk + stats.retries_vi + stats.retries_vo;
            long rxgood = stats.rxmpdu_be + stats.rxmpdu_bk + stats.rxmpdu_vi + stats.rxmpdu_vo;
            long txbad = stats.lostmpdu_be + stats.lostmpdu_bk + stats.lostmpdu_vi + stats.lostmpdu_vo;
            if (this.mLastPacketCountUpdateTimeStamp != Long.MIN_VALUE && this.mLastPacketCountUpdateTimeStamp < timeStamp && this.txBad <= txbad && this.txSuccess <= txgood && this.rxSuccess <= rxgood && this.txRetries <= txretries) {
                long timeDelta = timeStamp - this.mLastPacketCountUpdateTimeStamp;
                double lastSampleWeight = Math.exp(-1.0 * (double)timeDelta / 3000.0);
                double currentSampleWeight = 1.0 - lastSampleWeight;
                this.txBadRate = this.txBadRate * lastSampleWeight + (double)((txbad - this.txBad) * 5000L / timeDelta) * currentSampleWeight;
                this.txSuccessRate = this.txSuccessRate * lastSampleWeight + (double)((txgood - this.txSuccess) * 5000L / timeDelta) * currentSampleWeight;
                this.rxSuccessRate = this.rxSuccessRate * lastSampleWeight + (double)((rxgood - this.rxSuccess) * 5000L / timeDelta) * currentSampleWeight;
                this.txRetriesRate = this.txRetriesRate * lastSampleWeight + (double)((txretries - this.txRetries) * 5000L / timeDelta) * currentSampleWeight;
            } else {
                this.txBadRate = 0.0;
                this.txSuccessRate = 0.0;
                this.rxSuccessRate = 0.0;
                this.txRetriesRate = 0.0;
            }
            this.txBad = txbad;
            this.txSuccess = txgood;
            this.rxSuccess = rxgood;
            this.txRetries = txretries;
            this.mLastPacketCountUpdateTimeStamp = timeStamp;
        } else {
            this.txBad = 0L;
            this.txSuccess = 0L;
            this.rxSuccess = 0L;
            this.txRetries = 0L;
            this.txBadRate = 0.0;
            this.txSuccessRate = 0.0;
            this.rxSuccessRate = 0.0;
            this.txRetriesRate = 0.0;
            this.mLastPacketCountUpdateTimeStamp = Long.MIN_VALUE;
        }
    }

    private final void $$robo$$android_net_wifi_WifiInfo$updatePacketRates(long txPackets, long rxPackets) {
        this.txBad = 0L;
        this.txRetries = 0L;
        this.txBadRate = 0.0;
        this.txRetriesRate = 0.0;
        if (this.txSuccess <= txPackets && this.rxSuccess <= rxPackets) {
            this.txSuccessRate = this.txSuccessRate * 0.5 + (double)(txPackets - this.txSuccess) * 0.5;
            this.rxSuccessRate = this.rxSuccessRate * 0.5 + (double)(rxPackets - this.rxSuccess) * 0.5;
        } else {
            this.txBadRate = 0.0;
            this.txRetriesRate = 0.0;
        }
        this.txSuccess = txPackets;
        this.rxSuccess = rxPackets;
    }

    private void $$robo$$android_net_wifi_WifiInfo$__constructor__() {
        this.mMacAddress = "02:00:00:00:00:00";
        this.mWifiSsid = null;
        this.mBSSID = null;
        this.mNetworkId = -1;
        this.mSupplicantState = SupplicantState.UNINITIALIZED;
        this.mRssi = -127;
        this.mLinkSpeed = -1;
        this.mFrequency = -1;
        this.mLastPacketCountUpdateTimeStamp = Long.MIN_VALUE;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$reset() {
        this.setInetAddress(null);
        this.setBSSID(null);
        this.setSSID(null);
        this.setNetworkId(-1);
        this.setRssi(-127);
        this.setLinkSpeed(-1);
        this.setFrequency(-1);
        this.setMeteredHint(false);
        this.setEphemeral(false);
        this.txBad = 0L;
        this.txSuccess = 0L;
        this.rxSuccess = 0L;
        this.txRetries = 0L;
        this.txBadRate = 0.0;
        this.txSuccessRate = 0.0;
        this.rxSuccessRate = 0.0;
        this.txRetriesRate = 0.0;
        this.lowRssiCount = 0;
        this.badRssiCount = 0;
        this.linkStuckCount = 0;
        this.score = 0;
        this.mLastPacketCountUpdateTimeStamp = Long.MIN_VALUE;
    }

    private void $$robo$$android_net_wifi_WifiInfo$__constructor__(WifiInfo source) {
        this.mMacAddress = "02:00:00:00:00:00";
        if (source != null) {
            this.mSupplicantState = source.mSupplicantState;
            this.mBSSID = source.mBSSID;
            this.mWifiSsid = source.mWifiSsid;
            this.mNetworkId = source.mNetworkId;
            this.mRssi = source.mRssi;
            this.mLinkSpeed = source.mLinkSpeed;
            this.mFrequency = source.mFrequency;
            this.mIpAddress = source.mIpAddress;
            this.mMacAddress = source.mMacAddress;
            this.mMeteredHint = source.mMeteredHint;
            this.mEphemeral = source.mEphemeral;
            this.txBad = source.txBad;
            this.txRetries = source.txRetries;
            this.txSuccess = source.txSuccess;
            this.rxSuccess = source.rxSuccess;
            this.txBadRate = source.txBadRate;
            this.txRetriesRate = source.txRetriesRate;
            this.txSuccessRate = source.txSuccessRate;
            this.rxSuccessRate = source.rxSuccessRate;
            this.mLastPacketCountUpdateTimeStamp = source.mLastPacketCountUpdateTimeStamp;
            this.score = source.score;
            this.badRssiCount = source.badRssiCount;
            this.lowRssiCount = source.lowRssiCount;
            this.linkStuckCount = source.linkStuckCount;
        }
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setSSID(WifiSsid wifiSsid) {
        this.mWifiSsid = wifiSsid;
    }

    private final String $$robo$$android_net_wifi_WifiInfo$getSSID() {
        if (this.mWifiSsid != null) {
            String unicode = this.mWifiSsid.toString();
            if (!TextUtils.isEmpty(unicode)) {
                return "\"" + unicode + "\"";
            }
            String hex = this.mWifiSsid.getHexString();
            return hex != null ? hex : "<unknown ssid>";
        }
        return "<unknown ssid>";
    }

    private final WifiSsid $$robo$$android_net_wifi_WifiInfo$getWifiSsid() {
        return this.mWifiSsid;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setBSSID(String BSSID) {
        this.mBSSID = BSSID;
    }

    private final String $$robo$$android_net_wifi_WifiInfo$getBSSID() {
        return this.mBSSID;
    }

    private final int $$robo$$android_net_wifi_WifiInfo$getRssi() {
        return this.mRssi;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setRssi(int rssi) {
        if (rssi < -127) {
            rssi = -127;
        }
        if (rssi > 200) {
            rssi = 200;
        }
        this.mRssi = rssi;
    }

    private final int $$robo$$android_net_wifi_WifiInfo$getLinkSpeed() {
        return this.mLinkSpeed;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setLinkSpeed(int linkSpeed) {
        this.mLinkSpeed = linkSpeed;
    }

    private final int $$robo$$android_net_wifi_WifiInfo$getFrequency() {
        return this.mFrequency;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setFrequency(int frequency) {
        this.mFrequency = frequency;
    }

    private final boolean $$robo$$android_net_wifi_WifiInfo$is24GHz() {
        return ScanResult.is24GHz(this.mFrequency);
    }

    private final boolean $$robo$$android_net_wifi_WifiInfo$is5GHz() {
        return ScanResult.is5GHz(this.mFrequency);
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setMacAddress(String macAddress) {
        this.mMacAddress = macAddress;
    }

    private final String $$robo$$android_net_wifi_WifiInfo$getMacAddress() {
        return this.mMacAddress;
    }

    private final boolean $$robo$$android_net_wifi_WifiInfo$hasRealMacAddress() {
        return this.mMacAddress != null && !"02:00:00:00:00:00".equals(this.mMacAddress);
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setMeteredHint(boolean meteredHint) {
        this.mMeteredHint = meteredHint;
    }

    private final boolean $$robo$$android_net_wifi_WifiInfo$getMeteredHint() {
        return this.mMeteredHint;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setEphemeral(boolean ephemeral) {
        this.mEphemeral = ephemeral;
    }

    private final boolean $$robo$$android_net_wifi_WifiInfo$isEphemeral() {
        return this.mEphemeral;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setNetworkId(int id2) {
        this.mNetworkId = id2;
    }

    private final int $$robo$$android_net_wifi_WifiInfo$getNetworkId() {
        return this.mNetworkId;
    }

    private final SupplicantState $$robo$$android_net_wifi_WifiInfo$getSupplicantState() {
        return this.mSupplicantState;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setSupplicantState(SupplicantState state) {
        this.mSupplicantState = state;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setInetAddress(InetAddress address) {
        this.mIpAddress = address;
    }

    private final int $$robo$$android_net_wifi_WifiInfo$getIpAddress() {
        int result = 0;
        if (this.mIpAddress instanceof Inet4Address) {
            result = NetworkUtils.inetAddressToInt((Inet4Address)this.mIpAddress);
        }
        return result;
    }

    private final boolean $$robo$$android_net_wifi_WifiInfo$getHiddenSSID() {
        if (this.mWifiSsid == null) {
            return false;
        }
        return this.mWifiSsid.isHidden();
    }

    private static final NetworkInfo.DetailedState $$robo$$android_net_wifi_WifiInfo$getDetailedStateOf(SupplicantState suppState) {
        return stateMap.get(suppState);
    }

    private final void $$robo$$android_net_wifi_WifiInfo$setSupplicantState(String stateName) {
        this.mSupplicantState = WifiInfo.valueOf(stateName);
    }

    private static final SupplicantState $$robo$$android_net_wifi_WifiInfo$valueOf(String stateName) {
        if ("4WAY_HANDSHAKE".equalsIgnoreCase(stateName)) {
            return SupplicantState.FOUR_WAY_HANDSHAKE;
        }
        try {
            return SupplicantState.valueOf(stateName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return SupplicantState.INVALID;
        }
    }

    private static final String $$robo$$android_net_wifi_WifiInfo$removeDoubleQuotes(String string2) {
        if (string2 == null) {
            return null;
        }
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    private final String $$robo$$android_net_wifi_WifiInfo$toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("SSID: ").append(this.mWifiSsid == null ? "<unknown ssid>" : this.mWifiSsid).append(", BSSID: ").append(this.mBSSID == null ? none : this.mBSSID).append(", MAC: ").append(this.mMacAddress == null ? none : this.mMacAddress).append(", Supplicant state: ").append(this.mSupplicantState == null ? none : this.mSupplicantState).append(", RSSI: ").append(this.mRssi).append(", Link speed: ").append(this.mLinkSpeed).append("Mbps").append(", Frequency: ").append(this.mFrequency).append("MHz").append(", Net ID: ").append(this.mNetworkId).append(", Metered hint: ").append(this.mMeteredHint).append(", score: ").append(Integer.toString(this.score));
        return sb.toString();
    }

    private final int $$robo$$android_net_wifi_WifiInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_WifiInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNetworkId);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mLinkSpeed);
        dest.writeInt(this.mFrequency);
        if (this.mIpAddress != null) {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.mIpAddress.getAddress());
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mWifiSsid != null) {
            dest.writeInt(1);
            this.mWifiSsid.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        dest.writeString(this.mBSSID);
        dest.writeString(this.mMacAddress);
        dest.writeInt(this.mMeteredHint ? 1 : 0);
        dest.writeInt(this.mEphemeral ? 1 : 0);
        dest.writeInt(this.score);
        dest.writeDouble(this.txSuccessRate);
        dest.writeDouble(this.txRetriesRate);
        dest.writeDouble(this.txBadRate);
        dest.writeDouble(this.rxSuccessRate);
        dest.writeInt(this.badRssiCount);
        dest.writeInt(this.lowRssiCount);
        this.mSupplicantState.writeToParcel(dest, flags);
    }

    static void __staticInitializer__() {
        stateMap = new EnumMap(SupplicantState.class);
        stateMap.put(SupplicantState.DISCONNECTED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.INTERFACE_DISABLED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.INACTIVE, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.SCANNING, NetworkInfo.DetailedState.SCANNING);
        stateMap.put(SupplicantState.AUTHENTICATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.ASSOCIATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.ASSOCIATED, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.FOUR_WAY_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.GROUP_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.COMPLETED, NetworkInfo.DetailedState.OBTAINING_IPADDR);
        stateMap.put(SupplicantState.DORMANT, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.UNINITIALIZED, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.INVALID, NetworkInfo.DetailedState.FAILED);
        CREATOR = new Parcelable.Creator<WifiInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_WifiInfo_1$__constructor__() {
            }

            private final WifiInfo $$robo$$android_net_wifi_WifiInfo_1$createFromParcel(Parcel in) {
                WifiInfo info = new WifiInfo();
                info.setNetworkId(in.readInt());
                info.setRssi(in.readInt());
                info.setLinkSpeed(in.readInt());
                info.setFrequency(in.readInt());
                if (in.readByte() == 1) {
                    try {
                        info.setInetAddress(InetAddress.getByAddress(in.createByteArray()));
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                if (in.readInt() == 1) {
                    info.mWifiSsid = WifiSsid.CREATOR.createFromParcel(in);
                }
                info.mBSSID = in.readString();
                info.mMacAddress = in.readString();
                info.mMeteredHint = in.readInt() != 0;
                info.mEphemeral = in.readInt() != 0;
                info.score = in.readInt();
                info.txSuccessRate = in.readDouble();
                info.txRetriesRate = in.readDouble();
                info.txBadRate = in.readDouble();
                info.rxSuccessRate = in.readDouble();
                info.badRssiCount = in.readInt();
                info.lowRssiCount = in.readInt();
                info.mSupplicantState = SupplicantState.CREATOR.createFromParcel(in);
                return info;
            }

            private final WifiInfo[] $$robo$$android_net_wifi_WifiInfo_1$newArray(int size) {
                return new WifiInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_WifiInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiInfo_1$__constructor__(), 0, this);
            }

            @Override
            public WifiInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public WifiInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public void updatePacketRates(WifiLinkLayerStats wifiLinkLayerStats, long l) {
        InvokeDynamicSupport.bootstrap("updatePacketRates", $$robo$$android_net_wifi_WifiInfo$updatePacketRates(android.net.wifi.WifiLinkLayerStats long ), 0, this, wifiLinkLayerStats, l);
    }

    public void updatePacketRates(long l, long l2) {
        InvokeDynamicSupport.bootstrap("updatePacketRates", $$robo$$android_net_wifi_WifiInfo$updatePacketRates(long long ), 0, this, l, l2);
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_WifiInfo$__constructor__();
    }

    public WifiInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiInfo$__constructor__(), 0, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_net_wifi_WifiInfo$reset(), 0, this);
    }

    private void __constructor__(WifiInfo wifiInfo) {
        this.$$robo$$android_net_wifi_WifiInfo$__constructor__(wifiInfo);
    }

    public WifiInfo(WifiInfo wifiInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiInfo$__constructor__(android.net.wifi.WifiInfo ), 0, this, wifiInfo);
    }

    public void setSSID(WifiSsid wifiSsid) {
        InvokeDynamicSupport.bootstrap("setSSID", $$robo$$android_net_wifi_WifiInfo$setSSID(android.net.wifi.WifiSsid ), 0, this, wifiSsid);
    }

    public String getSSID() {
        return InvokeDynamicSupport.bootstrap("getSSID", $$robo$$android_net_wifi_WifiInfo$getSSID(), 0, this);
    }

    public WifiSsid getWifiSsid() {
        return InvokeDynamicSupport.bootstrap("getWifiSsid", $$robo$$android_net_wifi_WifiInfo$getWifiSsid(), 0, this);
    }

    public void setBSSID(String string2) {
        InvokeDynamicSupport.bootstrap("setBSSID", $$robo$$android_net_wifi_WifiInfo$setBSSID(java.lang.String ), 0, this, string2);
    }

    public String getBSSID() {
        return InvokeDynamicSupport.bootstrap("getBSSID", $$robo$$android_net_wifi_WifiInfo$getBSSID(), 0, this);
    }

    public int getRssi() {
        return (int)InvokeDynamicSupport.bootstrap("getRssi", $$robo$$android_net_wifi_WifiInfo$getRssi(), 0, this);
    }

    public void setRssi(int n) {
        InvokeDynamicSupport.bootstrap("setRssi", $$robo$$android_net_wifi_WifiInfo$setRssi(int ), 0, this, n);
    }

    public int getLinkSpeed() {
        return (int)InvokeDynamicSupport.bootstrap("getLinkSpeed", $$robo$$android_net_wifi_WifiInfo$getLinkSpeed(), 0, this);
    }

    public void setLinkSpeed(int n) {
        InvokeDynamicSupport.bootstrap("setLinkSpeed", $$robo$$android_net_wifi_WifiInfo$setLinkSpeed(int ), 0, this, n);
    }

    public int getFrequency() {
        return (int)InvokeDynamicSupport.bootstrap("getFrequency", $$robo$$android_net_wifi_WifiInfo$getFrequency(), 0, this);
    }

    public void setFrequency(int n) {
        InvokeDynamicSupport.bootstrap("setFrequency", $$robo$$android_net_wifi_WifiInfo$setFrequency(int ), 0, this, n);
    }

    public boolean is24GHz() {
        return (boolean)InvokeDynamicSupport.bootstrap("is24GHz", $$robo$$android_net_wifi_WifiInfo$is24GHz(), 0, this);
    }

    public boolean is5GHz() {
        return (boolean)InvokeDynamicSupport.bootstrap("is5GHz", $$robo$$android_net_wifi_WifiInfo$is5GHz(), 0, this);
    }

    public void setMacAddress(String string2) {
        InvokeDynamicSupport.bootstrap("setMacAddress", $$robo$$android_net_wifi_WifiInfo$setMacAddress(java.lang.String ), 0, this, string2);
    }

    public String getMacAddress() {
        return InvokeDynamicSupport.bootstrap("getMacAddress", $$robo$$android_net_wifi_WifiInfo$getMacAddress(), 0, this);
    }

    public boolean hasRealMacAddress() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRealMacAddress", $$robo$$android_net_wifi_WifiInfo$hasRealMacAddress(), 0, this);
    }

    public void setMeteredHint(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMeteredHint", $$robo$$android_net_wifi_WifiInfo$setMeteredHint(boolean ), 0, this, bl);
    }

    public boolean getMeteredHint() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMeteredHint", $$robo$$android_net_wifi_WifiInfo$getMeteredHint(), 0, this);
    }

    public void setEphemeral(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEphemeral", $$robo$$android_net_wifi_WifiInfo$setEphemeral(boolean ), 0, this, bl);
    }

    public boolean isEphemeral() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEphemeral", $$robo$$android_net_wifi_WifiInfo$isEphemeral(), 0, this);
    }

    public void setNetworkId(int n) {
        InvokeDynamicSupport.bootstrap("setNetworkId", $$robo$$android_net_wifi_WifiInfo$setNetworkId(int ), 0, this, n);
    }

    public int getNetworkId() {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkId", $$robo$$android_net_wifi_WifiInfo$getNetworkId(), 0, this);
    }

    public SupplicantState getSupplicantState() {
        return InvokeDynamicSupport.bootstrap("getSupplicantState", $$robo$$android_net_wifi_WifiInfo$getSupplicantState(), 0, this);
    }

    public void setSupplicantState(SupplicantState supplicantState) {
        InvokeDynamicSupport.bootstrap("setSupplicantState", $$robo$$android_net_wifi_WifiInfo$setSupplicantState(android.net.wifi.SupplicantState ), 0, this, supplicantState);
    }

    public void setInetAddress(InetAddress inetAddress) {
        InvokeDynamicSupport.bootstrap("setInetAddress", $$robo$$android_net_wifi_WifiInfo$setInetAddress(java.net.InetAddress ), 0, this, inetAddress);
    }

    public int getIpAddress() {
        return (int)InvokeDynamicSupport.bootstrap("getIpAddress", $$robo$$android_net_wifi_WifiInfo$getIpAddress(), 0, this);
    }

    public boolean getHiddenSSID() {
        return (boolean)InvokeDynamicSupport.bootstrap("getHiddenSSID", $$robo$$android_net_wifi_WifiInfo$getHiddenSSID(), 0, this);
    }

    public static NetworkInfo.DetailedState getDetailedStateOf(SupplicantState supplicantState) {
        return InvokeDynamicSupport.bootstrapStatic("getDetailedStateOf", $$robo$$android_net_wifi_WifiInfo$getDetailedStateOf(android.net.wifi.SupplicantState ), 0, (SupplicantState)supplicantState);
    }

    void setSupplicantState(String string2) {
        InvokeDynamicSupport.bootstrap("setSupplicantState", $$robo$$android_net_wifi_WifiInfo$setSupplicantState(java.lang.String ), 0, this, string2);
    }

    static SupplicantState valueOf(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_wifi_WifiInfo$valueOf(java.lang.String ), 0, (String)string2);
    }

    public static String removeDoubleQuotes(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("removeDoubleQuotes", $$robo$$android_net_wifi_WifiInfo$removeDoubleQuotes(java.lang.String ), 0, (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiInfo$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(WifiInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

