/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2.pps;

import android.net.wifi.hotspot2.pps.UpdateParameter;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Policy
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Policy";
    private static int MAX_EXCLUSION_SSIDS = 128;
    private static int MAX_SSID_BYTES = 32;
    private static int MAX_PORT_STRING_BYTES = 64;
    private static int NULL_VALUE = -1;
    private long mMinHomeDownlinkBandwidth;
    private long mMinHomeUplinkBandwidth;
    private long mMinRoamingDownlinkBandwidth;
    private long mMinRoamingUplinkBandwidth;
    private String[] mExcludedSsidList;
    private Map<Integer, String> mRequiredProtoPortMap;
    private int mMaximumBssLoadValue;
    private List<RoamingPartner> mPreferredRoamingPartnerList;
    private UpdateParameter mPolicyUpdate;
    public static Parcelable.Creator<Policy> CREATOR;

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$setMinHomeDownlinkBandwidth(long minHomeDownlinkBandwidth) {
        this.mMinHomeDownlinkBandwidth = minHomeDownlinkBandwidth;
    }

    private final long $$robo$$android_net_wifi_hotspot2_pps_Policy$getMinHomeDownlinkBandwidth() {
        return this.mMinHomeDownlinkBandwidth;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$setMinHomeUplinkBandwidth(long minHomeUplinkBandwidth) {
        this.mMinHomeUplinkBandwidth = minHomeUplinkBandwidth;
    }

    private final long $$robo$$android_net_wifi_hotspot2_pps_Policy$getMinHomeUplinkBandwidth() {
        return this.mMinHomeUplinkBandwidth;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$setMinRoamingDownlinkBandwidth(long minRoamingDownlinkBandwidth) {
        this.mMinRoamingDownlinkBandwidth = minRoamingDownlinkBandwidth;
    }

    private final long $$robo$$android_net_wifi_hotspot2_pps_Policy$getMinRoamingDownlinkBandwidth() {
        return this.mMinRoamingDownlinkBandwidth;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$setMinRoamingUplinkBandwidth(long minRoamingUplinkBandwidth) {
        this.mMinRoamingUplinkBandwidth = minRoamingUplinkBandwidth;
    }

    private final long $$robo$$android_net_wifi_hotspot2_pps_Policy$getMinRoamingUplinkBandwidth() {
        return this.mMinRoamingUplinkBandwidth;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$setExcludedSsidList(String[] excludedSsidList) {
        this.mExcludedSsidList = excludedSsidList;
    }

    private final String[] $$robo$$android_net_wifi_hotspot2_pps_Policy$getExcludedSsidList() {
        return this.mExcludedSsidList;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$setRequiredProtoPortMap(Map<Integer, String> requiredProtoPortMap) {
        this.mRequiredProtoPortMap = requiredProtoPortMap;
    }

    private final Map<Integer, String> $$robo$$android_net_wifi_hotspot2_pps_Policy$getRequiredProtoPortMap() {
        return this.mRequiredProtoPortMap;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$setMaximumBssLoadValue(int maximumBssLoadValue) {
        this.mMaximumBssLoadValue = maximumBssLoadValue;
    }

    private final int $$robo$$android_net_wifi_hotspot2_pps_Policy$getMaximumBssLoadValue() {
        return this.mMaximumBssLoadValue;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$setPreferredRoamingPartnerList(List<RoamingPartner> partnerList) {
        this.mPreferredRoamingPartnerList = partnerList;
    }

    private final List<RoamingPartner> $$robo$$android_net_wifi_hotspot2_pps_Policy$getPreferredRoamingPartnerList() {
        return this.mPreferredRoamingPartnerList;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$setPolicyUpdate(UpdateParameter policyUpdate) {
        this.mPolicyUpdate = policyUpdate;
    }

    private final UpdateParameter $$robo$$android_net_wifi_hotspot2_pps_Policy$getPolicyUpdate() {
        return this.mPolicyUpdate;
    }

    private void $$robo$$android_net_wifi_hotspot2_pps_Policy$__constructor__() {
        this.mMinHomeDownlinkBandwidth = Long.MIN_VALUE;
        this.mMinHomeUplinkBandwidth = Long.MIN_VALUE;
        this.mMinRoamingDownlinkBandwidth = Long.MIN_VALUE;
        this.mMinRoamingUplinkBandwidth = Long.MIN_VALUE;
        this.mExcludedSsidList = null;
        this.mRequiredProtoPortMap = null;
        this.mMaximumBssLoadValue = Integer.MIN_VALUE;
        this.mPreferredRoamingPartnerList = null;
        this.mPolicyUpdate = null;
    }

    private void $$robo$$android_net_wifi_hotspot2_pps_Policy$__constructor__(Policy source) {
        this.mMinHomeDownlinkBandwidth = Long.MIN_VALUE;
        this.mMinHomeUplinkBandwidth = Long.MIN_VALUE;
        this.mMinRoamingDownlinkBandwidth = Long.MIN_VALUE;
        this.mMinRoamingUplinkBandwidth = Long.MIN_VALUE;
        this.mExcludedSsidList = null;
        this.mRequiredProtoPortMap = null;
        this.mMaximumBssLoadValue = Integer.MIN_VALUE;
        this.mPreferredRoamingPartnerList = null;
        this.mPolicyUpdate = null;
        if (source == null) {
            return;
        }
        this.mMinHomeDownlinkBandwidth = source.mMinHomeDownlinkBandwidth;
        this.mMinHomeUplinkBandwidth = source.mMinHomeUplinkBandwidth;
        this.mMinRoamingDownlinkBandwidth = source.mMinRoamingDownlinkBandwidth;
        this.mMinRoamingUplinkBandwidth = source.mMinRoamingUplinkBandwidth;
        this.mMaximumBssLoadValue = source.mMaximumBssLoadValue;
        if (source.mExcludedSsidList != null) {
            this.mExcludedSsidList = Arrays.copyOf(source.mExcludedSsidList, source.mExcludedSsidList.length);
        }
        if (source.mRequiredProtoPortMap != null) {
            this.mRequiredProtoPortMap = Collections.unmodifiableMap(source.mRequiredProtoPortMap);
        }
        if (source.mPreferredRoamingPartnerList != null) {
            this.mPreferredRoamingPartnerList = Collections.unmodifiableList(source.mPreferredRoamingPartnerList);
        }
        if (source.mPolicyUpdate != null) {
            this.mPolicyUpdate = new UpdateParameter(source.mPolicyUpdate);
        }
    }

    private final int $$robo$$android_net_wifi_hotspot2_pps_Policy$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Policy$writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mMinHomeDownlinkBandwidth);
        dest.writeLong(this.mMinHomeUplinkBandwidth);
        dest.writeLong(this.mMinRoamingDownlinkBandwidth);
        dest.writeLong(this.mMinRoamingUplinkBandwidth);
        dest.writeStringArray(this.mExcludedSsidList);
        Policy.writeProtoPortMap(dest, this.mRequiredProtoPortMap);
        dest.writeInt(this.mMaximumBssLoadValue);
        Policy.writeRoamingPartnerList(dest, flags, this.mPreferredRoamingPartnerList);
        dest.writeParcelable(this.mPolicyUpdate, flags);
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_pps_Policy$equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Policy)) {
            return false;
        }
        Policy that = (Policy)thatObject;
        return this.mMinHomeDownlinkBandwidth == that.mMinHomeDownlinkBandwidth && this.mMinHomeUplinkBandwidth == that.mMinHomeUplinkBandwidth && this.mMinRoamingDownlinkBandwidth == that.mMinRoamingDownlinkBandwidth && this.mMinRoamingUplinkBandwidth == that.mMinRoamingUplinkBandwidth && Arrays.equals(this.mExcludedSsidList, that.mExcludedSsidList) && (this.mRequiredProtoPortMap == null ? that.mRequiredProtoPortMap == null : this.mRequiredProtoPortMap.equals(that.mRequiredProtoPortMap)) && this.mMaximumBssLoadValue == that.mMaximumBssLoadValue && (this.mPreferredRoamingPartnerList == null ? that.mPreferredRoamingPartnerList == null : this.mPreferredRoamingPartnerList.equals(that.mPreferredRoamingPartnerList)) && (this.mPolicyUpdate == null ? that.mPolicyUpdate == null : this.mPolicyUpdate.equals(that.mPolicyUpdate));
    }

    private final int $$robo$$android_net_wifi_hotspot2_pps_Policy$hashCode() {
        return Objects.hash(this.mMinHomeDownlinkBandwidth, this.mMinHomeUplinkBandwidth, this.mMinRoamingDownlinkBandwidth, this.mMinRoamingUplinkBandwidth, this.mExcludedSsidList, this.mRequiredProtoPortMap, this.mMaximumBssLoadValue, this.mPreferredRoamingPartnerList, this.mPolicyUpdate);
    }

    private final String $$robo$$android_net_wifi_hotspot2_pps_Policy$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MinHomeDownlinkBandwidth: ").append(this.mMinHomeDownlinkBandwidth).append("\n");
        builder.append("MinHomeUplinkBandwidth: ").append(this.mMinHomeUplinkBandwidth).append("\n");
        builder.append("MinRoamingDownlinkBandwidth: ").append(this.mMinRoamingDownlinkBandwidth).append("\n");
        builder.append("MinRoamingUplinkBandwidth: ").append(this.mMinRoamingUplinkBandwidth).append("\n");
        builder.append("ExcludedSSIDList: ").append(this.mExcludedSsidList).append("\n");
        builder.append("RequiredProtoPortMap: ").append(this.mRequiredProtoPortMap).append("\n");
        builder.append("MaximumBSSLoadValue: ").append(this.mMaximumBssLoadValue).append("\n");
        builder.append("PreferredRoamingPartnerList: ").append(this.mPreferredRoamingPartnerList).append("\n");
        if (this.mPolicyUpdate != null) {
            builder.append("PolicyUpdate Begin ---\n");
            builder.append(this.mPolicyUpdate);
            builder.append("PolicyUpdate End ---\n");
        }
        return builder.toString();
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_pps_Policy$validate() {
        if (this.mPolicyUpdate == null) {
            Log.d("Policy", "PolicyUpdate not specified");
            return false;
        }
        if (!this.mPolicyUpdate.validate()) {
            return false;
        }
        if (this.mExcludedSsidList != null) {
            if (this.mExcludedSsidList.length > 128) {
                Log.d("Policy", "SSID exclusion list size exceeded the max: " + this.mExcludedSsidList.length);
                return false;
            }
            for (String ssid : this.mExcludedSsidList) {
                if (ssid.getBytes(StandardCharsets.UTF_8).length <= 32) continue;
                Log.d("Policy", "Invalid SSID: " + (String)ssid);
                return false;
            }
        }
        if (this.mRequiredProtoPortMap != null) {
            for (Map.Entry entry : this.mRequiredProtoPortMap.entrySet()) {
                String portNumber = (String)entry.getValue();
                if (portNumber.getBytes(StandardCharsets.UTF_8).length <= 64) continue;
                Log.d("Policy", "PortNumber string bytes exceeded the max: " + portNumber);
                return false;
            }
        }
        if (this.mPreferredRoamingPartnerList != null) {
            for (RoamingPartner roamingPartner : this.mPreferredRoamingPartnerList) {
                if (roamingPartner.validate()) continue;
                return false;
            }
        }
        return true;
    }

    private static final void $$robo$$android_net_wifi_hotspot2_pps_Policy$writeProtoPortMap(Parcel dest, Map<Integer, String> protoPortMap) {
        if (protoPortMap == null) {
            dest.writeInt(-1);
            return;
        }
        dest.writeInt(protoPortMap.size());
        for (Map.Entry<Integer, String> entry : protoPortMap.entrySet()) {
            dest.writeInt(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    private static final void $$robo$$android_net_wifi_hotspot2_pps_Policy$writeRoamingPartnerList(Parcel dest, int flags, List<RoamingPartner> partnerList) {
        if (partnerList == null) {
            dest.writeInt(-1);
            return;
        }
        dest.writeInt(partnerList.size());
        for (RoamingPartner partner : partnerList) {
            dest.writeParcelable(partner, flags);
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Policy>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_hotspot2_pps_Policy_1$__constructor__() {
            }

            private final Policy $$robo$$android_net_wifi_hotspot2_pps_Policy_1$createFromParcel(Parcel in) {
                Policy policy = new Policy();
                policy.setMinHomeDownlinkBandwidth(in.readLong());
                policy.setMinHomeUplinkBandwidth(in.readLong());
                policy.setMinRoamingDownlinkBandwidth(in.readLong());
                policy.setMinRoamingUplinkBandwidth(in.readLong());
                policy.setExcludedSsidList(in.createStringArray());
                policy.setRequiredProtoPortMap(this.readProtoPortMap(in));
                policy.setMaximumBssLoadValue(in.readInt());
                policy.setPreferredRoamingPartnerList(this.readRoamingPartnerList(in));
                policy.setPolicyUpdate((UpdateParameter)in.readParcelable(null));
                return policy;
            }

            private final Policy[] $$robo$$android_net_wifi_hotspot2_pps_Policy_1$newArray(int size) {
                return new Policy[size];
            }

            private final Map<Integer, String> $$robo$$android_net_wifi_hotspot2_pps_Policy_1$readProtoPortMap(Parcel in) {
                int size = in.readInt();
                if (size == -1) {
                    return null;
                }
                HashMap<Integer, String> protoPortMap = new HashMap<Integer, String>(size);
                for (int i = 0; i < size; ++i) {
                    int key = in.readInt();
                    String value = in.readString();
                    protoPortMap.put(key, value);
                }
                return protoPortMap;
            }

            private final List<RoamingPartner> $$robo$$android_net_wifi_hotspot2_pps_Policy_1$readRoamingPartnerList(Parcel in) {
                int size = in.readInt();
                if (size == -1) {
                    return null;
                }
                ArrayList<RoamingPartner> partnerList = new ArrayList<RoamingPartner>();
                for (int i = 0; i < size; ++i) {
                    partnerList.add((RoamingPartner)in.readParcelable(null));
                }
                return partnerList;
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_hotspot2_pps_Policy_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Policy_1$__constructor__(), 0, this);
            }

            @Override
            public Policy createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_hotspot2_pps_Policy_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Policy[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_hotspot2_pps_Policy_1$newArray(int ), 0, this, n);
            }

            private Map<Integer, String> readProtoPortMap(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("readProtoPortMap", $$robo$$android_net_wifi_hotspot2_pps_Policy_1$readProtoPortMap(android.os.Parcel ), 0, this, parcel);
            }

            private List<RoamingPartner> readRoamingPartnerList(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("readRoamingPartnerList", $$robo$$android_net_wifi_hotspot2_pps_Policy_1$readRoamingPartnerList(android.os.Parcel ), 0, this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public void setMinHomeDownlinkBandwidth(long l) {
        InvokeDynamicSupport.bootstrap("setMinHomeDownlinkBandwidth", $$robo$$android_net_wifi_hotspot2_pps_Policy$setMinHomeDownlinkBandwidth(long ), 0, this, l);
    }

    public long getMinHomeDownlinkBandwidth() {
        return (long)InvokeDynamicSupport.bootstrap("getMinHomeDownlinkBandwidth", $$robo$$android_net_wifi_hotspot2_pps_Policy$getMinHomeDownlinkBandwidth(), 0, this);
    }

    public void setMinHomeUplinkBandwidth(long l) {
        InvokeDynamicSupport.bootstrap("setMinHomeUplinkBandwidth", $$robo$$android_net_wifi_hotspot2_pps_Policy$setMinHomeUplinkBandwidth(long ), 0, this, l);
    }

    public long getMinHomeUplinkBandwidth() {
        return (long)InvokeDynamicSupport.bootstrap("getMinHomeUplinkBandwidth", $$robo$$android_net_wifi_hotspot2_pps_Policy$getMinHomeUplinkBandwidth(), 0, this);
    }

    public void setMinRoamingDownlinkBandwidth(long l) {
        InvokeDynamicSupport.bootstrap("setMinRoamingDownlinkBandwidth", $$robo$$android_net_wifi_hotspot2_pps_Policy$setMinRoamingDownlinkBandwidth(long ), 0, this, l);
    }

    public long getMinRoamingDownlinkBandwidth() {
        return (long)InvokeDynamicSupport.bootstrap("getMinRoamingDownlinkBandwidth", $$robo$$android_net_wifi_hotspot2_pps_Policy$getMinRoamingDownlinkBandwidth(), 0, this);
    }

    public void setMinRoamingUplinkBandwidth(long l) {
        InvokeDynamicSupport.bootstrap("setMinRoamingUplinkBandwidth", $$robo$$android_net_wifi_hotspot2_pps_Policy$setMinRoamingUplinkBandwidth(long ), 0, this, l);
    }

    public long getMinRoamingUplinkBandwidth() {
        return (long)InvokeDynamicSupport.bootstrap("getMinRoamingUplinkBandwidth", $$robo$$android_net_wifi_hotspot2_pps_Policy$getMinRoamingUplinkBandwidth(), 0, this);
    }

    public void setExcludedSsidList(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setExcludedSsidList", $$robo$$android_net_wifi_hotspot2_pps_Policy$setExcludedSsidList(java.lang.String[] ), 0, this, stringArray);
    }

    public String[] getExcludedSsidList() {
        return InvokeDynamicSupport.bootstrap("getExcludedSsidList", $$robo$$android_net_wifi_hotspot2_pps_Policy$getExcludedSsidList(), 0, this);
    }

    public void setRequiredProtoPortMap(Map<Integer, String> map) {
        InvokeDynamicSupport.bootstrap("setRequiredProtoPortMap", $$robo$$android_net_wifi_hotspot2_pps_Policy$setRequiredProtoPortMap(java.util.Map<java.lang.Integer, java.lang.String> ), 0, this, map);
    }

    public Map<Integer, String> getRequiredProtoPortMap() {
        return InvokeDynamicSupport.bootstrap("getRequiredProtoPortMap", $$robo$$android_net_wifi_hotspot2_pps_Policy$getRequiredProtoPortMap(), 0, this);
    }

    public void setMaximumBssLoadValue(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumBssLoadValue", $$robo$$android_net_wifi_hotspot2_pps_Policy$setMaximumBssLoadValue(int ), 0, this, n);
    }

    public int getMaximumBssLoadValue() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumBssLoadValue", $$robo$$android_net_wifi_hotspot2_pps_Policy$getMaximumBssLoadValue(), 0, this);
    }

    public void setPreferredRoamingPartnerList(List<RoamingPartner> list) {
        InvokeDynamicSupport.bootstrap("setPreferredRoamingPartnerList", $$robo$$android_net_wifi_hotspot2_pps_Policy$setPreferredRoamingPartnerList(java.util.List<android.net.wifi.hotspot2.pps.Policy$RoamingPartner> ), 0, this, list);
    }

    public List<RoamingPartner> getPreferredRoamingPartnerList() {
        return InvokeDynamicSupport.bootstrap("getPreferredRoamingPartnerList", $$robo$$android_net_wifi_hotspot2_pps_Policy$getPreferredRoamingPartnerList(), 0, this);
    }

    public void setPolicyUpdate(UpdateParameter updateParameter) {
        InvokeDynamicSupport.bootstrap("setPolicyUpdate", $$robo$$android_net_wifi_hotspot2_pps_Policy$setPolicyUpdate(android.net.wifi.hotspot2.pps.UpdateParameter ), 0, this, updateParameter);
    }

    public UpdateParameter getPolicyUpdate() {
        return InvokeDynamicSupport.bootstrap("getPolicyUpdate", $$robo$$android_net_wifi_hotspot2_pps_Policy$getPolicyUpdate(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_hotspot2_pps_Policy$__constructor__();
    }

    public Policy() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Policy$__constructor__(), 0, this);
    }

    private void __constructor__(Policy policy) {
        this.$$robo$$android_net_wifi_hotspot2_pps_Policy$__constructor__(policy);
    }

    public Policy(Policy policy) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Policy$__constructor__(android.net.wifi.hotspot2.pps.Policy ), 0, this, policy);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_hotspot2_pps_Policy$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_hotspot2_pps_Policy$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_hotspot2_pps_Policy$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_hotspot2_pps_Policy$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_hotspot2_pps_Policy$toString(), 0, this);
    }

    public boolean validate() {
        return (boolean)InvokeDynamicSupport.bootstrap("validate", $$robo$$android_net_wifi_hotspot2_pps_Policy$validate(), 0, this);
    }

    private static void writeProtoPortMap(Parcel parcel, Map<Integer, String> map) {
        InvokeDynamicSupport.bootstrapStatic("writeProtoPortMap", $$robo$$android_net_wifi_hotspot2_pps_Policy$writeProtoPortMap(android.os.Parcel java.util.Map<java.lang.Integer, java.lang.String> ), 0, (Parcel)parcel, map);
    }

    private static void writeRoamingPartnerList(Parcel parcel, int n, List<RoamingPartner> list) {
        InvokeDynamicSupport.bootstrapStatic("writeRoamingPartnerList", $$robo$$android_net_wifi_hotspot2_pps_Policy$writeRoamingPartnerList(android.os.Parcel int java.util.List<android.net.wifi.hotspot2.pps.Policy$RoamingPartner> ), 0, (Parcel)parcel, (int)n, list);
    }

    static {
        RobolectricInternals.classInitializing(Policy.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Policy)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RoamingPartner
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mFqdn;
        private boolean mFqdnExactMatch;
        private int mPriority;
        private String mCountries;
        public static Parcelable.Creator<RoamingPartner> CREATOR;

        private final void $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$setFqdn(String fqdn) {
            this.mFqdn = fqdn;
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$getFqdn() {
            return this.mFqdn;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$setFqdnExactMatch(boolean fqdnExactMatch) {
            this.mFqdnExactMatch = fqdnExactMatch;
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$getFqdnExactMatch() {
            return this.mFqdnExactMatch;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$setPriority(int priority) {
            this.mPriority = priority;
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$getPriority() {
            return this.mPriority;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$setCountries(String countries) {
            this.mCountries = countries;
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$getCountries() {
            return this.mCountries;
        }

        private void $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$__constructor__() {
            this.mFqdn = null;
            this.mFqdnExactMatch = false;
            this.mPriority = Integer.MIN_VALUE;
            this.mCountries = null;
        }

        private void $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$__constructor__(RoamingPartner source) {
            this.mFqdn = null;
            this.mFqdnExactMatch = false;
            this.mPriority = Integer.MIN_VALUE;
            this.mCountries = null;
            if (source != null) {
                this.mFqdn = source.mFqdn;
                this.mFqdnExactMatch = source.mFqdnExactMatch;
                this.mPriority = source.mPriority;
                this.mCountries = source.mCountries;
            }
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mFqdn);
            dest.writeInt(this.mFqdnExactMatch ? 1 : 0);
            dest.writeInt(this.mPriority);
            dest.writeString(this.mCountries);
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$equals(Object thatObject) {
            if (this == thatObject) {
                return true;
            }
            if (!(thatObject instanceof RoamingPartner)) {
                return false;
            }
            RoamingPartner that = (RoamingPartner)thatObject;
            return TextUtils.equals(this.mFqdn, that.mFqdn) && this.mFqdnExactMatch == that.mFqdnExactMatch && this.mPriority == that.mPriority && TextUtils.equals(this.mCountries, that.mCountries);
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$hashCode() {
            return Objects.hash(this.mFqdn, this.mFqdnExactMatch, this.mPriority, this.mCountries);
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FQDN: ").append(this.mFqdn).append("\n");
            builder.append("ExactMatch: ").append("mFqdnExactMatch").append("\n");
            builder.append("Priority: ").append(this.mPriority).append("\n");
            builder.append("Countries: ").append(this.mCountries).append("\n");
            return builder.toString();
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$validate() {
            if (TextUtils.isEmpty(this.mFqdn)) {
                Log.d("Policy", "Missing FQDN");
                return false;
            }
            if (TextUtils.isEmpty(this.mCountries)) {
                Log.d("Policy", "Missing countries");
                return false;
            }
            return true;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RoamingPartner>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner_1$__constructor__() {
                }

                private final RoamingPartner $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner_1$createFromParcel(Parcel in) {
                    RoamingPartner roamingPartner = new RoamingPartner();
                    roamingPartner.setFqdn(in.readString());
                    roamingPartner.setFqdnExactMatch(in.readInt() != 0);
                    roamingPartner.setPriority(in.readInt());
                    roamingPartner.setCountries(in.readString());
                    return roamingPartner;
                }

                private final RoamingPartner[] $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner_1$newArray(int size) {
                    return new RoamingPartner[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner_1$__constructor__(), 0, this);
                }

                @Override
                public RoamingPartner createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public RoamingPartner[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public void setFqdn(String string2) {
            InvokeDynamicSupport.bootstrap("setFqdn", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$setFqdn(java.lang.String ), 0, this, string2);
        }

        public String getFqdn() {
            return InvokeDynamicSupport.bootstrap("getFqdn", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$getFqdn(), 0, this);
        }

        public void setFqdnExactMatch(boolean bl) {
            InvokeDynamicSupport.bootstrap("setFqdnExactMatch", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$setFqdnExactMatch(boolean ), 0, this, bl);
        }

        public boolean getFqdnExactMatch() {
            return (boolean)InvokeDynamicSupport.bootstrap("getFqdnExactMatch", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$getFqdnExactMatch(), 0, this);
        }

        public void setPriority(int n) {
            InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$setPriority(int ), 0, this, n);
        }

        public int getPriority() {
            return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$getPriority(), 0, this);
        }

        public void setCountries(String string2) {
            InvokeDynamicSupport.bootstrap("setCountries", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$setCountries(java.lang.String ), 0, this, string2);
        }

        public String getCountries() {
            return InvokeDynamicSupport.bootstrap("getCountries", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$getCountries(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$__constructor__();
        }

        public RoamingPartner() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$__constructor__(), 0, this);
        }

        private void __constructor__(RoamingPartner roamingPartner) {
            this.$$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$__constructor__(roamingPartner);
        }

        public RoamingPartner(RoamingPartner roamingPartner) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$__constructor__(android.net.wifi.hotspot2.pps.Policy$RoamingPartner ), 0, this, roamingPartner);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$toString(), 0, this);
        }

        public boolean validate() {
            return (boolean)InvokeDynamicSupport.bootstrap("validate", $$robo$$android_net_wifi_hotspot2_pps_Policy_RoamingPartner$validate(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(RoamingPartner.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RoamingPartner)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

