/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.nfc.cardemulation.CardEmulation;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AidGroup
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int MAX_NUM_AIDS = 256;
    static String TAG = "AidGroup";
    List<String> aids;
    String category;
    String description;
    public static Parcelable.Creator<AidGroup> CREATOR;

    private void $$robo$$android_nfc_cardemulation_AidGroup$__constructor__(List<String> aids, String category) {
        if (aids == null || aids.size() == 0) {
            throw new IllegalArgumentException("No AIDS in AID group.");
        }
        if (aids.size() > 256) {
            throw new IllegalArgumentException("Too many AIDs in AID group.");
        }
        for (String aid : aids) {
            if (CardEmulation.isValidAid(aid)) continue;
            throw new IllegalArgumentException("AID " + aid + " is not a valid AID.");
        }
        this.category = AidGroup.isValidCategory(category) ? category : "other";
        this.aids = new ArrayList<String>(aids.size());
        for (String aid : aids) {
            this.aids.add(aid.toUpperCase());
        }
        this.description = null;
    }

    private void $$robo$$android_nfc_cardemulation_AidGroup$__constructor__(String category, String description) {
        this.aids = new ArrayList<String>();
        this.category = category;
        this.description = description;
    }

    private final String $$robo$$android_nfc_cardemulation_AidGroup$getCategory() {
        return this.category;
    }

    private final List<String> $$robo$$android_nfc_cardemulation_AidGroup$getAids() {
        return this.aids;
    }

    private final String $$robo$$android_nfc_cardemulation_AidGroup$toString() {
        StringBuilder out = new StringBuilder("Category: " + this.category + ", AIDs:");
        for (String aid : this.aids) {
            out.append(aid);
            out.append(", ");
        }
        return out.toString();
    }

    private final int $$robo$$android_nfc_cardemulation_AidGroup$describeContents() {
        return 0;
    }

    private final void $$robo$$android_nfc_cardemulation_AidGroup$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.category);
        dest.writeInt(this.aids.size());
        if (this.aids.size() > 0) {
            dest.writeStringList(this.aids);
        }
    }

    private static final AidGroup $$robo$$android_nfc_cardemulation_AidGroup$createFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        String category = null;
        ArrayList<String> aids = new ArrayList<String>();
        AidGroup group = null;
        boolean inGroup = false;
        int eventType = parser.getEventType();
        int minDepth = parser.getDepth();
        while (eventType != 1 && parser.getDepth() >= minDepth) {
            String tagName = parser.getName();
            if (eventType == 2) {
                if (tagName.equals("aid")) {
                    if (inGroup) {
                        String aid = parser.getAttributeValue(null, "value");
                        if (aid != null) {
                            aids.add(aid.toUpperCase());
                        }
                    } else {
                        Log.d("AidGroup", "Ignoring <aid> tag while not in group");
                    }
                } else if (tagName.equals("aid-group")) {
                    category = parser.getAttributeValue(null, "category");
                    if (category == null) {
                        Log.e("AidGroup", "<aid-group> tag without valid category");
                        return null;
                    }
                    inGroup = true;
                } else {
                    Log.d("AidGroup", "Ignoring unexpected tag: " + tagName);
                }
            } else if (eventType == 3 && tagName.equals("aid-group") && inGroup && aids.size() > 0) {
                group = new AidGroup(aids, category);
                break;
            }
            eventType = parser.next();
        }
        return group;
    }

    private final void $$robo$$android_nfc_cardemulation_AidGroup$writeAsXml(XmlSerializer out) throws IOException {
        out.startTag(null, "aid-group");
        out.attribute(null, "category", this.category);
        for (String aid : this.aids) {
            out.startTag(null, "aid");
            out.attribute(null, "value", aid);
            out.endTag(null, "aid");
        }
        out.endTag(null, "aid-group");
    }

    private static final boolean $$robo$$android_nfc_cardemulation_AidGroup$isValidCategory(String category) {
        return "payment".equals(category) || "other".equals(category);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AidGroup>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_nfc_cardemulation_AidGroup_1$__constructor__() {
            }

            private final AidGroup $$robo$$android_nfc_cardemulation_AidGroup_1$createFromParcel(Parcel source) {
                String category = source.readString();
                int listSize = source.readInt();
                ArrayList<String> aidList = new ArrayList<String>();
                if (listSize > 0) {
                    source.readStringList(aidList);
                }
                return new AidGroup(aidList, category);
            }

            private final AidGroup[] $$robo$$android_nfc_cardemulation_AidGroup_1$newArray(int size) {
                return new AidGroup[size];
            }

            private void __constructor__() {
                this.$$robo$$android_nfc_cardemulation_AidGroup_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_AidGroup_1$__constructor__(), 0, this);
            }

            @Override
            public AidGroup createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_nfc_cardemulation_AidGroup_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AidGroup[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_nfc_cardemulation_AidGroup_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(List<String> list, String string2) {
        this.$$robo$$android_nfc_cardemulation_AidGroup$__constructor__(list, string2);
    }

    public AidGroup(List<String> list, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_AidGroup$__constructor__(java.util.List<java.lang.String> java.lang.String ), 0, this, list, string2);
    }

    private void __constructor__(String string2, String string3) {
        this.$$robo$$android_nfc_cardemulation_AidGroup$__constructor__(string2, string3);
    }

    AidGroup(String string2, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_AidGroup$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String getCategory() {
        return InvokeDynamicSupport.bootstrap("getCategory", $$robo$$android_nfc_cardemulation_AidGroup$getCategory(), 0, this);
    }

    public List<String> getAids() {
        return InvokeDynamicSupport.bootstrap("getAids", $$robo$$android_nfc_cardemulation_AidGroup$getAids(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_nfc_cardemulation_AidGroup$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_nfc_cardemulation_AidGroup$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_nfc_cardemulation_AidGroup$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public static AidGroup createFromXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXml", $$robo$$android_nfc_cardemulation_AidGroup$createFromXml(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    public void writeAsXml(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("writeAsXml", $$robo$$android_nfc_cardemulation_AidGroup$writeAsXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
    }

    static boolean isValidCategory(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidCategory", $$robo$$android_nfc_cardemulation_AidGroup$isValidCategory(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(AidGroup.class);
    }

    public /* synthetic */ AidGroup() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AidGroup)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

