/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.ETC1;
import android.opengl.GLES10;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ETC1Util
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_opengl_ETC1Util$__constructor__() {
    }

    private static final void $$robo$$android_opengl_ETC1Util$loadTexture(int target, int level, int border, int fallbackFormat, int fallbackType, InputStream input) throws IOException {
        ETC1Util.loadTexture(target, level, border, fallbackFormat, fallbackType, ETC1Util.createTexture(input));
    }

    private static final void $$robo$$android_opengl_ETC1Util$loadTexture(int target, int level, int border, int fallbackFormat, int fallbackType, ETC1Texture texture) {
        if (fallbackFormat != 6407) {
            throw new IllegalArgumentException("fallbackFormat must be GL_RGB");
        }
        if (fallbackType != 33635 && fallbackType != 5121) {
            throw new IllegalArgumentException("Unsupported fallbackType");
        }
        int width = texture.getWidth();
        int height = texture.getHeight();
        ByteBuffer data = texture.getData();
        if (ETC1Util.isETC1Supported()) {
            int imageSize = data.remaining();
            GLES10.glCompressedTexImage2D(target, level, 36196, width, height, border, imageSize, data);
        } else {
            boolean useShorts = fallbackType != 5121;
            int pixelSize = useShorts ? 2 : 3;
            int stride = pixelSize * width;
            ByteBuffer decodedData = ByteBuffer.allocateDirect(stride * height).order(ByteOrder.nativeOrder());
            ETC1.decodeImage(data, decodedData, width, height, pixelSize, stride);
            GLES10.glTexImage2D(target, level, fallbackFormat, width, height, border, fallbackFormat, fallbackType, decodedData);
        }
    }

    private static final boolean $$robo$$android_opengl_ETC1Util$isETC1Supported() {
        int[] results = new int[20];
        GLES10.glGetIntegerv(34466, results, 0);
        int numFormats = results[0];
        if (numFormats > results.length) {
            results = new int[numFormats];
        }
        GLES10.glGetIntegerv(34467, results, 0);
        for (int i = 0; i < numFormats; ++i) {
            if (results[i] != 36196) continue;
            return true;
        }
        return false;
    }

    private static final ETC1Texture $$robo$$android_opengl_ETC1Util$createTexture(InputStream input) throws IOException {
        int chunkSize;
        int width = 0;
        int height = 0;
        byte[] ioBuffer = new byte[4096];
        if (input.read(ioBuffer, 0, 16) != 16) {
            throw new IOException("Unable to read PKM file header.");
        }
        ByteBuffer headerBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        headerBuffer.put(ioBuffer, 0, 16).position(0);
        if (!ETC1.isValid(headerBuffer)) {
            throw new IOException("Not a PKM file.");
        }
        width = ETC1.getWidth(headerBuffer);
        height = ETC1.getHeight(headerBuffer);
        int encodedSize = ETC1.getEncodedDataSize(width, height);
        ByteBuffer dataBuffer = ByteBuffer.allocateDirect(encodedSize).order(ByteOrder.nativeOrder());
        for (int i = 0; i < encodedSize; i += chunkSize) {
            chunkSize = Math.min(ioBuffer.length, encodedSize - i);
            if (input.read(ioBuffer, 0, chunkSize) != chunkSize) {
                throw new IOException("Unable to read PKM file data.");
            }
            dataBuffer.put(ioBuffer, 0, chunkSize);
        }
        dataBuffer.position(0);
        return new ETC1Texture(width, height, dataBuffer);
    }

    private static final ETC1Texture $$robo$$android_opengl_ETC1Util$compressTexture(Buffer input, int width, int height, int pixelSize, int stride) {
        int encodedImageSize = ETC1.getEncodedDataSize(width, height);
        ByteBuffer compressedImage = ByteBuffer.allocateDirect(encodedImageSize).order(ByteOrder.nativeOrder());
        ETC1.encodeImage(input, width, height, pixelSize, stride, compressedImage);
        return new ETC1Texture(width, height, compressedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_opengl_ETC1Util$writeTexture(ETC1Texture texture, OutputStream output) throws IOException {
        ByteBuffer dataBuffer = texture.getData();
        int originalPosition = dataBuffer.position();
        try {
            int chunkSize;
            int width = texture.getWidth();
            int height = texture.getHeight();
            ByteBuffer header = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
            ETC1.formatHeader(header, width, height);
            byte[] ioBuffer = new byte[4096];
            header.get(ioBuffer, 0, 16);
            output.write(ioBuffer, 0, 16);
            int encodedSize = ETC1.getEncodedDataSize(width, height);
            for (int i = 0; i < encodedSize; i += chunkSize) {
                chunkSize = Math.min(ioBuffer.length, encodedSize - i);
                dataBuffer.get(ioBuffer, 0, chunkSize);
                output.write(ioBuffer, 0, chunkSize);
            }
        }
        finally {
            dataBuffer.position(originalPosition);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_opengl_ETC1Util$__constructor__();
    }

    public ETC1Util() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_ETC1Util$__constructor__(), 0, this);
    }

    public static void loadTexture(int n, int n2, int n3, int n4, int n5, InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("loadTexture", $$robo$$android_opengl_ETC1Util$loadTexture(int int int int int java.io.InputStream ), 0, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (InputStream)inputStream);
    }

    public static void loadTexture(int n, int n2, int n3, int n4, int n5, ETC1Texture eTC1Texture) {
        InvokeDynamicSupport.bootstrapStatic("loadTexture", $$robo$$android_opengl_ETC1Util$loadTexture(int int int int int android.opengl.ETC1Util$ETC1Texture ), 0, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (ETC1Texture)eTC1Texture);
    }

    public static boolean isETC1Supported() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isETC1Supported", $$robo$$android_opengl_ETC1Util$isETC1Supported(), 0);
    }

    public static ETC1Texture createTexture(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createTexture", $$robo$$android_opengl_ETC1Util$createTexture(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static ETC1Texture compressTexture(Buffer buffer, int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrapStatic("compressTexture", $$robo$$android_opengl_ETC1Util$compressTexture(java.nio.Buffer int int int int ), 0, (Buffer)buffer, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public static void writeTexture(ETC1Texture eTC1Texture, OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeTexture", $$robo$$android_opengl_ETC1Util$writeTexture(android.opengl.ETC1Util$ETC1Texture java.io.OutputStream ), 0, (ETC1Texture)eTC1Texture, (OutputStream)outputStream);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ETC1Util)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ETC1Texture
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mWidth;
        private int mHeight;
        private ByteBuffer mData;

        private void $$robo$$android_opengl_ETC1Util_ETC1Texture$__constructor__(int width, int height, ByteBuffer data) {
            this.mWidth = width;
            this.mHeight = height;
            this.mData = data;
        }

        private final int $$robo$$android_opengl_ETC1Util_ETC1Texture$getWidth() {
            return this.mWidth;
        }

        private final int $$robo$$android_opengl_ETC1Util_ETC1Texture$getHeight() {
            return this.mHeight;
        }

        private final ByteBuffer $$robo$$android_opengl_ETC1Util_ETC1Texture$getData() {
            return this.mData;
        }

        private void __constructor__(int n, int n2, ByteBuffer byteBuffer) {
            this.$$robo$$android_opengl_ETC1Util_ETC1Texture$__constructor__(n, n2, byteBuffer);
        }

        public ETC1Texture(int n, int n2, ByteBuffer byteBuffer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_ETC1Util_ETC1Texture$__constructor__(int int java.nio.ByteBuffer ), 0, this, n, n2, byteBuffer);
        }

        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_opengl_ETC1Util_ETC1Texture$getWidth(), 0, this);
        }

        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_opengl_ETC1Util_ETC1Texture$getHeight(), 0, this);
        }

        public ByteBuffer getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_opengl_ETC1Util_ETC1Texture$getData(), 0, this);
        }

        public /* synthetic */ ETC1Texture() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ETC1Texture)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

