/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.GLWrapperBase;
import java.io.IOException;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import javax.microedition.khronos.opengles.GL;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GLLogWrapper
extends GLWrapperBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int FORMAT_INT = 0;
    private static int FORMAT_FLOAT = 1;
    private static int FORMAT_FIXED = 2;
    private Writer mLog;
    private boolean mLogArgumentNames;
    private int mArgCount;
    private PointerInfo mColorPointer;
    private PointerInfo mNormalPointer;
    private PointerInfo mTexCoordPointer;
    private PointerInfo mVertexPointer;
    boolean mColorArrayEnabled;
    boolean mNormalArrayEnabled;
    boolean mTextureCoordArrayEnabled;
    boolean mVertexArrayEnabled;
    StringBuilder mStringBuilder;

    private void $$robo$$android_opengl_GLLogWrapper$__constructor__(GL gl, Writer log, boolean logArgumentNames) {
        this.mColorPointer = new PointerInfo(this);
        this.mNormalPointer = new PointerInfo(this);
        this.mTexCoordPointer = new PointerInfo(this);
        this.mVertexPointer = new PointerInfo(this);
        this.mLog = log;
        this.mLogArgumentNames = logArgumentNames;
    }

    private final void $$robo$$android_opengl_GLLogWrapper$checkError() {
        int glError = this.mgl.glGetError();
        if (glError != 0) {
            String errorMessage = "glError: " + Integer.toString(glError);
            this.logLine(errorMessage);
        }
    }

    private final void $$robo$$android_opengl_GLLogWrapper$logLine(String message) {
        this.log(message + '\n');
    }

    private final void $$robo$$android_opengl_GLLogWrapper$log(String message) {
        try {
            this.mLog.write(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_opengl_GLLogWrapper$begin(String name) {
        this.log(name + '(');
        this.mArgCount = 0;
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, String value) {
        if (this.mArgCount++ > 0) {
            this.log(", ");
        }
        if (this.mLogArgumentNames) {
            this.log(name + "=");
        }
        this.log(value);
    }

    private final void $$robo$$android_opengl_GLLogWrapper$end() {
        this.log(");\n");
        this.flush();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$flush() {
        try {
            this.mLog.flush();
        }
        catch (IOException e) {
            this.mLog = null;
        }
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, boolean value) {
        this.arg(name, Boolean.toString(value));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, int value) {
        this.arg(name, Integer.toString(value));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, float value) {
        this.arg(name, Float.toString(value));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$returns(String result) {
        this.log(") returns " + result + ";\n");
        this.flush();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$returns(int result) {
        this.returns(Integer.toString(result));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, int n, int[] arr, int offset) {
        this.arg(name, this.toString(n, 0, arr, offset));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, int n, short[] arr, int offset) {
        this.arg(name, this.toString(n, arr, offset));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, int n, float[] arr, int offset) {
        this.arg(name, this.toString(n, arr, offset));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$formattedAppend(StringBuilder buf, int value, int format) {
        switch (format) {
            case 0: {
                buf.append(value);
                break;
            }
            case 1: {
                buf.append(Float.intBitsToFloat(value));
                break;
            }
            case 2: {
                buf.append((float)value / 65536.0f);
            }
        }
    }

    private final String $$robo$$android_opengl_GLLogWrapper$toString(int n, int format, int[] arr, int offset) {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        int arrLen = arr.length;
        for (int i = 0; i < n; ++i) {
            int index = offset + i;
            buf.append(" [" + index + "] = ");
            if (index < 0 || index >= arrLen) {
                buf.append("out of bounds");
            } else {
                this.formattedAppend(buf, arr[index], format);
            }
            buf.append('\n');
        }
        buf.append("}");
        return buf.toString();
    }

    private final String $$robo$$android_opengl_GLLogWrapper$toString(int n, short[] arr, int offset) {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        int arrLen = arr.length;
        for (int i = 0; i < n; ++i) {
            int index = offset + i;
            buf.append(" [" + index + "] = ");
            if (index < 0 || index >= arrLen) {
                buf.append("out of bounds");
            } else {
                buf.append(arr[index]);
            }
            buf.append('\n');
        }
        buf.append("}");
        return buf.toString();
    }

    private final String $$robo$$android_opengl_GLLogWrapper$toString(int n, float[] arr, int offset) {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        int arrLen = arr.length;
        for (int i = 0; i < n; ++i) {
            int index = offset + i;
            buf.append("[" + index + "] = ");
            if (index < 0 || index >= arrLen) {
                buf.append("out of bounds");
            } else {
                buf.append(arr[index]);
            }
            buf.append('\n');
        }
        buf.append("}");
        return buf.toString();
    }

    private final String $$robo$$android_opengl_GLLogWrapper$toString(int n, FloatBuffer buf) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (int i = 0; i < n; ++i) {
            builder.append(" [" + i + "] = " + buf.get(i) + '\n');
        }
        builder.append("}");
        return builder.toString();
    }

    private final String $$robo$$android_opengl_GLLogWrapper$toString(int n, int format, IntBuffer buf) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (int i = 0; i < n; ++i) {
            builder.append(" [" + i + "] = ");
            this.formattedAppend(builder, buf.get(i), format);
            builder.append('\n');
        }
        builder.append("}");
        return builder.toString();
    }

    private final String $$robo$$android_opengl_GLLogWrapper$toString(int n, ShortBuffer buf) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (int i = 0; i < n; ++i) {
            builder.append(" [" + i + "] = " + buf.get(i) + '\n');
        }
        builder.append("}");
        return builder.toString();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, int n, FloatBuffer buf) {
        this.arg(name, this.toString(n, buf));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, int n, IntBuffer buf) {
        this.arg(name, this.toString(n, 0, buf));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$arg(String name, int n, ShortBuffer buf) {
        this.arg(name, this.toString(n, buf));
    }

    private final void $$robo$$android_opengl_GLLogWrapper$argPointer(int size, int type, int stride, Buffer pointer) {
        this.arg("size", size);
        this.arg("type", this.getPointerTypeName(type));
        this.arg("stride", stride);
        this.arg("pointer", pointer.toString());
    }

    private static final String $$robo$$android_opengl_GLLogWrapper$getHex(int value) {
        return "0x" + Integer.toHexString(value);
    }

    private static final String $$robo$$android_opengl_GLLogWrapper$getErrorString(int error) {
        switch (error) {
            case 0: {
                return "GL_NO_ERROR";
            }
            case 1280: {
                return "GL_INVALID_ENUM";
            }
            case 1281: {
                return "GL_INVALID_VALUE";
            }
            case 1282: {
                return "GL_INVALID_OPERATION";
            }
            case 1283: {
                return "GL_STACK_OVERFLOW";
            }
            case 1284: {
                return "GL_STACK_UNDERFLOW";
            }
            case 1285: {
                return "GL_OUT_OF_MEMORY";
            }
        }
        return GLLogWrapper.getHex(error);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getClearBufferMask(int mask) {
        StringBuilder b = new StringBuilder();
        if ((mask & 0x100) != 0) {
            b.append("GL_DEPTH_BUFFER_BIT");
            mask &= 0xFFFFFEFF;
        }
        if ((mask & 0x400) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("GL_STENCIL_BUFFER_BIT");
            mask &= 0xFFFFFBFF;
        }
        if ((mask & 0x4000) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("GL_COLOR_BUFFER_BIT");
            mask &= 0xFFFFBFFF;
        }
        if (mask != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append(GLLogWrapper.getHex(mask));
        }
        return b.toString();
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getFactor(int factor) {
        switch (factor) {
            case 0: {
                return "GL_ZERO";
            }
            case 1: {
                return "GL_ONE";
            }
            case 768: {
                return "GL_SRC_COLOR";
            }
            case 769: {
                return "GL_ONE_MINUS_SRC_COLOR";
            }
            case 774: {
                return "GL_DST_COLOR";
            }
            case 775: {
                return "GL_ONE_MINUS_DST_COLOR";
            }
            case 770: {
                return "GL_SRC_ALPHA";
            }
            case 771: {
                return "GL_ONE_MINUS_SRC_ALPHA";
            }
            case 772: {
                return "GL_DST_ALPHA";
            }
            case 773: {
                return "GL_ONE_MINUS_DST_ALPHA";
            }
            case 776: {
                return "GL_SRC_ALPHA_SATURATE";
            }
        }
        return GLLogWrapper.getHex(factor);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getShadeModel(int model) {
        switch (model) {
            case 7424: {
                return "GL_FLAT";
            }
            case 7425: {
                return "GL_SMOOTH";
            }
        }
        return GLLogWrapper.getHex(model);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getTextureTarget(int target) {
        switch (target) {
            case 3553: {
                return "GL_TEXTURE_2D";
            }
        }
        return GLLogWrapper.getHex(target);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getTextureEnvTarget(int target) {
        switch (target) {
            case 8960: {
                return "GL_TEXTURE_ENV";
            }
        }
        return GLLogWrapper.getHex(target);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getTextureEnvPName(int pname) {
        switch (pname) {
            case 8704: {
                return "GL_TEXTURE_ENV_MODE";
            }
            case 8705: {
                return "GL_TEXTURE_ENV_COLOR";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private final int $$robo$$android_opengl_GLLogWrapper$getTextureEnvParamCount(int pname) {
        switch (pname) {
            case 8704: {
                return 1;
            }
            case 8705: {
                return 4;
            }
        }
        return 0;
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getTextureEnvParamName(float param) {
        int iparam = (int)param;
        if (param == (float)iparam) {
            switch (iparam) {
                case 7681: {
                    return "GL_REPLACE";
                }
                case 8448: {
                    return "GL_MODULATE";
                }
                case 8449: {
                    return "GL_DECAL";
                }
                case 3042: {
                    return "GL_BLEND";
                }
                case 260: {
                    return "GL_ADD";
                }
                case 34160: {
                    return "GL_COMBINE";
                }
            }
            return GLLogWrapper.getHex(iparam);
        }
        return Float.toString(param);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getMatrixMode(int matrixMode) {
        switch (matrixMode) {
            case 5888: {
                return "GL_MODELVIEW";
            }
            case 5889: {
                return "GL_PROJECTION";
            }
            case 5890: {
                return "GL_TEXTURE";
            }
        }
        return GLLogWrapper.getHex(matrixMode);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getClientState(int clientState) {
        switch (clientState) {
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
        }
        return GLLogWrapper.getHex(clientState);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getCap(int cap) {
        switch (cap) {
            case 2912: {
                return "GL_FOG";
            }
            case 2896: {
                return "GL_LIGHTING";
            }
            case 3553: {
                return "GL_TEXTURE_2D";
            }
            case 2884: {
                return "GL_CULL_FACE";
            }
            case 3008: {
                return "GL_ALPHA_TEST";
            }
            case 3042: {
                return "GL_BLEND";
            }
            case 3058: {
                return "GL_COLOR_LOGIC_OP";
            }
            case 3024: {
                return "GL_DITHER";
            }
            case 2960: {
                return "GL_STENCIL_TEST";
            }
            case 2929: {
                return "GL_DEPTH_TEST";
            }
            case 16384: {
                return "GL_LIGHT0";
            }
            case 16385: {
                return "GL_LIGHT1";
            }
            case 16386: {
                return "GL_LIGHT2";
            }
            case 16387: {
                return "GL_LIGHT3";
            }
            case 16388: {
                return "GL_LIGHT4";
            }
            case 16389: {
                return "GL_LIGHT5";
            }
            case 16390: {
                return "GL_LIGHT6";
            }
            case 16391: {
                return "GL_LIGHT7";
            }
            case 2832: {
                return "GL_POINT_SMOOTH";
            }
            case 2848: {
                return "GL_LINE_SMOOTH";
            }
            case 2903: {
                return "GL_COLOR_MATERIAL";
            }
            case 2977: {
                return "GL_NORMALIZE";
            }
            case 32826: {
                return "GL_RESCALE_NORMAL";
            }
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
            case 32925: {
                return "GL_MULTISAMPLE";
            }
            case 32926: {
                return "GL_SAMPLE_ALPHA_TO_COVERAGE";
            }
            case 32927: {
                return "GL_SAMPLE_ALPHA_TO_ONE";
            }
            case 32928: {
                return "GL_SAMPLE_COVERAGE";
            }
            case 3089: {
                return "GL_SCISSOR_TEST";
            }
        }
        return GLLogWrapper.getHex(cap);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getTexturePName(int pname) {
        switch (pname) {
            case 10240: {
                return "GL_TEXTURE_MAG_FILTER";
            }
            case 10241: {
                return "GL_TEXTURE_MIN_FILTER";
            }
            case 10242: {
                return "GL_TEXTURE_WRAP_S";
            }
            case 10243: {
                return "GL_TEXTURE_WRAP_T";
            }
            case 33169: {
                return "GL_GENERATE_MIPMAP";
            }
            case 35741: {
                return "GL_TEXTURE_CROP_RECT_OES";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getTextureParamName(float param) {
        int iparam = (int)param;
        if (param == (float)iparam) {
            switch (iparam) {
                case 33071: {
                    return "GL_CLAMP_TO_EDGE";
                }
                case 10497: {
                    return "GL_REPEAT";
                }
                case 9728: {
                    return "GL_NEAREST";
                }
                case 9729: {
                    return "GL_LINEAR";
                }
                case 9984: {
                    return "GL_NEAREST_MIPMAP_NEAREST";
                }
                case 9985: {
                    return "GL_LINEAR_MIPMAP_NEAREST";
                }
                case 9986: {
                    return "GL_NEAREST_MIPMAP_LINEAR";
                }
                case 9987: {
                    return "GL_LINEAR_MIPMAP_LINEAR";
                }
            }
            return GLLogWrapper.getHex(iparam);
        }
        return Float.toString(param);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getFogPName(int pname) {
        switch (pname) {
            case 2914: {
                return "GL_FOG_DENSITY";
            }
            case 2915: {
                return "GL_FOG_START";
            }
            case 2916: {
                return "GL_FOG_END";
            }
            case 2917: {
                return "GL_FOG_MODE";
            }
            case 2918: {
                return "GL_FOG_COLOR";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private final int $$robo$$android_opengl_GLLogWrapper$getFogParamCount(int pname) {
        switch (pname) {
            case 2914: {
                return 1;
            }
            case 2915: {
                return 1;
            }
            case 2916: {
                return 1;
            }
            case 2917: {
                return 1;
            }
            case 2918: {
                return 4;
            }
        }
        return 0;
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getBeginMode(int mode) {
        switch (mode) {
            case 0: {
                return "GL_POINTS";
            }
            case 1: {
                return "GL_LINES";
            }
            case 2: {
                return "GL_LINE_LOOP";
            }
            case 3: {
                return "GL_LINE_STRIP";
            }
            case 4: {
                return "GL_TRIANGLES";
            }
            case 5: {
                return "GL_TRIANGLE_STRIP";
            }
            case 6: {
                return "GL_TRIANGLE_FAN";
            }
        }
        return GLLogWrapper.getHex(mode);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getIndexType(int type) {
        switch (type) {
            case 5123: {
                return "GL_UNSIGNED_SHORT";
            }
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
        }
        return GLLogWrapper.getHex(type);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getIntegerStateName(int pname) {
        switch (pname) {
            case 3413: {
                return "GL_ALPHA_BITS";
            }
            case 33902: {
                return "GL_ALIASED_LINE_WIDTH_RANGE";
            }
            case 33901: {
                return "GL_ALIASED_POINT_SIZE_RANGE";
            }
            case 3412: {
                return "GL_BLUE_BITS";
            }
            case 34467: {
                return "GL_COMPRESSED_TEXTURE_FORMATS";
            }
            case 3414: {
                return "GL_DEPTH_BITS";
            }
            case 3411: {
                return "GL_GREEN_BITS";
            }
            case 33001: {
                return "GL_MAX_ELEMENTS_INDICES";
            }
            case 33000: {
                return "GL_MAX_ELEMENTS_VERTICES";
            }
            case 3377: {
                return "GL_MAX_LIGHTS";
            }
            case 3379: {
                return "GL_MAX_TEXTURE_SIZE";
            }
            case 3386: {
                return "GL_MAX_VIEWPORT_DIMS";
            }
            case 3382: {
                return "GL_MAX_MODELVIEW_STACK_DEPTH";
            }
            case 3384: {
                return "GL_MAX_PROJECTION_STACK_DEPTH";
            }
            case 3385: {
                return "GL_MAX_TEXTURE_STACK_DEPTH";
            }
            case 34018: {
                return "GL_MAX_TEXTURE_UNITS";
            }
            case 34466: {
                return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
            }
            case 3410: {
                return "GL_RED_BITS";
            }
            case 2850: {
                return "GL_SMOOTH_LINE_WIDTH_RANGE";
            }
            case 2834: {
                return "GL_SMOOTH_POINT_SIZE_RANGE";
            }
            case 3415: {
                return "GL_STENCIL_BITS";
            }
            case 3408: {
                return "GL_SUBPIXEL_BITS";
            }
            case 35213: {
                return "GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES";
            }
            case 35214: {
                return "GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES";
            }
            case 35215: {
                return "GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private final int $$robo$$android_opengl_GLLogWrapper$getIntegerStateSize(int pname) {
        switch (pname) {
            case 3413: {
                return 1;
            }
            case 33902: {
                return 2;
            }
            case 33901: {
                return 2;
            }
            case 3412: {
                return 1;
            }
            case 34467: {
                int[] buffer = new int[1];
                this.mgl.glGetIntegerv(34466, buffer, 0);
                return buffer[0];
            }
            case 3414: {
                return 1;
            }
            case 3411: {
                return 1;
            }
            case 33001: {
                return 1;
            }
            case 33000: {
                return 1;
            }
            case 3377: {
                return 1;
            }
            case 3379: {
                return 1;
            }
            case 3386: {
                return 2;
            }
            case 3382: {
                return 1;
            }
            case 3384: {
                return 1;
            }
            case 3385: {
                return 1;
            }
            case 34018: {
                return 1;
            }
            case 34466: {
                return 1;
            }
            case 3410: {
                return 1;
            }
            case 2850: {
                return 2;
            }
            case 2834: {
                return 2;
            }
            case 3415: {
                return 1;
            }
            case 3408: {
                return 1;
            }
            case 35213: 
            case 35214: 
            case 35215: {
                return 16;
            }
        }
        return 0;
    }

    private final int $$robo$$android_opengl_GLLogWrapper$getIntegerStateFormat(int pname) {
        switch (pname) {
            case 35213: 
            case 35214: 
            case 35215: {
                return 1;
            }
        }
        return 0;
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getHintTarget(int target) {
        switch (target) {
            case 3156: {
                return "GL_FOG_HINT";
            }
            case 3154: {
                return "GL_LINE_SMOOTH_HINT";
            }
            case 3152: {
                return "GL_PERSPECTIVE_CORRECTION_HINT";
            }
            case 3153: {
                return "GL_POINT_SMOOTH_HINT";
            }
            case 3155: {
                return "GL_POLYGON_SMOOTH_HINT";
            }
            case 33170: {
                return "GL_GENERATE_MIPMAP_HINT";
            }
        }
        return GLLogWrapper.getHex(target);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getHintMode(int mode) {
        switch (mode) {
            case 4353: {
                return "GL_FASTEST";
            }
            case 4354: {
                return "GL_NICEST";
            }
            case 4352: {
                return "GL_DONT_CARE";
            }
        }
        return GLLogWrapper.getHex(mode);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getFaceName(int face) {
        switch (face) {
            case 1032: {
                return "GL_FRONT_AND_BACK";
            }
        }
        return GLLogWrapper.getHex(face);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getMaterialPName(int pname) {
        switch (pname) {
            case 4608: {
                return "GL_AMBIENT";
            }
            case 4609: {
                return "GL_DIFFUSE";
            }
            case 4610: {
                return "GL_SPECULAR";
            }
            case 5632: {
                return "GL_EMISSION";
            }
            case 5633: {
                return "GL_SHININESS";
            }
            case 5634: {
                return "GL_AMBIENT_AND_DIFFUSE";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private final int $$robo$$android_opengl_GLLogWrapper$getMaterialParamCount(int pname) {
        switch (pname) {
            case 4608: {
                return 4;
            }
            case 4609: {
                return 4;
            }
            case 4610: {
                return 4;
            }
            case 5632: {
                return 4;
            }
            case 5633: {
                return 1;
            }
            case 5634: {
                return 4;
            }
        }
        return 0;
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getLightName(int light) {
        if (light >= 16384 && light <= 16391) {
            return "GL_LIGHT" + Integer.toString(light);
        }
        return GLLogWrapper.getHex(light);
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getLightPName(int pname) {
        switch (pname) {
            case 4608: {
                return "GL_AMBIENT";
            }
            case 4609: {
                return "GL_DIFFUSE";
            }
            case 4610: {
                return "GL_SPECULAR";
            }
            case 4611: {
                return "GL_POSITION";
            }
            case 4612: {
                return "GL_SPOT_DIRECTION";
            }
            case 4613: {
                return "GL_SPOT_EXPONENT";
            }
            case 4614: {
                return "GL_SPOT_CUTOFF";
            }
            case 4615: {
                return "GL_CONSTANT_ATTENUATION";
            }
            case 4616: {
                return "GL_LINEAR_ATTENUATION";
            }
            case 4617: {
                return "GL_QUADRATIC_ATTENUATION";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private final int $$robo$$android_opengl_GLLogWrapper$getLightParamCount(int pname) {
        switch (pname) {
            case 4608: {
                return 4;
            }
            case 4609: {
                return 4;
            }
            case 4610: {
                return 4;
            }
            case 4611: {
                return 4;
            }
            case 4612: {
                return 3;
            }
            case 4613: {
                return 1;
            }
            case 4614: {
                return 1;
            }
            case 4615: {
                return 1;
            }
            case 4616: {
                return 1;
            }
            case 4617: {
                return 1;
            }
        }
        return 0;
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getLightModelPName(int pname) {
        switch (pname) {
            case 2899: {
                return "GL_LIGHT_MODEL_AMBIENT";
            }
            case 2898: {
                return "GL_LIGHT_MODEL_TWO_SIDE";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private final int $$robo$$android_opengl_GLLogWrapper$getLightModelParamCount(int pname) {
        switch (pname) {
            case 2899: {
                return 4;
            }
            case 2898: {
                return 1;
            }
        }
        return 0;
    }

    private final String $$robo$$android_opengl_GLLogWrapper$getPointerTypeName(int type) {
        switch (type) {
            case 5120: {
                return "GL_BYTE";
            }
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
            case 5122: {
                return "GL_SHORT";
            }
            case 5132: {
                return "GL_FIXED";
            }
            case 5126: {
                return "GL_FLOAT";
            }
        }
        return GLLogWrapper.getHex(type);
    }

    private final ByteBuffer $$robo$$android_opengl_GLLogWrapper$toByteBuffer(int byteCount, Buffer input) {
        boolean convertWholeBuffer;
        ByteBuffer result = null;
        boolean bl = convertWholeBuffer = byteCount < 0;
        if (input instanceof ByteBuffer) {
            ByteBuffer input2 = (ByteBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = input2.limit() - position;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            for (int i = 0; i < byteCount; ++i) {
                result.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof CharBuffer) {
            CharBuffer input2 = (CharBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 2;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            CharBuffer result2 = result.asCharBuffer();
            for (int i = 0; i < byteCount / 2; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof ShortBuffer) {
            ShortBuffer input2 = (ShortBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 2;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            ShortBuffer result2 = result.asShortBuffer();
            for (int i = 0; i < byteCount / 2; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof IntBuffer) {
            IntBuffer input2 = (IntBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 4;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            IntBuffer result2 = result.asIntBuffer();
            for (int i = 0; i < byteCount / 4; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof FloatBuffer) {
            FloatBuffer input2 = (FloatBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 4;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            FloatBuffer result2 = result.asFloatBuffer();
            for (int i = 0; i < byteCount / 4; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof DoubleBuffer) {
            DoubleBuffer input2 = (DoubleBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 8;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            DoubleBuffer result2 = result.asDoubleBuffer();
            for (int i = 0; i < byteCount / 8; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof LongBuffer) {
            LongBuffer input2 = (LongBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 8;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            LongBuffer result2 = result.asLongBuffer();
            for (int i = 0; i < byteCount / 8; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else {
            throw new RuntimeException("Unimplemented Buffer subclass.");
        }
        result.rewind();
        result.order(ByteOrder.nativeOrder());
        return result;
    }

    private final char[] $$robo$$android_opengl_GLLogWrapper$toCharIndices(int count, int type, Buffer indices) {
        char[] result = new char[count];
        switch (type) {
            case 5121: {
                ByteBuffer byteBuffer = this.toByteBuffer(count, indices);
                byte[] array2 = byteBuffer.array();
                int offset = byteBuffer.arrayOffset();
                for (int i = 0; i < count; ++i) {
                    result[i] = (char)(0xFF & array2[offset + i]);
                }
                break;
            }
            case 5123: {
                CharBuffer charBuffer;
                if (indices instanceof CharBuffer) {
                    charBuffer = (CharBuffer)indices;
                } else {
                    ByteBuffer byteBuffer = this.toByteBuffer(count * 2, indices);
                    charBuffer = byteBuffer.asCharBuffer();
                }
                int oldPosition = charBuffer.position();
                charBuffer.position(0);
                charBuffer.get(result);
                charBuffer.position(oldPosition);
                break;
            }
        }
        return result;
    }

    private final void $$robo$$android_opengl_GLLogWrapper$doArrayElement(StringBuilder builder, boolean enabled, String name, PointerInfo pointer, int index) {
        if (!enabled) {
            return;
        }
        builder.append(" ");
        builder.append(name + ":{");
        if (pointer == null || pointer.mTempByteBuffer == null) {
            builder.append("undefined }");
            return;
        }
        if (pointer.mStride < 0) {
            builder.append("invalid stride");
            return;
        }
        int stride = pointer.getStride();
        ByteBuffer byteBuffer = pointer.mTempByteBuffer;
        int size = pointer.mSize;
        int type = pointer.mType;
        int sizeofType = pointer.sizeof(type);
        int byteOffset = stride * index;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            switch (type) {
                case 5120: {
                    byte d = byteBuffer.get(byteOffset);
                    builder.append(Integer.toString(d));
                    break;
                }
                case 5121: {
                    byte d = byteBuffer.get(byteOffset);
                    builder.append(Integer.toString(0xFF & d));
                    break;
                }
                case 5122: {
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    short d = shortBuffer.get(byteOffset / 2);
                    builder.append(Integer.toString(d));
                    break;
                }
                case 5132: {
                    IntBuffer intBuffer = byteBuffer.asIntBuffer();
                    int d = intBuffer.get(byteOffset / 4);
                    builder.append(Integer.toString(d));
                    break;
                }
                case 5126: {
                    FloatBuffer intBuffer = byteBuffer.asFloatBuffer();
                    float d = intBuffer.get(byteOffset / 4);
                    builder.append(Float.toString(d));
                    break;
                }
                default: {
                    builder.append("?");
                }
            }
            byteOffset += sizeofType;
        }
        builder.append("}");
    }

    private final void $$robo$$android_opengl_GLLogWrapper$doElement(StringBuilder builder, int ordinal, int vertexIndex) {
        builder.append(" [" + ordinal + " : " + vertexIndex + "] =");
        this.doArrayElement(builder, this.mVertexArrayEnabled, "v", this.mVertexPointer, vertexIndex);
        this.doArrayElement(builder, this.mNormalArrayEnabled, "n", this.mNormalPointer, vertexIndex);
        this.doArrayElement(builder, this.mColorArrayEnabled, "c", this.mColorPointer, vertexIndex);
        this.doArrayElement(builder, this.mTextureCoordArrayEnabled, "t", this.mTexCoordPointer, vertexIndex);
        builder.append("\n");
    }

    private final void $$robo$$android_opengl_GLLogWrapper$bindArrays() {
        if (this.mColorArrayEnabled) {
            this.mColorPointer.bindByteBuffer();
        }
        if (this.mNormalArrayEnabled) {
            this.mNormalPointer.bindByteBuffer();
        }
        if (this.mTextureCoordArrayEnabled) {
            this.mTexCoordPointer.bindByteBuffer();
        }
        if (this.mVertexArrayEnabled) {
            this.mVertexPointer.bindByteBuffer();
        }
    }

    private final void $$robo$$android_opengl_GLLogWrapper$unbindArrays() {
        if (this.mColorArrayEnabled) {
            this.mColorPointer.unbindByteBuffer();
        }
        if (this.mNormalArrayEnabled) {
            this.mNormalPointer.unbindByteBuffer();
        }
        if (this.mTextureCoordArrayEnabled) {
            this.mTexCoordPointer.unbindByteBuffer();
        }
        if (this.mVertexArrayEnabled) {
            this.mVertexPointer.unbindByteBuffer();
        }
    }

    private final void $$robo$$android_opengl_GLLogWrapper$startLogIndices() {
        this.mStringBuilder = new StringBuilder();
        this.mStringBuilder.append("\n");
        this.bindArrays();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$endLogIndices() {
        this.log(this.mStringBuilder.toString());
        this.unbindArrays();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glActiveTexture(int texture) {
        this.begin("glActiveTexture");
        this.arg("texture", texture);
        this.end();
        this.mgl.glActiveTexture(texture);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glAlphaFunc(int func, float ref) {
        this.begin("glAlphaFunc");
        this.arg("func", func);
        this.arg("ref", ref);
        this.end();
        this.mgl.glAlphaFunc(func, ref);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glAlphaFuncx(int func, int ref) {
        this.begin("glAlphaFuncx");
        this.arg("func", func);
        this.arg("ref", ref);
        this.end();
        this.mgl.glAlphaFuncx(func, ref);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBindTexture(int target, int texture) {
        this.begin("glBindTexture");
        this.arg("target", this.getTextureTarget(target));
        this.arg("texture", texture);
        this.end();
        this.mgl.glBindTexture(target, texture);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBlendFunc(int sfactor, int dfactor) {
        this.begin("glBlendFunc");
        this.arg("sfactor", this.getFactor(sfactor));
        this.arg("dfactor", this.getFactor(dfactor));
        this.end();
        this.mgl.glBlendFunc(sfactor, dfactor);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClear(int mask) {
        this.begin("glClear");
        this.arg("mask", this.getClearBufferMask(mask));
        this.end();
        this.mgl.glClear(mask);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClearColor(float red, float green, float blue, float alpha) {
        this.begin("glClearColor");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glClearColor(red, green, blue, alpha);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClearColorx(int red, int green, int blue, int alpha) {
        this.begin("glClearColor");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glClearColorx(red, green, blue, alpha);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClearDepthf(float depth) {
        this.begin("glClearDepthf");
        this.arg("depth", depth);
        this.end();
        this.mgl.glClearDepthf(depth);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClearDepthx(int depth) {
        this.begin("glClearDepthx");
        this.arg("depth", depth);
        this.end();
        this.mgl.glClearDepthx(depth);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClearStencil(int s) {
        this.begin("glClearStencil");
        this.arg("s", s);
        this.end();
        this.mgl.glClearStencil(s);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClientActiveTexture(int texture) {
        this.begin("glClientActiveTexture");
        this.arg("texture", texture);
        this.end();
        this.mgl.glClientActiveTexture(texture);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glColor4f(float red, float green, float blue, float alpha) {
        this.begin("glColor4f");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glColor4f(red, green, blue, alpha);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glColor4x(int red, int green, int blue, int alpha) {
        this.begin("glColor4x");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glColor4x(red, green, blue, alpha);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        this.begin("glColorMask");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glColorMask(red, green, blue, alpha);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glColorPointer(int size, int type, int stride, Buffer pointer) {
        this.begin("glColorPointer");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mColorPointer = new PointerInfo(this, size, type, stride, pointer);
        this.mgl.glColorPointer(size, type, stride, pointer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        this.begin("glCompressedTexImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("internalformat", internalformat);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("border", border);
        this.arg("imageSize", imageSize);
        this.arg("data", data.toString());
        this.end();
        this.mgl.glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        this.begin("glCompressedTexSubImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("xoffset", xoffset);
        this.arg("yoffset", yoffset);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("format", format);
        this.arg("imageSize", imageSize);
        this.arg("data", data.toString());
        this.end();
        this.mgl.glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        this.begin("glCopyTexImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("internalformat", internalformat);
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("border", border);
        this.end();
        this.mgl.glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        this.begin("glCopyTexSubImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("xoffset", xoffset);
        this.arg("yoffset", yoffset);
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl.glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glCullFace(int mode) {
        this.begin("glCullFace");
        this.arg("mode", mode);
        this.end();
        this.mgl.glCullFace(mode);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDeleteTextures(int n, int[] textures, int offset) {
        this.begin("glDeleteTextures");
        this.arg("n", n);
        this.arg("textures", n, textures, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glDeleteTextures(n, textures, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDeleteTextures(int n, IntBuffer textures) {
        this.begin("glDeleteTextures");
        this.arg("n", n);
        this.arg("textures", n, textures);
        this.end();
        this.mgl.glDeleteTextures(n, textures);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDepthFunc(int func) {
        this.begin("glDepthFunc");
        this.arg("func", func);
        this.end();
        this.mgl.glDepthFunc(func);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDepthMask(boolean flag) {
        this.begin("glDepthMask");
        this.arg("flag", flag);
        this.end();
        this.mgl.glDepthMask(flag);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDepthRangef(float near, float far) {
        this.begin("glDepthRangef");
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glDepthRangef(near, far);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDepthRangex(int near, int far) {
        this.begin("glDepthRangex");
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glDepthRangex(near, far);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDisable(int cap) {
        this.begin("glDisable");
        this.arg("cap", this.getCap(cap));
        this.end();
        this.mgl.glDisable(cap);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDisableClientState(int array2) {
        this.begin("glDisableClientState");
        this.arg("array", this.getClientState(array2));
        this.end();
        switch (array2) {
            case 32886: {
                this.mColorArrayEnabled = false;
                break;
            }
            case 32885: {
                this.mNormalArrayEnabled = false;
                break;
            }
            case 32888: {
                this.mTextureCoordArrayEnabled = false;
                break;
            }
            case 32884: {
                this.mVertexArrayEnabled = false;
            }
        }
        this.mgl.glDisableClientState(array2);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawArrays(int mode, int first, int count) {
        this.begin("glDrawArrays");
        this.arg("mode", mode);
        this.arg("first", first);
        this.arg("count", count);
        this.startLogIndices();
        for (int i = 0; i < count; ++i) {
            this.doElement(this.mStringBuilder, i, first + i);
        }
        this.endLogIndices();
        this.end();
        this.mgl.glDrawArrays(mode, first, count);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawElements(int mode, int count, int type, Buffer indices) {
        this.begin("glDrawElements");
        this.arg("mode", this.getBeginMode(mode));
        this.arg("count", count);
        this.arg("type", this.getIndexType(type));
        char[] indexArray = this.toCharIndices(count, type, indices);
        int indexArrayLength = indexArray.length;
        this.startLogIndices();
        for (int i = 0; i < indexArrayLength; ++i) {
            this.doElement(this.mStringBuilder, i, indexArray[i]);
        }
        this.endLogIndices();
        this.end();
        this.mgl.glDrawElements(mode, count, type, indices);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glEnable(int cap) {
        this.begin("glEnable");
        this.arg("cap", this.getCap(cap));
        this.end();
        this.mgl.glEnable(cap);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glEnableClientState(int array2) {
        this.begin("glEnableClientState");
        this.arg("array", this.getClientState(array2));
        this.end();
        switch (array2) {
            case 32886: {
                this.mColorArrayEnabled = true;
                break;
            }
            case 32885: {
                this.mNormalArrayEnabled = true;
                break;
            }
            case 32888: {
                this.mTextureCoordArrayEnabled = true;
                break;
            }
            case 32884: {
                this.mVertexArrayEnabled = true;
            }
        }
        this.mgl.glEnableClientState(array2);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFinish() {
        this.begin("glFinish");
        this.end();
        this.mgl.glFinish();
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFlush() {
        this.begin("glFlush");
        this.end();
        this.mgl.glFlush();
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFogf(int pname, float param) {
        this.begin("glFogf");
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl.glFogf(pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFogfv(int pname, float[] params, int offset) {
        this.begin("glFogfv");
        this.arg("pname", this.getFogPName(pname));
        this.arg("params", this.getFogParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glFogfv(pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFogfv(int pname, FloatBuffer params) {
        this.begin("glFogfv");
        this.arg("pname", this.getFogPName(pname));
        this.arg("params", this.getFogParamCount(pname), params);
        this.end();
        this.mgl.glFogfv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFogx(int pname, int param) {
        this.begin("glFogx");
        this.arg("pname", this.getFogPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glFogx(pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFogxv(int pname, int[] params, int offset) {
        this.begin("glFogxv");
        this.arg("pname", this.getFogPName(pname));
        this.arg("params", this.getFogParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glFogxv(pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFogxv(int pname, IntBuffer params) {
        this.begin("glFogxv");
        this.arg("pname", this.getFogPName(pname));
        this.arg("params", this.getFogParamCount(pname), params);
        this.end();
        this.mgl.glFogxv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFrontFace(int mode) {
        this.begin("glFrontFace");
        this.arg("mode", mode);
        this.end();
        this.mgl.glFrontFace(mode);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFrustumf(float left, float right, float bottom, float top, float near, float far) {
        this.begin("glFrustumf");
        this.arg("left", left);
        this.arg("right", right);
        this.arg("bottom", bottom);
        this.arg("top", top);
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glFrustumf(left, right, bottom, top, near, far);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFrustumx(int left, int right, int bottom, int top, int near, int far) {
        this.begin("glFrustumx");
        this.arg("left", left);
        this.arg("right", right);
        this.arg("bottom", bottom);
        this.arg("top", top);
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glFrustumx(left, right, bottom, top, near, far);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGenTextures(int n, int[] textures, int offset) {
        this.begin("glGenTextures");
        this.arg("n", n);
        this.arg("textures", Arrays.toString(textures));
        this.arg("offset", offset);
        this.mgl.glGenTextures(n, textures, offset);
        this.returns(this.toString(n, 0, textures, offset));
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGenTextures(int n, IntBuffer textures) {
        this.begin("glGenTextures");
        this.arg("n", n);
        this.arg("textures", textures.toString());
        this.mgl.glGenTextures(n, textures);
        this.returns(this.toString(n, 0, textures));
        this.checkError();
    }

    private final int $$robo$$android_opengl_GLLogWrapper$glGetError() {
        this.begin("glGetError");
        int result = this.mgl.glGetError();
        this.returns(result);
        return result;
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetIntegerv(int pname, int[] params, int offset) {
        this.begin("glGetIntegerv");
        this.arg("pname", this.getIntegerStateName(pname));
        this.arg("params", Arrays.toString(params));
        this.arg("offset", offset);
        this.mgl.glGetIntegerv(pname, params, offset);
        this.returns(this.toString(this.getIntegerStateSize(pname), this.getIntegerStateFormat(pname), params, offset));
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetIntegerv(int pname, IntBuffer params) {
        this.begin("glGetIntegerv");
        this.arg("pname", this.getIntegerStateName(pname));
        this.arg("params", params.toString());
        this.mgl.glGetIntegerv(pname, params);
        this.returns(this.toString(this.getIntegerStateSize(pname), this.getIntegerStateFormat(pname), params));
        this.checkError();
    }

    private final String $$robo$$android_opengl_GLLogWrapper$glGetString(int name) {
        this.begin("glGetString");
        this.arg("name", name);
        String result = this.mgl.glGetString(name);
        this.returns(result);
        this.checkError();
        return result;
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glHint(int target, int mode) {
        this.begin("glHint");
        this.arg("target", this.getHintTarget(target));
        this.arg("mode", this.getHintMode(mode));
        this.end();
        this.mgl.glHint(target, mode);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightModelf(int pname, float param) {
        this.begin("glLightModelf");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glLightModelf(pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightModelfv(int pname, float[] params, int offset) {
        this.begin("glLightModelfv");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("params", this.getLightModelParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLightModelfv(pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightModelfv(int pname, FloatBuffer params) {
        this.begin("glLightModelfv");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("params", this.getLightModelParamCount(pname), params);
        this.end();
        this.mgl.glLightModelfv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightModelx(int pname, int param) {
        this.begin("glLightModelx");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glLightModelx(pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightModelxv(int pname, int[] params, int offset) {
        this.begin("glLightModelxv");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("params", this.getLightModelParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLightModelxv(pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightModelxv(int pname, IntBuffer params) {
        this.begin("glLightModelfv");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("params", this.getLightModelParamCount(pname), params);
        this.end();
        this.mgl.glLightModelxv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightf(int light, int pname, float param) {
        this.begin("glLightf");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glLightf(light, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightfv(int light, int pname, float[] params, int offset) {
        this.begin("glLightfv");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("params", this.getLightParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLightfv(light, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightfv(int light, int pname, FloatBuffer params) {
        this.begin("glLightfv");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("params", this.getLightParamCount(pname), params);
        this.end();
        this.mgl.glLightfv(light, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightx(int light, int pname, int param) {
        this.begin("glLightx");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glLightx(light, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightxv(int light, int pname, int[] params, int offset) {
        this.begin("glLightxv");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("params", this.getLightParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLightxv(light, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLightxv(int light, int pname, IntBuffer params) {
        this.begin("glLightxv");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("params", this.getLightParamCount(pname), params);
        this.end();
        this.mgl.glLightxv(light, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLineWidth(float width) {
        this.begin("glLineWidth");
        this.arg("width", width);
        this.end();
        this.mgl.glLineWidth(width);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLineWidthx(int width) {
        this.begin("glLineWidthx");
        this.arg("width", width);
        this.end();
        this.mgl.glLineWidthx(width);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLoadIdentity() {
        this.begin("glLoadIdentity");
        this.end();
        this.mgl.glLoadIdentity();
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLoadMatrixf(float[] m, int offset) {
        this.begin("glLoadMatrixf");
        this.arg("m", 16, m, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLoadMatrixf(m, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLoadMatrixf(FloatBuffer m) {
        this.begin("glLoadMatrixf");
        this.arg("m", 16, m);
        this.end();
        this.mgl.glLoadMatrixf(m);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLoadMatrixx(int[] m, int offset) {
        this.begin("glLoadMatrixx");
        this.arg("m", 16, m, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLoadMatrixx(m, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLoadMatrixx(IntBuffer m) {
        this.begin("glLoadMatrixx");
        this.arg("m", 16, m);
        this.end();
        this.mgl.glLoadMatrixx(m);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLogicOp(int opcode) {
        this.begin("glLogicOp");
        this.arg("opcode", opcode);
        this.end();
        this.mgl.glLogicOp(opcode);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMaterialf(int face, int pname, float param) {
        this.begin("glMaterialf");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glMaterialf(face, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMaterialfv(int face, int pname, float[] params, int offset) {
        this.begin("glMaterialfv");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("params", this.getMaterialParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glMaterialfv(face, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMaterialfv(int face, int pname, FloatBuffer params) {
        this.begin("glMaterialfv");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("params", this.getMaterialParamCount(pname), params);
        this.end();
        this.mgl.glMaterialfv(face, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMaterialx(int face, int pname, int param) {
        this.begin("glMaterialx");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glMaterialx(face, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMaterialxv(int face, int pname, int[] params, int offset) {
        this.begin("glMaterialxv");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("params", this.getMaterialParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glMaterialxv(face, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMaterialxv(int face, int pname, IntBuffer params) {
        this.begin("glMaterialxv");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("params", this.getMaterialParamCount(pname), params);
        this.end();
        this.mgl.glMaterialxv(face, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMatrixMode(int mode) {
        this.begin("glMatrixMode");
        this.arg("mode", this.getMatrixMode(mode));
        this.end();
        this.mgl.glMatrixMode(mode);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMultMatrixf(float[] m, int offset) {
        this.begin("glMultMatrixf");
        this.arg("m", 16, m, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glMultMatrixf(m, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMultMatrixf(FloatBuffer m) {
        this.begin("glMultMatrixf");
        this.arg("m", 16, m);
        this.end();
        this.mgl.glMultMatrixf(m);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMultMatrixx(int[] m, int offset) {
        this.begin("glMultMatrixx");
        this.arg("m", 16, m, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glMultMatrixx(m, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMultMatrixx(IntBuffer m) {
        this.begin("glMultMatrixx");
        this.arg("m", 16, m);
        this.end();
        this.mgl.glMultMatrixx(m);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMultiTexCoord4f(int target, float s, float t, float r, float q) {
        this.begin("glMultiTexCoord4f");
        this.arg("target", target);
        this.arg("s", s);
        this.arg("t", t);
        this.arg("r", r);
        this.arg("q", q);
        this.end();
        this.mgl.glMultiTexCoord4f(target, s, t, r, q);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMultiTexCoord4x(int target, int s, int t, int r, int q) {
        this.begin("glMultiTexCoord4x");
        this.arg("target", target);
        this.arg("s", s);
        this.arg("t", t);
        this.arg("r", r);
        this.arg("q", q);
        this.end();
        this.mgl.glMultiTexCoord4x(target, s, t, r, q);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glNormal3f(float nx, float ny, float nz) {
        this.begin("glNormal3f");
        this.arg("nx", nx);
        this.arg("ny", ny);
        this.arg("nz", nz);
        this.end();
        this.mgl.glNormal3f(nx, ny, nz);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glNormal3x(int nx, int ny, int nz) {
        this.begin("glNormal3x");
        this.arg("nx", nx);
        this.arg("ny", ny);
        this.arg("nz", nz);
        this.end();
        this.mgl.glNormal3x(nx, ny, nz);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glNormalPointer(int type, int stride, Buffer pointer) {
        this.begin("glNormalPointer");
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("pointer", pointer.toString());
        this.end();
        this.mNormalPointer = new PointerInfo(this, 3, type, stride, pointer);
        this.mgl.glNormalPointer(type, stride, pointer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glOrthof(float left, float right, float bottom, float top, float near, float far) {
        this.begin("glOrthof");
        this.arg("left", left);
        this.arg("right", right);
        this.arg("bottom", bottom);
        this.arg("top", top);
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glOrthof(left, right, bottom, top, near, far);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glOrthox(int left, int right, int bottom, int top, int near, int far) {
        this.begin("glOrthox");
        this.arg("left", left);
        this.arg("right", right);
        this.arg("bottom", bottom);
        this.arg("top", top);
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glOrthox(left, right, bottom, top, near, far);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPixelStorei(int pname, int param) {
        this.begin("glPixelStorei");
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl.glPixelStorei(pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPointSize(float size) {
        this.begin("glPointSize");
        this.arg("size", size);
        this.end();
        this.mgl.glPointSize(size);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPointSizex(int size) {
        this.begin("glPointSizex");
        this.arg("size", size);
        this.end();
        this.mgl.glPointSizex(size);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPolygonOffset(float factor, float units) {
        this.begin("glPolygonOffset");
        this.arg("factor", factor);
        this.arg("units", units);
        this.end();
        this.mgl.glPolygonOffset(factor, units);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPolygonOffsetx(int factor, int units) {
        this.begin("glPolygonOffsetx");
        this.arg("factor", factor);
        this.arg("units", units);
        this.end();
        this.mgl.glPolygonOffsetx(factor, units);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPopMatrix() {
        this.begin("glPopMatrix");
        this.end();
        this.mgl.glPopMatrix();
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPushMatrix() {
        this.begin("glPushMatrix");
        this.end();
        this.mgl.glPushMatrix();
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        this.begin("glReadPixels");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("format", format);
        this.arg("type", type);
        this.arg("pixels", pixels.toString());
        this.end();
        this.mgl.glReadPixels(x, y, width, height, format, type, pixels);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glRotatef(float angle, float x, float y, float z) {
        this.begin("glRotatef");
        this.arg("angle", angle);
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glRotatef(angle, x, y, z);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glRotatex(int angle, int x, int y, int z) {
        this.begin("glRotatex");
        this.arg("angle", angle);
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glRotatex(angle, x, y, z);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glSampleCoverage(float value, boolean invert) {
        this.begin("glSampleCoveragex");
        this.arg("value", value);
        this.arg("invert", invert);
        this.end();
        this.mgl.glSampleCoverage(value, invert);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glSampleCoveragex(int value, boolean invert) {
        this.begin("glSampleCoveragex");
        this.arg("value", value);
        this.arg("invert", invert);
        this.end();
        this.mgl.glSampleCoveragex(value, invert);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glScalef(float x, float y, float z) {
        this.begin("glScalef");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glScalef(x, y, z);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glScalex(int x, int y, int z) {
        this.begin("glScalex");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glScalex(x, y, z);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glScissor(int x, int y, int width, int height) {
        this.begin("glScissor");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl.glScissor(x, y, width, height);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glShadeModel(int mode) {
        this.begin("glShadeModel");
        this.arg("mode", this.getShadeModel(mode));
        this.end();
        this.mgl.glShadeModel(mode);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glStencilFunc(int func, int ref, int mask) {
        this.begin("glStencilFunc");
        this.arg("func", func);
        this.arg("ref", ref);
        this.arg("mask", mask);
        this.end();
        this.mgl.glStencilFunc(func, ref, mask);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glStencilMask(int mask) {
        this.begin("glStencilMask");
        this.arg("mask", mask);
        this.end();
        this.mgl.glStencilMask(mask);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glStencilOp(int fail, int zfail, int zpass) {
        this.begin("glStencilOp");
        this.arg("fail", fail);
        this.arg("zfail", zfail);
        this.arg("zpass", zpass);
        this.end();
        this.mgl.glStencilOp(fail, zfail, zpass);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexCoordPointer(int size, int type, int stride, Buffer pointer) {
        this.begin("glTexCoordPointer");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mTexCoordPointer = new PointerInfo(this, size, type, stride, pointer);
        this.mgl.glTexCoordPointer(size, type, stride, pointer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexEnvf(int target, int pname, float param) {
        this.begin("glTexEnvf");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("param", this.getTextureEnvParamName(param));
        this.end();
        this.mgl.glTexEnvf(target, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexEnvfv(int target, int pname, float[] params, int offset) {
        this.begin("glTexEnvfv");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("params", this.getTextureEnvParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glTexEnvfv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexEnvfv(int target, int pname, FloatBuffer params) {
        this.begin("glTexEnvfv");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("params", this.getTextureEnvParamCount(pname), params);
        this.end();
        this.mgl.glTexEnvfv(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexEnvx(int target, int pname, int param) {
        this.begin("glTexEnvx");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glTexEnvx(target, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexEnvxv(int target, int pname, int[] params, int offset) {
        this.begin("glTexEnvxv");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("params", this.getTextureEnvParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glTexEnvxv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexEnvxv(int target, int pname, IntBuffer params) {
        this.begin("glTexEnvxv");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("params", this.getTextureEnvParamCount(pname), params);
        this.end();
        this.mgl.glTexEnvxv(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        this.begin("glTexImage2D");
        this.arg("target", target);
        this.arg("level", level);
        this.arg("internalformat", internalformat);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("border", border);
        this.arg("format", format);
        this.arg("type", type);
        this.arg("pixels", pixels.toString());
        this.end();
        this.mgl.glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexParameterf(int target, int pname, float param) {
        this.begin("glTexParameterf");
        this.arg("target", this.getTextureTarget(target));
        this.arg("pname", this.getTexturePName(pname));
        this.arg("param", this.getTextureParamName(param));
        this.end();
        this.mgl.glTexParameterf(target, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexParameterx(int target, int pname, int param) {
        this.begin("glTexParameterx");
        this.arg("target", this.getTextureTarget(target));
        this.arg("pname", this.getTexturePName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glTexParameterx(target, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexParameteriv(int target, int pname, int[] params, int offset) {
        this.begin("glTexParameteriv");
        this.arg("target", this.getTextureTarget(target));
        this.arg("pname", this.getTexturePName(pname));
        this.arg("params", 4, params, offset);
        this.end();
        this.mgl11.glTexParameteriv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexParameteriv(int target, int pname, IntBuffer params) {
        this.begin("glTexParameteriv");
        this.arg("target", this.getTextureTarget(target));
        this.arg("pname", this.getTexturePName(pname));
        this.arg("params", 4, params);
        this.end();
        this.mgl11.glTexParameteriv(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        this.begin("glTexSubImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("xoffset", xoffset);
        this.arg("yoffset", yoffset);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("format", format);
        this.arg("type", type);
        this.arg("pixels", pixels.toString());
        this.end();
        this.mgl.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTranslatef(float x, float y, float z) {
        this.begin("glTranslatef");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glTranslatef(x, y, z);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTranslatex(int x, int y, int z) {
        this.begin("glTranslatex");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glTranslatex(x, y, z);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glVertexPointer(int size, int type, int stride, Buffer pointer) {
        this.begin("glVertexPointer");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mVertexPointer = new PointerInfo(this, size, type, stride, pointer);
        this.mgl.glVertexPointer(size, type, stride, pointer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glViewport(int x, int y, int width, int height) {
        this.begin("glViewport");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl.glViewport(x, y, width, height);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClipPlanef(int plane, float[] equation, int offset) {
        this.begin("glClipPlanef");
        this.arg("plane", plane);
        this.arg("equation", 4, equation, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glClipPlanef(plane, equation, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClipPlanef(int plane, FloatBuffer equation) {
        this.begin("glClipPlanef");
        this.arg("plane", plane);
        this.arg("equation", 4, equation);
        this.end();
        this.mgl11.glClipPlanef(plane, equation);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClipPlanex(int plane, int[] equation, int offset) {
        this.begin("glClipPlanex");
        this.arg("plane", plane);
        this.arg("equation", 4, equation, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glClipPlanex(plane, equation, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glClipPlanex(int plane, IntBuffer equation) {
        this.begin("glClipPlanef");
        this.arg("plane", plane);
        this.arg("equation", 4, equation);
        this.end();
        this.mgl11.glClipPlanex(plane, equation);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexfOES(float x, float y, float z, float width, float height) {
        this.begin("glDrawTexfOES");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl11Ext.glDrawTexfOES(x, y, z, width, height);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexfvOES(float[] coords, int offset) {
        this.begin("glDrawTexfvOES");
        this.arg("coords", 5, coords, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glDrawTexfvOES(coords, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexfvOES(FloatBuffer coords) {
        this.begin("glDrawTexfvOES");
        this.arg("coords", 5, coords);
        this.end();
        this.mgl11Ext.glDrawTexfvOES(coords);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexiOES(int x, int y, int z, int width, int height) {
        this.begin("glDrawTexiOES");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl11Ext.glDrawTexiOES(x, y, z, width, height);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexivOES(int[] coords, int offset) {
        this.begin("glDrawTexivOES");
        this.arg("coords", 5, coords, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glDrawTexivOES(coords, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexivOES(IntBuffer coords) {
        this.begin("glDrawTexivOES");
        this.arg("coords", 5, coords);
        this.end();
        this.mgl11Ext.glDrawTexivOES(coords);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexsOES(short x, short y, short z, short width, short height) {
        this.begin("glDrawTexsOES");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl11Ext.glDrawTexsOES(x, y, z, width, height);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexsvOES(short[] coords, int offset) {
        this.begin("glDrawTexsvOES");
        this.arg("coords", 5, coords, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glDrawTexsvOES(coords, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexsvOES(ShortBuffer coords) {
        this.begin("glDrawTexsvOES");
        this.arg("coords", 5, coords);
        this.end();
        this.mgl11Ext.glDrawTexsvOES(coords);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexxOES(int x, int y, int z, int width, int height) {
        this.begin("glDrawTexxOES");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl11Ext.glDrawTexxOES(x, y, z, width, height);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexxvOES(int[] coords, int offset) {
        this.begin("glDrawTexxvOES");
        this.arg("coords", 5, coords, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glDrawTexxvOES(coords, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawTexxvOES(IntBuffer coords) {
        this.begin("glDrawTexxvOES");
        this.arg("coords", 5, coords);
        this.end();
        this.mgl11Ext.glDrawTexxvOES(coords);
        this.checkError();
    }

    private final int $$robo$$android_opengl_GLLogWrapper$glQueryMatrixxOES(int[] mantissa, int mantissaOffset, int[] exponent, int exponentOffset) {
        this.begin("glQueryMatrixxOES");
        this.arg("mantissa", Arrays.toString(mantissa));
        this.arg("exponent", Arrays.toString(exponent));
        this.end();
        int valid = this.mgl10Ext.glQueryMatrixxOES(mantissa, mantissaOffset, exponent, exponentOffset);
        this.returns(this.toString(16, 2, mantissa, mantissaOffset));
        this.returns(this.toString(16, 0, exponent, exponentOffset));
        this.checkError();
        return valid;
    }

    private final int $$robo$$android_opengl_GLLogWrapper$glQueryMatrixxOES(IntBuffer mantissa, IntBuffer exponent) {
        this.begin("glQueryMatrixxOES");
        this.arg("mantissa", mantissa.toString());
        this.arg("exponent", exponent.toString());
        this.end();
        int valid = this.mgl10Ext.glQueryMatrixxOES(mantissa, exponent);
        this.returns(this.toString(16, 2, mantissa));
        this.returns(this.toString(16, 0, exponent));
        this.checkError();
        return valid;
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBindBuffer(int target, int buffer) {
        this.begin("glBindBuffer");
        this.arg("target", target);
        this.arg("buffer", buffer);
        this.end();
        this.mgl11.glBindBuffer(target, buffer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBufferData(int target, int size, Buffer data, int usage) {
        this.begin("glBufferData");
        this.arg("target", target);
        this.arg("size", size);
        this.arg("data", data.toString());
        this.arg("usage", usage);
        this.end();
        this.mgl11.glBufferData(target, size, data, usage);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBufferSubData(int target, int offset, int size, Buffer data) {
        this.begin("glBufferSubData");
        this.arg("target", target);
        this.arg("offset", offset);
        this.arg("size", size);
        this.arg("data", data.toString());
        this.end();
        this.mgl11.glBufferSubData(target, offset, size, data);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glColor4ub(byte red, byte green, byte blue, byte alpha) {
        this.begin("glColor4ub");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl11.glColor4ub(red, green, blue, alpha);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDeleteBuffers(int n, int[] buffers, int offset) {
        this.begin("glDeleteBuffers");
        this.arg("n", n);
        this.arg("buffers", buffers.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glDeleteBuffers(n, buffers, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDeleteBuffers(int n, IntBuffer buffers) {
        this.begin("glDeleteBuffers");
        this.arg("n", n);
        this.arg("buffers", buffers.toString());
        this.end();
        this.mgl11.glDeleteBuffers(n, buffers);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGenBuffers(int n, int[] buffers, int offset) {
        this.begin("glGenBuffers");
        this.arg("n", n);
        this.arg("buffers", buffers.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGenBuffers(n, buffers, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGenBuffers(int n, IntBuffer buffers) {
        this.begin("glGenBuffers");
        this.arg("n", n);
        this.arg("buffers", buffers.toString());
        this.end();
        this.mgl11.glGenBuffers(n, buffers);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetBooleanv(int pname, boolean[] params, int offset) {
        this.begin("glGetBooleanv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetBooleanv(pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetBooleanv(int pname, IntBuffer params) {
        this.begin("glGetBooleanv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetBooleanv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetBufferParameteriv(int target, int pname, int[] params, int offset) {
        this.begin("glGetBufferParameteriv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetBufferParameteriv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        this.begin("glGetBufferParameteriv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetBufferParameteriv(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetClipPlanef(int pname, float[] eqn, int offset) {
        this.begin("glGetClipPlanef");
        this.arg("pname", pname);
        this.arg("eqn", eqn.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetClipPlanef(pname, eqn, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetClipPlanef(int pname, FloatBuffer eqn) {
        this.begin("glGetClipPlanef");
        this.arg("pname", pname);
        this.arg("eqn", eqn.toString());
        this.end();
        this.mgl11.glGetClipPlanef(pname, eqn);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetClipPlanex(int pname, int[] eqn, int offset) {
        this.begin("glGetClipPlanex");
        this.arg("pname", pname);
        this.arg("eqn", eqn.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetClipPlanex(pname, eqn, offset);
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetClipPlanex(int pname, IntBuffer eqn) {
        this.begin("glGetClipPlanex");
        this.arg("pname", pname);
        this.arg("eqn", eqn.toString());
        this.end();
        this.mgl11.glGetClipPlanex(pname, eqn);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetFixedv(int pname, int[] params, int offset) {
        this.begin("glGetFixedv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetFixedv(pname, params, offset);
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetFixedv(int pname, IntBuffer params) {
        this.begin("glGetFixedv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetFixedv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetFloatv(int pname, float[] params, int offset) {
        this.begin("glGetFloatv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetFloatv(pname, params, offset);
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetFloatv(int pname, FloatBuffer params) {
        this.begin("glGetFloatv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetFloatv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetLightfv(int light, int pname, float[] params, int offset) {
        this.begin("glGetLightfv");
        this.arg("light", light);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetLightfv(light, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetLightfv(int light, int pname, FloatBuffer params) {
        this.begin("glGetLightfv");
        this.arg("light", light);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetLightfv(light, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetLightxv(int light, int pname, int[] params, int offset) {
        this.begin("glGetLightxv");
        this.arg("light", light);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetLightxv(light, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetLightxv(int light, int pname, IntBuffer params) {
        this.begin("glGetLightxv");
        this.arg("light", light);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetLightxv(light, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetMaterialfv(int face, int pname, float[] params, int offset) {
        this.begin("glGetMaterialfv");
        this.arg("face", face);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetMaterialfv(face, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetMaterialfv(int face, int pname, FloatBuffer params) {
        this.begin("glGetMaterialfv");
        this.arg("face", face);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetMaterialfv(face, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetMaterialxv(int face, int pname, int[] params, int offset) {
        this.begin("glGetMaterialxv");
        this.arg("face", face);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetMaterialxv(face, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetMaterialxv(int face, int pname, IntBuffer params) {
        this.begin("glGetMaterialxv");
        this.arg("face", face);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetMaterialxv(face, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexEnviv(int env, int pname, int[] params, int offset) {
        this.begin("glGetTexEnviv");
        this.arg("env", env);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexEnviv(env, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexEnviv(int env, int pname, IntBuffer params) {
        this.begin("glGetTexEnviv");
        this.arg("env", env);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexEnviv(env, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexEnvxv(int env, int pname, int[] params, int offset) {
        this.begin("glGetTexEnviv");
        this.arg("env", env);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexEnviv(env, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexEnvxv(int env, int pname, IntBuffer params) {
        this.begin("glGetTexEnviv");
        this.arg("env", env);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexEnvxv(env, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexParameterfv(int target, int pname, float[] params, int offset) {
        this.begin("glGetTexParameterfv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexParameterfv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        this.begin("glGetTexParameterfv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexParameterfv(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexParameteriv(int target, int pname, int[] params, int offset) {
        this.begin("glGetTexParameteriv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexEnviv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexParameteriv(int target, int pname, IntBuffer params) {
        this.begin("glGetTexParameteriv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexParameteriv(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexParameterxv(int target, int pname, int[] params, int offset) {
        this.begin("glGetTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexParameterxv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexParameterxv(int target, int pname, IntBuffer params) {
        this.begin("glGetTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexParameterxv(target, pname, params);
        this.checkError();
    }

    private final boolean $$robo$$android_opengl_GLLogWrapper$glIsBuffer(int buffer) {
        this.begin("glIsBuffer");
        this.arg("buffer", buffer);
        this.end();
        boolean result = this.mgl11.glIsBuffer(buffer);
        this.checkError();
        return result;
    }

    private final boolean $$robo$$android_opengl_GLLogWrapper$glIsEnabled(int cap) {
        this.begin("glIsEnabled");
        this.arg("cap", cap);
        this.end();
        boolean result = this.mgl11.glIsEnabled(cap);
        this.checkError();
        return result;
    }

    private final boolean $$robo$$android_opengl_GLLogWrapper$glIsTexture(int texture) {
        this.begin("glIsTexture");
        this.arg("texture", texture);
        this.end();
        boolean result = this.mgl11.glIsTexture(texture);
        this.checkError();
        return result;
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPointParameterf(int pname, float param) {
        this.begin("glPointParameterf");
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11.glPointParameterf(pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPointParameterfv(int pname, float[] params, int offset) {
        this.begin("glPointParameterfv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glPointParameterfv(pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPointParameterfv(int pname, FloatBuffer params) {
        this.begin("glPointParameterfv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glPointParameterfv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPointParameterx(int pname, int param) {
        this.begin("glPointParameterfv");
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11.glPointParameterx(pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPointParameterxv(int pname, int[] params, int offset) {
        this.begin("glPointParameterxv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glPointParameterxv(pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPointParameterxv(int pname, IntBuffer params) {
        this.begin("glPointParameterxv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glPointParameterxv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glPointSizePointerOES(int type, int stride, Buffer pointer) {
        this.begin("glPointSizePointerOES");
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("params", pointer.toString());
        this.end();
        this.mgl11.glPointSizePointerOES(type, stride, pointer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexEnvi(int target, int pname, int param) {
        this.begin("glTexEnvi");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11.glTexEnvi(target, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexEnviv(int target, int pname, int[] params, int offset) {
        this.begin("glTexEnviv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glTexEnviv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexEnviv(int target, int pname, IntBuffer params) {
        this.begin("glTexEnviv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glTexEnviv(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexParameterfv(int target, int pname, float[] params, int offset) {
        this.begin("glTexParameterfv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glTexParameterfv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexParameterfv(int target, int pname, FloatBuffer params) {
        this.begin("glTexParameterfv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glTexParameterfv(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexParameteri(int target, int pname, int param) {
        this.begin("glTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11.glTexParameteri(target, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexParameterxv(int target, int pname, int[] params, int offset) {
        this.begin("glTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glTexParameterxv(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexParameterxv(int target, int pname, IntBuffer params) {
        this.begin("glTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glTexParameterxv(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glColorPointer(int size, int type, int stride, int offset) {
        this.begin("glColorPointer");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glColorPointer(size, type, stride, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDrawElements(int mode, int count, int type, int offset) {
        this.begin("glDrawElements");
        this.arg("mode", mode);
        this.arg("count", count);
        this.arg("type", type);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glDrawElements(mode, count, type, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetPointerv(int pname, Buffer[] params) {
        this.begin("glGetPointerv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetPointerv(pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glNormalPointer(int type, int stride, int offset) {
        this.begin("glNormalPointer");
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glNormalPointer(type, stride, offset);
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexCoordPointer(int size, int type, int stride, int offset) {
        this.begin("glTexCoordPointer");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glTexCoordPointer(size, type, stride, offset);
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glVertexPointer(int size, int type, int stride, int offset) {
        this.begin("glVertexPointer");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glVertexPointer(size, type, stride, offset);
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glCurrentPaletteMatrixOES(int matrixpaletteindex) {
        this.begin("glCurrentPaletteMatrixOES");
        this.arg("matrixpaletteindex", matrixpaletteindex);
        this.end();
        this.mgl11Ext.glCurrentPaletteMatrixOES(matrixpaletteindex);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glLoadPaletteFromModelViewMatrixOES() {
        this.begin("glLoadPaletteFromModelViewMatrixOES");
        this.end();
        this.mgl11Ext.glLoadPaletteFromModelViewMatrixOES();
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMatrixIndexPointerOES(int size, int type, int stride, Buffer pointer) {
        this.begin("glMatrixIndexPointerOES");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mgl11Ext.glMatrixIndexPointerOES(size, type, stride, pointer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glMatrixIndexPointerOES(int size, int type, int stride, int offset) {
        this.begin("glMatrixIndexPointerOES");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glMatrixIndexPointerOES(size, type, stride, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glWeightPointerOES(int size, int type, int stride, Buffer pointer) {
        this.begin("glWeightPointerOES");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mgl11Ext.glWeightPointerOES(size, type, stride, pointer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glWeightPointerOES(int size, int type, int stride, int offset) {
        this.begin("glWeightPointerOES");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glWeightPointerOES(size, type, stride, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBindFramebufferOES(int target, int framebuffer) {
        this.begin("glBindFramebufferOES");
        this.arg("target", target);
        this.arg("framebuffer", framebuffer);
        this.end();
        this.mgl11ExtensionPack.glBindFramebufferOES(target, framebuffer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBindRenderbufferOES(int target, int renderbuffer) {
        this.begin("glBindRenderbufferOES");
        this.arg("target", target);
        this.arg("renderbuffer", renderbuffer);
        this.end();
        this.mgl11ExtensionPack.glBindRenderbufferOES(target, renderbuffer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBlendEquation(int mode) {
        this.begin("glBlendEquation");
        this.arg("mode", mode);
        this.end();
        this.mgl11ExtensionPack.glBlendEquation(mode);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        this.begin("glBlendEquationSeparate");
        this.arg("modeRGB", modeRGB);
        this.arg("modeAlpha", modeAlpha);
        this.end();
        this.mgl11ExtensionPack.glBlendEquationSeparate(modeRGB, modeAlpha);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        this.begin("glBlendFuncSeparate");
        this.arg("srcRGB", srcRGB);
        this.arg("dstRGB", dstRGB);
        this.arg("srcAlpha", srcAlpha);
        this.arg("dstAlpha", dstAlpha);
        this.end();
        this.mgl11ExtensionPack.glBlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
        this.checkError();
    }

    private final int $$robo$$android_opengl_GLLogWrapper$glCheckFramebufferStatusOES(int target) {
        this.begin("glCheckFramebufferStatusOES");
        this.arg("target", target);
        this.end();
        int result = this.mgl11ExtensionPack.glCheckFramebufferStatusOES(target);
        this.checkError();
        return result;
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDeleteFramebuffersOES(int n, int[] framebuffers, int offset) {
        this.begin("glDeleteFramebuffersOES");
        this.arg("n", n);
        this.arg("framebuffers", framebuffers.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glDeleteFramebuffersOES(n, framebuffers, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDeleteFramebuffersOES(int n, IntBuffer framebuffers) {
        this.begin("glDeleteFramebuffersOES");
        this.arg("n", n);
        this.arg("framebuffers", framebuffers.toString());
        this.end();
        this.mgl11ExtensionPack.glDeleteFramebuffersOES(n, framebuffers);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDeleteRenderbuffersOES(int n, int[] renderbuffers, int offset) {
        this.begin("glDeleteRenderbuffersOES");
        this.arg("n", n);
        this.arg("renderbuffers", renderbuffers.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glDeleteRenderbuffersOES(n, renderbuffers, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glDeleteRenderbuffersOES(int n, IntBuffer renderbuffers) {
        this.begin("glDeleteRenderbuffersOES");
        this.arg("n", n);
        this.arg("renderbuffers", renderbuffers.toString());
        this.end();
        this.mgl11ExtensionPack.glDeleteRenderbuffersOES(n, renderbuffers);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFramebufferRenderbufferOES(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        this.begin("glFramebufferRenderbufferOES");
        this.arg("target", target);
        this.arg("attachment", attachment);
        this.arg("renderbuffertarget", renderbuffertarget);
        this.arg("renderbuffer", renderbuffer);
        this.end();
        this.mgl11ExtensionPack.glFramebufferRenderbufferOES(target, attachment, renderbuffertarget, renderbuffer);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glFramebufferTexture2DOES(int target, int attachment, int textarget, int texture, int level) {
        this.begin("glFramebufferTexture2DOES");
        this.arg("target", target);
        this.arg("attachment", attachment);
        this.arg("textarget", textarget);
        this.arg("texture", texture);
        this.arg("level", level);
        this.end();
        this.mgl11ExtensionPack.glFramebufferTexture2DOES(target, attachment, textarget, texture, level);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGenerateMipmapOES(int target) {
        this.begin("glGenerateMipmapOES");
        this.arg("target", target);
        this.end();
        this.mgl11ExtensionPack.glGenerateMipmapOES(target);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGenFramebuffersOES(int n, int[] framebuffers, int offset) {
        this.begin("glGenFramebuffersOES");
        this.arg("n", n);
        this.arg("framebuffers", framebuffers.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glGenFramebuffersOES(n, framebuffers, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGenFramebuffersOES(int n, IntBuffer framebuffers) {
        this.begin("glGenFramebuffersOES");
        this.arg("n", n);
        this.arg("framebuffers", framebuffers.toString());
        this.end();
        this.mgl11ExtensionPack.glGenFramebuffersOES(n, framebuffers);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGenRenderbuffersOES(int n, int[] renderbuffers, int offset) {
        this.begin("glGenRenderbuffersOES");
        this.arg("n", n);
        this.arg("renderbuffers", renderbuffers.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glGenRenderbuffersOES(n, renderbuffers, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGenRenderbuffersOES(int n, IntBuffer renderbuffers) {
        this.begin("glGenRenderbuffersOES");
        this.arg("n", n);
        this.arg("renderbuffers", renderbuffers.toString());
        this.end();
        this.mgl11ExtensionPack.glGenRenderbuffersOES(n, renderbuffers);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetFramebufferAttachmentParameterivOES(int target, int attachment, int pname, int[] params, int offset) {
        this.begin("glGetFramebufferAttachmentParameterivOES");
        this.arg("target", target);
        this.arg("attachment", attachment);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glGetFramebufferAttachmentParameterivOES(target, attachment, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetFramebufferAttachmentParameterivOES(int target, int attachment, int pname, IntBuffer params) {
        this.begin("glGetFramebufferAttachmentParameterivOES");
        this.arg("target", target);
        this.arg("attachment", attachment);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11ExtensionPack.glGetFramebufferAttachmentParameterivOES(target, attachment, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetRenderbufferParameterivOES(int target, int pname, int[] params, int offset) {
        this.begin("glGetRenderbufferParameterivOES");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glGetRenderbufferParameterivOES(target, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetRenderbufferParameterivOES(int target, int pname, IntBuffer params) {
        this.begin("glGetRenderbufferParameterivOES");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11ExtensionPack.glGetRenderbufferParameterivOES(target, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexGenfv(int coord, int pname, float[] params, int offset) {
        this.begin("glGetTexGenfv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glGetTexGenfv(coord, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexGenfv(int coord, int pname, FloatBuffer params) {
        this.begin("glGetTexGenfv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11ExtensionPack.glGetTexGenfv(coord, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexGeniv(int coord, int pname, int[] params, int offset) {
        this.begin("glGetTexGeniv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glGetTexGeniv(coord, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexGeniv(int coord, int pname, IntBuffer params) {
        this.begin("glGetTexGeniv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11ExtensionPack.glGetTexGeniv(coord, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexGenxv(int coord, int pname, int[] params, int offset) {
        this.begin("glGetTexGenxv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glGetTexGenxv(coord, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glGetTexGenxv(int coord, int pname, IntBuffer params) {
        this.begin("glGetTexGenxv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11ExtensionPack.glGetTexGenxv(coord, pname, params);
        this.checkError();
    }

    private final boolean $$robo$$android_opengl_GLLogWrapper$glIsFramebufferOES(int framebuffer) {
        this.begin("glIsFramebufferOES");
        this.arg("framebuffer", framebuffer);
        this.end();
        boolean result = this.mgl11ExtensionPack.glIsFramebufferOES(framebuffer);
        this.checkError();
        return result;
    }

    private final boolean $$robo$$android_opengl_GLLogWrapper$glIsRenderbufferOES(int renderbuffer) {
        this.begin("glIsRenderbufferOES");
        this.arg("renderbuffer", renderbuffer);
        this.end();
        this.mgl11ExtensionPack.glIsRenderbufferOES(renderbuffer);
        this.checkError();
        return false;
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glRenderbufferStorageOES(int target, int internalformat, int width, int height) {
        this.begin("glRenderbufferStorageOES");
        this.arg("target", target);
        this.arg("internalformat", internalformat);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl11ExtensionPack.glRenderbufferStorageOES(target, internalformat, width, height);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexGenf(int coord, int pname, float param) {
        this.begin("glTexGenf");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11ExtensionPack.glTexGenf(coord, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexGenfv(int coord, int pname, float[] params, int offset) {
        this.begin("glTexGenfv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glTexGenfv(coord, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexGenfv(int coord, int pname, FloatBuffer params) {
        this.begin("glTexGenfv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11ExtensionPack.glTexGenfv(coord, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexGeni(int coord, int pname, int param) {
        this.begin("glTexGeni");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11ExtensionPack.glTexGeni(coord, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexGeniv(int coord, int pname, int[] params, int offset) {
        this.begin("glTexGeniv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glTexGeniv(coord, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexGeniv(int coord, int pname, IntBuffer params) {
        this.begin("glTexGeniv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11ExtensionPack.glTexGeniv(coord, pname, params);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexGenx(int coord, int pname, int param) {
        this.begin("glTexGenx");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11ExtensionPack.glTexGenx(coord, pname, param);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexGenxv(int coord, int pname, int[] params, int offset) {
        this.begin("glTexGenxv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11ExtensionPack.glTexGenxv(coord, pname, params, offset);
        this.checkError();
    }

    private final void $$robo$$android_opengl_GLLogWrapper$glTexGenxv(int coord, int pname, IntBuffer params) {
        this.begin("glTexGenxv");
        this.arg("coord", coord);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11ExtensionPack.glTexGenxv(coord, pname, params);
        this.checkError();
    }

    private void __constructor__(GL gL, Writer writer, boolean bl) {
        this.$$robo$$android_opengl_GLLogWrapper$__constructor__(gL, writer, bl);
    }

    public GLLogWrapper(GL gL, Writer writer, boolean bl) {
        super(gL);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLLogWrapper$__constructor__(javax.microedition.khronos.opengles.GL java.io.Writer boolean ), 0, this, gL, writer, bl);
    }

    private void checkError() {
        InvokeDynamicSupport.bootstrap("checkError", $$robo$$android_opengl_GLLogWrapper$checkError(), 0, this);
    }

    private void logLine(String string2) {
        InvokeDynamicSupport.bootstrap("logLine", $$robo$$android_opengl_GLLogWrapper$logLine(java.lang.String ), 0, this, string2);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_opengl_GLLogWrapper$log(java.lang.String ), 0, this, string2);
    }

    private void begin(String string2) {
        InvokeDynamicSupport.bootstrap("begin", $$robo$$android_opengl_GLLogWrapper$begin(java.lang.String ), 0, this, string2);
    }

    private void arg(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_opengl_GLLogWrapper$end(), 0, this);
    }

    private void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_opengl_GLLogWrapper$flush(), 0, this);
    }

    private void arg(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String boolean ), 0, this, string2, bl);
    }

    private void arg(String string2, int n) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String int ), 0, this, string2, n);
    }

    private void arg(String string2, float f) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String float ), 0, this, string2, f);
    }

    private void returns(String string2) {
        InvokeDynamicSupport.bootstrap("returns", $$robo$$android_opengl_GLLogWrapper$returns(java.lang.String ), 0, this, string2);
    }

    private void returns(int n) {
        InvokeDynamicSupport.bootstrap("returns", $$robo$$android_opengl_GLLogWrapper$returns(int ), 0, this, n);
    }

    private void arg(String string2, int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String int int[] int ), 0, this, string2, n, nArray, n2);
    }

    private void arg(String string2, int n, short[] sArray, int n2) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String int short[] int ), 0, this, string2, n, sArray, n2);
    }

    private void arg(String string2, int n, float[] fArray, int n2) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String int float[] int ), 0, this, string2, n, fArray, n2);
    }

    private void formattedAppend(StringBuilder stringBuilder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("formattedAppend", $$robo$$android_opengl_GLLogWrapper$formattedAppend(java.lang.StringBuilder int int ), 0, this, stringBuilder, n, n2);
    }

    private String toString(int n, int n2, int[] nArray, int n3) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_opengl_GLLogWrapper$toString(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    private String toString(int n, short[] sArray, int n2) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_opengl_GLLogWrapper$toString(int short[] int ), 0, this, n, sArray, n2);
    }

    private String toString(int n, float[] fArray, int n2) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_opengl_GLLogWrapper$toString(int float[] int ), 0, this, n, fArray, n2);
    }

    private String toString(int n, FloatBuffer floatBuffer) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_opengl_GLLogWrapper$toString(int java.nio.FloatBuffer ), 0, this, n, floatBuffer);
    }

    private String toString(int n, int n2, IntBuffer intBuffer) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_opengl_GLLogWrapper$toString(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    private String toString(int n, ShortBuffer shortBuffer) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_opengl_GLLogWrapper$toString(int java.nio.ShortBuffer ), 0, this, n, shortBuffer);
    }

    private void arg(String string2, int n, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String int java.nio.FloatBuffer ), 0, this, string2, n, floatBuffer);
    }

    private void arg(String string2, int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String int java.nio.IntBuffer ), 0, this, string2, n, intBuffer);
    }

    private void arg(String string2, int n, ShortBuffer shortBuffer) {
        InvokeDynamicSupport.bootstrap("arg", $$robo$$android_opengl_GLLogWrapper$arg(java.lang.String int java.nio.ShortBuffer ), 0, this, string2, n, shortBuffer);
    }

    private void argPointer(int n, int n2, int n3, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("argPointer", $$robo$$android_opengl_GLLogWrapper$argPointer(int int int java.nio.Buffer ), 0, this, n, n2, n3, buffer);
    }

    private static String getHex(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getHex", $$robo$$android_opengl_GLLogWrapper$getHex(int ), 0, (int)n);
    }

    public static String getErrorString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getErrorString", $$robo$$android_opengl_GLLogWrapper$getErrorString(int ), 0, (int)n);
    }

    private String getClearBufferMask(int n) {
        return InvokeDynamicSupport.bootstrap("getClearBufferMask", $$robo$$android_opengl_GLLogWrapper$getClearBufferMask(int ), 0, this, n);
    }

    private String getFactor(int n) {
        return InvokeDynamicSupport.bootstrap("getFactor", $$robo$$android_opengl_GLLogWrapper$getFactor(int ), 0, this, n);
    }

    private String getShadeModel(int n) {
        return InvokeDynamicSupport.bootstrap("getShadeModel", $$robo$$android_opengl_GLLogWrapper$getShadeModel(int ), 0, this, n);
    }

    private String getTextureTarget(int n) {
        return InvokeDynamicSupport.bootstrap("getTextureTarget", $$robo$$android_opengl_GLLogWrapper$getTextureTarget(int ), 0, this, n);
    }

    private String getTextureEnvTarget(int n) {
        return InvokeDynamicSupport.bootstrap("getTextureEnvTarget", $$robo$$android_opengl_GLLogWrapper$getTextureEnvTarget(int ), 0, this, n);
    }

    private String getTextureEnvPName(int n) {
        return InvokeDynamicSupport.bootstrap("getTextureEnvPName", $$robo$$android_opengl_GLLogWrapper$getTextureEnvPName(int ), 0, this, n);
    }

    private int getTextureEnvParamCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getTextureEnvParamCount", $$robo$$android_opengl_GLLogWrapper$getTextureEnvParamCount(int ), 0, this, n);
    }

    private String getTextureEnvParamName(float f) {
        return InvokeDynamicSupport.bootstrap("getTextureEnvParamName", $$robo$$android_opengl_GLLogWrapper$getTextureEnvParamName(float ), 0, this, f);
    }

    private String getMatrixMode(int n) {
        return InvokeDynamicSupport.bootstrap("getMatrixMode", $$robo$$android_opengl_GLLogWrapper$getMatrixMode(int ), 0, this, n);
    }

    private String getClientState(int n) {
        return InvokeDynamicSupport.bootstrap("getClientState", $$robo$$android_opengl_GLLogWrapper$getClientState(int ), 0, this, n);
    }

    private String getCap(int n) {
        return InvokeDynamicSupport.bootstrap("getCap", $$robo$$android_opengl_GLLogWrapper$getCap(int ), 0, this, n);
    }

    private String getTexturePName(int n) {
        return InvokeDynamicSupport.bootstrap("getTexturePName", $$robo$$android_opengl_GLLogWrapper$getTexturePName(int ), 0, this, n);
    }

    private String getTextureParamName(float f) {
        return InvokeDynamicSupport.bootstrap("getTextureParamName", $$robo$$android_opengl_GLLogWrapper$getTextureParamName(float ), 0, this, f);
    }

    private String getFogPName(int n) {
        return InvokeDynamicSupport.bootstrap("getFogPName", $$robo$$android_opengl_GLLogWrapper$getFogPName(int ), 0, this, n);
    }

    private int getFogParamCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getFogParamCount", $$robo$$android_opengl_GLLogWrapper$getFogParamCount(int ), 0, this, n);
    }

    private String getBeginMode(int n) {
        return InvokeDynamicSupport.bootstrap("getBeginMode", $$robo$$android_opengl_GLLogWrapper$getBeginMode(int ), 0, this, n);
    }

    private String getIndexType(int n) {
        return InvokeDynamicSupport.bootstrap("getIndexType", $$robo$$android_opengl_GLLogWrapper$getIndexType(int ), 0, this, n);
    }

    private String getIntegerStateName(int n) {
        return InvokeDynamicSupport.bootstrap("getIntegerStateName", $$robo$$android_opengl_GLLogWrapper$getIntegerStateName(int ), 0, this, n);
    }

    private int getIntegerStateSize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIntegerStateSize", $$robo$$android_opengl_GLLogWrapper$getIntegerStateSize(int ), 0, this, n);
    }

    private int getIntegerStateFormat(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIntegerStateFormat", $$robo$$android_opengl_GLLogWrapper$getIntegerStateFormat(int ), 0, this, n);
    }

    private String getHintTarget(int n) {
        return InvokeDynamicSupport.bootstrap("getHintTarget", $$robo$$android_opengl_GLLogWrapper$getHintTarget(int ), 0, this, n);
    }

    private String getHintMode(int n) {
        return InvokeDynamicSupport.bootstrap("getHintMode", $$robo$$android_opengl_GLLogWrapper$getHintMode(int ), 0, this, n);
    }

    private String getFaceName(int n) {
        return InvokeDynamicSupport.bootstrap("getFaceName", $$robo$$android_opengl_GLLogWrapper$getFaceName(int ), 0, this, n);
    }

    private String getMaterialPName(int n) {
        return InvokeDynamicSupport.bootstrap("getMaterialPName", $$robo$$android_opengl_GLLogWrapper$getMaterialPName(int ), 0, this, n);
    }

    private int getMaterialParamCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMaterialParamCount", $$robo$$android_opengl_GLLogWrapper$getMaterialParamCount(int ), 0, this, n);
    }

    private String getLightName(int n) {
        return InvokeDynamicSupport.bootstrap("getLightName", $$robo$$android_opengl_GLLogWrapper$getLightName(int ), 0, this, n);
    }

    private String getLightPName(int n) {
        return InvokeDynamicSupport.bootstrap("getLightPName", $$robo$$android_opengl_GLLogWrapper$getLightPName(int ), 0, this, n);
    }

    private int getLightParamCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLightParamCount", $$robo$$android_opengl_GLLogWrapper$getLightParamCount(int ), 0, this, n);
    }

    private String getLightModelPName(int n) {
        return InvokeDynamicSupport.bootstrap("getLightModelPName", $$robo$$android_opengl_GLLogWrapper$getLightModelPName(int ), 0, this, n);
    }

    private int getLightModelParamCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLightModelParamCount", $$robo$$android_opengl_GLLogWrapper$getLightModelParamCount(int ), 0, this, n);
    }

    private String getPointerTypeName(int n) {
        return InvokeDynamicSupport.bootstrap("getPointerTypeName", $$robo$$android_opengl_GLLogWrapper$getPointerTypeName(int ), 0, this, n);
    }

    private ByteBuffer toByteBuffer(int n, Buffer buffer) {
        return InvokeDynamicSupport.bootstrap("toByteBuffer", $$robo$$android_opengl_GLLogWrapper$toByteBuffer(int java.nio.Buffer ), 0, this, n, buffer);
    }

    private char[] toCharIndices(int n, int n2, Buffer buffer) {
        return InvokeDynamicSupport.bootstrap("toCharIndices", $$robo$$android_opengl_GLLogWrapper$toCharIndices(int int java.nio.Buffer ), 0, this, n, n2, buffer);
    }

    private void doArrayElement(StringBuilder stringBuilder, boolean bl, String string2, PointerInfo pointerInfo, int n) {
        InvokeDynamicSupport.bootstrap("doArrayElement", $$robo$$android_opengl_GLLogWrapper$doArrayElement(java.lang.StringBuilder boolean java.lang.String android.opengl.GLLogWrapper$PointerInfo int ), 0, this, stringBuilder, bl, string2, pointerInfo, n);
    }

    private void doElement(StringBuilder stringBuilder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("doElement", $$robo$$android_opengl_GLLogWrapper$doElement(java.lang.StringBuilder int int ), 0, this, stringBuilder, n, n2);
    }

    private void bindArrays() {
        InvokeDynamicSupport.bootstrap("bindArrays", $$robo$$android_opengl_GLLogWrapper$bindArrays(), 0, this);
    }

    private void unbindArrays() {
        InvokeDynamicSupport.bootstrap("unbindArrays", $$robo$$android_opengl_GLLogWrapper$unbindArrays(), 0, this);
    }

    private void startLogIndices() {
        InvokeDynamicSupport.bootstrap("startLogIndices", $$robo$$android_opengl_GLLogWrapper$startLogIndices(), 0, this);
    }

    private void endLogIndices() {
        InvokeDynamicSupport.bootstrap("endLogIndices", $$robo$$android_opengl_GLLogWrapper$endLogIndices(), 0, this);
    }

    @Override
    public void glActiveTexture(int n) {
        InvokeDynamicSupport.bootstrap("glActiveTexture", $$robo$$android_opengl_GLLogWrapper$glActiveTexture(int ), 0, this, n);
    }

    @Override
    public void glAlphaFunc(int n, float f) {
        InvokeDynamicSupport.bootstrap("glAlphaFunc", $$robo$$android_opengl_GLLogWrapper$glAlphaFunc(int float ), 0, this, n, f);
    }

    @Override
    public void glAlphaFuncx(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glAlphaFuncx", $$robo$$android_opengl_GLLogWrapper$glAlphaFuncx(int int ), 0, this, n, n2);
    }

    @Override
    public void glBindTexture(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glBindTexture", $$robo$$android_opengl_GLLogWrapper$glBindTexture(int int ), 0, this, n, n2);
    }

    @Override
    public void glBlendFunc(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glBlendFunc", $$robo$$android_opengl_GLLogWrapper$glBlendFunc(int int ), 0, this, n, n2);
    }

    @Override
    public void glClear(int n) {
        InvokeDynamicSupport.bootstrap("glClear", $$robo$$android_opengl_GLLogWrapper$glClear(int ), 0, this, n);
    }

    @Override
    public void glClearColor(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("glClearColor", $$robo$$android_opengl_GLLogWrapper$glClearColor(float float float float ), 0, this, f, f2, f3, f4);
    }

    @Override
    public void glClearColorx(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glClearColorx", $$robo$$android_opengl_GLLogWrapper$glClearColorx(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glClearDepthf(float f) {
        InvokeDynamicSupport.bootstrap("glClearDepthf", $$robo$$android_opengl_GLLogWrapper$glClearDepthf(float ), 0, this, f);
    }

    @Override
    public void glClearDepthx(int n) {
        InvokeDynamicSupport.bootstrap("glClearDepthx", $$robo$$android_opengl_GLLogWrapper$glClearDepthx(int ), 0, this, n);
    }

    @Override
    public void glClearStencil(int n) {
        InvokeDynamicSupport.bootstrap("glClearStencil", $$robo$$android_opengl_GLLogWrapper$glClearStencil(int ), 0, this, n);
    }

    @Override
    public void glClientActiveTexture(int n) {
        InvokeDynamicSupport.bootstrap("glClientActiveTexture", $$robo$$android_opengl_GLLogWrapper$glClientActiveTexture(int ), 0, this, n);
    }

    @Override
    public void glColor4f(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("glColor4f", $$robo$$android_opengl_GLLogWrapper$glColor4f(float float float float ), 0, this, f, f2, f3, f4);
    }

    @Override
    public void glColor4x(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glColor4x", $$robo$$android_opengl_GLLogWrapper$glColor4x(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        InvokeDynamicSupport.bootstrap("glColorMask", $$robo$$android_opengl_GLLogWrapper$glColorMask(boolean boolean boolean boolean ), 0, this, bl, bl2, bl3, bl4);
    }

    @Override
    public void glColorPointer(int n, int n2, int n3, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glColorPointer", $$robo$$android_opengl_GLLogWrapper$glColorPointer(int int int java.nio.Buffer ), 0, this, n, n2, n3, buffer);
    }

    @Override
    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glCompressedTexImage2D", $$robo$$android_opengl_GLLogWrapper$glCompressedTexImage2D(int int int int int int int java.nio.Buffer ), 0, this, n, n2, n3, n4, n5, n6, n7, buffer);
    }

    @Override
    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glCompressedTexSubImage2D", $$robo$$android_opengl_GLLogWrapper$glCompressedTexSubImage2D(int int int int int int int int java.nio.Buffer ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, buffer);
    }

    @Override
    public void glCopyTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        InvokeDynamicSupport.bootstrap("glCopyTexImage2D", $$robo$$android_opengl_GLLogWrapper$glCopyTexImage2D(int int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    public void glCopyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        InvokeDynamicSupport.bootstrap("glCopyTexSubImage2D", $$robo$$android_opengl_GLLogWrapper$glCopyTexSubImage2D(int int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    public void glCullFace(int n) {
        InvokeDynamicSupport.bootstrap("glCullFace", $$robo$$android_opengl_GLLogWrapper$glCullFace(int ), 0, this, n);
    }

    @Override
    public void glDeleteTextures(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glDeleteTextures", $$robo$$android_opengl_GLLogWrapper$glDeleteTextures(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glDeleteTextures(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glDeleteTextures", $$robo$$android_opengl_GLLogWrapper$glDeleteTextures(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glDepthFunc(int n) {
        InvokeDynamicSupport.bootstrap("glDepthFunc", $$robo$$android_opengl_GLLogWrapper$glDepthFunc(int ), 0, this, n);
    }

    @Override
    public void glDepthMask(boolean bl) {
        InvokeDynamicSupport.bootstrap("glDepthMask", $$robo$$android_opengl_GLLogWrapper$glDepthMask(boolean ), 0, this, bl);
    }

    @Override
    public void glDepthRangef(float f, float f2) {
        InvokeDynamicSupport.bootstrap("glDepthRangef", $$robo$$android_opengl_GLLogWrapper$glDepthRangef(float float ), 0, this, f, f2);
    }

    @Override
    public void glDepthRangex(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glDepthRangex", $$robo$$android_opengl_GLLogWrapper$glDepthRangex(int int ), 0, this, n, n2);
    }

    @Override
    public void glDisable(int n) {
        InvokeDynamicSupport.bootstrap("glDisable", $$robo$$android_opengl_GLLogWrapper$glDisable(int ), 0, this, n);
    }

    @Override
    public void glDisableClientState(int n) {
        InvokeDynamicSupport.bootstrap("glDisableClientState", $$robo$$android_opengl_GLLogWrapper$glDisableClientState(int ), 0, this, n);
    }

    @Override
    public void glDrawArrays(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glDrawArrays", $$robo$$android_opengl_GLLogWrapper$glDrawArrays(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glDrawElements(int n, int n2, int n3, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glDrawElements", $$robo$$android_opengl_GLLogWrapper$glDrawElements(int int int java.nio.Buffer ), 0, this, n, n2, n3, buffer);
    }

    @Override
    public void glEnable(int n) {
        InvokeDynamicSupport.bootstrap("glEnable", $$robo$$android_opengl_GLLogWrapper$glEnable(int ), 0, this, n);
    }

    @Override
    public void glEnableClientState(int n) {
        InvokeDynamicSupport.bootstrap("glEnableClientState", $$robo$$android_opengl_GLLogWrapper$glEnableClientState(int ), 0, this, n);
    }

    @Override
    public void glFinish() {
        InvokeDynamicSupport.bootstrap("glFinish", $$robo$$android_opengl_GLLogWrapper$glFinish(), 0, this);
    }

    @Override
    public void glFlush() {
        InvokeDynamicSupport.bootstrap("glFlush", $$robo$$android_opengl_GLLogWrapper$glFlush(), 0, this);
    }

    @Override
    public void glFogf(int n, float f) {
        InvokeDynamicSupport.bootstrap("glFogf", $$robo$$android_opengl_GLLogWrapper$glFogf(int float ), 0, this, n, f);
    }

    @Override
    public void glFogfv(int n, float[] fArray, int n2) {
        InvokeDynamicSupport.bootstrap("glFogfv", $$robo$$android_opengl_GLLogWrapper$glFogfv(int float[] int ), 0, this, n, fArray, n2);
    }

    @Override
    public void glFogfv(int n, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glFogfv", $$robo$$android_opengl_GLLogWrapper$glFogfv(int java.nio.FloatBuffer ), 0, this, n, floatBuffer);
    }

    @Override
    public void glFogx(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glFogx", $$robo$$android_opengl_GLLogWrapper$glFogx(int int ), 0, this, n, n2);
    }

    @Override
    public void glFogxv(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glFogxv", $$robo$$android_opengl_GLLogWrapper$glFogxv(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glFogxv(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glFogxv", $$robo$$android_opengl_GLLogWrapper$glFogxv(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glFrontFace(int n) {
        InvokeDynamicSupport.bootstrap("glFrontFace", $$robo$$android_opengl_GLLogWrapper$glFrontFace(int ), 0, this, n);
    }

    @Override
    public void glFrustumf(float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrap("glFrustumf", $$robo$$android_opengl_GLLogWrapper$glFrustumf(float float float float float float ), 0, this, f, f2, f3, f4, f5, f6);
    }

    @Override
    public void glFrustumx(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("glFrustumx", $$robo$$android_opengl_GLLogWrapper$glFrustumx(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    @Override
    public void glGenTextures(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGenTextures", $$robo$$android_opengl_GLLogWrapper$glGenTextures(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glGenTextures(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGenTextures", $$robo$$android_opengl_GLLogWrapper$glGenTextures(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public int glGetError() {
        return (int)InvokeDynamicSupport.bootstrap("glGetError", $$robo$$android_opengl_GLLogWrapper$glGetError(), 0, this);
    }

    @Override
    public void glGetIntegerv(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGetIntegerv", $$robo$$android_opengl_GLLogWrapper$glGetIntegerv(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glGetIntegerv(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetIntegerv", $$robo$$android_opengl_GLLogWrapper$glGetIntegerv(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public String glGetString(int n) {
        return InvokeDynamicSupport.bootstrap("glGetString", $$robo$$android_opengl_GLLogWrapper$glGetString(int ), 0, this, n);
    }

    @Override
    public void glHint(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glHint", $$robo$$android_opengl_GLLogWrapper$glHint(int int ), 0, this, n, n2);
    }

    @Override
    public void glLightModelf(int n, float f) {
        InvokeDynamicSupport.bootstrap("glLightModelf", $$robo$$android_opengl_GLLogWrapper$glLightModelf(int float ), 0, this, n, f);
    }

    @Override
    public void glLightModelfv(int n, float[] fArray, int n2) {
        InvokeDynamicSupport.bootstrap("glLightModelfv", $$robo$$android_opengl_GLLogWrapper$glLightModelfv(int float[] int ), 0, this, n, fArray, n2);
    }

    @Override
    public void glLightModelfv(int n, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glLightModelfv", $$robo$$android_opengl_GLLogWrapper$glLightModelfv(int java.nio.FloatBuffer ), 0, this, n, floatBuffer);
    }

    @Override
    public void glLightModelx(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glLightModelx", $$robo$$android_opengl_GLLogWrapper$glLightModelx(int int ), 0, this, n, n2);
    }

    @Override
    public void glLightModelxv(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glLightModelxv", $$robo$$android_opengl_GLLogWrapper$glLightModelxv(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glLightModelxv(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glLightModelxv", $$robo$$android_opengl_GLLogWrapper$glLightModelxv(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glLightf(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("glLightf", $$robo$$android_opengl_GLLogWrapper$glLightf(int int float ), 0, this, n, n2, f);
    }

    @Override
    public void glLightfv(int n, int n2, float[] fArray, int n3) {
        InvokeDynamicSupport.bootstrap("glLightfv", $$robo$$android_opengl_GLLogWrapper$glLightfv(int int float[] int ), 0, this, n, n2, fArray, n3);
    }

    @Override
    public void glLightfv(int n, int n2, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glLightfv", $$robo$$android_opengl_GLLogWrapper$glLightfv(int int java.nio.FloatBuffer ), 0, this, n, n2, floatBuffer);
    }

    @Override
    public void glLightx(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glLightx", $$robo$$android_opengl_GLLogWrapper$glLightx(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glLightxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glLightxv", $$robo$$android_opengl_GLLogWrapper$glLightxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glLightxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glLightxv", $$robo$$android_opengl_GLLogWrapper$glLightxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glLineWidth(float f) {
        InvokeDynamicSupport.bootstrap("glLineWidth", $$robo$$android_opengl_GLLogWrapper$glLineWidth(float ), 0, this, f);
    }

    @Override
    public void glLineWidthx(int n) {
        InvokeDynamicSupport.bootstrap("glLineWidthx", $$robo$$android_opengl_GLLogWrapper$glLineWidthx(int ), 0, this, n);
    }

    @Override
    public void glLoadIdentity() {
        InvokeDynamicSupport.bootstrap("glLoadIdentity", $$robo$$android_opengl_GLLogWrapper$glLoadIdentity(), 0, this);
    }

    @Override
    public void glLoadMatrixf(float[] fArray, int n) {
        InvokeDynamicSupport.bootstrap("glLoadMatrixf", $$robo$$android_opengl_GLLogWrapper$glLoadMatrixf(float[] int ), 0, this, fArray, n);
    }

    @Override
    public void glLoadMatrixf(FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glLoadMatrixf", $$robo$$android_opengl_GLLogWrapper$glLoadMatrixf(java.nio.FloatBuffer ), 0, this, floatBuffer);
    }

    @Override
    public void glLoadMatrixx(int[] nArray, int n) {
        InvokeDynamicSupport.bootstrap("glLoadMatrixx", $$robo$$android_opengl_GLLogWrapper$glLoadMatrixx(int[] int ), 0, this, nArray, n);
    }

    @Override
    public void glLoadMatrixx(IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glLoadMatrixx", $$robo$$android_opengl_GLLogWrapper$glLoadMatrixx(java.nio.IntBuffer ), 0, this, intBuffer);
    }

    @Override
    public void glLogicOp(int n) {
        InvokeDynamicSupport.bootstrap("glLogicOp", $$robo$$android_opengl_GLLogWrapper$glLogicOp(int ), 0, this, n);
    }

    @Override
    public void glMaterialf(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("glMaterialf", $$robo$$android_opengl_GLLogWrapper$glMaterialf(int int float ), 0, this, n, n2, f);
    }

    @Override
    public void glMaterialfv(int n, int n2, float[] fArray, int n3) {
        InvokeDynamicSupport.bootstrap("glMaterialfv", $$robo$$android_opengl_GLLogWrapper$glMaterialfv(int int float[] int ), 0, this, n, n2, fArray, n3);
    }

    @Override
    public void glMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glMaterialfv", $$robo$$android_opengl_GLLogWrapper$glMaterialfv(int int java.nio.FloatBuffer ), 0, this, n, n2, floatBuffer);
    }

    @Override
    public void glMaterialx(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glMaterialx", $$robo$$android_opengl_GLLogWrapper$glMaterialx(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glMaterialxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glMaterialxv", $$robo$$android_opengl_GLLogWrapper$glMaterialxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glMaterialxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glMaterialxv", $$robo$$android_opengl_GLLogWrapper$glMaterialxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glMatrixMode(int n) {
        InvokeDynamicSupport.bootstrap("glMatrixMode", $$robo$$android_opengl_GLLogWrapper$glMatrixMode(int ), 0, this, n);
    }

    @Override
    public void glMultMatrixf(float[] fArray, int n) {
        InvokeDynamicSupport.bootstrap("glMultMatrixf", $$robo$$android_opengl_GLLogWrapper$glMultMatrixf(float[] int ), 0, this, fArray, n);
    }

    @Override
    public void glMultMatrixf(FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glMultMatrixf", $$robo$$android_opengl_GLLogWrapper$glMultMatrixf(java.nio.FloatBuffer ), 0, this, floatBuffer);
    }

    @Override
    public void glMultMatrixx(int[] nArray, int n) {
        InvokeDynamicSupport.bootstrap("glMultMatrixx", $$robo$$android_opengl_GLLogWrapper$glMultMatrixx(int[] int ), 0, this, nArray, n);
    }

    @Override
    public void glMultMatrixx(IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glMultMatrixx", $$robo$$android_opengl_GLLogWrapper$glMultMatrixx(java.nio.IntBuffer ), 0, this, intBuffer);
    }

    @Override
    public void glMultiTexCoord4f(int n, float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("glMultiTexCoord4f", $$robo$$android_opengl_GLLogWrapper$glMultiTexCoord4f(int float float float float ), 0, this, n, f, f2, f3, f4);
    }

    @Override
    public void glMultiTexCoord4x(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("glMultiTexCoord4x", $$robo$$android_opengl_GLLogWrapper$glMultiTexCoord4x(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    @Override
    public void glNormal3f(float f, float f2, float f3) {
        InvokeDynamicSupport.bootstrap("glNormal3f", $$robo$$android_opengl_GLLogWrapper$glNormal3f(float float float ), 0, this, f, f2, f3);
    }

    @Override
    public void glNormal3x(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glNormal3x", $$robo$$android_opengl_GLLogWrapper$glNormal3x(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glNormalPointer(int n, int n2, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glNormalPointer", $$robo$$android_opengl_GLLogWrapper$glNormalPointer(int int java.nio.Buffer ), 0, this, n, n2, buffer);
    }

    @Override
    public void glOrthof(float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrap("glOrthof", $$robo$$android_opengl_GLLogWrapper$glOrthof(float float float float float float ), 0, this, f, f2, f3, f4, f5, f6);
    }

    @Override
    public void glOrthox(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("glOrthox", $$robo$$android_opengl_GLLogWrapper$glOrthox(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    @Override
    public void glPixelStorei(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glPixelStorei", $$robo$$android_opengl_GLLogWrapper$glPixelStorei(int int ), 0, this, n, n2);
    }

    @Override
    public void glPointSize(float f) {
        InvokeDynamicSupport.bootstrap("glPointSize", $$robo$$android_opengl_GLLogWrapper$glPointSize(float ), 0, this, f);
    }

    @Override
    public void glPointSizex(int n) {
        InvokeDynamicSupport.bootstrap("glPointSizex", $$robo$$android_opengl_GLLogWrapper$glPointSizex(int ), 0, this, n);
    }

    @Override
    public void glPolygonOffset(float f, float f2) {
        InvokeDynamicSupport.bootstrap("glPolygonOffset", $$robo$$android_opengl_GLLogWrapper$glPolygonOffset(float float ), 0, this, f, f2);
    }

    @Override
    public void glPolygonOffsetx(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glPolygonOffsetx", $$robo$$android_opengl_GLLogWrapper$glPolygonOffsetx(int int ), 0, this, n, n2);
    }

    @Override
    public void glPopMatrix() {
        InvokeDynamicSupport.bootstrap("glPopMatrix", $$robo$$android_opengl_GLLogWrapper$glPopMatrix(), 0, this);
    }

    @Override
    public void glPushMatrix() {
        InvokeDynamicSupport.bootstrap("glPushMatrix", $$robo$$android_opengl_GLLogWrapper$glPushMatrix(), 0, this);
    }

    @Override
    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glReadPixels", $$robo$$android_opengl_GLLogWrapper$glReadPixels(int int int int int int java.nio.Buffer ), 0, this, n, n2, n3, n4, n5, n6, buffer);
    }

    @Override
    public void glRotatef(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("glRotatef", $$robo$$android_opengl_GLLogWrapper$glRotatef(float float float float ), 0, this, f, f2, f3, f4);
    }

    @Override
    public void glRotatex(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glRotatex", $$robo$$android_opengl_GLLogWrapper$glRotatex(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glSampleCoverage(float f, boolean bl) {
        InvokeDynamicSupport.bootstrap("glSampleCoverage", $$robo$$android_opengl_GLLogWrapper$glSampleCoverage(float boolean ), 0, this, f, bl);
    }

    @Override
    public void glSampleCoveragex(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("glSampleCoveragex", $$robo$$android_opengl_GLLogWrapper$glSampleCoveragex(int boolean ), 0, this, n, bl);
    }

    @Override
    public void glScalef(float f, float f2, float f3) {
        InvokeDynamicSupport.bootstrap("glScalef", $$robo$$android_opengl_GLLogWrapper$glScalef(float float float ), 0, this, f, f2, f3);
    }

    @Override
    public void glScalex(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glScalex", $$robo$$android_opengl_GLLogWrapper$glScalex(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glScissor(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glScissor", $$robo$$android_opengl_GLLogWrapper$glScissor(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glShadeModel(int n) {
        InvokeDynamicSupport.bootstrap("glShadeModel", $$robo$$android_opengl_GLLogWrapper$glShadeModel(int ), 0, this, n);
    }

    @Override
    public void glStencilFunc(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glStencilFunc", $$robo$$android_opengl_GLLogWrapper$glStencilFunc(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glStencilMask(int n) {
        InvokeDynamicSupport.bootstrap("glStencilMask", $$robo$$android_opengl_GLLogWrapper$glStencilMask(int ), 0, this, n);
    }

    @Override
    public void glStencilOp(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glStencilOp", $$robo$$android_opengl_GLLogWrapper$glStencilOp(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glTexCoordPointer(int n, int n2, int n3, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glTexCoordPointer", $$robo$$android_opengl_GLLogWrapper$glTexCoordPointer(int int int java.nio.Buffer ), 0, this, n, n2, n3, buffer);
    }

    @Override
    public void glTexEnvf(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("glTexEnvf", $$robo$$android_opengl_GLLogWrapper$glTexEnvf(int int float ), 0, this, n, n2, f);
    }

    @Override
    public void glTexEnvfv(int n, int n2, float[] fArray, int n3) {
        InvokeDynamicSupport.bootstrap("glTexEnvfv", $$robo$$android_opengl_GLLogWrapper$glTexEnvfv(int int float[] int ), 0, this, n, n2, fArray, n3);
    }

    @Override
    public void glTexEnvfv(int n, int n2, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glTexEnvfv", $$robo$$android_opengl_GLLogWrapper$glTexEnvfv(int int java.nio.FloatBuffer ), 0, this, n, n2, floatBuffer);
    }

    @Override
    public void glTexEnvx(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glTexEnvx", $$robo$$android_opengl_GLLogWrapper$glTexEnvx(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glTexEnvxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glTexEnvxv", $$robo$$android_opengl_GLLogWrapper$glTexEnvxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glTexEnvxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glTexEnvxv", $$robo$$android_opengl_GLLogWrapper$glTexEnvxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glTexImage2D", $$robo$$android_opengl_GLLogWrapper$glTexImage2D(int int int int int int int int java.nio.Buffer ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, buffer);
    }

    @Override
    public void glTexParameterf(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("glTexParameterf", $$robo$$android_opengl_GLLogWrapper$glTexParameterf(int int float ), 0, this, n, n2, f);
    }

    @Override
    public void glTexParameterx(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glTexParameterx", $$robo$$android_opengl_GLLogWrapper$glTexParameterx(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glTexParameteriv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glTexParameteriv", $$robo$$android_opengl_GLLogWrapper$glTexParameteriv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glTexParameteriv", $$robo$$android_opengl_GLLogWrapper$glTexParameteriv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glTexSubImage2D", $$robo$$android_opengl_GLLogWrapper$glTexSubImage2D(int int int int int int int int java.nio.Buffer ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, buffer);
    }

    @Override
    public void glTranslatef(float f, float f2, float f3) {
        InvokeDynamicSupport.bootstrap("glTranslatef", $$robo$$android_opengl_GLLogWrapper$glTranslatef(float float float ), 0, this, f, f2, f3);
    }

    @Override
    public void glTranslatex(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glTranslatex", $$robo$$android_opengl_GLLogWrapper$glTranslatex(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glVertexPointer(int n, int n2, int n3, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glVertexPointer", $$robo$$android_opengl_GLLogWrapper$glVertexPointer(int int int java.nio.Buffer ), 0, this, n, n2, n3, buffer);
    }

    @Override
    public void glViewport(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glViewport", $$robo$$android_opengl_GLLogWrapper$glViewport(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glClipPlanef(int n, float[] fArray, int n2) {
        InvokeDynamicSupport.bootstrap("glClipPlanef", $$robo$$android_opengl_GLLogWrapper$glClipPlanef(int float[] int ), 0, this, n, fArray, n2);
    }

    @Override
    public void glClipPlanef(int n, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glClipPlanef", $$robo$$android_opengl_GLLogWrapper$glClipPlanef(int java.nio.FloatBuffer ), 0, this, n, floatBuffer);
    }

    @Override
    public void glClipPlanex(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glClipPlanex", $$robo$$android_opengl_GLLogWrapper$glClipPlanex(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glClipPlanex(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glClipPlanex", $$robo$$android_opengl_GLLogWrapper$glClipPlanex(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glDrawTexfOES(float f, float f2, float f3, float f4, float f5) {
        InvokeDynamicSupport.bootstrap("glDrawTexfOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexfOES(float float float float float ), 0, this, f, f2, f3, f4, f5);
    }

    @Override
    public void glDrawTexfvOES(float[] fArray, int n) {
        InvokeDynamicSupport.bootstrap("glDrawTexfvOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexfvOES(float[] int ), 0, this, fArray, n);
    }

    @Override
    public void glDrawTexfvOES(FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glDrawTexfvOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexfvOES(java.nio.FloatBuffer ), 0, this, floatBuffer);
    }

    @Override
    public void glDrawTexiOES(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("glDrawTexiOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexiOES(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    @Override
    public void glDrawTexivOES(int[] nArray, int n) {
        InvokeDynamicSupport.bootstrap("glDrawTexivOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexivOES(int[] int ), 0, this, nArray, n);
    }

    @Override
    public void glDrawTexivOES(IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glDrawTexivOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexivOES(java.nio.IntBuffer ), 0, this, intBuffer);
    }

    @Override
    public void glDrawTexsOES(short s, short s2, short s3, short s4, short s5) {
        InvokeDynamicSupport.bootstrap("glDrawTexsOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexsOES(short short short short short ), 0, this, s, s2, s3, s4, s5);
    }

    @Override
    public void glDrawTexsvOES(short[] sArray, int n) {
        InvokeDynamicSupport.bootstrap("glDrawTexsvOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexsvOES(short[] int ), 0, this, sArray, n);
    }

    @Override
    public void glDrawTexsvOES(ShortBuffer shortBuffer) {
        InvokeDynamicSupport.bootstrap("glDrawTexsvOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexsvOES(java.nio.ShortBuffer ), 0, this, shortBuffer);
    }

    @Override
    public void glDrawTexxOES(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("glDrawTexxOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexxOES(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    @Override
    public void glDrawTexxvOES(int[] nArray, int n) {
        InvokeDynamicSupport.bootstrap("glDrawTexxvOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexxvOES(int[] int ), 0, this, nArray, n);
    }

    @Override
    public void glDrawTexxvOES(IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glDrawTexxvOES", $$robo$$android_opengl_GLLogWrapper$glDrawTexxvOES(java.nio.IntBuffer ), 0, this, intBuffer);
    }

    @Override
    public int glQueryMatrixxOES(int[] nArray, int n, int[] nArray2, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("glQueryMatrixxOES", $$robo$$android_opengl_GLLogWrapper$glQueryMatrixxOES(int[] int int[] int ), 0, this, nArray, n, nArray2, n2);
    }

    @Override
    public int glQueryMatrixxOES(IntBuffer intBuffer, IntBuffer intBuffer2) {
        return (int)InvokeDynamicSupport.bootstrap("glQueryMatrixxOES", $$robo$$android_opengl_GLLogWrapper$glQueryMatrixxOES(java.nio.IntBuffer java.nio.IntBuffer ), 0, this, intBuffer, intBuffer2);
    }

    @Override
    public void glBindBuffer(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glBindBuffer", $$robo$$android_opengl_GLLogWrapper$glBindBuffer(int int ), 0, this, n, n2);
    }

    @Override
    public void glBufferData(int n, int n2, Buffer buffer, int n3) {
        InvokeDynamicSupport.bootstrap("glBufferData", $$robo$$android_opengl_GLLogWrapper$glBufferData(int int java.nio.Buffer int ), 0, this, n, n2, buffer, n3);
    }

    @Override
    public void glBufferSubData(int n, int n2, int n3, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glBufferSubData", $$robo$$android_opengl_GLLogWrapper$glBufferSubData(int int int java.nio.Buffer ), 0, this, n, n2, n3, buffer);
    }

    @Override
    public void glColor4ub(byte by, byte by2, byte by3, byte by4) {
        InvokeDynamicSupport.bootstrap("glColor4ub", $$robo$$android_opengl_GLLogWrapper$glColor4ub(byte byte byte byte ), 0, this, by, by2, by3, by4);
    }

    @Override
    public void glDeleteBuffers(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glDeleteBuffers", $$robo$$android_opengl_GLLogWrapper$glDeleteBuffers(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glDeleteBuffers(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glDeleteBuffers", $$robo$$android_opengl_GLLogWrapper$glDeleteBuffers(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glGenBuffers(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGenBuffers", $$robo$$android_opengl_GLLogWrapper$glGenBuffers(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glGenBuffers(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGenBuffers", $$robo$$android_opengl_GLLogWrapper$glGenBuffers(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glGetBooleanv(int n, boolean[] blArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGetBooleanv", $$robo$$android_opengl_GLLogWrapper$glGetBooleanv(int boolean[] int ), 0, this, n, blArray, n2);
    }

    @Override
    public void glGetBooleanv(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetBooleanv", $$robo$$android_opengl_GLLogWrapper$glGetBooleanv(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glGetBufferParameteriv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetBufferParameteriv", $$robo$$android_opengl_GLLogWrapper$glGetBufferParameteriv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetBufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetBufferParameteriv", $$robo$$android_opengl_GLLogWrapper$glGetBufferParameteriv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glGetClipPlanef(int n, float[] fArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGetClipPlanef", $$robo$$android_opengl_GLLogWrapper$glGetClipPlanef(int float[] int ), 0, this, n, fArray, n2);
    }

    @Override
    public void glGetClipPlanef(int n, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glGetClipPlanef", $$robo$$android_opengl_GLLogWrapper$glGetClipPlanef(int java.nio.FloatBuffer ), 0, this, n, floatBuffer);
    }

    @Override
    public void glGetClipPlanex(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGetClipPlanex", $$robo$$android_opengl_GLLogWrapper$glGetClipPlanex(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glGetClipPlanex(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetClipPlanex", $$robo$$android_opengl_GLLogWrapper$glGetClipPlanex(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glGetFixedv(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGetFixedv", $$robo$$android_opengl_GLLogWrapper$glGetFixedv(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glGetFixedv(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetFixedv", $$robo$$android_opengl_GLLogWrapper$glGetFixedv(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glGetFloatv(int n, float[] fArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGetFloatv", $$robo$$android_opengl_GLLogWrapper$glGetFloatv(int float[] int ), 0, this, n, fArray, n2);
    }

    @Override
    public void glGetFloatv(int n, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glGetFloatv", $$robo$$android_opengl_GLLogWrapper$glGetFloatv(int java.nio.FloatBuffer ), 0, this, n, floatBuffer);
    }

    @Override
    public void glGetLightfv(int n, int n2, float[] fArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetLightfv", $$robo$$android_opengl_GLLogWrapper$glGetLightfv(int int float[] int ), 0, this, n, n2, fArray, n3);
    }

    @Override
    public void glGetLightfv(int n, int n2, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glGetLightfv", $$robo$$android_opengl_GLLogWrapper$glGetLightfv(int int java.nio.FloatBuffer ), 0, this, n, n2, floatBuffer);
    }

    @Override
    public void glGetLightxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetLightxv", $$robo$$android_opengl_GLLogWrapper$glGetLightxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetLightxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetLightxv", $$robo$$android_opengl_GLLogWrapper$glGetLightxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glGetMaterialfv(int n, int n2, float[] fArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetMaterialfv", $$robo$$android_opengl_GLLogWrapper$glGetMaterialfv(int int float[] int ), 0, this, n, n2, fArray, n3);
    }

    @Override
    public void glGetMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glGetMaterialfv", $$robo$$android_opengl_GLLogWrapper$glGetMaterialfv(int int java.nio.FloatBuffer ), 0, this, n, n2, floatBuffer);
    }

    @Override
    public void glGetMaterialxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetMaterialxv", $$robo$$android_opengl_GLLogWrapper$glGetMaterialxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetMaterialxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetMaterialxv", $$robo$$android_opengl_GLLogWrapper$glGetMaterialxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glGetTexEnviv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetTexEnviv", $$robo$$android_opengl_GLLogWrapper$glGetTexEnviv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetTexEnviv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetTexEnviv", $$robo$$android_opengl_GLLogWrapper$glGetTexEnviv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glGetTexEnvxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetTexEnvxv", $$robo$$android_opengl_GLLogWrapper$glGetTexEnvxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetTexEnvxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetTexEnvxv", $$robo$$android_opengl_GLLogWrapper$glGetTexEnvxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glGetTexParameterfv(int n, int n2, float[] fArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetTexParameterfv", $$robo$$android_opengl_GLLogWrapper$glGetTexParameterfv(int int float[] int ), 0, this, n, n2, fArray, n3);
    }

    @Override
    public void glGetTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glGetTexParameterfv", $$robo$$android_opengl_GLLogWrapper$glGetTexParameterfv(int int java.nio.FloatBuffer ), 0, this, n, n2, floatBuffer);
    }

    @Override
    public void glGetTexParameteriv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetTexParameteriv", $$robo$$android_opengl_GLLogWrapper$glGetTexParameteriv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetTexParameteriv", $$robo$$android_opengl_GLLogWrapper$glGetTexParameteriv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glGetTexParameterxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetTexParameterxv", $$robo$$android_opengl_GLLogWrapper$glGetTexParameterxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetTexParameterxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetTexParameterxv", $$robo$$android_opengl_GLLogWrapper$glGetTexParameterxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public boolean glIsBuffer(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("glIsBuffer", $$robo$$android_opengl_GLLogWrapper$glIsBuffer(int ), 0, this, n);
    }

    @Override
    public boolean glIsEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("glIsEnabled", $$robo$$android_opengl_GLLogWrapper$glIsEnabled(int ), 0, this, n);
    }

    @Override
    public boolean glIsTexture(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("glIsTexture", $$robo$$android_opengl_GLLogWrapper$glIsTexture(int ), 0, this, n);
    }

    @Override
    public void glPointParameterf(int n, float f) {
        InvokeDynamicSupport.bootstrap("glPointParameterf", $$robo$$android_opengl_GLLogWrapper$glPointParameterf(int float ), 0, this, n, f);
    }

    @Override
    public void glPointParameterfv(int n, float[] fArray, int n2) {
        InvokeDynamicSupport.bootstrap("glPointParameterfv", $$robo$$android_opengl_GLLogWrapper$glPointParameterfv(int float[] int ), 0, this, n, fArray, n2);
    }

    @Override
    public void glPointParameterfv(int n, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glPointParameterfv", $$robo$$android_opengl_GLLogWrapper$glPointParameterfv(int java.nio.FloatBuffer ), 0, this, n, floatBuffer);
    }

    @Override
    public void glPointParameterx(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glPointParameterx", $$robo$$android_opengl_GLLogWrapper$glPointParameterx(int int ), 0, this, n, n2);
    }

    @Override
    public void glPointParameterxv(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glPointParameterxv", $$robo$$android_opengl_GLLogWrapper$glPointParameterxv(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glPointParameterxv(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glPointParameterxv", $$robo$$android_opengl_GLLogWrapper$glPointParameterxv(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glPointSizePointerOES(int n, int n2, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glPointSizePointerOES", $$robo$$android_opengl_GLLogWrapper$glPointSizePointerOES(int int java.nio.Buffer ), 0, this, n, n2, buffer);
    }

    @Override
    public void glTexEnvi(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glTexEnvi", $$robo$$android_opengl_GLLogWrapper$glTexEnvi(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glTexEnviv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glTexEnviv", $$robo$$android_opengl_GLLogWrapper$glTexEnviv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glTexEnviv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glTexEnviv", $$robo$$android_opengl_GLLogWrapper$glTexEnviv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glTexParameterfv(int n, int n2, float[] fArray, int n3) {
        InvokeDynamicSupport.bootstrap("glTexParameterfv", $$robo$$android_opengl_GLLogWrapper$glTexParameterfv(int int float[] int ), 0, this, n, n2, fArray, n3);
    }

    @Override
    public void glTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glTexParameterfv", $$robo$$android_opengl_GLLogWrapper$glTexParameterfv(int int java.nio.FloatBuffer ), 0, this, n, n2, floatBuffer);
    }

    @Override
    public void glTexParameteri(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glTexParameteri", $$robo$$android_opengl_GLLogWrapper$glTexParameteri(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glTexParameterxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glTexParameterxv", $$robo$$android_opengl_GLLogWrapper$glTexParameterxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glTexParameterxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glTexParameterxv", $$robo$$android_opengl_GLLogWrapper$glTexParameterxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glColorPointer(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glColorPointer", $$robo$$android_opengl_GLLogWrapper$glColorPointer(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glDrawElements(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glDrawElements", $$robo$$android_opengl_GLLogWrapper$glDrawElements(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glGetPointerv(int n, Buffer[] bufferArray) {
        InvokeDynamicSupport.bootstrap("glGetPointerv", $$robo$$android_opengl_GLLogWrapper$glGetPointerv(int java.nio.Buffer[] ), 0, this, n, bufferArray);
    }

    @Override
    public void glNormalPointer(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glNormalPointer", $$robo$$android_opengl_GLLogWrapper$glNormalPointer(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glTexCoordPointer(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glTexCoordPointer", $$robo$$android_opengl_GLLogWrapper$glTexCoordPointer(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glVertexPointer(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glVertexPointer", $$robo$$android_opengl_GLLogWrapper$glVertexPointer(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glCurrentPaletteMatrixOES(int n) {
        InvokeDynamicSupport.bootstrap("glCurrentPaletteMatrixOES", $$robo$$android_opengl_GLLogWrapper$glCurrentPaletteMatrixOES(int ), 0, this, n);
    }

    @Override
    public void glLoadPaletteFromModelViewMatrixOES() {
        InvokeDynamicSupport.bootstrap("glLoadPaletteFromModelViewMatrixOES", $$robo$$android_opengl_GLLogWrapper$glLoadPaletteFromModelViewMatrixOES(), 0, this);
    }

    @Override
    public void glMatrixIndexPointerOES(int n, int n2, int n3, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glMatrixIndexPointerOES", $$robo$$android_opengl_GLLogWrapper$glMatrixIndexPointerOES(int int int java.nio.Buffer ), 0, this, n, n2, n3, buffer);
    }

    @Override
    public void glMatrixIndexPointerOES(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glMatrixIndexPointerOES", $$robo$$android_opengl_GLLogWrapper$glMatrixIndexPointerOES(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glWeightPointerOES(int n, int n2, int n3, Buffer buffer) {
        InvokeDynamicSupport.bootstrap("glWeightPointerOES", $$robo$$android_opengl_GLLogWrapper$glWeightPointerOES(int int int java.nio.Buffer ), 0, this, n, n2, n3, buffer);
    }

    @Override
    public void glWeightPointerOES(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glWeightPointerOES", $$robo$$android_opengl_GLLogWrapper$glWeightPointerOES(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glBindFramebufferOES(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glBindFramebufferOES", $$robo$$android_opengl_GLLogWrapper$glBindFramebufferOES(int int ), 0, this, n, n2);
    }

    @Override
    public void glBindRenderbufferOES(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glBindRenderbufferOES", $$robo$$android_opengl_GLLogWrapper$glBindRenderbufferOES(int int ), 0, this, n, n2);
    }

    @Override
    public void glBlendEquation(int n) {
        InvokeDynamicSupport.bootstrap("glBlendEquation", $$robo$$android_opengl_GLLogWrapper$glBlendEquation(int ), 0, this, n);
    }

    @Override
    public void glBlendEquationSeparate(int n, int n2) {
        InvokeDynamicSupport.bootstrap("glBlendEquationSeparate", $$robo$$android_opengl_GLLogWrapper$glBlendEquationSeparate(int int ), 0, this, n, n2);
    }

    @Override
    public void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glBlendFuncSeparate", $$robo$$android_opengl_GLLogWrapper$glBlendFuncSeparate(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public int glCheckFramebufferStatusOES(int n) {
        return (int)InvokeDynamicSupport.bootstrap("glCheckFramebufferStatusOES", $$robo$$android_opengl_GLLogWrapper$glCheckFramebufferStatusOES(int ), 0, this, n);
    }

    @Override
    public void glDeleteFramebuffersOES(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glDeleteFramebuffersOES", $$robo$$android_opengl_GLLogWrapper$glDeleteFramebuffersOES(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glDeleteFramebuffersOES(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glDeleteFramebuffersOES", $$robo$$android_opengl_GLLogWrapper$glDeleteFramebuffersOES(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glDeleteRenderbuffersOES(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glDeleteRenderbuffersOES", $$robo$$android_opengl_GLLogWrapper$glDeleteRenderbuffersOES(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glDeleteRenderbuffersOES(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glDeleteRenderbuffersOES", $$robo$$android_opengl_GLLogWrapper$glDeleteRenderbuffersOES(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glFramebufferRenderbufferOES(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glFramebufferRenderbufferOES", $$robo$$android_opengl_GLLogWrapper$glFramebufferRenderbufferOES(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glFramebufferTexture2DOES(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("glFramebufferTexture2DOES", $$robo$$android_opengl_GLLogWrapper$glFramebufferTexture2DOES(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    @Override
    public void glGenerateMipmapOES(int n) {
        InvokeDynamicSupport.bootstrap("glGenerateMipmapOES", $$robo$$android_opengl_GLLogWrapper$glGenerateMipmapOES(int ), 0, this, n);
    }

    @Override
    public void glGenFramebuffersOES(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGenFramebuffersOES", $$robo$$android_opengl_GLLogWrapper$glGenFramebuffersOES(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glGenFramebuffersOES(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGenFramebuffersOES", $$robo$$android_opengl_GLLogWrapper$glGenFramebuffersOES(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glGenRenderbuffersOES(int n, int[] nArray, int n2) {
        InvokeDynamicSupport.bootstrap("glGenRenderbuffersOES", $$robo$$android_opengl_GLLogWrapper$glGenRenderbuffersOES(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public void glGenRenderbuffersOES(int n, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGenRenderbuffersOES", $$robo$$android_opengl_GLLogWrapper$glGenRenderbuffersOES(int java.nio.IntBuffer ), 0, this, n, intBuffer);
    }

    @Override
    public void glGetFramebufferAttachmentParameterivOES(int n, int n2, int n3, int[] nArray, int n4) {
        InvokeDynamicSupport.bootstrap("glGetFramebufferAttachmentParameterivOES", $$robo$$android_opengl_GLLogWrapper$glGetFramebufferAttachmentParameterivOES(int int int int[] int ), 0, this, n, n2, n3, nArray, n4);
    }

    @Override
    public void glGetFramebufferAttachmentParameterivOES(int n, int n2, int n3, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetFramebufferAttachmentParameterivOES", $$robo$$android_opengl_GLLogWrapper$glGetFramebufferAttachmentParameterivOES(int int int java.nio.IntBuffer ), 0, this, n, n2, n3, intBuffer);
    }

    @Override
    public void glGetRenderbufferParameterivOES(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetRenderbufferParameterivOES", $$robo$$android_opengl_GLLogWrapper$glGetRenderbufferParameterivOES(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetRenderbufferParameterivOES(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetRenderbufferParameterivOES", $$robo$$android_opengl_GLLogWrapper$glGetRenderbufferParameterivOES(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glGetTexGenfv(int n, int n2, float[] fArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetTexGenfv", $$robo$$android_opengl_GLLogWrapper$glGetTexGenfv(int int float[] int ), 0, this, n, n2, fArray, n3);
    }

    @Override
    public void glGetTexGenfv(int n, int n2, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glGetTexGenfv", $$robo$$android_opengl_GLLogWrapper$glGetTexGenfv(int int java.nio.FloatBuffer ), 0, this, n, n2, floatBuffer);
    }

    @Override
    public void glGetTexGeniv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetTexGeniv", $$robo$$android_opengl_GLLogWrapper$glGetTexGeniv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetTexGeniv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetTexGeniv", $$robo$$android_opengl_GLLogWrapper$glGetTexGeniv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glGetTexGenxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glGetTexGenxv", $$robo$$android_opengl_GLLogWrapper$glGetTexGenxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glGetTexGenxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glGetTexGenxv", $$robo$$android_opengl_GLLogWrapper$glGetTexGenxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public boolean glIsFramebufferOES(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("glIsFramebufferOES", $$robo$$android_opengl_GLLogWrapper$glIsFramebufferOES(int ), 0, this, n);
    }

    @Override
    public boolean glIsRenderbufferOES(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("glIsRenderbufferOES", $$robo$$android_opengl_GLLogWrapper$glIsRenderbufferOES(int ), 0, this, n);
    }

    @Override
    public void glRenderbufferStorageOES(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("glRenderbufferStorageOES", $$robo$$android_opengl_GLLogWrapper$glRenderbufferStorageOES(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void glTexGenf(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("glTexGenf", $$robo$$android_opengl_GLLogWrapper$glTexGenf(int int float ), 0, this, n, n2, f);
    }

    @Override
    public void glTexGenfv(int n, int n2, float[] fArray, int n3) {
        InvokeDynamicSupport.bootstrap("glTexGenfv", $$robo$$android_opengl_GLLogWrapper$glTexGenfv(int int float[] int ), 0, this, n, n2, fArray, n3);
    }

    @Override
    public void glTexGenfv(int n, int n2, FloatBuffer floatBuffer) {
        InvokeDynamicSupport.bootstrap("glTexGenfv", $$robo$$android_opengl_GLLogWrapper$glTexGenfv(int int java.nio.FloatBuffer ), 0, this, n, n2, floatBuffer);
    }

    @Override
    public void glTexGeni(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glTexGeni", $$robo$$android_opengl_GLLogWrapper$glTexGeni(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glTexGeniv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glTexGeniv", $$robo$$android_opengl_GLLogWrapper$glTexGeniv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glTexGeniv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glTexGeniv", $$robo$$android_opengl_GLLogWrapper$glTexGeniv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    @Override
    public void glTexGenx(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("glTexGenx", $$robo$$android_opengl_GLLogWrapper$glTexGenx(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void glTexGenxv(int n, int n2, int[] nArray, int n3) {
        InvokeDynamicSupport.bootstrap("glTexGenxv", $$robo$$android_opengl_GLLogWrapper$glTexGenxv(int int int[] int ), 0, this, n, n2, nArray, n3);
    }

    @Override
    public void glTexGenxv(int n, int n2, IntBuffer intBuffer) {
        InvokeDynamicSupport.bootstrap("glTexGenxv", $$robo$$android_opengl_GLLogWrapper$glTexGenxv(int int java.nio.IntBuffer ), 0, this, n, n2, intBuffer);
    }

    public /* synthetic */ GLLogWrapper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GLLogWrapper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PointerInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int mSize;
        public int mType;
        public int mStride;
        public Buffer mPointer;
        public ByteBuffer mTempByteBuffer;
        /* synthetic */ GLLogWrapper this$0;

        private void $$robo$$android_opengl_GLLogWrapper_PointerInfo$__constructor__(GLLogWrapper gLLogWrapper) {
        }

        private void $$robo$$android_opengl_GLLogWrapper_PointerInfo$__constructor__(GLLogWrapper gLLogWrapper, int size, int type, int stride, Buffer pointer) {
            this.mSize = size;
            this.mType = type;
            this.mStride = stride;
            this.mPointer = pointer;
        }

        private final int $$robo$$android_opengl_GLLogWrapper_PointerInfo$sizeof(int type) {
            switch (type) {
                case 5121: {
                    return 1;
                }
                case 5120: {
                    return 1;
                }
                case 5122: {
                    return 2;
                }
                case 5132: {
                    return 4;
                }
                case 5126: {
                    return 4;
                }
            }
            return 0;
        }

        private final int $$robo$$android_opengl_GLLogWrapper_PointerInfo$getStride() {
            return this.mStride > 0 ? this.mStride : this.sizeof(this.mType) * this.mSize;
        }

        private final void $$robo$$android_opengl_GLLogWrapper_PointerInfo$bindByteBuffer() {
            this.mTempByteBuffer = this.mPointer == null ? null : this.this$0.toByteBuffer(-1, this.mPointer);
        }

        private final void $$robo$$android_opengl_GLLogWrapper_PointerInfo$unbindByteBuffer() {
            this.mTempByteBuffer = null;
        }

        private void __constructor__(GLLogWrapper gLLogWrapper) {
            this.$$robo$$android_opengl_GLLogWrapper_PointerInfo$__constructor__(gLLogWrapper);
        }

        public PointerInfo(GLLogWrapper gLLogWrapper) {
            this.this$0 = gLLogWrapper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLLogWrapper_PointerInfo$__constructor__(android.opengl.GLLogWrapper ), 0, this, gLLogWrapper);
        }

        private void __constructor__(GLLogWrapper gLLogWrapper, int n, int n2, int n3, Buffer buffer) {
            this.$$robo$$android_opengl_GLLogWrapper_PointerInfo$__constructor__(gLLogWrapper, n, n2, n3, buffer);
        }

        public PointerInfo(GLLogWrapper gLLogWrapper, int n, int n2, int n3, Buffer buffer) {
            this.this$0 = gLLogWrapper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLLogWrapper_PointerInfo$__constructor__(android.opengl.GLLogWrapper int int int java.nio.Buffer ), 0, this, gLLogWrapper, n, n2, n3, buffer);
        }

        public int sizeof(int n) {
            return (int)InvokeDynamicSupport.bootstrap("sizeof", $$robo$$android_opengl_GLLogWrapper_PointerInfo$sizeof(int ), 0, this, n);
        }

        public int getStride() {
            return (int)InvokeDynamicSupport.bootstrap("getStride", $$robo$$android_opengl_GLLogWrapper_PointerInfo$getStride(), 0, this);
        }

        public void bindByteBuffer() {
            InvokeDynamicSupport.bootstrap("bindByteBuffer", $$robo$$android_opengl_GLLogWrapper_PointerInfo$bindByteBuffer(), 0, this);
        }

        public void unbindByteBuffer() {
            InvokeDynamicSupport.bootstrap("unbindByteBuffer", $$robo$$android_opengl_GLLogWrapper_PointerInfo$unbindByteBuffer(), 0, this);
        }

        public /* synthetic */ PointerInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointerInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

