/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Environment
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Environment";
    private static String ENV_EXTERNAL_STORAGE = "EXTERNAL_STORAGE";
    private static String ENV_ANDROID_ROOT = "ANDROID_ROOT";
    private static String ENV_ANDROID_DATA = "ANDROID_DATA";
    private static String ENV_ANDROID_EXPAND = "ANDROID_EXPAND";
    private static String ENV_ANDROID_STORAGE = "ANDROID_STORAGE";
    private static String ENV_DOWNLOAD_CACHE = "DOWNLOAD_CACHE";
    private static String ENV_OEM_ROOT = "OEM_ROOT";
    private static String ENV_ODM_ROOT = "ODM_ROOT";
    private static String ENV_VENDOR_ROOT = "VENDOR_ROOT";
    public static String DIR_ANDROID = "Android";
    private static String DIR_DATA = "data";
    private static String DIR_MEDIA = "media";
    private static String DIR_OBB = "obb";
    private static String DIR_FILES = "files";
    private static String DIR_CACHE = "cache";
    @Deprecated
    public static String DIRECTORY_ANDROID = "Android";
    private static File DIR_ANDROID_ROOT;
    private static File DIR_ANDROID_DATA;
    private static File DIR_ANDROID_EXPAND;
    private static File DIR_ANDROID_STORAGE;
    private static File DIR_DOWNLOAD_CACHE;
    private static File DIR_OEM_ROOT;
    private static File DIR_ODM_ROOT;
    private static File DIR_VENDOR_ROOT;
    private static UserEnvironment sCurrentUser;
    private static boolean sUserRequired;
    public static String DIRECTORY_MUSIC;
    public static String DIRECTORY_PODCASTS;
    public static String DIRECTORY_RINGTONES;
    public static String DIRECTORY_ALARMS;
    public static String DIRECTORY_NOTIFICATIONS;
    public static String DIRECTORY_PICTURES;
    public static String DIRECTORY_MOVIES;
    public static String DIRECTORY_DOWNLOADS;
    public static String DIRECTORY_DCIM;
    public static String DIRECTORY_DOCUMENTS;
    public static String[] STANDARD_DIRECTORIES;
    public static String MEDIA_UNKNOWN = "unknown";
    public static String MEDIA_REMOVED = "removed";
    public static String MEDIA_UNMOUNTED = "unmounted";
    public static String MEDIA_CHECKING = "checking";
    public static String MEDIA_NOFS = "nofs";
    public static String MEDIA_MOUNTED = "mounted";
    public static String MEDIA_MOUNTED_READ_ONLY = "mounted_ro";
    public static String MEDIA_SHARED = "shared";
    public static String MEDIA_BAD_REMOVAL = "bad_removal";
    public static String MEDIA_UNMOUNTABLE = "unmountable";
    public static String MEDIA_EJECTING = "ejecting";

    private void $$robo$$android_os_Environment$__constructor__() {
    }

    private static final void $$robo$$android_os_Environment$initForCurrentUser() {
        int userId = UserHandle.myUserId();
        sCurrentUser = new UserEnvironment(userId);
    }

    private static final File $$robo$$android_os_Environment$getRootDirectory() {
        return DIR_ANDROID_ROOT;
    }

    private static final File $$robo$$android_os_Environment$getStorageDirectory() {
        return DIR_ANDROID_STORAGE;
    }

    private static final File $$robo$$android_os_Environment$getOemDirectory() {
        return DIR_OEM_ROOT;
    }

    private static final File $$robo$$android_os_Environment$getOdmDirectory() {
        return DIR_ODM_ROOT;
    }

    private static final File $$robo$$android_os_Environment$getVendorDirectory() {
        return DIR_VENDOR_ROOT;
    }

    @Deprecated
    private static final File $$robo$$android_os_Environment$getUserSystemDirectory(int userId) {
        return new File(new File(Environment.getDataSystemDirectory(), "users"), Integer.toString(userId));
    }

    @Deprecated
    private static final File $$robo$$android_os_Environment$getUserConfigDirectory(int userId) {
        return new File(new File(new File(Environment.getDataDirectory(), "misc"), "user"), Integer.toString(userId));
    }

    private static final File $$robo$$android_os_Environment$getDataDirectory() {
        return DIR_ANDROID_DATA;
    }

    private static final File $$robo$$android_os_Environment$getDataDirectory(String volumeUuid) {
        if (TextUtils.isEmpty(volumeUuid)) {
            return DIR_ANDROID_DATA;
        }
        return new File("/mnt/expand/" + volumeUuid);
    }

    private static final File $$robo$$android_os_Environment$getExpandDirectory() {
        return DIR_ANDROID_EXPAND;
    }

    private static final File $$robo$$android_os_Environment$getDataSystemDirectory() {
        return new File(Environment.getDataDirectory(), "system");
    }

    private static final File $$robo$$android_os_Environment$getDataSystemDeDirectory() {
        return Environment.buildPath(Environment.getDataDirectory(), "system_de");
    }

    private static final File $$robo$$android_os_Environment$getDataSystemCeDirectory() {
        return Environment.buildPath(Environment.getDataDirectory(), "system_ce");
    }

    private static final File $$robo$$android_os_Environment$getDataSystemCeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "system_ce", String.valueOf(userId));
    }

    private static final File $$robo$$android_os_Environment$getDataSystemDeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "system_de", String.valueOf(userId));
    }

    private static final File $$robo$$android_os_Environment$getDataMiscDirectory() {
        return new File(Environment.getDataDirectory(), "misc");
    }

    private static final File $$robo$$android_os_Environment$getDataMiscCeDirectory() {
        return Environment.buildPath(Environment.getDataDirectory(), "misc_ce");
    }

    private static final File $$robo$$android_os_Environment$getDataMiscCeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "misc_ce", String.valueOf(userId));
    }

    private static final File $$robo$$android_os_Environment$getDataMiscDeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "misc_de", String.valueOf(userId));
    }

    private static final File $$robo$$android_os_Environment$getDataProfilesDeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "misc", "profiles", "cur", String.valueOf(userId));
    }

    private static final File $$robo$$android_os_Environment$getReferenceProfile(String packageName) {
        return Environment.buildPath(Environment.getDataDirectory(), "misc", "profiles", "ref", packageName);
    }

    private static final File $$robo$$android_os_Environment$getDataProfilesDePackageDirectory(int userId, String packageName) {
        return Environment.buildPath(Environment.getDataProfilesDeDirectory(userId), packageName);
    }

    private static final File $$robo$$android_os_Environment$getDataAppDirectory(String volumeUuid) {
        return new File(Environment.getDataDirectory(volumeUuid), "app");
    }

    private static final File $$robo$$android_os_Environment$getDataUserCeDirectory(String volumeUuid) {
        return new File(Environment.getDataDirectory(volumeUuid), "user");
    }

    private static final File $$robo$$android_os_Environment$getDataUserCeDirectory(String volumeUuid, int userId) {
        return new File(Environment.getDataUserCeDirectory(volumeUuid), String.valueOf(userId));
    }

    private static final File $$robo$$android_os_Environment$getDataUserCePackageDirectory(String volumeUuid, int userId, String packageName) {
        return new File(Environment.getDataUserCeDirectory(volumeUuid, userId), packageName);
    }

    private static final File $$robo$$android_os_Environment$getDataUserDeDirectory(String volumeUuid) {
        return new File(Environment.getDataDirectory(volumeUuid), "user_de");
    }

    private static final File $$robo$$android_os_Environment$getDataUserDeDirectory(String volumeUuid, int userId) {
        return new File(Environment.getDataUserDeDirectory(volumeUuid), String.valueOf(userId));
    }

    private static final File $$robo$$android_os_Environment$getDataUserDePackageDirectory(String volumeUuid, int userId, String packageName) {
        return new File(Environment.getDataUserDeDirectory(volumeUuid, userId), packageName);
    }

    private static final File $$robo$$android_os_Environment$getDataPreloadsDirectory() {
        return new File(Environment.getDataDirectory(), "preloads");
    }

    private static final File $$robo$$android_os_Environment$getDataPreloadsDemoDirectory() {
        return new File(Environment.getDataPreloadsDirectory(), "demo");
    }

    private static final File $$robo$$android_os_Environment$getDataPreloadsAppsDirectory() {
        return new File(Environment.getDataPreloadsDirectory(), "apps");
    }

    private static final File $$robo$$android_os_Environment$getDataPreloadsMediaDirectory() {
        return new File(Environment.getDataPreloadsDirectory(), "media");
    }

    private static final File $$robo$$android_os_Environment$getDataPreloadsFileCacheDirectory(String packageName) {
        return new File(Environment.getDataPreloadsFileCacheDirectory(), packageName);
    }

    private static final File $$robo$$android_os_Environment$getDataPreloadsFileCacheDirectory() {
        return new File(Environment.getDataPreloadsDirectory(), "file_cache");
    }

    private static final File $$robo$$android_os_Environment$getExternalStorageDirectory() {
        Environment.throwIfUserRequired();
        return sCurrentUser.getExternalDirs()[0];
    }

    private static final File $$robo$$android_os_Environment$getLegacyExternalStorageDirectory() {
        return new File(System.getenv("EXTERNAL_STORAGE"));
    }

    private static final File $$robo$$android_os_Environment$getLegacyExternalStorageObbDirectory() {
        return Environment.buildPath(Environment.getLegacyExternalStorageDirectory(), "Android", "obb");
    }

    private static final boolean $$robo$$android_os_Environment$isStandardDirectory(String dir) {
        for (String valid : STANDARD_DIRECTORIES) {
            if (!valid.equals(dir)) continue;
            return true;
        }
        return false;
    }

    private static final File $$robo$$android_os_Environment$getExternalStoragePublicDirectory(String type) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStoragePublicDirs(type)[0];
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAndroidDataDirs() {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAndroidDataDirs();
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppDataDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppDataDirs(packageName);
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppMediaDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppMediaDirs(packageName);
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppObbDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppObbDirs(packageName);
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppFilesDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppFilesDirs(packageName);
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppCacheDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppCacheDirs(packageName);
    }

    private static final File $$robo$$android_os_Environment$getDownloadCacheDirectory() {
        return DIR_DOWNLOAD_CACHE;
    }

    private static final String $$robo$$android_os_Environment$getExternalStorageState() {
        File externalDir = sCurrentUser.getExternalDirs()[0];
        return Environment.getExternalStorageState(externalDir);
    }

    @Deprecated
    private static final String $$robo$$android_os_Environment$getStorageState(File path) {
        return Environment.getExternalStorageState(path);
    }

    private static final String $$robo$$android_os_Environment$getExternalStorageState(File path) {
        StorageVolume volume = StorageManager.getStorageVolume(path, UserHandle.myUserId());
        if (volume != null) {
            return volume.getState();
        }
        return "unknown";
    }

    private static final boolean $$robo$$android_os_Environment$isExternalStorageRemovable() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        File externalDir = sCurrentUser.getExternalDirs()[0];
        return Environment.isExternalStorageRemovable(externalDir);
    }

    private static final boolean $$robo$$android_os_Environment$isExternalStorageRemovable(File path) {
        StorageVolume volume = StorageManager.getStorageVolume(path, UserHandle.myUserId());
        if (volume != null) {
            return volume.isRemovable();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    private static final boolean $$robo$$android_os_Environment$isExternalStorageEmulated() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        File externalDir = sCurrentUser.getExternalDirs()[0];
        return Environment.isExternalStorageEmulated(externalDir);
    }

    private static final boolean $$robo$$android_os_Environment$isExternalStorageEmulated(File path) {
        StorageVolume volume = StorageManager.getStorageVolume(path, UserHandle.myUserId());
        if (volume != null) {
            return volume.isEmulated();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    private static final File $$robo$$android_os_Environment$getDirectory(String variableName, String defaultPath) {
        String path = System.getenv(variableName);
        return path == null ? new File(defaultPath) : new File(path);
    }

    private static final void $$robo$$android_os_Environment$setUserRequired(boolean userRequired) {
        sUserRequired = userRequired;
    }

    private static final void $$robo$$android_os_Environment$throwIfUserRequired() {
        if (sUserRequired) {
            Log.wtf("Environment", "Path requests must specify a user by using UserEnvironment", new Throwable());
        }
    }

    private static final File[] $$robo$$android_os_Environment$buildPaths(File[] base, String ... segments) {
        File[] result = new File[base.length];
        for (int i = 0; i < base.length; ++i) {
            result[i] = Environment.buildPath(base[i], segments);
        }
        return result;
    }

    private static final File $$robo$$android_os_Environment$buildPath(File base, String ... segments) {
        File cur = base;
        for (String segment : segments) {
            cur = cur == null ? new File(segment) : new File(cur, segment);
        }
        return cur;
    }

    private static final boolean $$robo$$android_os_Environment$isStorageDisabled() {
        return SystemProperties.getBoolean("config.disable_storage", false);
    }

    private static final File $$robo$$android_os_Environment$maybeTranslateEmulatedPathToInternal(File path) {
        return StorageManager.maybeTranslateEmulatedPathToInternal(path);
    }

    static void __staticInitializer__() {
        DIR_ANDROID_ROOT = Environment.getDirectory("ANDROID_ROOT", "/system");
        DIR_ANDROID_DATA = Environment.getDirectory("ANDROID_DATA", "/data");
        DIR_ANDROID_EXPAND = Environment.getDirectory("ANDROID_EXPAND", "/mnt/expand");
        DIR_ANDROID_STORAGE = Environment.getDirectory("ANDROID_STORAGE", "/storage");
        DIR_DOWNLOAD_CACHE = Environment.getDirectory("DOWNLOAD_CACHE", "/cache");
        DIR_OEM_ROOT = Environment.getDirectory("OEM_ROOT", "/oem");
        DIR_ODM_ROOT = Environment.getDirectory("ODM_ROOT", "/odm");
        DIR_VENDOR_ROOT = Environment.getDirectory("VENDOR_ROOT", "/vendor");
        Environment.initForCurrentUser();
        DIRECTORY_MUSIC = "Music";
        DIRECTORY_PODCASTS = "Podcasts";
        DIRECTORY_RINGTONES = "Ringtones";
        DIRECTORY_ALARMS = "Alarms";
        DIRECTORY_NOTIFICATIONS = "Notifications";
        DIRECTORY_PICTURES = "Pictures";
        DIRECTORY_MOVIES = "Movies";
        DIRECTORY_DOWNLOADS = "Download";
        DIRECTORY_DCIM = "DCIM";
        DIRECTORY_DOCUMENTS = "Documents";
        STANDARD_DIRECTORIES = new String[]{DIRECTORY_MUSIC, DIRECTORY_PODCASTS, DIRECTORY_RINGTONES, DIRECTORY_ALARMS, DIRECTORY_NOTIFICATIONS, DIRECTORY_PICTURES, DIRECTORY_MOVIES, DIRECTORY_DOWNLOADS, DIRECTORY_DCIM, DIRECTORY_DOCUMENTS};
    }

    private void __constructor__() {
        this.$$robo$$android_os_Environment$__constructor__();
    }

    public Environment() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Environment$__constructor__(), 0, this);
    }

    public static void initForCurrentUser() {
        InvokeDynamicSupport.bootstrapStatic("initForCurrentUser", $$robo$$android_os_Environment$initForCurrentUser(), 0);
    }

    public static File getRootDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getRootDirectory", $$robo$$android_os_Environment$getRootDirectory(), 0);
    }

    public static File getStorageDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getStorageDirectory", $$robo$$android_os_Environment$getStorageDirectory(), 0);
    }

    public static File getOemDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getOemDirectory", $$robo$$android_os_Environment$getOemDirectory(), 0);
    }

    public static File getOdmDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getOdmDirectory", $$robo$$android_os_Environment$getOdmDirectory(), 0);
    }

    public static File getVendorDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getVendorDirectory", $$robo$$android_os_Environment$getVendorDirectory(), 0);
    }

    @Deprecated
    public static File getUserSystemDirectory(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getUserSystemDirectory", $$robo$$android_os_Environment$getUserSystemDirectory(int ), 0, (int)n);
    }

    @Deprecated
    public static File getUserConfigDirectory(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getUserConfigDirectory", $$robo$$android_os_Environment$getUserConfigDirectory(int ), 0, (int)n);
    }

    public static File getDataDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataDirectory", $$robo$$android_os_Environment$getDataDirectory(), 0);
    }

    public static File getDataDirectory(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDataDirectory", $$robo$$android_os_Environment$getDataDirectory(java.lang.String ), 0, (String)string2);
    }

    public static File getExpandDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getExpandDirectory", $$robo$$android_os_Environment$getExpandDirectory(), 0);
    }

    public static File getDataSystemDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataSystemDirectory", $$robo$$android_os_Environment$getDataSystemDirectory(), 0);
    }

    public static File getDataSystemDeDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataSystemDeDirectory", $$robo$$android_os_Environment$getDataSystemDeDirectory(), 0);
    }

    public static File getDataSystemCeDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataSystemCeDirectory", $$robo$$android_os_Environment$getDataSystemCeDirectory(), 0);
    }

    public static File getDataSystemCeDirectory(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDataSystemCeDirectory", $$robo$$android_os_Environment$getDataSystemCeDirectory(int ), 0, (int)n);
    }

    public static File getDataSystemDeDirectory(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDataSystemDeDirectory", $$robo$$android_os_Environment$getDataSystemDeDirectory(int ), 0, (int)n);
    }

    public static File getDataMiscDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataMiscDirectory", $$robo$$android_os_Environment$getDataMiscDirectory(), 0);
    }

    public static File getDataMiscCeDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataMiscCeDirectory", $$robo$$android_os_Environment$getDataMiscCeDirectory(), 0);
    }

    public static File getDataMiscCeDirectory(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDataMiscCeDirectory", $$robo$$android_os_Environment$getDataMiscCeDirectory(int ), 0, (int)n);
    }

    public static File getDataMiscDeDirectory(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDataMiscDeDirectory", $$robo$$android_os_Environment$getDataMiscDeDirectory(int ), 0, (int)n);
    }

    private static File getDataProfilesDeDirectory(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDataProfilesDeDirectory", $$robo$$android_os_Environment$getDataProfilesDeDirectory(int ), 0, (int)n);
    }

    public static File getReferenceProfile(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getReferenceProfile", $$robo$$android_os_Environment$getReferenceProfile(java.lang.String ), 0, (String)string2);
    }

    public static File getDataProfilesDePackageDirectory(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDataProfilesDePackageDirectory", $$robo$$android_os_Environment$getDataProfilesDePackageDirectory(int java.lang.String ), 0, (int)n, (String)string2);
    }

    public static File getDataAppDirectory(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDataAppDirectory", $$robo$$android_os_Environment$getDataAppDirectory(java.lang.String ), 0, (String)string2);
    }

    public static File getDataUserCeDirectory(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDataUserCeDirectory", $$robo$$android_os_Environment$getDataUserCeDirectory(java.lang.String ), 0, (String)string2);
    }

    public static File getDataUserCeDirectory(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDataUserCeDirectory", $$robo$$android_os_Environment$getDataUserCeDirectory(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static File getDataUserCePackageDirectory(String string2, int n, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDataUserCePackageDirectory", $$robo$$android_os_Environment$getDataUserCePackageDirectory(java.lang.String int java.lang.String ), 0, (String)string2, (int)n, (String)string3);
    }

    public static File getDataUserDeDirectory(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDataUserDeDirectory", $$robo$$android_os_Environment$getDataUserDeDirectory(java.lang.String ), 0, (String)string2);
    }

    public static File getDataUserDeDirectory(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDataUserDeDirectory", $$robo$$android_os_Environment$getDataUserDeDirectory(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static File getDataUserDePackageDirectory(String string2, int n, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDataUserDePackageDirectory", $$robo$$android_os_Environment$getDataUserDePackageDirectory(java.lang.String int java.lang.String ), 0, (String)string2, (int)n, (String)string3);
    }

    public static File getDataPreloadsDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataPreloadsDirectory", $$robo$$android_os_Environment$getDataPreloadsDirectory(), 0);
    }

    public static File getDataPreloadsDemoDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataPreloadsDemoDirectory", $$robo$$android_os_Environment$getDataPreloadsDemoDirectory(), 0);
    }

    public static File getDataPreloadsAppsDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataPreloadsAppsDirectory", $$robo$$android_os_Environment$getDataPreloadsAppsDirectory(), 0);
    }

    public static File getDataPreloadsMediaDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataPreloadsMediaDirectory", $$robo$$android_os_Environment$getDataPreloadsMediaDirectory(), 0);
    }

    public static File getDataPreloadsFileCacheDirectory(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDataPreloadsFileCacheDirectory", $$robo$$android_os_Environment$getDataPreloadsFileCacheDirectory(java.lang.String ), 0, (String)string2);
    }

    public static File getDataPreloadsFileCacheDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataPreloadsFileCacheDirectory", $$robo$$android_os_Environment$getDataPreloadsFileCacheDirectory(), 0);
    }

    public static File getExternalStorageDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getExternalStorageDirectory", $$robo$$android_os_Environment$getExternalStorageDirectory(), 0);
    }

    public static File getLegacyExternalStorageDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getLegacyExternalStorageDirectory", $$robo$$android_os_Environment$getLegacyExternalStorageDirectory(), 0);
    }

    public static File getLegacyExternalStorageObbDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getLegacyExternalStorageObbDirectory", $$robo$$android_os_Environment$getLegacyExternalStorageObbDirectory(), 0);
    }

    public static boolean isStandardDirectory(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStandardDirectory", $$robo$$android_os_Environment$isStandardDirectory(java.lang.String ), 0, (String)string2);
    }

    public static File getExternalStoragePublicDirectory(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getExternalStoragePublicDirectory", $$robo$$android_os_Environment$getExternalStoragePublicDirectory(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAndroidDataDirs() {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAndroidDataDirs", $$robo$$android_os_Environment$buildExternalStorageAndroidDataDirs(), 0);
    }

    public static File[] buildExternalStorageAppDataDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppDataDirs", $$robo$$android_os_Environment$buildExternalStorageAppDataDirs(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAppMediaDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppMediaDirs", $$robo$$android_os_Environment$buildExternalStorageAppMediaDirs(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAppObbDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppObbDirs", $$robo$$android_os_Environment$buildExternalStorageAppObbDirs(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAppFilesDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppFilesDirs", $$robo$$android_os_Environment$buildExternalStorageAppFilesDirs(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAppCacheDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppCacheDirs", $$robo$$android_os_Environment$buildExternalStorageAppCacheDirs(java.lang.String ), 0, (String)string2);
    }

    public static File getDownloadCacheDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDownloadCacheDirectory", $$robo$$android_os_Environment$getDownloadCacheDirectory(), 0);
    }

    public static String getExternalStorageState() {
        return InvokeDynamicSupport.bootstrapStatic("getExternalStorageState", $$robo$$android_os_Environment$getExternalStorageState(), 0);
    }

    @Deprecated
    public static String getStorageState(File file) {
        return InvokeDynamicSupport.bootstrapStatic("getStorageState", $$robo$$android_os_Environment$getStorageState(java.io.File ), 0, (File)file);
    }

    public static String getExternalStorageState(File file) {
        return InvokeDynamicSupport.bootstrapStatic("getExternalStorageState", $$robo$$android_os_Environment$getExternalStorageState(java.io.File ), 0, (File)file);
    }

    public static boolean isExternalStorageRemovable() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExternalStorageRemovable", $$robo$$android_os_Environment$isExternalStorageRemovable(), 0);
    }

    public static boolean isExternalStorageRemovable(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExternalStorageRemovable", $$robo$$android_os_Environment$isExternalStorageRemovable(java.io.File ), 0, (File)file);
    }

    public static boolean isExternalStorageEmulated() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExternalStorageEmulated", $$robo$$android_os_Environment$isExternalStorageEmulated(), 0);
    }

    public static boolean isExternalStorageEmulated(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExternalStorageEmulated", $$robo$$android_os_Environment$isExternalStorageEmulated(java.io.File ), 0, (File)file);
    }

    static File getDirectory(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDirectory", $$robo$$android_os_Environment$getDirectory(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static void setUserRequired(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setUserRequired", $$robo$$android_os_Environment$setUserRequired(boolean ), 0, (boolean)bl);
    }

    private static void throwIfUserRequired() {
        InvokeDynamicSupport.bootstrapStatic("throwIfUserRequired", $$robo$$android_os_Environment$throwIfUserRequired(), 0);
    }

    public static File[] buildPaths(File[] fileArray, String ... stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildPaths", $$robo$$android_os_Environment$buildPaths(java.io.File[] java.lang.String[] ), 0, (File[])fileArray, (String[])stringArray);
    }

    public static File buildPath(File file, String ... stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildPath", $$robo$$android_os_Environment$buildPath(java.io.File java.lang.String[] ), 0, (File)file, (String[])stringArray);
    }

    private static boolean isStorageDisabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStorageDisabled", $$robo$$android_os_Environment$isStorageDisabled(), 0);
    }

    public static File maybeTranslateEmulatedPathToInternal(File file) {
        return InvokeDynamicSupport.bootstrapStatic("maybeTranslateEmulatedPathToInternal", $$robo$$android_os_Environment$maybeTranslateEmulatedPathToInternal(java.io.File ), 0, (File)file);
    }

    static {
        RobolectricInternals.classInitializing(Environment.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Environment)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class UserEnvironment
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mUserId;

        private void $$robo$$android_os_Environment_UserEnvironment$__constructor__(int userId) {
            this.mUserId = userId;
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$getExternalDirs() {
            StorageVolume[] volumes = StorageManager.getVolumeList(this.mUserId, 256);
            File[] files = new File[volumes.length];
            for (int i = 0; i < volumes.length; ++i) {
                files[i] = volumes[i].getPathFile();
            }
            return files;
        }

        @Deprecated
        private final File $$robo$$android_os_Environment_UserEnvironment$getExternalStorageDirectory() {
            return this.getExternalDirs()[0];
        }

        @Deprecated
        private final File $$robo$$android_os_Environment_UserEnvironment$getExternalStoragePublicDirectory(String type) {
            return this.buildExternalStoragePublicDirs(type)[0];
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStoragePublicDirs(String type) {
            return Environment.buildPaths(this.getExternalDirs(), type);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAndroidDataDirs() {
            return Environment.buildPaths(this.getExternalDirs(), "Android", "data");
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAndroidObbDirs() {
            return Environment.buildPaths(this.getExternalDirs(), "Android", "obb");
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppDataDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", "data", packageName);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppMediaDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", "media", packageName);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppObbDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", "obb", packageName);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppFilesDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", "data", packageName, "files");
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppCacheDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", "data", packageName, "cache");
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_Environment_UserEnvironment$__constructor__(n);
        }

        public UserEnvironment(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Environment_UserEnvironment$__constructor__(int ), 0, this, n);
        }

        public File[] getExternalDirs() {
            return InvokeDynamicSupport.bootstrap("getExternalDirs", $$robo$$android_os_Environment_UserEnvironment$getExternalDirs(), 0, this);
        }

        @Deprecated
        public File getExternalStorageDirectory() {
            return InvokeDynamicSupport.bootstrap("getExternalStorageDirectory", $$robo$$android_os_Environment_UserEnvironment$getExternalStorageDirectory(), 0, this);
        }

        @Deprecated
        public File getExternalStoragePublicDirectory(String string2) {
            return InvokeDynamicSupport.bootstrap("getExternalStoragePublicDirectory", $$robo$$android_os_Environment_UserEnvironment$getExternalStoragePublicDirectory(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStoragePublicDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStoragePublicDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStoragePublicDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAndroidDataDirs() {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAndroidDataDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAndroidDataDirs(), 0, this);
        }

        public File[] buildExternalStorageAndroidObbDirs() {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAndroidObbDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAndroidObbDirs(), 0, this);
        }

        public File[] buildExternalStorageAppDataDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppDataDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppDataDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppMediaDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppMediaDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppMediaDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppObbDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppObbDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppObbDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppFilesDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppFilesDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppFilesDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppCacheDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppCacheDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppCacheDirs(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ UserEnvironment() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserEnvironment)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

