/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.opengl.EGL14;
import android.os.SystemProperties;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.io.File;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class GraphicsEnvironment
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "GraphicsEnvironment";
    private static String PROPERTY_GFX_DRIVER = "ro.gfx.driver.0";

    private void $$robo$$android_os_GraphicsEnvironment$__constructor__() {
    }

    private static final void $$robo$$android_os_GraphicsEnvironment$setupGraphicsEnvironment(Context context) {
        GraphicsEnvironment.chooseDriver(context);
        Thread eglInitThread = new Thread(() -> EGL14.eglGetDisplay(0), "EGL Init");
        eglInitThread.start();
    }

    private static final void $$robo$$android_os_GraphicsEnvironment$chooseDriver(Context context) {
        ApplicationInfo driverInfo;
        String driverPackageName = SystemProperties.get("ro.gfx.driver.0");
        if (driverPackageName == null || driverPackageName.isEmpty()) {
            return;
        }
        ApplicationInfo ai = context.getApplicationInfo();
        if (ai.isPrivilegedApp() || ai.isSystemApp() && !ai.isUpdatedSystemApp()) {
            return;
        }
        try {
            driverInfo = context.getPackageManager().getApplicationInfo(driverPackageName, 0x100000);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("GraphicsEnvironment", "driver package '" + driverPackageName + "' not installed");
            return;
        }
        String abi = GraphicsEnvironment.chooseAbi(driverInfo);
        if (abi == null) {
            return;
        }
        if (driverInfo.targetSdkVersion < 26) {
            Log.w("GraphicsEnvironment", "updated driver package is not known to be compatible with O");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(driverInfo.nativeLibraryDir).append(File.pathSeparator);
        sb.append(driverInfo.sourceDir).append("!/lib/").append(abi);
        String paths = sb.toString();
        GraphicsEnvironment.setDriverPath(paths);
    }

    private static final String $$robo$$android_os_GraphicsEnvironment$chooseAbi(ApplicationInfo ai) {
        String isa = VMRuntime.getCurrentInstructionSet();
        if (ai.primaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.primaryCpuAbi))) {
            return ai.primaryCpuAbi;
        }
        if (ai.secondaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.secondaryCpuAbi))) {
            return ai.secondaryCpuAbi;
        }
        return null;
    }

    private static final void $$robo$$android_os_GraphicsEnvironment$setDriverPath(String string2) {
    }

    private void __constructor__() {
        this.$$robo$$android_os_GraphicsEnvironment$__constructor__();
    }

    public GraphicsEnvironment() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_GraphicsEnvironment$__constructor__(), 0, this);
    }

    public static void setupGraphicsEnvironment(Context context) {
        InvokeDynamicSupport.bootstrapStatic("setupGraphicsEnvironment", $$robo$$android_os_GraphicsEnvironment$setupGraphicsEnvironment(android.content.Context ), 0, (Context)context);
    }

    private static void chooseDriver(Context context) {
        InvokeDynamicSupport.bootstrapStatic("chooseDriver", $$robo$$android_os_GraphicsEnvironment$chooseDriver(android.content.Context ), 0, (Context)context);
    }

    private static String chooseAbi(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrapStatic("chooseAbi", $$robo$$android_os_GraphicsEnvironment$chooseAbi(android.content.pm.ApplicationInfo ), 0, (ApplicationInfo)applicationInfo);
    }

    private static final native /* synthetic */ void $$robo$$setDriverPath$nativeBinding(String var0);

    private static void setDriverPath(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setDriverPath", $$robo$$android_os_GraphicsEnvironment$setDriverPath(java.lang.String ), 1, (String)string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GraphicsEnvironment)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

