/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.DebugUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import java.io.CharArrayWriter;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DiskInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String ACTION_DISK_SCANNED = "android.os.storage.action.DISK_SCANNED";
    public static String EXTRA_DISK_ID = "android.os.storage.extra.DISK_ID";
    public static String EXTRA_VOLUME_COUNT = "android.os.storage.extra.VOLUME_COUNT";
    public static int FLAG_ADOPTABLE = 1;
    public static int FLAG_DEFAULT_PRIMARY = 2;
    public static int FLAG_SD = 4;
    public static int FLAG_USB = 8;
    public String id;
    public int flags;
    public long size;
    public String label;
    public int volumeCount;
    public String sysPath;
    public static Parcelable.Creator<DiskInfo> CREATOR;

    private void $$robo$$android_os_storage_DiskInfo$__constructor__(String id2, int flags) {
        this.id = Preconditions.checkNotNull(id2);
        this.flags = flags;
    }

    private void $$robo$$android_os_storage_DiskInfo$__constructor__(Parcel parcel) {
        this.id = parcel.readString();
        this.flags = parcel.readInt();
        this.size = parcel.readLong();
        this.label = parcel.readString();
        this.volumeCount = parcel.readInt();
        this.sysPath = parcel.readString();
    }

    private final String $$robo$$android_os_storage_DiskInfo$getId() {
        return this.id;
    }

    private final boolean $$robo$$android_os_storage_DiskInfo$isInteresting(String label) {
        if (TextUtils.isEmpty(label)) {
            return false;
        }
        if (label.equalsIgnoreCase("ata")) {
            return false;
        }
        if (label.toLowerCase().contains("generic")) {
            return false;
        }
        if (label.toLowerCase().startsWith("usb")) {
            return false;
        }
        return !label.toLowerCase().startsWith("multiple");
    }

    private final String $$robo$$android_os_storage_DiskInfo$getDescription() {
        Resources res = Resources.getSystem();
        if ((this.flags & 4) != 0) {
            if (this.isInteresting(this.label)) {
                return res.getString(17040853, this.label);
            }
            return res.getString(17040852);
        }
        if ((this.flags & 8) != 0) {
            if (this.isInteresting(this.label)) {
                return res.getString(17040856, this.label);
            }
            return res.getString(17040855);
        }
        return null;
    }

    private final boolean $$robo$$android_os_storage_DiskInfo$isAdoptable() {
        return (this.flags & 1) != 0;
    }

    private final boolean $$robo$$android_os_storage_DiskInfo$isDefaultPrimary() {
        return (this.flags & 2) != 0;
    }

    private final boolean $$robo$$android_os_storage_DiskInfo$isSd() {
        return (this.flags & 4) != 0;
    }

    private final boolean $$robo$$android_os_storage_DiskInfo$isUsb() {
        return (this.flags & 8) != 0;
    }

    private final String $$robo$$android_os_storage_DiskInfo$toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump(new IndentingPrintWriter(writer, "    ", 80));
        return writer.toString();
    }

    private final void $$robo$$android_os_storage_DiskInfo$dump(IndentingPrintWriter pw) {
        pw.println("DiskInfo{" + this.id + "}:");
        pw.increaseIndent();
        pw.printPair("flags", DebugUtils.flagsToString(this.getClass(), "FLAG_", this.flags));
        pw.printPair("size", this.size);
        pw.printPair("label", this.label);
        pw.println();
        pw.printPair("sysPath", this.sysPath);
        pw.decreaseIndent();
        pw.println();
    }

    private final DiskInfo $$robo$$android_os_storage_DiskInfo$clone() {
        Parcel temp = Parcel.obtain();
        try {
            this.writeToParcel(temp, 0);
            temp.setDataPosition(0);
            DiskInfo diskInfo = CREATOR.createFromParcel(temp);
            return diskInfo;
        }
        finally {
            temp.recycle();
        }
    }

    private final boolean $$robo$$android_os_storage_DiskInfo$equals(Object o) {
        if (o instanceof DiskInfo) {
            return Objects.equals(this.id, ((DiskInfo)o).id);
        }
        return false;
    }

    private final int $$robo$$android_os_storage_DiskInfo$hashCode() {
        return this.id.hashCode();
    }

    private final int $$robo$$android_os_storage_DiskInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_os_storage_DiskInfo$writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.id);
        parcel.writeInt(this.flags);
        parcel.writeLong(this.size);
        parcel.writeString(this.label);
        parcel.writeInt(this.volumeCount);
        parcel.writeString(this.sysPath);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<DiskInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_storage_DiskInfo_1$__constructor__() {
            }

            private final DiskInfo $$robo$$android_os_storage_DiskInfo_1$createFromParcel(Parcel in) {
                return new DiskInfo(in);
            }

            private final DiskInfo[] $$robo$$android_os_storage_DiskInfo_1$newArray(int size) {
                return new DiskInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_storage_DiskInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_DiskInfo_1$__constructor__(), 0, this);
            }

            @Override
            public DiskInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_storage_DiskInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public DiskInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_storage_DiskInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, int n) {
        this.$$robo$$android_os_storage_DiskInfo$__constructor__(string2, n);
    }

    public DiskInfo(String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_DiskInfo$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_os_storage_DiskInfo$__constructor__(parcel);
    }

    public DiskInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_DiskInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_os_storage_DiskInfo$getId(), 0, this);
    }

    private boolean isInteresting(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isInteresting", $$robo$$android_os_storage_DiskInfo$isInteresting(java.lang.String ), 0, this, string2);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_os_storage_DiskInfo$getDescription(), 0, this);
    }

    public boolean isAdoptable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAdoptable", $$robo$$android_os_storage_DiskInfo$isAdoptable(), 0, this);
    }

    public boolean isDefaultPrimary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultPrimary", $$robo$$android_os_storage_DiskInfo$isDefaultPrimary(), 0, this);
    }

    public boolean isSd() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSd", $$robo$$android_os_storage_DiskInfo$isSd(), 0, this);
    }

    public boolean isUsb() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsb", $$robo$$android_os_storage_DiskInfo$isUsb(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_storage_DiskInfo$toString(), 0, this);
    }

    public void dump(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_storage_DiskInfo$dump(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
    }

    public DiskInfo clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_os_storage_DiskInfo$clone(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_storage_DiskInfo$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_storage_DiskInfo$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_storage_DiskInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_storage_DiskInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(DiskInfo.class);
    }

    public /* synthetic */ DiskInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DiskInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

